/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.element;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.util.GsonHelper;
import net.rocketplatform.game.client.mod.ui.repository.LayoutParser;
import net.rocketplatform.game.client.mod.ui.template.callback.CallbackHolder;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import net.rocketplatform.game.client.mod.ui.widget.UnrenderedWidget;
import net.rocketplatform.game.client.mod.util.GuiUtils;
import net.rocketplatform.game.client.mod.util.function.IntBiConsumer;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public abstract class ElementTemplate<T>
implements CallbackHolder {
    private static Map<String, List<ElementTemplate<?>>> standaloneElements;
    private String type;
    private String id;
    private Position position;
    private ElementCallback callback;
    protected Map<String, Object> options;
    @SerializedName(value="required_display_variable")
    protected String requiredDisplayVariable;

    public ElementTemplate(String type, String id, Position position, ElementCallback callback) {
        this.type = type;
        this.id = id;
        this.position = position;
        this.callback = callback;
    }

    public String getType() {
        return this.type;
    }

    public Position getPosition() {
        return this.position;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ElementCallback getCallback() {
        return this.callback;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    @Nullable
    public String getRequiredDisplayVariable() {
        return this.requiredDisplayVariable;
    }

    @Nullable
    public <V> V getOption(String key) {
        return (V)(this.options == null ? null : this.options.get(key));
    }

    public <V> V getOptionOrThrow(String key) {
        V value = this.getOption(key);
        if (value == null) {
            throw new IllegalArgumentException("Option " + key + " is required for " + this.getType() + " element");
        }
        return value;
    }

    public <V> V getOption(String key, @Nullable V defaultValue) {
        Object value = this.getOption(key);
        if (value instanceof Number) {
            Number number = (Number)value;
            if (defaultValue instanceof Number) {
                switch (defaultValue.getClass().getSimpleName()) {
                    case "Byte": {
                        value = number.byteValue();
                        break;
                    }
                    case "Short": {
                        value = number.shortValue();
                        break;
                    }
                    case "Integer": {
                        value = number.intValue();
                        break;
                    }
                    case "Long": {
                        value = number.longValue();
                        break;
                    }
                    case "Float": {
                        value = Float.valueOf(number.floatValue());
                        break;
                    }
                    case "Double": {
                        value = number.doubleValue();
                    }
                }
                return value;
            }
        }
        return value == null ? defaultValue : value;
    }

    public Pivot getPivot() {
        String pivot = this.getPosition().pivot();
        if (pivot == null) {
            pivot = "center";
        }
        return Pivot.valueOf(pivot.toUpperCase(Locale.ROOT));
    }

    public final T createElement(TemplateScreen screen, int elementWidth, int elementHeight, int offsetX, int offsetY, VariableStorage variableStorage) {
        if (this.requiredDisplayVariable != null && !GuiUtils.shouldProcess(this.requiredDisplayVariable, variableStorage)) {
            return (T)((Object)new UnrenderedWidget(screen.getPanel()));
        }
        return this.createElement0(screen, elementWidth, elementHeight, offsetX, offsetY, variableStorage);
    }

    public abstract T createElement0(TemplateScreen var1, int var2, int var3, int var4, int var5, VariableStorage var6);

    @Nullable
    public static List<ElementTemplate<?>> createStandalone(String key) {
        if (standaloneElements == null) {
            return null;
        }
        return standaloneElements.get(key);
    }

    public static void loadStandalone(String json) {
        standaloneElements = (Map)GsonHelper.fromJson((Gson)LayoutParser.getGson(), (Reader)new StringReader(json), (TypeToken)new TypeToken<Map<String, List<ElementTemplate<?>>>>(){}, (boolean)true);
    }

    public static void loadStandalone(InputStream stream) {
        standaloneElements = (Map)GsonHelper.fromJson((Gson)LayoutParser.getGson(), (Reader)new InputStreamReader(stream), (TypeToken)new TypeToken<Map<String, List<ElementTemplate<?>>>>(){}, (boolean)true);
    }

    public record Position(int x, int y, String pivot) {
    }

    public static enum Pivot {
        CENTER,
        TOP_LEFT,
        TOP_CENTER,
        TOP_RIGHT,
        MIDDLE_LEFT,
        MIDDLE_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_CENTER,
        BOTTOM_RIGHT;


        public Vector2i apply(int elementWidth, int elementHeight, int width, int height) {
            Vector2i pos = new Vector2i();
            this.apply((arg_0, arg_1) -> ((Vector2i)pos).set(arg_0, arg_1), elementWidth, elementHeight, width, height);
            return pos;
        }

        public void apply(IntBiConsumer consumer, int elementWidth, int elementHeight, int width, int height) {
            switch (this.ordinal()) {
                case 0: {
                    consumer.accept(elementWidth / 2 - width / 2, elementHeight / 2 - height / 2);
                    break;
                }
                case 1: {
                    consumer.accept(0, 0);
                    break;
                }
                case 2: {
                    consumer.accept(elementWidth / 2 - width / 2, 0);
                    break;
                }
                case 3: {
                    consumer.accept(elementWidth - width, 0);
                    break;
                }
                case 4: {
                    consumer.accept(0, elementHeight / 2 - height / 2);
                    break;
                }
                case 5: {
                    consumer.accept(elementWidth - width, elementHeight / 2 - height / 2);
                    break;
                }
                case 6: {
                    consumer.accept(0, elementHeight - height);
                    break;
                }
                case 7: {
                    consumer.accept(elementWidth / 2 - width / 2, elementHeight - height);
                    break;
                }
                case 8: {
                    consumer.accept(elementWidth - width, elementHeight - height);
                }
            }
        }
    }
}

