/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.callback.type;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.client.RocketClientHandler;
import net.rocketplatform.game.client.mod.ui.template.callback.CallbackHolder;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.jetbrains.annotations.Nullable;

public class ManageBillingCallback
extends ElementCallback {
    private static final int CACHED_URL_EXPIRY = 120000;
    private static URI cachedUrl;
    private static long lastFetchTime;

    public ManageBillingCallback(String action) {
        super(action);
    }

    @Override
    public void onPress(TemplateScreen screen, @Nullable CallbackHolder holder, VariableStorage variableStorage) {
        if (cachedUrl != null && System.currentTimeMillis() - lastFetchTime < 120000L) {
            Util.getPlatform().openUri(cachedUrl);
            return;
        }
        ((CompletableFuture)RocketClientMod.getInstance().getClientHandler().thenCompose(RocketClientHandler::getCustomerPortalAddress)).whenComplete((response, e) -> {
            URI uri;
            if (e != null) {
                RocketClientMod.getLogger().error("Unable to manage billing: Failed to get customer portal address.", e);
                return;
            }
            if (response == null) {
                RocketClientMod.getLogger().error("Unable to manage billing: Failed to get customer portal address.");
                return;
            }
            cachedUrl = uri = URI.create(response.getUrl());
            lastFetchTime = System.currentTimeMillis();
            Util.getPlatform().openUri(uri);
        });
    }
}

