/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.loader;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.rocketplatform.client.generated.Modpack;
import net.rocketplatform.client.generated.ModpackAsset;
import net.rocketplatform.client.generated.ModpackLoadout;
import net.rocketplatform.client.generated.ModpackRegion;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.loader.ListEntryLoader;
import net.rocketplatform.game.client.mod.ui.loader.ModpackLoadoutEntryLoader;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.type.AbstractListLayoutTemplate;
import net.rocketplatform.game.client.mod.ui.variable.VariableProcessor;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class ModpackRegionEntryLoader
extends ListEntryLoader {
    @SerializedName(value="auto_load_loadouts")
    private boolean autoLoadLoadouts;

    public ModpackRegionEntryLoader(String type, AbstractListLayoutTemplate.ListEntry entryTemplate) {
        super(type, entryTemplate);
    }

    @Override
    public CompletableFuture<List<ListEntryLoader.ListEntryTemplate>> loadEntries(@Nullable VariableStorage storage) {
        AbstractListLayoutTemplate.ListEntry entryTemplate = this.getEntryTemplate();
        return ((CompletableFuture)RocketClientMod.getInstance().getClientHandler().thenCompose(client -> {
            if (this.autoLoadLoadouts) {
                String modpackId = RocketClientMod.getInstance().getModpackId();
                return client.getModpack(modpackId).thenCompose(pack -> client.getModpackRegions().thenApply(regions -> Pair.of((Object)pack, (Object)regions)));
            }
            return client.getModpackRegions().thenApply(regions -> Pair.of((Object)null, (Object)regions));
        })).thenApply(pair -> {
            Modpack modpack = (Modpack)pair.getKey();
            List regions = (List)pair.getValue();
            ArrayList<ListEntryLoader.ListEntryTemplate> entries = new ArrayList<ListEntryLoader.ListEntryTemplate>();
            for (ModpackRegion region : regions) {
                ModpackLoadout loadout;
                VariableStorage regionStorage = new VariableStorage();
                regionStorage.store("regionId", region.getRegionId());
                regionStorage.store("regionName", region.getDisplayName());
                regionStorage.store("regionPurchasable", region.getPurchasable());
                ModpackAsset asset = region.getIconAsset();
                regionStorage.store("regionAssetKey", asset.getAssetKey());
                regionStorage.store("regionAssetUrl", asset.getDownloadUrl());
                if (modpack != null && (loadout = (ModpackLoadout)modpack.getLoadouts().stream().filter(ModpackLoadout::getAutoSelect).findFirst().orElse(null)) != null) {
                    ModpackLoadoutEntryLoader.storeLoadout(regionStorage, loadout);
                }
                List<ElementTemplate<?>> elements = ModpackRegionEntryLoader.processElements(entryTemplate, regionStorage);
                AbstractListLayoutTemplate.ListEntry entry = new AbstractListLayoutTemplate.ListEntry(VariableProcessor.process(entryTemplate.getId(), regionStorage), elements, entryTemplate.requiredDoubleClickVariable(), entryTemplate.getCallback(), entryTemplate.selectedCallback());
                entries.add(new ListEntryLoader.ListEntryTemplate(entry, regionStorage));
            }
            return entries;
        });
    }

    public static CompletableFuture<List<ListEntryLoader.ListEntryTemplate>> convert(List<CompletableFuture<ListEntryLoader.ListEntryTemplate>> futures) {
        CompletableFuture<Void> allOf = CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
        return allOf.thenApply(v -> futures.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }
}

