/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.loader;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.rocketplatform.client.generated.InviteCode;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.loader.ListEntryLoader;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.type.AbstractListLayoutTemplate;
import net.rocketplatform.game.client.mod.ui.variable.VariableProcessor;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.jetbrains.annotations.Nullable;

public class InviteListEntryLoader
extends ListEntryLoader {
    public InviteListEntryLoader(String type, AbstractListLayoutTemplate.ListEntry entryTemplate) {
        super(type, entryTemplate);
    }

    @Override
    public CompletableFuture<List<ListEntryLoader.ListEntryTemplate>> loadEntries(@Nullable VariableStorage storage) {
        AbstractListLayoutTemplate.ListEntry entryTemplate = this.getEntryTemplate();
        if (storage == null) {
            RocketClientMod.getLogger().warn("No storage provided for player list entry loader, so no entries will be loaded.");
            return CompletableFuture.completedFuture(List.of());
        }
        if (!storage.contains("gameServerId")) {
            RocketClientMod.getLogger().warn("No game server ID provided for player list entry loader, so no entries will be loaded.");
            return CompletableFuture.completedFuture(List.of());
        }
        String gameServerId = (String)storage.retrieve("gameServerId");
        return ((CompletableFuture)((CompletableFuture)RocketClientMod.getInstance().getClientHandler().thenCompose(client -> client.getInviteCodes(gameServerId))).thenApply(playerList -> {
            ArrayList<ListEntryLoader.ListEntryTemplate> entries = new ArrayList<ListEntryLoader.ListEntryTemplate>();
            for (InviteCode code : playerList.getInviteCodes()) {
                VariableStorage codeStorage = new VariableStorage();
                codeStorage.store("inviteCode", code.getCode());
                codeStorage.store("remainingUses", code.getUsesRemaining());
                if (code.getUsesRemaining() == 1) {
                    codeStorage.store("autoAcceptDisplay", "(Single Use)");
                } else {
                    codeStorage.store("autoAcceptDisplay", "");
                }
                List<ElementTemplate<?>> elements = InviteListEntryLoader.processElements(entryTemplate, codeStorage);
                AbstractListLayoutTemplate.ListEntry entry = new AbstractListLayoutTemplate.ListEntry(VariableProcessor.process(entryTemplate.getId(), codeStorage), elements, entryTemplate.requiredDoubleClickVariable(), entryTemplate.getCallback(), entryTemplate.selectedCallback());
                entries.add(new ListEntryLoader.ListEntryTemplate(entry, codeStorage));
            }
            return entries;
        })).exceptionally(e -> {
            RocketClientMod.getLogger().error("Failed to load invite codes", e);
            return List.of();
        });
    }
}

