/// <reference path="./internals/internal_*.d.ts" />
declare class BlockPos extends Vec3i {
    constructor(arg0: Vec3i_)
    constructor(arg0: number, arg1: number, arg2: number)
    mutable(): Internal.BlockPos$MutableBlockPos;
    above(): this;
    static offsetCodec(arg0: number): Internal.Codec<Vec3i>;
    getY(): number;
    static getY(arg0: number): number;
    static betweenClosed(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.Iterable<BlockPos>;
    toShortString(): string;
    static betweenClosedStream(arg0: BlockPos_, arg1: BlockPos_): Internal.Stream<BlockPos>;
    notify(): void;
    static "betweenClosedStream(net.minecraft.world.level.levelgen.structure.BoundingBox)"(arg0: Internal.BoundingBox_): Internal.Stream<BlockPos>;
    compareTo(arg0: any): number;
    east(arg0: number): Vec3i;
    static offset(arg0: number, arg1: number, arg2: number, arg3: number): number;
    asLong(): number;
    multiply(arg0: number): Vec3i;
    static spiralAround(arg0: BlockPos_, arg1: number, arg2: Internal.Direction_, arg3: Internal.Direction_): Internal.Iterable<Internal.BlockPos$MutableBlockPos>;
    closerThan(arg0: Vec3i_, arg1: number): boolean;
    below(arg0: number): this;
    "compareTo(net.minecraft.core.Vec3i)"(arg0: Vec3i_): number;
    west(): Vec3i;
    static betweenClosedStream(arg0: Internal.BoundingBox_): Internal.Stream<BlockPos>;
    relative(arg0: Internal.Direction_): this;
    static randomInCube(arg0: Internal.RandomSource_, arg1: number, arg2: BlockPos_, arg3: number): Internal.Iterable<BlockPos>;
    static breadthFirstTraversal(arg0: BlockPos_, arg1: number, arg2: number, arg3: Internal.BiConsumer_<BlockPos, Internal.Consumer<BlockPos>>, arg4: Internal.Predicate_<BlockPos>): number;
    "relative(net.minecraft.core.Direction$Axis,int)"(arg0: Internal.Direction$Axis_, arg1: number): this;
    static betweenClosed(arg0: BlockPos_, arg1: BlockPos_): Internal.Iterable<BlockPos>;
    distSqr(arg0: Vec3i_): number;
    "relative(net.minecraft.core.Direction,int)"(arg0: Internal.Direction_, arg1: number): this;
    subtract(arg0: Vec3i_): Vec3i;
    static offset(arg0: number, arg1: Internal.Direction_): number;
    getCenter(): Vec3d;
    wait(): void;
    static containing(arg0: Internal.Position_): BlockPos;
    cross(arg0: Vec3i_): this;
    "compareTo(java.lang.Object)"(arg0: any): number;
    distToCenterSqr(arg0: number, arg1: number, arg2: number): number;
    north(): Vec3i;
    getClass(): typeof any;
    distToCenterSqr(arg0: Internal.Position_): number;
    getX(): number;
    south(arg0: number): Vec3i;
    east(): this;
    static getX(arg0: number): number;
    static getZ(arg0: number): number;
    static findClosestMatch(arg0: BlockPos_, arg1: number, arg2: number, arg3: Internal.Predicate_<BlockPos>): Internal.Optional<BlockPos>;
    above(arg0: number): Vec3i;
    atY(arg0: number): this;
    west(arg0: number): Vec3i;
    wait(arg0: number, arg1: number): void;
    distToLowCornerSqr(arg0: number, arg1: number, arg2: number): number;
    rotate(arg0: Internal.Rotation_): this;
    static "betweenClosedStream(net.minecraft.world.phys.AABB)"(arg0: Internal.AABB_): Internal.Stream<BlockPos>;
    relative(arg0: Internal.Direction_, arg1: number): this;
    static betweenClosedStream(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.Stream<BlockPos>;
    getZ(): number;
    static randomBetweenClosed(arg0: Internal.RandomSource_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): Internal.Iterable<BlockPos>;
    offset(arg0: number, arg1: number, arg2: number): Vec3i;
    static withinManhattanStream(arg0: BlockPos_, arg1: number, arg2: number, arg3: number): Internal.Stream<BlockPos>;
    immutable(): this;
    toString(): string;
    north(arg0: number): Vec3i;
    static asLong(arg0: number, arg1: number, arg2: number): number;
    below(): Vec3i;
    notifyAll(): void;
    distManhattan(arg0: Vec3i_): number;
    static getFlatIndex(arg0: number): number;
    static of(arg0: number): BlockPos;
    get(arg0: Internal.Direction$Axis_): number;
    offset(arg0: Vec3i_): Vec3i;
    /**
     * @deprecated
    */
    static squareOutSouthEast(arg0: BlockPos_): Internal.Stream<BlockPos>;
    static withinManhattan(arg0: BlockPos_, arg1: number, arg2: number, arg3: number): Internal.Iterable<BlockPos>;
    south(): Vec3i;
    static containing(arg0: number, arg1: number, arg2: number): BlockPos;
    static betweenClosedStream(arg0: Internal.AABB_): Internal.Stream<BlockPos>;
    hashCode(): number;
    wait(arg0: number): void;
    relative(arg0: Internal.Direction$Axis_, arg1: number): this;
    compareTo(arg0: Vec3i_): number;
    equals(arg0: any): boolean;
    closerToCenterThan(arg0: Internal.Position_, arg1: number): boolean;
    get y(): number
    get center(): Vec3d
    get class(): typeof any
    get x(): number
    get z(): number
    static readonly PACKED_Y_LENGTH: (12) & (number);
    static readonly CODEC: Internal.Codec<BlockPos>;
    static readonly ZERO: (BlockPos) & (BlockPos);
}
type BlockPos_ = Vec3d_ | [number, number, number] | BlockPos;
declare interface BlockStatePredicate extends Internal.ReplacementMatch, Internal.Predicate<Internal.BlockState> {
    fromString(s: string): this;
    asRuleTest(): Internal.RuleTest;
    ruleTestOf(o: any): Internal.RuleTest;
    getBlockIds(): Internal.Set<ResourceLocation>;
    not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
    check(targetStates: Internal.List_<Internal.OreConfiguration$TargetBlockState>): boolean;
    abstract test(arg0: Internal.BlockState_): boolean;
    getBlockStates(): Internal.Collection<Internal.BlockState>;
    getBlocks(): Internal.Collection<Internal.Block>;
    isEqual<T>(arg0: any): Internal.Predicate<T>;
    testBlock(block: Internal.Block_): boolean;
    of(o: BlockStatePredicate_): this;
    test(arg0: any): boolean;
    and(arg0: Internal.Predicate_<Internal.BlockState>): Internal.Predicate<Internal.BlockState>;
    abstract "test(net.minecraft.world.level.block.state.BlockState)"(arg0: Internal.BlockState_): boolean;
    or(arg0: Internal.Predicate_<Internal.BlockState>): Internal.Predicate<Internal.BlockState>;
    negate(): Internal.Predicate<Internal.BlockState>;
    "test(java.lang.Object)"(arg0: any): boolean;
    get blockIds(): Internal.Set<ResourceLocation>
    get blockStates(): Internal.Collection<Internal.BlockState>
    get blocks(): Internal.Collection<Internal.Block>
    readonly AIR_ID: (ResourceLocation) & (ResourceLocation);
}
type BlockStatePredicate_ = RegExp | "-" | `#${Special.BlockTag}` | BlockStatePredicate_[] | Internal.Block_ | Internal.BlockState_ | "*" | BlockStatePredicate | {not?: BlockStatePredicate_, or?: BlockStatePredicate_};
declare const BlockStatePredicate: BlockStatePredicate;
/**
 * Various block related helper functions
*/
declare class Block {
    constructor()
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    static id(id: ResourceLocation_): Internal.BlockIDPredicate;
    static entity(id: ResourceLocation_): Internal.BlockEntityPredicate;
    /**
     * Gets a blocks id from the Block
    */
    static getId(block: Internal.Block_): ResourceLocation;
    /**
     * Get a map of direction name to Direction. Functionally identical to Direction.ALL
    */
    static getFacing(): Internal.Map<string, Internal.Direction>;
    notify(): void;
    static id(id: ResourceLocation_, properties: Internal.Map_<string, any>): Internal.BlockIDPredicate;
    wait(arg0: number, arg1: number): void;
    /**
     * Gets a list of all blocks with tags
    */
    static getTaggedIds(tag: ResourceLocation_): Internal.List<ResourceLocation>;
    hashCode(): number;
    /**
     * Gets a Block from a block id
    */
    static getBlock(id: ResourceLocation_): Internal.Block;
    wait(): void;
    wait(arg0: number): void;
    static custom(predicate: Internal.BlockPredicate_): Internal.BlockPredicate;
    /**
     * Gets a list of the classname of all registered blocks
    */
    static getTypeList(): Internal.List<string>;
    equals(arg0: any): boolean;
    get class(): typeof any
    /**
     * Get a map of direction name to Direction. Functionally identical to Direction.ALL
    */
    get facing(): Internal.Map<string, Internal.Direction>
    /**
     * Gets a list of the classname of all registered blocks
    */
    get typeList(): Internal.List<string>
}
type Block_ = Block;
declare class Vec3d implements Internal.Position {
    constructor(arg0: number, arg1: number, arg2: number)
    constructor(arg0: Vec3f_)
    distanceToSqr(arg0: Vec3d_): number;
    lengthSqr(): number;
    notify(): void;
    yRot(arg0: number): this;
    z(): number;
    xRot(arg0: number): this;
    align(arg0: Internal.EnumSet_<Internal.Direction$Axis>): this;
    x(): number;
    closerThan(arg0: Internal.Position_, arg1: number): boolean;
    static atLowerCornerWithOffset(arg0: Vec3i_, arg1: number, arg2: number, arg3: number): Vec3d;
    subtract(arg0: Vec3d_): this;
    static upFromBottomCenterOf(arg0: Vec3i_, arg1: number): Vec3d;
    scale(arg0: number): this;
    reverse(): this;
    wait(): void;
    length(): number;
    distanceToSqr(arg0: number, arg1: number, arg2: number): number;
    zRot(arg0: number): this;
    subtract(arg0: number, arg1: number, arg2: number): this;
    lerp(arg0: Vec3d_, arg1: number): this;
    normalize(): this;
    horizontalDistance(): number;
    get(arg0: Internal.Direction$Axis_): number;
    getClass(): typeof any;
    relative(arg0: Internal.Direction_, arg1: number): this;
    add(arg0: number, arg1: number, arg2: number): this;
    static atCenterOf(arg0: Vec3i_): Vec3d;
    cross(arg0: Vec3d_): this;
    static directionFromRotation(arg0: Internal.Vec2_): Vec3d;
    add(arg0: Vec3d_): this;
    wait(arg0: number, arg1: number): void;
    "with"(arg0: Internal.Direction$Axis_, arg1: number): this;
    static atBottomCenterOf(arg0: Vec3i_): Vec3d;
    horizontalDistanceSqr(): number;
    dot(arg0: Vec3d_): number;
    multiply(arg0: number, arg1: number, arg2: number): this;
    y(): number;
    offsetRandom(arg0: Internal.RandomSource_, arg1: number): this;
    vectorTo(arg0: Vec3d_): this;
    toString(): string;
    static atLowerCornerOf(arg0: Vec3i_): Vec3d;
    notifyAll(): void;
    static fromRGB24(arg0: number): Vec3d;
    distanceTo(arg0: Vec3d_): number;
    multiply(arg0: Vec3d_): this;
    hashCode(): number;
    toVector3f(): Vec3f;
    wait(arg0: number): void;
    static directionFromRotation(arg0: number, arg1: number): Vec3d;
    equals(arg0: any): boolean;
    get class(): typeof any
    readonly z: number;
    static readonly ZERO: (Vec3d) & (Vec3d);
    static readonly CODEC: Internal.Codec<Vec3d>;
    readonly x: number;
    readonly y: number;
}
type Vec3d_ = [number, number, number] | Vec3d;
declare class KMath {
    constructor()
    getClass(): typeof any;
    static block(x: number, y: number, z: number): BlockPos;
    static deg(value: number): number;
    static v3d(x: number, y: number, z: number): Internal.Vector3d;
    static ceil(value: number): number;
    static map(value: number, min0: number, max0: number, min1: number, max1: number): number;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    static clamp(value: number, min: number, max: number): number;
    static v4f(x: number, y: number, z: number, w: number): Vec4f;
    static rad(value: number): number;
    static degreesDifference(current: number, target: number): number;
    static floor(value: number): number;
    static lerp(value: number, min: number, max: number): number;
    static v3f(x: number, y: number, z: number): Vec3f;
    toString(): string;
    notifyAll(): void;
    static rotateIfNecessary(current: number, target: number, max: number): number;
    static m4f(): Matrix4f;
    static v3(x: number, y: number, z: number): Vec3d;
    static quaternion(x: number, y: number, z: number, w: number): Quaternionf;
    hashCode(): number;
    static wrapDegrees(d: number): number;
    static m3f(): Matrix3f;
    wait(): void;
    static approachDegrees(current: number, target: number, speed: number): number;
    static clampedLerp(value: number, min: number, max: number): number;
    wait(arg0: number): void;
    static approach(current: number, target: number, speed: number): number;
    equals(arg0: any): boolean;
    static isPowerOfTwo(value: number): boolean;
    get class(): typeof any
    static readonly PI: (3.141592653589793) & (number);
    static readonly RADIANS_TO_DEGREES: (57.29577951308232) & (number);
    static readonly DEGREES_TO_RADIANS: (0.017453292519943295) & (number);
    static readonly E: (2.718281828459045) & (number);
}
type KMath_ = KMath;
declare class RotationAxis extends Internal.Enum<RotationAxis> {
    deg(f: number): Quaternionf;
    static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    static valueOf(name: string): RotationAxis;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    compareTo(arg0: any): number;
    name(): string;
    static values(): RotationAxis[];
    hashCode(): number;
    rad(f: number): Quaternionf;
    getDeclaringClass(): typeof RotationAxis;
    ordinal(): number;
    wait(): void;
    "compareTo(dev.latvian.mods.kubejs.util.RotationAxis)"(arg0: RotationAxis_): number;
    wait(arg0: number): void;
    compareTo(arg0: RotationAxis_): number;
    "compareTo(java.lang.Object)"(arg0: any): number;
    equals(arg0: any): boolean;
    describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<RotationAxis>>;
    get class(): typeof any
    get declaringClass(): typeof RotationAxis
    static readonly XN: (RotationAxis) & (RotationAxis);
    static readonly ZP: (RotationAxis) & (RotationAxis);
    static readonly YN: (RotationAxis) & (RotationAxis);
    static readonly XP: (RotationAxis) & (RotationAxis);
    static readonly YP: (RotationAxis) & (RotationAxis);
    static readonly ZN: (RotationAxis) & (RotationAxis);
    readonly vec: Vec3f;
}
type RotationAxis_ = "yp" | "xp" | "yn" | "xn" | "zp" | RotationAxis | "zn";
declare class ResourceLocation implements Internal.ResourceLocationAccess, Internal.SpecialEquality, Internal.Comparable<ResourceLocation> {
    constructor(arg0: string, arg1: string)
    constructor(arg0: string)
    static isValidNamespace(arg0: string): boolean;
    getClass(): typeof any;
    compareTo(arg0: ResourceLocation_): number;
    toLanguageKey(arg0: string): string;
    static checkSpecialEquality(o: any, o1: any, shallow: boolean): boolean;
    static validNamespaceChar(arg0: string): boolean;
    static read(arg0: string): Internal.DataResult<ResourceLocation>;
    static isValidPath(arg0: string): boolean;
    toShortLanguageKey(): string;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    compareTo(arg0: any): number;
    setPath(arg0: string): void;
    static tryBuild(arg0: string, arg1: string): ResourceLocation;
    "withPath(java.lang.String)"(arg0: string): this;
    static isAllowedInResourceLocation(arg0: string): boolean;
    withPath(arg0: string): this;
    static tryParse(arg0: string): ResourceLocation;
    static validPathChar(arg0: string): boolean;
    toLanguageKey(arg0: string, arg1: string): string;
    toDebugFileName(): string;
    getPath(): string;
    getNamespace(): string;
    static of(arg0: string, arg1: string): ResourceLocation;
    compareNamespaced(arg0: ResourceLocation_): number;
    "compareTo(net.minecraft.resources.ResourceLocation)"(arg0: ResourceLocation_): number;
    toString(): string;
    withSuffix(arg0: string): this;
    notifyAll(): void;
    specialEquals(o: any, shallow: boolean): boolean;
    static read(arg0: Internal.StringReader_): ResourceLocation;
    toLanguageKey(): string;
    static isValidResourceLocation(arg0: string): boolean;
    "withPath(java.util.function.UnaryOperator)"(arg0: Internal.UnaryOperator_<string>): this;
    static "read(com.mojang.brigadier.StringReader)"(arg0: Internal.StringReader_): ResourceLocation;
    hashCode(): number;
    static "read(java.lang.String)"(arg0: string): Internal.DataResult<ResourceLocation>;
    setNamespace(arg0: string): void;
    wait(): void;
    withPath(arg0: Internal.UnaryOperator_<string>): this;
    wait(arg0: number): void;
    withPrefix(arg0: string): this;
    "compareTo(java.lang.Object)"(arg0: any): number;
    equals(arg0: any): boolean;
    get class(): typeof any
    set path(arg0: string)
    get path(): string
    get namespace(): string
    set namespace(arg0: string)
    static readonly REALMS_NAMESPACE: ("realms") & (string);
    static readonly CODEC: Internal.Codec<ResourceLocation>;
    static readonly NAMESPACE_SEPARATOR: (":") & (string);
    static readonly DEFAULT_NAMESPACE: ("minecraft") & (string);
}
type ResourceLocation_ = string | ResourceLocation | Special.CustomStat;
declare class Items {
    constructor()
    getClass(): typeof any;
    toString(): string;
    static registerBlock(arg0: Internal.Block_, ...arg1: Internal.Block_[]): Internal.Item;
    notifyAll(): void;
    static "registerItem(net.minecraft.resources.ResourceKey,net.minecraft.world.item.Item)"(arg0: Internal.ResourceKey_<Internal.Item>, arg1: Internal.Item_): Internal.Item;
    static "registerItem(net.minecraft.resources.ResourceLocation,net.minecraft.world.item.Item)"(arg0: ResourceLocation_, arg1: Internal.Item_): Internal.Item;
    static registerBlock(arg0: Internal.Block_): Internal.Item;
    static "registerBlock(net.minecraft.world.item.BlockItem)"(arg0: Internal.BlockItem_): Internal.Item;
    static "registerBlock(net.minecraft.world.level.block.Block,net.minecraft.world.item.Item)"(arg0: Internal.Block_, arg1: Internal.Item_): Internal.Item;
    static registerItem(arg0: Internal.ResourceKey_<Internal.Item>, arg1: Internal.Item_): Internal.Item;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    hashCode(): number;
    static "registerBlock(net.minecraft.world.level.block.Block)"(arg0: Internal.Block_): Internal.Item;
    static registerItem(arg0: ResourceLocation_, arg1: Internal.Item_): Internal.Item;
    static "registerItem(java.lang.String,net.minecraft.world.item.Item)"(arg0: string, arg1: Internal.Item_): Internal.Item;
    wait(): void;
    static registerBlock(arg0: Internal.Block_, arg1: Internal.Item_): Internal.Item;
    wait(arg0: number): void;
    static registerItem(arg0: string, arg1: Internal.Item_): Internal.Item;
    equals(arg0: any): boolean;
    static registerBlock(arg0: Internal.BlockItem_): Internal.Item;
    static "registerBlock(net.minecraft.world.level.block.Block,net.minecraft.world.level.block.Block[])"(arg0: Internal.Block_, ...arg1: Internal.Block_[]): Internal.Item;
    get class(): typeof any
    static POWERED_RAIL: (Internal.BlockItem) & (Internal.Item);
    static GUARDIAN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static QUARTZ: (Internal.Item) & (Internal.Item);
    static TUBE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static TURTLE_EGG: (Internal.BlockItem) & (Internal.Item);
    static HANGING_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static CYAN_DYE: (Internal.DyeItem) & (Internal.Item);
    static WAXED_WEATHERED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CRACKED_DEEPSLATE_TILES: (Internal.BlockItem) & (Internal.Item);
    static OAK_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static BLAZE_ROD: (Internal.Item) & (Internal.Item);
    static GRASS_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static DRIED_KELP: (Internal.Item) & (Internal.Item);
    static TURTLE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GRAY_BANNER: (Internal.BannerItem) & (Internal.Item);
    static MAGENTA_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static WARPED_FUNGUS: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static BEETROOT: (Internal.Item) & (Internal.Item);
    static LIGHT_GRAY_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static GRAY_BED: (Internal.BedItem) & (Internal.Item);
    static MUDDY_MANGROVE_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static OAK_SIGN: (Internal.SignItem) & (Internal.Item);
    static ACACIA_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CHAIN: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_DYE: (Internal.DyeItem) & (Internal.Item);
    static STRIPPED_SPRUCE_LOG: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static PURPUR_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static DEBUG_STICK: (Internal.DebugStickItem) & (Internal.Item);
    static DUNE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static MUSIC_DISC_CAT: (Internal.RecordItem) & (Internal.Item);
    static GOLDEN_SWORD: (Internal.SwordItem) & (Internal.Item);
    static VERDANT_FROGLIGHT: (Internal.BlockItem) & (Internal.Item);
    static WARPED_NYLIUM: (Internal.BlockItem) & (Internal.Item);
    static TIPPED_ARROW: (Internal.TippedArrowItem) & (Internal.Item);
    static MILK_BUCKET: (Internal.MilkBucketItem) & (Internal.Item);
    static LAPIS_ORE: (Internal.BlockItem) & (Internal.Item);
    static WEEPING_VINES: (Internal.BlockItem) & (Internal.Item);
    static BLAZE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static TORCHFLOWER: (Internal.BlockItem) & (Internal.Item);
    static LODESTONE: (Internal.BlockItem) & (Internal.Item);
    static IRON_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static MANGROVE_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static INFESTED_STONE: (Internal.BlockItem) & (Internal.Item);
    static OAK_LOG: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_QUARTZ: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BRUSH: (Internal.BrushItem) & (Internal.Item);
    static END_PORTAL_FRAME: (Internal.BlockItem) & (Internal.Item);
    static AZURE_BLUET: (Internal.BlockItem) & (Internal.Item);
    static NETHER_QUARTZ_ORE: (Internal.BlockItem) & (Internal.Item);
    static COBBLESTONE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static SPRUCE_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static PUMPKIN: (Internal.BlockItem) & (Internal.Item);
    static COBWEB: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_WOOD: (Internal.BlockItem) & (Internal.Item);
    static BLUE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static CARROT: (Internal.ItemNameBlockItem) & (Internal.Item);
    static GOLDEN_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static BLACKSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static SUNFLOWER: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static COPPER_ORE: (Internal.BlockItem) & (Internal.Item);
    static CHEST: (Internal.BlockItem) & (Internal.Item);
    static DEAD_HORN_CORAL: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_GRANITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static SKELETON_SKULL: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static RESPAWN_ANCHOR: (Internal.BlockItem) & (Internal.Item);
    static BUCKET: (Internal.BucketItem) & (Internal.Item);
    static ZOMBIFIED_PIGLIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GLASS: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static FIRE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static LAVA_BUCKET: (Internal.BucketItem) & (Internal.Item);
    static ENDER_PEARL: (Internal.EnderpearlItem) & (Internal.Item);
    static DRIED_KELP_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static WILD_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static JUNGLE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BOOKSHELF: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static COBBLESTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static TWISTING_VINES: (Internal.BlockItem) & (Internal.Item);
    static GRINDSTONE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static PHANTOM_MEMBRANE: (Internal.Item) & (Internal.Item);
    static BRICK: (Internal.Item) & (Internal.Item);
    static ARCHER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static JUNGLE_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static TINTED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static OAK_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static GOLD_ORE: (Internal.BlockItem) & (Internal.Item);
    static FLOWERING_AZALEA: (Internal.BlockItem) & (Internal.Item);
    static POPPED_CHORUS_FRUIT: (Internal.Item) & (Internal.Item);
    static PRISMARINE_CRYSTALS: (Internal.Item) & (Internal.Item);
    static LAPIS_LAZULI: (Internal.Item) & (Internal.Item);
    static SQUID_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_INGOT: (Internal.Item) & (Internal.Item);
    static DEEPSLATE_EMERALD_ORE: (Internal.BlockItem) & (Internal.Item);
    static CHAINMAIL_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static NETHERITE_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static CHICKEN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BEEHIVE: (Internal.BlockItem) & (Internal.Item);
    static SPYGLASS: (Internal.SpyglassItem) & (Internal.Item);
    static NETHERITE_AXE: (Internal.AxeItem) & (Internal.Item);
    static ELDER_GUARDIAN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DARK_OAK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BLUE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static MULE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ORANGE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static FIREWORK_STAR: (Internal.FireworkStarItem) & (Internal.Item);
    static SPIDER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DARK_OAK_LOG: (Internal.BlockItem) & (Internal.Item);
    static SKULL_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static FROG_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DEAD_BRAIN_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static DIRT: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static WOODEN_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static GLOWSTONE_DUST: (Internal.Item) & (Internal.Item);
    static ITEM_FRAME: (Internal.ItemFrameItem) & (Internal.Item);
    static MUSIC_DISC_RELIC: (Internal.RecordItem) & (Internal.Item);
    static SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_FENCE: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_COBBLESTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static REDSTONE: (Internal.ItemNameBlockItem) & (Internal.Item);
    static CARROT_ON_A_STICK: Internal.Item;
    static SOUL_TORCH: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static LIME_CARPET: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static SUGAR_CANE: (Internal.BlockItem) & (Internal.Item);
    static COMMAND_BLOCK_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static SMOOTH_SANDSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CHEST_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static DEAD_BUBBLE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static SCUTE: (Internal.Item) & (Internal.Item);
    static FEATHER: (Internal.Item) & (Internal.Item);
    static JUNGLE_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static CUT_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_QUARTZ_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static WHITE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static COPPER_INGOT: (Internal.Item) & (Internal.Item);
    static SWEET_BERRIES: (Internal.ItemNameBlockItem) & (Internal.Item);
    static GREEN_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static BUBBLE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static BELL: (Internal.BlockItem) & (Internal.Item);
    static WAXED_EXPOSED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static WHITE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static PITCHER_POD: (Internal.ItemNameBlockItem) & (Internal.Item);
    static BLACK_DYE: (Internal.DyeItem) & (Internal.Item);
    static WHITE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static DETECTOR_RAIL: (Internal.BlockItem) & (Internal.Item);
    static TIDE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static LIME_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static PIGLIN_HEAD: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static CHORUS_FLOWER: (Internal.BlockItem) & (Internal.Item);
    static WARPED_HYPHAE: (Internal.BlockItem) & (Internal.Item);
    static WARDEN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CHISELED_NETHER_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static SNOWBALL: (Internal.SnowballItem) & (Internal.Item);
    static LANTERN: (Internal.BlockItem) & (Internal.Item);
    static CYAN_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static MAP: (Internal.EmptyMapItem) & (Internal.Item);
    static WHITE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_COPPER_ORE: (Internal.BlockItem) & (Internal.Item);
    static CUT_STANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BLACK_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static BLAST_FURNACE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static QUARTZ_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static CYAN_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static IRON_INGOT: (Internal.Item) & (Internal.Item);
    static PINK_BANNER: (Internal.BannerItem) & (Internal.Item);
    static MAGMA_CUBE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static WHITE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_RED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static TRADER_LLAMA_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static TNT: (Internal.BlockItem) & (Internal.Item);
    static OAK_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static CHERRY_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static GREEN_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_FENCE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_BANNER: (Internal.BannerItem) & (Internal.Item);
    static ROTTEN_FLESH: (Internal.Item) & (Internal.Item);
    static RIB_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WRITTEN_BOOK: (Internal.WrittenBookItem) & (Internal.Item);
    static DISC_FRAGMENT_5: (Internal.DiscFragmentItem) & (Internal.Item);
    static SNIFFER_EGG: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_DYE: (Internal.DyeItem) & (Internal.Item);
    static CLAY: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static BRAIN_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static SPAWNER: (Internal.BlockItem) & (Internal.Item);
    static LIME_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_SCRAP: (Internal.Item) & (Internal.Item);
    static NETHER_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static STONE: (Internal.BlockItem) & (Internal.Item);
    static WITHER_SKELETON_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static AMETHYST_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static HOGLIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ZOGLIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static LIME_DYE: (Internal.DyeItem) & (Internal.Item);
    static IRON_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static MAGENTA_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static PETRIFIED_OAK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PRISMARINE_SHARD: (Internal.Item) & (Internal.Item);
    static NETHER_GOLD_ORE: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BASALT: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static CHERRY_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static SANDSTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static ENDER_DRAGON_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static STRIPPED_OAK_LOG: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_GRANITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_GOLD_ORE: (Internal.BlockItem) & (Internal.Item);
    static OBSERVER: (Internal.BlockItem) & (Internal.Item);
    static GRAY_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_SWORD: (Internal.SwordItem) & (Internal.Item);
    static FOX_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CHERRY_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_WOOL: (Internal.BlockItem) & (Internal.Item);
    static CALCITE: (Internal.BlockItem) & (Internal.Item);
    static PUMPKIN_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static FERMENTED_SPIDER_EYE: (Internal.Item) & (Internal.Item);
    static HEART_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static PURPLE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static MUTTON: (Internal.Item) & (Internal.Item);
    static PURPLE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static GOLDEN_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static ZOMBIE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static MUSIC_DISC_PIGSTEP: (Internal.RecordItem) & (Internal.Item);
    static REDSTONE_TORCH: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static LEATHER_LEGGINGS: (Internal.DyeableArmorItem) & (Internal.Item);
    static PIGLIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static RED_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static COD: (Internal.Item) & (Internal.Item);
    static MUSIC_DISC_11: (Internal.RecordItem) & (Internal.Item);
    static AZALEA_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static NETHER_WART: (Internal.ItemNameBlockItem) & (Internal.Item);
    static NAME_TAG: (Internal.NameTagItem) & (Internal.Item);
    static CYAN_CARPET: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_COBBLESTONE: (Internal.BlockItem) & (Internal.Item);
    static NETHER_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static JACK_O_LANTERN: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static WARPED_SLAB: (Internal.BlockItem) & (Internal.Item);
    static FURNACE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RED_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_CARPET: (Internal.BlockItem) & (Internal.Item);
    static POWDER_SNOW_BUCKET: (Internal.SolidBucketItem) & (Internal.Item);
    static BUBBLE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static WHITE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static BOOK: (Internal.BookItem) & (Internal.Item);
    static RED_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static DARK_PRISMARINE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static CRIMSON_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_BED: (Internal.BedItem) & (Internal.Item);
    static EMERALD_ORE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static CRACKED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static COD_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DIAMOND: (Internal.Item) & (Internal.Item);
    static AZALEA: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_BOAT: (Internal.BoatItem) & (Internal.Item);
    static SPRUCE_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static MELON_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static WEATHERED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CANDLE: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static PILLAGER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static MUSIC_DISC_13: (Internal.RecordItem) & (Internal.Item);
    static LIGHT_GRAY_CARPET: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_WOOD: (Internal.BlockItem) & (Internal.Item);
    static FLOWER_POT: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_WOOD: (Internal.BlockItem) & (Internal.Item);
    static WARPED_FENCE: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_POLISHED_BLACKSTONE: (Internal.BlockItem) & (Internal.Item);
    static SEA_PICKLE: (Internal.BlockItem) & (Internal.Item);
    static LARGE_FERN: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static AMETHYST_SHARD: (Internal.Item) & (Internal.Item);
    static CHICKEN: (Internal.Item) & (Internal.Item);
    static GRAY_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static TOTEM_OF_UNDYING: (Internal.Item) & (Internal.Item);
    static STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static GREEN_BED: (Internal.BedItem) & (Internal.Item);
    static DROPPER: (Internal.BlockItem) & (Internal.Item);
    static LIME_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static KNOWLEDGE_BOOK: (Internal.KnowledgeBookItem) & (Internal.Item);
    static LOOM: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static FISHING_ROD: (Internal.FishingRodItem) & (Internal.Item);
    static BROWN_DYE: (Internal.DyeItem) & (Internal.Item);
    static MEDIUM_AMETHYST_BUD: (Internal.BlockItem) & (Internal.Item);
    static ROOTED_DIRT: (Internal.BlockItem) & (Internal.Item);
    static SHAPER_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static WARPED_STEM: (Internal.BlockItem) & (Internal.Item);
    static SHEAF_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static RED_SAND: (Internal.BlockItem) & (Internal.Item);
    static END_STONE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SHEARS: (Internal.ShearsItem) & (Internal.Item);
    static PANDA_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static POTATO: (Internal.ItemNameBlockItem) & (Internal.Item);
    static LAPIS_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static COMPOSTER: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static TROPICAL_FISH: (Internal.Item) & (Internal.Item);
    static POTION: (Internal.PotionItem) & (Internal.Item);
    static MANGROVE_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static JIGSAW: (Internal.GameMasterBlockItem) & (Internal.Item);
    static PRISMARINE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static TROPICAL_FISH_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static WARPED_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static RED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static BROWN_CARPET: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static LIGHT_BLUE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static LEATHER_CHESTPLATE: (Internal.DyeableArmorItem) & (Internal.Item);
    static RED_BED: (Internal.BedItem) & (Internal.Item);
    static STONE_HOE: (Internal.HoeItem) & (Internal.Item);
    static JUNGLE_LOG: (Internal.BlockItem) & (Internal.Item);
    static GLOW_SQUID_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static EYE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static BROWN_WOOL: (Internal.BlockItem) & (Internal.Item);
    static PUFFERFISH_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static CHAINMAIL_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static GREEN_WOOL: (Internal.BlockItem) & (Internal.Item);
    static BREAD: (Internal.Item) & (Internal.Item);
    static COOKED_CHICKEN: (Internal.Item) & (Internal.Item);
    static BIRCH_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_SLAB: (Internal.BlockItem) & (Internal.Item);
    static GOLD_NUGGET: (Internal.Item) & (Internal.Item);
    static PHANTOM_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static QUARTZ_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WHITE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static WAXED_WEATHERED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static BLUE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static WHEAT_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static DEEPSLATE_TILES: (Internal.BlockItem) & (Internal.Item);
    static PORKCHOP: (Internal.Item) & (Internal.Item);
    static SCAFFOLDING: (Internal.ScaffoldingBlockItem) & (Internal.Item);
    static END_ROD: (Internal.BlockItem) & (Internal.Item);
    static ANDESITE: (Internal.BlockItem) & (Internal.Item);
    static PACKED_MUD: (Internal.BlockItem) & (Internal.Item);
    static STONE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static REINFORCED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static LILY_OF_THE_VALLEY: (Internal.BlockItem) & (Internal.Item);
    static VILLAGER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static STONE_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static PARROT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static WHEAT: (Internal.Item) & (Internal.Item);
    static JUNGLE_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static BROWN_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DEEPSLATE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_AXE: (Internal.AxeItem) & (Internal.Item);
    static WAXED_WEATHERED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WARPED_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static NETHERRACK: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static GRAY_WOOL: (Internal.BlockItem) & (Internal.Item);
    static COPPER_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static WEATHERED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static PURPUR_PILLAR: (Internal.BlockItem) & (Internal.Item);
    static STONE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static RED_NETHER_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CAKE: (Internal.BlockItem) & (Internal.Item);
    static COBBLED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_FENCE: (Internal.BlockItem) & (Internal.Item);
    static FARMLAND: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static PUMPKIN_PIE: (Internal.Item) & (Internal.Item);
    static SHULKER_SHELL: (Internal.Item) & (Internal.Item);
    static OAK_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static RABBIT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static LIGHT_WEIGHTED_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static APPLE: (Internal.Item) & (Internal.Item);
    static DIAMOND_HORSE_ARMOR: (Internal.HorseArmorItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WARPED_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_LOG: (Internal.BlockItem) & (Internal.Item);
    static ELYTRA: (Internal.ElytraItem) & (Internal.Item);
    static WARPED_SIGN: (Internal.SignItem) & (Internal.Item);
    static GREEN_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static BEE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static PINK_DYE: (Internal.DyeItem) & (Internal.Item);
    static PLAYER_HEAD: (Internal.PlayerHeadItem) & (Internal.Item);
    static GLOW_LICHEN: (Internal.BlockItem) & (Internal.Item);
    static STONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static ROSE_BUSH: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static GLOW_ITEM_FRAME: (Internal.ItemFrameItem) & (Internal.Item);
    static WHITE_TULIP: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static OBSIDIAN: (Internal.BlockItem) & (Internal.Item);
    static BLADE_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static BROWN_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static EGG: (Internal.EggItem) & (Internal.Item);
    static WITCH_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static OXIDIZED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WAXED_EXPOSED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static OCELOT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static HORN_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static NETHER_SPROUTS: (Internal.BlockItem) & (Internal.Item);
    static MUD_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static DEAD_BRAIN_CORAL: (Internal.BlockItem) & (Internal.Item);
    static TALL_GRASS: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BLACK_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static SPIDER_EYE: (Internal.Item) & (Internal.Item);
    static FILLED_MAP: (Internal.MapItem) & (Internal.Item);
    static MUD_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static AXOLOTL_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static ZOMBIE_HORSE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DARK_PRISMARINE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_SIGN: (Internal.SignItem) & (Internal.Item);
    static STRIPPED_JUNGLE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static MUSHROOM_STEM: (Internal.BlockItem) & (Internal.Item);
    static LILAC: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BAMBOO_RAFT: (Internal.BoatItem) & (Internal.Item);
    static SUSPICIOUS_STEW: (Internal.SuspiciousStewItem) & (Internal.Item);
    static SUSPICIOUS_GRAVEL: (Internal.BlockItem) & (Internal.Item);
    static GOLDEN_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static IRON_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static WAXED_OXIDIZED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static CRACKED_DEEPSLATE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static SHULKER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SENTRY_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static LIGHT_GRAY_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static MELON_SLICE: (Internal.Item) & (Internal.Item);
    static HONEYCOMB_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DIORITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static PEARLESCENT_FROGLIGHT: (Internal.BlockItem) & (Internal.Item);
    static GOLDEN_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static ANCIENT_DEBRIS: (Internal.BlockItem) & (Internal.Item);
    static HOPPER_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static MAGMA_CREAM: (Internal.Item) & (Internal.Item);
    static ZOMBIE_HEAD: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static POLISHED_GRANITE: (Internal.BlockItem) & (Internal.Item);
    static PINK_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static HONEYCOMB: (Internal.HoneycombItem) & (Internal.Item);
    static NOTE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static RED_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static FURNACE_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static DRAGON_BREATH: (Internal.Item) & (Internal.Item);
    static CYAN_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static CHORUS_PLANT: (Internal.BlockItem) & (Internal.Item);
    static WAXED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static TURTLE_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static DARK_OAK_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static COAL_ORE: (Internal.BlockItem) & (Internal.Item);
    static COAL: (Internal.Item) & (Internal.Item);
    static COAST_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static GRAY_CARPET: (Internal.BlockItem) & (Internal.Item);
    static OXIDIZED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static DANGER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static GREEN_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static BARREL: (Internal.BlockItem) & (Internal.Item);
    static RED_SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WHITE_DYE: (Internal.DyeItem) & (Internal.Item);
    static ORANGE_DYE: (Internal.DyeItem) & (Internal.Item);
    static ENCHANTED_BOOK: (Internal.EnchantedBookItem) & (Internal.Item);
    static SOUL_SOIL: (Internal.BlockItem) & (Internal.Item);
    static IRON_NUGGET: (Internal.Item) & (Internal.Item);
    static ENDERMITE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static NETHERITE_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static LEVER: (Internal.BlockItem) & (Internal.Item);
    static COOKED_SALMON: (Internal.Item) & (Internal.Item);
    static CAULDRON: (Internal.Items$1) & (Internal.Item);
    static ALLIUM: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static EXPLORER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static POISONOUS_POTATO: (Internal.Item) & (Internal.Item);
    static FLOWER_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static SMOOTH_STONE: (Internal.BlockItem) & (Internal.Item);
    static WHITE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static SNORT_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static BROWN_MUSHROOM_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static GHAST_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static NETHER_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static IRON_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static AXOLOTL_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ORANGE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static SEA_LANTERN: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_RED_SANDSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static STONE_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static LIME_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static SHIELD: (Internal.ShieldItem) & (Internal.Item);
    static DIORITE_WALL: (Internal.BlockItem) & (Internal.Item);
    static STONE_SWORD: (Internal.SwordItem) & (Internal.Item);
    static GOLDEN_HOE: (Internal.HoeItem) & (Internal.Item);
    static BLACK_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_ORE: (Internal.BlockItem) & (Internal.Item);
    static BLACK_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_DYE: (Internal.DyeItem) & (Internal.Item);
    static REPEATER: (Internal.BlockItem) & (Internal.Item);
    static SPECTRAL_ARROW: (Internal.SpectralArrowItem) & (Internal.Item);
    static CHERRY_SLAB: (Internal.BlockItem) & (Internal.Item);
    static LEAD: (Internal.LeadItem) & (Internal.Item);
    static WHITE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static DEAD_TUBE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static BROWN_BANNER: (Internal.BannerItem) & (Internal.Item);
    static WAXED_OXIDIZED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static PINK_WOOL: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_BOAT: (Internal.BoatItem) & (Internal.Item);
    static BLACK_CARPET: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static BREWING_STAND: (Internal.BlockItem) & (Internal.Item);
    static BIG_DRIPLEAF: (Internal.Items$1) & (Internal.Item);
    static CARVED_PUMPKIN: (Internal.BlockItem) & (Internal.Item);
    static OAK_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static PINK_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DIORITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_BOAT: (Internal.BoatItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_WOOD: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_QUARTZ_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static END_STONE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_BED: (Internal.BedItem) & (Internal.Item);
    static LIGHT: (Internal.BlockItem) & (Internal.Item);
    static BONE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static DRIPSTONE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static WET_SPONGE: (Internal.BlockItem) & (Internal.Item);
    static FLINT: (Internal.Item) & (Internal.Item);
    static INFESTED_CHISELED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static GRAY_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_COBBLESTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static HUSK_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static PINK_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_ICE: (Internal.BlockItem) & (Internal.Item);
    static JUKEBOX: (Internal.BlockItem) & (Internal.Item);
    static FIRE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static FIRE_CHARGE: (Internal.FireChargeItem) & (Internal.Item);
    static COOKED_MUTTON: (Internal.Item) & (Internal.Item);
    static BASALT: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static PIG_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static MUSHROOM_STEW: (Internal.BowlFoodItem) & (Internal.Item);
    static PURPLE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static HOWL_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static SMALL_AMETHYST_BUD: (Internal.BlockItem) & (Internal.Item);
    static DEAD_HORN_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static WEATHERED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static RED_WOOL: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_PROPAGULE: (Internal.BlockItem) & (Internal.Item);
    static PURPUR_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static PAPER: (Internal.Item) & (Internal.Item);
    static IRON_HOE: (Internal.HoeItem) & (Internal.Item);
    static MAGENTA_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static STICKY_PISTON: (Internal.BlockItem) & (Internal.Item);
    static COMPASS: (Internal.CompassItem) & (Internal.Item);
    static RED_SANDSTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static DARK_PRISMARINE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_FENCE: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static CLAY_BALL: (Internal.Item) & (Internal.Item);
    static CYAN_WOOL: (Internal.BlockItem) & (Internal.Item);
    static STONECUTTER: (Internal.BlockItem) & (Internal.Item);
    static MINECART: (Internal.MinecartItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static RED_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static GREEN_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static SHELTER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static AIR: (Internal.AirItem) & (Internal.Item);
    static SEAGRASS: (Internal.BlockItem) & (Internal.Item);
    static GLOWSTONE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_BED: (Internal.BedItem) & (Internal.Item);
    static ANVIL: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static RAW_COPPER_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DIORITE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_SIGN: (Internal.SignItem) & (Internal.Item);
    static MAGENTA_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static NETHER_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static WITHER_SKELETON_SKULL: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static DONKEY_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static STONE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WARPED_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static WAXED_COPPER_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static ENCHANTED_GOLDEN_APPLE: (Internal.EnchantedGoldenAppleItem) & (Internal.Item);
    static MANGROVE_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static MUD: (Internal.BlockItem) & (Internal.Item);
    static OAK_FENCE: (Internal.BlockItem) & (Internal.Item);
    static GOAT_HORN: (Internal.InstrumentItem) & (Internal.Item);
    static HOST_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static CAVE_SPIDER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static QUARTZ_PILLAR: (Internal.BlockItem) & (Internal.Item);
    static DEAD_FIRE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static SUGAR: (Internal.Item) & (Internal.Item);
    static WAXED_EXPOSED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static BROWN_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static SCULK_VEIN: (Internal.BlockItem) & (Internal.Item);
    static FLETCHING_TABLE: (Internal.BlockItem) & (Internal.Item);
    static INFESTED_MOSSY_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static WARPED_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static BROWN_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static PINK_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static STONE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PLENTY_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static RED_CARPET: (Internal.BlockItem) & (Internal.Item);
    static CLOCK: (Internal.Item) & (Internal.Item);
    static GRAY_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static EMERALD: (Internal.Item) & (Internal.Item);
    static DEEPSLATE_DIAMOND_ORE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BROWN_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static KELP: (Internal.BlockItem) & (Internal.Item);
    static WITHER_ROSE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static TADPOLE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static OAK_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static SNOUT_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static SPRUCE_FENCE: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static CRAFTING_TABLE: (Internal.BlockItem) & (Internal.Item);
    static BAKED_POTATO: (Internal.Item) & (Internal.Item);
    static MANGROVE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CYAN_BED: (Internal.BedItem) & (Internal.Item);
    static CHISELED_BOOKSHELF: (Internal.BlockItem) & (Internal.Item);
    static NAUTILUS_SHELL: (Internal.Item) & (Internal.Item);
    static SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static STICK: (Internal.Item) & (Internal.Item);
    static HEAVY_WEIGHTED_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static COARSE_DIRT: (Internal.BlockItem) & (Internal.Item);
    static QUARTZ_SLAB: (Internal.BlockItem) & (Internal.Item);
    static SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static COBBLED_DEEPSLATE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static LIGHTNING_ROD: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_FENCE: (Internal.BlockItem) & (Internal.Item);
    static POLAR_BEAR_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ACACIA_LOG: (Internal.BlockItem) & (Internal.Item);
    static MOJANG_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static DEEPSLATE_REDSTONE_ORE: (Internal.BlockItem) & (Internal.Item);
    static INFESTED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static ENCHANTING_TABLE: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_ANDESITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static PINK_CARPET: (Internal.BlockItem) & (Internal.Item);
    static BREWER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static DIORITE: (Internal.BlockItem) & (Internal.Item);
    static RED_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static GRAY_DYE: (Internal.DyeItem) & (Internal.Item);
    static LIGHT_GRAY_BED: (Internal.BedItem) & (Internal.Item);
    static BAMBOO_SIGN: (Internal.SignItem) & (Internal.Item);
    static IRON_ORE: (Internal.BlockItem) & (Internal.Item);
    static SCULK_SENSOR: (Internal.BlockItem) & (Internal.Item);
    static BUNDLE: (Internal.BundleItem) & (Internal.Item);
    static STRING: (Internal.ItemNameBlockItem) & (Internal.Item);
    static STRIPPED_JUNGLE_LOG: (Internal.BlockItem) & (Internal.Item);
    static END_CRYSTAL: (Internal.EndCrystalItem) & (Internal.Item);
    static LEATHER_BOOTS: (Internal.DyeableArmorItem) & (Internal.Item);
    static SLIME_BALL: (Internal.Item) & (Internal.Item);
    static ORANGE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_IRON_ORE: (Internal.BlockItem) & (Internal.Item);
    static BOW: (Internal.BowItem) & (Internal.Item);
    static ORANGE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_ORCHID: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static LLAMA_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CAMPFIRE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static EXPOSED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BUBBLE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static RED_MUSHROOM: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BLACK_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static SAND: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_HOE: (Internal.HoeItem) & (Internal.Item);
    static RED_MUSHROOM_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static MYCELIUM: (Internal.BlockItem) & (Internal.Item);
    static PINK_TULIP: (Internal.BlockItem) & (Internal.Item);
    static PINK_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static GOAT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static INFESTED_CRACKED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static RABBIT: (Internal.Item) & (Internal.Item);
    static PRISMARINE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static REDSTONE_LAMP: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static TUBE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static MANGROVE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static LIME_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static STRIPPED_ACACIA_WOOD: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static ARMOR_STAND: (Internal.ArmorStandItem) & (Internal.Item);
    static CHERRY_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static BROWN_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static STONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static MANGROVE_BOAT: (Internal.BoatItem) & (Internal.Item);
    static PRISMARINE_WALL: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_BANNER: (Internal.BannerItem) & (Internal.Item);
    static RED_NETHER_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WAXED_OXIDIZED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static IRON_GOLEM_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CRIMSON_NYLIUM: (Internal.BlockItem) & (Internal.Item);
    static FIRE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static EXPERIENCE_BOTTLE: (Internal.ExperienceBottleItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static RED_NETHER_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static BLACK_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static SMITHING_TABLE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_SIGN: (Internal.SignItem) & (Internal.Item);
    static YELLOW_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static VEX_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static PIGLIN_BRUTE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GRAY_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static COBBLESTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BLAZE_POWDER: (Internal.Item) & (Internal.Item);
    static MUSIC_DISC_MALL: (Internal.RecordItem) & (Internal.Item);
    static LARGE_AMETHYST_BUD: (Internal.BlockItem) & (Internal.Item);
    static BRICKS: (Internal.BlockItem) & (Internal.Item);
    static BUDDING_AMETHYST: (Internal.BlockItem) & (Internal.Item);
    static RABBIT_FOOT: (Internal.Item) & (Internal.Item);
    static BAMBOO_MOSAIC: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_COBBLESTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SKULL_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static ACACIA_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static BURN_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static COMMAND_BLOCK: (Internal.GameMasterBlockItem) & (Internal.Item);
    static BEACON: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_SPRUCE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static OAK_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_CRIMSON_STEM: (Internal.BlockItem) & (Internal.Item);
    static GLOW_INK_SAC: (Internal.GlowInkSacItem) & (Internal.Item);
    static CYAN_BANNER: (Internal.BannerItem) & (Internal.Item);
    static CAMEL_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static POLISHED_BLACKSTONE: (Internal.BlockItem) & (Internal.Item);
    static GRASS: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_RED_SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BROWN_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_CHIRP: (Internal.RecordItem) & (Internal.Item);
    static MUSIC_DISC_FAR: (Internal.RecordItem) & (Internal.Item);
    static RED_SANDSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static COBBLED_DEEPSLATE_WALL: (Internal.BlockItem) & (Internal.Item);
    static BLUE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static WOODEN_AXE: (Internal.AxeItem) & (Internal.Item);
    static SPORE_BLOSSOM: (Internal.BlockItem) & (Internal.Item);
    static DEAD_BRAIN_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static DEEPSLATE_TILE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CROSSBOW: (Internal.CrossbowItem) & (Internal.Item);
    static BAMBOO_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static HORN_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static ORANGE_TULIP: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static GREEN_CARPET: (Internal.BlockItem) & (Internal.Item);
    static SILENCE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static OXIDIZED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static RABBIT_HIDE: (Internal.Item) & (Internal.Item);
    static COOKED_COD: (Internal.Item) & (Internal.Item);
    static BLACK_BED: (Internal.BedItem) & (Internal.Item);
    static PUFFERFISH: (Internal.Item) & (Internal.Item);
    static ENDER_EYE: (Internal.EnderEyeItem) & (Internal.Item);
    static INFESTED_COBBLESTONE: (Internal.BlockItem) & (Internal.Item);
    static GOLD_INGOT: (Internal.Item) & (Internal.Item);
    static VEX_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static STRIPPED_MANGROVE_LOG: (Internal.BlockItem) & (Internal.Item);
    static ICE: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_MOSAIC_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BLACK_BANNER: (Internal.BannerItem) & (Internal.Item);
    static OAK_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static LIME_BANNER: (Internal.BannerItem) & (Internal.Item);
    static PINK_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static SMALL_DRIPLEAF: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static LILY_PAD: (Internal.PlaceOnWaterBlockItem) & (Internal.Item);
    static CREEPER_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static GLOW_BERRIES: (Internal.ItemNameBlockItem) & (Internal.Item);
    static HOPPER: (Internal.BlockItem) & (Internal.Item);
    static PUFFERFISH_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static PURPLE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static HAY_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static HEART_OF_THE_SEA: (Internal.Item) & (Internal.Item);
    static WARD_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static MOSSY_STONE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static EXPOSED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WARPED_WART_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_SWORD: (Internal.SwordItem) & (Internal.Item);
    static SHEEP_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ANGLER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static PODZOL: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_HOE: (Internal.HoeItem) & (Internal.Item);
    static GRAY_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_WARPED_STEM: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_SIGN: (Internal.SignItem) & (Internal.Item);
    static RABBIT_STEW: (Internal.BowlFoodItem) & (Internal.Item);
    static DEAD_TUBE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static DECORATED_POT: (Internal.BlockItem) & (Internal.Item);
    static OAK_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static CHAINMAIL_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static CRACKED_POLISHED_BLACKSTONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static LIME_BED: (Internal.BedItem) & (Internal.Item);
    static TUFF: (Internal.BlockItem) & (Internal.Item);
    static GRAVEL: (Internal.BlockItem) & (Internal.Item);
    static BARRIER: (Internal.BlockItem) & (Internal.Item);
    static DRAGON_HEAD: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static MUSIC_DISC_MELLOHI: (Internal.RecordItem) & (Internal.Item);
    static IRON_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BAT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static VINDICATOR_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SMOOTH_BASALT: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static DEAD_HORN_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static DROWNED_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static NETHER_STAR: (Internal.SimpleFoiledItem) & (Internal.Item);
    static CRIMSON_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static FLINT_AND_STEEL: (Internal.FlintAndSteelItem) & (Internal.Item);
    static MAGENTA_BED: (Internal.BedItem) & (Internal.Item);
    static BONE: (Internal.Item) & (Internal.Item);
    static BROWN_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static END_STONE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CALIBRATED_SCULK_SENSOR: (Internal.BlockItem) & (Internal.Item);
    static COMPARATOR: (Internal.BlockItem) & (Internal.Item);
    static LEATHER_HORSE_ARMOR: (Internal.DyeableHorseArmorItem) & (Internal.Item);
    static STRIPPED_BAMBOO_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DIORITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MUD_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static MOSS_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CREEPER_HEAD: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static JUNGLE_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BLACK_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static COOKIE: (Internal.Item) & (Internal.Item);
    static GRANITE: (Internal.BlockItem) & (Internal.Item);
    static LEATHER: (Internal.Item) & (Internal.Item);
    static SALMON_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static DANDELION: (Internal.BlockItem) & (Internal.Item);
    static WARPED_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static PRISMARINE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RED_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static IRON_HORSE_ARMOR: (Internal.HorseArmorItem) & (Internal.Item);
    static IRON_SWORD: (Internal.SwordItem) & (Internal.Item);
    static BONE_MEAL: (Internal.BoneMealItem) & (Internal.Item);
    static GRAY_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static DEAD_FIRE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POINTED_DRIPSTONE: (Internal.BlockItem) & (Internal.Item);
    static PURPUR_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static ALLAY_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static COW_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ARMS_UP_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static BLUE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_WARD: (Internal.RecordItem) & (Internal.Item);
    static PINK_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static BLUE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static ANDESITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CHORUS_FRUIT: (Internal.ChorusFruitItem) & (Internal.Item);
    static VINE: (Internal.BlockItem) & (Internal.Item);
    static COAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DEEPSLATE_WALL: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_OTHERSIDE: (Internal.RecordItem) & (Internal.Item);
    static MOSSY_STONE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SNOW_GOLEM_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SCULK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_ANDESITE: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_SIGN: (Internal.SignItem) & (Internal.Item);
    static COCOA_BEANS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static CYAN_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_DYE: (Internal.DyeItem) & (Internal.Item);
    static CYAN_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static BLACKSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static GLOBE_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static SPRUCE_LOG: (Internal.BlockItem) & (Internal.Item);
    static TUBE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static EXPOSED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static GREEN_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static CONDUIT: (Internal.BlockItem) & (Internal.Item);
    static GLISTERING_MELON_SLICE: (Internal.Item) & (Internal.Item);
    static RAVAGER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SKELETON_HORSE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BRAIN_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO: (Internal.BlockItem) & (Internal.Item);
    static COOKED_PORKCHOP: (Internal.Item) & (Internal.Item);
    static GOLDEN_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static CUT_RED_SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static BAMBOO_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_STONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static IRON_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static SMOKER: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_BIRCH_WOOD: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_BOAT: (Internal.BoatItem) & (Internal.Item);
    static MOSS_CARPET: (Internal.BlockItem) & (Internal.Item);
    static FIREWORK_ROCKET: (Internal.FireworkRocketItem) & (Internal.Item);
    static OCHRE_FROGLIGHT: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static NETHER_BRICK_FENCE: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_RED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static TADPOLE_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static DRAGON_EGG: (Internal.BlockItem) & (Internal.Item);
    static PRIZE_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static DARK_OAK_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static COOKED_RABBIT: (Internal.Item) & (Internal.Item);
    static CHERRY_BOAT: (Internal.BoatItem) & (Internal.Item);
    static END_STONE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static GREEN_DYE: (Internal.DyeItem) & (Internal.Item);
    static MUSIC_DISC_WAIT: (Internal.RecordItem) & (Internal.Item);
    static RED_NETHER_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static PITCHER_PLANT: (Internal.BlockItem) & (Internal.Item);
    static LIME_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static PRISMARINE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static AMETHYST_CLUSTER: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_COAL_ORE: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_MANGROVE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static STONE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static RED_DYE: (Internal.DyeItem) & (Internal.Item);
    static SPLASH_POTION: (Internal.SplashPotionItem) & (Internal.Item);
    static PURPLE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static STRIDER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static OXEYE_DAISY: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PINK_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_CHERRY_WOOD: (Internal.BlockItem) & (Internal.Item);
    static REPEATING_COMMAND_BLOCK: (Internal.GameMasterBlockItem) & (Internal.Item);
    static CHERRY_SIGN: (Internal.SignItem) & (Internal.Item);
    static CRYING_OBSIDIAN: (Internal.BlockItem) & (Internal.Item);
    static RAISER_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static CREEPER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BAMBOO_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static SCULK_SHRIEKER: (Internal.BlockItem) & (Internal.Item);
    static GOLDEN_HORSE_ARMOR: (Internal.HorseArmorItem) & (Internal.Item);
    static POLISHED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_WOOL: (Internal.BlockItem) & (Internal.Item);
    static PINK_PETALS: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_DYE: (Internal.DyeItem) & (Internal.Item);
    static CRIMSON_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static PURPLE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static WITHER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BEETROOT_SOUP: (Internal.BowlFoodItem) & (Internal.Item);
    static CRIMSON_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static BLACKSTONE: (Internal.BlockItem) & (Internal.Item);
    static FLOWERING_AZALEA_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static OAK_BOAT: (Internal.BoatItem) & (Internal.Item);
    static POLISHED_ANDESITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BROWN_BED: (Internal.BedItem) & (Internal.Item);
    static BLUE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_CRIMSON_HYPHAE: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DEEPSLATE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static TARGET: (Internal.BlockItem) & (Internal.Item);
    static SOUL_SAND: (Internal.BlockItem) & (Internal.Item);
    static DAYLIGHT_DETECTOR: (Internal.BlockItem) & (Internal.Item);
    static MOOSHROOM_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static LIGHT_BLUE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static PRISMARINE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static DAMAGED_ANVIL: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static RAW_IRON_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static TROPICAL_FISH_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BAMBOO_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static INK_SAC: (Internal.InkSacItem) & (Internal.Item);
    static LINGERING_POTION: (Internal.LingeringPotionItem) & (Internal.Item);
    static BRAIN_CORAL: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static GILDED_BLACKSTONE: (Internal.BlockItem) & (Internal.Item);
    static PRISMARINE: (Internal.BlockItem) & (Internal.Item);
    static SOUL_CAMPFIRE: (Internal.BlockItem) & (Internal.Item);
    static LECTERN: (Internal.BlockItem) & (Internal.Item);
    static SHROOMLIGHT: (Internal.BlockItem) & (Internal.Item);
    static GOLD_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MUD_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_FENCE: (Internal.BlockItem) & (Internal.Item);
    static SNIFFER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CHERRY_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static PAINTING: (Internal.HangingEntityItem) & (Internal.Item);
    static MANGROVE_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static IRON_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static ARROW: (Internal.ArrowItem) & (Internal.Item);
    static DEAD_BUBBLE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_DARK_OAK_LOG: (Internal.BlockItem) & (Internal.Item);
    static WHITE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_STEM: (Internal.BlockItem) & (Internal.Item);
    static SOUL_LANTERN: (Internal.BlockItem) & (Internal.Item);
    static BLUE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static WRITABLE_BOOK: (Internal.WritableBookItem) & (Internal.Item);
    static PURPLE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static CUT_RED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static LIME_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static STRAY_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static STRIPPED_BIRCH_LOG: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_TILE_WALL: (Internal.BlockItem) & (Internal.Item);
    static SLIME_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static NETHER_WART_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_TILE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_MOSAIC_SLAB: (Internal.BlockItem) & (Internal.Item);
    static END_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static SKELETON_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CRIMSON_FENCE: (Internal.BlockItem) & (Internal.Item);
    static SUSPICIOUS_SAND: (Internal.BlockItem) & (Internal.Item);
    static CRACKED_NETHER_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static STRUCTURE_BLOCK: (Internal.GameMasterBlockItem) & (Internal.Item);
    static CAT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static IRON_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static STRIPPED_OAK_WOOD: (Internal.BlockItem) & (Internal.Item);
    static PISTON: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_UPGRADE_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static DEEPSLATE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static COD_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static HONEY_BOTTLE: (Internal.HoneyBottleItem) & (Internal.Item);
    static EXPOSED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_STRAD: (Internal.RecordItem) & (Internal.Item);
    static GREEN_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static PINK_BED: (Internal.BedItem) & (Internal.Item);
    static LADDER: (Internal.BlockItem) & (Internal.Item);
    static SCULK_CATALYST: (Internal.BlockItem) & (Internal.Item);
    static BLUE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static SNOW_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_CHEST_RAFT: (Internal.BoatItem) & (Internal.Item);
    static SALMON: (Internal.Item) & (Internal.Item);
    static DISPENSER: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static OAK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static RED_BANNER: (Internal.BannerItem) & (Internal.Item);
    static IRON_AXE: (Internal.AxeItem) & (Internal.Item);
    static DEEPSLATE_LAPIS_ORE: (Internal.BlockItem) & (Internal.Item);
    static SILVERFISH_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ENDERMAN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GOLDEN_AXE: (Internal.AxeItem) & (Internal.Item);
    static OAK_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static GRANITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CHARCOAL: (Internal.Item) & (Internal.Item);
    static WOODEN_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static MELON: (Internal.BlockItem) & (Internal.Item);
    static ECHO_SHARD: (Internal.Item) & (Internal.Item);
    static BAMBOO_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static DIRT_PATH: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static WAYFINDER_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static WHITE_BED: (Internal.BedItem) & (Internal.Item);
    static DIORITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static RECOVERY_COMPASS: (Internal.Item) & (Internal.Item);
    static SNOW: (Internal.BlockItem) & (Internal.Item);
    static GRAY_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static GHAST_TEAR: (Internal.Item) & (Internal.Item);
    static GOLDEN_CARROT: (Internal.Item) & (Internal.Item);
    static FERN: (Internal.BlockItem) & (Internal.Item);
    static CORNFLOWER: (Internal.BlockItem) & (Internal.Item);
    static CHAIN_COMMAND_BLOCK: (Internal.GameMasterBlockItem) & (Internal.Item);
    static ZOMBIE_VILLAGER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static LIME_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static GREEN_BANNER: (Internal.BannerItem) & (Internal.Item);
    static TRIPWIRE_HOOK: (Internal.BlockItem) & (Internal.Item);
    static EVOKER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SALMON_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DEEPSLATE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RAW_GOLD: (Internal.Item) & (Internal.Item);
    static BIRCH_SIGN: (Internal.SignItem) & (Internal.Item);
    static FROGSPAWN: (Internal.PlaceOnWaterBlockItem) & (Internal.Item);
    static SADDLE: (Internal.SaddleItem) & (Internal.Item);
    static YELLOW_WOOL: (Internal.BlockItem) & (Internal.Item);
    static TRIDENT: (Internal.TridentItem) & (Internal.Item);
    static LIGHT_BLUE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static WARPED_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static SLIME_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static OAK_WOOD: (Internal.BlockItem) & (Internal.Item);
    static ENDER_CHEST: (Internal.BlockItem) & (Internal.Item);
    static REDSTONE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_BED: (Internal.BedItem) & (Internal.Item);
    static CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WANDERING_TRADER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static WAXED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static WAXED_WEATHERED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static WAXED_OXIDIZED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static QUARTZ_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RAIL: (Internal.BlockItem) & (Internal.Item);
    static EMERALD_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static POPPY: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static ANDESITE_WALL: (Internal.BlockItem) & (Internal.Item);
    static LEATHER_HELMET: (Internal.DyeableArmorItem) & (Internal.Item);
    static ACACIA_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static CARTOGRAPHY_TABLE: (Internal.BlockItem) & (Internal.Item);
    static RED_TULIP: (Internal.BlockItem) & (Internal.Item);
    static TRAPPED_CHEST: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_LOG: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_LOG: (Internal.BlockItem) & (Internal.Item);
    static CHIPPED_ANVIL: (Internal.BlockItem) & (Internal.Item);
    static MAGMA_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static GUNPOWDER: (Internal.Item) & (Internal.Item);
    static OXIDIZED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static BLACK_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static BLUE_DYE: (Internal.DyeItem) & (Internal.Item);
    static PACKED_ICE: (Internal.BlockItem) & (Internal.Item);
    static PEONY: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static CRIMSON_FUNGUS: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static BEETROOT_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static IRON_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static GOLDEN_APPLE: (Internal.Item) & (Internal.Item);
    static LIGHT_BLUE_BED: (Internal.BedItem) & (Internal.Item);
    static WARPED_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static CACTUS: (Internal.BlockItem) & (Internal.Item);
    static TORCH: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static GLASS_BOTTLE: (Internal.BottleItem) & (Internal.Item);
    static MAGENTA_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static STRUCTURE_VOID: (Internal.BlockItem) & (Internal.Item);
    static DEAD_TUBE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static GREEN_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_BLOCKS: (Internal.RecordItem) & (Internal.Item);
    static COOKED_BEEF: (Internal.Item) & (Internal.Item);
    static DIAMOND_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static WOODEN_SWORD: (Internal.SwordItem) & (Internal.Item);
    static CRIMSON_SIGN: (Internal.SignItem) & (Internal.Item);
    static NETHER_BRICK: (Internal.Item) & (Internal.Item);
    static STONE_AXE: (Internal.AxeItem) & (Internal.Item);
    static DEAD_BUSH: (Internal.BlockItem) & (Internal.Item);
    static CYAN_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static DEEPSLATE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WHITE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static GRANITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_STONE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static OAK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static DEAD_BUBBLE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static WARPED_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static MINER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static BROWN_MUSHROOM: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static WOLF_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static MAGENTA_BANNER: (Internal.BannerItem) & (Internal.Item);
    static CYAN_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static WAXED_EXPOSED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static RAW_IRON: (Internal.Item) & (Internal.Item);
    static WEATHERED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_DARK_OAK_WOOD: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_FENCE: (Internal.BlockItem) & (Internal.Item);
    static INFESTED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static IRON_BARS: (Internal.BlockItem) & (Internal.Item);
    static SANDSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BEDROCK: (Internal.BlockItem) & (Internal.Item);
    static MOURNER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static STRIPPED_CHERRY_LOG: (Internal.BlockItem) & (Internal.Item);
    static TNT_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static BEE_NEST: (Internal.BlockItem) & (Internal.Item);
    static ACTIVATOR_RAIL: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_5: (Internal.RecordItem) & (Internal.Item);
    static DEAD_FIRE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static GOLDEN_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static STRIPPED_WARPED_HYPHAE: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_CARPET: (Internal.BlockItem) & (Internal.Item);
    static TORCHFLOWER_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static HONEY_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_ACACIA_LOG: (Internal.BlockItem) & (Internal.Item);
    static FRIEND_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static RAW_GOLD_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static WARPED_FUNGUS_ON_A_STICK: Internal.Item;
    static SMOOTH_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static DOLPHIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static NETHERITE_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static GRANITE_WALL: (Internal.BlockItem) & (Internal.Item);
    static BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static LIME_WOOL: (Internal.BlockItem) & (Internal.Item);
    static CHAINMAIL_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static WOODEN_HOE: (Internal.HoeItem) & (Internal.Item);
    static HORSE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static WATER_BUCKET: (Internal.BucketItem) & (Internal.Item);
    static SMOOTH_QUARTZ_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WAXED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static HORN_CORAL: (Internal.BlockItem) & (Internal.Item);
    static BLACKSTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_STAL: (Internal.RecordItem) & (Internal.Item);
    static SPONGE: (Internal.BlockItem) & (Internal.Item);
    static PIGLIN_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static RAW_COPPER: (Internal.Item) & (Internal.Item);
    static DARK_OAK_BOAT: (Internal.BoatItem) & (Internal.Item);
    static REDSTONE_ORE: (Internal.BlockItem) & (Internal.Item);
    static ANDESITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BOWL: (Internal.Item) & (Internal.Item);
    static BLACK_WOOL: (Internal.BlockItem) & (Internal.Item);
    static COBBLED_DEEPSLATE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BEEF: (Internal.Item) & (Internal.Item);
    static COBBLESTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CYAN_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static SPRUCE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static HEARTBREAK_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static CRIMSON_HYPHAE: (Internal.BlockItem) & (Internal.Item);
}
type Items_ = Items;
declare interface NBTIO {
    write(path: Internal.Path_, nbt: Internal.CompoundTag_): void;
    read(path: Internal.Path_): Internal.CompoundTag;
}
type NBTIO_ = NBTIO;
declare const NBTIO: NBTIO;
declare class SoundType {
    constructor(arg0: number, arg1: number, arg2: Internal.SoundEvent_, arg3: Internal.SoundEvent_, arg4: Internal.SoundEvent_, arg5: Internal.SoundEvent_, arg6: Internal.SoundEvent_)
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    getHitSound(): Internal.SoundEvent;
    getStepSound(): Internal.SoundEvent;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    getFallSound(): Internal.SoundEvent;
    getPlaceSound(): Internal.SoundEvent;
    getVolume(): number;
    hashCode(): number;
    getPitch(): number;
    wait(): void;
    wait(arg0: number): void;
    getBreakSound(): Internal.SoundEvent;
    equals(arg0: any): boolean;
    get class(): typeof any
    get hitSound(): Internal.SoundEvent
    get stepSound(): Internal.SoundEvent
    get fallSound(): Internal.SoundEvent
    get placeSound(): Internal.SoundEvent
    get volume(): number
    get pitch(): number
    get breakSound(): Internal.SoundEvent
    static readonly EMPTY: (SoundType) & (SoundType);
    static readonly SAND: (SoundType) & (SoundType);
    static readonly DECORATED_POT: (SoundType) & (SoundType);
    static readonly TUFF: (SoundType) & (SoundType);
    static readonly GRAVEL: (SoundType) & (SoundType);
    static readonly SHROOMLIGHT: (SoundType) & (SoundType);
    static readonly MOSS: (SoundType) & (SoundType);
    readonly pitch: number;
    static readonly GRASS: (SoundType) & (SoundType);
    static readonly SOUL_SOIL: (SoundType) & (SoundType);
    static readonly WEEPING_VINES: (SoundType) & (SoundType);
    static readonly ANCIENT_DEBRIS: (SoundType) & (SoundType);
    static readonly SCULK_SENSOR: (SoundType) & (SoundType);
    static readonly POINTED_DRIPSTONE: (SoundType) & (SoundType);
    static readonly ROOTED_DIRT: (SoundType) & (SoundType);
    static readonly FROGSPAWN: (SoundType) & (SoundType);
    static readonly NETHER_ORE: (SoundType) & (SoundType);
    static readonly COPPER: (SoundType) & (SoundType);
    static readonly LANTERN: (SoundType) & (SoundType);
    static readonly BONE_BLOCK: (SoundType) & (SoundType);
    static readonly FROGLIGHT: (SoundType) & (SoundType);
    static readonly SNOW: (SoundType) & (SoundType);
    static readonly SCULK_VEIN: (SoundType) & (SoundType);
    static readonly CHERRY_WOOD: (SoundType) & (SoundType);
    static readonly POLISHED_DEEPSLATE: (SoundType) & (SoundType);
    static readonly NYLIUM: (SoundType) & (SoundType);
    static readonly DEEPSLATE: (SoundType) & (SoundType);
    static readonly SPORE_BLOSSOM: (SoundType) & (SoundType);
    static readonly BASALT: (SoundType) & (SoundType);
    static readonly CHERRY_WOOD_HANGING_SIGN: (SoundType) & (SoundType);
    static readonly SMALL_AMETHYST_BUD: (SoundType) & (SoundType);
    static readonly CANDLE: (SoundType) & (SoundType);
    static readonly FLOWERING_AZALEA: (SoundType) & (SoundType);
    static readonly ANVIL: (SoundType) & (SoundType);
    static readonly SCAFFOLDING: (SoundType) & (SoundType);
    static readonly DEEPSLATE_BRICKS: (SoundType) & (SoundType);
    static readonly CORAL_BLOCK: (SoundType) & (SoundType);
    static readonly BAMBOO_SAPLING: (SoundType) & (SoundType);
    static readonly LILY_PAD: (SoundType) & (SoundType);
    static readonly MOSS_CARPET: (SoundType) & (SoundType);
    static readonly LADDER: (SoundType) & (SoundType);
    static readonly LARGE_AMETHYST_BUD: (SoundType) & (SoundType);
    static readonly GLOW_LICHEN: (SoundType) & (SoundType);
    static readonly CROP: (SoundType) & (SoundType);
    static readonly PINK_PETALS: (SoundType) & (SoundType);
    static readonly AZALEA_LEAVES: (SoundType) & (SoundType);
    static readonly POWDER_SNOW: (SoundType) & (SoundType);
    static readonly METAL: (SoundType) & (SoundType);
    static readonly HONEY_BLOCK: (SoundType) & (SoundType);
    static readonly NETHER_BRICKS: (SoundType) & (SoundType);
    static readonly SUSPICIOUS_SAND: (SoundType) & (SoundType);
    static readonly GILDED_BLACKSTONE: (SoundType) & (SoundType);
    static readonly HARD_CROP: (SoundType) & (SoundType);
    static readonly SCULK_CATALYST: (SoundType) & (SoundType);
    static readonly DEEPSLATE_TILES: (SoundType) & (SoundType);
    static readonly PACKED_MUD: (SoundType) & (SoundType);
    static readonly SCULK: (SoundType) & (SoundType);
    static readonly VINE: (SoundType) & (SoundType);
    static readonly BAMBOO: (SoundType) & (SoundType);
    static readonly GLASS: (SoundType) & (SoundType);
    static readonly DRIPSTONE_BLOCK: (SoundType) & (SoundType);
    static readonly CHERRY_SAPLING: (SoundType) & (SoundType);
    static readonly CALCITE: (SoundType) & (SoundType);
    static readonly MUD_BRICKS: (SoundType) & (SoundType);
    static readonly STEM: (SoundType) & (SoundType);
    static readonly BAMBOO_WOOD: (SoundType) & (SoundType);
    static readonly SOUL_SAND: (SoundType) & (SoundType);
    static readonly MUD: (SoundType) & (SoundType);
    static readonly BIG_DRIPLEAF: (SoundType) & (SoundType);
    static readonly BAMBOO_WOOD_HANGING_SIGN: (SoundType) & (SoundType);
    static readonly TWISTING_VINES: (SoundType) & (SoundType);
    static readonly NETHERRACK: (SoundType) & (SoundType);
    static readonly AMETHYST_CLUSTER: (SoundType) & (SoundType);
    static readonly SLIME_BLOCK: (SoundType) & (SoundType);
    static readonly SCULK_SHRIEKER: (SoundType) & (SoundType);
    static readonly CHAIN: (SoundType) & (SoundType);
    static readonly WOOD: (SoundType) & (SoundType);
    static readonly AZALEA: (SoundType) & (SoundType);
    static readonly MANGROVE_ROOTS: (SoundType) & (SoundType);
    static readonly CHISELED_BOOKSHELF: (SoundType) & (SoundType);
    static readonly NETHER_GOLD_ORE: (SoundType) & (SoundType);
    static readonly CHERRY_LEAVES: (SoundType) & (SoundType);
    static readonly AMETHYST: (SoundType) & (SoundType);
    static readonly DECORATED_POT_CRACKED: (SoundType) & (SoundType);
    static readonly CAVE_VINES: (SoundType) & (SoundType);
    static readonly SUSPICIOUS_GRAVEL: (SoundType) & (SoundType);
    static readonly LODESTONE: (SoundType) & (SoundType);
    readonly volume: number;
    static readonly FUNGUS: (SoundType) & (SoundType);
    static readonly SMALL_DRIPLEAF: (SoundType) & (SoundType);
    static readonly HANGING_ROOTS: (SoundType) & (SoundType);
    static readonly SWEET_BERRY_BUSH: (SoundType) & (SoundType);
    static readonly NETHER_WOOD: (SoundType) & (SoundType);
    static readonly NETHER_WART: (SoundType) & (SoundType);
    static readonly STONE: (SoundType) & (SoundType);
    static readonly NETHER_WOOD_HANGING_SIGN: (SoundType) & (SoundType);
    static readonly HANGING_SIGN: (SoundType) & (SoundType);
    static readonly WET_GRASS: (SoundType) & (SoundType);
    static readonly NETHERITE_BLOCK: (SoundType) & (SoundType);
    static readonly MEDIUM_AMETHYST_BUD: (SoundType) & (SoundType);
    static readonly MUDDY_MANGROVE_ROOTS: (SoundType) & (SoundType);
    static readonly WOOL: (SoundType) & (SoundType);
    static readonly ROOTS: (SoundType) & (SoundType);
    static readonly WART_BLOCK: (SoundType) & (SoundType);
    static readonly NETHER_SPROUTS: (SoundType) & (SoundType);
}
type SoundType_ = SoundType;
declare interface EntityJSUtils {
    /**
     * Creates a custom Move Control builder and returns it.
    */
    createMoveControl(pMob: Internal.Mob_, consumer: Internal.Consumer_<Internal.MoveControlJSBuilder>): Internal.MoveControlJS;
    /**
     * Wall climbing entity path navigation
    */
    createWallClimberNavigation(pMob: Internal.Mob_, pLevel: Internal.Level_): Internal.WallClimberNavigation;
    /**
     * Creates a custom Jump Control builder and returns it.
    */
    createJumpControl(pMob: Internal.Mob_, consumer: Internal.Consumer_<Internal.JumpControlJSBuilder>): Internal.JumpControlJS;
    /**
     * Flying entity path navigation
    */
    createFlyingPathNavigation(pMob: Internal.Mob_, pLevel: Internal.Level_): Internal.FlyingPathNavigation;
    /**
     * Creates a custom Look Control builder and returns it.
    */
    createLookControl(pMob: Internal.Mob_, consumer: Internal.Consumer_<Internal.LookControlJSBuilder>): Internal.LookControlJS;
    /**
     * Helper method to get the entity's builder for the type.
    */
    getEntityBuilder<T extends Internal.BuilderBase<any>>(type: Internal.EntityType_<any>): T;
    /**
     * Water bound entity path navigation
    */
    createWaterBoundPathNavigation(pMob: Internal.Mob_, pLevel: Internal.Level_): Internal.WaterBoundPathNavigation;
    /**
     * Ground entity path navigation
    */
    createGroundPathNavigation(pMob: Internal.Mob_, pLevel: Internal.Level_): Internal.GroundPathNavigation;
    /**
     * Amphibious entity path navigation
    */
    createAmphibiousPathNavigation(pMob: Internal.Mob_, pLevel: Internal.Level_): Internal.AmphibiousPathNavigation;
}
type EntityJSUtils_ = EntityJSUtils;
declare const EntityJSUtils: EntityJSUtils;
declare class Stats {
    constructor()
    getClass(): typeof any;
    hashCode(): number;
    toString(): string;
    wait(): void;
    notifyAll(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    get class(): typeof any
    static readonly SWIM_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly FLY_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly CLEAN_SHULKER_BOX: (ResourceLocation) & (ResourceLocation);
    static readonly TOTAL_WORLD_TIME: (ResourceLocation) & (ResourceLocation);
    static readonly TUNE_NOTEBLOCK: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_RESISTED: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_DROPPED: Internal.StatType<Internal.Item>;
    static readonly PLAYER_KILLS: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_BREWINGSTAND: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_CAMPFIRE: (ResourceLocation) & (ResourceLocation);
    static readonly INSPECT_DISPENSER: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_FURNACE: (ResourceLocation) & (ResourceLocation);
    static readonly OPEN_ENDERCHEST: (ResourceLocation) & (ResourceLocation);
    static readonly ANIMALS_BRED: (ResourceLocation) & (ResourceLocation);
    static readonly POT_FLOWER: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_STONECUTTER: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_PICKED_UP: Internal.StatType<Internal.Item>;
    static readonly FALL_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_ABSORBED: (ResourceLocation) & (ResourceLocation);
    static readonly FISH_CAUGHT: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_ANVIL: (ResourceLocation) & (ResourceLocation);
    static readonly BOAT_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly PLAY_RECORD: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_DEALT_RESISTED: (ResourceLocation) & (ResourceLocation);
    static readonly RAID_WIN: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_DEALT: (ResourceLocation) & (ResourceLocation);
    static readonly DEATHS: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_SMOKER: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_USED: Internal.StatType<Internal.Item>;
    static readonly BELL_RING: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_SMITHING_TABLE: (ResourceLocation) & (ResourceLocation);
    static readonly INSPECT_DROPPER: (ResourceLocation) & (ResourceLocation);
    static readonly DROP: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_LECTERN: (ResourceLocation) & (ResourceLocation);
    static readonly PLAY_TIME: (ResourceLocation) & (ResourceLocation);
    static readonly WALK_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly CLIMB_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly TRADED_WITH_VILLAGER: (ResourceLocation) & (ResourceLocation);
    static readonly RAID_TRIGGER: (ResourceLocation) & (ResourceLocation);
    static readonly STRIDER_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_BROKEN: Internal.StatType<Internal.Item>;
    static readonly BLOCK_MINED: Internal.StatType<Internal.Block>;
    static readonly TIME_SINCE_REST: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_BEACON: (ResourceLocation) & (ResourceLocation);
    static readonly INSPECT_HOPPER: (ResourceLocation) & (ResourceLocation);
    static readonly PLAY_NOTEBLOCK: (ResourceLocation) & (ResourceLocation);
    static readonly CUSTOM: Internal.StatType<ResourceLocation>;
    static readonly CROUCH_TIME: (ResourceLocation) & (ResourceLocation);
    static readonly JUMP: (ResourceLocation) & (ResourceLocation);
    static readonly ENTITY_KILLED: Internal.StatType<Internal.EntityType<any>>;
    static readonly ENTITY_KILLED_BY: Internal.StatType<Internal.EntityType<any>>;
    static readonly INTERACT_WITH_CARTOGRAPHY_TABLE: (ResourceLocation) & (ResourceLocation);
    static readonly MOB_KILLS: (ResourceLocation) & (ResourceLocation);
    static readonly OPEN_CHEST: (ResourceLocation) & (ResourceLocation);
    static readonly SLEEP_IN_BED: (ResourceLocation) & (ResourceLocation);
    static readonly CLEAN_ARMOR: (ResourceLocation) & (ResourceLocation);
    static readonly CROUCH_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly TALKED_TO_VILLAGER: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_DEALT_ABSORBED: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_LOOM: (ResourceLocation) & (ResourceLocation);
    static readonly LEAVE_GAME: (ResourceLocation) & (ResourceLocation);
    static readonly HORSE_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly WALK_ON_WATER_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly MINECART_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly ENCHANT_ITEM: (ResourceLocation) & (ResourceLocation);
    static readonly TIME_SINCE_DEATH: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_TAKEN: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_BLAST_FURNACE: (ResourceLocation) & (ResourceLocation);
    static readonly TRIGGER_TRAPPED_CHEST: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_GRINDSTONE: (ResourceLocation) & (ResourceLocation);
    static readonly OPEN_BARREL: (ResourceLocation) & (ResourceLocation);
    static readonly SPRINT_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_BLOCKED_BY_SHIELD: (ResourceLocation) & (ResourceLocation);
    static readonly EAT_CAKE_SLICE: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_CRAFTING_TABLE: (ResourceLocation) & (ResourceLocation);
    static readonly CLEAN_BANNER: (ResourceLocation) & (ResourceLocation);
    static readonly TARGET_HIT: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_CRAFTED: Internal.StatType<Internal.Item>;
    static readonly WALK_UNDER_WATER_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly PIG_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly OPEN_SHULKER_BOX: (ResourceLocation) & (ResourceLocation);
    static readonly USE_CAULDRON: (ResourceLocation) & (ResourceLocation);
    static readonly AVIATE_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly FILL_CAULDRON: (ResourceLocation) & (ResourceLocation);
}
type Stats_ = Stats;
declare class Duration implements Internal.TemporalAmount, Internal.Comparable<Duration>, Internal.Serializable {
    "dividedBy(java.time.Duration)"(arg0: Duration_): number;
    static parse(arg0: Internal.CharSequence_): Duration;
    notify(): void;
    compareTo(arg0: any): number;
    minusHours(arg0: number): this;
    plusMillis(arg0: number): this;
    toNanosPart(): number;
    getUnits(): Internal.List<Internal.TemporalUnit>;
    multipliedBy(arg0: number): this;
    dividedBy(arg0: number): this;
    get(arg0: Internal.TemporalUnit_): number;
    minusNanos(arg0: number): this;
    static ofSeconds(arg0: number): Duration;
    isNegative(): boolean;
    minus(arg0: Duration_): this;
    static ofMinutes(arg0: number): Duration;
    static ofNanos(arg0: number): Duration;
    toDays(): number;
    toHoursPart(): number;
    minusDays(arg0: number): this;
    toSecondsPart(): number;
    static ofMillis(arg0: number): Duration;
    wait(): void;
    plusNanos(arg0: number): this;
    "compareTo(java.lang.Object)"(arg0: any): number;
    minusSeconds(arg0: number): this;
    toMinutes(): number;
    plus(arg0: number, arg1: Internal.TemporalUnit_): this;
    getClass(): typeof any;
    toMillis(): number;
    toHours(): number;
    getSeconds(): number;
    static ofSeconds(arg0: number, arg1: number): Duration;
    toMinutesPart(): number;
    isZero(): boolean;
    wait(arg0: number, arg1: number): void;
    static of(arg0: number, arg1: Internal.TemporalUnit_): Duration;
    withSeconds(arg0: number): this;
    static between(arg0: Internal.Temporal_, arg1: Internal.Temporal_): Duration;
    plusSeconds(arg0: number): this;
    plusMinutes(arg0: number): this;
    toNanos(): number;
    negated(): this;
    static ofDays(arg0: number): Duration;
    addTo(arg0: Internal.Temporal_): Internal.Temporal;
    compareTo(arg0: Duration_): number;
    toString(): string;
    minus(arg0: number, arg1: Internal.TemporalUnit_): this;
    plus(arg0: Duration_): this;
    notifyAll(): void;
    toDaysPart(): number;
    "compareTo(java.time.Duration)"(arg0: Duration_): number;
    plusDays(arg0: number): this;
    static from(arg0: Internal.TemporalAmount_): Duration;
    getNano(): number;
    plusHours(arg0: number): this;
    truncatedTo(arg0: Internal.TemporalUnit_): this;
    subtractFrom(arg0: Internal.Temporal_): Internal.Temporal;
    hashCode(): number;
    minusMillis(arg0: number): this;
    wait(arg0: number): void;
    dividedBy(arg0: Duration_): number;
    equals(arg0: any): boolean;
    abs(): this;
    static ofHours(arg0: number): Duration;
    minusMinutes(arg0: number): this;
    withNanos(arg0: number): this;
    "dividedBy(long)"(arg0: number): this;
    toSeconds(): number;
    toMillisPart(): number;
    get units(): Internal.List<Internal.TemporalUnit>
    get negative(): boolean
    get class(): typeof any
    get seconds(): number
    get zero(): boolean
    get nano(): number
    static readonly ZERO: (Duration) & (Duration);
}
type Duration_ = Duration;
declare class OutputItem implements Internal.OutputReplacement {
    getClass(): typeof any;
    getCount(): number;
    withRolls(rolls: Internal.IntProvider_): this;
    static of(from: any): OutputItem;
    isEmpty(): boolean;
    notify(): void;
    withCount(count: number): this;
    wait(arg0: number, arg1: number): void;
    weakNBT(): InputItem;
    strongNBT(): InputItem;
    replaceOutput(recipe: Internal.RecipeJS_, match: Internal.ReplacementMatch_, original: Internal.OutputReplacement_): any;
    withChance(chance: number): this;
    withRolls(min: number, max: number): this;
    getNbt(): Internal.CompoundTag;
    toString(): string;
    transform(transformer: Internal.OutputReplacementTransformer_): Internal.OutputReplacementTransformer$Replacement;
    notifyAll(): void;
    getChance(): number;
    static of(item: Internal.ItemStack_, chance: number): OutputItem;
    hashCode(): number;
    wait(): void;
    wait(arg0: number): void;
    hasChance(): boolean;
    equals(arg0: any): boolean;
    /**
     * @deprecated
    */
    ignoreNBT(): InputItem;
    get class(): typeof any
    get count(): number
    get empty(): boolean
    get nbt(): Internal.CompoundTag
    get chance(): number
    static readonly EMPTY: (OutputItem) & (OutputItem);
    readonly item: Internal.ItemStack;
    readonly rolls: Internal.IntProvider;
    readonly chance: number;
}
type OutputItem_ = Internal.ItemStack_ | OutputItem;
declare class Fluid {
    constructor()
    static of(o: Internal.FluidStackJS_): Internal.FluidStackJS;
    getClass(): typeof any;
    static getEmpty(): Internal.FluidStackJS;
    static getType(id: ResourceLocation_): Internal.Fluid;
    static of(o: Internal.FluidStackJS_, nbt: Internal.CompoundTag_): Internal.FluidStackJS;
    toString(): string;
    static of(o: Internal.FluidStackJS_, amount: number, nbt: Internal.CompoundTag_): Internal.FluidStackJS;
    static "of(dev.latvian.mods.kubejs.fluid.FluidStackJS,net.minecraft.nbt.CompoundTag)"(o: Internal.FluidStackJS_, nbt: Internal.CompoundTag_): Internal.FluidStackJS;
    notifyAll(): void;
    static of(o: Internal.FluidStackJS_, amount: number): Internal.FluidStackJS;
    static lava(amount: number): Internal.FluidStackJS;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    hashCode(): number;
    static lava(): Internal.FluidStackJS;
    static getTypes(): Internal.List<string>;
    static "of(dev.latvian.mods.kubejs.fluid.FluidStackJS,int)"(o: Internal.FluidStackJS_, amount: number): Internal.FluidStackJS;
    wait(): void;
    static getId(fluid: Internal.Fluid_): ResourceLocation;
    wait(arg0: number): void;
    static water(amount: number): Internal.FluidStackJS;
    static exists(id: ResourceLocation_): boolean;
    equals(arg0: any): boolean;
    static water(): Internal.FluidStackJS;
    get class(): typeof any
    get empty(): Internal.FluidStackJS
    get types(): Internal.List<string>
    static readonly LAVA_ID: (ResourceLocation) & (ResourceLocation);
    static readonly WATER_ID: (ResourceLocation) & (ResourceLocation);
}
type Fluid_ = Fluid;
declare class InputItem implements Internal.InputReplacement, Internal.IngredientSupplierKJS, Internal.JsonSerializable {
    replaceInput(recipe: Internal.RecipeJS_, match: Internal.ReplacementMatch_, original: Internal.InputReplacement_): any;
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    isEmpty(): boolean;
    notify(): void;
    toJson(): Internal.JsonElement;
    withCount(count: number): this;
    wait(arg0: number, arg1: number): void;
    static of(o: InputItem_): InputItem;
    static of(ingredient: Internal.Ingredient_, count: number): InputItem;
    toJson(alwaysNest: boolean): Internal.JsonElement;
    validForMatching(): boolean;
    hashCode(): number;
    unwrap(): Internal.List<InputItem>;
    wait(): void;
    wait(arg0: number): void;
    transform(transformer: Internal.InputReplacementTransformer_): Internal.InputReplacementTransformer$Replacement;
    equals(arg0: any): boolean;
    kjs$asIngredient(): Internal.Ingredient;
    get class(): typeof any
    get empty(): boolean
    readonly ingredient: Internal.Ingredient;
    readonly count: number;
    static readonly EMPTY: (InputItem) & (InputItem);
    static readonly PARSE_CACHE: ({}) & (Internal.Map<string, InputItem>);
}
type InputItem_ = Internal.Ingredient_ | InputItem;
declare class DamageSource {
    constructor(arg0: Internal.Holder_<Internal.DamageType>)
    constructor(arg0: Internal.Holder_<Internal.DamageType>, arg1: Internal.Entity_, arg2: Internal.Entity_)
    constructor(arg0: Internal.Holder_<Internal.DamageType>, arg1: Internal.Entity_)
    constructor(arg0: Internal.Holder_<Internal.DamageType>, arg1: Vec3d_)
    constructor(arg0: Internal.Holder_<Internal.DamageType>, arg1: Internal.Entity_, arg2: Internal.Entity_, arg3: Vec3d_)
    getClass(): typeof any;
    getSourcePosition(): Vec3d;
    scalesWithDifficulty(): boolean;
    typeHolder(): Internal.Holder<Internal.DamageType>;
    "is(net.minecraft.tags.TagKey)"(arg0: Internal.TagKey_<Internal.DamageType>): boolean;
    notify(): void;
    getLocalizedDeathMessage(arg0: Internal.LivingEntity_): Internal.Component;
    wait(arg0: number, arg1: number): void;
    is(arg0: Internal.TagKey_<Internal.DamageType>): boolean;
    type(): Internal.DamageType;
    "is(net.minecraft.resources.ResourceKey)"(arg0: Internal.ResourceKey_<Internal.DamageType>): boolean;
    getType(): string;
    getActual(): Internal.Entity;
    getPlayer(): Internal.Player;
    toString(): string;
    isIndirect(): boolean;
    getImmediate(): Internal.Entity;
    notifyAll(): void;
    getFoodExhaustion(): number;
    sourcePositionRaw(): Vec3d;
    is(arg0: Internal.ResourceKey_<Internal.DamageType>): boolean;
    hashCode(): number;
    isCreativePlayer(): boolean;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    get class(): typeof any
    get sourcePosition(): Vec3d
    get type(): string
    get actual(): Internal.Entity
    get player(): Internal.Player
    get indirect(): boolean
    get immediate(): Internal.Entity
    get foodExhaustion(): number
    get creativePlayer(): boolean
}
type DamageSource_ = DamageSource;
declare class LootEntry {
    constructor()
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    static of(in_: Internal.ItemStack_, count: number, nbt: Internal.CompoundTag_): Internal.LootEntry;
    static withChance(o: any, chance: number): Internal.LootEntry;
    notify(): void;
    static of(in_: Internal.ItemStack_, count: number): Internal.LootEntry;
    wait(arg0: number, arg1: number): void;
    static "of(net.minecraft.world.item.ItemStack,net.minecraft.nbt.CompoundTag)"(in_: Internal.ItemStack_, nbt: Internal.CompoundTag_): Internal.LootEntry;
    hashCode(): number;
    wait(): void;
    static "of(net.minecraft.world.item.ItemStack,int)"(in_: Internal.ItemStack_, count: number): Internal.LootEntry;
    static of(in_: Internal.ItemStack_, nbt: Internal.CompoundTag_): Internal.LootEntry;
    wait(arg0: number): void;
    static ofJson(json: Internal.JsonObject_): Internal.LootEntry;
    equals(arg0: any): boolean;
    static of(o: any): Internal.LootEntry;
    get class(): typeof any
}
type LootEntry_ = LootEntry;
declare interface Color {
    of(o: any): Internal.Color;
    rgba(r: number, g: number, b: number, a: number): Internal.Color;
    createMapped(o: any, ...names: string[]): Internal.Color;
    readonly DARK_PURPLE: (Internal.ChatFormatting) & (Internal.Color);
    readonly YELLOW: (Internal.ChatFormatting) & (Internal.Color);
    readonly CYAN_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly GRAY: (Internal.ChatFormatting) & (Internal.Color);
    readonly BROWN_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly LIGHT_PURPLE: (Internal.ChatFormatting) & (Internal.Color);
    readonly PURPLE_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly DARK_AQUA: (Internal.ChatFormatting) & (Internal.Color);
    readonly GREEN: (Internal.ChatFormatting) & (Internal.Color);
    readonly LIGHT_GRAY_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly WHITE: (Internal.ChatFormatting) & (Internal.Color);
    readonly MAGENTA_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly RED: (Internal.ChatFormatting) & (Internal.Color);
    readonly BLACK_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly TEXT: ({"dark_red": Internal.ChatFormatting, "green": Internal.ChatFormatting, "underline": Internal.ChatFormatting, "dark_green": Internal.ChatFormatting, "black": Internal.ChatFormatting, "yellow": Internal.ChatFormatting, "bold": Internal.ChatFormatting, "italic": Internal.ChatFormatting, "dark_blue": Internal.ChatFormatting, "dark_purple": Internal.ChatFormatting, "gold": Internal.ChatFormatting, "red": Internal.ChatFormatting, "aqua": Internal.ChatFormatting, "gray": Internal.ChatFormatting, "light_purple": Internal.ChatFormatting, "blue": Internal.ChatFormatting, "white": Internal.ChatFormatting, "dark_aqua": Internal.ChatFormatting, "dark_gray": Internal.ChatFormatting, "reset": Internal.ChatFormatting, "strikethrough": Internal.ChatFormatting, "obfuscated": Internal.ChatFormatting}) & (Internal.Map<string, Internal.ChatFormatting>);
    readonly RED_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly GRAY_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly DARK_GRAY: (Internal.ChatFormatting) & (Internal.Color);
    readonly NONE: (Internal.NoColor) & (Internal.Color);
    readonly ORANGE_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly WHITE_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly DYE: ({"magenta": Internal.DyeColor, "pink": Internal.DyeColor, "green": Internal.DyeColor, "lime": Internal.DyeColor, "light_gray": Internal.DyeColor, "yellow": Internal.DyeColor, "black": Internal.DyeColor, "light_blue": Internal.DyeColor, "brown": Internal.DyeColor, "cyan": Internal.DyeColor, "orange": Internal.DyeColor, "red": Internal.DyeColor, "gray": Internal.DyeColor, "white": Internal.DyeColor, "blue": Internal.DyeColor, "purple": Internal.DyeColor}) & (Internal.Map<string, Internal.DyeColor>);
    readonly BLACK: (Internal.ChatFormatting) & (Internal.Color);
    readonly BLUE: (Internal.ChatFormatting) & (Internal.Color);
    readonly DARK_GREEN: (Internal.ChatFormatting) & (Internal.Color);
    readonly DARK_RED: (Internal.ChatFormatting) & (Internal.Color);
    readonly GOLD: (Internal.ChatFormatting) & (Internal.Color);
    readonly MAP: ({"": Internal.NoColor, "light_blue_dye": Internal.DyeColor, "BLUE_DYE": Internal.DyeColor, "purple_dye": Internal.DyeColor, "dark_red": Internal.ChatFormatting, "lightGrayDye": Internal.DyeColor, "DARK_AQUA": Internal.ChatFormatting, "none": Internal.NoColor, "green_dye": Internal.DyeColor, "blackDye": Internal.DyeColor, "dark_blue": Internal.ChatFormatting, "red": Internal.ChatFormatting, "pink_dye": Internal.DyeColor, "aqua": Internal.ChatFormatting, "white": Internal.ChatFormatting, "WHITE_DYE": Internal.DyeColor, "dark_gray": Internal.ChatFormatting, "LIGHT_PURPLE": Internal.ChatFormatting, "BROWN_DYE": Internal.DyeColor, "BLACK": Internal.ChatFormatting, "darkPurple": Internal.ChatFormatting, "NONE": Internal.NoColor, "LIGHT_BLUE_DYE": Internal.DyeColor, "AQUA": Internal.ChatFormatting, "lightBlueDye": Internal.DyeColor, "limeDye": Internal.DyeColor, "PURPLE_DYE": Internal.DyeColor, "GREEN_DYE": Internal.DyeColor, "magenta_dye": Internal.DyeColor, "-": Internal.NoColor, "lime_dye": Internal.DyeColor, "yellowDye": Internal.DyeColor, "grayDye": Internal.DyeColor, "purpleDye": Internal.DyeColor, "DARK_PURPLE": Internal.ChatFormatting, "ORANGE_DYE": Internal.DyeColor, "darkGray": Internal.ChatFormatting, "brownDye": Internal.DyeColor, "YELLOW": Internal.ChatFormatting, "LIME_DYE": Internal.DyeColor, "blueDye": Internal.DyeColor, "white_dye": Internal.DyeColor, "pinkDye": Internal.DyeColor, "blue_dye": Internal.DyeColor, "cyanDye": Internal.DyeColor, "GOLD": Internal.ChatFormatting, "GRAY": Internal.ChatFormatting, "MAGENTA_DYE": Internal.DyeColor, "BLUE": Internal.ChatFormatting, "yellow": Internal.ChatFormatting, "darkBlue": Internal.ChatFormatting, "transparent": Internal.NoColor, "orange_dye": Internal.DyeColor, "red_dye": Internal.DyeColor, "dark_purple": Internal.ChatFormatting, "gold": Internal.ChatFormatting, "gray": Internal.ChatFormatting, "light_purple": Internal.ChatFormatting, "darkRed": Internal.ChatFormatting, "greenDye": Internal.DyeColor, "DARK_RED": Internal.ChatFormatting, "redDye": Internal.DyeColor, "GRAY_DYE": Internal.DyeColor, "orangeDye": Internal.DyeColor, "yellow_dye": Internal.DyeColor, "black_dye": Internal.DyeColor, "magentaDye": Internal.DyeColor, "WHITE": Internal.ChatFormatting, "green": Internal.ChatFormatting, "LIGHT_GRAY_DYE": Internal.DyeColor, "BLACK_DYE": Internal.DyeColor, "darkGreen": Internal.ChatFormatting, "RED_DYE": Internal.DyeColor, "dark_green": Internal.ChatFormatting, "black": Internal.ChatFormatting, "lightPurple": Internal.ChatFormatting, "PINK_DYE": Internal.DyeColor, "DARK_BLUE": Internal.ChatFormatting, "GREEN": Internal.ChatFormatting, "darkAqua": Internal.ChatFormatting, "gray_dye": Internal.DyeColor, "CYAN_DYE": Internal.DyeColor, "RED": Internal.ChatFormatting, "brown_dye": Internal.DyeColor, "cyan_dye": Internal.DyeColor, "blue": Internal.ChatFormatting, "whiteDye": Internal.DyeColor, "dark_aqua": Internal.ChatFormatting, "YELLOW_DYE": Internal.DyeColor, "DARK_GREEN": Internal.ChatFormatting, "DARK_GRAY": Internal.ChatFormatting}) & (Internal.Map<string, Internal.Color>);
    readonly GREEN_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly LIGHT_BLUE_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly AQUA: (Internal.ChatFormatting) & (Internal.Color);
    readonly DARK_BLUE: (Internal.ChatFormatting) & (Internal.Color);
    readonly PINK_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly BLUE_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly YELLOW_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly LIME_DYE: (Internal.DyeColor) & (Internal.Color);
}
type Color_ = Color;
declare const Color: Color;
declare class JsonIO {
    constructor()
    getClass(): typeof any;
    static readJson(path: Internal.Path_): Internal.JsonElement;
    static toPrettyString(json: Internal.JsonElement_): string;
    static getJsonHashString(json: Internal.JsonElement_): string;
    notify(): void;
    static toObject(json: Internal.JsonElement_): any;
    wait(arg0: number, arg1: number): void;
    static primitiveOf(o: any): Internal.JsonPrimitive;
    static readString(path: Internal.Path_): string;
    static writeJsonHash(stream: Internal.DataOutputStream_, element: Internal.JsonElement_): void;
    static parseRaw(string: string): Internal.JsonElement;
    static write(path: Internal.Path_, json: Internal.JsonObject_): void;
    static read(path: Internal.Path_): Internal.Map<any, any>;
    toString(): string;
    notifyAll(): void;
    static toArray(element: Internal.JsonElement_): Internal.JsonArray;
    static parse(string: string): any;
    static toPrimitive(element: Internal.JsonElement_): any;
    hashCode(): number;
    static copy(element: Internal.JsonElement_): Internal.JsonElement;
    wait(): void;
    wait(arg0: number): void;
    static toString(json: Internal.JsonElement_): string;
    static getJsonHashBytes(json: Internal.JsonElement_): number[];
    equals(arg0: any): boolean;
    static of(o: any): Internal.JsonElement;
    get class(): typeof any
}
type JsonIO_ = JsonIO;
declare class ModelResourceLocation extends ResourceLocation {
    constructor(arg0: string, arg1: string, arg2: string)
    constructor(arg0: ResourceLocation_, arg1: string)
    static isValidNamespace(arg0: string): boolean;
    getClass(): typeof any;
    compareTo(arg0: ResourceLocation_): number;
    toLanguageKey(arg0: string): string;
    static checkSpecialEquality(o: any, o1: any, shallow: boolean): boolean;
    static validNamespaceChar(arg0: string): boolean;
    static read(arg0: string): Internal.DataResult<ResourceLocation>;
    static isValidPath(arg0: string): boolean;
    toShortLanguageKey(): string;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    compareTo(arg0: any): number;
    setPath(arg0: string): void;
    static tryBuild(arg0: string, arg1: string): ResourceLocation;
    "withPath(java.lang.String)"(arg0: string): ResourceLocation;
    static vanilla(arg0: string, arg1: string): ModelResourceLocation;
    getVariant(): string;
    static isAllowedInResourceLocation(arg0: string): boolean;
    withPath(arg0: string): ResourceLocation;
    static tryParse(arg0: string): ResourceLocation;
    static validPathChar(arg0: string): boolean;
    toLanguageKey(arg0: string, arg1: string): string;
    toDebugFileName(): string;
    getPath(): string;
    getNamespace(): string;
    static of(arg0: string, arg1: string): ResourceLocation;
    compareNamespaced(arg0: ResourceLocation_): number;
    "compareTo(net.minecraft.resources.ResourceLocation)"(arg0: ResourceLocation_): number;
    toString(): string;
    withSuffix(arg0: string): ResourceLocation;
    notifyAll(): void;
    specialEquals(o: any, shallow: boolean): boolean;
    static read(arg0: Internal.StringReader_): ResourceLocation;
    toLanguageKey(): string;
    static isValidResourceLocation(arg0: string): boolean;
    "withPath(java.util.function.UnaryOperator)"(arg0: Internal.UnaryOperator_<string>): ResourceLocation;
    static "read(com.mojang.brigadier.StringReader)"(arg0: Internal.StringReader_): ResourceLocation;
    hashCode(): number;
    static "read(java.lang.String)"(arg0: string): Internal.DataResult<ResourceLocation>;
    setNamespace(arg0: string): void;
    wait(): void;
    withPath(arg0: Internal.UnaryOperator_<string>): ResourceLocation;
    wait(arg0: number): void;
    withPrefix(arg0: string): ResourceLocation;
    "compareTo(java.lang.Object)"(arg0: any): number;
    equals(arg0: any): boolean;
    get class(): typeof any
    set path(arg0: string)
    get variant(): string
    get path(): string
    get namespace(): string
    set namespace(arg0: string)
}
type ModelResourceLocation_ = ModelResourceLocation;
declare class Platform {
    constructor()
    getClass(): typeof any;
    static getMcVersion(): string;
    static isForge(): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    static isFabric(): boolean;
    static isGeneratingData(): boolean;
    static getInfo(modID: string): Internal.PlatformWrapper$ModInfo;
    static isLoaded(modId: string): boolean;
    static getName(): string;
    static setModName(modId: string, name: string): void;
    static getMinecraftVersion(): number;
    static isDevelopmentEnvironment(): boolean;
    static getList(): Internal.Set<string>;
    toString(): string;
    notifyAll(): void;
    static isClientEnvironment(): boolean;
    static breakpoint(...args: any[]): void;
    static getModVersion(): string;
    hashCode(): number;
    static getMinecraftVersionString(): string;
    static getMods(): Internal.Map<string, Internal.PlatformWrapper$ModInfo>;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    get class(): typeof any
    get mcVersion(): string
    get forge(): boolean
    get fabric(): boolean
    get generatingData(): boolean
    get name(): string
    get minecraftVersion(): number
    get developmentEnvironment(): boolean
    get list(): Internal.Set<string>
    get clientEnvironment(): boolean
    get modVersion(): string
    get minecraftVersionString(): string
    get mods(): Internal.Map<string, Internal.PlatformWrapper$ModInfo>
}
type Platform_ = Platform;
/**
 * Various item related helper methods
*/
declare interface Item {
    /**
     * Returns an ItemStack of the input
    */
    of(in_: Internal.ItemStack_): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified count and NBT data
    */
    of(in_: Internal.ItemStack_, count: number, nbt: Internal.CompoundTag_): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified count
    */
    of(in_: Internal.ItemStack_, count: number): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified NBT data
    */
    withNBT(in_: Internal.ItemStack_, nbt: Internal.CompoundTag_): Internal.ItemStack;
    getTypeToStackMap(): Internal.Map<ResourceLocation, Internal.Collection<Internal.ItemStack>>;
    playerHeadFromSkinHash(hash: string): Internal.ItemStack;
    /**
     * Get the item that represents air/an empty slot
    */
    getEmpty(): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified count
    */
    "of(net.minecraft.world.item.ItemStack,int)"(in_: Internal.ItemStack_, count: number): Internal.ItemStack;
    /**
     * Gets an Item from an item id
    */
    getItem(id: ResourceLocation_): Internal.Item;
    getVariants(item: Internal.ItemStack_): Internal.Collection<Internal.ItemStack>;
    /**
     * Returns a Firework with the input properties
    */
    fireworks(properties: Internal.Map_<string, any>): Internal.FireworksJS;
    /**
     * Get a list of most items in the game. Items not in a creative tab are ignored
    */
    getList(): Internal.List<Internal.ItemStack>;
    /**
     * Returns an ItemStack of the input, with the specified NBT data
    */
    "of(net.minecraft.world.item.ItemStack,net.minecraft.nbt.CompoundTag)"(in_: Internal.ItemStack_, tag: Internal.CompoundTag_): Internal.ItemStack;
    playerHead(name: string): Internal.ItemStack;
    playerHeadFromUrl(url: string): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified NBT data
    */
    of(in_: Internal.ItemStack_, tag: Internal.CompoundTag_): Internal.ItemStack;
    /**
     * Get a list of all the item ids in the game
    */
    getTypeList(): Internal.List<string>;
    /**
     * Checks if the provided item id exists in the registry
    */
    exists(id: ResourceLocation_): boolean;
    playerHead(uuid: Internal.UUID_, textureBase64: string): Internal.ItemStack;
    /**
     * Checks if the passed in object is an ItemStack.
     * Note that this does not mean it will not function as an ItemStack if passed to something that requests one.
    */
    isItem(o: any): boolean;
    /**
     * Gets an items id from the Item
    */
    getId(item: Internal.Item_): ResourceLocation;
    get typeToStackMap(): Internal.Map<ResourceLocation, Internal.Collection<Internal.ItemStack>>
    /**
     * Get the item that represents air/an empty slot
    */
    get empty(): Internal.ItemStack
    /**
     * Get a list of most items in the game. Items not in a creative tab are ignored
    */
    get list(): Internal.List<Internal.ItemStack>
    /**
     * Get a list of all the item ids in the game
    */
    get typeList(): Internal.List<string>
    readonly KJS_ARMOR_MODIFIER_UUID_PER_SLOT: Internal.UUID[];
    readonly KJS_BASE_ATTACK_SPEED_UUID: (Internal.UUID) & (Internal.UUID);
    readonly KJS_BASE_ATTACK_DAMAGE_UUID: (Internal.UUID) & (Internal.UUID);
}
type Item_ = Item;
declare const Item: Item;
declare abstract class number implements Internal.Serializable {
    constructor()
    abstract longValue(): number;
    getClass(): typeof any;
    abstract doubleValue(): number;
    toString(): string;
    abstract floatValue(): number;
    notifyAll(): void;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    shortValue(): number;
    hashCode(): number;
    abstract intValue(): number;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    byteValue(): number;
    get class(): typeof any
}
type number_ = number;
declare interface ItemFilter extends Internal.Predicate<Internal.ItemStack> {
    hasEnchantment(filter: Internal.ResourceLocationFilter_, min: number, max: number): this;
    abstract "test(net.minecraft.world.item.ItemStack)"(arg0: Internal.ItemStack_): boolean;
    isEqual<T>(arg0: any): Internal.Predicate<T>;
    "not(com.almostreliable.lootjs.filters.ItemFilter)"(itemFilter: ItemFilter_): this;
    and(...itemFilters: ItemFilter_[]): this;
    test(arg0: any): boolean;
    and(other: ItemFilter_): this;
    not(itemFilter: ItemFilter_): this;
    or(...itemFilters: ItemFilter_[]): this;
    or(other: ItemFilter_): this;
    "test(java.lang.Object)"(arg0: any): boolean;
    "and(java.util.function.Predicate)"(arg0: Internal.Predicate_<Internal.ItemStack>): Internal.Predicate<Internal.ItemStack>;
    not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
    "or(com.almostreliable.lootjs.filters.ItemFilter)"(other: ItemFilter_): this;
    negate(): Internal.Predicate<any>;
    hasEnchantment(filter: Internal.ResourceLocationFilter_): this;
    "and(com.almostreliable.lootjs.filters.ItemFilter[])"(...itemFilters: ItemFilter_[]): this;
    "not(java.util.function.Predicate)"<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
    equipmentSlot(slot: Internal.EquipmentSlot_): this;
    "or(com.almostreliable.lootjs.filters.ItemFilter[])"(...itemFilters: ItemFilter_[]): this;
    or(arg0: Internal.Predicate_<Internal.ItemStack>): Internal.Predicate<Internal.ItemStack>;
    "or(java.util.function.Predicate)"(arg0: Internal.Predicate_<Internal.ItemStack>): Internal.Predicate<Internal.ItemStack>;
    abstract test(arg0: Internal.ItemStack_): boolean;
    custom(predicate: Internal.Predicate_<Internal.ItemStack>): this;
    "and(com.almostreliable.lootjs.filters.ItemFilter)"(other: ItemFilter_): this;
    and(arg0: Internal.Predicate_<Internal.ItemStack>): Internal.Predicate<Internal.ItemStack>;
    readonly FEET_ARMOR: ItemFilter;
    readonly ENCHANTABLE: ItemFilter;
    readonly POTION: ItemFilter;
    readonly HAS_TIER: ItemFilter;
    readonly PROJECTILE_WEAPON: ItemFilter;
    readonly TOOL: ItemFilter;
    readonly LEGS_ARMOR: ItemFilter;
    readonly DAMAGED: ItemFilter;
    readonly DAMAGEABLE: ItemFilter;
    readonly WEAPON: ItemFilter;
    readonly BLOCK: ItemFilter;
    readonly FOOD: ItemFilter;
    readonly HOE: ItemFilter;
    readonly SHOVEL: ItemFilter;
    readonly ALWAYS_TRUE: ItemFilter;
    readonly PICKAXE: ItemFilter;
    readonly ENCHANTED: ItemFilter;
    readonly HEAD_ARMOR: ItemFilter;
    readonly CHEST_ARMOR: ItemFilter;
    readonly AXE: ItemFilter;
    readonly ALWAYS_FALSE: ItemFilter;
    readonly SWORD: ItemFilter;
    readonly ARMOR: ItemFilter;
}
type ItemFilter_ = ItemFilter;
declare const ItemFilter: ItemFilter;
declare class Vec3f implements Internal.Cloneable, Internal.Vector3fc, Internal.Externalizable {
    constructor()
    constructor(arg0: Internal.Vector3fc_)
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: number, arg1: Internal.FloatBuffer_)
    constructor(arg0: number[])
    constructor(arg0: number)
    constructor(arg0: Internal.Vector2fc_, arg1: number)
    constructor(arg0: Internal.Vector2ic_, arg1: number)
    constructor(arg0: Internal.ByteBuffer_)
    constructor(arg0: number, arg1: Internal.ByteBuffer_)
    constructor(arg0: number, arg1: number, arg2: number)
    constructor(arg0: Internal.Vector3ic_)
    "set(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    "get(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    set(arg0: number, arg1: number, arg2: number): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    div(arg0: number, arg1: number, arg2: number): this;
    rotateY(arg0: number): this;
    "mul(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    angleCos(arg0: Internal.Vector3fc_): number;
    "fma(float,org.joml.Vector3fc)"(arg0: number, arg1: Internal.Vector3fc_): this;
    set(arg0: number): this;
    "set(float)"(arg0: number): this;
    static length(arg0: number, arg1: number, arg2: number): number;
    mulAdd(arg0: number, arg1: Internal.Vector3fc_): this;
    normalize(arg0: number, arg1: Vec3f_): this;
    sub(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    half(arg0: number, arg1: number, arg2: number): this;
    round(): this;
    "fma(org.joml.Vector3fc,org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    "mulAdd(org.joml.Vector3fc,org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    orthogonalizeUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    "get(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "div(float)"(arg0: number): this;
    add(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    get(arg0: number): number;
    "mulAdd(float,org.joml.Vector3fc,org.joml.Vector3f)"(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    mul(arg0: number, arg1: number, arg2: number): this;
    ceil(arg0: Vec3f_): this;
    negate(): this;
    getClass(): typeof any;
    "mulPosition(org.joml.Matrix4x3fc,org.joml.Vector3f)"(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    add(arg0: Internal.Vector3fc_): this;
    static lengthSquared(arg0: number, arg1: number, arg2: number): number;
    ceil(): this;
    div(arg0: number, arg1: Vec3f_): this;
    distanceSquared(arg0: number, arg1: number, arg2: number): number;
    "div(float,org.joml.Vector3f)"(arg0: number, arg1: Vec3f_): this;
    "mulDirection(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_): this;
    add(arg0: number, arg1: number, arg2: number): this;
    mulTransposeDirection(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    rotateZ(arg0: number): this;
    distanceSquared(arg0: Internal.Vector3fc_): number;
    set(arg0: number[]): this;
    equals(arg0: Internal.Vector3fc_, arg1: number): boolean;
    "set(double)"(arg0: number): this;
    "normalize(float)"(arg0: number): this;
    mulAdd(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    div(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    max(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    lerp(arg0: Internal.Vector3fc_, arg1: number, arg2: Vec3f_): this;
    "mulAdd(org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mulPositionW(arg0: Internal.Matrix4fc_): number;
    mulPosition(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    rotationTo(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): Quaternionf;
    "mul(org.joml.Matrix3x2fc,org.joml.Vector3f)"(arg0: Internal.Matrix3x2fc_, arg1: Vec3f_): this;
    mul(arg0: Internal.Matrix3x2fc_): this;
    "set(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    mulDirection(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    "mulDirection(org.joml.Matrix4fc,org.joml.Vector3f)"(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    wait(arg0: number): void;
    rotateZ(arg0: number, arg1: Vec3f_): this;
    mul(arg0: Internal.Matrix3fc_): this;
    "mulDirection(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    absolute(arg0: Vec3f_): this;
    angleSigned(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): number;
    normalize(arg0: Vec3f_): this;
    normalize(arg0: number): this;
    normalize(): this;
    mulProject(arg0: Internal.Matrix4fc_, arg1: number, arg2: Vec3f_): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    mul(arg0: Internal.Vector3fc_): this;
    isFinite(): boolean;
    mulTransposePosition(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    getToAddress(arg0: number): Internal.Vector3fc;
    "mulDirection(org.joml.Matrix4dc,org.joml.Vector3f)"(arg0: Internal.Matrix4dc_, arg1: Vec3f_): this;
    "mul(org.joml.Matrix3dc,org.joml.Vector3f)"(arg0: Internal.Matrix3dc_, arg1: Vec3f_): this;
    "mulDirection(org.joml.Matrix4x3fc,org.joml.Vector3f)"(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    x(): number;
    absolute(): this;
    mulDirection(arg0: Internal.Matrix4dc_): this;
    "set(float,float,float)"(arg0: number, arg1: number, arg2: number): this;
    "set(org.joml.Vector2dc,float)"(arg0: Internal.Vector2dc_, arg1: number): this;
    mulDirection(arg0: Internal.Matrix4dc_, arg1: Vec3f_): this;
    mulAdd(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    "mul(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    fma(arg0: number, arg1: Internal.Vector3fc_): this;
    wait(): void;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    sub(arg0: Internal.Vector3fc_): this;
    minComponent(): number;
    set(arg0: Internal.Vector3fc_): this;
    orthogonalize(arg0: Internal.Vector3fc_): this;
    rotate(arg0: Internal.Quaternionfc_, arg1: Vec3f_): this;
    "set(org.joml.Vector2ic,float)"(arg0: Internal.Vector2ic_, arg1: number): this;
    set(arg0: Internal.ByteBuffer_): this;
    "set(org.joml.Vector3dc)"(arg0: Internal.Vector3dc_): this;
    "mul(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    rotateX(arg0: number): this;
    round(arg0: Vec3f_): this;
    half(arg0: Internal.Vector3fc_): this;
    mul(arg0: Internal.Matrix3dc_, arg1: Vec3f_): this;
    static distance(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
    mul(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    "normalize(org.joml.Vector3f)"(arg0: Vec3f_): this;
    "set(float[])"(arg0: number[]): this;
    y(): number;
    mul(arg0: Internal.Matrix3x2fc_, arg1: Vec3f_): this;
    "get(int,org.joml.Vector3i)"(arg0: number, arg1: Internal.Vector3i_): Internal.Vector3i;
    set(arg0: Internal.Vector2fc_, arg1: number): this;
    distance(arg0: Internal.Vector3fc_): number;
    "mul(org.joml.Matrix3fc,org.joml.Vector3f)"(arg0: Internal.Matrix3fc_, arg1: Vec3f_): this;
    "mulPosition(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    max(arg0: Internal.Vector3fc_): this;
    equals(arg0: any): boolean;
    setFromAddress(arg0: number): this;
    "mul(float)"(arg0: number): this;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    "mul(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_): this;
    "get(org.joml.Vector3f)"(arg0: Vec3f_): this;
    equals(arg0: number, arg1: number, arg2: number): boolean;
    add(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    mulPosition(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    mulTransposeDirection(arg0: Internal.Matrix4fc_): this;
    set(arg0: Internal.FloatBuffer_): this;
    "set(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): this;
    z(): number;
    "get(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    mulPositionW(arg0: Internal.Matrix4fc_, arg1: Vec3f_): number;
    mulDirection(arg0: Internal.Matrix4fc_): this;
    "fma(org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    toString(arg0: Internal.NumberFormat_): string;
    "get(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    "div(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    lengthSquared(): number;
    mulAdd(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "set(double,double,double)"(arg0: number, arg1: number, arg2: number): this;
    "set(org.joml.Vector2fc,float)"(arg0: Internal.Vector2fc_, arg1: number): this;
    mulTranspose(arg0: Internal.Matrix3fc_, arg1: Vec3f_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec3f_): this;
    clone(): any;
    cross(arg0: Internal.Vector3fc_): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    maxComponent(): number;
    "get(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.Vector3dc_): this;
    mul(arg0: number): this;
    static distanceSquared(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
    dot(arg0: number, arg1: number, arg2: number): number;
    mulTranspose(arg0: Internal.Matrix3fc_): this;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    floor(): this;
    zero(): this;
    reflect(arg0: number, arg1: number, arg2: number): this;
    mulProject(arg0: Internal.Matrix4fc_): this;
    sub(arg0: number, arg1: number, arg2: number): this;
    mulPosition(arg0: Internal.Matrix4x3fc_): this;
    length(): number;
    toString(): string;
    notifyAll(): void;
    "mulPosition(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    "mulPosition(org.joml.Matrix4fc,org.joml.Vector3f)"(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    setComponent(arg0: number, arg1: number): this;
    "mul(org.joml.Matrix3x2fc)"(arg0: Internal.Matrix3x2fc_): this;
    div(arg0: number): this;
    orthogonalize(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    cross(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    div(arg0: Internal.Vector3fc_): this;
    fma(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    set(arg0: number): this;
    rotate(arg0: Internal.Quaternionfc_): this;
    set(arg0: Internal.Vector3ic_): this;
    "mul(float,org.joml.Vector3f)"(arg0: number, arg1: Vec3f_): this;
    min(arg0: Internal.Vector3fc_): this;
    half(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    cross(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    notify(): void;
    "mulAdd(float,org.joml.Vector3fc)"(arg0: number, arg1: Internal.Vector3fc_): this;
    floor(arg0: Vec3f_): this;
    mul(arg0: Internal.Matrix3fc_, arg1: Vec3f_): this;
    half(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    smoothStep(arg0: Internal.Vector3fc_, arg1: number, arg2: Vec3f_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    set(arg0: Internal.Vector2dc_, arg1: number): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    negate(arg0: Vec3f_): this;
    mul(arg0: number, arg1: Vec3f_): this;
    mulPosition(arg0: Internal.Matrix4fc_): this;
    hermite(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: number, arg4: Vec3f_): this;
    get(arg0: Internal.Vector3d_): Internal.Vector3d;
    "set(org.joml.Vector3ic)"(arg0: Internal.Vector3ic_): this;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotateY(arg0: number, arg1: Vec3f_): this;
    "get(int)"(arg0: number): number;
    distance(arg0: number, arg1: number, arg2: number): number;
    "set(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): this;
    dot(arg0: Internal.Vector3fc_): number;
    "set(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    div(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    cross(arg0: number, arg1: number, arg2: number): this;
    orthogonalizeUnit(arg0: Internal.Vector3fc_): this;
    min(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    set(arg0: number, arg1: number, arg2: number): this;
    wait(arg0: number, arg1: number): void;
    "mulDirection(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    set(arg0: Internal.Vector2ic_, arg1: number): this;
    lerp(arg0: Internal.Vector3fc_, arg1: number): this;
    "div(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    sub(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    rotationTo(arg0: Internal.Vector3fc_, arg1: Quaternionf_): Quaternionf;
    mulTransposePosition(arg0: Internal.Matrix4fc_): this;
    angle(arg0: Internal.Vector3fc_): number;
    mulProject(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    "fma(float,org.joml.Vector3fc,org.joml.Vector3f)"(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    get(arg0: number, arg1: Internal.Vector3i_): Internal.Vector3i;
    fma(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    angleSigned(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
    mulDirection(arg0: Internal.Matrix4x3fc_): this;
    mulDirection(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    hashCode(): number;
    fma(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    get(arg0: Vec3f_): this;
    rotateX(arg0: number, arg1: Vec3f_): this;
    reflect(arg0: Internal.Vector3fc_): this;
    mul(arg0: Internal.Matrix3dc_): this;
    set "(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set "(float)"(arg0: number)
    get class(): typeof any
    set "(double)"(arg0: number)
    set "(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    get finite(): boolean
    set "(org.joml.Vector3dc)"(arg0: Internal.Vector3dc_)
    set "(float[])"(arg0: number[])
    set fromAddress(arg0: number)
    set "(org.joml.Vector3ic)"(arg0: Internal.Vector3ic_)
    set "(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_)
    z: number;
    y: number;
    x: number;
}
type Vec3f_ = Vec3f;
declare class Vec4f implements Internal.Cloneable, Internal.Vector4fc, Internal.Externalizable {
    constructor()
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: number, arg1: Internal.FloatBuffer_)
    constructor(arg0: Internal.Vector2fc_, arg1: number, arg2: number)
    constructor(arg0: Internal.Vector3fc_, arg1: number)
    constructor(arg0: number[])
    constructor(arg0: number)
    constructor(arg0: Internal.ByteBuffer_)
    constructor(arg0: Internal.Vector2ic_, arg1: number, arg2: number)
    constructor(arg0: number, arg1: Internal.ByteBuffer_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number)
    constructor(arg0: Internal.Vector4fc_)
    constructor(arg0: Internal.Vector3ic_, arg1: number)
    constructor(arg0: Internal.Vector4ic_)
    min(arg0: Internal.Vector4fc_): this;
    set(arg0: Internal.Vector4ic_): this;
    div(arg0: Internal.Vector4fc_): this;
    "fma(float,org.joml.Vector4fc,org.joml.Vector4f)"(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    normalize3(arg0: Vec4f_): this;
    static distanceSquared(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): number;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotateAbout(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "set(float,float,float,float)"(arg0: number, arg1: number, arg2: number, arg3: number): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mul(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "div(float)"(arg0: number): this;
    mul(arg0: Internal.Vector4fc_): this;
    dot(arg0: number, arg1: number, arg2: number, arg3: number): number;
    setComponent(arg0: number, arg1: number): this;
    "set(double,double,double,double)"(arg0: number, arg1: number, arg2: number, arg3: number): this;
    fma(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    rotateZ(arg0: number, arg1: Vec4f_): this;
    mulAdd(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    "mul(org.joml.Matrix4fc,org.joml.Vector4f)"(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    z(): number;
    "set(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): this;
    min(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    div(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    "mul(float)"(arg0: number): this;
    "get(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.Vector2ic_, arg1: number, arg2: number): this;
    dot(arg0: Internal.Vector4fc_): number;
    set(arg0: number, arg1: number, arg2: number): this;
    mulAffine(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    "set(org.joml.Vector2fc,float,float)"(arg0: Internal.Vector2fc_, arg1: number, arg2: number): this;
    toString(arg0: Internal.NumberFormat_): string;
    rotateZ(arg0: number): this;
    "mul(float,org.joml.Vector4f)"(arg0: number, arg1: Vec4f_): this;
    "get(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "get(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    fma(arg0: number, arg1: Internal.Vector4fc_): this;
    normalize3(): this;
    round(arg0: Vec4f_): this;
    div(arg0: number, arg1: number, arg2: number, arg3: number): this;
    lengthSquared(): number;
    mul(arg0: Internal.Matrix4x3fc_): this;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    get(arg0: number): number;
    distanceSquared(arg0: Internal.Vector4fc_): number;
    set(arg0: number[]): this;
    sub(arg0: Internal.Vector4fc_): this;
    mulAdd(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    set(arg0: Internal.Vector3ic_, arg1: number): this;
    sub(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    clone(): any;
    getClass(): typeof any;
    mul(arg0: number, arg1: number, arg2: number, arg3: number): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    maxComponent(): number;
    "set(org.joml.Vector4ic)"(arg0: Internal.Vector4ic_): this;
    "get(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.Vector4fc_): this;
    "mul(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    negate(arg0: Vec4f_): this;
    "set(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    "fma(float,org.joml.Vector4fc)"(arg0: number, arg1: Internal.Vector4fc_): this;
    get(arg0: Internal.Vector4d_): Internal.Vector4d;
    getToAddress(arg0: number): Internal.Vector4fc;
    rotateY(arg0: number, arg1: Vec4f_): this;
    "get(int,org.joml.Vector4i)"(arg0: number, arg1: Internal.Vector4i_): Internal.Vector4i;
    set(arg0: Internal.Vector3fc_, arg1: number): this;
    "mul(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    "fma(org.joml.Vector4fc,org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    static lengthSquared(arg0: number, arg1: number, arg2: number, arg3: number): number;
    ceil(arg0: Vec4f_): this;
    "fma(org.joml.Vector4fc,org.joml.Vector4fc)"(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    "mul(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    "set(org.joml.Vector4fc)"(arg0: Internal.Vector4fc_): this;
    negate(): this;
    mulAffineTranspose(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    "mulAdd(float,org.joml.Vector4fc)"(arg0: number, arg1: Internal.Vector4fc_): this;
    w(): number;
    rotate(arg0: Internal.Quaternionfc_): this;
    "set(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    length(): number;
    toString(): string;
    normalize(arg0: number): this;
    distanceSquared(arg0: number, arg1: number, arg2: number, arg3: number): number;
    mul(arg0: number): this;
    notifyAll(): void;
    ceil(): this;
    smoothStep(arg0: Internal.Vector4fc_, arg1: number, arg2: Vec4f_): this;
    lerp(arg0: Internal.Vector4fc_, arg1: number): this;
    "mul(org.joml.Matrix4x3fc,org.joml.Vector4f)"(arg0: Internal.Matrix4x3fc_, arg1: Vec4f_): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    floor(arg0: Vec4f_): this;
    mul(arg0: Internal.Matrix4x3fc_, arg1: Vec4f_): this;
    "get(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    div(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    "set(org.joml.Vector3ic,float)"(arg0: Internal.Vector3ic_, arg1: number): this;
    floor(): this;
    angle(arg0: Internal.Vector4fc_): number;
    wait(arg0: number): void;
    static "lengthSquared(int,int,int,int)"(arg0: number, arg1: number, arg2: number, arg3: number): number;
    "set(org.joml.Vector3fc,float)"(arg0: Internal.Vector3fc_, arg1: number): this;
    max(arg0: Internal.Vector4fc_): this;
    sub(arg0: number, arg1: number, arg2: number, arg3: number): this;
    set(arg0: Internal.FloatBuffer_): this;
    "get(org.joml.Vector4f)"(arg0: Vec4f_): this;
    angleCos(arg0: Internal.Vector4fc_): number;
    "set(float)"(arg0: number): this;
    get(arg0: number, arg1: Internal.Vector4i_): Internal.Vector4i;
    hermite(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Internal.Vector4fc_, arg3: number, arg4: Vec4f_): this;
    "set(float,float,float)"(arg0: number, arg1: number, arg2: number): this;
    absolute(): this;
    distance(arg0: Internal.Vector4fc_): number;
    mul(arg0: number, arg1: Vec4f_): this;
    notify(): void;
    fma(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    normalize(): this;
    isFinite(): boolean;
    "normalize(org.joml.Vector4f)"(arg0: Vec4f_): this;
    get(arg0: Vec4f_): this;
    static length(arg0: number, arg1: number, arg2: number, arg3: number): number;
    set(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateX(arg0: number, arg1: Vec4f_): this;
    "mul(org.joml.Vector4fc)"(arg0: Internal.Vector4fc_): this;
    lerp(arg0: Internal.Vector4fc_, arg1: number, arg2: Vec4f_): this;
    static distance(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): number;
    div(arg0: number): this;
    setFromAddress(arg0: number): this;
    "div(org.joml.Vector4fc)"(arg0: Internal.Vector4fc_): this;
    mulAdd(arg0: number, arg1: Internal.Vector4fc_): this;
    "div(float,org.joml.Vector4f)"(arg0: number, arg1: Vec4f_): this;
    x(): number;
    absolute(arg0: Vec4f_): this;
    div(arg0: number, arg1: Vec4f_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    mulTranspose(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    static lengthSquared(arg0: number, arg1: number, arg2: number, arg3: number): number;
    set(arg0: Internal.ByteBuffer_): this;
    "mulProject(org.joml.Matrix4fc,org.joml.Vector4f)"(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    "set(double)"(arg0: number): this;
    "div(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    wait(): void;
    fma(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    set(arg0: number, arg1: number, arg2: number, arg3: number): this;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    zero(): this;
    mulProject(arg0: Internal.Matrix4fc_): this;
    "get(int)"(arg0: number): number;
    static "lengthSquared(float,float,float,float)"(arg0: number, arg1: number, arg2: number, arg3: number): number;
    mulAdd(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    mulProject(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    "normalize(float)"(arg0: number): this;
    add(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    rotateX(arg0: number): this;
    minComponent(): number;
    round(): this;
    set(arg0: Internal.Vector4dc_): this;
    "mulAdd(org.joml.Vector4fc,org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    "mulProject(org.joml.Matrix4fc,org.joml.Vector3f)"(arg0: Internal.Matrix4fc_, arg1: Vec3f_): Vec3f;
    add(arg0: Internal.Vector4fc_): this;
    "mulAdd(org.joml.Vector4fc,org.joml.Vector4fc)"(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    equals(arg0: Internal.Vector4fc_, arg1: number): boolean;
    wait(arg0: number, arg1: number): void;
    "set(org.joml.Vector2ic,float,float)"(arg0: Internal.Vector2ic_, arg1: number, arg2: number): this;
    sub(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    mulTranspose(arg0: Internal.Matrix4fc_): this;
    max(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    equals(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
    "mulAdd(float,org.joml.Vector4fc,org.joml.Vector4f)"(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    mulProject(arg0: Internal.Matrix4fc_, arg1: Vec3f_): Vec3f;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    y(): number;
    rotate(arg0: Internal.Quaternionfc_, arg1: Vec4f_): this;
    mul(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    normalize(arg0: Vec4f_): this;
    set(arg0: number): this;
    rotateY(arg0: number): this;
    hashCode(): number;
    set(arg0: Internal.Vector2fc_, arg1: number, arg2: number): this;
    distance(arg0: number, arg1: number, arg2: number, arg3: number): number;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    "set(org.joml.Vector4dc)"(arg0: Internal.Vector4dc_): this;
    set(arg0: number): this;
    equals(arg0: any): boolean;
    mul(arg0: Internal.Matrix4fc_): this;
    "set(float[])"(arg0: number[]): this;
    "set(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): this;
    normalize(arg0: number, arg1: Vec4f_): this;
    get class(): typeof any
    set "(org.joml.Vector4ic)"(arg0: Internal.Vector4ic_)
    set "(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    set "(org.joml.Vector4fc)"(arg0: Internal.Vector4fc_)
    set "(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set "(float)"(arg0: number)
    get finite(): boolean
    set fromAddress(arg0: number)
    set "(double)"(arg0: number)
    set "(org.joml.Vector4dc)"(arg0: Internal.Vector4dc_)
    set "(float[])"(arg0: number[])
    z: number;
    y: number;
    x: number;
    w: number;
}
type Vec4f_ = Vec4f;
declare class CuriosApi {
    constructor()
    notify(): void;
    static getSlot(arg0: string, arg1: Internal.Level_): Internal.Optional<Internal.ISlotType>;
    static getPlayerSlots(arg0: boolean): Internal.Map<string, Internal.ISlotType>;
    /**
     * @deprecated
     * This method is marked to be removed in future!
    */
    static getSlotHelper(): Internal.ISlotHelper;
    /**
     * @deprecated
    */
    static getSlots(): Internal.Map<string, Internal.ISlotType>;
    static getCuriosInventory(arg0: Internal.LivingEntity_): Internal.LazyOptional<Internal.ICuriosItemHandler>;
    static "getPlayerSlots(net.minecraft.world.entity.player.Player)"(arg0: Internal.Player_): Internal.Map<string, Internal.ISlotType>;
    static broadcastCurioBreakEvent(arg0: Internal.SlotContext_): void;
    static "getSlots(net.minecraft.world.level.Level)"(arg0: Internal.Level_): Internal.Map<string, Internal.ISlotType>;
    static registerCurioPredicate(arg0: ResourceLocation_, arg1: Internal.Predicate_<Internal.SlotResult>): void;
    static getSlotIcon(arg0: string): ResourceLocation;
    static "getSlots(boolean)"(arg0: boolean): Internal.Map<string, Internal.ISlotType>;
    /**
     * @deprecated
    */
    static getIconHelper(): Internal.IIconHelper;
    /**
     * @deprecated
    */
    static getCuriosHelper(): Internal.ICuriosHelper;
    static "getItemStackSlots(net.minecraft.world.item.ItemStack,boolean)"(arg0: Internal.ItemStack_, arg1: boolean): Internal.Map<string, Internal.ISlotType>;
    static getCurio(arg0: Internal.ItemStack_): Internal.LazyOptional<Internal.ICurio>;
    static "getSlot(java.lang.String,net.minecraft.world.level.Level)"(arg0: string, arg1: Internal.Level_): Internal.Optional<Internal.ISlotType>;
    static registerCurio(arg0: Internal.Item_, arg1: Internal.ICurioItem_): void;
    /**
     * @deprecated
    */
    static setCuriosHelper(arg0: Internal.ICuriosHelper_): void;
    static getAttributeModifiers(arg0: Internal.SlotContext_, arg1: Internal.UUID_, arg2: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
    /**
     * @deprecated
    */
    static setIconHelper(arg0: Internal.IIconHelper_): void;
    static getEntitySlots(arg0: Internal.EntityType_<any>, arg1: Internal.Level_): Internal.Map<string, Internal.ISlotType>;
    static getCurioPredicate(arg0: ResourceLocation_): Internal.Optional<Internal.Predicate<Internal.SlotResult>>;
    wait(): void;
    static getEntitySlots(arg0: Internal.EntityType_<any>, arg1: boolean): Internal.Map<string, Internal.ISlotType>;
    static addSlotModifier(arg0: Internal.ItemStack_, arg1: string, arg2: string, arg3: Internal.UUID_, arg4: number, arg5: Internal.AttributeModifier$Operation_, arg6: string): void;
    static isStackValid(arg0: Internal.SlotContext_, arg1: Internal.ItemStack_): boolean;
    static "getEntitySlots(net.minecraft.world.entity.EntityType,boolean)"(arg0: Internal.EntityType_<any>, arg1: boolean): Internal.Map<string, Internal.ISlotType>;
    getClass(): typeof any;
    static getSlot(arg0: string, arg1: boolean): Internal.Optional<Internal.ISlotType>;
    static "getEntitySlots(net.minecraft.world.entity.EntityType,net.minecraft.world.level.Level)"(arg0: Internal.EntityType_<any>, arg1: Internal.Level_): Internal.Map<string, Internal.ISlotType>;
    static getPlayerSlots(arg0: Internal.Player_): Internal.Map<string, Internal.ISlotType>;
    /**
     * @deprecated
    */
    static getSlot(arg0: string): Internal.Optional<Internal.ISlotType>;
    static "getPlayerSlots(boolean)"(arg0: boolean): Internal.Map<string, Internal.ISlotType>;
    wait(arg0: number, arg1: number): void;
    static "getSlot(java.lang.String,boolean)"(arg0: string, arg1: boolean): Internal.Optional<Internal.ISlotType>;
    static "getPlayerSlots(net.minecraft.world.level.Level)"(arg0: Internal.Level_): Internal.Map<string, Internal.ISlotType>;
    static getCurioPredicates(): Internal.Map<ResourceLocation, Internal.Predicate<Internal.SlotResult>>;
    static createCurioProvider(arg0: Internal.ICurio_): Internal.ICapabilityProvider;
    static "getItemStackSlots(net.minecraft.world.item.ItemStack,net.minecraft.world.entity.LivingEntity)"(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.Map<string, Internal.ISlotType>;
    /**
     * @deprecated
    */
    static getItemStackSlots(arg0: Internal.ItemStack_): Internal.Map<string, Internal.ISlotType>;
    toString(): string;
    static getItemStackSlots(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.Map<string, Internal.ISlotType>;
    static getSlots(arg0: Internal.Level_): Internal.Map<string, Internal.ISlotType>;
    notifyAll(): void;
    static getSlotUuid(arg0: Internal.SlotContext_): Internal.UUID;
    static "getItemStackSlots(net.minecraft.world.item.ItemStack,net.minecraft.world.level.Level)"(arg0: Internal.ItemStack_, arg1: Internal.Level_): Internal.Map<string, Internal.ISlotType>;
    /**
     * @deprecated
     * This method is marked to be removed in future!
    */
    static setSlotHelper(arg0: Internal.ISlotHelper_): void;
    static getItemStackSlots(arg0: Internal.ItemStack_, arg1: Internal.Level_): Internal.Map<string, Internal.ISlotType>;
    static testCurioPredicates(arg0: Internal.Set_<ResourceLocation>, arg1: Internal.SlotResult_): boolean;
    static getPlayerSlots(arg0: Internal.Level_): Internal.Map<string, Internal.ISlotType>;
    hashCode(): number;
    static addModifier(arg0: Internal.ItemStack_, arg1: Internal.Attribute_, arg2: string, arg3: Internal.UUID_, arg4: number, arg5: Internal.AttributeModifier$Operation_, arg6: string): void;
    /**
     * @deprecated
    */
    static getEntitySlots(arg0: Internal.EntityType_<any>): Internal.Map<string, Internal.ISlotType>;
    wait(arg0: number): void;
    static getSlots(arg0: boolean): Internal.Map<string, Internal.ISlotType>;
    static addSlotModifier(arg0: Internal.Multimap_<Internal.Attribute, Internal.AttributeModifier>, arg1: string, arg2: Internal.UUID_, arg3: number, arg4: Internal.AttributeModifier$Operation_): void;
    static getItemStackSlots(arg0: Internal.ItemStack_, arg1: boolean): Internal.Map<string, Internal.ISlotType>;
    /**
     * @deprecated
    */
    static "getEntitySlots(net.minecraft.world.entity.EntityType)"(arg0: Internal.EntityType_<any>): Internal.Map<string, Internal.ISlotType>;
    equals(arg0: any): boolean;
    static getEntitySlots(arg0: Internal.LivingEntity_): Internal.Map<string, Internal.ISlotType>;
    /**
     * @deprecated
    */
    static getPlayerSlots(): Internal.Map<string, Internal.ISlotType>;
    static "getEntitySlots(net.minecraft.world.entity.LivingEntity)"(arg0: Internal.LivingEntity_): Internal.Map<string, Internal.ISlotType>;
    /**
     * @deprecated
     * This method is marked to be removed in future!
    */
    get slotHelper(): Internal.ISlotHelper
    /**
     * @deprecated
    */
    get slots(): Internal.Map<string, Internal.ISlotType>
    /**
     * @deprecated
    */
    get iconHelper(): Internal.IIconHelper
    /**
     * @deprecated
    */
    get curiosHelper(): Internal.ICuriosHelper
    /**
     * @deprecated
    */
    set curiosHelper(arg0: Internal.ICuriosHelper_)
    /**
     * @deprecated
    */
    set iconHelper(arg0: Internal.IIconHelper_)
    get class(): typeof any
    get curioPredicates(): Internal.Map<ResourceLocation, Internal.Predicate<Internal.SlotResult>>
    /**
     * @deprecated
     * This method is marked to be removed in future!
    */
    set slotHelper(arg0: Internal.ISlotHelper_)
    /**
     * @deprecated
    */
    get playerSlots(): Internal.Map<string, Internal.ISlotType>
    static readonly MODID: ("curios") & (string);
}
type CuriosApi_ = CuriosApi;
declare class Notification {
    constructor()
    constructor(buf: Internal.FriendlyByteBuf_)
    getClass(): typeof any;
    write(buf: Internal.FriendlyByteBuf_): void;
    toString(): string;
    static make(consumer: Internal.Consumer_<Notification>): Notification;
    notifyAll(): void;
    static of(cx: Internal.Context_, object: any): Notification;
    setIcon(icon: string): void;
    show(): void;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    hashCode(): number;
    setAtlasIcon(icon: string): void;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    setItemIcon(stack: Internal.ItemStack_): void;
    get class(): typeof any
    set icon(icon: string)
    set atlasIcon(icon: string)
    set itemIcon(stack: Internal.ItemStack_)
    duration: Duration;
    static readonly DEFAULT_DURATION: (Duration) & (Duration);
    backgroundColor: Internal.Color;
    iconSize: number;
    static readonly DEFAULT_BACKGROUND_COLOR: (Internal.SimpleColor) & (Internal.Color);
    static readonly DEFAULT_BORDER_COLOR: (Internal.SimpleColor) & (Internal.Color);
    borderColor: Internal.Color;
    text: Internal.Component;
    outlineColor: Internal.Color;
    textShadow: boolean;
    static readonly NO_TEXT: Internal.Component[];
}
type Notification_ = Notification;
declare interface UUID {
    toString(id: Internal.UUID_): string;
    digits(sb: Internal.StringBuilder_, val: number, digits: number): void;
    fromString(o: any): Internal.UUID;
}
type UUID_ = UUID;
declare const UUID: UUID;
declare interface Facing {
    readonly south: (Internal.Direction) & (Internal.Direction);
    readonly up: (Internal.Direction) & (Internal.Direction);
    readonly UP: (Internal.Direction) & (Internal.Direction);
    readonly NORTH: (Internal.Direction) & (Internal.Direction);
    readonly east: (Internal.Direction) & (Internal.Direction);
    readonly DOWN: (Internal.Direction) & (Internal.Direction);
    readonly EAST: (Internal.Direction) & (Internal.Direction);
    readonly west: (Internal.Direction) & (Internal.Direction);
    readonly north: (Internal.Direction) & (Internal.Direction);
    readonly down: (Internal.Direction) & (Internal.Direction);
    readonly ALL: ({"east": Internal.Direction, "south": Internal.Direction, "north": Internal.Direction, "west": Internal.Direction, "up": Internal.Direction, "down": Internal.Direction}) & (Internal.Map<string, Internal.Direction>);
    readonly WEST: (Internal.Direction) & (Internal.Direction);
    readonly SOUTH: (Internal.Direction) & (Internal.Direction);
}
type Facing_ = Facing;
declare const Facing: Facing;
/**
 * Various Ingredient related helper methods
*/
declare interface Ingredient {
    static of(ingredient: Internal.Ingredient_, count: number): Internal.Ingredient;
    /**
     * Returns an ingredient of the input
    */
    of(ingredient: Internal.Ingredient_): Internal.Ingredient;
    /**
     * Returns an ingredient of the input, with the specified count
    */
    of(ingredient: Internal.Ingredient_, count: number): InputItem;
    /**
     * Register a custom ingredient action for use in recipes with Recipe#customIngredientAction
    */
    registerCustomIngredientAction(id: string, callback: Internal.CustomIngredientActionCallback_): void;
    /**
     * Make a custom ingredient where a match must match the provided predicate function
    */
    custom(predicate: Internal.Predicate_<Internal.ItemStack>): Internal.Ingredient;
    /**
     * Make a custom ingredient where items must match both the parent ingredient and the custom predicate function
    */
    custom(parent: Internal.Ingredient_, predicate: Internal.Predicate_<Internal.ItemStack>): Internal.Ingredient;
    static of(ingredient: Internal.Ingredient_): Internal.Ingredient;
    /**
     * Checks if the passed in object is an Ingredient.
     * Note that this does not mean it will not function as an Ingredient if passed to something that requests one.
    */
    isIngredient(o: any): boolean;
    /**
     * Make a custom ingredient where an item must match both the parent ingredient and the item's nbt must match the custom predicate function
    */
    customNBT(in_: Internal.Ingredient_, predicate: Internal.Predicate_<Internal.CompoundTag>): Internal.Ingredient;
    /**
     * An ingredient that matches everything
    */
    readonly all: (Internal.WildcardIngredient) & (Internal.Ingredient);
    /**
     * A completely empty ingredient that will only match air
    */
    readonly none: (Internal.Ingredient) & (Internal.Ingredient);
}
type Ingredient_ = Ingredient;
declare const Ingredient: Ingredient;
declare class Quaternionf implements Internal.Cloneable, Internal.Externalizable, Internal.Quaternionfc {
    constructor()
    constructor(arg0: Internal.AxisAngle4d_)
    constructor(arg0: Internal.Quaternionfc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number)
    constructor(arg0: Internal.AxisAngle4f_)
    constructor(arg0: Internal.Quaterniondc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number)
    "transform(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    slerp(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    transformInverse(arg0: Internal.Vector4d_): Internal.Vector4d;
    invert(): this;
    transformPositiveY(arg0: Vec3f_): Vec3f;
    transformPositiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
    mul(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transformUnit(arg0: Internal.Vector4d_): Internal.Vector4d;
    getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
    "getAsMatrix3f(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    "transformInverse(float,float,float,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "transformUnit(double,double,double,org.joml.Vector4d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    setFromUnnormalized(arg0: Internal.Matrix3fc_): this;
    get(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    conjugate(arg0: Quaternionf_): this;
    transform(arg0: Internal.Vector4d_): Internal.Vector4d;
    rotateXYZ(arg0: number, arg1: number, arg2: number): this;
    fromAxisAngleDeg(arg0: Internal.Vector3fc_, arg1: number): this;
    "transformUnitPositiveZ(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    rotateLocalZ(arg0: number): this;
    scale(arg0: number): this;
    premul(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotationZ(arg0: number): this;
    transformInverse(arg0: Internal.Vector3d_): Internal.Vector3d;
    transformPositiveY(arg0: Vec4f_): Vec4f;
    transformPositiveX(arg0: Internal.Vector4d_): Internal.Vector4d;
    "set(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): this;
    premul(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transformUnit(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    "transformUnitPositiveY(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    invert(arg0: Quaternionf_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "get(org.joml.Quaternionf)"(arg0: Quaternionf_): this;
    transform(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transformInverse(org.joml.Vector4dc,org.joml.Vector4d)"(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    "transform(double,double,double,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    positiveZ(arg0: Vec3f_): Vec3f;
    difference(arg0: Quaternionf_): this;
    div(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    setFromNormalized(arg0: Internal.Matrix3dc_): this;
    normalize(): this;
    getClass(): typeof any;
    transformPositiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
    rotateZ(arg0: number): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    transformUnit(arg0: Vec4f_): Vec4f;
    transformPositiveZ(arg0: Vec3f_): Vec3f;
    "setAngleAxis(double,double,double,double)"(arg0: number, arg1: number, arg2: number, arg3: number): this;
    scale(arg0: number, arg1: Quaternionf_): this;
    nlerp(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    "transformInverse(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    mul(arg0: number): this;
    "transformUnitPositiveX(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Quaternionf_): this;
    static slerp(arg0: Quaternionf_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    "transformPositiveY(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    get(arg0: Matrix4f_): Matrix4f;
    setAngleAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transform(arg0: Vec4f_): Vec4f;
    transformUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    setFromNormalized(arg0: Internal.Matrix4fc_): this;
    "setFromNormalized(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    getAsMatrix3f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "get(org.joml.Matrix4x3f)"(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    "transformInverseUnit(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    normalize(arg0: Quaternionf_): this;
    rotationAxis(arg0: Internal.AxisAngle4f_): this;
    transformInverseUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    mul(arg0: number, arg1: Quaternionf_): this;
    "transformPositiveZ(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    "transformUnit(float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    w(): number;
    transform(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    transformPositiveY(arg0: Internal.Vector4d_): Internal.Vector4d;
    rotateTo(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Quaternionf_): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "transformInverse(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    transformPositiveZ(arg0: Vec4f_): Vec4f;
    conjugateBy(arg0: Internal.Quaternionfc_): this;
    "transformInverse(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    transformInverse(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    get(arg0: Internal.Matrix3d_): Internal.Matrix3d;
    transform(arg0: Vec3f_): Vec3f;
    "get(org.joml.Matrix3d)"(arg0: Internal.Matrix3d_): Internal.Matrix3d;
    wait(arg0: number): void;
    "nlerp(org.joml.Quaternionfc,float,org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number): this;
    get(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
    slerp(arg0: Internal.Quaternionfc_, arg1: number): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    fromAxisAngleRad(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transformPositiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
    "get(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    "transformUnit(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    rotationTo(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotateLocalY(arg0: number, arg1: Quaternionf_): this;
    div(arg0: Internal.Quaternionfc_): this;
    transformInverseUnit(arg0: Internal.Vector4d_): Internal.Vector4d;
    "transformPositiveY(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    isFinite(): boolean;
    setFromUnnormalized(arg0: Internal.Matrix3dc_): this;
    "nlerpIterative(org.joml.Quaternionfc,float,float,org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: Quaternionf_): this;
    transformUnitPositiveX(arg0: Vec3f_): Vec3f;
    rotateLocalX(arg0: number): this;
    get(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    x(): number;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "transform(double,double,double,org.joml.Vector4d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    transformUnit(arg0: Vec3f_): Vec3f;
    transformPositiveZ(arg0: Internal.Vector4d_): Internal.Vector4d;
    "transformPositiveX(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    "transform(float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    "transform(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    "setFromUnnormalized(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    transformInverseUnit(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "mul(float,org.joml.Quaternionf)"(arg0: number, arg1: Quaternionf_): this;
    "transformUnitPositiveZ(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    "transformInverseUnit(float,float,float,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    fromAxisAngleRad(arg0: Internal.Vector3fc_, arg1: number): this;
    setFromUnnormalized(arg0: Internal.Matrix4fc_): this;
    wait(): void;
    setFromNormalized(arg0: Internal.Matrix3fc_): this;
    premul(arg0: Internal.Quaternionfc_): this;
    nlerp(arg0: Internal.Quaternionfc_, arg1: number): this;
    integrate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    "transformPositiveX(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transform(float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    get(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    "getAsMatrix4f(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    "transformInverse(float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    "transformUnit(org.joml.Vector4dc,org.joml.Vector4d)"(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    static "nlerpIterative(org.joml.Quaternionf[],float[],float,org.joml.Quaternionf)"(arg0: Quaternionf_[], arg1: number[], arg2: number, arg3: Quaternionf_): Internal.Quaternionfc;
    transformInverse(arg0: Vec4f_): Vec4f;
    getEulerAnglesZXY(arg0: Vec3f_): Vec3f;
    nlerpIterative(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: Quaternionf_): this;
    transform(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    "get(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    add(arg0: Internal.Quaternionfc_): this;
    rotateLocalZ(arg0: number, arg1: Quaternionf_): this;
    getAsMatrix4f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    "transformUnit(float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    rotationYXZ(arg0: number, arg1: number, arg2: number): this;
    add(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    dot(arg0: Quaternionf_): number;
    "getAsMatrix4f(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "transformUnitPositiveY(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    equals(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
    rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): this;
    rotateAxis(arg0: number, arg1: Internal.Vector3fc_): this;
    static "nlerp(org.joml.Quaternionfc[],float[],org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    rotateAxis(arg0: number, arg1: Internal.Vector3fc_, arg2: Quaternionf_): this;
    rotateLocalY(arg0: number): this;
    "transformInverse(double,double,double,org.joml.Vector4d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    y(): number;
    transformInverse(arg0: Vec3f_): Vec3f;
    "setFromNormalized(org.joml.Matrix4x3dc)"(arg0: Internal.Matrix4x3dc_): this;
    "transformUnitPositiveX(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    set(arg0: number, arg1: number, arg2: number, arg3: number): this;
    setFromNormalized(arg0: Internal.Matrix4x3fc_): this;
    "get(org.joml.Matrix4d)"(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    static nlerp(arg0: Internal.Quaternionfc_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    getAsMatrix4x3f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    setFromUnnormalized(arg0: Internal.Matrix4x3dc_): this;
    "transformInverse(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    "transformPositiveZ(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    "mul(float)"(arg0: number): this;
    conjugate(): this;
    transformInverse(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    equals(arg0: any): boolean;
    rotateYXZ(arg0: number, arg1: number, arg2: number): this;
    "transformInverseUnit(org.joml.Vector4dc,org.joml.Vector4d)"(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    "transformInverseUnit(float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    "setFromNormalized(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    rotationZYX(arg0: number, arg1: number, arg2: number): this;
    "transformInverse(float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    "transform(org.joml.Vector4dc,org.joml.Vector4d)"(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    fromAxisAngleDeg(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "setFromUnnormalized(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_): this;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "getAsMatrix4x3f(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    transformUnitPositiveZ(arg0: Vec3f_): Vec3f;
    "setFromNormalized(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    transformUnitPositiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transform(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transformUnitPositiveZ(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    transformUnit(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    z(): number;
    "transformUnitPositiveY(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    rotationAxis(arg0: number, arg1: Internal.Vector3fc_): this;
    normalizedPositiveX(arg0: Vec3f_): Vec3f;
    "setAngleAxis(float,float,float,float)"(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "set(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    "get(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    getAsMatrix3f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    toString(arg0: Internal.NumberFormat_): string;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    transformInverseUnit(arg0: Vec3f_): Vec3f;
    lengthSquared(): number;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    getEulerAnglesYXZ(arg0: Vec3f_): Vec3f;
    setFromUnnormalized(arg0: Internal.Matrix4dc_): this;
    get(arg0: Quaternionf_): this;
    rotateX(arg0: number, arg1: Quaternionf_): this;
    transformUnitPositiveX(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformUnitPositiveY(arg0: Vec4f_): Vec4f;
    identity(): this;
    "transformInverseUnit(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    clone(): any;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    "mul(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    "setFromUnnormalized(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    "transformUnitPositiveX(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): this;
    rotateLocalX(arg0: number, arg1: Quaternionf_): this;
    "transformPositiveY(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    transformUnit(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    static "slerp(org.joml.Quaternionf[],float[],org.joml.Quaternionf)"(arg0: Quaternionf_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    transform(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    set(arg0: Internal.Quaternionfc_): this;
    transformInverseUnit(arg0: Vec4f_): Vec4f;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    "set(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_): this;
    setFromNormalized(arg0: Internal.Matrix4x3dc_): this;
    "get(org.joml.Matrix4x3d)"(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
    transformInverseUnit(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    transformUnitPositiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transformInverseUnit(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformUnitPositiveY(arg0: Vec3f_): Vec3f;
    rotationAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "transformUnit(org.joml.Vector3dc,org.joml.Vector3d)"(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    rotateTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "transformInverseUnit(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "transformUnit(double,double,double,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    get(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    toString(): string;
    "transformPositiveZ(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    normalizedPositiveY(arg0: Vec3f_): Vec3f;
    notifyAll(): void;
    "setFromNormalized(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_): this;
    "transformInverse(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    transform(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    equals(arg0: Internal.Quaternionfc_, arg1: number): boolean;
    scaling(arg0: number): this;
    transformInverse(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    "slerp(org.joml.Quaternionfc,float,org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    setFromUnnormalized(arg0: Internal.Matrix4x3fc_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    rotationTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "transform(org.joml.Vector3dc,org.joml.Vector3d)"(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    transformUnitPositiveX(arg0: Vec4f_): Vec4f;
    premul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    getAsMatrix4x3f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mul(arg0: Internal.Quaternionfc_): this;
    rotateY(arg0: number): this;
    "transformInverse(double,double,double,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "transformUnit(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    notify(): void;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Quaternionf_): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    rotationX(arg0: number): this;
    "transformPositiveY(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transformInverseUnit(double,double,double,org.joml.Vector4d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    integrate(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    "getAsMatrix4x3f(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    normalizedPositiveZ(arg0: Vec3f_): Vec3f;
    set(arg0: Internal.AxisAngle4f_): this;
    "getAsMatrix3f(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    conjugateBy(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    "transform(float,float,float,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
    angle(): number;
    "transformPositiveX(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformInverseUnit(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    "transform(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    "transformInverseUnit(float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    get(arg0: Matrix3f_): Matrix3f;
    "setFromNormalized(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_): this;
    "transformUnitPositiveZ(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    rotateZ(arg0: number, arg1: Quaternionf_): this;
    "transformInverseUnit(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    positiveX(arg0: Vec3f_): Vec3f;
    rotateZYX(arg0: number, arg1: number, arg2: number): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): this;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    transformUnitPositiveZ(arg0: Internal.Vector4d_): Internal.Vector4d;
    "transformPositiveX(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    getAsMatrix4f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    rotateX(arg0: number): this;
    "transformInverseUnit(double,double,double,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    difference(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transformPositiveX(arg0: Vec3f_): Vec3f;
    "set(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    "transformInverse(org.joml.Vector3dc,org.joml.Vector3d)"(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    "get(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    wait(arg0: number, arg1: number): void;
    "setFromUnnormalized(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_): this;
    set(arg0: Internal.Quaterniondc_): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    "transformUnit(float,float,float,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "mul(org.joml.Quaternionfc,org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transform(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    nlerpIterative(arg0: Internal.Quaternionfc_, arg1: number, arg2: number): this;
    "transformUnitPositiveY(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    transformUnitPositiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transformUnit(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "transform(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    "transformUnit(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    setFromNormalized(arg0: Internal.Matrix4dc_): this;
    static nlerpIterative(arg0: Quaternionf_[], arg1: number[], arg2: number, arg3: Quaternionf_): Internal.Quaternionfc;
    rotationY(arg0: number): this;
    rotationXYZ(arg0: number, arg1: number, arg2: number): this;
    transformInverse(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    rotateTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Quaternionf_): this;
    "transformInverseUnit(org.joml.Vector3dc,org.joml.Vector3d)"(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    transformPositiveX(arg0: Vec4f_): Vec4f;
    "get(org.joml.Matrix4f)"(arg0: Matrix4f_): Matrix4f;
    set(arg0: Internal.AxisAngle4d_): this;
    hashCode(): number;
    setAngleAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    positiveY(arg0: Vec3f_): Vec3f;
    "transformInverse(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    rotateTo(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "setFromUnnormalized(org.joml.Matrix4x3dc)"(arg0: Internal.Matrix4x3dc_): this;
    transformUnitPositiveZ(arg0: Vec4f_): Vec4f;
    get(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    "transformPositiveZ(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    "transform(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "transformUnitPositiveX(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    rotateY(arg0: number, arg1: Quaternionf_): this;
    transformUnitPositiveY(arg0: Internal.Vector4d_): Internal.Vector4d;
    "transformUnit(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    "setFromUnnormalized(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    set fromUnnormalized(arg0: Internal.Matrix3fc_)
    set "(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_)
    set fromNormalized(arg0: Internal.Matrix3dc_)
    get class(): typeof any
    set fromNormalized(arg0: Internal.Matrix4fc_)
    set "fromNormalized(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_)
    get finite(): boolean
    set fromUnnormalized(arg0: Internal.Matrix3dc_)
    set "fromUnnormalized(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set fromUnnormalized(arg0: Internal.Matrix4fc_)
    set fromNormalized(arg0: Internal.Matrix3fc_)
    set "fromNormalized(org.joml.Matrix4x3dc)"(arg0: Internal.Matrix4x3dc_)
    set fromNormalized(arg0: Internal.Matrix4x3fc_)
    set fromUnnormalized(arg0: Internal.Matrix4x3dc_)
    set "fromNormalized(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set "fromUnnormalized(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_)
    set "fromNormalized(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_)
    set "(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_)
    set fromUnnormalized(arg0: Internal.Matrix4dc_)
    set "fromUnnormalized(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_)
    set "(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_)
    set fromNormalized(arg0: Internal.Matrix4x3dc_)
    set "fromNormalized(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_)
    set fromUnnormalized(arg0: Internal.Matrix4x3fc_)
    set "fromNormalized(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_)
    set "(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_)
    set "fromUnnormalized(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_)
    set fromNormalized(arg0: Internal.Matrix4dc_)
    set "fromUnnormalized(org.joml.Matrix4x3dc)"(arg0: Internal.Matrix4x3dc_)
    set "fromUnnormalized(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_)
    z: number;
    y: number;
    x: number;
    w: number;
}
type Quaternionf_ = Quaternionf;
declare class JavaMath {
    static "nextUp(float)"(arg0: number): number;
    static asin(arg0: number): number;
    static expm1(arg0: number): number;
    static ceil(arg0: number): number;
    static nextAfter(arg0: number, arg1: number): number;
    static exp(arg0: number): number;
    static "decrementExact(long)"(arg0: number): number;
    static "floorMod(long,int)"(arg0: number, arg1: number): number;
    static "incrementExact(int)"(arg0: number): number;
    static copySign(arg0: number, arg1: number): number;
    static ulp(arg0: number): number;
    static max(arg0: number, arg1: number): number;
    static "copySign(float,float)"(arg0: number, arg1: number): number;
    static "abs(float)"(arg0: number): number;
    static "negateExact(int)"(arg0: number): number;
    static "fma(double,double,double)"(arg0: number, arg1: number, arg2: number): number;
    static "min(double,double)"(arg0: number, arg1: number): number;
    static fma(arg0: number, arg1: number, arg2: number): number;
    static round(arg0: number): number;
    static hypot(arg0: number, arg1: number): number;
    static round(arg0: number): number;
    static "scalb(float,int)"(arg0: number, arg1: number): number;
    static abs(arg0: number): number;
    static "subtractExact(long,long)"(arg0: number, arg1: number): number;
    static "floorDiv(long,long)"(arg0: number, arg1: number): number;
    static floorMod(arg0: number, arg1: number): number;
    static log(arg0: number): number;
    static signum(arg0: number): number;
    static "max(float,float)"(arg0: number, arg1: number): number;
    static "nextAfter(double,double)"(arg0: number, arg1: number): number;
    static cos(arg0: number): number;
    getClass(): typeof any;
    static min(arg0: number, arg1: number): number;
    static nextUp(arg0: number): number;
    static "min(int,int)"(arg0: number, arg1: number): number;
    static "floorMod(int,int)"(arg0: number, arg1: number): number;
    static "max(long,long)"(arg0: number, arg1: number): number;
    static "fma(float,float,float)"(arg0: number, arg1: number, arg2: number): number;
    static "nextDown(double)"(arg0: number): number;
    static atan2(arg0: number, arg1: number): number;
    static cosh(arg0: number): number;
    static "round(float)"(arg0: number): number;
    static toIntExact(arg0: number): number;
    static decrementExact(arg0: number): number;
    static "floorDiv(int,int)"(arg0: number, arg1: number): number;
    static sinh(arg0: number): number;
    static toDegrees(arg0: number): number;
    static "multiplyExact(long,long)"(arg0: number, arg1: number): number;
    static max(arg0: number, arg1: number): number;
    static nextAfter(arg0: number, arg1: number): number;
    static "scalb(double,int)"(arg0: number, arg1: number): number;
    static "decrementExact(int)"(arg0: number): number;
    static tanh(arg0: number): number;
    toString(): string;
    static "negateExact(long)"(arg0: number): number;
    static "nextUp(double)"(arg0: number): number;
    notifyAll(): void;
    static floorMod(arg0: number, arg1: number): number;
    static "min(long,long)"(arg0: number, arg1: number): number;
    static nextDown(arg0: number): number;
    static "absExact(long)"(arg0: number): number;
    static "addExact(int,int)"(arg0: number, arg1: number): number;
    static pow(arg0: number, arg1: number): number;
    static absExact(arg0: number): number;
    static scalb(arg0: number, arg1: number): number;
    wait(arg0: number): void;
    static "abs(int)"(arg0: number): number;
    static addExact(arg0: number, arg1: number): number;
    static atan(arg0: number): number;
    static "addExact(long,long)"(arg0: number, arg1: number): number;
    static min(arg0: number, arg1: number): number;
    notify(): void;
    static multiplyExact(arg0: number, arg1: number): number;
    static "ulp(float)"(arg0: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static random(): number;
    static "ulp(double)"(arg0: number): number;
    static nextUp(arg0: number): number;
    static sqrt(arg0: number): number;
    static "multiplyExact(int,int)"(arg0: number, arg1: number): number;
    static "copySign(double,double)"(arg0: number, arg1: number): number;
    static "abs(double)"(arg0: number): number;
    static "subtractExact(int,int)"(arg0: number, arg1: number): number;
    static min(arg0: number, arg1: number): number;
    static fma(arg0: number, arg1: number, arg2: number): number;
    static addExact(arg0: number, arg1: number): number;
    static multiplyExact(arg0: number, arg1: number): number;
    static abs(arg0: number): number;
    static "floorMod(long,long)"(arg0: number, arg1: number): number;
    static floor(arg0: number): number;
    static subtractExact(arg0: number, arg1: number): number;
    static "abs(long)"(arg0: number): number;
    static rint(arg0: number): number;
    static "min(float,float)"(arg0: number, arg1: number): number;
    static "max(int,int)"(arg0: number, arg1: number): number;
    static signum(arg0: number): number;
    static absExact(arg0: number): number;
    wait(): void;
    static log10(arg0: number): number;
    static abs(arg0: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static tan(arg0: number): number;
    static floorMod(arg0: number, arg1: number): number;
    static ulp(arg0: number): number;
    static sin(arg0: number): number;
    static min(arg0: number, arg1: number): number;
    wait(arg0: number, arg1: number): void;
    static max(arg0: number, arg1: number): number;
    static "max(double,double)"(arg0: number, arg1: number): number;
    static toRadians(arg0: number): number;
    static "multiplyExact(long,int)"(arg0: number, arg1: number): number;
    static incrementExact(arg0: number): number;
    static negateExact(arg0: number): number;
    static max(arg0: number, arg1: number): number;
    static incrementExact(arg0: number): number;
    static decrementExact(arg0: number): number;
    static copySign(arg0: number, arg1: number): number;
    static negateExact(arg0: number): number;
    static "getExponent(float)"(arg0: number): number;
    static "incrementExact(long)"(arg0: number): number;
    static "signum(float)"(arg0: number): number;
    static nextDown(arg0: number): number;
    static "nextAfter(float,double)"(arg0: number, arg1: number): number;
    static IEEEremainder(arg0: number, arg1: number): number;
    static "round(double)"(arg0: number): number;
    static abs(arg0: number): number;
    static getExponent(arg0: number): number;
    static "getExponent(double)"(arg0: number): number;
    static scalb(arg0: number, arg1: number): number;
    static multiplyHigh(arg0: number, arg1: number): number;
    static multiplyFull(arg0: number, arg1: number): number;
    hashCode(): number;
    static multiplyExact(arg0: number, arg1: number): number;
    static getExponent(arg0: number): number;
    static "floorDiv(long,int)"(arg0: number, arg1: number): number;
    static cbrt(arg0: number): number;
    static acos(arg0: number): number;
    static log1p(arg0: number): number;
    static "nextDown(float)"(arg0: number): number;
    equals(arg0: any): boolean;
    static "signum(double)"(arg0: number): number;
    static "absExact(int)"(arg0: number): number;
    static subtractExact(arg0: number, arg1: number): number;
    get class(): typeof any
    static readonly PI: (3.141592653589793) & (number);
    static readonly E: (2.718281828459045) & (number);
}
type JavaMath_ = JavaMath;
declare class BlockProperties {
    constructor()
    getClass(): typeof any;
    hashCode(): number;
    toString(): string;
    wait(): void;
    notifyAll(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    get class(): typeof any
    static readonly LEVEL_FLOWING: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly PERSISTENT: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly HORIZONTAL_FACING: (Internal.DirectionProperty) & (Internal.DirectionProperty);
    static readonly WEST_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly CHISELED_BOOKSHELF_SLOT_5_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly NOTE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly AGE_5: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly EGGS: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly NORTH: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly HAS_RECORD: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SCULK_SENSOR_PHASE: Internal.EnumProperty<Internal.SculkSensorPhase>;
    static readonly EAST_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly HALF: Internal.EnumProperty<Internal.Half>;
    static readonly RESPAWN_ANCHOR_CHARGES: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly HANGING: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly TILT: Internal.EnumProperty<Internal.Tilt>;
    static readonly STABILITY_DISTANCE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_4_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly HAS_BOTTLE_2: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly LAYERS: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly SOUTH_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly CRACKED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CONDITIONAL: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly LOCKED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly POWER: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly EYE: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SOUTH_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly MAX_AGE_1: (1) & (number);
    static readonly ATTACHED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MAX_LEVEL_15: (15) & (number);
    static readonly BELL_ATTACHMENT: Internal.EnumProperty<Internal.BellAttachType>;
    static readonly MAX_DISTANCE: (7) & (number);
    static readonly FLOWER_AMOUNT: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly EXTENDED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly INVERTED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MODE_COMPARATOR: Internal.EnumProperty<Internal.ComparatorMode>;
    static readonly MOISTURE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly LIT: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly DISTANCE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly NORTH_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly AGE_3: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly STAIRS_SHAPE: Internal.EnumProperty<Internal.StairsShape>;
    static readonly MAX_LEVEL_8: (8) & (number);
    static readonly MIN_RESPAWN_ANCHOR_CHARGES: (0) & (number);
    static readonly BAMBOO_LEAVES: Internal.EnumProperty<Internal.BambooLeaves>;
    static readonly HORIZONTAL_AXIS: Internal.EnumProperty<Internal.Direction$Axis>;
    static readonly FALLING: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly ENABLED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly ATTACH_FACE: Internal.EnumProperty<Internal.AttachFace>;
    static readonly OPEN: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly UNSTABLE: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_4: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly EAST: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly ORIENTATION: Internal.EnumProperty<Internal.FrontAndTop>;
    static readonly DOUBLE_BLOCK_HALF: Internal.EnumProperty<Internal.DoubleBlockHalf>;
    static readonly MAX_RESPAWN_ANCHOR_CHARGES: (4) & (number);
    static readonly CHEST_TYPE: Internal.EnumProperty<Internal.ChestType>;
    static readonly MAX_AGE_7: (7) & (number);
    static readonly DOWN: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_2_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_15: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly STRUCTUREBLOCK_MODE: Internal.EnumProperty<Internal.StructureMode>;
    static readonly SLAB_TYPE: Internal.EnumProperty<Internal.SlabType>;
    static readonly EAST_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly WATERLOGGED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly BLOOM: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SHRIEKING: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_1: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly FACING_HOPPER: (Internal.DirectionProperty) & (Internal.DirectionProperty);
    static readonly VERTICAL_DIRECTION: (Internal.DirectionProperty) & (Internal.DirectionProperty);
    static readonly PICKLES: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MAX_AGE_25: (25) & (number);
    static readonly LEVEL_HONEY: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly DUSTED: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MAX_AGE_4: (4) & (number);
    static readonly PISTON_TYPE: Internal.EnumProperty<Internal.PistonType>;
    static readonly HATCH: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly SNOWY: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly TRIGGERED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_1_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SIGNAL_FIRE: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly LEVEL_CAULDRON: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly AXIS: Internal.EnumProperty<Internal.Direction$Axis>;
    static readonly AGE_2: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly DRAG: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CAN_SUMMON: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly LEVEL: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly STAGE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MAX_AGE_5: (5) & (number);
    static readonly NORTH_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly UP: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_0_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly BITES: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly IN_WALL: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_25: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly STABILITY_MAX_DISTANCE: (7) & (number);
    static readonly HAS_BOTTLE_1: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_7: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_3_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SOUTH: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MAX_AGE_15: (15) & (number);
    static readonly DISARMED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly RAIL_SHAPE: Internal.EnumProperty<Internal.RailShape>;
    static readonly DOOR_HINGE: Internal.EnumProperty<Internal.DoorHingeSide>;
    static readonly LEVEL_COMPOSTER: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly DELAY: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MIN_LEVEL: (0) & (number);
    static readonly RAIL_SHAPE_STRAIGHT: Internal.EnumProperty<Internal.RailShape>;
    static readonly MIN_LEVEL_CAULDRON: (1) & (number);
    static readonly BOTTOM: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly HAS_BOOK: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CANDLES: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly NOTEBLOCK_INSTRUMENT: Internal.EnumProperty<Internal.NoteBlockInstrument>;
    static readonly WEST: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SHORT: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly BERRIES: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MAX_AGE_2: (2) & (number);
    static readonly HAS_BOTTLE_0: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly WEST_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly ROTATION_16: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MAX_LEVEL_3: (3) & (number);
    static readonly BED_PART: Internal.EnumProperty<Internal.BedPart>;
    static readonly POWERED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MAX_AGE_3: (3) & (number);
    static readonly OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly DRIPSTONE_THICKNESS: Internal.EnumProperty<Internal.DripstoneThickness>;
    static readonly FACING: (Internal.DirectionProperty) & (Internal.DirectionProperty);
}
type BlockProperties_ = BlockProperties;
declare class OverlayTexture implements Internal.AutoCloseable {
    constructor()
    getClass(): typeof any;
    static "pack(int,int)"(arg0: number, arg1: number): number;
    toString(): string;
    notifyAll(): void;
    static "pack(float,boolean)"(arg0: number, arg1: boolean): number;
    teardownOverlayColor(): void;
    static v(arg0: boolean): number;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    static pack(arg0: number, arg1: number): number;
    hashCode(): number;
    static pack(arg0: number, arg1: boolean): number;
    wait(): void;
    close(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    static u(arg0: number): number;
    setupOverlayColor(): void;
    get class(): typeof any
    static readonly NO_OVERLAY: (655360) & (number);
    static readonly WHITE_OVERLAY_V: (10) & (number);
    static readonly NO_WHITE_U: (0) & (number);
    static readonly RED_OVERLAY_V: (3) & (number);
}
type OverlayTexture_ = OverlayTexture;
declare class LootType extends Internal.Enum<LootType> {
    static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
    getClass(): typeof any;
    static values(): LootType[];
    toString(): string;
    notifyAll(): void;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    compareTo(arg0: any): number;
    "compareTo(com.almostreliable.lootjs.core.LootContextType)"(arg0: LootType_): number;
    name(): string;
    getDeclaringClass(): typeof LootType;
    hashCode(): number;
    ordinal(): number;
    wait(): void;
    describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<LootType>>;
    compareTo(arg0: LootType_): number;
    wait(arg0: number): void;
    "compareTo(java.lang.Object)"(arg0: any): number;
    equals(arg0: any): boolean;
    static valueOf(name: string): LootType;
    get class(): typeof any
    get declaringClass(): typeof LootType
    static readonly ADVANCEMENT_ENTITY: (LootType) & (LootType);
    static readonly ENTITY: (LootType) & (LootType);
    static readonly CHEST: (LootType) & (LootType);
    static readonly FISHING: (LootType) & (LootType);
    static readonly GIFT: (LootType) & (LootType);
    static readonly ADVANCEMENT_REWARD: (LootType) & (LootType);
    static readonly UNKNOWN: (LootType) & (LootType);
    static readonly BLOCK: (LootType) & (LootType);
    static readonly PIGLIN_BARTER: (LootType) & (LootType);
}
type LootType_ = "advancement_reward" | "gift" | "piglin_barter" | LootType | "block" | "advancement_entity" | "entity" | "unknown" | "chest" | "fishing";
declare interface CuriosRenderer {
    followBodyRotations(arg0: Internal.LivingEntity_, ...arg1: Internal.HumanoidModel_<Internal.LivingEntity>[]): void;
    translateIfSneaking(arg0: Internal.PoseStack_, arg1: Internal.LivingEntity_): void;
    rotateIfSneaking(arg0: Internal.PoseStack_, arg1: Internal.LivingEntity_): void;
    abstract render<T extends Internal.LivingEntity, M extends Internal.EntityModel<T>>(arg0: Internal.ItemStack_, arg1: Internal.SlotContext_, arg2: Internal.PoseStack_, arg3: Internal.RenderLayerParent_<T, M>, arg4: Internal.MultiBufferSource_, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number): void;
    followHeadRotations(arg0: Internal.LivingEntity_, ...arg1: Internal.ModelPart_[]): void;
    (arg0: Internal.ItemStack, arg1: Internal.SlotContext, arg2: Internal.PoseStack, arg3: Internal.RenderLayerParent<T, M>, arg4: Internal.MultiBufferSource, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number): void;
}
type CuriosRenderer_ = CuriosRenderer | ((arg0: Internal.ItemStack, arg1: Internal.SlotContext, arg2: Internal.PoseStack, arg3: Internal.RenderLayerParent<T, M>, arg4: Internal.MultiBufferSource, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number)=> void);
declare const CuriosRenderer: CuriosRenderer;
declare interface NBT {
    accessTagMap(tag: Internal.CompoundTag_): Internal.Map<string, Internal.Tag>;
    read(buf: Internal.FriendlyByteBuf_): Internal.OrderedCompoundTag;
    toJson(t: Internal.Tag_): Internal.JsonElement;
    toTagCollection(c: Internal.Collection_<any>): Internal.CollectionTag<any>;
    l(v: number): Internal.Tag;
    quoteAndEscapeForJS(stringBuilder: Internal.StringBuilder_, string: string): void;
    b(v: number): Internal.Tag;
    byteArrayTag(v: number[]): Internal.Tag;
    listTag(): Internal.Tag;
    floatTag(v: number): Internal.Tag;
    s(v: number): Internal.Tag;
    byteTag(v: number): Internal.Tag;
    listTag(list: Internal.List_<any>): Internal.Tag;
    ia(v: number[]): Internal.Tag;
    d(v: number): Internal.Tag;
    longArrayTag(v: number[]): Internal.Tag;
    isTagCollection(o: any): boolean;
    "toTagCollection(java.util.Collection)"(c: Internal.Collection_<any>): Internal.CollectionTag<any>;
    longTag(v: number): Internal.Tag;
    compoundTag(): Internal.Tag;
    intTag(v: number): Internal.Tag;
    shortTag(v: number): Internal.Tag;
    stringTag(v: string): Internal.Tag;
    la(v: number[]): Internal.Tag;
    convertType(tagType: Internal.TagType_<any>): Internal.TagType<any>;
    toTagCollection(v: any): Internal.CollectionTag<any>;
    f(v: number): Internal.Tag;
    fromTag(t: Internal.Tag_): any;
    toTag(v: any): Internal.Tag;
    toTagCompound(v: any): Internal.CompoundTag;
    toTagList(list: any): Internal.ListTag;
    isTagCompound(o: any): boolean;
    doubleTag(v: number): Internal.Tag;
    intArrayTag(v: number[]): Internal.Tag;
    ba(v: number[]): Internal.Tag;
    compoundTag(map: Internal.Map_<any, any>): Internal.Tag;
    i(v: number): Internal.Tag;
    "toTagCollection(java.lang.Object)"(v: any): Internal.CollectionTag<any>;
    readonly VALUE_UNWRAPPER: Internal.ValueUnwrapper;
    readonly LIST_TYPE: Internal.TagType<Internal.ListTag>;
    readonly COMPOUND_TYPE: Internal.TagType<Internal.OrderedCompoundTag>;
}
type NBT_ = NBT;
declare const NBT: NBT;
declare class Vec3i implements Internal.Comparable<Vec3i> {
    constructor(arg0: number, arg1: number, arg2: number)
    north(): this;
    getClass(): typeof any;
    distToCenterSqr(arg0: Internal.Position_): number;
    getX(): number;
    static offsetCodec(arg0: number): Internal.Codec<Vec3i>;
    getY(): number;
    south(arg0: number): this;
    toShortString(): string;
    above(arg0: number): this;
    notify(): void;
    west(arg0: number): this;
    wait(arg0: number, arg1: number): void;
    compareTo(arg0: any): number;
    east(arg0: number): this;
    distToLowCornerSqr(arg0: number, arg1: number, arg2: number): number;
    "relative(net.minecraft.core.Direction$Axis,int)"(arg0: Internal.Direction$Axis_, arg1: number): this;
    relative(arg0: Internal.Direction_): this;
    multiply(arg0: number): this;
    getZ(): number;
    closerThan(arg0: Vec3i_, arg1: number): boolean;
    below(arg0: number): this;
    offset(arg0: number, arg1: number, arg2: number): this;
    above(): this;
    toString(): string;
    "compareTo(net.minecraft.core.Vec3i)"(arg0: Vec3i_): number;
    north(arg0: number): this;
    east(): this;
    below(): this;
    notifyAll(): void;
    distManhattan(arg0: Vec3i_): number;
    west(): this;
    relative(arg0: Internal.Direction$Axis_, arg1: number): this;
    get(arg0: Internal.Direction$Axis_): number;
    offset(arg0: Vec3i_): this;
    cross(arg0: Vec3i_): this;
    south(): this;
    hashCode(): number;
    distSqr(arg0: Vec3i_): number;
    subtract(arg0: Vec3i_): this;
    relative(arg0: Internal.Direction_, arg1: number): this;
    wait(): void;
    wait(arg0: number): void;
    compareTo(arg0: Vec3i_): number;
    "compareTo(java.lang.Object)"(arg0: any): number;
    equals(arg0: any): boolean;
    closerToCenterThan(arg0: Internal.Position_, arg1: number): boolean;
    "relative(net.minecraft.core.Direction,int)"(arg0: Internal.Direction_, arg1: number): this;
    distToCenterSqr(arg0: number, arg1: number, arg2: number): number;
    get class(): typeof any
    get x(): number
    get y(): number
    get z(): number
    static readonly ZERO: (Vec3i) & (Vec3i);
    static readonly CODEC: Internal.Codec<Vec3i>;
}
type Vec3i_ = Vec3i;
declare interface ForgeItemFilter extends ItemFilter {
    hasEnchantment(filter: Internal.ResourceLocationFilter_, min: number, max: number): ItemFilter;
    abstract "test(net.minecraft.world.item.ItemStack)"(arg0: Internal.ItemStack_): boolean;
    isEqual<T>(arg0: any): Internal.Predicate<T>;
    "not(com.almostreliable.lootjs.filters.ItemFilter)"(itemFilter: ItemFilter_): ItemFilter;
    and(...itemFilters: ItemFilter_[]): ItemFilter;
    test(arg0: any): boolean;
    and(other: ItemFilter_): ItemFilter;
    not(itemFilter: ItemFilter_): ItemFilter;
    or(...itemFilters: ItemFilter_[]): ItemFilter;
    or(other: ItemFilter_): ItemFilter;
    "test(java.lang.Object)"(arg0: any): boolean;
    "and(java.util.function.Predicate)"(arg0: Internal.Predicate_<Internal.ItemStack>): Internal.Predicate<Internal.ItemStack>;
    not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
    "or(com.almostreliable.lootjs.filters.ItemFilter)"(other: ItemFilter_): ItemFilter;
    negate(): Internal.Predicate<any>;
    hasEnchantment(filter: Internal.ResourceLocationFilter_): ItemFilter;
    "not(java.util.function.Predicate)"<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
    "and(com.almostreliable.lootjs.filters.ItemFilter[])"(...itemFilters: ItemFilter_[]): ItemFilter;
    canPerformAnyAction(...actions: string[]): ItemFilter;
    equipmentSlot(slot: Internal.EquipmentSlot_): ItemFilter;
    "or(com.almostreliable.lootjs.filters.ItemFilter[])"(...itemFilters: ItemFilter_[]): ItemFilter;
    or(arg0: Internal.Predicate_<Internal.ItemStack>): Internal.Predicate<Internal.ItemStack>;
    "or(java.util.function.Predicate)"(arg0: Internal.Predicate_<Internal.ItemStack>): Internal.Predicate<Internal.ItemStack>;
    abstract test(arg0: Internal.ItemStack_): boolean;
    custom(predicate: Internal.Predicate_<Internal.ItemStack>): ItemFilter;
    canPerformAction(...actions: string[]): ItemFilter;
    "and(com.almostreliable.lootjs.filters.ItemFilter)"(other: ItemFilter_): ItemFilter;
    and(arg0: Internal.Predicate_<Internal.ItemStack>): Internal.Predicate<Internal.ItemStack>;
}
type ForgeItemFilter_ = ForgeItemFilter;
declare const ForgeItemFilter: ForgeItemFilter;
declare interface FluidAmounts {
    readonly MILLIBUCKET: (1) & (number);
    readonly MB: (1) & (number);
    readonly INGOT: (90) & (number);
    readonly BOTTLE: (250) & (number);
    readonly B: (1000) & (number);
    readonly NUGGET: (10) & (number);
    readonly METAL_BLOCK: (810) & (number);
    readonly BUCKET: (1000) & (number);
}
type FluidAmounts_ = FluidAmounts;
declare const FluidAmounts: FluidAmounts;
declare class Matrix3f implements Internal.Cloneable, Internal.Matrix3fc, Internal.Externalizable {
    constructor(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_)
    constructor()
    constructor(arg0: Internal.Matrix3fc_)
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: Internal.Matrix2fc_)
    constructor(arg0: Internal.Matrix4fc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number)
    rotateLocalY(arg0: number, arg1: Matrix3f_): this;
    setColumn(arg0: number, arg1: Internal.Vector3fc_): this;
    mapnZnXY(): this;
    rotate(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
    mapZXnY(): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapYXnZ(arg0: Matrix3f_): this;
    "getUnnormalizedRotation(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    mapnYnXZ(arg0: Matrix3f_): this;
    "scale(float)"(arg0: number): this;
    "getTransposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix3f_): this;
    mapYnXnZ(arg0: Matrix3f_): this;
    "getNormalizedRotation(org.joml.Quaternionf)"(arg0: Quaternionf_): Quaternionf;
    "set(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): this;
    negateZ(arg0: Matrix3f_): this;
    getUnnormalizedRotation(arg0: Quaternionf_): Quaternionf;
    "get(int,int)"(arg0: number, arg1: number): number;
    mapXnYnZ(): this;
    mapnYnZX(): this;
    m20(arg0: number): this;
    set(arg0: Internal.Matrix4fc_): this;
    rotationZ(arg0: number): this;
    mapnYnXnZ(arg0: Matrix3f_): this;
    transformTranspose(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZYnX(): this;
    sub(arg0: Internal.Matrix3fc_): this;
    setLookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "rotate(float,org.joml.Vector3fc)"(arg0: number, arg1: Internal.Vector3fc_): this;
    getNormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    "get(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    setColumn(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnYnZnX(): this;
    getRowColumn(arg0: number, arg1: number): number;
    positiveZ(arg0: Vec3f_): Vec3f;
    mapnYZX(arg0: Matrix3f_): this;
    mapnXnZY(arg0: Matrix3f_): this;
    rotateZ(arg0: number, arg1: Matrix3f_): this;
    mapXZY(arg0: Matrix3f_): this;
    mapYZnX(): this;
    mapnZnYX(arg0: Matrix3f_): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    rotateLocalZ(arg0: number, arg1: Matrix3f_): this;
    getClass(): typeof any;
    rotateLocal(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    setLookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mapZYX(): this;
    mapYnZnX(): this;
    mapnXnYnZ(): this;
    obliqueZ(arg0: number, arg1: number, arg2: Matrix3f_): this;
    scale(arg0: number): this;
    set(arg0: Internal.Matrix3fc_): this;
    m20(): number;
    reflect(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    mapnXnYZ(): this;
    "rotate(org.joml.AxisAngle4f,org.joml.Matrix3f)"(arg0: Internal.AxisAngle4f_, arg1: Matrix3f_): this;
    get(arg0: Matrix4f_): Matrix4f;
    rotation(arg0: number, arg1: Internal.Vector3fc_): this;
    set(arg0: Internal.AxisAngle4d_): this;
    mul(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    rotate(arg0: Internal.AxisAngle4f_): this;
    rotationXYZ(arg0: number, arg1: number, arg2: number): this;
    m21(arg0: number): this;
    rotationY(arg0: number): this;
    "get3x4(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnXYnZ(): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number): this;
    getTransposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapZnYX(): this;
    mapnYZnX(arg0: Matrix3f_): this;
    cofactor(arg0: Matrix3f_): this;
    set(arg0: Internal.ByteBuffer_): this;
    setTransposed(arg0: Internal.Matrix3fc_): this;
    getScale(arg0: Vec3f_): Vec3f;
    mapXnZY(arg0: Matrix3f_): this;
    transform(arg0: Vec3f_): Vec3f;
    rotateY(arg0: number, arg1: Matrix3f_): this;
    mapYnZX(): this;
    "scale(org.joml.Vector3fc,org.joml.Matrix3f)"(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    mapnXZY(arg0: Matrix3f_): this;
    "scale(float,org.joml.Matrix3f)"(arg0: number, arg1: Matrix3f_): this;
    wait(arg0: number): void;
    set(arg0: Internal.Quaterniondc_): this;
    scale(arg0: Internal.Vector3fc_): this;
    normal(arg0: Matrix3f_): this;
    mapZYnX(): this;
    rotation(arg0: number, arg1: number, arg2: number, arg3: number): this;
    setRow(arg0: number, arg1: Internal.Vector3fc_): this;
    scaling(arg0: number, arg1: number, arg2: number): this;
    set(arg0: number, arg1: number, arg2: number): this;
    reflect(arg0: Internal.Quaternionfc_): this;
    rotateLocalY(arg0: number): this;
    "get(org.joml.Matrix3f)"(arg0: Matrix3f_): this;
    rotationTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    set(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    m21(): number;
    sub(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    set(arg0: Internal.AxisAngle4f_): this;
    isFinite(): boolean;
    get3x4(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapZnYX(arg0: Matrix3f_): this;
    mapnYZX(): this;
    transpose(arg0: Matrix3f_): this;
    rotation(arg0: Internal.Quaternionfc_): this;
    mapnXnYZ(arg0: Matrix3f_): this;
    mapnXnZnY(): this;
    "set(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    mapXnZnY(): this;
    m10(): number;
    "set(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    mapZXY(arg0: Matrix3f_): this;
    rotationX(arg0: number): this;
    rotate(arg0: Internal.AxisAngle4f_, arg1: Matrix3f_): this;
    mapYnXZ(): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    getToAddress(arg0: number): Internal.Matrix3fc;
    reflect(arg0: number, arg1: number, arg2: number): this;
    get(arg0: number, arg1: number): number;
    setRow(arg0: number, arg1: number, arg2: number, arg3: number): this;
    wait(): void;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    get3x4(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.FloatBuffer_): this;
    mapnZnXnY(arg0: Matrix3f_): this;
    mapXZnY(arg0: Matrix3f_): this;
    rotateLocalX(arg0: number, arg1: Matrix3f_): this;
    mulLocal(arg0: Internal.Matrix3fc_): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    transform(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    mapnYXnZ(arg0: Matrix3f_): this;
    transformTranspose(arg0: Vec3f_): Vec3f;
    "rotation(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    rotateLocalZ(arg0: number): this;
    lerp(arg0: Internal.Matrix3fc_, arg1: number, arg2: Matrix3f_): this;
    m22(): number;
    mapYXnZ(): this;
    mapZnYnX(arg0: Matrix3f_): this;
    "rotation(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    mapYXZ(arg0: Matrix3f_): this;
    reflection(arg0: number, arg1: number, arg2: number): this;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "getTransposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapnZXnY(): this;
    invert(): this;
    m11(): number;
    getTransposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapZnXnY(arg0: Matrix3f_): this;
    rotateXYZ(arg0: Vec3f_): this;
    rotate(arg0: number, arg1: Internal.Vector3fc_): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnXnZY(): this;
    negateZ(): this;
    getNormalizedRotation(arg0: Quaternionf_): Quaternionf;
    mapnZnYnX(arg0: Matrix3f_): this;
    equals(arg0: any): boolean;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix3f_): this;
    mapXZY(): this;
    m00(): number;
    mapYnZX(arg0: Matrix3f_): this;
    "set(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_): this;
    "scaling(float)"(arg0: number): this;
    get3x4(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnZXY(): this;
    "scaling(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    scale(arg0: number, arg1: number, arg2: number): this;
    "reflect(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    identity(): this;
    scaling(arg0: Internal.Vector3fc_): this;
    mulLocal(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    mapXZnY(): this;
    "get3x4(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    reflect(arg0: Internal.Vector3fc_): this;
    "getNormalizedRotation(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    mul(arg0: Internal.Matrix3fc_): this;
    setFromAddress(arg0: number): this;
    mapnZnYnX(): this;
    m01(arg0: number): this;
    "set(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    rotate(arg0: Internal.Quaternionfc_): this;
    get3x4(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapZnYnX(): this;
    mapnZYnX(arg0: Matrix3f_): this;
    m12(): number;
    normal(): this;
    mapZYnX(arg0: Matrix3f_): this;
    scaleLocal(arg0: number, arg1: number, arg2: number): this;
    mapnXZY(): this;
    "get(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    normalizedPositiveX(arg0: Vec3f_): Vec3f;
    "rotate(org.joml.Quaternionfc,org.joml.Matrix3f)"(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    get(arg0: number[]): number[];
    negateY(): this;
    getColumn(arg0: number, arg1: Vec3f_): Vec3f;
    toString(arg0: Internal.NumberFormat_): string;
    "get(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnXYnZ(arg0: Matrix3f_): this;
    mapnYXnZ(): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number): this;
    get(arg0: number[], arg1: number): number[];
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix3f_): this;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    mapnXnYnZ(arg0: Matrix3f_): this;
    mapZYX(arg0: Matrix3f_): this;
    "scale(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    m12(arg0: number): this;
    clone(): any;
    m01(): number;
    mapnYnZX(arg0: Matrix3f_): this;
    setRowColumn(arg0: number, arg1: number, arg2: number): this;
    quadraticFormProduct(arg0: Internal.Vector3fc_): number;
    "set(int,int,float)"(arg0: number, arg1: number, arg2: number): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    getRotation(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    "get(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    reflection(arg0: Internal.Quaternionfc_): this;
    mapnYnZnX(arg0: Matrix3f_): this;
    transformTranspose(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    rotateZYX(arg0: Vec3f_): this;
    rotateLocalX(arg0: number): this;
    mapnZnXnY(): this;
    "reflection(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    m02(arg0: number): this;
    getTransposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    scale(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    rotationTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZnXY(arg0: Matrix3f_): this;
    mapnYnXZ(): this;
    mapnXZnY(): this;
    mapYZX(): this;
    "get3x4(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapnYXZ(): this;
    mulComponentWise(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    mapZXnY(arg0: Matrix3f_): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    rotationYXZ(arg0: number, arg1: number, arg2: number): this;
    negateX(): this;
    "set(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    "set(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): this;
    toString(): string;
    rotateLocal(arg0: Internal.Quaternionfc_): this;
    mapnZYX(arg0: Matrix3f_): this;
    normalizedPositiveY(arg0: Vec3f_): Vec3f;
    notifyAll(): void;
    mapYZnX(arg0: Matrix3f_): this;
    mapnZnYX(): this;
    "set(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    getRow(arg0: number, arg1: Vec3f_): Vec3f;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix3f_): this;
    mapnZXnY(arg0: Matrix3f_): this;
    mapZnXY(arg0: Matrix3f_): this;
    "reflect(org.joml.Vector3fc,org.joml.Matrix3f)"(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    reflection(arg0: Internal.Vector3fc_): this;
    rotateX(arg0: number): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix3f_): this;
    mapnXZnY(arg0: Matrix3f_): this;
    "rotate(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    mapYXZ(): this;
    setSkewSymmetric(arg0: number, arg1: number, arg2: number): this;
    "rotate(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    rotateZYX(arg0: number, arg1: number, arg2: number): this;
    notify(): void;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number): this;
    m02(): number;
    mapZnXnY(): this;
    "set(org.joml.Vector3fc,org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "set(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    negateX(arg0: Matrix3f_): this;
    mapnYZnX(): this;
    m22(arg0: number): this;
    mulComponentWise(arg0: Internal.Matrix3fc_): this;
    invert(arg0: Matrix3f_): this;
    normalizedPositiveZ(arg0: Vec3f_): Vec3f;
    reflect(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    "getTransposed(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    readExternal(arg0: Internal.ObjectInput_): void;
    mapnZYX(): this;
    scaleLocal(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
    get(arg0: Matrix3f_): this;
    "get(float[],int)"(arg0: number[], arg1: number): number[];
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotateX(arg0: number, arg1: Matrix3f_): this;
    positiveX(arg0: Vec3f_): Vec3f;
    "getTransposed(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotateYXZ(arg0: Vec3f_): this;
    determinant(): number;
    add(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    transpose(): this;
    "set(float[])"(arg0: number[]): this;
    "reflect(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    mapYnZnX(arg0: Matrix3f_): this;
    m10(arg0: number): this;
    "set(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): this;
    rotateY(arg0: number): this;
    rotation(arg0: Internal.AxisAngle4f_): this;
    "reflect(org.joml.Quaternionfc,org.joml.Matrix3f)"(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    add(arg0: Internal.Matrix3fc_): this;
    scale(arg0: number, arg1: Matrix3f_): this;
    lerp(arg0: Internal.Matrix3fc_, arg1: number): this;
    rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    mapYnXZ(arg0: Matrix3f_): this;
    mapnZXY(arg0: Matrix3f_): this;
    "get3x4(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    scale(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    mapZnXY(): this;
    wait(arg0: number, arg1: number): void;
    cofactor(): this;
    mapnYnXnZ(): this;
    quadraticFormProduct(arg0: number, arg1: number, arg2: number): number;
    "get(float[])"(arg0: number[]): number[];
    "set(org.joml.Matrix2fc)"(arg0: Internal.Matrix2fc_): this;
    "set(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix3f_): this;
    swap(arg0: Matrix3f_): this;
    mapXnZnY(arg0: Matrix3f_): this;
    set(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "reflection(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    obliqueZ(arg0: number, arg1: number): this;
    negateY(arg0: Matrix3f_): this;
    getUnnormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    rotate(arg0: number, arg1: Internal.Vector3fc_, arg2: Matrix3f_): this;
    getTransposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    m00(arg0: number): this;
    mapXnYnZ(arg0: Matrix3f_): this;
    mapXnZY(): this;
    "get(org.joml.Matrix4f)"(arg0: Matrix4f_): Matrix4f;
    equals(arg0: Internal.Matrix3fc_, arg1: number): boolean;
    mapYZX(arg0: Matrix3f_): this;
    set(arg0: Internal.Matrix4x3fc_): this;
    set(arg0: Internal.Matrix2fc_): this;
    mapnXnZnY(arg0: Matrix3f_): this;
    rotateZ(arg0: number): this;
    "getUnnormalizedRotation(org.joml.Quaternionf)"(arg0: Quaternionf_): Quaternionf;
    hashCode(): number;
    rotationZYX(arg0: number, arg1: number, arg2: number): this;
    positiveY(arg0: Vec3f_): Vec3f;
    mapYnXnZ(): this;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    mapZXY(): this;
    mapnYXZ(arg0: Matrix3f_): this;
    scaling(arg0: number): this;
    set(arg0: number[]): this;
    zero(): this;
    set(arg0: Internal.Quaternionfc_): this;
    m11(arg0: number): this;
    set "(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_)
    get class(): typeof any
    set transposed(arg0: Internal.Matrix3fc_)
    get finite(): boolean
    set "(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_)
    set "(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set "(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_)
    set fromAddress(arg0: number)
    set "(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_)
    set "(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set "(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_)
    set "(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_)
    set "(float[])"(arg0: number[])
    set "(org.joml.Matrix2fc)"(arg0: Internal.Matrix2fc_)
    set "(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    m10: number;
    m21: number;
    m20: number;
    m01: number;
    m12: number;
    m00: number;
    m11: number;
    m22: number;
    m02: number;
}
type Matrix3f_ = Matrix3f;
declare class Matrix4f implements Internal.Cloneable, Internal.Matrix4fc, Internal.Externalizable {
    constructor()
    constructor(arg0: Internal.Matrix3fc_)
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number)
    constructor(arg0: Internal.Matrix4dc_)
    constructor(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Internal.Vector4fc_, arg3: Internal.Vector4fc_)
    constructor(arg0: Internal.Matrix4fc_)
    constructor(arg0: Internal.Matrix4x3fc_)
    scaleXY(arg0: number, arg1: number, arg2: Matrix4f_): this;
    setLookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    rotateAffineXYZ(arg0: number, arg1: number, arg2: number): this;
    translationRotateScale(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    transformProject(arg0: Internal.Vector4fc_, arg1: Vec3f_): Vec3f;
    testSphere(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
    zero(): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number): this;
    m32(arg0: number): this;
    "get4x3(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    obliqueZ(arg0: number, arg1: number, arg2: Matrix4f_): this;
    "orthoLH(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mapYXnZ(arg0: Matrix4f_): this;
    setTransposedFromAddress(arg0: number): this;
    "get(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "perspectiveRect(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    getRowColumn(arg0: number, arg1: number): number;
    "normalize3x3(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    "set(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): this;
    "unprojectInv(float,float,float,int[],org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    billboardSpherical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "set(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): this;
    lookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: Matrix4f_): this;
    "mulPerspectiveAffine(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    "normal(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    "project(org.joml.Vector3fc,int[],org.joml.Vector4f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    rotateX(arg0: number, arg1: Matrix4f_): this;
    mul0(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    m10(arg0: number): this;
    mapZYnX(): this;
    rotateLocalY(arg0: number, arg1: Matrix4f_): this;
    set(arg0: Internal.Matrix3fc_): this;
    invertAffine(arg0: Matrix4f_): this;
    arcball(arg0: number, arg1: Internal.Vector3fc_, arg2: number, arg3: number, arg4: Matrix4f_): this;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number): this;
    m32(): number;
    unproject(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    "frustumLH(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapZnYX(): this;
    mapYnXnZ(arg0: Matrix4f_): this;
    shadow(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number): this;
    normal(arg0: Matrix3f_): Matrix3f;
    m21(arg0: number): this;
    lerp(arg0: Internal.Matrix4fc_, arg1: number, arg2: Matrix4f_): this;
    rotationY(arg0: number): this;
    getRotation(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    rotate(arg0: Internal.AxisAngle4f_, arg1: Matrix4f_): this;
    tile(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "unproject(org.joml.Vector3fc,int[],org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    "ortho(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    m21(): number;
    isFinite(): boolean;
    transformProject(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    m30(arg0: number): this;
    setRotationYXZ(arg0: number, arg1: number, arg2: number): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mul(arg0: Internal.Matrix4fc_): this;
    rotateAffineZYX(arg0: number, arg1: number, arg2: number): this;
    m10(): number;
    set(arg0: number, arg1: number, arg2: number): this;
    mapnZnXnY(): this;
    setPerspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    "get3x3(org.joml.Matrix3d)"(arg0: Internal.Matrix3d_): Internal.Matrix3d;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    mapYXZ(arg0: Matrix4f_): this;
    "get4x3Transposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotation(arg0: Internal.Quaternionfc_): this;
    rotateAffine(arg0: Internal.Quaternionfc_): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    get4x3Transposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    transpose3x3(arg0: Matrix3f_): Matrix3f;
    translate(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): this;
    "transformProject(org.joml.Vector4fc,org.joml.Vector3f)"(arg0: Internal.Vector4fc_, arg1: Vec3f_): Vec3f;
    ortho2DLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    "set4x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    rotateTranslation(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    mapYZnX(): this;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    scaleLocal(arg0: number): this;
    rotateZ(arg0: number, arg1: Matrix4f_): this;
    setTransposed(arg0: Internal.FloatBuffer_): this;
    set(arg0: Internal.FloatBuffer_): this;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    unprojectInv(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    "getRow(int,org.joml.Vector4f)"(arg0: number, arg1: Vec4f_): Vec4f;
    perspectiveInvOrigin(arg0: Vec3f_): Vec3f;
    transformTranspose(arg0: Vec4f_): Vec4f;
    rotationTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mapnYnXZ(arg0: Matrix4f_): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapZnYX(arg0: Matrix4f_): this;
    mapnZXnY(): this;
    "shadow(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    getToAddress(arg0: number): Internal.Matrix4fc;
    mapnXZY(): this;
    rotateAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number): this;
    transformProject(arg0: Vec4f_): Vec4f;
    "set(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    negateZ(): this;
    m23(): number;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    equals(arg0: Internal.Matrix4fc_, arg1: number): boolean;
    lookAtPerspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    lookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: Matrix4f_): this;
    setOrthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    "get4x3Transposed(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnYnZX(arg0: Matrix4f_): this;
    m12(): number;
    "getColumn(int,org.joml.Vector4f)"(arg0: number, arg1: Vec4f_): Vec4f;
    translationRotate(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_): this;
    "reflect(org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "orthoSymmetricLH(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    setFrustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    normalizedPositiveX(arg0: Vec3f_): Vec3f;
    mapXZY(): this;
    transformDirection(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    getColumn(arg0: number, arg1: Vec3f_): Vec3f;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number): this;
    unprojectRay(arg0: Internal.Vector2fc_, arg1: number[], arg2: Vec3f_, arg3: Vec3f_): this;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    reflection(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "transformProject(float,float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    "mul(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    m01(arg0: number): this;
    mapYXnZ(): this;
    m01(): number;
    "get(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mul(arg0: Internal.Matrix3x2fc_, arg1: Matrix4f_): this;
    mapYZnX(arg0: Matrix4f_): this;
    "translationRotateScaleInvert(org.joml.Vector3fc,org.joml.Quaternionfc,float)"(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    translate(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    mapnZXnY(arg0: Matrix4f_): this;
    mapZnXY(arg0: Matrix4f_): this;
    transformAab(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Vec3f_, arg7: Vec3f_): this;
    invertOrtho(): this;
    "scaling(float)"(arg0: number): this;
    transform(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "get4x3Transposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotateLocalY(arg0: number): this;
    billboardCylindrical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "scaling(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    getRow(arg0: number, arg1: Vec3f_): Vec3f;
    rotationTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    setPerspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "ortho(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mapnYXZ(): this;
    setFromIntrinsic(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    negateX(): this;
    setColumn(arg0: number, arg1: Internal.Vector4fc_): this;
    fma4x3(arg0: Internal.Matrix4fc_, arg1: number, arg2: Matrix4f_): this;
    notify(): void;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    get4x3(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    translationRotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): this;
    rotateYXZ(arg0: Vec3f_): this;
    mapnYXZ(arg0: Matrix4f_): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "reflection(org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    setLookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    cofactor3x3(arg0: Matrix4f_): this;
    normalizedPositiveZ(arg0: Vec3f_): Vec3f;
    "rotate(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    scale(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    translationRotateScaleMulAffine(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_, arg3: Matrix4f_): this;
    "orthoSymmetric(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    rotate(arg0: Internal.Quaternionfc_): this;
    invertOrtho(arg0: Matrix4f_): this;
    mapYZX(arg0: Matrix4f_): this;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    m03(): number;
    "get(float[])"(arg0: number[]): number[];
    unprojectInv(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    translationRotateScaleMulAffine(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: Matrix4f_): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number): this;
    rotationZYX(arg0: number, arg1: number, arg2: number): this;
    cofactor3x3(): this;
    scaleXY(arg0: number, arg1: number): this;
    rotation(arg0: Internal.AxisAngle4f_): this;
    m12(arg0: number): this;
    translateLocal(arg0: Internal.Vector3fc_): this;
    rotateAffineYXZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    scaling(arg0: number): this;
    mapZnXY(): this;
    "setTransposed(float[])"(arg0: number[]): this;
    "unprojectInv(org.joml.Vector3fc,int[],org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    "transformProject(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    project(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    hashCode(): number;
    positiveY(arg0: Vec3f_): Vec3f;
    negateX(arg0: Matrix4f_): this;
    setOrtho2D(arg0: number, arg1: number, arg2: number, arg3: number): this;
    translation(arg0: Internal.Vector3fc_): this;
    translationRotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    m23(arg0: number): this;
    "set(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    "orthoSymmetric(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mul3x3(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    setRow(arg0: number, arg1: Internal.Vector4fc_): this;
    project(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
    trapezoidCrop(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    translationRotate(arg0: number, arg1: number, arg2: number, arg3: Internal.Quaternionfc_): this;
    transformPosition(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    setOrtho2DLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    unprojectInvRay(arg0: number, arg1: number, arg2: number[], arg3: Vec3f_, arg4: Vec3f_): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapnZnYnX(arg0: Matrix4f_): this;
    "getNormalizedRotation(org.joml.Quaternionf)"(arg0: Quaternionf_): Quaternionf;
    "get(int,int)"(arg0: number, arg1: number): number;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    get4x3(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number, arg16: Matrix4f_): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4fc_): this;
    "transformProject(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    mapZYX(): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    get3x3(arg0: Internal.Matrix3d_): Internal.Matrix3d;
    mapnXnYnZ(): this;
    setTransposed(arg0: Internal.ByteBuffer_): this;
    getNormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    "frustum(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapZnYnX(arg0: Matrix4f_): this;
    positiveZ(arg0: Vec3f_): Vec3f;
    arcball(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    invertPerspective(): this;
    mapnYnZX(): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number): this;
    mapXnZY(arg0: Matrix4f_): this;
    translate(arg0: number, arg1: number, arg2: number): this;
    lerp(arg0: Internal.Matrix4fc_, arg1: number): this;
    "rotate(org.joml.Quaternionfc,org.joml.Matrix4f)"(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    mapnXYnZ(): this;
    lookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    mulLocal(arg0: Internal.Matrix4fc_): this;
    rotateXYZ(arg0: Internal.Vector3fc_): this;
    rotateLocal(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    shadow(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: Matrix4f_): this;
    mulLocalAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    set(arg0: number[], arg1: number): this;
    get3x3(arg0: Matrix3f_): Matrix3f;
    "mulPerspectiveAffine(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "set3x3(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    mapXnYnZ(): this;
    negateZ(arg0: Matrix4f_): this;
    transformProject(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    setOrtho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "set(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    "getColumn(int,org.joml.Vector3f)"(arg0: number, arg1: Vec3f_): Vec3f;
    mul(arg0: Internal.Matrix4x3fc_): this;
    setPerspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "project(float,float,float,int[],org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotateTowardsXY(arg0: number, arg1: number): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: Matrix4f_): this;
    setLookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    sub(arg0: Internal.Matrix4fc_): this;
    rotateLocalZ(arg0: number): this;
    scale(arg0: number): this;
    "transformProject(float,float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec3f_): Vec3f;
    m03(arg0: number): this;
    get(arg0: number, arg1: number): number;
    mapnYZX(): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    "translationRotateScale(org.joml.Vector3fc,org.joml.Quaternionfc,float)"(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    get3x4(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    invert(): this;
    setPerspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    transformTranspose(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    "setTransposed(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "get4x3Transposed(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    perspectiveNear(): number;
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapnYZX(arg0: Matrix4f_): this;
    mulLocalAffine(arg0: Internal.Matrix4fc_): this;
    "getTransposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotateAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number): this;
    shadow(arg0: Vec4f_, arg1: Matrix4f_): this;
    "scale(org.joml.Vector3fc,org.joml.Matrix4f)"(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    perspectiveOrigin(arg0: Vec3f_): Vec3f;
    frustumAabb(arg0: Vec3f_, arg1: Vec3f_): this;
    "set(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_): this;
    getNormalizedRotation(arg0: Quaternionf_): Quaternionf;
    "rotation(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    mulLocal(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    "set(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    "mul(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    setTranslation(arg0: Internal.Vector3fc_): this;
    mapXnYnZ(arg0: Matrix4f_): this;
    setPerspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    isAffine(): boolean;
    "scale(float,org.joml.Matrix4f)"(arg0: number, arg1: Matrix4f_): this;
    get3x4(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    arcball(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapYnXnZ(): this;
    "get3x4(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Internal.Vector4fc_, arg3: Internal.Vector4fc_): this;
    mul4x3ComponentWise(arg0: Internal.Matrix4fc_): this;
    rotateAffine(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "getNormalizedRotation(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    rotateX(arg0: number): this;
    invertFrustum(): this;
    rotateAffineYXZ(arg0: number, arg1: number, arg2: number): this;
    "set(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    mapnYnZnX(arg0: Matrix4f_): this;
    "get(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    "invertPerspectiveView(org.joml.Matrix4x3fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    mapnYnXnZ(): this;
    identity(): this;
    set4x3(arg0: Internal.Matrix4x3fc_): this;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number): this;
    translateLocal(arg0: number, arg1: number, arg2: number): this;
    clone(): any;
    mul4x3ComponentWise(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    invert(arg0: Matrix4f_): this;
    mapZnYnX(): this;
    frustumRayDir(arg0: number, arg1: number, arg2: Vec3f_): Vec3f;
    mapnZnYX(): this;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "mulPerspectiveAffine(org.joml.Matrix4x3fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    translationRotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "mul(org.joml.Matrix3x2fc,org.joml.Matrix4f)"(arg0: Internal.Matrix3x2fc_, arg1: Matrix4f_): this;
    getTransposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    sub4x3(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    transformProject(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    mulPerspectiveAffine(arg0: Internal.Matrix4x3fc_): this;
    properties(): number;
    translationRotateScaleInvert(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    "unproject(float,float,float,int[],org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    toString(): string;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    translationRotateInvert(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_): this;
    mapnYnXZ(): this;
    mulOrthoAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    mapnZnXY(arg0: Matrix4f_): this;
    "perspectiveOffCenterFovLH(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    translateLocal(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    unproject(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    mapnZnYnX(): this;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    pick(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number[]): this;
    scaleLocal(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    normalize3x3(arg0: Matrix3f_): Matrix3f;
    unproject(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    scaleLocal(arg0: number, arg1: Matrix4f_): this;
    reflect(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    "perspectiveOffCenter(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    rotateZ(arg0: number): this;
    rotateLocalZ(arg0: number, arg1: Matrix4f_): this;
    scale(arg0: number, arg1: Matrix4f_): this;
    "get3x3(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    "invertPerspectiveView(org.joml.Matrix4fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    scale(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    "rotate(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    ortho2D(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapYnZnX(): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    "set(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    arcball(arg0: number, arg1: Internal.Vector3fc_, arg2: number, arg3: number): this;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    reflection(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    testPoint(arg0: number, arg1: number, arg2: number): boolean;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    perspectiveFov(): number;
    "get4x3(org.joml.Matrix4x3f)"(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    mapZYnX(arg0: Matrix4f_): this;
    mapZXY(): this;
    "get4x3(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    "get4x3(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "transpose3x3(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    mapnXYnZ(arg0: Matrix4f_): this;
    withLookAtUp(arg0: number, arg1: number, arg2: number): this;
    withLookAtUp(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    mapnYnZnX(): this;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    mapYnZnX(arg0: Matrix4f_): this;
    mapnXnYnZ(arg0: Matrix4f_): this;
    mapnZnYX(arg0: Matrix4f_): this;
    origin(arg0: Vec3f_): Vec3f;
    getTransposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    determinantAffine(): number;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    rotateAroundLocal(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number): this;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    obliqueZ(arg0: number, arg1: number): this;
    "mul(org.joml.Matrix4x3fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    "perspective(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    ortho2DLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnZYnX(): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    lookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    mul3x3(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    get(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    pick(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number[], arg5: Matrix4f_): this;
    tile(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    rotateY(arg0: number, arg1: Matrix4f_): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    "orthoLH(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    getUnnormalizedRotation(arg0: Quaternionf_): Quaternionf;
    rotateAffine(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    mapXZnY(arg0: Matrix4f_): this;
    rotateLocalX(arg0: number, arg1: Matrix4f_): this;
    reflection(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZXY(arg0: Matrix4f_): this;
    mapnYXnZ(arg0: Matrix4f_): this;
    mapZXnY(): this;
    m31(): number;
    transformAffine(arg0: Vec4f_): Vec4f;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    get4x3Transposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "scale(float)"(arg0: number): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    m20(arg0: number): this;
    reflection(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotationZ(arg0: number): this;
    mapZXY(arg0: Matrix4f_): this;
    static perspectiveOffCenterViewFromRectangle(arg0: Vec3f_, arg1: Vec3f_, arg2: Vec3f_, arg3: Vec3f_, arg4: number, arg5: boolean, arg6: Matrix4f_, arg7: Matrix4f_): void;
    cofactor3x3(arg0: Matrix3f_): Matrix3f;
    mapnYnXnZ(arg0: Matrix4f_): this;
    "getRotation(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    m20(): number;
    get(arg0: Matrix4f_): this;
    transform(arg0: Vec4f_): Vec4f;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    normal(arg0: Matrix4f_): this;
    m33(arg0: number): this;
    "get3x4(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    set3x3(arg0: Internal.Matrix3fc_): this;
    translationRotateScale(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    unprojectRay(arg0: number, arg1: number, arg2: number[], arg3: Vec3f_, arg4: Vec3f_): this;
    "translationRotateScale(org.joml.Vector3fc,org.joml.Quaternionfc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    normalize3x3(arg0: Matrix4f_): this;
    "frustumLH(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    "shadow(org.joml.Vector4f,float,float,float,float)"(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number): this;
    getScale(arg0: Vec3f_): Vec3f;
    rotation(arg0: number, arg1: Internal.Vector3fc_): this;
    setRotationXYZ(arg0: number, arg1: number, arg2: number): this;
    mapZnXnY(): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    invertFrustum(arg0: Matrix4f_): this;
    transformProject(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    wait(arg0: number): void;
    lookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "transformProject(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    rotationTowardsXY(arg0: number, arg1: number): this;
    "normalize3x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    orthoCrop(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    "shadow(org.joml.Vector4f,float,float,float,float,org.joml.Matrix4f)"(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: Matrix4f_): this;
    scaling(arg0: number, arg1: number, arg2: number): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    lookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    unprojectInvRay(arg0: Internal.Vector2fc_, arg1: number[], arg2: Vec3f_, arg3: Vec3f_): this;
    transpose3x3(arg0: Matrix4f_): this;
    mul(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setLookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    "reflect(org.joml.Quaternionfc,org.joml.Vector3fc,org.joml.Matrix4f)"(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    "unprojectInv(float,float,float,int[],org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    m33(): number;
    transpose(arg0: Matrix4f_): this;
    setPerspective(arg0: number, arg1: number, arg2: number, arg3: number): this;
    unprojectInv(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    set(arg0: Internal.Matrix4fc_): this;
    rotationX(arg0: number): this;
    "set(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    m22(): number;
    m31(arg0: number): this;
    mapZYX(arg0: Matrix4f_): this;
    mulAffineR(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setOrthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    mapYnZX(arg0: Matrix4f_): this;
    m11(): number;
    mulOrthoAffine(arg0: Internal.Matrix4fc_): this;
    mapnZnXY(): this;
    setTransposed(arg0: Internal.Matrix4fc_): this;
    setRotationZYX(arg0: number, arg1: number, arg2: number): this;
    assume(arg0: number): this;
    "unproject(float,float,float,int[],org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    mul0(arg0: Internal.Matrix4fc_): this;
    rotateTowardsXY(arg0: number, arg1: number, arg2: Matrix4f_): this;
    transformAab(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_, arg3: Vec3f_): this;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    equals(arg0: any): boolean;
    rotateAroundLocal(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    "perspectiveOffCenterFov(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    scaleLocal(arg0: number, arg1: number, arg2: number): this;
    mapnZYnX(arg0: Matrix4f_): this;
    m00(): number;
    rotationYXZ(arg0: number, arg1: number, arg2: number): this;
    rotateLocal(arg0: Internal.Quaternionfc_): this;
    "cofactor3x3(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    mul(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    setOrthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    m13(arg0: number): this;
    invertPerspective(arg0: Matrix4f_): this;
    get3x4(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "get(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapnZXY(): this;
    rotateZYX(arg0: Vec3f_): this;
    rotateLocalX(arg0: number): this;
    "normal(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    translationRotateScaleInvert(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number): this;
    get(arg0: number[], arg1: number): number[];
    mapXZnY(): this;
    "setTransposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    set(arg0: Internal.Matrix4dc_): this;
    negateY(): this;
    withLookAtUp(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    mapnZYX(arg0: Matrix4f_): this;
    sub(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    "perspectiveRect(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    getRow(arg0: number, arg1: Vec4f_): Vec4f;
    "getRotation(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    "perspectiveLH(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    getColumn(arg0: number, arg1: Vec4f_): Vec4f;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    mapnYXnZ(): this;
    transpose3x3(): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateAroundAffine(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    setFrustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    setRowColumn(arg0: number, arg1: number, arg2: number): this;
    transformProject(arg0: Vec3f_): Vec3f;
    normalizedPositiveY(arg0: Vec3f_): Vec3f;
    sub4x3(arg0: Matrix4f_): this;
    translationRotateInvert(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): this;
    setPerspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    testAab(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): boolean;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "reflect(org.joml.Quaternionfc,org.joml.Vector3fc)"(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    m13(): number;
    reflect(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    mapYZX(): this;
    "get4x3(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    "getRow(int,org.joml.Vector3f)"(arg0: number, arg1: Vec3f_): Vec3f;
    "unprojectInv(org.joml.Vector3fc,int[],org.joml.Vector4f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    setFromAddress(arg0: number): this;
    m02(arg0: number): this;
    "mulPerspectiveAffine(org.joml.Matrix4fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    transformAffine(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    mapnYZnX(arg0: Matrix4f_): this;
    m02(): number;
    project(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    transformTranspose(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    transpose(): this;
    "perspectiveOffCenterFov(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    "set(float[])"(arg0: number[]): this;
    set(arg0: number[]): this;
    m11(arg0: number): this;
    mulAffine(arg0: Internal.Matrix4fc_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
    rotateZYX(arg0: number, arg1: number, arg2: number): this;
    "project(float,float,float,int[],org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    positiveX(arg0: Vec3f_): Vec3f;
    setTranslation(arg0: number, arg1: number, arg2: number): this;
    m22(arg0: number): this;
    mapXnZY(): this;
    originAffine(arg0: Vec3f_): Vec3f;
    "set4x3(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    mapnZYX(): this;
    fma4x3(arg0: Internal.Matrix4fc_, arg1: number): this;
    "get3x4(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    setPerspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    set(arg0: Internal.Matrix4x3fc_): this;
    normal(): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    setLookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    mulTranslationAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setPerspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    "reflection(org.joml.Quaternionfc,org.joml.Vector3fc)"(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    lookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    "set(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_): this;
    billboardSpherical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "unproject(org.joml.Vector3fc,int[],org.joml.Vector4f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    mul(arg0: Internal.Matrix3x2fc_): this;
    scale(arg0: number, arg1: number, arg2: number): this;
    "perspectiveOffCenterFovLH(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    scaling(arg0: Internal.Vector3fc_): this;
    unprojectInv(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    mapnYZnX(): this;
    m00(arg0: number): this;
    setFrustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    get4x3Transposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    mulComponentWise(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    "rotate(float,org.joml.Vector3fc)"(arg0: number, arg1: Internal.Vector3fc_): this;
    set(arg0: Internal.ByteBuffer_): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    "getUnnormalizedRotation(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    set3x3(arg0: Matrix4f_): this;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    "getTransposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnXZY(arg0: Matrix4f_): this;
    set(arg0: Internal.Quaterniondc_): this;
    setPerspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnXnZY(arg0: Matrix4f_): this;
    mapXZY(arg0: Matrix4f_): this;
    mulComponentWise(arg0: Internal.Matrix4fc_): this;
    setOrtho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    rotate(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    "perspectiveLH(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    add(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    swap(arg0: Matrix4f_): this;
    transformDirection(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    negateY(arg0: Matrix4f_): this;
    translationRotateScale(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number): this;
    getClass(): typeof any;
    "transformProject(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    add(arg0: Internal.Matrix4fc_): this;
    determineProperties(): this;
    mapXnZnY(): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    "set(float[],int)"(arg0: number[], arg1: number): this;
    rotation(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "shadow(float,float,float,float,org.joml.Matrix4fc,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4fc_, arg5: Matrix4f_): this;
    getTransposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    withLookAtUp(arg0: Internal.Vector3fc_): this;
    mapYnZX(): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapnXnYZ(): this;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateAffineZYX(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    set(arg0: Internal.AxisAngle4d_): this;
    mapnXnZnY(): this;
    rotationXYZ(arg0: number, arg1: number, arg2: number): this;
    rotate(arg0: Internal.AxisAngle4f_): this;
    lookAtPerspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    setTransposed(arg0: number[], arg1: number): this;
    mapZnXnY(arg0: Matrix4f_): this;
    rotateAffineXYZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    setOrthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    "translationRotateScaleInvert(org.joml.Vector3fc,org.joml.Quaternionfc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    get3x4(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    get4x3Transposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    get4x3(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    scale(arg0: Internal.Vector3fc_): this;
    "mul(org.joml.Matrix4fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    "cofactor3x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    lookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    transformPosition(arg0: Vec3f_): Vec3f;
    "rotation(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    set(arg0: Internal.AxisAngle4f_): this;
    affineSpan(arg0: Vec3f_, arg1: Vec3f_, arg2: Vec3f_, arg3: Vec3f_): this;
    transformDirection(arg0: Vec3f_): Vec3f;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    perspectiveFrustumSlice(arg0: number, arg1: number, arg2: Matrix4f_): this;
    determinant3x3(): number;
    wait(): void;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "frustum(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    projectedGridRange(arg0: Internal.Matrix4fc_, arg1: number, arg2: number, arg3: Matrix4f_): this;
    mulAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    setFrustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZnXnY(arg0: Matrix4f_): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4fc_, arg5: Matrix4f_): this;
    rotationAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number): this;
    set4x3(arg0: Matrix4f_): this;
    project(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    getTransposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "get(org.joml.Matrix4d)"(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    "setTransposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    get4x3(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    translateLocal(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnXnYZ(arg0: Matrix4f_): this;
    normalize3x3(): this;
    translationRotateScaleInvert(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    mapnXnZY(): this;
    translationRotateScale(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): this;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotate(arg0: number, arg1: Internal.Vector3fc_): this;
    translation(arg0: number, arg1: number, arg2: number): this;
    "transpose3x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    setOrthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    frustumPlane(arg0: number, arg1: Vec4f_): Vec4f;
    transformPosition(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    invertAffine(): this;
    frustumCorner(arg0: number, arg1: Vec3f_): Vec3f;
    "project(org.joml.Vector3fc,int[],org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    get(arg0: number[]): number[];
    shadow(arg0: Vec4f_, arg1: Internal.Matrix4fc_, arg2: Matrix4f_): this;
    set(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number): this;
    toString(arg0: Internal.NumberFormat_): string;
    rotateAffine(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    transformProject(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec3f_): Vec3f;
    mapZXnY(arg0: Matrix4f_): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    setPerspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    getRotation(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    get4x3(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    "get3x4(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapYnXZ(): this;
    setTransposed(arg0: number[]): this;
    unproject(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    "scale(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    rotateY(arg0: number): this;
    rotateTranslation(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    invertPerspectiveView(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    setPerspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    notifyAll(): void;
    add4x3(arg0: Internal.Matrix4fc_): this;
    mapnXZnY(): this;
    mulAffineR(arg0: Internal.Matrix4fc_): this;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    ortho2D(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "orthoSymmetricLH(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    transformAffine(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number): this;
    perspectiveFar(): number;
    "set(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    mapnXnZnY(arg0: Matrix4f_): this;
    set(arg0: Internal.Quaternionfc_): this;
    "rotate(org.joml.AxisAngle4f,org.joml.Matrix4f)"(arg0: Internal.AxisAngle4f_, arg1: Matrix4f_): this;
    mapYnXZ(arg0: Matrix4f_): this;
    "getTransposed(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    "perspective(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    "get(float[],int)"(arg0: number[], arg1: number): number[];
    "getTransposed(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapXnZnY(arg0: Matrix4f_): this;
    mapYXZ(): this;
    determinant(): number;
    "reflect(org.joml.Vector3fc,org.joml.Vector3fc,org.joml.Matrix4f)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    add4x3(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setLookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    wait(arg0: number, arg1: number): void;
    setOrthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "perspectiveOffCenter(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    getUnnormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    mapnXZnY(arg0: Matrix4f_): this;
    rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    translate(arg0: Internal.Vector3fc_): this;
    "get(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    m30(): number;
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "getUnnormalizedRotation(org.joml.Quaternionf)"(arg0: Quaternionf_): Quaternionf;
    "set3x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    "mul(org.joml.Matrix3x2fc)"(arg0: Internal.Matrix3x2fc_): this;
    rotate(arg0: number, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    getTranslation(arg0: Vec3f_): Vec3f;
    invertPerspectiveView(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    set transposedFromAddress(arg0: number)
    set "(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_)
    get finite(): boolean
    set transposed(arg0: Internal.FloatBuffer_)
    set "(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set "transposed(float[])"(arg0: number[])
    set "(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    set transposed(arg0: Internal.ByteBuffer_)
    set "(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_)
    set "transposed(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set "(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_)
    set "(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_)
    set translation(arg0: Internal.Vector3fc_)
    get affine(): boolean
    set "(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_)
    set "(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_)
    set "(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set transposed(arg0: Internal.Matrix4fc_)
    set "transposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set fromAddress(arg0: number)
    set "(float[])"(arg0: number[])
    set "(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_)
    get class(): typeof any
    set "transposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    set transposed(arg0: number[])
}
type Matrix4f_ = Matrix4f;
declare class Blocks {
    constructor()
    static never(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.EntityType_<any>): boolean;
    static log(arg0: Internal.MapColor_, arg1: Internal.MapColor_, arg2: SoundType_): Internal.RotatedPillarBlock;
    getClass(): typeof any;
    static never(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
    toString(): string;
    notifyAll(): void;
    static always(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
    static rebuildCache(): void;
    static stoneButton(): Internal.ButtonBlock;
    notify(): void;
    static woodenButton(arg0: Internal.BlockSetType_, ...arg1: Internal.FeatureFlag_[]): Internal.ButtonBlock;
    wait(arg0: number, arg1: number): void;
    static log(arg0: Internal.MapColor_, arg1: Internal.MapColor_): Internal.RotatedPillarBlock;
    static register(arg0: string, arg1: Internal.Block_): Internal.Block;
    hashCode(): number;
    static leaves(arg0: SoundType_): Internal.LeavesBlock;
    static litBlockEmission(arg0: number): Internal.ToIntFunction<Internal.BlockState>;
    static netherStem(arg0: Internal.MapColor_): Internal.Block;
    wait(): void;
    wait(arg0: number): void;
    static always(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.EntityType_<any>): boolean;
    static ocelotOrParrot(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.EntityType_<any>): boolean;
    static flowerPot(arg0: Internal.Block_, ...arg1: Internal.FeatureFlag_[]): Internal.FlowerPotBlock;
    equals(arg0: any): boolean;
    get class(): typeof any
    static MANGROVE_PROPAGULE: (Internal.MangrovePropaguleBlock) & (Internal.Block);
    static STONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static POTTED_CRIMSON_FUNGUS: (Internal.FlowerPotBlock) & (Internal.Block);
    static DEEPSLATE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CHERRY_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static POLISHED_ANDESITE: (Internal.Block) & (Internal.Block);
    static RED_NETHER_BRICKS: (Internal.Block) & (Internal.Block);
    static TORCH: (Internal.TorchBlock) & (Internal.Block);
    static COAL_BLOCK: (Internal.Block) & (Internal.Block);
    static STRIPPED_CRIMSON_STEM: (Internal.RotatedPillarBlock) & (Internal.Block);
    static FIRE_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static WEEPING_VINES_PLANT: (Internal.WeepingVinesPlantBlock) & (Internal.Block);
    static PEONY: (Internal.TallFlowerBlock) & (Internal.Block);
    static CARROTS: (Internal.CarrotBlock) & (Internal.Block);
    static YELLOW_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static CYAN_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static BLUE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static TUBE_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static SMITHING_TABLE: (Internal.SmithingTableBlock) & (Internal.Block);
    static ACACIA_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static MAGENTA_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static POTTED_CHERRY_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static PLAYER_WALL_HEAD: (Internal.PlayerWallHeadBlock) & (Internal.Block);
    static DEAD_HORN_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static MANGROVE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static SPRUCE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static IRON_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static TRIPWIRE: (Internal.TripWireBlock) & (Internal.Block);
    static BLACK_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static LIGHT_BLUE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static ACACIA_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CRIMSON_FUNGUS: (Internal.FungusBlock) & (Internal.Block);
    static BUBBLE_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static LIGHT_BLUE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static PRISMARINE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static DEAD_TUBE_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static PURPLE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static RED_NETHER_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static SCULK_SENSOR: (Internal.SculkSensorBlock) & (Internal.Block);
    static YELLOW_WOOL: (Internal.Block) & (Internal.Block);
    static MAGENTA_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static SAND: (Internal.SandBlock) & (Internal.Block);
    static MYCELIUM: (Internal.MyceliumBlock) & (Internal.Block);
    static LIGHT_GRAY_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static ORANGE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static CORNFLOWER: (Internal.FlowerBlock) & (Internal.Block);
    static DARK_OAK_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static GRANITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static REDSTONE_LAMP: (Internal.RedstoneLampBlock) & (Internal.Block);
    static LIGHT: (Internal.LightBlock) & (Internal.Block);
    static TUBE_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static WARPED_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static DANDELION: (Internal.FlowerBlock) & (Internal.Block);
    static PINK_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static WARPED_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static RED_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static SOUL_SOIL: (Internal.Block) & (Internal.Block);
    static ACACIA_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static CRIMSON_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static HEAVY_WEIGHTED_PRESSURE_PLATE: (Internal.WeightedPressurePlateBlock) & (Internal.Block);
    static PRISMARINE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static TWISTING_VINES_PLANT: (Internal.TwistingVinesPlantBlock) & (Internal.Block);
    static DEEPSLATE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static WARPED_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static OAK_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PINK_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static RED_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static WARPED_WART_BLOCK: (Internal.Block) & (Internal.Block);
    static EXPOSED_CUT_COPPER_STAIRS: (Internal.WeatheringCopperStairBlock) & (Internal.Block);
    static COARSE_DIRT: (Internal.Block) & (Internal.Block);
    static DEEPSLATE_REDSTONE_ORE: (Internal.RedStoneOreBlock) & (Internal.Block);
    static TUFF: (Internal.Block) & (Internal.Block);
    static CHISELED_BOOKSHELF: (Internal.ChiseledBookShelfBlock) & (Internal.Block);
    static ACACIA_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DEEPSLATE_IRON_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static PURPLE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static LIGHTNING_ROD: (Internal.LightningRodBlock) & (Internal.Block);
    static COBBLED_DEEPSLATE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static CHERRY_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static LILY_PAD: (Internal.WaterlilyBlock) & (Internal.Block);
    static GREEN_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static BARRIER: (Internal.BarrierBlock) & (Internal.Block);
    static PINK_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static DRAGON_HEAD: (Internal.SkullBlock) & (Internal.Block);
    static YELLOW_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static DEAD_BUBBLE_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static STRIPPED_BIRCH_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static SEAGRASS: (Internal.SeagrassBlock) & (Internal.Block);
    static CHERRY_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static HORN_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static MOSSY_STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static SPRUCE_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static WAXED_COPPER_BLOCK: (Internal.Block) & (Internal.Block);
    static STONE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static GRANITE_WALL: (Internal.WallBlock) & (Internal.Block);
    static NETHER_BRICK_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static MOSS_CARPET: (Internal.CarpetBlock) & (Internal.Block);
    static DARK_OAK_PLANKS: (Internal.Block) & (Internal.Block);
    static MAGENTA_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static ANDESITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_NETHER_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static BIRCH_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static BAMBOO_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static BROWN_CONCRETE: (Internal.Block) & (Internal.Block);
    static DEEPSLATE_DIAMOND_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static BEETROOTS: (Internal.BeetrootBlock) & (Internal.Block);
    static POTTED_BAMBOO: (Internal.FlowerPotBlock) & (Internal.Block);
    static FERN: (Internal.TallGrassBlock) & (Internal.Block);
    static CRIMSON_HYPHAE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static WAXED_CUT_COPPER: (Internal.Block) & (Internal.Block);
    static ACACIA_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static BLACK_WOOL: (Internal.Block) & (Internal.Block);
    static POLISHED_BLACKSTONE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static BRAIN_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static VINE: (Internal.VineBlock) & (Internal.Block);
    static CHERRY_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static ANDESITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static INFESTED_DEEPSLATE: (Internal.InfestedRotatedPillarBlock) & (Internal.Block);
    static ACACIA_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static SPONGE: (Internal.SpongeBlock) & (Internal.Block);
    static REDSTONE_ORE: (Internal.RedStoneOreBlock) & (Internal.Block);
    static STRIPPED_ACACIA_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static REDSTONE_WALL_TORCH: (Internal.RedstoneWallTorchBlock) & (Internal.Block);
    static CYAN_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static BLACK_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static CAMPFIRE: (Internal.CampfireBlock) & (Internal.Block);
    static OCHRE_FROGLIGHT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static COBBLESTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DRAGON_WALL_HEAD: (Internal.WallSkullBlock) & (Internal.Block);
    static POTTED_WITHER_ROSE: (Internal.FlowerPotBlock) & (Internal.Block);
    static BLACKSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static GRAY_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static CYAN_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static BAMBOO_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static BIRCH_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static POTTED_CORNFLOWER: (Internal.FlowerPotBlock) & (Internal.Block);
    static STICKY_PISTON: (Internal.PistonBaseBlock) & (Internal.Block);
    static LIGHT_BLUE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static WEATHERED_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static CYAN_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static RAW_GOLD_BLOCK: (Internal.Block) & (Internal.Block);
    static STRIPPED_BIRCH_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static LARGE_AMETHYST_BUD: (Internal.AmethystClusterBlock) & (Internal.Block);
    static POLISHED_ANDESITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static NETHER_PORTAL: (Internal.NetherPortalBlock) & (Internal.Block);
    static JUNGLE_PLANKS: (Internal.Block) & (Internal.Block);
    static PINK_TULIP: (Internal.FlowerBlock) & (Internal.Block);
    static OAK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static STRIPPED_WARPED_HYPHAE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static POTTED_OAK_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static MANGROVE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static DARK_OAK_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static EXPOSED_CUT_COPPER_SLAB: (Internal.WeatheringCopperSlabBlock) & (Internal.Block);
    static ORANGE_CONCRETE: (Internal.Block) & (Internal.Block);
    static BLUE_ORCHID: (Internal.FlowerBlock) & (Internal.Block);
    static STRIPPED_BAMBOO_BLOCK: (Internal.RotatedPillarBlock) & (Internal.Block);
    static BIRCH_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static GRAY_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static DEEPSLATE_TILES: (Internal.Block) & (Internal.Block);
    static CRIMSON_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static WHITE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static KELP: (Internal.KelpBlock) & (Internal.Block);
    static BROWN_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static INFESTED_CRACKED_STONE_BRICKS: (Internal.InfestedBlock) & (Internal.Block);
    static JUNGLE_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static LIGHT_GRAY_CONCRETE: (Internal.Block) & (Internal.Block);
    static RED_MUSHROOM_BLOCK: (Internal.HugeMushroomBlock) & (Internal.Block);
    static GRAY_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static MOSS_BLOCK: (Internal.MossBlock) & (Internal.Block);
    static LIME_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static CRIMSON_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CARVED_PUMPKIN: (Internal.EquipableCarvedPumpkinBlock) & (Internal.Block);
    static POTATOES: (Internal.PotatoBlock) & (Internal.Block);
    static PURPUR_PILLAR: (Internal.RotatedPillarBlock) & (Internal.Block);
    static MUD_BRICKS: (Internal.Block) & (Internal.Block);
    static DEAD_FIRE_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static MANGROVE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CHERRY_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static NOTE_BLOCK: (Internal.NoteBlock) & (Internal.Block);
    static ENDER_CHEST: (Internal.EnderChestBlock) & (Internal.Block);
    static CYAN_BED: (Internal.BedBlock) & (Internal.Block);
    static DEAD_TUBE_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static BIRCH_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static YELLOW_CONCRETE: (Internal.Block) & (Internal.Block);
    static DEAD_TUBE_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static STRIPPED_WARPED_STEM: (Internal.RotatedPillarBlock) & (Internal.Block);
    static LEVER: (Internal.LeverBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE: (Internal.Block) & (Internal.Block);
    static LIGHT_BLUE_CONCRETE: (Internal.Block) & (Internal.Block);
    static POTTED_MANGROVE_PROPAGULE: (Internal.FlowerPotBlock) & (Internal.Block);
    static DROPPER: (Internal.DropperBlock) & (Internal.Block);
    static SPRUCE_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static RED_SANDSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CRAFTING_TABLE: (Internal.CraftingTableBlock) & (Internal.Block);
    static SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static GRASS: (Internal.TallGrassBlock) & (Internal.Block);
    static CHERRY_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MEDIUM_AMETHYST_BUD: (Internal.AmethystClusterBlock) & (Internal.Block);
    static CRIMSON_ROOTS: (Internal.RootsBlock) & (Internal.Block);
    static WITHER_ROSE: (Internal.WitherRoseBlock) & (Internal.Block);
    static OXEYE_DAISY: (Internal.FlowerBlock) & (Internal.Block);
    static OAK_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static EMERALD_BLOCK: (Internal.Block) & (Internal.Block);
    static BUDDING_AMETHYST: (Internal.BuddingAmethystBlock) & (Internal.Block);
    static RAIL: (Internal.RailBlock) & (Internal.Block);
    static JUNGLE_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static BROWN_MUSHROOM_BLOCK: (Internal.HugeMushroomBlock) & (Internal.Block);
    static DARK_OAK_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static DIAMOND_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static LADDER: (Internal.LadderBlock) & (Internal.Block);
    static OAK_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static MELON: (Internal.MelonBlock) & (Internal.Block);
    static CRIMSON_PLANKS: (Internal.Block) & (Internal.Block);
    static GLOW_LICHEN: (Internal.GlowLichenBlock) & (Internal.Block);
    static REDSTONE_WIRE: (Internal.RedStoneWireBlock) & (Internal.Block);
    static HORN_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static DARK_PRISMARINE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CAVE_VINES_PLANT: (Internal.CaveVinesPlantBlock) & (Internal.Block);
    static ACACIA_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static YELLOW_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static SMOOTH_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static COBBLED_DEEPSLATE_WALL: (Internal.WallBlock) & (Internal.Block);
    static CRIMSON_NYLIUM: (Internal.NyliumBlock) & (Internal.Block);
    static POTTED_BLUE_ORCHID: (Internal.FlowerPotBlock) & (Internal.Block);
    static CYAN_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static SCULK_CATALYST: (Internal.SculkCatalystBlock) & (Internal.Block);
    static STRIPPED_MANGROVE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DISPENSER: (Internal.DispenserBlock) & (Internal.Block);
    static PRISMARINE_WALL: (Internal.WallBlock) & (Internal.Block);
    static ORANGE_TULIP: (Internal.FlowerBlock) & (Internal.Block);
    static COMMAND_BLOCK: (Internal.CommandBlock) & (Internal.Block);
    static BLACK_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static SPORE_BLOSSOM: (Internal.SporeBlossomBlock) & (Internal.Block);
    static OXIDIZED_CUT_COPPER_STAIRS: (Internal.WeatheringCopperStairBlock) & (Internal.Block);
    static DEEPSLATE_TILE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static JUNGLE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DIRT_PATH: (Internal.DirtPathBlock) & (Internal.Block);
    static BLUE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static GREEN_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static HONEYCOMB_BLOCK: (Internal.Block) & (Internal.Block);
    static ICE: (Internal.IceBlock) & (Internal.Block);
    static BAMBOO_MOSAIC_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static POTTED_BIRCH_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static WHITE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static WATER: (Internal.LiquidBlock) & (Internal.Block);
    static CRACKED_NETHER_BRICKS: (Internal.Block) & (Internal.Block);
    static WATER_CAULDRON: (Internal.LayeredCauldronBlock) & (Internal.Block);
    static MUD_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static WAXED_CUT_COPPER_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static POLISHED_DEEPSLATE_WALL: (Internal.WallBlock) & (Internal.Block);
    static OAK_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static OAK_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static POTTED_BROWN_MUSHROOM: (Internal.FlowerPotBlock) & (Internal.Block);
    static WARPED_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static JUKEBOX: (Internal.JukeboxBlock) & (Internal.Block);
    static MANGROVE_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static NETHER_BRICKS: (Internal.Block) & (Internal.Block);
    static PLAYER_HEAD: (Internal.PlayerHeadBlock) & (Internal.Block);
    static PURPLE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static DEAD_TUBE_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static BIRCH_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static POWDER_SNOW_CAULDRON: (Internal.PowderSnowCauldronBlock) & (Internal.Block);
    static BROWN_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static BREWING_STAND: (Internal.BrewingStandBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static REDSTONE_TORCH: (Internal.RedstoneTorchBlock) & (Internal.Block);
    static BAMBOO_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static BLACK_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static POLISHED_GRANITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static MAGENTA_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static DEAD_BRAIN_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static BLACK_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static NETHER_SPROUTS: (Internal.NetherSproutsBlock) & (Internal.Block);
    static GREEN_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static SPRUCE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PURPLE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static CONDUIT: (Internal.ConduitBlock) & (Internal.Block);
    static ORANGE_WOOL: (Internal.Block) & (Internal.Block);
    static POTTED_WHITE_TULIP: (Internal.FlowerPotBlock) & (Internal.Block);
    static PRISMARINE_BRICKS: (Internal.Block) & (Internal.Block);
    static POLISHED_BLACKSTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static SEA_LANTERN: (Internal.Block) & (Internal.Block);
    static MAGENTA_BED: (Internal.BedBlock) & (Internal.Block);
    static POLISHED_DEEPSLATE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static STONE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static SCAFFOLDING: (Internal.ScaffoldingBlock) & (Internal.Block);
    static NETHER_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DIORITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static PISTON_HEAD: (Internal.PistonHeadBlock) & (Internal.Block);
    static BLACK_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static PURPLE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static LIME_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static OAK_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static CUT_RED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static DEAD_FIRE_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static LIME_BED: (Internal.BedBlock) & (Internal.Block);
    static SPAWNER: (Internal.SpawnerBlock) & (Internal.Block);
    static FROSTED_ICE: (Internal.FrostedIceBlock) & (Internal.Block);
    static IRON_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static WARPED_ROOTS: (Internal.RootsBlock) & (Internal.Block);
    static STONE: (Internal.Block) & (Internal.Block);
    static MUD_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static SOUL_LANTERN: (Internal.LanternBlock) & (Internal.Block);
    static COPPER_BLOCK: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static WAXED_OXIDIZED_COPPER: (Internal.Block) & (Internal.Block);
    static WARPED_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static POLISHED_BASALT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DAYLIGHT_DETECTOR: (Internal.DaylightDetectorBlock) & (Internal.Block);
    static CRIMSON_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CHERRY_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static GOLD_BLOCK: (Internal.Block) & (Internal.Block);
    static POTTED_LILY_OF_THE_VALLEY: (Internal.FlowerPotBlock) & (Internal.Block);
    static LIGHT_BLUE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static LIGHT_GRAY_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static DRIPSTONE_BLOCK: (Internal.Block) & (Internal.Block);
    static COBBLED_DEEPSLATE: (Internal.Block) & (Internal.Block);
    static BIG_DRIPLEAF: (Internal.BigDripleafBlock) & (Internal.Block);
    static MANGROVE_LEAVES: (Internal.MangroveLeavesBlock) & (Internal.Block);
    static GRAY_WOOL: (Internal.Block) & (Internal.Block);
    static INFESTED_CHISELED_STONE_BRICKS: (Internal.InfestedBlock) & (Internal.Block);
    static GRAY_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static CHERRY_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static REPEATING_COMMAND_BLOCK: (Internal.CommandBlock) & (Internal.Block);
    static WARPED_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static RED_BED: (Internal.BedBlock) & (Internal.Block);
    static CHERRY_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static POTTED_DANDELION: (Internal.FlowerPotBlock) & (Internal.Block);
    static POTTED_CACTUS: (Internal.FlowerPotBlock) & (Internal.Block);
    static DIORITE_WALL: (Internal.WallBlock) & (Internal.Block);
    static HOPPER: (Internal.HopperBlock) & (Internal.Block);
    static SPRUCE_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static BARREL: (Internal.BarrelBlock) & (Internal.Block);
    static MELON_STEM: (Internal.StemBlock) & (Internal.Block);
    static ROOTED_DIRT: (Internal.RootedDirtBlock) & (Internal.Block);
    static LIGHT_BLUE_WOOL: (Internal.Block) & (Internal.Block);
    static SOUL_WALL_TORCH: (Internal.WallTorchBlock) & (Internal.Block);
    static LAPIS_BLOCK: (Internal.Block) & (Internal.Block);
    static ANDESITE: (Internal.Block) & (Internal.Block);
    static YELLOW_BED: (Internal.BedBlock) & (Internal.Block);
    static END_STONE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BLAST_FURNACE: (Internal.BlastFurnaceBlock) & (Internal.Block);
    static SMALL_DRIPLEAF: (Internal.SmallDripleafBlock) & (Internal.Block);
    static KELP_PLANT: (Internal.KelpPlantBlock) & (Internal.Block);
    static RED_SAND: (Internal.SandBlock) & (Internal.Block);
    static JUNGLE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static QUARTZ_BRICKS: (Internal.Block) & (Internal.Block);
    static CRIMSON_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static ZOMBIE_WALL_HEAD: (Internal.WallSkullBlock) & (Internal.Block);
    static LIME_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static RAW_COPPER_BLOCK: (Internal.Block) & (Internal.Block);
    static CHERRY_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static ORANGE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static LOOM: (Internal.LoomBlock) & (Internal.Block);
    static GREEN_WOOL: (Internal.Block) & (Internal.Block);
    static BROWN_WOOL: (Internal.Block) & (Internal.Block);
    static LIGHT_GRAY_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static PIGLIN_WALL_HEAD: (Internal.PiglinWallSkullBlock) & (Internal.Block);
    static BLUE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static PINK_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static SMOKER: (Internal.SmokerBlock) & (Internal.Block);
    static ANVIL: (Internal.AnvilBlock) & (Internal.Block);
    static BROWN_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static FLOWER_POT: (Internal.FlowerPotBlock) & (Internal.Block);
    static LIGHT_BLUE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static STONECUTTER: (Internal.StonecutterBlock) & (Internal.Block);
    static CUT_RED_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_CONCRETE: (Internal.Block) & (Internal.Block);
    static DARK_OAK_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static GREEN_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static BAMBOO: (Internal.BambooStalkBlock) & (Internal.Block);
    static DEAD_HORN_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static DARK_OAK_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static MAGENTA_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static DARK_OAK_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static CHISELED_RED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static CRIMSON_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static PITCHER_CROP: (Internal.PitcherCropBlock) & (Internal.Block);
    static CHERRY_LEAVES: (Internal.CherryLeavesBlock) & (Internal.Block);
    static RED_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static QUARTZ_PILLAR: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CHISELED_POLISHED_BLACKSTONE: (Internal.Block) & (Internal.Block);
    static DEAD_FIRE_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static PURPLE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static RED_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static AMETHYST_CLUSTER: (Internal.AmethystClusterBlock) & (Internal.Block);
    static DARK_PRISMARINE: (Internal.Block) & (Internal.Block);
    static MANGROVE_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static SCULK_VEIN: (Internal.SculkVeinBlock) & (Internal.Block);
    static JUNGLE_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static YELLOW_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static OBSERVER: (Internal.ObserverBlock) & (Internal.Block);
    static END_STONE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static SPRUCE_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static MANGROVE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static WAXED_EXPOSED_CUT_COPPER: (Internal.Block) & (Internal.Block);
    static STONE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static BAMBOO_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static SPRUCE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static NETHER_WART: (Internal.NetherWartBlock) & (Internal.Block);
    static WAXED_OXIDIZED_CUT_COPPER_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static OBSIDIAN: (Internal.Block) & (Internal.Block);
    static PURPLE_CONCRETE: (Internal.Block) & (Internal.Block);
    static BLACK_CONCRETE: (Internal.Block) & (Internal.Block);
    static WARPED_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static REINFORCED_DEEPSLATE: (Internal.Block) & (Internal.Block);
    static DRAGON_EGG: (Internal.DragonEggBlock) & (Internal.Block);
    static PACKED_MUD: (Internal.Block) & (Internal.Block);
    static ACACIA_PLANKS: (Internal.Block) & (Internal.Block);
    static RED_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static DARK_OAK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static MOSSY_STONE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static LIGHT_WEIGHTED_PRESSURE_PLATE: (Internal.WeightedPressurePlateBlock) & (Internal.Block);
    static FIRE_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static QUARTZ_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static PURPUR_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static STONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static STRIPPED_JUNGLE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static RED_WOOL: (Internal.Block) & (Internal.Block);
    static FARMLAND: (Internal.FarmBlock) & (Internal.Block);
    static DARK_OAK_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static ORANGE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static DEEPSLATE_GOLD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static LIGHT_BLUE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static BRICKS: (Internal.Block) & (Internal.Block);
    static WAXED_EXPOSED_CUT_COPPER_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MOSSY_COBBLESTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CAKE: (Internal.CakeBlock) & (Internal.Block);
    static GREEN_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static JUNGLE_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static BLUE_BED: (Internal.BedBlock) & (Internal.Block);
    static OAK_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static MANGROVE_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static DEEPSLATE_BRICKS: (Internal.Block) & (Internal.Block);
    static BASALT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static REPEATER: (Internal.RepeaterBlock) & (Internal.Block);
    static PURPLE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static AZURE_BLUET: (Internal.FlowerBlock) & (Internal.Block);
    static LILY_OF_THE_VALLEY: (Internal.FlowerBlock) & (Internal.Block);
    static STONE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static BIRCH_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static BIRCH_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static LIGHT_BLUE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static BROWN_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static FIRE_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static SANDSTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static RESPAWN_ANCHOR: (Internal.RespawnAnchorBlock) & (Internal.Block);
    static PRISMARINE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static NETHER_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static NETHERRACK: (Internal.NetherrackBlock) & (Internal.Block);
    static CAVE_VINES: (Internal.CaveVinesBlock) & (Internal.Block);
    static WARPED_NYLIUM: (Internal.NyliumBlock) & (Internal.Block);
    static POTTED_POPPY: (Internal.FlowerPotBlock) & (Internal.Block);
    static POINTED_DRIPSTONE: (Internal.PointedDripstoneBlock) & (Internal.Block);
    static ORANGE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static LIGHT_GRAY_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static WAXED_WEATHERED_CUT_COPPER_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BRICKS: (Internal.Block) & (Internal.Block);
    static GLASS: (Internal.GlassBlock) & (Internal.Block);
    static WARPED_PLANKS: (Internal.Block) & (Internal.Block);
    static WET_SPONGE: (Internal.WetSpongeBlock) & (Internal.Block);
    static GRASS_BLOCK: (Internal.GrassBlock) & (Internal.Block);
    static COAL_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static PURPUR_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static WARPED_STEM: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DEEPSLATE_COPPER_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static POLISHED_DIORITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static ANCIENT_DEBRIS: (Internal.Block) & (Internal.Block);
    static GRAY_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static DEAD_BRAIN_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static WHITE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static END_STONE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static PODZOL: (Internal.SnowyDirtBlock) & (Internal.Block);
    static CHERRY_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static COMPARATOR: (Internal.ComparatorBlock) & (Internal.Block);
    static ACACIA_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static CHISELED_STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static WAXED_WEATHERED_COPPER: (Internal.Block) & (Internal.Block);
    static SUGAR_CANE: (Internal.SugarCaneBlock) & (Internal.Block);
    static DEAD_BRAIN_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static NETHERITE_BLOCK: (Internal.Block) & (Internal.Block);
    static OAK_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static WHITE_CONCRETE: (Internal.Block) & (Internal.Block);
    static POTTED_AZURE_BLUET: (Internal.FlowerPotBlock) & (Internal.Block);
    static SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static ORANGE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static ORANGE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static BRAIN_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static PINK_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static OXIDIZED_CUT_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static GRAY_BED: (Internal.BedBlock) & (Internal.Block);
    static GLASS_PANE: (Internal.IronBarsBlock) & (Internal.Block);
    static GRAVEL: (Internal.GravelBlock) & (Internal.Block);
    static BAMBOO_MOSAIC: (Internal.Block) & (Internal.Block);
    static SUSPICIOUS_GRAVEL: (Internal.BrushableBlock) & (Internal.Block);
    static ENCHANTING_TABLE: (Internal.EnchantmentTableBlock) & (Internal.Block);
    static LILAC: (Internal.TallFlowerBlock) & (Internal.Block);
    static STRIPPED_SPRUCE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static MANGROVE_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static RED_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static STRIPPED_JUNGLE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static ALLIUM: (Internal.FlowerBlock) & (Internal.Block);
    static MUD_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DEAD_BRAIN_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static LIGHT_GRAY_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static ZOMBIE_HEAD: (Internal.SkullBlock) & (Internal.Block);
    static WHITE_TULIP: (Internal.FlowerBlock) & (Internal.Block);
    static PINK_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static MOSSY_COBBLESTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static CRACKED_DEEPSLATE_BRICKS: (Internal.Block) & (Internal.Block);
    static WHITE_WOOL: (Internal.Block) & (Internal.Block);
    static GREEN_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static GRAY_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static BLACK_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static TUBE_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static JUNGLE_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static CUT_SANDSTONE: (Internal.Block) & (Internal.Block);
    static POLISHED_GRANITE: (Internal.Block) & (Internal.Block);
    static DARK_OAK_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static SKELETON_WALL_SKULL: (Internal.WallSkullBlock) & (Internal.Block);
    static TALL_GRASS: (Internal.DoublePlantBlock) & (Internal.Block);
    static POTTED_JUNGLE_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static YELLOW_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static PEARLESCENT_FROGLIGHT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DARK_OAK_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static MAGENTA_WOOL: (Internal.Block) & (Internal.Block);
    static PUMPKIN_STEM: (Internal.StemBlock) & (Internal.Block);
    static MUD: (Internal.MudBlock) & (Internal.Block);
    static GRINDSTONE: (Internal.GrindstoneBlock) & (Internal.Block);
    static LIGHT_BLUE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static BAMBOO_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static BLUE_ICE: (Internal.HalfTransparentBlock) & (Internal.Block);
    static BROWN_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static FLOWERING_AZALEA: (Internal.AzaleaBlock) & (Internal.Block);
    static CHERRY_PLANKS: (Internal.Block) & (Internal.Block);
    static PACKED_ICE: (Internal.Block) & (Internal.Block);
    static ACACIA_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static GRAY_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static DARK_OAK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static BLUE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static ORANGE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static BEEHIVE: (Internal.BeehiveBlock) & (Internal.Block);
    static PURPLE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static BLUE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static BLACK_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static WHITE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static NETHER_GOLD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static LODESTONE: (Internal.Block) & (Internal.Block);
    static WEEPING_VINES: (Internal.WeepingVinesBlock) & (Internal.Block);
    static MAGENTA_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static OAK_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static END_PORTAL: (Internal.EndPortalBlock) & (Internal.Block);
    static TINTED_GLASS: (Internal.TintedGlassBlock) & (Internal.Block);
    static LIME_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static SKELETON_SKULL: (Internal.SkullBlock) & (Internal.Block);
    static LIME_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static END_STONE: (Internal.Block) & (Internal.Block);
    static JUNGLE_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static TWISTING_VINES: (Internal.TwistingVinesBlock) & (Internal.Block);
    static END_PORTAL_FRAME: (Internal.EndPortalFrameBlock) & (Internal.Block);
    static CRIMSON_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static SPRUCE_PLANKS: (Internal.Block) & (Internal.Block);
    static POLISHED_GRANITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static YELLOW_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static SNIFFER_EGG: (Internal.SnifferEggBlock) & (Internal.Block);
    static MOSSY_COBBLESTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CHERRY_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static ORANGE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static LIGHT_BLUE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static ACACIA_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static GRAY_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static GRAY_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static BIRCH_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CRACKED_DEEPSLATE_TILES: (Internal.Block) & (Internal.Block);
    static HANGING_ROOTS: (Internal.HangingRootsBlock) & (Internal.Block);
    static TURTLE_EGG: (Internal.TurtleEggBlock) & (Internal.Block);
    static BLACKSTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static SMOOTH_RED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static BAMBOO_SAPLING: (Internal.BambooSaplingBlock) & (Internal.Block);
    static WAXED_OXIDIZED_CUT_COPPER_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static WHITE_BED: (Internal.BedBlock) & (Internal.Block);
    static CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static DETECTOR_RAIL: (Internal.DetectorRailBlock) & (Internal.Block);
    static COPPER_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static CAULDRON: (Internal.CauldronBlock) & (Internal.Block);
    static LANTERN: (Internal.LanternBlock) & (Internal.Block);
    static GLOWSTONE: (Internal.Block) & (Internal.Block);
    static YELLOW_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static VOID_AIR: (Internal.AirBlock) & (Internal.Block);
    static PURPUR_BLOCK: (Internal.Block) & (Internal.Block);
    static INFESTED_STONE: (Internal.InfestedBlock) & (Internal.Block);
    static CHAIN: (Internal.ChainBlock) & (Internal.Block);
    static STRIPPED_SPRUCE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static OAK_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static OAK_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static MAGMA_BLOCK: (Internal.MagmaBlock) & (Internal.Block);
    static DIORITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static RED_SANDSTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static LAPIS_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static SPRUCE_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static SMOOTH_STONE: (Internal.Block) & (Internal.Block);
    static BUBBLE_COLUMN: (Internal.BubbleColumnBlock) & (Internal.Block);
    static CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static POLISHED_DIORITE: (Internal.Block) & (Internal.Block);
    static BIRCH_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static AIR: (Internal.AirBlock) & (Internal.Block);
    static AZALEA_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static WHITE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static CAVE_AIR: (Internal.AirBlock) & (Internal.Block);
    static MOSSY_COBBLESTONE: (Internal.Block) & (Internal.Block);
    static OAK_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static BAMBOO_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static EMERALD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static CYAN_WOOL: (Internal.Block) & (Internal.Block);
    static BIRCH_PLANKS: (Internal.Block) & (Internal.Block);
    static POTTED_ORANGE_TULIP: (Internal.FlowerPotBlock) & (Internal.Block);
    static POTTED_WARPED_ROOTS: (Internal.FlowerPotBlock) & (Internal.Block);
    static SPRUCE_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static DARK_PRISMARINE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static SMALL_AMETHYST_BUD: (Internal.AmethystClusterBlock) & (Internal.Block);
    static SPRUCE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static WITHER_SKELETON_SKULL: (Internal.WitherSkullBlock) & (Internal.Block);
    static BUBBLE_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static CREEPER_WALL_HEAD: (Internal.WallSkullBlock) & (Internal.Block);
    static STRIPPED_OAK_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static ACACIA_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CHAIN_COMMAND_BLOCK: (Internal.CommandBlock) & (Internal.Block);
    static PIGLIN_HEAD: (Internal.SkullBlock) & (Internal.Block);
    static MANGROVE_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static INFESTED_MOSSY_STONE_BRICKS: (Internal.InfestedBlock) & (Internal.Block);
    static BROWN_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static BLUE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static ACACIA_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static CYAN_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static FLETCHING_TABLE: (Internal.FletchingTableBlock) & (Internal.Block);
    static TORCHFLOWER_CROP: (Internal.TorchflowerCropBlock) & (Internal.Block);
    static GRAY_CONCRETE: (Internal.Block) & (Internal.Block);
    static WARPED_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static HORN_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static BROWN_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static END_GATEWAY: (Internal.EndGatewayBlock) & (Internal.Block);
    static DEEPSLATE_TILE_WALL: (Internal.WallBlock) & (Internal.Block);
    static POTTED_ALLIUM: (Internal.FlowerPotBlock) & (Internal.Block);
    static COBBLESTONE: (Internal.Block) & (Internal.Block);
    static OAK_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static CALCITE: (Internal.Block) & (Internal.Block);
    static MANGROVE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static POTTED_OXEYE_DAISY: (Internal.FlowerPotBlock) & (Internal.Block);
    static FIRE_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static OAK_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static STRIPPED_CRIMSON_HYPHAE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static BIRCH_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static TERRACOTTA: (Internal.Block) & (Internal.Block);
    static JUNGLE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static NETHER_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static CYAN_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static BAMBOO_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static END_ROD: (Internal.EndRodBlock) & (Internal.Block);
    static LIGHT_BLUE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static SMOOTH_QUARTZ: (Internal.Block) & (Internal.Block);
    static PRISMARINE: (Internal.Block) & (Internal.Block);
    static SMOOTH_QUARTZ_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static NETHER_QUARTZ_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static MUDDY_MANGROVE_ROOTS: (Internal.RotatedPillarBlock) & (Internal.Block);
    static LIGHT_GRAY_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static MANGROVE_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static DEEPSLATE_TILE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static ATTACHED_PUMPKIN_STEM: (Internal.AttachedStemBlock) & (Internal.Block);
    static CYAN_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static OXIDIZED_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static POLISHED_DEEPSLATE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static POLISHED_DEEPSLATE: (Internal.Block) & (Internal.Block);
    static COCOA: (Internal.CocoaBlock) & (Internal.Block);
    static JUNGLE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static BIRCH_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static SPRUCE_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static POTTED_RED_MUSHROOM: (Internal.FlowerPotBlock) & (Internal.Block);
    static MAGENTA_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static JUNGLE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static WARPED_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static CRIMSON_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static CHEST: (Internal.ChestBlock) & (Internal.Block);
    static SPRUCE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PINK_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static BLACKSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static LIME_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static GILDED_BLACKSTONE: (Internal.Block) & (Internal.Block);
    static SUNFLOWER: (Internal.TallFlowerBlock) & (Internal.Block);
    static ORANGE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static VERDANT_FROGLIGHT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PETRIFIED_OAK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_NETHER_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DRIED_KELP_BLOCK: (Internal.Block) & (Internal.Block);
    static BONE_BLOCK: (Internal.RotatedPillarBlock) & (Internal.Block);
    static WHITE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static POTTED_SPRUCE_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static DEAD_HORN_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static BUBBLE_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static GREEN_CONCRETE: (Internal.Block) & (Internal.Block);
    static CHORUS_FLOWER: (Internal.ChorusFlowerBlock) & (Internal.Block);
    static GRAY_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static SMOOTH_SANDSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static RED_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static YELLOW_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static LIGHT_GRAY_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static PINK_WOOL: (Internal.Block) & (Internal.Block);
    static PINK_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static CYAN_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static DARK_OAK_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static POWERED_RAIL: (Internal.PoweredRailBlock) & (Internal.Block);
    static LIGHT_BLUE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static POWDER_SNOW: (Internal.PowderSnowBlock) & (Internal.Block);
    static ORANGE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static PINK_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static BLACK_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static SPRUCE_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static GRAY_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static WARPED_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static JIGSAW: (Internal.JigsawBlock) & (Internal.Block);
    static WHITE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static SPRUCE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static LIGHT_GRAY_WOOL: (Internal.Block) & (Internal.Block);
    static PISTON: (Internal.PistonBaseBlock) & (Internal.Block);
    static SMOOTH_RED_SANDSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CUT_COPPER_STAIRS: (Internal.WeatheringCopperStairBlock) & (Internal.Block);
    static DIRT: (Internal.Block) & (Internal.Block);
    static BLUE_CONCRETE: (Internal.Block) & (Internal.Block);
    static RED_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static DEAD_BUBBLE_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static OXIDIZED_CUT_COPPER_SLAB: (Internal.WeatheringCopperSlabBlock) & (Internal.Block);
    static TALL_SEAGRASS: (Internal.TallSeagrassBlock) & (Internal.Block);
    static CHORUS_PLANT: (Internal.ChorusPlantBlock) & (Internal.Block);
    static PINK_CONCRETE: (Internal.Block) & (Internal.Block);
    static WHITE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static MOVING_PISTON: (Internal.MovingPistonBlock) & (Internal.Block);
    static CHERRY_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static MANGROVE_ROOTS: (Internal.MangroveRootsBlock) & (Internal.Block);
    static POTTED_ACACIA_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static MANGROVE_PLANKS: (Internal.Block) & (Internal.Block);
    static ACACIA_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static WAXED_OXIDIZED_CUT_COPPER: (Internal.Block) & (Internal.Block);
    static BAMBOO_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static RED_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static BLUE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static BELL: (Internal.BellBlock) & (Internal.Block);
    static MUSHROOM_STEM: (Internal.HugeMushroomBlock) & (Internal.Block);
    static EXPOSED_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static CYAN_CONCRETE: (Internal.Block) & (Internal.Block);
    static POTTED_CRIMSON_ROOTS: (Internal.FlowerPotBlock) & (Internal.Block);
    static GREEN_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static CHISELED_QUARTZ_BLOCK: (Internal.Block) & (Internal.Block);
    static JUNGLE_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static FROGSPAWN: (Internal.FrogspawnBlock) & (Internal.Block);
    static SOUL_TORCH: (Internal.TorchBlock) & (Internal.Block);
    static BOOKSHELF: (Internal.Block) & (Internal.Block);
    static WAXED_EXPOSED_COPPER: (Internal.Block) & (Internal.Block);
    static CRIMSON_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static DIAMOND_BLOCK: (Internal.Block) & (Internal.Block);
    static RED_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static CRIMSON_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static SANDSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static MAGENTA_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static STRIPPED_DARK_OAK_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DEAD_BUBBLE_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static SPRUCE_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static BLUE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static STRIPPED_CHERRY_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CALIBRATED_SCULK_SENSOR: (Internal.CalibratedSculkSensorBlock) & (Internal.Block);
    static AMETHYST_BLOCK: (Internal.AmethystBlock) & (Internal.Block);
    static STRUCTURE_BLOCK: (Internal.StructureBlock) & (Internal.Block);
    static BAMBOO_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static BRAIN_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static BAMBOO_MOSAIC_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static STRIPPED_DARK_OAK_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static SMOOTH_SANDSTONE: (Internal.Block) & (Internal.Block);
    static WAXED_EXPOSED_CUT_COPPER_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BLUE_WOOL: (Internal.Block) & (Internal.Block);
    static IRON_BARS: (Internal.IronBarsBlock) & (Internal.Block);
    static IRON_BLOCK: (Internal.Block) & (Internal.Block);
    static SUSPICIOUS_SAND: (Internal.BrushableBlock) & (Internal.Block);
    static HORN_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static MAGENTA_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static HONEY_BLOCK: (Internal.HoneyBlock) & (Internal.Block);
    static END_STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static JACK_O_LANTERN: (Internal.CarvedPumpkinBlock) & (Internal.Block);
    static TARGET: (Internal.TargetBlock) & (Internal.Block);
    static BRAIN_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static DEAD_FIRE_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static MOSSY_STONE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static BLUE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static WITHER_SKELETON_WALL_SKULL: (Internal.WitherWallSkullBlock) & (Internal.Block);
    static CUT_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static BIRCH_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static ROSE_BUSH: (Internal.TallFlowerBlock) & (Internal.Block);
    static YELLOW_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static LECTERN: (Internal.LecternBlock) & (Internal.Block);
    static CRIMSON_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static DAMAGED_ANVIL: (Internal.AnvilBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static POLISHED_DIORITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static HAY_BLOCK: (Internal.HayBlock) & (Internal.Block);
    static WARPED_HYPHAE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CHERRY_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static MANGROVE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static WEATHERED_CUT_COPPER_SLAB: (Internal.WeatheringCopperSlabBlock) & (Internal.Block);
    static LIME_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static TRIPWIRE_HOOK: (Internal.TripWireHookBlock) & (Internal.Block);
    static CLAY: (Internal.Block) & (Internal.Block);
    static SNOW: (Internal.SnowLayerBlock) & (Internal.Block);
    static WHEAT: (Internal.CropBlock) & (Internal.Block);
    static CYAN_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static WEATHERED_CUT_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static BROWN_MUSHROOM: (Internal.MushroomBlock) & (Internal.Block);
    static SHROOMLIGHT: (Internal.Block) & (Internal.Block);
    static CRIMSON_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static PRISMARINE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static POPPY: (Internal.FlowerBlock) & (Internal.Block);
    static STRUCTURE_VOID: (Internal.StructureVoidBlock) & (Internal.Block);
    static ORANGE_BED: (Internal.BedBlock) & (Internal.Block);
    static DEEPSLATE_COAL_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static PURPLE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static CUT_COPPER_SLAB: (Internal.WeatheringCopperSlabBlock) & (Internal.Block);
    static REDSTONE_BLOCK: (Internal.PoweredBlock) & (Internal.Block);
    static BLACK_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static WAXED_CUT_COPPER_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static GREEN_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static POTTED_AZALEA: (Internal.FlowerPotBlock) & (Internal.Block);
    static LIME_CONCRETE: (Internal.Block) & (Internal.Block);
    static BAMBOO_BLOCK: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PURPLE_WOOL: (Internal.Block) & (Internal.Block);
    static SOUL_FIRE: (Internal.SoulFireBlock) & (Internal.Block);
    static CHISELED_NETHER_BRICKS: (Internal.Block) & (Internal.Block);
    static CRACKED_POLISHED_BLACKSTONE_BRICKS: (Internal.Block) & (Internal.Block);
    static PINK_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static CARTOGRAPHY_TABLE: (Internal.CartographyTableBlock) & (Internal.Block);
    static BLACK_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static GREEN_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static CYAN_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static QUARTZ_BLOCK: (Internal.Block) & (Internal.Block);
    static BAMBOO_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static WHITE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static WAXED_WEATHERED_CUT_COPPER: (Internal.Block) & (Internal.Block);
    static WARPED_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static COMPOSTER: (Internal.ComposterBlock) & (Internal.Block);
    static DARK_OAK_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static ACACIA_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static PITCHER_PLANT: (Internal.DoublePlantBlock) & (Internal.Block);
    static CHISELED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static POTTED_PINK_TULIP: (Internal.FlowerPotBlock) & (Internal.Block);
    static LARGE_FERN: (Internal.DoublePlantBlock) & (Internal.Block);
    static TNT: (Internal.TntBlock) & (Internal.Block);
    static COBBLED_DEEPSLATE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static WARPED_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static SMOOTH_QUARTZ_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static LAVA_CAULDRON: (Internal.LavaCauldronBlock) & (Internal.Block);
    static SCULK_SHRIEKER: (Internal.SculkShriekerBlock) & (Internal.Block);
    static BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static CHISELED_DEEPSLATE: (Internal.Block) & (Internal.Block);
    static AZALEA: (Internal.AzaleaBlock) & (Internal.Block);
    static SMOOTH_STONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static JUNGLE_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static LIME_WOOL: (Internal.Block) & (Internal.Block);
    static LIME_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static GREEN_BED: (Internal.BedBlock) & (Internal.Block);
    static ACTIVATOR_RAIL: (Internal.PoweredRailBlock) & (Internal.Block);
    static SEA_PICKLE: (Internal.SeaPickleBlock) & (Internal.Block);
    static PINK_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static BLUE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static WEATHERED_CUT_COPPER_STAIRS: (Internal.WeatheringCopperStairBlock) & (Internal.Block);
    static CRACKED_STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static FURNACE: (Internal.FurnaceBlock) & (Internal.Block);
    static COBBLESTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MANGROVE_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static CHERRY_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BAMBOO_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static LIGHT_GRAY_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static MANGROVE_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static COBBLESTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static BEDROCK: (Internal.Block) & (Internal.Block);
    static BIRCH_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static PURPLE_BED: (Internal.BedBlock) & (Internal.Block);
    static LIME_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static RED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static GOLD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static SCULK: (Internal.SculkBlock) & (Internal.Block);
    static ACACIA_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static COBWEB: (Internal.WebBlock) & (Internal.Block);
    static CRIMSON_STEM: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PINK_BED: (Internal.BedBlock) & (Internal.Block);
    static STRIPPED_ACACIA_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static BEE_NEST: (Internal.BeehiveBlock) & (Internal.Block);
    static LAVA: (Internal.LiquidBlock) & (Internal.Block);
    static POTTED_WARPED_FUNGUS: (Internal.FlowerPotBlock) & (Internal.Block);
    static NETHER_WART_BLOCK: (Internal.Block) & (Internal.Block);
    static TORCHFLOWER: (Internal.FlowerBlock) & (Internal.Block);
    static ATTACHED_MELON_STEM: (Internal.AttachedStemBlock) & (Internal.Block);
    static DEEPSLATE_EMERALD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static BROWN_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static POTTED_DARK_OAK_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static POTTED_FERN: (Internal.FlowerPotBlock) & (Internal.Block);
    static PUMPKIN: (Internal.PumpkinBlock) & (Internal.Block);
    static EXPOSED_CUT_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static RED_MUSHROOM: (Internal.MushroomBlock) & (Internal.Block);
    static BROWN_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static PURPLE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static ORANGE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static RAW_IRON_BLOCK: (Internal.Block) & (Internal.Block);
    static WALL_TORCH: (Internal.WallTorchBlock) & (Internal.Block);
    static CACTUS: (Internal.CactusBlock) & (Internal.Block);
    static FIRE: (Internal.FireBlock) & (Internal.Block);
    static SLIME_BLOCK: (Internal.SlimeBlock) & (Internal.Block);
    static CHIPPED_ANVIL: (Internal.AnvilBlock) & (Internal.Block);
    static QUARTZ_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static LIGHT_BLUE_BED: (Internal.BedBlock) & (Internal.Block);
    static GREEN_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static JUNGLE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static SOUL_SAND: (Internal.SoulSandBlock) & (Internal.Block);
    static CUT_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MAGENTA_CONCRETE: (Internal.Block) & (Internal.Block);
    static GRANITE: (Internal.Block) & (Internal.Block);
    static LIGHT_GRAY_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static SMOOTH_BASALT: (Internal.Block) & (Internal.Block);
    static DEAD_BUSH: (Internal.DeadBushBlock) & (Internal.Block);
    static DARK_OAK_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static SOUL_CAMPFIRE: (Internal.CampfireBlock) & (Internal.Block);
    static MAGENTA_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static SPRUCE_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static CREEPER_HEAD: (Internal.SkullBlock) & (Internal.Block);
    static BROWN_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static YELLOW_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static DEAD_BUBBLE_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static BLUE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static JUNGLE_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static LIME_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static ACACIA_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static MOSSY_STONE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static TUBE_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static BROWN_BED: (Internal.BedBlock) & (Internal.Block);
    static PURPLE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static LIGHT_GRAY_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static BIG_DRIPLEAF_STEM: (Internal.BigDripleafStemBlock) & (Internal.Block);
    static LIME_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static WARPED_FUNGUS: (Internal.FungusBlock) & (Internal.Block);
    static WHITE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static DARK_OAK_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static STRIPPED_MANGROVE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CRYING_OBSIDIAN: (Internal.CryingObsidianBlock) & (Internal.Block);
    static WAXED_WEATHERED_CUT_COPPER_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MAGENTA_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static POTTED_TORCHFLOWER: (Internal.FlowerPotBlock) & (Internal.Block);
    static STONE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static IRON_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static TRAPPED_CHEST: (Internal.TrappedChestBlock) & (Internal.Block);
    static LIGHT_GRAY_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static OAK_PLANKS: (Internal.Block) & (Internal.Block);
    static FLOWERING_AZALEA_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static POTTED_FLOWERING_AZALEA: (Internal.FlowerPotBlock) & (Internal.Block);
    static POLISHED_ANDESITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BUBBLE_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static ANDESITE_WALL: (Internal.WallBlock) & (Internal.Block);
    static YELLOW_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static BIRCH_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static DEEPSLATE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static SMOOTH_RED_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static BLACKSTONE: (Internal.Block) & (Internal.Block);
    static LIGHT_GRAY_BED: (Internal.BedBlock) & (Internal.Block);
    static STRIPPED_OAK_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PINK_PETALS: (Internal.PinkPetalsBlock) & (Internal.Block);
    static DIORITE: (Internal.Block) & (Internal.Block);
    static SWEET_BERRY_BUSH: (Internal.SweetBerryBushBlock) & (Internal.Block);
    static DECORATED_POT: (Internal.DecoratedPotBlock) & (Internal.Block);
    static INFESTED_STONE_BRICKS: (Internal.InfestedBlock) & (Internal.Block);
    static POTTED_RED_TULIP: (Internal.FlowerPotBlock) & (Internal.Block);
    static RED_TULIP: (Internal.FlowerBlock) & (Internal.Block);
    static BAMBOO_PLANKS: (Internal.Block) & (Internal.Block);
    static BIRCH_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static JUNGLE_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static GREEN_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static BEACON: (Internal.BeaconBlock) & (Internal.Block);
    static DEEPSLATE_LAPIS_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static OAK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BIRCH_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static SANDSTONE: (Internal.Block) & (Internal.Block);
    static SNOW_BLOCK: (Internal.Block) & (Internal.Block);
    static BLACK_BED: (Internal.BedBlock) & (Internal.Block);
    static BROWN_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static POTTED_DEAD_BUSH: (Internal.FlowerPotBlock) & (Internal.Block);
    static STRIPPED_CHERRY_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static GRANITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DEEPSLATE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DARK_OAK_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static WHITE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static DEAD_HORN_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static BAMBOO_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static INFESTED_COBBLESTONE: (Internal.InfestedBlock) & (Internal.Block);
}
type Blocks_ = Blocks;
/**
 * The hub for all things text components. Format text to your hearts content!
*/
declare class Component {
    constructor()
    getClass(): typeof any;
    /**
     * Returns a component of the input, colored light purple
    */
    static lightPurple(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored blue
    */
    static blue(text: any): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key
    */
    static translatable(key: string): Internal.MutableComponent;
    /**
     * Returns a ClickEvent of the input
    */
    static clickEventOf(o: any): Internal.ClickEvent;
    /**
     * Returns a colorful representation of the input nbt. Useful for displaying NBT to the player
    */
    static prettyPrintNbt(tag: Internal.Tag_): Internal.Component;
    /**
     * Returns an empty component
    */
    static empty(): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key, with args of the objects
    */
    static translatable(key: string, ...objects: any[]): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored white
    */
    static white(text: any): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key, with args of the objects
    */
    static translate(key: string, ...objects: any[]): Internal.MutableComponent;
    /**
     * Returns a plain component of the string, or empty if it is an empty string
    */
    static ofString(s: string): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key
    */
    static translate(key: string): Internal.MutableComponent;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    /**
     * Returns a component displaying all entities matching the input selector
    */
    static selector(selector: string): Internal.MutableComponent;
    /**
     * Checks if the passed in component, and all its children are empty
    */
    static isEmpty(component: Internal.Component_): boolean;
    /**
     * Returns a component of the input, colored yellow
    */
    static yellow(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark purple
    */
    static darkPurple(text: any): Internal.MutableComponent;
    /**
     * Returns a Component of the input
    */
    static of(o: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored gray
    */
    static gray(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark blue
    */
    static darkBlue(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark red
    */
    static darkRed(text: any): Internal.MutableComponent;
    toString(): string;
    /**
     * Returns a component of the input, colored gold
    */
    static gold(text: any): Internal.MutableComponent;
    notifyAll(): void;
    /**
     * Returns a component of the input, colored red
    */
    static red(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark green
    */
    static darkGreen(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored green
    */
    static green(text: any): Internal.MutableComponent;
    /**
     * Returns a keybinding component of the input keybinding descriptor
    */
    static keybind(keybind: string): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark aqua
    */
    static darkAqua(text: any): Internal.MutableComponent;
    /**
     * Joins all components
    */
    static join(...texts: Internal.Component_[]): Internal.MutableComponent;
    hashCode(): number;
    /**
     * Returns a score component of the input objective, for the provided selector
    */
    static score(selector: string, objective: string): Internal.MutableComponent;
    /**
     * Returns a plain component of the passed in string, even if empty
    */
    static string(text: string): Internal.MutableComponent;
    wait(): void;
    /**
     * Joins all components in the list with the separator component
    */
    static join(separator: Internal.MutableComponent_, texts: Internal.Iterable_<Internal.Component>): Internal.MutableComponent;
    /**
     * Returns a component displaying all entities matching the input selector, with a custom separator
    */
    static selector(selector: string, separator: Internal.Component_): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored aqua
    */
    static aqua(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored black
    */
    static black(text: any): Internal.MutableComponent;
    wait(arg0: number): void;
    /**
     * Returns a component of the input, colored dark gray
    */
    static darkGray(text: any): Internal.MutableComponent;
    /**
     * Returns a plain component of the input
    */
    static literal(text: string): Internal.MutableComponent;
    equals(arg0: any): boolean;
    get class(): typeof any
}
type Component_ = Component;
/**
 * A collection of utilities
*/
declare interface Utils {
    /**
     * Capitalises the first letter of the string unless it is "a", "an", "the", "of", "on", "in", "and", "or", "but" or "for"
    */
    toTitleCase(s: string): string;
    /**
     * Returns a Stat of the passed in ResourceLocation.
     * Note that this requires the same ResourceLocation to get the same stat, so should not be used unless you want to make your own stat, and are storing an actual ResourceLocation somewhere to access it.
    */
    getStat(id: ResourceLocation_): Internal.Stat<ResourceLocation>;
    /**
     * Returns the provided snake_case_string in Title Case
    */
    snakeCaseToTitleCase(string: string): string;
    /**
     * Returns a new counting map
    */
    newCountingMap(): Internal.CountingMap;
    /**
     * Capitalises the first letter of the string. If ignoreSpecial is true, it will also capitalise articles and prepositions
    */
    toTitleCase(s: string, ignoreSpecial: boolean): string;
    /**
     * Tries to parse the first parameter as a double and returns that. The second parameter is returned if parsing fails
    */
    parseDouble(object: any, def: number): number;
    /**
     * Get a Random, for generating random numbers. Note this will always return the same Random instance
    */
    getRandom(): Internal.Random;
    /**
     * Returns a new mutable list
    */
    newList(): Internal.List<any>;
    /**
     * Returns the results of rolling the specified loot table (it does not have to be a chest loot table)
    */
    rollChestLoot(id: ResourceLocation_): Internal.List<Internal.ItemStack>;
    /**
     * Get a new random with the specified seed
    */
    newRandom(seed: number): Internal.Random;
    /**
     * Gets all ids from the registry with the specified id
    */
    getRegistryIds(id: ResourceLocation_): Internal.List<ResourceLocation>;
    /**
     * Get an immutable empty list
    */
    emptyList<T>(): Internal.List<T>;
    /**
     * Gets the current system time, in milliseconds
    */
    getSystemTime(): number;
    /**
     * Runs the provided supplier function in KubeJS' background thread and returns its CompletableFuture
    */
    supplyAsync(task: Internal.Supplier_<any>): Internal.CompletableFuture<any>;
    /**
     * Returns a ResourceLocation with the specified namepsace and path
    */
    id(namespace: string, path: string): ResourceLocation;
    /**
     * Returns a lazy value with the supplier function as its value factory
    */
    lazy<T>(supplier: Internal.Supplier_<T>): Internal.Lazy<T>;
    /**
     * Checks if the passed in object is an instance of WrappedJS
    */
    isWrapped(o: any): boolean;
    /**
     * Returns the creative tab associated with the id
    */
    findCreativeTab(id: ResourceLocation_): Internal.CreativeModeTab;
    /**
     * Returns the provided snake_case_string in camelCase
    */
    snakeCaseToCamelCase(string: string): string;
    /**
     * Get an immutable empty map
    */
    emptyMap<K, V>(): Internal.Map<K, V>;
    /**
     * Gets a SoundEvent from the id
    */
    getSound(id: ResourceLocation_): Internal.SoundEvent;
    /**
     * Returns a lazy value with the supplier function as its value factory, that will expire after the specified number of milliseconds
    */
    expiringLazy<T>(supplier: Internal.Supplier_<T>, time: number): Internal.Lazy<T>;
    /**
     * Gets a random object from the list using the passed in random
    */
    randomOf(random: Internal.Random_, objects: Internal.Collection_<any>): any;
    /**
     * Returns a new mutable map
    */
    newMap(): Internal.Map<any, any>;
    /**
     * Gets the specified registry
    */
    getRegistry(id: ResourceLocation_): Internal.RegistryInfo<any>;
    particleOptions(o: any): Internal.ParticleOptions;
    /**
     * Returns a copy the object if possible, or the object itself if not
    */
    copy(o: any): any;
    /**
     * Returns a regex pattern of the input with the specified flags
    */
    regex(pattern: string, flags: number): Internal.Pattern;
    /**
     * Typewraps the input string to a ResourceLocation. Format should be namespace:path
    */
    id(id: ResourceLocation_): ResourceLocation;
    /**
     * Returns a regex pattern of the input
    */
    regex(s: any): Internal.Pattern;
    /**
     * Parses a block state from the input string. May throw for invalid inputs!
    */
    parseBlockState(o: any): Internal.BlockState;
    /**
     * Runs the provided runnable function in KubeJS' background thread and returns its CompletableFuture
    */
    runAsync(task: Internal.Runnable_): Internal.CompletableFuture<void>;
    /**
     * Immediately run the passed runnable function in a try-catch block, and log the exception if it throws
    */
    queueIO(runnable: Internal.Runnable_): void;
    /**
     * Tries to parse the first parameter as an integer, and returns that. The second parameter is returned if parsing fails
    */
    parseInt(object: any, def: number): number;
    /**
     * Get the server. Null if there is no server (startup or client)
    */
    getServer(): Internal.MinecraftServer;
    /**
     * Returns the results of rolling the specified loot table with the entity as a parameter (it does not have to be a chest loot table)
    */
    rollChestLoot(id: ResourceLocation_, entity: Internal.Entity_): Internal.List<Internal.ItemStack>;
    /**
     * Get a Random, for generating random numbers. Note this will always return the same Random instance
    */
    get random(): Internal.Random
    /**
     * Gets the current system time, in milliseconds
    */
    get systemTime(): number
    /**
     * Get the server. Null if there is no server (startup or client)
    */
    get server(): Internal.MinecraftServer
    readonly ERROR_PARTICLE: (Internal.DustParticleOptions) & (Internal.DustParticleOptions);
}
type Utils_ = Utils;
declare const Utils: Utils;
declare interface AABB {
    ofSize(vec3: Vec3d_, x: number, y: number, z: number): Internal.AABB;
    ofBlock(pos: BlockPos_): Internal.AABB;
    of(x0: number, y0: number, z0: number, x1: number, y1: number, z1: number): Internal.AABB;
    ofSize(x: number, y: number, z: number): Internal.AABB;
    ofBlocks(pos1: BlockPos_, pos2: BlockPos_): Internal.AABB;
    wrap(o: any): Internal.AABB;
    readonly CUBE: (Internal.AABB) & (Internal.AABB);
    readonly EMPTY: (Internal.AABB) & (Internal.AABB);
}
type AABB_ = AABB;
declare const AABB: AABB;
declare namespace Special {
    type Mod = "fabric_transfer_api_v1" | "fabric_dimensions_v1" | "rhino" | "fabric_renderer_api_v1" | "geckolib" | "kubejs_curios" | "playeranimator" | "customskinloader" | "fabric_item_api_v1" | "fabric_model_loading_api_v1" | "lithostitched" | "fabric_rendering_fluids_v1" | "attributefix" | "fabric_screen_handler_api_v1" | "fabric_models_v0" | "fabric_resource_loader_v0" | "caelus" | "fabric_rendering_v1" | "fabric_renderer_indigo" | "fabric_convention_tags_v1" | "controlling" | "modernfix" | "jei" | "fabric_mining_level_api_v1" | "fabric_command_api_v1" | "fabric_block_view_api_v2" | "fabric_command_api_v2" | "fabric_data_attachment_api_v1" | "maxhealthfix" | "mixinextras" | "bookshelf" | "fabric_screen_api_v1" | "fabric_particles_v1" | "cloth_config" | "forge" | "fabric_api" | "fabric_content_registries_v0" | "konkrete" | "embeddium" | "rubidium" | "fabric_transitive_access_wideners_v1" | "minecraft" | "enchdesc" | "fabric_game_rule_api_v1" | "moonlight" | "fabric_api_base" | "mousetweaks" | "titanium" | "fabric_api_lookup_api_v1" | "fabric_blockrenderlayer_v1" | "jade" | "fabric_block_api_v1" | "fabric_resource_conditions_api_v1" | "kotlinforforge" | "curios" | "entityjs" | "patchouli" | "mutil" | "fabric_item_group_api_v1" | "searchables" | "irons_spellbooks" | "jecharacters" | "fabric_biome_api_v1" | "fabric_entity_events_v1" | "fabric_registry_sync_v0" | "lootjs" | "architectury" | "kubejs" | "appleskin" | "fabric_recipe_api_v1" | "ferritecore" | "fabric_loot_api_v2" | "fabric_object_builder_api_v1" | "lanserverproperties" | "fabric_rendering_data_attachment_v1" | "fabric_networking_api_v1" | "jadeaddons" | "krypton" | "fabric_sound_api_v1" | "probejs" | "fabric_message_api_v1" | "fabric_lifecycle_events_v1" | "fabric_data_generation_api_v1" | "fabric_events_interaction_v0" | "fabric_key_binding_api_v1" | "fabric_client_tags_api_v1"
    type Ingredient = "kubejs:wildcard" | "kubejs:custom" | "kubejs:custom_predicate" | "kubejs:mod" | "kubejs:regex" | "kubejs:creative_tab" | "forge:compound" | "forge:nbt" | "forge:partial_nbt" | "forge:difference" | "forge:intersection" | "minecraft:item" | "fabric:all" | "fabric:any" | "fabric:difference" | "fabric:nbt";
    type Advancement = "minecraft:recipes/building_blocks/waxed_cut_copper_stairs_from_honeycomb" | "minecraft:recipes/building_blocks/weathered_cut_copper_stairs_from_weathered_copper_stonecutting" | "minecraft:recipes/redstone/lever" | "minecraft:nether/obtain_crying_obsidian" | "minecraft:recipes/redstone/acacia_button" | "minecraft:recipes/combat/iron_sword" | "minecraft:recipes/building_blocks/stripped_cherry_wood" | "minecraft:recipes/decorations/brick_wall" | "minecraft:recipes/decorations/gray_glazed_terracotta" | "minecraft:recipes/misc/light_blue_dye_from_blue_orchid" | "minecraft:recipes/misc/magenta_dye_from_lilac" | "minecraft:recipes/building_blocks/stone_bricks" | "minecraft:recipes/redstone/observer" | "minecraft:recipes/building_blocks/polished_deepslate" | "minecraft:recipes/building_blocks/red_nether_brick_slab_from_red_nether_bricks_stonecutting" | "minecraft:recipes/building_blocks/exposed_cut_copper_stairs" | "minecraft:recipes/misc/light_gray_dye_from_white_tulip" | "minecraft:recipes/building_blocks/lime_concrete_powder" | "minecraft:recipes/misc/pink_dye_from_pink_petals" | "minecraft:recipes/tools/iron_pickaxe" | "minecraft:husbandry/allay_deliver_item_to_player" | "minecraft:recipes/combat/leather_helmet" | "minecraft:recipes/building_blocks/polished_blackstone_brick_slab" | "minecraft:husbandry/froglights" | "irons_spellbooks:irons_spellbooks/spell_book_villager" | "minecraft:recipes/building_blocks/polished_granite_stairs" | "minecraft:recipes/building_blocks/copper_block" | "minecraft:recipes/misc/melon_seeds" | "minecraft:recipes/building_blocks/magma_block" | "minecraft:recipes/decorations/blast_furnace" | "minecraft:recipes/decorations/ladder" | "minecraft:recipes/building_blocks/dark_oak_slab" | "minecraft:recipes/building_blocks/dark_prismarine_stairs_from_dark_prismarine_stonecutting" | "minecraft:recipes/decorations/red_nether_brick_wall" | "minecraft:recipes/decorations/magenta_stained_glass_pane" | "irons_spellbooks:irons_spellbooks/enter_catacombs" | "minecraft:recipes/transportation/mangrove_boat" | "minecraft:recipes/redstone/spruce_button" | "minecraft:recipes/building_blocks/stripped_mangrove_wood" | "minecraft:recipes/decorations/torch" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_stairs_from_waxed_weathered_cut_copper_stonecutting" | "minecraft:recipes/building_blocks/smooth_red_sandstone_stairs_from_smooth_red_sandstone_stonecutting" | "minecraft:recipes/misc/popped_chorus_fruit" | "minecraft:nether/distract_piglin" | "minecraft:recipes/building_blocks/stone_brick_slab_from_stone_stonecutting" | "minecraft:recipes/misc/flower_banner_pattern" | "minecraft:recipes/building_blocks/smooth_sandstone_stairs_from_smooth_sandstone_stonecutting" | "minecraft:recipes/building_blocks/lime_terracotta" | "minecraft:recipes/building_blocks/smooth_quartz_slab_from_smooth_quartz_stonecutting" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_stairs_from_honeycomb" | "minecraft:recipes/building_blocks/dark_oak_planks" | "minecraft:recipes/food/cake" | "minecraft:recipes/transportation/detector_rail" | "irons_spellbooks:irons_spellbooks/spell_book_diamond" | "minecraft:recipes/combat/iron_leggings" | "minecraft:recipes/building_blocks/sandstone_stairs" | "minecraft:recipes/redstone/dark_oak_door" | "minecraft:recipes/building_blocks/light_gray_terracotta" | "minecraft:recipes/combat/shield" | "minecraft:recipes/decorations/brown_banner" | "minecraft:recipes/misc/coal_from_smelting_deepslate_coal_ore" | "minecraft:recipes/building_blocks/red_sandstone_stairs" | "minecraft:recipes/decorations/gray_bed" | "minecraft:recipes/food/dried_kelp_from_smoking" | "minecraft:recipes/redstone/hopper" | "minecraft:recipes/misc/emerald_from_smelting_emerald_ore" | "minecraft:recipes/building_blocks/coarse_dirt" | "minecraft:recipes/building_blocks/deepslate_brick_slab_from_polished_deepslate_stonecutting" | "irons_spellbooks:irons_spellbooks/spell_book_druidic" | "minecraft:recipes/redstone/calibrated_sculk_sensor" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_slab_from_waxed_weathered_cut_copper_stonecutting" | "minecraft:recipes/building_blocks/deepslate_tile_stairs_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/building_blocks/light_gray_concrete_powder" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_from_waxed_oxidized_copper_stonecutting" | "minecraft:recipes/misc/dune_armor_trim_smithing_template" | "minecraft:recipes/building_blocks/mangrove_planks" | "minecraft:recipes/decorations/magenta_carpet" | "minecraft:recipes/misc/creeper_banner_pattern" | "minecraft:recipes/building_blocks/oxidized_cut_copper_stairs_from_oxidized_copper_stonecutting" | "minecraft:recipes/misc/lime_dye" | "minecraft:recipes/building_blocks/end_stone_brick_stairs_from_end_stone_brick_stonecutting" | "minecraft:recipes/misc/gold_ingot_from_smelting_raw_gold" | "minecraft:recipes/misc/lapis_lazuli_from_smelting_deepslate_lapis_ore" | "minecraft:recipes/combat/leather_leggings" | "minecraft:recipes/building_blocks/pink_concrete_powder" | "minecraft:recipes/building_blocks/sandstone_slab" | "minecraft:recipes/building_blocks/smooth_basalt" | "minecraft:recipes/misc/emerald" | "minecraft:recipes/misc/shaper_armor_trim_smithing_template" | "minecraft:recipes/building_blocks/andesite_stairs_from_andesite_stonecutting" | "minecraft:recipes/decorations/iron_bars" | "minecraft:recipes/building_blocks/tinted_glass" | "minecraft:recipes/building_blocks/dye_blue_wool" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_stairs_from_waxed_oxidized_cut_copper_stonecutting" | "minecraft:recipes/redstone/crimson_button" | "minecraft:recipes/building_blocks/brick_stairs" | "minecraft:recipes/decorations/deepslate_brick_wall_from_deepslate_bricks_stonecutting" | "minecraft:story/obtain_armor" | "minecraft:recipes/misc/copper_ingot" | "minecraft:recipes/redstone/comparator" | "minecraft:recipes/redstone/mangrove_pressure_plate" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_stairs_from_waxed_oxidized_copper_stonecutting" | "minecraft:recipes/decorations/deepslate_brick_wall_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/building_blocks/dye_purple_wool" | "minecraft:recipes/building_blocks/deepslate_tile_stairs_from_deepslate_tiles_stonecutting" | "minecraft:recipes/transportation/chest_minecart" | "minecraft:recipes/combat/diamond_leggings" | "minecraft:recipes/decorations/gray_stained_glass_pane" | "minecraft:recipes/misc/eye_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/building_blocks/red_stained_glass" | "minecraft:recipes/building_blocks/spruce_planks" | "minecraft:adventure/trim_with_all_exclusive_armor_patterns" | "minecraft:recipes/decorations/lime_stained_glass_pane_from_glass_pane" | "minecraft:adventure/very_very_frightening" | "minecraft:story/lava_bucket" | "minecraft:recipes/food/dried_kelp_from_smelting" | "minecraft:recipes/misc/copper_ingot_from_blasting_deepslate_copper_ore" | "minecraft:recipes/building_blocks/netherite_block" | "minecraft:recipes/building_blocks/polished_diorite_slab" | "minecraft:recipes/building_blocks/quartz_stairs" | "minecraft:recipes/decorations/red_carpet" | "minecraft:recipes/misc/copper_ingot_from_blasting_raw_copper" | "minecraft:recipes/misc/wild_armor_trim_smithing_template" | "minecraft:recipes/building_blocks/smooth_quartz_slab" | "minecraft:recipes/decorations/black_bed" | "minecraft:recipes/transportation/dark_oak_chest_boat" | "minecraft:recipes/building_blocks/end_stone_brick_slab" | "minecraft:husbandry/ride_a_boat_with_a_goat" | "minecraft:recipes/building_blocks/cherry_slab" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_stairs_from_waxed_weathered_copper_stonecutting" | "minecraft:recipes/building_blocks/stone_brick_stairs_from_stone_stonecutting" | "minecraft:recipes/decorations/polished_deepslate_wall" | "minecraft:end/kill_dragon" | "minecraft:recipes/building_blocks/polished_blackstone_brick_stairs" | "minecraft:recipes/building_blocks/deepslate_tile_slab_from_deepslate_tiles_stonecutting" | "minecraft:recipes/building_blocks/mud_brick_slab" | "minecraft:adventure/lightning_rod_with_villager_no_fire" | "minecraft:recipes/misc/host_armor_trim_smithing_template" | "minecraft:recipes/decorations/orange_bed" | "minecraft:recipes/building_blocks/polished_deepslate_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/decorations/orange_candle" | "minecraft:recipes/decorations/stone_brick_wall" | "minecraft:recipes/food/cooked_beef_from_smoking" | "minecraft:recipes/decorations/fletching_table" | "minecraft:recipes/brewing/glistering_melon_slice" | "minecraft:recipes/decorations/pink_stained_glass_pane" | "minecraft:recipes/food/cooked_chicken_from_campfire_cooking" | "minecraft:recipes/misc/light_gray_dye_from_azure_bluet" | "minecraft:recipes/decorations/brown_bed" | "minecraft:recipes/redstone/dark_oak_fence_gate" | "minecraft:recipes/building_blocks/waxed_weathered_copper_from_honeycomb" | "minecraft:recipes/misc/iron_nugget_from_smelting" | "minecraft:recipes/food/cooked_mutton_from_smoking" | "minecraft:recipes/building_blocks/cracked_nether_bricks" | "minecraft:recipes/building_blocks/deepslate_bricks" | "minecraft:recipes/building_blocks/polished_deepslate_slab_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/decorations/prismarine_wall_from_prismarine_stonecutting" | "minecraft:recipes/building_blocks/dye_light_gray_bed" | "minecraft:nether/all_potions" | "minecraft:recipes/building_blocks/waxed_cut_copper_stairs_from_waxed_cut_copper_stonecutting" | "minecraft:recipes/misc/emerald_from_blasting_emerald_ore" | "minecraft:recipes/misc/wild_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/building_blocks/smooth_quartz" | "minecraft:recipes/building_blocks/polished_diorite_stairs" | "minecraft:recipes/misc/diamond_from_smelting_deepslate_diamond_ore" | "minecraft:recipes/misc/copper_ingot_from_smelting_copper_ore" | "minecraft:recipes/building_blocks/dye_brown_bed" | "minecraft:recipes/combat/netherite_boots_smithing" | "minecraft:recipes/misc/light_blue_dye_from_blue_white_dye" | "minecraft:recipes/misc/blue_dye" | "minecraft:recipes/misc/gold_ingot_from_gold_block" | "minecraft:recipes/building_blocks/light_blue_stained_glass" | "minecraft:recipes/building_blocks/orange_concrete_powder" | "minecraft:recipes/food/baked_potato_from_campfire_cooking" | "minecraft:recipes/food/cooked_porkchop" | "minecraft:recipes/building_blocks/oak_slab" | "minecraft:recipes/decorations/blue_stained_glass_pane" | "minecraft:husbandry/tame_an_animal" | "minecraft:recipes/building_blocks/chiseled_polished_blackstone" | "minecraft:recipes/building_blocks/raw_copper_block" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_slab_from_waxed_exposed_copper_stonecutting" | "minecraft:recipes/building_blocks/granite_stairs" | "minecraft:recipes/misc/lapis_lazuli_from_blasting_lapis_ore" | "minecraft:recipes/decorations/cyan_glazed_terracotta" | "minecraft:recipes/misc/cyan_dye" | "minecraft:adventure/craft_decorated_pot_using_only_sherds" | "minecraft:recipes/building_blocks/dye_red_bed" | "minecraft:recipes/decorations/purple_bed" | "minecraft:husbandry/make_a_sign_glow" | "minecraft:recipes/building_blocks/dye_black_bed" | "minecraft:recipes/decorations/polished_deepslate_wall_from_polished_deepslate_stonecutting" | "minecraft:recipes/food/cooked_salmon_from_smoking" | "minecraft:recipes/tools/brush" | "minecraft:recipes/building_blocks/dye_lime_wool" | "minecraft:recipes/redstone/acacia_pressure_plate" | "minecraft:recipes/decorations/cyan_candle" | "minecraft:recipes/building_blocks/diorite_stairs_from_diorite_stonecutting" | "minecraft:recipes/tools/netherite_shovel_smithing" | "minecraft:recipes/brewing/glass_bottle" | "minecraft:recipes/decorations/acacia_hanging_sign" | "minecraft:recipes/building_blocks/stripped_acacia_wood" | "minecraft:recipes/building_blocks/dye_gray_carpet" | "minecraft:nether/create_beacon" | "minecraft:recipes/decorations/light_gray_glazed_terracotta" | "minecraft:recipes/misc/leather" | "minecraft:recipes/building_blocks/crimson_slab" | "minecraft:recipes/building_blocks/mossy_stone_bricks_from_vine" | "minecraft:recipes/decorations/light_gray_bed" | "minecraft:recipes/redstone/birch_button" | "minecraft:recipes/building_blocks/quartz_slab" | "minecraft:recipes/building_blocks/crimson_stairs" | "minecraft:recipes/building_blocks/blackstone_stairs" | "minecraft:recipes/building_blocks/jungle_wood" | "irons_spellbooks:irons_spellbooks/make_scroll_forge" | "minecraft:recipes/combat/netherite_chestplate_smithing" | "minecraft:recipes/decorations/red_nether_brick_wall_from_red_nether_bricks_stonecutting" | "irons_spellbooks:irons_spellbooks/staff_root" | "minecraft:recipes/decorations/purple_glazed_terracotta" | "minecraft:recipes/building_blocks/green_stained_glass" | "minecraft:recipes/misc/lime_dye_from_smelting" | "minecraft:story/deflect_arrow" | "minecraft:recipes/building_blocks/blackstone_slab_from_blackstone_stonecutting" | "minecraft:recipes/building_blocks/bamboo_mosaic_slab" | "minecraft:recipes/decorations/yellow_glazed_terracotta" | "minecraft:recipes/redstone/cherry_fence_gate" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_stairs" | "minecraft:recipes/transportation/bamboo_chest_raft" | "minecraft:recipes/building_blocks/chiseled_red_sandstone_from_red_sandstone_stonecutting" | "minecraft:recipes/building_blocks/bookshelf" | "minecraft:recipes/decorations/cyan_banner" | "minecraft:recipes/tools/golden_axe" | "minecraft:husbandry/leash_all_frog_variants" | "minecraft:recipes/building_blocks/jungle_planks" | "minecraft:recipes/decorations/red_banner" | "minecraft:recipes/building_blocks/raw_gold_block" | "minecraft:recipes/building_blocks/dye_red_wool" | "minecraft:recipes/combat/iron_boots" | "minecraft:recipes/building_blocks/chiseled_quartz_block" | "minecraft:recipes/building_blocks/birch_planks" | "minecraft:recipes/redstone/bamboo_trapdoor" | "minecraft:story/iron_tools" | "minecraft:recipes/building_blocks/deepslate_tile_stairs_from_deepslate_bricks_stonecutting" | "minecraft:recipes/decorations/orange_banner" | "minecraft:recipes/decorations/polished_blackstone_brick_wall_from_blackstone_stonecutting" | "minecraft:recipes/combat/iron_chestplate" | "minecraft:recipes/building_blocks/polished_blackstone_slab_from_blackstone_stonecutting" | "minecraft:recipes/misc/gold_ingot_from_blasting_deepslate_gold_ore" | "minecraft:recipes/redstone/spruce_pressure_plate" | "minecraft:recipes/redstone/dark_oak_trapdoor" | "minecraft:recipes/decorations/oak_sign" | "minecraft:recipes/redstone/oak_trapdoor" | "minecraft:recipes/building_blocks/granite_stairs_from_granite_stonecutting" | "minecraft:recipes/building_blocks/prismarine_brick_stairs_from_prismarine_stonecutting" | "minecraft:recipes/misc/gold_ingot_from_blasting_gold_ore" | "minecraft:recipes/building_blocks/red_concrete_powder" | "minecraft:recipes/decorations/magenta_glazed_terracotta" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_slab_from_waxed_weathered_copper_stonecutting" | "minecraft:recipes/tools/golden_pickaxe" | "minecraft:recipes/building_blocks/dye_light_blue_wool" | "minecraft:recipes/building_blocks/polished_granite_stairs_from_polished_granite_stonecutting" | "minecraft:recipes/redstone/sticky_piston" | "minecraft:recipes/brewing/magma_cream" | "minecraft:recipes/building_blocks/mud_brick_stairs" | "minecraft:recipes/building_blocks/dye_blue_carpet" | "minecraft:recipes/building_blocks/deepslate_brick_stairs_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/building_blocks/oxidized_cut_copper_slab" | "minecraft:recipes/misc/book" | "minecraft:recipes/building_blocks/purpur_slab" | "minecraft:recipes/building_blocks/dye_light_gray_wool" | "minecraft:nether/brew_potion" | "minecraft:recipes/combat/stone_sword" | "minecraft:recipes/decorations/cobblestone_wall" | "minecraft:recipes/building_blocks/polished_deepslate_slab" | "minecraft:recipes/decorations/magenta_banner" | "minecraft:recipes/brewing/fermented_spider_eye" | "minecraft:recipes/misc/iron_ingot_from_smelting_raw_iron" | "minecraft:recipes/misc/dune_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/tools/stone_pickaxe" | "minecraft:recipes/building_blocks/deepslate_brick_slab_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/building_blocks/quartz_bricks" | "minecraft:recipes/decorations/deepslate_tile_wall_from_deepslate_tiles_stonecutting" | "minecraft:recipes/building_blocks/brown_stained_glass" | "minecraft:recipes/decorations/deepslate_brick_wall" | "minecraft:recipes/decorations/purple_stained_glass_pane_from_glass_pane" | "minecraft:recipes/misc/purple_dye" | "minecraft:recipes/misc/black_dye" | "minecraft:recipes/building_blocks/waxed_cut_copper_from_waxed_copper_block_stonecutting" | "minecraft:end/dragon_egg" | "minecraft:recipes/building_blocks/light_gray_stained_glass" | "minecraft:recipes/decorations/brown_carpet" | "minecraft:recipes/food/honey_bottle" | "minecraft:adventure/kill_mob_near_sculk_catalyst" | "minecraft:recipes/building_blocks/dried_kelp_block" | "minecraft:recipes/building_blocks/end_stone_brick_slab_from_end_stone_brick_stonecutting" | "minecraft:recipes/decorations/red_stained_glass_pane" | "minecraft:husbandry/fishy_business" | "minecraft:recipes/building_blocks/quartz_bricks_from_quartz_block_stonecutting" | "minecraft:recipes/food/dried_kelp_from_campfire_cooking" | "minecraft:recipes/misc/light_gray_dye_from_gray_white_dye" | "minecraft:recipes/building_blocks/lapis_block" | "minecraft:recipes/combat/netherite_sword_smithing" | "minecraft:recipes/decorations/acacia_sign" | "minecraft:recipes/building_blocks/brick_slab" | "minecraft:recipes/misc/iron_ingot_from_smelting_iron_ore" | "minecraft:recipes/food/cooked_cod_from_smoking" | "minecraft:recipes/decorations/lantern" | "minecraft:recipes/decorations/cherry_sign" | "minecraft:recipes/building_blocks/waxed_oxidized_copper_from_honeycomb" | "minecraft:nether/explore_nether" | "minecraft:recipes/building_blocks/prismarine" | "minecraft:recipes/misc/diamond" | "minecraft:recipes/misc/gold_nugget_from_smelting" | "minecraft:recipes/building_blocks/polished_diorite" | "minecraft:recipes/building_blocks/cobbled_deepslate_slab_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/decorations/mangrove_fence" | "minecraft:recipes/food/cooked_chicken" | "minecraft:recipes/building_blocks/dye_white_carpet" | "minecraft:recipes/building_blocks/white_terracotta" | "minecraft:recipes/misc/orange_dye_from_red_yellow" | "minecraft:recipes/misc/netherite_upgrade_smithing_template" | "minecraft:recipes/misc/brown_dye" | "minecraft:recipes/tools/stone_axe" | "minecraft:recipes/building_blocks/raw_iron_block" | "minecraft:recipes/food/cooked_mutton" | "minecraft:recipes/misc/white_dye_from_lily_of_the_valley" | "minecraft:recipes/building_blocks/deepslate_tile_stairs" | "minecraft:recipes/building_blocks/polished_blackstone_bricks_from_polished_blackstone_stonecutting" | "minecraft:adventure/fall_from_world_height" | "minecraft:recipes/misc/gold_ingot_from_blasting_nether_gold_ore" | "minecraft:recipes/building_blocks/dye_orange_bed" | "minecraft:recipes/building_blocks/mud_brick_slab_from_mud_bricks_stonecutting" | "minecraft:recipes/decorations/blue_candle" | "minecraft:recipes/food/rabbit_stew_from_brown_mushroom" | "minecraft:recipes/building_blocks/magenta_concrete_powder" | "minecraft:recipes/decorations/blue_bed" | "minecraft:recipes/building_blocks/dye_light_blue_bed" | "minecraft:recipes/decorations/green_bed" | "minecraft:recipes/decorations/lime_carpet" | "minecraft:nether/ride_strider" | "minecraft:adventure/sniper_duel" | "minecraft:recipes/building_blocks/polished_andesite_stairs" | "minecraft:recipes/transportation/furnace_minecart" | "minecraft:recipes/building_blocks/cut_sandstone_from_sandstone_stonecutting" | "minecraft:recipes/building_blocks/stone_brick_slab_from_stone_bricks_stonecutting" | "minecraft:nether/root" | "minecraft:recipes/decorations/campfire" | "minecraft:recipes/misc/spire_armor_trim_smithing_template" | "minecraft:recipes/decorations/lime_stained_glass_pane" | "minecraft:recipes/misc/snout_armor_trim_smithing_template" | "minecraft:recipes/building_blocks/waxed_cut_copper_slab_from_honeycomb" | "minecraft:recipes/misc/iron_nugget" | "minecraft:recipes/transportation/hopper_minecart" | "minecraft:recipes/building_blocks/brown_concrete_powder" | "minecraft:recipes/building_blocks/stone_slab_from_stone_stonecutting" | "minecraft:recipes/building_blocks/end_stone_brick_slab_from_end_stone_stonecutting" | "minecraft:end/levitate" | "minecraft:recipes/building_blocks/deepslate_tile_slab_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/decorations/blue_stained_glass_pane_from_glass_pane" | "minecraft:recipes/misc/netherite_scrap_from_blasting" | "minecraft:recipes/combat/diamond_sword" | "minecraft:recipes/decorations/cyan_stained_glass_pane" | "minecraft:recipes/building_blocks/blue_stained_glass" | "minecraft:recipes/misc/white_dye" | "minecraft:recipes/building_blocks/stripped_warped_hyphae" | "minecraft:recipes/decorations/jukebox" | "minecraft:recipes/building_blocks/cracked_stone_bricks" | "minecraft:recipes/building_blocks/terracotta" | "minecraft:recipes/tools/flint_and_steel" | "minecraft:recipes/misc/red_dye_from_beetroot" | "minecraft:recipes/misc/silence_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/building_blocks/dye_purple_carpet" | "minecraft:recipes/building_blocks/nether_bricks" | "minecraft:recipes/decorations/end_stone_brick_wall_from_end_stone_brick_stonecutting" | "minecraft:recipes/building_blocks/cut_copper_slab_from_cut_copper_stonecutting" | "minecraft:recipes/misc/gold_nugget" | "minecraft:recipes/misc/sugar_from_sugar_cane" | "minecraft:recipes/misc/iron_ingot_from_blasting_iron_ore" | "minecraft:recipes/building_blocks/dye_magenta_bed" | "minecraft:recipes/redstone/jungle_trapdoor" | "minecraft:recipes/tools/wooden_hoe" | "minecraft:recipes/building_blocks/smooth_sandstone_slab_from_smooth_sandstone_stonecutting" | "minecraft:recipes/decorations/respawn_anchor" | "minecraft:nether/all_effects" | "minecraft:recipes/misc/bucket" | "minecraft:recipes/building_blocks/diorite_slab" | "minecraft:adventure/bullseye" | "minecraft:recipes/building_blocks/stone_brick_stairs_from_stone_bricks_stonecutting" | "minecraft:recipes/building_blocks/chiseled_sandstone_from_sandstone_stonecutting" | "minecraft:recipes/building_blocks/polished_deepslate_slab_from_polished_deepslate_stonecutting" | "minecraft:recipes/decorations/granite_wall" | "minecraft:recipes/decorations/orange_stained_glass_pane" | "minecraft:recipes/decorations/white_banner" | "minecraft:recipes/building_blocks/light_blue_concrete_powder" | "minecraft:recipes/building_blocks/orange_terracotta" | "minecraft:recipes/decorations/mossy_cobblestone_wall" | "minecraft:recipes/misc/silence_armor_trim_smithing_template" | "minecraft:recipes/building_blocks/glass" | "minecraft:recipes/decorations/white_glazed_terracotta" | "minecraft:recipes/combat/iron_helmet" | "minecraft:recipes/tools/golden_shovel" | "minecraft:recipes/combat/bow" | "minecraft:nether/get_wither_skull" | "minecraft:recipes/food/cooked_chicken_from_smoking" | "minecraft:recipes/redstone/oak_fence_gate" | "minecraft:recipes/building_blocks/acacia_slab" | "minecraft:recipes/building_blocks/smooth_sandstone" | "irons_spellbooks:irons_spellbooks/make_wayward_compass" | "minecraft:recipes/building_blocks/oxidized_cut_copper" | "minecraft:husbandry/bred_all_animals" | "minecraft:recipes/building_blocks/dye_magenta_wool" | "minecraft:recipes/building_blocks/dye_magenta_carpet" | "minecraft:recipes/decorations/diorite_wall_from_diorite_stonecutting" | "minecraft:recipes/combat/diamond_chestplate" | "minecraft:story/mine_stone" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_slab_from_waxed_oxidized_cut_copper_stonecutting" | "minecraft:recipes/decorations/furnace" | "minecraft:recipes/transportation/minecart" | "minecraft:recipes/decorations/orange_glazed_terracotta" | "minecraft:recipes/food/beetroot_soup" | "minecraft:recipes/building_blocks/andesite_stairs" | "minecraft:recipes/misc/charcoal" | "minecraft:recipes/decorations/green_stained_glass_pane" | "minecraft:recipes/tools/iron_hoe" | "minecraft:recipes/tools/wooden_pickaxe" | "minecraft:recipes/building_blocks/cobbled_deepslate_stairs" | "minecraft:recipes/building_blocks/deepslate_tile_stairs_from_polished_deepslate_stonecutting" | "minecraft:recipes/building_blocks/mossy_stone_brick_stairs" | "minecraft:recipes/building_blocks/stone_brick_slab" | "minecraft:recipes/redstone/redstone_torch" | "minecraft:recipes/redstone/cherry_pressure_plate" | "minecraft:recipes/redstone/warped_pressure_plate" | "minecraft:recipes/food/golden_apple" | "minecraft:recipes/misc/gold_ingot_from_blasting_raw_gold" | "minecraft:recipes/building_blocks/polished_granite_slab_from_granite_stonecutting" | "minecraft:recipes/building_blocks/green_concrete_powder" | "minecraft:recipes/building_blocks/polished_andesite_from_andesite_stonecutting" | "minecraft:recipes/tools/iron_shovel" | "irons_spellbooks:irons_spellbooks/spell_book_iron" | "minecraft:recipes/building_blocks/dark_oak_wood" | "minecraft:recipes/building_blocks/chiseled_polished_blackstone_from_polished_blackstone_stonecutting" | "minecraft:recipes/building_blocks/orange_stained_glass" | "irons_spellbooks:irons_spellbooks/spell_book_dragon" | "minecraft:recipes/building_blocks/polished_blackstone" | "irons_spellbooks:irons_spellbooks/staff_ice" | "minecraft:recipes/misc/diamond_from_smelting_diamond_ore" | "minecraft:recipes/misc/bowl" | "minecraft:recipes/food/cooked_salmon_from_campfire_cooking" | "minecraft:recipes/building_blocks/dye_orange_carpet" | "minecraft:recipes/decorations/item_frame" | "minecraft:recipes/building_blocks/waxed_cut_copper_slab" | "minecraft:recipes/tools/clock" | "minecraft:recipes/food/baked_potato_from_smoking" | "minecraft:recipes/building_blocks/cut_copper_slab" | "minecraft:adventure/two_birds_one_arrow" | "minecraft:recipes/decorations/end_crystal" | "minecraft:story/enter_the_nether" | "minecraft:recipes/decorations/red_glazed_terracotta" | "minecraft:adventure/whos_the_pillager_now" | "minecraft:recipes/building_blocks/smooth_sandstone_stairs" | "minecraft:recipes/food/baked_potato" | "minecraft:recipes/decorations/black_stained_glass_pane_from_glass_pane" | "irons_spellbooks:irons_spellbooks/staff_artificer" | "minecraft:recipes/redstone/birch_door" | "minecraft:recipes/redstone/bamboo_pressure_plate" | "minecraft:recipes/decorations/green_banner" | "minecraft:recipes/misc/gold_ingot_from_nuggets" | "minecraft:recipes/building_blocks/cut_red_sandstone_slab" | "minecraft:recipes/decorations/red_candle" | "minecraft:recipes/misc/lapis_lazuli" | "minecraft:recipes/misc/coast_armor_trim_smithing_template" | "minecraft:recipes/misc/ward_armor_trim_smithing_template_smithing_trim" | "minecraft:story/upgrade_tools" | "minecraft:recipes/combat/diamond_helmet" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_stairs_from_waxed_exposed_cut_copper_stonecutting" | "minecraft:recipes/decorations/snow" | "minecraft:recipes/decorations/soul_lantern" | "minecraft:recipes/misc/sentry_armor_trim_smithing_template" | "minecraft:recipes/building_blocks/oxidized_cut_copper_from_oxidized_copper_stonecutting" | "minecraft:recipes/decorations/cherry_fence" | "minecraft:recipes/decorations/birch_fence" | "minecraft:recipes/decorations/sandstone_wall_from_sandstone_stonecutting" | "minecraft:recipes/misc/pink_dye_from_pink_tulip" | "minecraft:recipes/building_blocks/mangrove_stairs" | "minecraft:recipes/misc/eye_armor_trim_smithing_template" | "minecraft:recipes/building_blocks/stone_brick_stairs" | "minecraft:recipes/combat/golden_boots" | "minecraft:adventure/walk_on_powder_snow_with_leather_boots" | "irons_spellbooks:irons_spellbooks/make_arcane_anvil" | "minecraft:recipes/tools/wooden_axe" | "minecraft:recipes/decorations/spruce_sign" | "minecraft:recipes/misc/wayfinder_armor_trim_smithing_template" | "minecraft:recipes/misc/raiser_armor_trim_smithing_template" | "minecraft:recipes/misc/sentry_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/building_blocks/waxed_cut_copper_slab_from_waxed_cut_copper_stonecutting" | "minecraft:recipes/misc/gold_ingot_from_smelting_gold_ore" | "minecraft:recipes/building_blocks/stone_bricks_from_stone_stonecutting" | "minecraft:recipes/building_blocks/chiseled_nether_bricks_from_nether_bricks_stonecutting" | "minecraft:husbandry/tactical_fishing" | "minecraft:recipes/building_blocks/chiseled_sandstone" | "minecraft:adventure/salvage_sherd" | "minecraft:recipes/building_blocks/bricks" | "minecraft:recipes/building_blocks/chiseled_stone_bricks_from_stone_bricks_stonecutting" | "minecraft:recipes/combat/netherite_leggings_smithing" | "minecraft:recipes/decorations/painting" | "minecraft:recipes/decorations/pink_bed" | "minecraft:recipes/building_blocks/waxed_cut_copper" | "minecraft:recipes/building_blocks/red_terracotta" | "minecraft:recipes/misc/coal_from_blasting_deepslate_coal_ore" | "irons_spellbooks:irons_spellbooks/spell_book_netherite" | "irons_spellbooks:irons_spellbooks/staff_lightning_rod" | "minecraft:recipes/building_blocks/stone_slab" | "minecraft:recipes/combat/arrow" | "minecraft:recipes/decorations/black_carpet" | "minecraft:story/cure_zombie_villager" | "minecraft:recipes/misc/gold_nugget_from_blasting" | "minecraft:recipes/decorations/yellow_stained_glass_pane" | "minecraft:recipes/building_blocks/blue_concrete_powder" | "minecraft:recipes/building_blocks/cyan_stained_glass" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_slab_from_honeycomb" | "minecraft:recipes/tools/netherite_axe_smithing" | "minecraft:recipes/building_blocks/granite_slab_from_granite_stonecutting" | "minecraft:recipes/building_blocks/polished_deepslate_stairs_from_polished_deepslate_stonecutting" | "minecraft:recipes/decorations/jungle_sign" | "minecraft:recipes/misc/vex_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/redstone/mangrove_trapdoor" | "irons_spellbooks:irons_spellbooks/ink_root" | "minecraft:recipes/tools/recovery_compass" | "minecraft:recipes/building_blocks/andesite" | "minecraft:recipes/building_blocks/crimson_planks" | "minecraft:recipes/combat/golden_helmet" | "minecraft:recipes/building_blocks/cut_sandstone_slab_from_sandstone_stonecutting" | "minecraft:recipes/redstone/acacia_trapdoor" | "minecraft:recipes/building_blocks/exposed_cut_copper_from_exposed_copper_stonecutting" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_from_waxed_exposed_copper_stonecutting" | "minecraft:recipes/redstone/oak_pressure_plate" | "minecraft:recipes/building_blocks/cut_sandstone" | "minecraft:recipes/building_blocks/brick_slab_from_bricks_stonecutting" | "minecraft:recipes/building_blocks/smooth_red_sandstone" | "minecraft:recipes/building_blocks/black_terracotta" | "minecraft:recipes/decorations/blackstone_wall" | "minecraft:recipes/misc/cyan_dye_from_pitcher_plant" | "minecraft:recipes/building_blocks/polished_blackstone_stairs_from_polished_blackstone_stonecutting" | "minecraft:recipes/building_blocks/weathered_cut_copper_slab_from_weathered_cut_copper_stonecutting" | "minecraft:recipes/food/cooked_salmon" | "minecraft:recipes/building_blocks/blackstone_slab" | "minecraft:recipes/building_blocks/cherry_stairs" | "minecraft:husbandry/feed_snifflet" | "minecraft:recipes/building_blocks/sandstone_slab_from_sandstone_stonecutting" | "minecraft:recipes/redstone/dropper" | "minecraft:recipes/decorations/purple_candle" | "minecraft:recipes/decorations/pink_glazed_terracotta" | "minecraft:recipes/misc/coal" | "minecraft:recipes/transportation/spruce_chest_boat" | "minecraft:end/find_end_city" | "minecraft:story/form_obsidian" | "minecraft:recipes/food/cooked_rabbit" | "minecraft:recipes/misc/netherite_ingot_from_netherite_block" | "minecraft:recipes/redstone/mangrove_fence_gate" | "minecraft:end/enter_end_gateway" | "minecraft:recipes/combat/leather_chestplate" | "minecraft:recipes/building_blocks/bamboo_slab" | "minecraft:recipes/misc/magenta_dye_from_blue_red_pink" | "minecraft:recipes/decorations/yellow_candle" | "minecraft:recipes/building_blocks/dye_light_blue_carpet" | "minecraft:nether/obtain_blaze_rod" | "minecraft:recipes/building_blocks/polished_andesite" | "minecraft:recipes/building_blocks/polished_blackstone_slab_from_polished_blackstone_stonecutting" | "minecraft:recipes/decorations/lime_glazed_terracotta" | "minecraft:recipes/building_blocks/purpur_block" | "minecraft:recipes/decorations/composter" | "minecraft:recipes/building_blocks/red_nether_brick_stairs_from_red_nether_bricks_stonecutting" | "minecraft:nether/loot_bastion" | "minecraft:recipes/redstone/oak_door" | "minecraft:recipes/building_blocks/dye_yellow_carpet" | "minecraft:adventure/shoot_arrow" | "minecraft:recipes/misc/iron_ingot_from_iron_block" | "minecraft:recipes/building_blocks/polished_blackstone_stairs" | "minecraft:recipes/building_blocks/end_stone_bricks" | "minecraft:recipes/building_blocks/exposed_cut_copper_slab_from_exposed_cut_copper_stonecutting" | "minecraft:recipes/decorations/glow_item_frame" | "minecraft:recipes/transportation/carrot_on_a_stick" | "minecraft:husbandry/silk_touch_nest" | "minecraft:recipes/building_blocks/dark_prismarine_stairs" | "minecraft:recipes/building_blocks/dye_cyan_wool" | "minecraft:recipes/decorations/andesite_wall_from_andesite_stonecutting" | "minecraft:recipes/redstone/jungle_door" | "minecraft:recipes/building_blocks/waxed_cut_copper_from_honeycomb" | "minecraft:recipes/building_blocks/nether_brick_stairs" | "minecraft:recipes/decorations/end_stone_brick_wall_from_end_stone_stonecutting" | "minecraft:recipes/building_blocks/polished_granite" | "minecraft:recipes/building_blocks/polished_blackstone_brick_slab_from_blackstone_stonecutting" | "minecraft:recipes/redstone/birch_trapdoor" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_slab" | "minecraft:recipes/building_blocks/chiseled_red_sandstone" | "minecraft:recipes/redstone/spruce_trapdoor" | "minecraft:recipes/building_blocks/muddy_mangrove_roots" | "minecraft:recipes/building_blocks/red_sandstone_slab_from_red_sandstone_stonecutting" | "minecraft:recipes/decorations/light_gray_stained_glass_pane_from_glass_pane" | "minecraft:recipes/misc/quartz" | "minecraft:adventure/arbalistic" | "minecraft:recipes/decorations/pink_candle" | "minecraft:recipes/building_blocks/smooth_red_sandstone_slab" | "minecraft:end/respawn_dragon" | "minecraft:recipes/decorations/polished_blackstone_brick_wall_from_polished_blackstone_bricks_stonecutting" | "minecraft:recipes/decorations/soul_campfire" | "minecraft:recipes/decorations/light_gray_candle" | "minecraft:story/smelt_iron" | "minecraft:recipes/misc/orange_dye_from_torchflower" | "minecraft:recipes/building_blocks/melon" | "minecraft:recipes/building_blocks/deepslate_brick_stairs" | "minecraft:recipes/decorations/light_blue_bed" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_slab_from_waxed_exposed_cut_copper_stonecutting" | "minecraft:recipes/building_blocks/pink_stained_glass" | "minecraft:recipes/building_blocks/warped_slab" | "minecraft:recipes/tools/fishing_rod" | "irons_spellbooks:irons_spellbooks/spell_book_equip" | "minecraft:recipes/decorations/purple_stained_glass_pane" | "minecraft:recipes/decorations/smoker" | "minecraft:recipes/food/cooked_mutton_from_campfire_cooking" | "minecraft:recipes/building_blocks/black_stained_glass" | "minecraft:recipes/building_blocks/brick_stairs_from_bricks_stonecutting" | "minecraft:recipes/building_blocks/polished_andesite_slab" | "minecraft:recipes/building_blocks/polished_blackstone_brick_stairs_from_polished_blackstone_stonecutting" | "minecraft:nether/charge_respawn_anchor" | "minecraft:recipes/redstone/spruce_door" | "minecraft:recipes/building_blocks/chiseled_deepslate_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/building_blocks/bamboo_planks" | "minecraft:recipes/building_blocks/cracked_polished_blackstone_bricks" | "minecraft:recipes/decorations/yellow_stained_glass_pane_from_glass_pane" | "minecraft:recipes/building_blocks/chiseled_stone_bricks" | "minecraft:recipes/building_blocks/nether_brick_slab" | "minecraft:recipes/building_blocks/gray_stained_glass" | "minecraft:recipes/building_blocks/crimson_hyphae" | "minecraft:recipes/building_blocks/dye_orange_wool" | "minecraft:recipes/building_blocks/yellow_concrete_powder" | "minecraft:recipes/redstone/spruce_fence_gate" | "minecraft:recipes/misc/pumpkin_seeds" | "minecraft:recipes/decorations/crafting_table" | "minecraft:recipes/building_blocks/purple_stained_glass" | "minecraft:recipes/building_blocks/cut_copper_stairs_from_copper_block_stonecutting" | "minecraft:recipes/misc/map" | "minecraft:recipes/combat/golden_sword" | "minecraft:recipes/decorations/chest" | "minecraft:recipes/decorations/mud_brick_wall" | "minecraft:story/shiny_gear" | "minecraft:end/elytra" | "minecraft:recipes/building_blocks/chiseled_stone_bricks_stone_from_stonecutting" | "minecraft:recipes/building_blocks/cobbled_deepslate_slab" | "minecraft:recipes/building_blocks/red_sandstone" | "minecraft:recipes/decorations/mangrove_sign" | "minecraft:recipes/tools/wooden_shovel" | "minecraft:husbandry/tadpole_in_a_bucket" | "minecraft:recipes/decorations/bamboo_mosaic" | "minecraft:recipes/building_blocks/purpur_stairs" | "minecraft:recipes/redstone/dark_oak_button" | "minecraft:recipes/tools/shears" | "minecraft:recipes/misc/stick" | "minecraft:recipes/redstone/crimson_pressure_plate" | "minecraft:recipes/redstone/redstone_lamp" | "minecraft:husbandry/wax_off" | "minecraft:recipes/building_blocks/mossy_cobblestone_slab_from_mossy_cobblestone_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone_brick_slab_from_polished_blackstone_bricks_stonecutting" | "minecraft:recipes/redstone/polished_blackstone_button" | "minecraft:recipes/decorations/blue_carpet" | "minecraft:recipes/misc/snout_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/building_blocks/dye_white_wool" | "minecraft:recipes/decorations/beehive" | "minecraft:recipes/decorations/crimson_fence" | "minecraft:recipes/redstone/dispenser" | "minecraft:recipes/misc/rib_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/tools/netherite_hoe_smithing" | "minecraft:recipes/decorations/light_blue_glazed_terracotta" | "minecraft:recipes/decorations/lime_candle" | "minecraft:recipes/building_blocks/emerald_block" | "minecraft:recipes/food/cooked_rabbit_from_smoking" | "minecraft:recipes/building_blocks/cut_red_sandstone_slab_from_red_sandstone_stonecutting" | "minecraft:recipes/building_blocks/purpur_pillar_from_purpur_block_stonecutting" | "minecraft:recipes/building_blocks/prismarine_stairs" | "minecraft:recipes/brewing/golden_carrot" | "minecraft:recipes/building_blocks/nether_wart_block" | "minecraft:recipes/building_blocks/cobblestone_slab" | "minecraft:recipes/building_blocks/polished_blackstone_from_blackstone_stonecutting" | "minecraft:recipes/redstone/trapped_chest" | "minecraft:recipes/building_blocks/dye_pink_wool" | "minecraft:recipes/building_blocks/deepslate_tiles_from_polished_deepslate_stonecutting" | "minecraft:recipes/building_blocks/pink_terracotta" | "minecraft:recipes/decorations/cobbled_deepslate_wall_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/building_blocks/stripped_crimson_hyphae" | "minecraft:recipes/decorations/polished_blackstone_wall_from_polished_blackstone_stonecutting" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_slab_from_honeycomb" | "minecraft:recipes/building_blocks/deepslate_tiles_from_deepslate_bricks_stonecutting" | "minecraft:recipes/building_blocks/mossy_cobblestone_stairs_from_mossy_cobblestone_stonecutting" | "minecraft:adventure/summon_iron_golem" | "minecraft:recipes/transportation/jungle_chest_boat" | "minecraft:recipes/building_blocks/dripstone_block" | "minecraft:recipes/building_blocks/mangrove_wood" | "irons_spellbooks:irons_spellbooks/root" | "minecraft:recipes/building_blocks/magenta_terracotta" | "minecraft:adventure/avoid_vibration" | "minecraft:recipes/building_blocks/dye_pink_bed" | "minecraft:recipes/misc/brick" | "minecraft:recipes/misc/gold_ingot_from_smelting_nether_gold_ore" | "minecraft:recipes/building_blocks/stripped_birch_wood" | "minecraft:recipes/tools/spyglass" | "minecraft:recipes/building_blocks/sponge" | "minecraft:recipes/building_blocks/smooth_red_sandstone_slab_from_smooth_red_sandstone_stonecutting" | "minecraft:recipes/building_blocks/prismarine_brick_stairs" | "minecraft:recipes/decorations/prismarine_wall" | "minecraft:recipes/redstone/lectern" | "minecraft:recipes/building_blocks/yellow_stained_glass" | "minecraft:recipes/misc/spire_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/building_blocks/stone_stairs_from_stone_stonecutting" | "minecraft:recipes/decorations/acacia_fence" | "minecraft:recipes/misc/red_dye_from_rose_bush" | "minecraft:recipes/redstone/warped_fence_gate" | "minecraft:recipes/building_blocks/gold_block" | "minecraft:recipes/misc/magenta_dye_from_purple_and_pink" | "minecraft:recipes/transportation/acacia_chest_boat" | "minecraft:recipes/decorations/mossy_stone_brick_wall" | "minecraft:recipes/misc/iron_ingot_from_blasting_deepslate_iron_ore" | "minecraft:recipes/building_blocks/dye_brown_carpet" | "minecraft:recipes/building_blocks/exposed_cut_copper_stairs_from_exposed_cut_copper_stonecutting" | "minecraft:recipes/misc/yellow_dye_from_sunflower" | "minecraft:recipes/redstone/mangrove_button" | "minecraft:nether/return_to_sender" | "minecraft:recipes/decorations/white_candle" | "minecraft:recipes/brewing/cauldron" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_slab" | "minecraft:recipes/decorations/armor_stand" | "minecraft:adventure/sleep_in_bed" | "minecraft:recipes/building_blocks/sandstone" | "irons_spellbooks:irons_spellbooks/spell_book_rotten" | "minecraft:recipes/food/cooked_rabbit_from_campfire_cooking" | "minecraft:recipes/building_blocks/cobblestone_slab_from_cobblestone_stonecutting" | "minecraft:recipes/combat/turtle_helmet" | "minecraft:recipes/building_blocks/mud_brick_stairs_from_mud_bricks_stonecutting" | "minecraft:recipes/building_blocks/oak_stairs" | "minecraft:recipes/building_blocks/polished_andesite_slab_from_andesite_stonecutting" | "minecraft:recipes/transportation/acacia_boat" | "minecraft:recipes/redstone/iron_trapdoor" | "minecraft:recipes/building_blocks/prismarine_slab_from_prismarine_stonecutting" | "minecraft:recipes/decorations/birch_sign" | "minecraft:recipes/transportation/cherry_boat" | "minecraft:end/dragon_breath" | "minecraft:adventure/root" | "minecraft:recipes/building_blocks/polished_basalt_from_basalt_stonecutting" | "minecraft:recipes/building_blocks/end_stone_brick_stairs" | "minecraft:recipes/building_blocks/white_concrete_powder" | "minecraft:recipes/decorations/jungle_fence" | "minecraft:recipes/misc/tide_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/building_blocks/white_wool_from_string" | "minecraft:recipes/tools/diamond_pickaxe" | "minecraft:recipes/decorations/mud_brick_wall_from_mud_bricks_stonecutting" | "minecraft:recipes/redstone/lightning_rod" | "minecraft:adventure/kill_all_mobs" | "minecraft:recipes/decorations/brown_glazed_terracotta" | "minecraft:recipes/misc/music_disc_5" | "minecraft:recipes/building_blocks/chiseled_quartz_block_from_quartz_block_stonecutting" | "minecraft:recipes/misc/ender_eye" | "minecraft:recipes/misc/netherite_scrap" | "minecraft:recipes/building_blocks/birch_wood" | "minecraft:story/enchant_item" | "minecraft:recipes/decorations/yellow_banner" | "minecraft:recipes/redstone/redstone_block" | "minecraft:recipes/decorations/brown_stained_glass_pane_from_glass_pane" | "minecraft:husbandry/obtain_sniffer_egg" | "minecraft:recipes/building_blocks/lime_stained_glass" | "minecraft:recipes/decorations/crimson_sign" | "minecraft:recipes/decorations/dark_oak_hanging_sign" | "minecraft:recipes/building_blocks/deepslate_brick_slab" | "minecraft:adventure/voluntary_exile" | "minecraft:recipes/building_blocks/polished_diorite_stairs_from_polished_diorite_stonecutting" | "minecraft:recipes/building_blocks/quartz_pillar_from_quartz_block_stonecutting" | "minecraft:recipes/decorations/brick_wall_from_bricks_stonecutting" | "minecraft:recipes/decorations/granite_wall_from_granite_stonecutting" | "minecraft:recipes/redstone/cherry_trapdoor" | "minecraft:recipes/building_blocks/polished_blackstone_brick_stairs_from_blackstone_stonecutting" | "minecraft:recipes/building_blocks/exposed_cut_copper_slab_from_exposed_copper_stonecutting" | "minecraft:recipes/decorations/chain" | "minecraft:recipes/building_blocks/cyan_terracotta" | "minecraft:recipes/decorations/yellow_bed" | "minecraft:recipes/redstone/polished_blackstone_pressure_plate" | "minecraft:recipes/decorations/nether_brick_wall_from_nether_bricks_stonecutting" | "minecraft:recipes/decorations/oak_fence" | "minecraft:recipes/decorations/red_stained_glass_pane_from_glass_pane" | "minecraft:recipes/building_blocks/polished_blackstone_bricks_from_blackstone_stonecutting" | "minecraft:recipes/food/cooked_cod_from_campfire_cooking" | "minecraft:story/follow_ender_eye" | "minecraft:recipes/building_blocks/weathered_cut_copper_from_weathered_copper_stonecutting" | "minecraft:recipes/redstone/cherry_button" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_stairs" | "minecraft:recipes/decorations/magenta_stained_glass_pane_from_glass_pane" | "minecraft:recipes/misc/coal_from_blasting_coal_ore" | "minecraft:recipes/redstone/mangrove_door" | "minecraft:recipes/building_blocks/cherry_planks" | "minecraft:recipes/redstone/redstone_from_smelting_deepslate_redstone_ore" | "minecraft:recipes/food/cooked_porkchop_from_campfire_cooking" | "minecraft:recipes/misc/pink_dye_from_red_white_dye" | "minecraft:recipes/building_blocks/dye_cyan_bed" | "minecraft:recipes/brewing/blaze_powder" | "minecraft:recipes/building_blocks/chiseled_bookshelf" | "minecraft:recipes/redstone/jungle_pressure_plate" | "minecraft:end/root" | "irons_spellbooks:make_inscription_table" | "minecraft:recipes/combat/golden_chestplate" | "minecraft:recipes/decorations/deepslate_tile_wall_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/misc/iron_ingot_from_blasting_raw_iron" | "minecraft:recipes/building_blocks/stripped_dark_oak_wood" | "minecraft:recipes/building_blocks/dye_yellow_wool" | "minecraft:recipes/misc/blue_dye_from_cornflower" | "minecraft:recipes/redstone/slime_block" | "minecraft:recipes/decorations/light_blue_stained_glass_pane" | "minecraft:recipes/misc/diamond_from_blasting_diamond_ore" | "minecraft:recipes/building_blocks/polished_blackstone_brick_slab_from_polished_blackstone_stonecutting" | "minecraft:recipes/decorations/moss_carpet" | "minecraft:recipes/building_blocks/polished_diorite_slab_from_polished_diorite_stonecutting" | "minecraft:adventure/spyglass_at_parrot" | "minecraft:recipes/decorations/cyan_stained_glass_pane_from_glass_pane" | "minecraft:recipes/building_blocks/nether_brick_stairs_from_nether_bricks_stonecutting" | "minecraft:recipes/decorations/bamboo_hanging_sign" | "minecraft:recipes/building_blocks/iron_block" | "minecraft:recipes/decorations/blackstone_wall_from_blackstone_stonecutting" | "minecraft:recipes/building_blocks/oxidized_cut_copper_stairs" | "minecraft:recipes/redstone/crimson_fence_gate" | "minecraft:recipes/misc/red_dye_from_poppy" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper" | "minecraft:recipes/building_blocks/acacia_wood" | "minecraft:recipes/building_blocks/smooth_red_sandstone_stairs" | "minecraft:recipes/building_blocks/spruce_wood" | "minecraft:recipes/decorations/polished_blackstone_brick_wall" | "minecraft:recipes/building_blocks/clay" | "minecraft:recipes/misc/yellow_dye_from_dandelion" | "minecraft:recipes/building_blocks/amethyst_block" | "minecraft:recipes/combat/wooden_sword" | "minecraft:recipes/decorations/gray_banner" | "minecraft:recipes/building_blocks/oak_planks" | "minecraft:recipes/decorations/end_stone_brick_wall" | "minecraft:recipes/building_blocks/gray_concrete_powder" | "minecraft:recipes/decorations/light_blue_carpet" | "minecraft:recipes/decorations/light_gray_banner" | "minecraft:husbandry/obtain_netherite_hoe" | "minecraft:recipes/building_blocks/dye_blue_bed" | "minecraft:recipes/tools/iron_axe" | "minecraft:recipes/decorations/birch_hanging_sign" | "minecraft:recipes/transportation/mangrove_chest_boat" | "minecraft:recipes/building_blocks/glowstone" | "minecraft:recipes/decorations/mangrove_hanging_sign" | "minecraft:recipes/building_blocks/deepslate_bricks_from_polished_deepslate_stonecutting" | "minecraft:recipes/building_blocks/sea_lantern" | "minecraft:recipes/decorations/deepslate_tile_wall_from_deepslate_bricks_stonecutting" | "minecraft:recipes/decorations/black_banner" | "minecraft:recipes/building_blocks/quartz_slab_from_stonecutting" | "minecraft:recipes/decorations/gray_carpet" | "minecraft:recipes/decorations/deepslate_tile_wall" | "minecraft:recipes/redstone/tripwire_hook" | "minecraft:recipes/misc/black_dye_from_wither_rose" | "minecraft:recipes/misc/bone_meal" | "minecraft:recipes/building_blocks/black_concrete_powder" | "minecraft:recipes/decorations/cartography_table" | "minecraft:recipes/building_blocks/prismarine_brick_slab_from_prismarine_stonecutting" | "minecraft:recipes/building_blocks/sandstone_stairs_from_sandstone_stonecutting" | "minecraft:recipes/redstone/birch_fence_gate" | "minecraft:recipes/redstone/stone_button" | "minecraft:adventure/totem_of_undying" | "minecraft:recipes/combat/crossbow" | "minecraft:recipes/building_blocks/mud_bricks" | "minecraft:recipes/decorations/cobbled_deepslate_wall" | "minecraft:recipes/building_blocks/packed_mud" | "minecraft:recipes/building_blocks/deepslate_tile_slab" | "minecraft:recipes/food/cooked_porkchop_from_smoking" | "minecraft:recipes/building_blocks/polished_diorite_from_diorite_stonecutting" | "minecraft:recipes/building_blocks/prismarine_bricks" | "minecraft:recipes/building_blocks/cracked_deepslate_bricks" | "minecraft:recipes/building_blocks/chiseled_deepslate" | "minecraft:recipes/building_blocks/chiseled_nether_bricks" | "minecraft:recipes/building_blocks/warped_planks" | "minecraft:recipes/building_blocks/nether_brick_slab_from_nether_bricks_stonecutting" | "minecraft:recipes/building_blocks/exposed_cut_copper_slab" | "minecraft:recipes/misc/iron_nugget_from_blasting" | "minecraft:recipes/decorations/polished_deepslate_wall_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/decorations/warped_fence" | "minecraft:recipes/building_blocks/smooth_sandstone_slab" | "minecraft:adventure/kill_a_mob" | "minecraft:recipes/decorations/black_glazed_terracotta" | "minecraft:recipes/building_blocks/blue_terracotta" | "minecraft:recipes/decorations/diorite_wall" | "minecraft:husbandry/plant_any_sniffer_seed" | "minecraft:recipes/building_blocks/weathered_cut_copper_stairs" | "minecraft:recipes/building_blocks/stone" | "minecraft:recipes/decorations/green_carpet" | "minecraft:recipes/building_blocks/deepslate_bricks_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/building_blocks/light_blue_terracotta" | "minecraft:recipes/decorations/stonecutter" | "minecraft:recipes/misc/gray_dye" | "minecraft:adventure/adventuring_time" | "minecraft:recipes/building_blocks/dye_cyan_carpet" | "minecraft:recipes/transportation/bamboo_raft" | "minecraft:recipes/building_blocks/cut_red_sandstone" | "minecraft:recipes/redstone/bamboo_button" | "minecraft:recipes/decorations/light_gray_carpet" | "minecraft:recipes/decorations/barrel" | "minecraft:recipes/building_blocks/mossy_stone_brick_slab" | "minecraft:recipes/decorations/light_blue_banner" | "minecraft:recipes/decorations/purple_carpet" | "minecraft:recipes/misc/rib_armor_trim_smithing_template" | "minecraft:recipes/decorations/smithing_table" | "minecraft:recipes/building_blocks/cut_copper" | "minecraft:husbandry/plant_seed" | "minecraft:recipes/redstone/stone_pressure_plate" | "minecraft:nether/find_bastion" | "minecraft:recipes/building_blocks/polished_blackstone_slab" | "minecraft:recipes/combat/leather_boots" | "minecraft:recipes/misc/red_dye_from_tulip" | "minecraft:husbandry/axolotl_in_a_bucket" | "minecraft:recipes/decorations/cobblestone_wall_from_cobblestone_stonecutting" | "minecraft:recipes/misc/netherite_ingot" | "minecraft:recipes/building_blocks/cut_sandstone_slab" | "minecraft:recipes/building_blocks/polished_andesite_slab_from_polished_andesite_stonecutting" | "minecraft:recipes/misc/sugar_from_honey_bottle" | "minecraft:recipes/misc/orange_dye_from_orange_tulip" | "minecraft:recipes/building_blocks/dye_red_carpet" | "minecraft:recipes/decorations/grindstone" | "minecraft:recipes/building_blocks/diamond_block" | "minecraft:husbandry/allay_deliver_cake_to_note_block" | "minecraft:recipes/building_blocks/dye_lime_bed" | "minecraft:recipes/decorations/flower_pot" | "minecraft:recipes/misc/raw_iron" | "minecraft:adventure/spyglass_at_dragon" | "minecraft:recipes/building_blocks/weathered_cut_copper_slab_from_weathered_copper_stonecutting" | "minecraft:recipes/decorations/yellow_carpet" | "minecraft:recipes/building_blocks/stripped_oak_wood" | "minecraft:recipes/decorations/orange_stained_glass_pane_from_glass_pane" | "minecraft:recipes/transportation/tnt_minecart" | "minecraft:recipes/building_blocks/deepslate_tile_slab_from_deepslate_bricks_stonecutting" | "minecraft:recipes/misc/stick_from_bamboo_item" | "minecraft:nether/ride_strider_in_overworld_lava" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper" | "irons_spellbooks:irons_spellbooks/spell_book_dead_king" | "minecraft:adventure/trade_at_world_height" | "minecraft:recipes/redstone/bamboo_fence_gate" | "minecraft:recipes/decorations/sandstone_wall" | "minecraft:recipes/decorations/red_sandstone_wall_from_red_sandstone_stonecutting" | "minecraft:recipes/food/cookie" | "minecraft:recipes/decorations/andesite_wall" | "minecraft:recipes/decorations/light_blue_stained_glass_pane_from_glass_pane" | "minecraft:recipes/building_blocks/andesite_slab" | "minecraft:recipes/building_blocks/acacia_stairs" | "minecraft:recipes/misc/light_gray_dye_from_oxeye_daisy" | "minecraft:recipes/building_blocks/oxidized_cut_copper_stairs_from_oxidized_cut_copper_stonecutting" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_stairs_from_waxed_exposed_copper_stonecutting" | "minecraft:recipes/decorations/blue_banner" | "minecraft:recipes/misc/fire_charge" | "minecraft:recipes/building_blocks/dye_green_bed" | "minecraft:recipes/decorations/soul_torch" | "minecraft:recipes/misc/light_gray_dye_from_black_white_dye" | "minecraft:recipes/building_blocks/waxed_cut_copper_stairs_from_waxed_copper_block_stonecutting" | "minecraft:recipes/building_blocks/yellow_terracotta" | "minecraft:recipes/decorations/brown_candle" | "irons_spellbooks:irons_spellbooks/spell_book_evoker" | "minecraft:recipes/building_blocks/quartz_pillar" | "minecraft:husbandry/wax_on" | "minecraft:recipes/building_blocks/deepslate_tile_slab_from_polished_deepslate_stonecutting" | "minecraft:recipes/building_blocks/purple_terracotta" | "minecraft:recipes/building_blocks/cobblestone_stairs_from_cobblestone_stonecutting" | "minecraft:adventure/play_jukebox_in_meadows" | "minecraft:recipes/misc/writable_book" | "minecraft:recipes/misc/wheat" | "minecraft:recipes/building_blocks/dark_prismarine_slab_from_dark_prismarine_stonecutting" | "minecraft:recipes/building_blocks/polished_andesite_stairs_from_andesite_stonecutting" | "minecraft:recipes/decorations/lime_banner" | "minecraft:recipes/decorations/white_bed" | "minecraft:recipes/misc/green_dye" | "minecraft:recipes/decorations/magenta_bed" | "minecraft:recipes/redstone/honey_block" | "minecraft:recipes/building_blocks/dark_prismarine" | "minecraft:recipes/food/rabbit_stew_from_red_mushroom" | "minecraft:recipes/redstone/birch_pressure_plate" | "minecraft:adventure/hero_of_the_village" | "minecraft:recipes/decorations/candle" | "minecraft:recipes/redstone/redstone" | "minecraft:recipes/building_blocks/purpur_stairs_from_purpur_block_stonecutting" | "minecraft:recipes/tools/golden_hoe" | "minecraft:recipes/building_blocks/cut_red_sandstone_from_red_sandstone_stonecutting" | "minecraft:recipes/food/bread" | "minecraft:recipes/building_blocks/diorite_slab_from_diorite_stonecutting" | "minecraft:recipes/decorations/deepslate_brick_wall_from_polished_deepslate_stonecutting" | "minecraft:recipes/building_blocks/smooth_stone" | "minecraft:recipes/misc/lapis_lazuli_from_blasting_deepslate_lapis_ore" | "minecraft:nether/obtain_ancient_debris" | "minecraft:recipes/decorations/nether_brick_wall" | "minecraft:recipes/misc/ward_armor_trim_smithing_template" | "minecraft:recipes/misc/coast_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/decorations/pink_carpet" | "minecraft:recipes/building_blocks/dye_pink_carpet" | "minecraft:recipes/misc/bone_meal_from_bone_block" | "minecraft:recipes/misc/copper_ingot_from_smelting_deepslate_copper_ore" | "minecraft:recipes/decorations/magenta_candle" | "minecraft:recipes/building_blocks/exposed_cut_copper_stairs_from_exposed_copper_stonecutting" | "minecraft:nether/create_full_beacon" | "minecraft:recipes/building_blocks/packed_ice" | "minecraft:recipes/transportation/spruce_boat" | "minecraft:recipes/building_blocks/diorite" | "minecraft:recipes/building_blocks/dye_white_bed" | "minecraft:recipes/building_blocks/cut_copper_slab_from_copper_block_stonecutting" | "minecraft:recipes/misc/firework_rocket_simple" | "minecraft:recipes/misc/gold_ingot_from_smelting_deepslate_gold_ore" | "minecraft:nether/summon_wither" | "minecraft:recipes/building_blocks/quartz_stairs_from_quartz_block_stonecutting" | "minecraft:recipes/food/mushroom_stew" | "minecraft:recipes/decorations/spruce_hanging_sign" | "minecraft:recipes/building_blocks/polished_granite_from_granite_stonecutting" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_slab" | "minecraft:recipes/building_blocks/deepslate_tiles" | "minecraft:husbandry/balanced_diet" | "minecraft:recipes/building_blocks/gray_terracotta" | "minecraft:recipes/redstone/redstone_from_blasting_deepslate_redstone_ore" | "irons_spellbooks:irons_spellbooks/spell_book_gold" | "minecraft:recipes/food/cooked_cod" | "minecraft:recipes/tools/netherite_pickaxe_smithing" | "minecraft:recipes/building_blocks/oxidized_cut_copper_slab_from_oxidized_copper_stonecutting" | "minecraft:recipes/building_blocks/warped_hyphae" | "minecraft:recipes/redstone/jungle_button" | "minecraft:nether/fast_travel" | "minecraft:recipes/building_blocks/red_nether_brick_slab" | "minecraft:recipes/building_blocks/cobblestone_stairs" | "minecraft:recipes/building_blocks/birch_slab" | "minecraft:recipes/building_blocks/bamboo_stairs" | "minecraft:recipes/misc/copper_ingot_from_blasting_copper_ore" | "minecraft:recipes/building_blocks/dye_green_carpet" | "minecraft:recipes/misc/raw_gold" | "minecraft:recipes/building_blocks/dye_yellow_bed" | "minecraft:recipes/building_blocks/mossy_stone_brick_stairs_from_mossy_stone_brick_stonecutting" | "minecraft:recipes/redstone/note_block" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_slab_from_honeycomb" | "minecraft:recipes/decorations/oak_hanging_sign" | "minecraft:recipes/building_blocks/bamboo_block" | "minecraft:recipes/building_blocks/dye_lime_carpet" | "minecraft:recipes/building_blocks/polished_blackstone_stairs_from_blackstone_stonecutting" | "minecraft:recipes/decorations/green_stained_glass_pane_from_glass_pane" | "minecraft:recipes/building_blocks/deepslate_tiles_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/building_blocks/polished_diorite_slab_from_diorite_stonecutting" | "minecraft:recipes/building_blocks/dye_gray_wool" | "minecraft:recipes/decorations/pink_banner" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_stairs" | "minecraft:recipes/redstone/redstone_from_smelting_redstone_ore" | "minecraft:recipes/decorations/crimson_hanging_sign" | "minecraft:recipes/building_blocks/prismarine_brick_slab" | "minecraft:recipes/building_blocks/hay_block" | "minecraft:recipes/misc/leather_horse_armor" | "minecraft:recipes/decorations/lime_bed" | "minecraft:recipes/building_blocks/waxed_exposed_copper_from_honeycomb" | "minecraft:recipes/decorations/mossy_cobblestone_wall_from_mossy_cobblestone_stonecutting" | "minecraft:recipes/misc/magenta_dye_from_blue_red_white_dye" | "minecraft:recipes/redstone/tnt" | "minecraft:recipes/decorations/black_stained_glass_pane" | "minecraft:recipes/building_blocks/granite" | "minecraft:recipes/building_blocks/cut_sandstone_slab_from_cut_sandstone_stonecutting" | "minecraft:recipes/building_blocks/purple_concrete_powder" | "minecraft:recipes/building_blocks/smooth_stone_slab" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_slab_from_waxed_oxidized_copper_stonecutting" | "minecraft:recipes/misc/emerald_from_smelting_deepslate_emerald_ore" | "minecraft:recipes/building_blocks/prismarine_slab" | "minecraft:recipes/decorations/orange_carpet" | "minecraft:recipes/transportation/oak_chest_boat" | "minecraft:recipes/building_blocks/dye_gray_bed" | "minecraft:adventure/read_power_of_chiseled_bookshelf" | "minecraft:recipes/redstone/target" | "minecraft:recipes/misc/beacon" | "minecraft:recipes/redstone/cherry_door" | "minecraft:recipes/building_blocks/red_nether_bricks" | "minecraft:recipes/redstone/crimson_door" | "minecraft:recipes/building_blocks/cut_copper_stairs" | "minecraft:recipes/decorations/cyan_carpet" | "minecraft:husbandry/root" | "minecraft:recipes/decorations/warped_hanging_sign" | "minecraft:recipes/transportation/birch_boat" | "minecraft:recipes/building_blocks/cut_copper_from_copper_block_stonecutting" | "minecraft:recipes/misc/copper_ingot_from_waxed_copper_block" | "minecraft:recipes/decorations/enchanting_table" | "minecraft:recipes/building_blocks/cobbled_deepslate_stairs_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/redstone/acacia_door" | "minecraft:recipes/building_blocks/weathered_cut_copper_stairs_from_weathered_cut_copper_stonecutting" | "minecraft:recipes/misc/tide_armor_trim_smithing_template" | "minecraft:recipes/building_blocks/oxidized_cut_copper_slab_from_oxidized_cut_copper_stonecutting" | "minecraft:recipes/redstone/crimson_trapdoor" | "minecraft:recipes/tools/stone_hoe" | "minecraft:recipes/building_blocks/cherry_wood" | "minecraft:recipes/decorations/green_glazed_terracotta" | "minecraft:recipes/decorations/spruce_fence" | "minecraft:recipes/decorations/bamboo_sign" | "minecraft:recipes/tools/diamond_hoe" | "minecraft:recipes/food/dried_kelp" | "minecraft:recipes/combat/spectral_arrow" | "minecraft:recipes/transportation/activator_rail" | "minecraft:recipes/decorations/white_stained_glass_pane" | "minecraft:recipes/building_blocks/dark_oak_stairs" | "minecraft:recipes/tools/diamond_shovel" | "minecraft:recipes/building_blocks/polished_granite_slab_from_polished_granite_stonecutting" | "irons_spellbooks:irons_spellbooks/spell_book_blaze" | "minecraft:nether/use_lodestone" | "minecraft:husbandry/safely_harvest_honey" | "minecraft:recipes/building_blocks/blue_ice" | "minecraft:adventure/trade" | "minecraft:recipes/building_blocks/deepslate" | "minecraft:recipes/building_blocks/granite_slab" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_from_honeycomb" | "minecraft:recipes/decorations/jungle_hanging_sign" | "minecraft:recipes/decorations/ender_chest" | "minecraft:recipes/decorations/white_carpet" | "minecraft:recipes/decorations/dark_oak_sign" | "minecraft:recipes/transportation/cherry_chest_boat" | "minecraft:recipes/building_blocks/spruce_stairs" | "minecraft:recipes/building_blocks/mangrove_slab" | "minecraft:recipes/building_blocks/red_sandstone_slab" | "minecraft:adventure/spyglass_at_ghast" | "minecraft:recipes/building_blocks/dark_prismarine_slab" | "minecraft:adventure/trim_with_any_armor_pattern" | "minecraft:nether/uneasy_alliance" | "minecraft:recipes/decorations/pink_stained_glass_pane_from_glass_pane" | "minecraft:recipes/building_blocks/jack_o_lantern" | "minecraft:recipes/transportation/birch_chest_boat" | "minecraft:recipes/decorations/glass_pane" | "minecraft:recipes/decorations/purple_banner" | "minecraft:recipes/building_blocks/magenta_stained_glass" | "minecraft:recipes/building_blocks/red_sandstone_stairs_from_red_sandstone_stonecutting" | "minecraft:story/mine_diamond" | "minecraft:recipes/building_blocks/cut_copper_stairs_from_cut_copper_stonecutting" | "minecraft:recipes/building_blocks/polished_granite_stairs_from_granite_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone_brick_stairs_from_polished_blackstone_bricks_stonecutting" | "minecraft:recipes/transportation/oak_boat" | "minecraft:recipes/decorations/anvil" | "minecraft:recipes/redstone/redstone_from_blasting_redstone_ore" | "minecraft:recipes/decorations/black_candle" | "minecraft:recipes/building_blocks/cyan_concrete_powder" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_from_honeycomb" | "minecraft:recipes/building_blocks/bamboo_mosaic_stairs" | "minecraft:recipes/building_blocks/smooth_stone_slab_from_smooth_stone_stonecutting" | "minecraft:recipes/decorations/deepslate_tile_wall_from_polished_deepslate_stonecutting" | "minecraft:recipes/building_blocks/deepslate_brick_stairs_from_deepslate_bricks_stonecutting" | "minecraft:recipes/decorations/mossy_stone_brick_wall_from_mossy_stone_brick_stonecutting" | "minecraft:recipes/misc/paper" | "minecraft:recipes/building_blocks/polished_diorite_stairs_from_diorite_stonecutting" | "minecraft:recipes/misc/pink_dye_from_peony" | "minecraft:recipes/decorations/loom" | "minecraft:recipes/building_blocks/deepslate_brick_stairs_from_polished_deepslate_stonecutting" | "minecraft:recipes/redstone/warped_button" | "minecraft:recipes/tools/diamond_axe" | "minecraft:husbandry/kill_axolotl_target" | "minecraft:recipes/building_blocks/end_stone_bricks_from_end_stone_stonecutting" | "minecraft:recipes/decorations/stone_brick_wall_from_stone_bricks_stonecutting" | "minecraft:recipes/building_blocks/end_stone_brick_stairs_from_end_stone_stonecutting" | "minecraft:recipes/building_blocks/red_nether_brick_stairs" | "minecraft:recipes/building_blocks/dye_black_carpet" | "minecraft:recipes/misc/coal_from_smelting_coal_ore" | "minecraft:nether/find_fortress" | "minecraft:recipes/misc/emerald_from_blasting_deepslate_emerald_ore" | "minecraft:recipes/building_blocks/waxed_copper_block_from_honeycomb" | "minecraft:recipes/decorations/scaffolding" | "minecraft:recipes/building_blocks/polished_blackstone_bricks" | "minecraft:recipes/building_blocks/weathered_cut_copper" | "minecraft:recipes/building_blocks/warped_stairs" | "minecraft:recipes/building_blocks/white_stained_glass" | "minecraft:recipes/redstone/warped_trapdoor" | "minecraft:recipes/decorations/blue_glazed_terracotta" | "minecraft:recipes/decorations/red_sandstone_wall" | "minecraft:recipes/building_blocks/mossy_cobblestone_from_moss_block" | "minecraft:recipes/misc/nether_brick" | "minecraft:recipes/building_blocks/andesite_slab_from_andesite_stonecutting" | "minecraft:recipes/redstone/acacia_fence_gate" | "minecraft:recipes/building_blocks/coal_block" | "minecraft:recipes/building_blocks/dye_brown_wool" | "minecraft:recipes/redstone/light_weighted_pressure_plate" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_stairs_from_honeycomb" | "minecraft:recipes/tools/stone_shovel" | "minecraft:adventure/throw_trident" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper" | "minecraft:recipes/building_blocks/mossy_cobblestone_slab" | "minecraft:recipes/building_blocks/diorite_stairs" | "minecraft:recipes/misc/conduit" | "minecraft:recipes/building_blocks/spruce_slab" | "minecraft:recipes/building_blocks/green_terracotta" | "minecraft:recipes/decorations/polished_blackstone_wall_from_blackstone_stonecutting" | "irons_spellbooks:grant_patchouli" | "minecraft:recipes/building_blocks/prismarine_stairs_from_prismarine_stonecutting" | "minecraft:recipes/misc/raw_copper" | "minecraft:recipes/building_blocks/brown_terracotta" | "minecraft:recipes/building_blocks/polished_andesite_stairs_from_polished_andesite_stonecutting" | "minecraft:recipes/decorations/green_candle" | "minecraft:recipes/tools/lead" | "minecraft:recipes/decorations/warped_sign" | "minecraft:recipes/decorations/white_stained_glass_pane_from_glass_pane" | "minecraft:recipes/building_blocks/polished_deepslate_stairs_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/building_blocks/waxed_cut_copper_slab_from_waxed_copper_block_stonecutting" | "minecraft:recipes/building_blocks/mossy_stone_bricks_from_moss_block" | "minecraft:recipes/building_blocks/polished_deepslate_stairs" | "minecraft:recipes/decorations/shulker_box" | "minecraft:recipes/misc/skull_banner_pattern" | "minecraft:recipes/building_blocks/polished_basalt" | "minecraft:recipes/building_blocks/oak_wood" | "irons_spellbooks:irons_spellbooks/ink_legendary" | "minecraft:story/root" | "minecraft:recipes/building_blocks/smooth_quartz_stairs" | "minecraft:recipes/misc/slime_ball" | "minecraft:recipes/misc/raiser_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/building_blocks/dye_black_wool" | "minecraft:recipes/redstone/bamboo_door" | "minecraft:recipes/decorations/lodestone" | "minecraft:recipes/misc/shaper_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/brewing/brewing_stand" | "minecraft:recipes/root" | "minecraft:recipes/building_blocks/dye_green_wool" | "minecraft:recipes/decorations/bamboo_fence" | "minecraft:recipes/decorations/cherry_hanging_sign" | "minecraft:recipes/building_blocks/jungle_slab" | "minecraft:recipes/misc/quartz_from_blasting" | "minecraft:recipes/building_blocks/polished_granite_slab" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_from_waxed_weathered_copper_stonecutting" | "minecraft:recipes/building_blocks/acacia_planks" | "minecraft:recipes/decorations/light_blue_candle" | "minecraft:recipes/redstone/repeater" | "minecraft:recipes/tools/compass" | "minecraft:recipes/redstone/oak_button" | "minecraft:adventure/honey_block_slide" | "minecraft:adventure/ol_betsy" | "minecraft:recipes/building_blocks/quartz_block" | "minecraft:recipes/redstone/dark_oak_pressure_plate" | "minecraft:recipes/decorations/gray_candle" | "minecraft:recipes/building_blocks/mossy_stone_brick_slab_from_mossy_stone_brick_stonecutting" | "minecraft:recipes/building_blocks/mossy_cobblestone_from_vine" | "minecraft:recipes/food/cooked_beef" | "minecraft:recipes/building_blocks/smooth_quartz_stairs_from_smooth_quartz_stonecutting" | "minecraft:recipes/misc/vex_armor_trim_smithing_template" | "minecraft:recipes/redstone/iron_door" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_from_honeycomb" | "minecraft:recipes/misc/iron_ingot_from_smelting_deepslate_iron_ore" | "minecraft:recipes/misc/copper_ingot_from_smelting_raw_copper" | "minecraft:recipes/decorations/nether_brick_fence" | "minecraft:recipes/building_blocks/chiseled_polished_blackstone_from_blackstone_stonecutting" | "minecraft:recipes/building_blocks/snow_block" | "minecraft:recipes/misc/magenta_dye_from_allium" | "minecraft:recipes/transportation/powered_rail" | "minecraft:recipes/decorations/red_bed" | "minecraft:recipes/misc/wayfinder_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/decorations/cyan_bed" | "minecraft:recipes/misc/iron_ingot_from_nuggets" | "minecraft:recipes/building_blocks/blackstone_stairs_from_blackstone_stonecutting" | "minecraft:recipes/decorations/decorated_pot_simple" | "minecraft:recipes/building_blocks/cracked_deepslate_tiles" | "irons_spellbooks:irons_spellbooks/make_inscription_table" | "minecraft:recipes/transportation/jungle_boat" | "minecraft:recipes/building_blocks/exposed_cut_copper" | "minecraft:nether/netherite_armor" | "minecraft:recipes/building_blocks/birch_stairs" | "minecraft:recipes/building_blocks/weathered_cut_copper_slab" | "minecraft:recipes/decorations/stone_brick_walls_from_stone_stonecutting" | "minecraft:recipes/building_blocks/jungle_stairs" | "minecraft:recipes/decorations/polished_blackstone_wall" | "minecraft:recipes/redstone/heavy_weighted_pressure_plate" | "minecraft:recipes/building_blocks/purpur_pillar" | "minecraft:recipes/food/pumpkin_pie" | "minecraft:recipes/redstone/daylight_detector" | "minecraft:recipes/transportation/dark_oak_boat" | "minecraft:recipes/decorations/honeycomb_block" | "minecraft:recipes/decorations/end_rod" | "minecraft:recipes/misc/diamond_from_blasting_deepslate_diamond_ore" | "minecraft:recipes/misc/host_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/building_blocks/waxed_cut_copper_stairs" | "minecraft:recipes/building_blocks/cut_red_sandstone_slab_from_cut_red_sandstone_stonecutting" | "minecraft:story/enter_the_end" | "minecraft:husbandry/breed_an_animal" | "minecraft:recipes/building_blocks/dye_purple_bed" | "minecraft:recipes/redstone/jungle_fence_gate" | "minecraft:recipes/transportation/warped_fungus_on_a_stick" | "minecraft:recipes/misc/mojang_banner_pattern" | "minecraft:recipes/combat/golden_leggings" | "minecraft:recipes/redstone/piston" | "minecraft:recipes/combat/netherite_helmet_smithing" | "minecraft:recipes/misc/lapis_lazuli_from_smelting_lapis_ore" | "minecraft:recipes/building_blocks/stripped_jungle_wood" | "minecraft:recipes/building_blocks/dye_light_gray_carpet" | "minecraft:recipes/building_blocks/stone_stairs" | "minecraft:recipes/redstone/warped_door" | "minecraft:husbandry/complete_catalogue" | "minecraft:recipes/decorations/gray_stained_glass_pane_from_glass_pane" | "minecraft:recipes/building_blocks/purpur_slab_from_purpur_block_stonecutting" | "minecraft:recipes/building_blocks/stripped_spruce_wood" | "minecraft:recipes/transportation/rail" | "minecraft:recipes/building_blocks/deepslate_brick_slab_from_deepslate_bricks_stonecutting" | "minecraft:recipes/decorations/brown_stained_glass_pane" | "minecraft:recipes/food/cooked_beef_from_campfire_cooking" | "minecraft:recipes/decorations/dark_oak_fence" | "minecraft:recipes/combat/diamond_boots" | "irons_spellbooks:irons_spellbooks/staff_blood_staff" | "minecraft:recipes/decorations/polished_blackstone_brick_wall_from_polished_blackstone_stonecutting" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_stairs_from_honeycomb" | "minecraft:recipes/building_blocks/mossy_cobblestone_stairs" | "minecraft:recipes/decorations/light_gray_stained_glass_pane" | "minecraft:recipes/building_blocks/bone_block";
    type RecipeId = "irons_spellbooks:cryomancer_helmet" | "minecraft:yellow_dye_from_dandelion" | "minecraft:charcoal" | "minecraft:dark_oak_button" | "minecraft:emerald_from_smelting_deepslate_emerald_ore" | "minecraft:diorite_wall_from_diorite_stonecutting" | "minecraft:polished_blackstone_brick_slab" | "irons_spellbooks:poisonous_potato" | "minecraft:chiseled_deepslate" | "minecraft:gray_candle" | "minecraft:rabbit_stew_from_brown_mushroom" | "minecraft:sentry_armor_trim_smithing_template_smithing_trim" | "minecraft:stripped_dark_oak_wood" | "minecraft:stonecutter" | "minecraft:soul_torch" | "irons_spellbooks:archevoker_boots" | "minecraft:bone_block" | "minecraft:raw_iron" | "minecraft:eye_armor_trim_smithing_template" | "minecraft:iron_nugget" | "minecraft:melon" | "minecraft:birch_fence" | "minecraft:cracked_deepslate_tiles" | "minecraft:deepslate_brick_stairs_from_cobbled_deepslate_stonecutting" | "irons_spellbooks:fire_upgrade_orb" | "minecraft:red_nether_brick_slab" | "minecraft:waxed_oxidized_cut_copper_from_honeycomb" | "minecraft:cooked_rabbit" | "minecraft:gold_nugget_from_blasting" | "minecraft:warped_fence_gate" | "minecraft:cooked_salmon_from_campfire_cooking" | "minecraft:nether_wart_block" | "minecraft:bamboo_fence_gate" | "minecraft:polished_blackstone_brick_slab_from_blackstone_stonecutting" | "minecraft:magenta_banner" | "minecraft:weathered_cut_copper_from_weathered_copper_stonecutting" | "minecraft:polished_blackstone_brick_wall_from_polished_blackstone_stonecutting" | "minecraft:cobblestone_wall" | "minecraft:gray_dye" | "minecraft:lime_stained_glass_pane" | "irons_spellbooks:pumpkin_chestplate" | "minecraft:mangrove_fence_gate" | "minecraft:warped_pressure_plate" | "minecraft:cut_sandstone_slab_from_cut_sandstone_stonecutting" | "minecraft:waxed_cut_copper_slab" | "irons_spellbooks:curios/frostward_ring" | "minecraft:coal_block" | "minecraft:raw_copper" | "minecraft:sugar_from_honey_bottle" | "minecraft:mangrove_button" | "minecraft:slime_ball" | "minecraft:spruce_fence_gate" | "minecraft:leather_chestplate" | "irons_spellbooks:protection_rune" | "minecraft:yellow_bed" | "minecraft:iron_block" | "minecraft:beehive" | "minecraft:map_extending" | "minecraft:nether_brick_slab_from_nether_bricks_stonecutting" | "minecraft:spruce_sign" | "minecraft:white_stained_glass_pane_from_glass_pane" | "minecraft:dark_oak_door" | "minecraft:cooked_porkchop" | "minecraft:waxed_cut_copper_slab_from_waxed_cut_copper_stonecutting" | "minecraft:cut_copper_slab_from_copper_block_stonecutting" | "minecraft:cooked_salmon_from_smoking" | "minecraft:dye_light_gray_wool" | "irons_spellbooks:shadowwalker_leggings" | "minecraft:writable_book" | "minecraft:birch_wood" | "minecraft:cyan_dye_from_pitcher_plant" | "minecraft:glow_item_frame" | "minecraft:leather_helmet" | "minecraft:light_blue_bed" | "minecraft:bamboo_mosaic" | "minecraft:oak_wood" | "minecraft:scaffolding" | "minecraft:emerald_block" | "minecraft:golden_apple" | "minecraft:chiseled_nether_bricks" | "minecraft:diamond_pickaxe" | "minecraft:flower_pot" | "minecraft:acacia_button" | "minecraft:light_gray_dye_from_oxeye_daisy" | "minecraft:polished_granite_from_granite_stonecutting" | "minecraft:magenta_stained_glass_pane" | "minecraft:copper_block" | "minecraft:nether_brick_stairs" | "minecraft:purple_candle" | "irons_spellbooks:scroll_forge" | "minecraft:chiseled_stone_bricks_from_stone_bricks_stonecutting" | "minecraft:lapis_lazuli_from_smelting_deepslate_lapis_ore" | "minecraft:polished_blackstone_bricks_from_blackstone_stonecutting" | "minecraft:recovery_compass" | "minecraft:magenta_bed" | "minecraft:oxidized_cut_copper_stairs_from_oxidized_copper_stonecutting" | "minecraft:end_stone_brick_slab_from_end_stone_brick_stonecutting" | "minecraft:iron_sword" | "minecraft:spruce_wood" | "minecraft:green_stained_glass" | "minecraft:magenta_dye_from_blue_red_white_dye" | "minecraft:spruce_fence" | "minecraft:cherry_fence" | "minecraft:mossy_stone_brick_slab" | "minecraft:andesite_slab" | "minecraft:bamboo_chest_raft" | "minecraft:dark_prismarine_slab" | "minecraft:polished_blackstone_wall_from_polished_blackstone_stonecutting" | "minecraft:sandstone_slab_from_sandstone_stonecutting" | "minecraft:honey_block" | "irons_spellbooks:pumpkin_boots" | "minecraft:bamboo_planks" | "minecraft:green_dye" | "minecraft:pink_glazed_terracotta" | "minecraft:pink_terracotta" | "minecraft:dried_kelp_from_smoking" | "irons_spellbooks:artificer_cane" | "minecraft:chiseled_sandstone_from_sandstone_stonecutting" | "minecraft:spire_armor_trim_smithing_template_smithing_trim" | "minecraft:waxed_exposed_cut_copper_stairs" | "minecraft:orange_stained_glass" | "minecraft:exposed_cut_copper_slab" | "irons_spellbooks:electromancer_helmet" | "minecraft:polished_blackstone_wall" | "minecraft:cobblestone_stairs" | "minecraft:copper_ingot_from_blasting_deepslate_copper_ore" | "irons_spellbooks:pyromancer_helmet" | "minecraft:redstone_from_smelting_redstone_ore" | "minecraft:cut_sandstone_slab" | "minecraft:smooth_red_sandstone_slab" | "minecraft:stone_brick_stairs_from_stone_bricks_stonecutting" | "minecraft:cut_copper_stairs_from_cut_copper_stonecutting" | "minecraft:suspicious_stew" | "irons_spellbooks:blood_upgrade_orb" | "minecraft:bamboo_pressure_plate" | "minecraft:cherry_door" | "minecraft:birch_trapdoor" | "minecraft:weathered_cut_copper_slab" | "minecraft:prismarine_brick_stairs_from_prismarine_stonecutting" | "minecraft:deepslate_brick_wall_from_deepslate_bricks_stonecutting" | "minecraft:waxed_weathered_copper_from_honeycomb" | "minecraft:golden_boots" | "minecraft:pink_dye_from_red_white_dye" | "minecraft:netherite_shovel_smithing" | "minecraft:coal_from_blasting_coal_ore" | "minecraft:andesite_wall_from_andesite_stonecutting" | "minecraft:acacia_door" | "minecraft:mangrove_wood" | "minecraft:polished_basalt" | "minecraft:prismarine_stairs" | "minecraft:cyan_concrete_powder" | "minecraft:conduit" | "minecraft:dye_green_carpet" | "minecraft:mojang_banner_pattern" | "titanium:test_serializer/saplings_to_sticks" | "minecraft:polished_granite_slab" | "minecraft:dye_pink_wool" | "irons_spellbooks:pyromancer_boots" | "minecraft:fire_charge" | "minecraft:golden_hoe" | "minecraft:sticky_piston" | "minecraft:sentry_armor_trim_smithing_template" | "minecraft:white_dye" | "minecraft:redstone" | "minecraft:blue_glazed_terracotta" | "minecraft:emerald" | "irons_spellbooks:curios/cast_time_ring" | "minecraft:polished_andesite_slab" | "minecraft:dye_green_bed" | "minecraft:wooden_pickaxe" | "minecraft:cherry_planks" | "minecraft:powered_rail" | "minecraft:exposed_cut_copper_slab_from_exposed_copper_stonecutting" | "minecraft:wild_armor_trim_smithing_template_smithing_trim" | "minecraft:warped_hanging_sign" | "minecraft:firework_star" | "minecraft:green_concrete_powder" | "minecraft:nether_brick_wall_from_nether_bricks_stonecutting" | "minecraft:oxidized_cut_copper_slab_from_oxidized_cut_copper_stonecutting" | "minecraft:oak_stairs" | "minecraft:silence_armor_trim_smithing_template" | "minecraft:smooth_red_sandstone_slab_from_smooth_red_sandstone_stonecutting" | "minecraft:cracked_deepslate_bricks" | "minecraft:orange_dye_from_torchflower" | "minecraft:dye_white_bed" | "irons_spellbooks:ice_rune" | "minecraft:stone_button" | "minecraft:polished_blackstone_brick_stairs" | "minecraft:brown_stained_glass" | "minecraft:stick_from_bamboo_item" | "minecraft:tinted_glass" | "minecraft:blue_terracotta" | "minecraft:yellow_candle" | "minecraft:stripped_oak_wood" | "minecraft:sandstone" | "minecraft:yellow_concrete_powder" | "minecraft:gray_terracotta" | "minecraft:jungle_fence_gate" | "irons_spellbooks:protection_upgrade_orb" | "minecraft:diamond_from_blasting_diamond_ore" | "minecraft:comparator" | "minecraft:lodestone" | "minecraft:repeater" | "minecraft:red_concrete_powder" | "irons_spellbooks:pyromancer_leggings" | "minecraft:netherite_boots_smithing" | "irons_spellbooks:inscription_table" | "minecraft:purpur_block" | "minecraft:cut_copper_stairs_from_copper_block_stonecutting" | "minecraft:glass" | "minecraft:polished_blackstone_slab" | "minecraft:stone_stairs" | "minecraft:fishing_rod" | "minecraft:cooked_beef_from_smoking" | "minecraft:dried_kelp_block" | "minecraft:end_stone_brick_stairs" | "minecraft:iron_leggings" | "irons_spellbooks:nature_rune" | "minecraft:terracotta" | "minecraft:stripped_crimson_hyphae" | "minecraft:quartz" | "minecraft:cyan_carpet" | "minecraft:polished_deepslate_stairs_from_polished_deepslate_stonecutting" | "minecraft:nether_brick_wall" | "minecraft:book_cloning" | "minecraft:polished_basalt_from_basalt_stonecutting" | "minecraft:gray_concrete_powder" | "irons_spellbooks:iron_spell_book" | "minecraft:light_blue_concrete_powder" | "minecraft:smooth_sandstone_stairs_from_smooth_sandstone_stonecutting" | "minecraft:granite_wall_from_granite_stonecutting" | "minecraft:wayfinder_armor_trim_smithing_template" | "minecraft:dye_light_blue_bed" | "minecraft:redstone_from_blasting_redstone_ore" | "minecraft:granite_stairs" | "minecraft:cyan_terracotta" | "minecraft:polished_granite_slab_from_polished_granite_stonecutting" | "minecraft:cut_red_sandstone" | "irons_spellbooks:eldritch_manuscript" | "minecraft:mushroom_stew" | "irons_spellbooks:magic_cloth" | "minecraft:mangrove_fence" | "minecraft:polished_deepslate_from_cobbled_deepslate_stonecutting" | "minecraft:red_dye_from_tulip" | "minecraft:warped_planks" | "minecraft:lime_candle" | "minecraft:red_nether_brick_wall_from_red_nether_bricks_stonecutting" | "minecraft:red_dye_from_beetroot" | "minecraft:beacon" | "minecraft:tnt" | "irons_spellbooks:arcane_salvage" | "minecraft:mossy_stone_bricks_from_vine" | "minecraft:dye_white_carpet" | "minecraft:waxed_weathered_cut_copper_stairs_from_waxed_weathered_cut_copper_stonecutting" | "minecraft:andesite_slab_from_andesite_stonecutting" | "irons_spellbooks:curios/poisonward_ring" | "minecraft:dye_yellow_bed" | "minecraft:light_gray_bed" | "minecraft:flint_and_steel" | "minecraft:red_candle" | "minecraft:orange_dye_from_orange_tulip" | "irons_spellbooks:netherite_spell_book" | "minecraft:brown_carpet" | "minecraft:jungle_door" | "minecraft:black_dye" | "minecraft:black_stained_glass_pane" | "minecraft:prismarine_brick_slab" | "minecraft:prismarine_bricks" | "minecraft:nether_bricks" | "minecraft:blue_carpet" | "minecraft:deepslate_brick_stairs_from_polished_deepslate_stonecutting" | "minecraft:bamboo_door" | "minecraft:iron_chestplate" | "irons_spellbooks:shadowwalker_chestplate" | "minecraft:crimson_fence" | "minecraft:stone_bricks" | "minecraft:oxidized_cut_copper_slab" | "irons_spellbooks:curios/heavy_chain_necklace" | "minecraft:lapis_lazuli_from_blasting_deepslate_lapis_ore" | "minecraft:birch_stairs" | "minecraft:exposed_cut_copper_slab_from_exposed_cut_copper_stonecutting" | "minecraft:dune_armor_trim_smithing_template_smithing_trim" | "minecraft:vex_armor_trim_smithing_template" | "minecraft:dye_orange_wool" | "minecraft:light_gray_stained_glass" | "minecraft:white_wool_from_string" | "minecraft:spruce_chest_boat" | "minecraft:cobblestone_wall_from_cobblestone_stonecutting" | "minecraft:polished_andesite_from_andesite_stonecutting" | "minecraft:white_stained_glass_pane" | "minecraft:golden_axe" | "minecraft:crimson_stairs" | "minecraft:dye_light_blue_wool" | "minecraft:decorated_pot_simple" | "minecraft:light_blue_stained_glass_pane" | "minecraft:mud_brick_slab_from_mud_bricks_stonecutting" | "minecraft:brown_concrete_powder" | "minecraft:cooked_chicken_from_smoking" | "minecraft:cyan_glazed_terracotta" | "minecraft:cyan_stained_glass" | "minecraft:oak_pressure_plate" | "minecraft:stone_brick_stairs" | "minecraft:stone_sword" | "minecraft:yellow_dye_from_sunflower" | "minecraft:cut_red_sandstone_from_red_sandstone_stonecutting" | "minecraft:diorite" | "minecraft:acacia_fence" | "minecraft:crimson_hyphae" | "minecraft:waxed_weathered_cut_copper_slab_from_waxed_weathered_copper_stonecutting" | "minecraft:coal_from_smelting_coal_ore" | "minecraft:oak_slab" | "minecraft:cyan_banner" | "minecraft:snout_armor_trim_smithing_template_smithing_trim" | "minecraft:polished_blackstone_wall_from_blackstone_stonecutting" | "minecraft:dripstone_block" | "minecraft:glistering_melon_slice" | "minecraft:mangrove_chest_boat" | "minecraft:smooth_stone_slab_from_smooth_stone_stonecutting" | "minecraft:crimson_button" | "minecraft:warped_door" | "minecraft:iron_hoe" | "minecraft:iron_ingot_from_iron_block" | "minecraft:jungle_hanging_sign" | "minecraft:jungle_planks" | "minecraft:netherite_axe_smithing" | "minecraft:snow" | "minecraft:acacia_fence_gate" | "irons_spellbooks:archevoker_chestplate" | "minecraft:clock" | "minecraft:mangrove_sign" | "minecraft:dye_yellow_wool" | "minecraft:magenta_carpet" | "irons_spellbooks:gold_spell_book" | "minecraft:orange_stained_glass_pane_from_glass_pane" | "minecraft:blackstone_wall_from_blackstone_stonecutting" | "minecraft:jungle_trapdoor" | "minecraft:grindstone" | "minecraft:blue_ice" | "minecraft:polished_deepslate_slab_from_polished_deepslate_stonecutting" | "minecraft:red_nether_bricks" | "minecraft:banner_duplicate" | "minecraft:granite_slab_from_granite_stonecutting" | "minecraft:dye_brown_carpet" | "minecraft:glass_pane" | "minecraft:diamond_leggings" | "minecraft:granite_stairs_from_granite_stonecutting" | "minecraft:emerald_from_smelting_emerald_ore" | "minecraft:warped_slab" | "minecraft:lectern" | "minecraft:mangrove_stairs" | "minecraft:prismarine" | "minecraft:golden_sword" | "minecraft:purple_stained_glass" | "minecraft:iron_ingot_from_nuggets" | "minecraft:chiseled_sandstone" | "minecraft:clay" | "minecraft:golden_pickaxe" | "minecraft:cut_copper_stairs" | "minecraft:bamboo_raft" | "minecraft:chiseled_bookshelf" | "minecraft:magenta_dye_from_allium" | "minecraft:smooth_stone_slab" | "minecraft:ladder" | "minecraft:polished_blackstone_slab_from_polished_blackstone_stonecutting" | "minecraft:dye_lime_wool" | "minecraft:redstone_torch" | "minecraft:moss_carpet" | "minecraft:oxidized_cut_copper_stairs_from_oxidized_cut_copper_stonecutting" | "irons_spellbooks:plagued_boots" | "minecraft:mossy_cobblestone_slab" | "minecraft:polished_andesite_slab_from_andesite_stonecutting" | "minecraft:dye_black_bed" | "minecraft:furnace_minecart" | "minecraft:mossy_cobblestone_from_vine" | "minecraft:target" | "minecraft:polished_diorite_slab_from_diorite_stonecutting" | "minecraft:white_concrete_powder" | "minecraft:yellow_terracotta" | "minecraft:orange_carpet" | "minecraft:mossy_stone_bricks_from_moss_block" | "minecraft:waxed_weathered_cut_copper" | "minecraft:cake" | "minecraft:gray_bed" | "minecraft:orange_banner" | "minecraft:dark_oak_sign" | "minecraft:granite_slab" | "minecraft:cherry_boat" | "minecraft:chiseled_nether_bricks_from_nether_bricks_stonecutting" | "minecraft:mud_brick_stairs" | "minecraft:white_terracotta" | "minecraft:leather_boots" | "minecraft:diamond_from_blasting_deepslate_diamond_ore" | "minecraft:netherite_ingot_from_netherite_block" | "minecraft:oak_hanging_sign" | "minecraft:armor_stand" | "minecraft:pink_stained_glass_pane" | "minecraft:lime_concrete_powder" | "minecraft:mangrove_slab" | "minecraft:leather_leggings" | "minecraft:sandstone_wall_from_sandstone_stonecutting" | "minecraft:blue_dye_from_cornflower" | "minecraft:brick_slab_from_bricks_stonecutting" | "minecraft:stripped_cherry_wood" | "minecraft:polished_blackstone_bricks_from_polished_blackstone_stonecutting" | "minecraft:quartz_slab_from_stonecutting" | "minecraft:brown_banner" | "minecraft:barrel" | "minecraft:cherry_pressure_plate" | "minecraft:polished_blackstone_button" | "minecraft:polished_blackstone_slab_from_blackstone_stonecutting" | "minecraft:warped_hyphae" | "minecraft:redstone_from_blasting_deepslate_redstone_ore" | "minecraft:netherite_scrap_from_blasting" | "minecraft:jungle_chest_boat" | "irons_spellbooks:spellbreaker" | "minecraft:red_nether_brick_slab_from_red_nether_bricks_stonecutting" | "irons_spellbooks:shriving_stone" | "minecraft:dark_prismarine_slab_from_dark_prismarine_stonecutting" | "irons_spellbooks:cultist_leggings" | "minecraft:lime_stained_glass_pane_from_glass_pane" | "minecraft:baked_potato_from_smoking" | "minecraft:magenta_glazed_terracotta" | "irons_spellbooks:cryomancer_leggings" | "minecraft:deepslate_brick_slab_from_polished_deepslate_stonecutting" | "minecraft:dye_black_carpet" | "minecraft:chiseled_stone_bricks_stone_from_stonecutting" | "minecraft:book" | "minecraft:chiseled_stone_bricks" | "irons_spellbooks:arcane_anvil" | "minecraft:netherite_sword_smithing" | "minecraft:polished_blackstone_brick_wall_from_blackstone_stonecutting" | "minecraft:wooden_shovel" | "minecraft:end_stone_brick_slab" | "minecraft:smithing_table" | "minecraft:green_bed" | "minecraft:dye_gray_carpet" | "minecraft:deepslate_tile_slab_from_polished_deepslate_stonecutting" | "minecraft:magma_block" | "minecraft:polished_granite_stairs_from_granite_stonecutting" | "minecraft:shaper_armor_trim_smithing_template" | "minecraft:red_sandstone_slab_from_red_sandstone_stonecutting" | "minecraft:spruce_pressure_plate" | "minecraft:polished_blackstone_brick_stairs_from_polished_blackstone_stonecutting" | "minecraft:purple_terracotta" | "minecraft:cauldron" | "minecraft:pink_concrete_powder" | "minecraft:bamboo_trapdoor" | "irons_spellbooks:pyromancer_chestplate" | "minecraft:red_nether_brick_stairs_from_red_nether_bricks_stonecutting" | "irons_spellbooks:netherite_mage_leggings" | "minecraft:waxed_copper_block_from_honeycomb" | "minecraft:brush" | "minecraft:magenta_concrete_powder" | "minecraft:red_dye_from_poppy" | "minecraft:redstone_from_smelting_deepslate_redstone_ore" | "minecraft:deepslate_tiles_from_deepslate_bricks_stonecutting" | "minecraft:diamond_shovel" | "minecraft:warped_fungus_on_a_stick" | "minecraft:waxed_weathered_cut_copper_slab_from_honeycomb" | "irons_spellbooks:wayward_compass" | "minecraft:deepslate_tile_slab_from_deepslate_tiles_stonecutting" | "minecraft:prismarine_brick_slab_from_prismarine_stonecutting" | "minecraft:andesite_wall" | "minecraft:sandstone_slab" | "irons_spellbooks:cooldown_upgrade_orb" | "minecraft:hay_block" | "minecraft:light_blue_candle" | "irons_spellbooks:electromancer_boots" | "minecraft:raiser_armor_trim_smithing_template_smithing_trim" | "minecraft:waxed_oxidized_cut_copper_stairs_from_waxed_oxidized_cut_copper_stonecutting" | "minecraft:cobblestone_slab" | "minecraft:gold_ingot_from_smelting_raw_gold" | "minecraft:iron_ingot_from_blasting_deepslate_iron_ore" | "minecraft:gray_banner" | "minecraft:warped_stairs" | "minecraft:spruce_hanging_sign" | "minecraft:wild_armor_trim_smithing_template" | "minecraft:gold_ingot_from_smelting_gold_ore" | "minecraft:cracked_polished_blackstone_bricks" | "minecraft:deepslate_brick_slab_from_cobbled_deepslate_stonecutting" | "irons_spellbooks:lesser_spell_slot_upgrade" | "minecraft:deepslate_tile_wall_from_deepslate_tiles_stonecutting" | "minecraft:end_stone_bricks_from_end_stone_stonecutting" | "minecraft:mossy_stone_brick_slab_from_mossy_stone_brick_stonecutting" | "minecraft:popped_chorus_fruit" | "minecraft:cooked_cod_from_smoking" | "irons_spellbooks:hogskin_to_leather" | "minecraft:snout_armor_trim_smithing_template" | "irons_spellbooks:frozen_bone_to_bonemeal" | "minecraft:shaper_armor_trim_smithing_template_smithing_trim" | "minecraft:minecart" | "minecraft:stone_bricks_from_stone_stonecutting" | "minecraft:smooth_sandstone_slab" | "irons_spellbooks:ender_rune" | "minecraft:smooth_quartz_slab_from_smooth_quartz_stonecutting" | "minecraft:chest" | "minecraft:gray_stained_glass" | "minecraft:rail" | "minecraft:pink_candle" | "minecraft:diamond_sword" | "minecraft:red_terracotta" | "minecraft:yellow_banner" | "irons_spellbooks:upgrade_orb" | "minecraft:creeper_banner_pattern" | "minecraft:waxed_exposed_cut_copper_slab" | "minecraft:red_bed" | "minecraft:dark_oak_fence" | "minecraft:golden_shovel" | "irons_spellbooks:electromancer_chestplate" | "minecraft:ward_armor_trim_smithing_template_smithing_trim" | "minecraft:cut_copper" | "minecraft:deepslate_tile_stairs" | "minecraft:dye_gray_wool" | "minecraft:purpur_stairs_from_purpur_block_stonecutting" | "minecraft:soul_lantern" | "titanium:test_serializer/dirt_to_diamod" | "minecraft:copper_ingot" | "minecraft:deepslate_bricks_from_cobbled_deepslate_stonecutting" | "minecraft:waxed_weathered_cut_copper_slab" | "minecraft:white_dye_from_lily_of_the_valley" | "minecraft:crimson_trapdoor" | "minecraft:waxed_oxidized_cut_copper_slab_from_waxed_oxidized_copper_stonecutting" | "minecraft:pink_dye_from_pink_petals" | "minecraft:oxidized_cut_copper_slab_from_oxidized_copper_stonecutting" | "minecraft:brick_wall_from_bricks_stonecutting" | "irons_spellbooks:copper_spell_book" | "minecraft:dye_gray_bed" | "minecraft:end_stone_brick_wall" | "minecraft:firework_star_fade" | "irons_spellbooks:plagued_helmet" | "minecraft:eye_armor_trim_smithing_template_smithing_trim" | "minecraft:polished_diorite_slab" | "irons_spellbooks:netherite_mage_helmet" | "minecraft:dye_light_gray_bed" | "minecraft:bamboo_stairs" | "minecraft:brown_glazed_terracotta" | "minecraft:smooth_sandstone_stairs" | "minecraft:blaze_powder" | "minecraft:end_stone_brick_slab_from_end_stone_stonecutting" | "minecraft:waxed_exposed_cut_copper_slab_from_waxed_exposed_cut_copper_stonecutting" | "minecraft:copper_ingot_from_blasting_copper_ore" | "minecraft:smooth_basalt" | "minecraft:chain" | "minecraft:polished_blackstone_from_blackstone_stonecutting" | "minecraft:blue_concrete_powder" | "minecraft:blue_stained_glass" | "minecraft:iron_ingot_from_smelting_deepslate_iron_ore" | "minecraft:oak_fence" | "minecraft:warped_trapdoor" | "minecraft:chiseled_deepslate_from_cobbled_deepslate_stonecutting" | "minecraft:rabbit_stew_from_red_mushroom" | "minecraft:iron_boots" | "minecraft:netherite_hoe_smithing" | "minecraft:polished_blackstone_brick_stairs_from_polished_blackstone_bricks_stonecutting" | "minecraft:prismarine_brick_stairs" | "irons_spellbooks:ice_staff" | "minecraft:diamond_chestplate" | "minecraft:waxed_oxidized_cut_copper_stairs_from_honeycomb" | "minecraft:golden_chestplate" | "minecraft:netherite_chestplate_smithing" | "minecraft:copper_ingot_from_smelting_raw_copper" | "minecraft:prismarine_stairs_from_prismarine_stonecutting" | "minecraft:crimson_planks" | "minecraft:oak_sign" | "minecraft:smooth_red_sandstone" | "minecraft:quartz_stairs_from_quartz_block_stonecutting" | "minecraft:blue_candle" | "minecraft:netherite_ingot" | "minecraft:birch_sign" | "minecraft:exposed_cut_copper_stairs_from_exposed_copper_stonecutting" | "irons_spellbooks:divine_pearl" | "irons_spellbooks:priest_boots" | "minecraft:wayfinder_armor_trim_smithing_template_smithing_trim" | "minecraft:diamond_from_smelting_deepslate_diamond_ore" | "minecraft:birch_pressure_plate" | "minecraft:flower_banner_pattern" | "minecraft:netherite_block" | "irons_spellbooks:druidic_spell_book" | "minecraft:deepslate" | "minecraft:light_blue_terracotta" | "minecraft:orange_dye_from_red_yellow" | "minecraft:red_sandstone_stairs_from_red_sandstone_stonecutting" | "minecraft:spruce_stairs" | "minecraft:mangrove_planks" | "minecraft:emerald_from_blasting_deepslate_emerald_ore" | "minecraft:polished_blackstone_brick_slab_from_polished_blackstone_bricks_stonecutting" | "minecraft:smooth_sandstone_slab_from_smooth_sandstone_stonecutting" | "minecraft:black_bed" | "irons_spellbooks:nature_upgrade_orb" | "minecraft:gold_ingot_from_blasting_raw_gold" | "minecraft:jungle_sign" | "minecraft:cyan_candle" | "minecraft:iron_nugget_from_blasting" | "irons_spellbooks:wandering_magician_boots" | "minecraft:cut_red_sandstone_slab_from_red_sandstone_stonecutting" | "minecraft:diamond_from_smelting_diamond_ore" | "minecraft:gold_ingot_from_blasting_gold_ore" | "minecraft:crossbow" | "minecraft:light_gray_dye_from_azure_bluet" | "minecraft:light_gray_dye_from_white_tulip" | "minecraft:shield_decoration" | "minecraft:calibrated_sculk_sensor" | "minecraft:deepslate_tile_wall_from_cobbled_deepslate_stonecutting" | "minecraft:bowl" | "irons_spellbooks:wandering_magician_leggings" | "minecraft:diamond" | "minecraft:magenta_candle" | "minecraft:green_stained_glass_pane" | "minecraft:crimson_slab" | "minecraft:magenta_dye_from_blue_red_pink" | "minecraft:black_concrete_powder" | "irons_spellbooks:plagued_leggings" | "minecraft:prismarine_slab_from_prismarine_stonecutting" | "minecraft:lime_carpet" | "minecraft:purple_banner" | "minecraft:purple_concrete_powder" | "minecraft:sugar_from_sugar_cane" | "minecraft:birch_planks" | "minecraft:polished_deepslate_slab_from_cobbled_deepslate_stonecutting" | "minecraft:light_gray_dye_from_black_white_dye" | "minecraft:deepslate_tile_wall_from_deepslate_bricks_stonecutting" | "minecraft:light_gray_stained_glass_pane" | "minecraft:spectral_arrow" | "minecraft:green_terracotta" | "minecraft:tnt_minecart" | "minecraft:red_carpet" | "minecraft:white_stained_glass" | "minecraft:acacia_planks" | "minecraft:slime_block" | "minecraft:cooked_beef_from_campfire_cooking" | "minecraft:wooden_hoe" | "minecraft:quartz_pillar" | "minecraft:cooked_rabbit_from_campfire_cooking" | "minecraft:dye_red_wool" | "minecraft:cherry_button" | "minecraft:mud_bricks" | "irons_spellbooks:cryomancer_boots" | "minecraft:dye_magenta_bed" | "minecraft:netherite_upgrade_smithing_template" | "minecraft:waxed_cut_copper_from_honeycomb" | "minecraft:waxed_oxidized_cut_copper_from_waxed_oxidized_copper_stonecutting" | "minecraft:dye_magenta_carpet" | "minecraft:purpur_stairs" | "minecraft:brown_terracotta" | "minecraft:waxed_oxidized_cut_copper_stairs" | "irons_spellbooks:mana_ring" | "minecraft:bamboo_block" | "minecraft:mossy_cobblestone_stairs" | "minecraft:note_block" | "minecraft:mud_brick_stairs_from_mud_bricks_stonecutting" | "minecraft:weathered_cut_copper_stairs_from_weathered_cut_copper_stonecutting" | "minecraft:dye_orange_bed" | "minecraft:blue_dye" | "minecraft:polished_diorite_slab_from_polished_diorite_stonecutting" | "minecraft:waxed_weathered_cut_copper_stairs_from_waxed_weathered_copper_stonecutting" | "minecraft:acacia_hanging_sign" | "minecraft:muddy_mangrove_roots" | "irons_spellbooks:evocation_upgrade_orb" | "minecraft:blackstone_stairs_from_blackstone_stonecutting" | "minecraft:piston" | "minecraft:waxed_weathered_cut_copper_from_waxed_weathered_copper_stonecutting" | "minecraft:brown_bed" | "minecraft:blue_bed" | "minecraft:ward_armor_trim_smithing_template" | "minecraft:light_gray_carpet" | "minecraft:weathered_cut_copper_slab_from_weathered_copper_stonecutting" | "minecraft:white_banner" | "minecraft:smooth_quartz" | "minecraft:end_crystal" | "minecraft:magenta_stained_glass_pane_from_glass_pane" | "minecraft:smooth_red_sandstone_stairs" | "minecraft:smooth_sandstone" | "minecraft:light_gray_banner" | "minecraft:stone_pickaxe" | "minecraft:light_blue_glazed_terracotta" | "minecraft:shulker_box" | "irons_spellbooks:archevoker_leggings" | "minecraft:cut_red_sandstone_slab_from_cut_red_sandstone_stonecutting" | "minecraft:dispenser" | "minecraft:wooden_axe" | "minecraft:cyan_stained_glass_pane" | "minecraft:daylight_detector" | "minecraft:sponge" | "minecraft:quartz_stairs" | "minecraft:diorite_wall" | "minecraft:quartz_from_blasting" | "minecraft:purple_glazed_terracotta" | "minecraft:white_carpet" | "minecraft:spruce_planks" | "minecraft:mossy_cobblestone_stairs_from_mossy_cobblestone_stonecutting" | "minecraft:red_stained_glass" | "minecraft:light_gray_stained_glass_pane_from_glass_pane" | "minecraft:green_carpet" | "minecraft:polished_blackstone_bricks" | "minecraft:purpur_slab" | "minecraft:waxed_exposed_cut_copper_from_honeycomb" | "minecraft:mossy_cobblestone_from_moss_block" | "minecraft:cracked_stone_bricks" | "minecraft:jack_o_lantern" | "minecraft:tripwire_hook" | "minecraft:chiseled_polished_blackstone_from_blackstone_stonecutting" | "minecraft:diorite_stairs_from_diorite_stonecutting" | "minecraft:trapped_chest" | "minecraft:hopper" | "irons_spellbooks:holy_upgrade_orb" | "minecraft:cut_sandstone_from_sandstone_stonecutting" | "minecraft:stone_stairs_from_stone_stonecutting" | "minecraft:lantern" | "minecraft:raw_gold" | "minecraft:waxed_cut_copper_slab_from_waxed_copper_block_stonecutting" | "minecraft:green_banner" | "minecraft:dried_kelp" | "minecraft:ender_chest" | "irons_spellbooks:firefly_jar" | "minecraft:magenta_stained_glass" | "minecraft:gold_nugget" | "minecraft:polished_andesite_stairs_from_andesite_stonecutting" | "minecraft:iron_bars" | "minecraft:beetroot_soup" | "minecraft:iron_trapdoor" | "minecraft:brown_candle" | "minecraft:deepslate_brick_wall" | "minecraft:green_glazed_terracotta" | "minecraft:lime_terracotta" | "minecraft:cooked_cod" | "minecraft:diamond_axe" | "minecraft:iron_helmet" | "irons_spellbooks:blood_rune" | "minecraft:blackstone_slab_from_blackstone_stonecutting" | "minecraft:jungle_wood" | "minecraft:waxed_oxidized_cut_copper" | "minecraft:cartography_table" | "minecraft:gray_stained_glass_pane_from_glass_pane" | "minecraft:polished_diorite" | "minecraft:stone_slab" | "minecraft:acacia_pressure_plate" | "minecraft:lime_bed" | "minecraft:dark_oak_pressure_plate" | "minecraft:dye_blue_wool" | "minecraft:acacia_slab" | "minecraft:brick_stairs_from_bricks_stonecutting" | "titanium:test_serializer/dirt_to_used" | "minecraft:jungle_stairs" | "minecraft:cooked_porkchop_from_smoking" | "minecraft:blast_furnace" | "minecraft:polished_andesite_stairs" | "minecraft:deepslate_brick_stairs_from_deepslate_bricks_stonecutting" | "minecraft:light_blue_stained_glass_pane_from_glass_pane" | "minecraft:magenta_dye_from_lilac" | "minecraft:waxed_weathered_cut_copper_from_honeycomb" | "irons_spellbooks:patchouli_book" | "minecraft:dye_red_bed" | "minecraft:cherry_chest_boat" | "minecraft:tipped_arrow" | "minecraft:waxed_cut_copper" | "minecraft:rib_armor_trim_smithing_template_smithing_trim" | "minecraft:blue_stained_glass_pane_from_glass_pane" | "minecraft:light_blue_carpet" | "minecraft:chiseled_polished_blackstone" | "irons_spellbooks:cryomancer_chestplate" | "minecraft:firework_rocket" | "minecraft:turtle_helmet" | "minecraft:polished_andesite_slab_from_polished_andesite_stonecutting" | "minecraft:red_sandstone_wall_from_red_sandstone_stonecutting" | "minecraft:gold_ingot_from_smelting_deepslate_gold_ore" | "minecraft:cobbled_deepslate_stairs" | "minecraft:baked_potato" | "minecraft:fletching_table" | "minecraft:light_blue_banner" | "minecraft:dye_lime_bed" | "minecraft:mud_brick_wall_from_mud_bricks_stonecutting" | "minecraft:waxed_exposed_cut_copper_stairs_from_waxed_exposed_copper_stonecutting" | "minecraft:cooked_salmon" | "minecraft:light_gray_dye_from_gray_white_dye" | "minecraft:mossy_cobblestone_wall" | "minecraft:spyglass" | "minecraft:magenta_dye_from_purple_and_pink" | "minecraft:red_banner" | "minecraft:purpur_pillar" | "minecraft:heavy_weighted_pressure_plate" | "minecraft:deepslate_tile_slab" | "irons_spellbooks:dragonskin_spell_book" | "minecraft:pink_stained_glass" | "minecraft:stone_shovel" | "minecraft:golden_leggings" | "minecraft:oak_chest_boat" | "minecraft:stripped_birch_wood" | "minecraft:deepslate_tiles_from_polished_deepslate_stonecutting" | "minecraft:waxed_oxidized_cut_copper_slab" | "minecraft:end_stone_brick_wall_from_end_stone_brick_stonecutting" | "irons_spellbooks:energized_core" | "minecraft:polished_blackstone_stairs" | "minecraft:lime_banner" | "minecraft:netherite_pickaxe_smithing" | "minecraft:deepslate_brick_stairs" | "minecraft:stone_pressure_plate" | "minecraft:dropper" | "minecraft:redstone_lamp" | "minecraft:yellow_stained_glass_pane" | "minecraft:black_carpet" | "minecraft:deepslate_brick_wall_from_cobbled_deepslate_stonecutting" | "irons_spellbooks:netherite_mage_boots" | "minecraft:end_rod" | "minecraft:cut_copper_from_copper_block_stonecutting" | "minecraft:diorite_slab_from_diorite_stonecutting" | "irons_spellbooks:curios/affinity_ring" | "minecraft:iron_ingot_from_blasting_iron_ore" | "minecraft:lime_dye_from_smelting" | "minecraft:polished_andesite_stairs_from_polished_andesite_stonecutting" | "minecraft:tide_armor_trim_smithing_template_smithing_trim" | "minecraft:dye_magenta_wool" | "minecraft:raiser_armor_trim_smithing_template" | "minecraft:deepslate_tile_stairs_from_deepslate_tiles_stonecutting" | "irons_spellbooks:frosted_helve" | "minecraft:bamboo_mosaic_stairs" | "minecraft:golden_helmet" | "minecraft:light_blue_dye_from_blue_orchid" | "minecraft:weathered_cut_copper_stairs" | "minecraft:mossy_stone_brick_wall_from_mossy_stone_brick_stonecutting" | "minecraft:warped_button" | "minecraft:waxed_oxidized_cut_copper_slab_from_honeycomb" | "irons_spellbooks:curios/concentration_amulet" | "minecraft:polished_deepslate" | "minecraft:oxidized_cut_copper_from_oxidized_copper_stonecutting" | "irons_spellbooks:mana_upgrade_orb" | "minecraft:bone_meal_from_bone_block" | "minecraft:bread" | "minecraft:mangrove_boat" | "minecraft:torch" | "minecraft:polished_granite_stairs" | "minecraft:acacia_boat" | "minecraft:armor_dye" | "minecraft:lever" | "minecraft:end_stone_brick_wall_from_end_stone_stonecutting" | "minecraft:dye_blue_bed" | "minecraft:cobbled_deepslate_slab_from_cobbled_deepslate_stonecutting" | "minecraft:map" | "irons_spellbooks:alchemist_cauldron" | "minecraft:detector_rail" | "minecraft:pink_bed" | "minecraft:shield" | "minecraft:blackstone_slab" | "minecraft:dye_light_blue_carpet" | "minecraft:bamboo_slab" | "minecraft:cooked_porkchop_from_campfire_cooking" | "minecraft:crimson_sign" | "minecraft:cyan_stained_glass_pane_from_glass_pane" | "minecraft:dark_oak_chest_boat" | "minecraft:dark_oak_trapdoor" | "minecraft:waxed_exposed_cut_copper_slab_from_waxed_exposed_copper_stonecutting" | "irons_spellbooks:curios/emerald_stoneplate_ring" | "irons_spellbooks:holy_rune" | "minecraft:black_banner" | "minecraft:painting" | "minecraft:iron_shovel" | "minecraft:dye_red_carpet" | "minecraft:stone_brick_slab" | "minecraft:cooked_rabbit_from_smoking" | "irons_spellbooks:pumpkin_leggings" | "minecraft:polished_blackstone_pressure_plate" | "minecraft:quartz_bricks" | "minecraft:crafting_table" | "minecraft:map_cloning" | "minecraft:sandstone_wall" | "minecraft:green_stained_glass_pane_from_glass_pane" | "minecraft:polished_deepslate_slab" | "minecraft:red_sandstone_wall" | "minecraft:acacia_chest_boat" | "minecraft:cut_copper_slab" | "minecraft:dark_oak_wood" | "minecraft:birch_hanging_sign" | "irons_spellbooks:plagued_chestplate" | "minecraft:stone_slab_from_stone_stonecutting" | "irons_spellbooks:priest_helmet" | "minecraft:orange_glazed_terracotta" | "minecraft:pink_carpet" | "minecraft:gray_glazed_terracotta" | "minecraft:acacia_stairs" | "minecraft:cherry_slab" | "minecraft:stone_brick_slab_from_stone_stonecutting" | "minecraft:deepslate_bricks" | "minecraft:iron_nugget_from_smelting" | "minecraft:raw_gold_block" | "minecraft:birch_door" | "minecraft:waxed_exposed_copper_from_honeycomb" | "minecraft:anvil" | "minecraft:stripped_acacia_wood" | "minecraft:waxed_weathered_cut_copper_stairs" | "minecraft:gold_ingot_from_nuggets" | "minecraft:mossy_stone_brick_stairs" | "minecraft:cooked_chicken" | "minecraft:smooth_quartz_stairs_from_smooth_quartz_stonecutting" | "minecraft:oak_trapdoor" | "minecraft:amethyst_block" | "minecraft:chiseled_polished_blackstone_from_polished_blackstone_stonecutting" | "minecraft:oak_door" | "minecraft:netherite_leggings_smithing" | "minecraft:waxed_cut_copper_slab_from_honeycomb" | "minecraft:orange_bed" | "minecraft:birch_button" | "minecraft:nether_brick" | "minecraft:wooden_sword" | "minecraft:birch_fence_gate" | "minecraft:bone_meal" | "minecraft:stone_brick_stairs_from_stone_stonecutting" | "irons_spellbooks:arcane_salvage_from_curio" | "minecraft:gold_ingot_from_blasting_nether_gold_ore" | "minecraft:black_glazed_terracotta" | "minecraft:polished_diorite_stairs_from_diorite_stonecutting" | "minecraft:weathered_cut_copper_stairs_from_weathered_copper_stonecutting" | "irons_spellbooks:fire_rune" | "minecraft:honey_bottle" | "minecraft:cyan_bed" | "minecraft:smooth_quartz_slab" | "minecraft:spruce_door" | "minecraft:carrot_on_a_stick" | "minecraft:red_stained_glass_pane" | "irons_spellbooks:curios/fireward_ring" | "minecraft:brick_wall" | "minecraft:lapis_lazuli_from_smelting_lapis_ore" | "minecraft:raw_copper_block" | "minecraft:polished_diorite_from_diorite_stonecutting" | "minecraft:purple_bed" | "irons_spellbooks:lightning_upgrade_orb" | "irons_spellbooks:arcane_ingot" | "minecraft:mud_brick_wall" | "irons_spellbooks:shadowwalker_helmet" | "irons_spellbooks:priest_chestplate" | "minecraft:waxed_exposed_cut_copper_stairs_from_waxed_exposed_cut_copper_stonecutting" | "minecraft:dark_prismarine" | "minecraft:prismarine_wall_from_prismarine_stonecutting" | "minecraft:purple_stained_glass_pane_from_glass_pane" | "minecraft:leather_horse_armor" | "minecraft:cookie" | "minecraft:raw_iron_block" | "minecraft:dark_oak_planks" | "minecraft:lapis_lazuli" | "minecraft:candle" | "minecraft:lightning_rod" | "minecraft:brown_stained_glass_pane_from_glass_pane" | "minecraft:oak_button" | "minecraft:granite_wall" | "irons_spellbooks:netherite_mage_chestplate" | "minecraft:orange_concrete_powder" | "minecraft:dark_oak_hanging_sign" | "minecraft:polished_blackstone_brick_slab_from_polished_blackstone_stonecutting" | "minecraft:redstone_block" | "minecraft:shears" | "minecraft:waxed_oxidized_cut_copper_slab_from_waxed_oxidized_cut_copper_stonecutting" | "minecraft:wheat" | "irons_spellbooks:uninscribe_rune" | "minecraft:polished_deepslate_wall_from_cobbled_deepslate_stonecutting" | "minecraft:honeycomb_block" | "minecraft:orange_stained_glass_pane" | "minecraft:quartz_block" | "minecraft:brick" | "minecraft:yellow_stained_glass_pane_from_glass_pane" | "minecraft:deepslate_tile_slab_from_cobbled_deepslate_stonecutting" | "minecraft:exposed_cut_copper_from_exposed_copper_stonecutting" | "minecraft:music_disc_5" | "minecraft:mossy_cobblestone_slab_from_mossy_cobblestone_stonecutting" | "minecraft:diamond_helmet" | "minecraft:warped_fence" | "minecraft:bow" | "minecraft:andesite_stairs_from_andesite_stonecutting" | "minecraft:stone_brick_slab_from_stone_bricks_stonecutting" | "minecraft:dark_oak_fence_gate" | "minecraft:waxed_exposed_cut_copper" | "minecraft:coal" | "minecraft:compass" | "minecraft:dye_pink_bed" | "minecraft:gold_ingot_from_blasting_deepslate_gold_ore" | "minecraft:andesite_stairs" | "minecraft:item_frame" | "minecraft:waxed_weathered_cut_copper_slab_from_waxed_weathered_cut_copper_stonecutting" | "minecraft:iron_ingot_from_smelting_iron_ore" | "minecraft:jungle_slab" | "minecraft:loom" | "minecraft:polished_granite_stairs_from_polished_granite_stonecutting" | "minecraft:smoker" | "minecraft:skull_banner_pattern" | "minecraft:dark_oak_boat" | "irons_spellbooks:shadowwalker_boots" | "irons_spellbooks:archevoker_helmet" | "minecraft:coast_armor_trim_smithing_template" | "minecraft:pink_dye_from_pink_tulip" | "minecraft:arrow" | "minecraft:dune_armor_trim_smithing_template" | "minecraft:oak_fence_gate" | "minecraft:copper_ingot_from_smelting_deepslate_copper_ore" | "minecraft:mossy_stone_brick_wall" | "minecraft:brown_dye" | "minecraft:granite" | "minecraft:melon_seeds" | "minecraft:polished_blackstone_stairs_from_blackstone_stonecutting" | "minecraft:waxed_exposed_cut_copper_stairs_from_honeycomb" | "minecraft:dye_cyan_carpet" | "minecraft:brick_slab" | "minecraft:firework_rocket_simple" | "minecraft:black_dye_from_wither_rose" | "minecraft:red_sandstone_stairs" | "minecraft:coast_armor_trim_smithing_template_smithing_trim" | "minecraft:sandstone_stairs_from_sandstone_stonecutting" | "minecraft:bricks" | "minecraft:red_sandstone_slab" | "minecraft:gray_stained_glass_pane" | "minecraft:gray_carpet" | "minecraft:oxidized_cut_copper_stairs" | "minecraft:yellow_glazed_terracotta" | "minecraft:mangrove_trapdoor" | "minecraft:andesite" | "minecraft:diamond_boots" | "minecraft:crimson_hanging_sign" | "minecraft:deepslate_tile_wall" | "minecraft:polished_deepslate_stairs" | "minecraft:exposed_cut_copper" | "minecraft:polished_blackstone" | "minecraft:mangrove_hanging_sign" | "minecraft:waxed_exposed_cut_copper_slab_from_honeycomb" | "minecraft:stick" | "irons_spellbooks:pumpkin_helmet" | "minecraft:red_nether_brick_stairs" | "minecraft:dark_oak_stairs" | "minecraft:jungle_pressure_plate" | "minecraft:brewing_stand" | "minecraft:dye_yellow_carpet" | "minecraft:white_candle" | "minecraft:polished_blackstone_brick_wall_from_polished_blackstone_bricks_stonecutting" | "minecraft:bamboo_mosaic_slab" | "minecraft:host_armor_trim_smithing_template" | "minecraft:dye_white_wool" | "minecraft:emerald_from_blasting_emerald_ore" | "minecraft:smooth_red_sandstone_stairs_from_smooth_red_sandstone_stonecutting" | "minecraft:cobbled_deepslate_wall_from_cobbled_deepslate_stonecutting" | "minecraft:dye_light_gray_carpet" | "minecraft:spire_armor_trim_smithing_template" | "irons_spellbooks:cooldown_rune" | "minecraft:polished_blackstone_brick_wall" | "minecraft:stone_axe" | "minecraft:jungle_button" | "minecraft:packed_ice" | "irons_spellbooks:priest_leggings" | "irons_spellbooks:wandering_magician_helmet" | "minecraft:golden_carrot" | "minecraft:stone" | "minecraft:blackstone_stairs" | "minecraft:dried_kelp_from_campfire_cooking" | "minecraft:blue_banner" | "minecraft:dye_purple_carpet" | "minecraft:dye_orange_carpet" | "minecraft:prismarine_wall" | "minecraft:diamond_block" | "minecraft:deepslate_tile_slab_from_deepslate_bricks_stonecutting" | "minecraft:deepslate_tile_stairs_from_deepslate_bricks_stonecutting" | "minecraft:dye_cyan_bed" | "minecraft:waxed_oxidized_copper_from_honeycomb" | "minecraft:diorite_slab" | "minecraft:spruce_trapdoor" | "minecraft:yellow_stained_glass" | "minecraft:light_blue_stained_glass" | "minecraft:waxed_oxidized_cut_copper_stairs_from_waxed_oxidized_copper_stonecutting" | "minecraft:glowstone" | "minecraft:respawn_anchor" | "minecraft:pumpkin_seeds" | "minecraft:vex_armor_trim_smithing_template_smithing_trim" | "minecraft:cobbled_deepslate_wall" | "minecraft:deepslate_brick_slab" | "minecraft:purpur_slab_from_purpur_block_stonecutting" | "minecraft:red_nether_brick_wall" | "minecraft:chiseled_red_sandstone" | "minecraft:nether_brick_fence" | "minecraft:polished_blackstone_brick_stairs_from_blackstone_stonecutting" | "minecraft:magma_cream" | "minecraft:blackstone_wall" | "minecraft:smooth_stone" | "minecraft:cooked_mutton" | "minecraft:bookshelf" | "minecraft:dark_prismarine_stairs" | "minecraft:iron_ingot_from_blasting_raw_iron" | "minecraft:light_gray_candle" | "minecraft:lapis_block" | "irons_spellbooks:cultist_helmet" | "minecraft:cobbled_deepslate_stairs_from_cobbled_deepslate_stonecutting" | "minecraft:purple_carpet" | "minecraft:birch_chest_boat" | "minecraft:brown_stained_glass_pane" | "minecraft:dried_kelp_from_smelting" | "minecraft:polished_deepslate_stairs_from_cobbled_deepslate_stonecutting" | "minecraft:black_terracotta" | "minecraft:polished_granite_slab_from_granite_stonecutting" | "minecraft:snow_block" | "minecraft:cherry_sign" | "minecraft:iron_axe" | "minecraft:dye_lime_carpet" | "minecraft:composter" | "minecraft:ender_eye" | "minecraft:sandstone_stairs" | "minecraft:jukebox" | "minecraft:polished_deepslate_wall_from_polished_deepslate_stonecutting" | "minecraft:light_gray_terracotta" | "minecraft:white_bed" | "minecraft:birch_slab" | "minecraft:spruce_slab" | "minecraft:deepslate_tile_stairs_from_cobbled_deepslate_stonecutting" | "minecraft:acacia_sign" | "minecraft:coarse_dirt" | "minecraft:chest_minecart" | "minecraft:cobblestone_slab_from_cobblestone_stonecutting" | "minecraft:oak_boat" | "minecraft:mossy_stone_brick_stairs_from_mossy_stone_brick_stonecutting" | "minecraft:waxed_cut_copper_stairs" | "minecraft:quartz_bricks_from_quartz_block_stonecutting" | "minecraft:sea_lantern" | "minecraft:yellow_carpet" | "minecraft:green_candle" | "minecraft:dye_blue_carpet" | "minecraft:waxed_weathered_cut_copper_stairs_from_honeycomb" | "minecraft:pink_stained_glass_pane_from_glass_pane" | "minecraft:prismarine_slab" | "minecraft:red_dye_from_rose_bush" | "minecraft:exposed_cut_copper_stairs" | "minecraft:fermented_spider_eye" | "minecraft:decorated_pot" | "minecraft:light_gray_glazed_terracotta" | "minecraft:magenta_terracotta" | "minecraft:baked_potato_from_campfire_cooking" | "minecraft:stone_hoe" | "minecraft:diamond_hoe" | "minecraft:jungle_boat" | "minecraft:coal_from_smelting_deepslate_coal_ore" | "minecraft:dye_cyan_wool" | "minecraft:pumpkin_pie" | "minecraft:stripped_mangrove_wood" | "minecraft:exposed_cut_copper_stairs_from_exposed_cut_copper_stonecutting" | "minecraft:deepslate_bricks_from_polished_deepslate_stonecutting" | "minecraft:gold_ingot_from_gold_block" | "minecraft:jungle_fence" | "minecraft:light_weighted_pressure_plate" | "minecraft:cobbled_deepslate_slab" | "minecraft:cooked_mutton_from_campfire_cooking" | "minecraft:tide_armor_trim_smithing_template" | "minecraft:glass_bottle" | "minecraft:weathered_cut_copper" | "minecraft:dye_black_wool" | "minecraft:iron_ingot_from_smelting_raw_iron" | "irons_spellbooks:wandering_magician_chestplate" | "minecraft:deepslate_brick_slab_from_deepslate_bricks_stonecutting" | "minecraft:dye_green_wool" | "minecraft:iron_door" | "minecraft:purple_stained_glass_pane" | "minecraft:polished_granite" | "minecraft:cooked_beef" | "minecraft:mud_brick_slab" | "minecraft:cooked_mutton_from_smoking" | "minecraft:hopper_minecart" | "minecraft:blue_stained_glass_pane" | "minecraft:black_stained_glass_pane_from_glass_pane" | "minecraft:oxidized_cut_copper" | "minecraft:pink_banner" | "minecraft:chiseled_quartz_block" | "minecraft:soul_campfire" | "minecraft:cobblestone_stairs_from_cobblestone_stonecutting" | "minecraft:stripped_warped_hyphae" | "minecraft:bamboo_button" | "minecraft:crimson_door" | "minecraft:copper_ingot_from_waxed_copper_block" | "irons_spellbooks:amethyst_rapier" | "minecraft:end_stone_brick_stairs_from_end_stone_brick_stonecutting" | "minecraft:dye_pink_carpet" | "minecraft:gold_ingot_from_smelting_nether_gold_ore" | "minecraft:leather" | "minecraft:cherry_hanging_sign" | "minecraft:cherry_trapdoor" | "minecraft:gold_nugget_from_smelting" | "irons_spellbooks:amethyst_resonance_charm" | "minecraft:chiseled_quartz_block_from_quartz_block_stonecutting" | "minecraft:end_stone_bricks" | "minecraft:waxed_cut_copper_stairs_from_honeycomb" | "minecraft:dye_brown_bed" | "minecraft:red_stained_glass_pane_from_glass_pane" | "minecraft:acacia_trapdoor" | "minecraft:stone_brick_wall_from_stone_bricks_stonecutting" | "minecraft:waxed_cut_copper_stairs_from_waxed_copper_block_stonecutting" | "minecraft:black_candle" | "minecraft:cut_copper_slab_from_cut_copper_stonecutting" | "minecraft:light_gray_concrete_powder" | "minecraft:smooth_quartz_stairs" | "irons_spellbooks:ice_upgrade_orb" | "minecraft:furnace" | "irons_spellbooks:curios/conjurers_talisman" | "minecraft:diorite_stairs" | "minecraft:mangrove_pressure_plate" | "minecraft:cracked_nether_bricks" | "minecraft:dark_prismarine_stairs_from_dark_prismarine_stonecutting" | "minecraft:crimson_fence_gate" | "minecraft:purpur_pillar_from_purpur_block_stonecutting" | "minecraft:dye_brown_wool" | "minecraft:activator_rail" | "irons_spellbooks:arcane_rune" | "minecraft:lime_dye" | "irons_spellbooks:lightning_rune" | "minecraft:bamboo_hanging_sign" | "minecraft:polished_diorite_stairs_from_polished_diorite_stonecutting" | "minecraft:crimson_pressure_plate" | "minecraft:oak_planks" | "irons_spellbooks:curios/cooldown_ring" | "minecraft:orange_candle" | "minecraft:deepslate_brick_wall_from_polished_deepslate_stonecutting" | "minecraft:weathered_cut_copper_slab_from_weathered_cut_copper_stonecutting" | "minecraft:waxed_exposed_cut_copper_from_waxed_exposed_copper_stonecutting" | "minecraft:end_stone_brick_stairs_from_end_stone_stonecutting" | "minecraft:warped_sign" | "minecraft:lapis_lazuli_from_blasting_lapis_ore" | "minecraft:copper_ingot_from_smelting_copper_ore" | "irons_spellbooks:diamond_spell_book" | "irons_spellbooks:evocation_rune" | "minecraft:rib_armor_trim_smithing_template" | "minecraft:mangrove_door" | "minecraft:cherry_stairs" | "minecraft:cooked_chicken_from_campfire_cooking" | "minecraft:deepslate_tile_wall_from_polished_deepslate_stonecutting" | "minecraft:purple_dye" | "irons_spellbooks:graybeard_staff" | "minecraft:red_sandstone" | "minecraft:netherite_scrap" | "minecraft:stone_brick_wall" | "minecraft:iron_pickaxe" | "minecraft:quartz_slab" | "minecraft:cut_sandstone" | "minecraft:bamboo_sign" | "minecraft:spruce_button" | "minecraft:repair_item" | "minecraft:light_blue_dye_from_blue_white_dye" | "minecraft:shulker_box_coloring" | "minecraft:nether_brick_slab" | "minecraft:host_armor_trim_smithing_template_smithing_trim" | "minecraft:cyan_dye" | "minecraft:quartz_pillar_from_quartz_block_stonecutting" | "minecraft:waxed_cut_copper_stairs_from_waxed_cut_copper_stonecutting" | "minecraft:deepslate_tiles" | "minecraft:orange_terracotta" | "minecraft:deepslate_tile_stairs_from_polished_deepslate_stonecutting" | "minecraft:bamboo_fence" | "minecraft:enchanting_table" | "minecraft:red_glazed_terracotta" | "minecraft:white_glazed_terracotta" | "minecraft:deepslate_tiles_from_cobbled_deepslate_stonecutting" | "minecraft:lead" | "minecraft:birch_boat" | "minecraft:gold_block" | "minecraft:spruce_boat" | "irons_spellbooks:ender_upgrade_orb" | "minecraft:polished_diorite_stairs" | "minecraft:mossy_cobblestone_wall_from_mossy_cobblestone_stonecutting" | "minecraft:nether_brick_stairs_from_nether_bricks_stonecutting" | "minecraft:observer" | "irons_spellbooks:electromancer_leggings" | "minecraft:campfire" | "minecraft:paper" | "minecraft:polished_deepslate_wall" | "minecraft:cherry_wood" | "minecraft:dark_oak_slab" | "minecraft:lime_glazed_terracotta" | "minecraft:cooked_cod_from_campfire_cooking" | "minecraft:packed_mud" | "irons_spellbooks:weapon_parts" | "minecraft:brick_stairs" | "minecraft:dye_purple_bed" | "minecraft:lime_stained_glass" | "minecraft:cut_sandstone_slab_from_sandstone_stonecutting" | "minecraft:stripped_spruce_wood" | "minecraft:acacia_wood" | "minecraft:cherry_fence_gate" | "minecraft:netherite_helmet_smithing" | "minecraft:polished_blackstone_stairs_from_polished_blackstone_stonecutting" | "minecraft:stripped_jungle_wood" | "minecraft:pink_dye_from_peony" | "minecraft:copper_ingot_from_blasting_raw_copper" | "irons_spellbooks:cultist_chestplate" | "minecraft:stone_brick_walls_from_stone_stonecutting" | "minecraft:bucket" | "minecraft:waxed_cut_copper_from_waxed_copper_block_stonecutting" | "minecraft:cut_red_sandstone_slab" | "minecraft:silence_armor_trim_smithing_template_smithing_trim" | "minecraft:coal_from_blasting_deepslate_coal_ore" | "minecraft:black_stained_glass" | "minecraft:chiseled_red_sandstone_from_red_sandstone_stonecutting" | "irons_spellbooks:cultist_boots" | "minecraft:dye_purple_wool" | "minecraft:polished_andesite";
    type LangKey = "options.damageTiltStrength.tooltip" | "block.minecraft.brown_terracotta" | "entity.minecraft.area_effect_cloud" | "item.minecraft.gray_dye" | "entity.irons_spellbooks.flame_strike" | "block.minecraft.terracotta" | "multiplayer.disconnect.flying" | "key.categories.creative" | "item.minecraft.potion.effect.weakness" | "item.irons_spellbooks.cinder_essence.guide" | "selectWorld.backupWarning.experimental" | "config.jade.flip_main_hand" | "block.minecraft.dark_prismarine_slab" | "subtitles.entity.mooshroom.milk" | "patchouli.gui.lexicon.sneak" | "spell.irons_spellbooks.flaming_barrage" | "block.minecraft.red_nether_brick_slab" | "patchouli.gui.lexicon.button.config" | "config.jade.plugin_minecraft.animal_owner" | "block.minecraft.yellow_terracotta" | "jei.key.combo.control" | "entity.minecraft.creeper" | "key.keyboard.world.1" | "key.keyboard.world.2" | "lanserverproperties.gui.max_player" | "block.minecraft.banner.straight_cross.cyan" | "commands.schedule.created.function" | "deathScreen.quit.confirm" | "options.onlyShowSecureChat.tooltip" | "commands.data.modify.invalid_substring" | "entity.minecraft.allay" | "item.irons_spellbooks.energized_core.failure" | "commands.bossbar.remove.success" | "block.minecraft.sculk_sensor" | "gamerule.disableElytraMovementCheck" | "item.geckolib.wolf_armor_chestplate" | "advancements.nether.create_full_beacon.description" | "block.minecraft.banner.creeper.orange" | "item.irons_spellbooks.graybeard_staff" | "addServer.enterIp" | "item.minecraft.charcoal" | "stat.minecraft.clean_shulker_box" | "item.minecraft.tipped_arrow.effect.night_vision" | "block.minecraft.stone_brick_slab" | "entity.irons_spellbooks.blood_needle" | "ui.irons_spellbooks.strength" | "key.keyboard.left" | "block.minecraft.banner.mojang.cyan" | "subtitles.entity.iron_golem.hurt" | "selectWorld.loading_list" | "enchantment.improved_exp.night.desc" | "block.minecraft.white_stained_glass" | "item.minecraft.bowl" | "config.jade.plugin_minecraft.harvest_tool.show_unbreakable" | "item.minecraft.bone_meal" | "jade.instrument.banjo" | "jei.key.combo.alt" | "tooltip.irons_spellbooks.modifiers.multihand" | "block.minecraft.cherry_wall_sign" | "mco.configure.world.subscription.timeleft" | "item.irons_spellbooks.cooldown_rune" | "multiplayer.status.no_connection" | "subtitles.block.respawn_anchor.deplete" | "item.irons_spellbooks.ice_staff" | "modernfix.message.reload_config" | "modernfix.option.category.expert_only" | "config.jade.plugin_minecraft.item_storage_extra_msg" | "createWorld.customize.custom.useOceanRuins" | "arguments.objective.readonly" | "commands.forge.tracking.entity.enabled" | "gui.banned.reason.spam_or_advertising" | "commands.team.leave.success.single" | "patchouli.gui.lexicon.progress_meter" | "advancements.end.elytra.title" | "sodium.console.core_shaders_error" | "entity.minecraft.piglin_brute" | "subtitles.entity.wandering_trader.hurt" | "block.minecraft.banner.diagonal_left.cyan" | "jei.key.category.recipe.gui" | "block.minecraft.banner.stripe_bottom.light_blue" | "menu.preparingSpawn" | "createWorld.customize.custom.biomeScaleWeight" | "block.minecraft.end_stone" | "subtitles.entity.horse.armor" | "block.minecraft.potted_white_tulip" | "block.minecraft.warped_door" | "chat.cannotSend" | "mco.download.title" | "modernfix.option.mixin.perf.boost_worker_count" | "item.minecraft.splash_potion.effect.fire_resistance" | "spell.irons_spellbooks.creeper_revenge.guide" | "fml.language.missingversion" | "block.minecraft.banner.half_vertical_right.pink" | "block.minecraft.banner.triangles_bottom.light_gray" | "selectWorld.edit.export_worldgen_settings.success" | "item.minecraft.mourner_pottery_sherd" | "stat.minecraft.damage_dealt" | "createWorld.customize.presets.list" | "block.minecraft.stripped_bamboo_block" | "forge.configgui.disableStairSlabCulling.tooltip" | "item.minecraft.shield.red" | "block.minecraft.quartz_pillar" | "commands.bossbar.get.visible.hidden" | "title.32bit.deprecation.realms.check" | "argument.pos3d.incomplete" | "item.minecraft.diamond_sword" | "death.attack.irons_spellbooks.sonic_boom.item" | "mco.backup.entry.gameMode" | "block.minecraft.oak_planks" | "item.minecraft.amethyst_shard" | "item.irons_spellbooks.autoloader_crossbow.desc" | "jade.instrument.bell" | "subtitles.entity.piglin.celebrate" | "config.jade.plugin_jade.coordinates_extra_msg" | "lanserverproperties.options.online_mode" | "block.minecraft.structure_void" | "tutorial.socialInteractions.title" | "block.minecraft.purple_shulker_box" | "commands.item.source.not_a_container" | "jigsaw_block.pool" | "block.minecraft.potatoes" | "subtitles.entity.camel.step_sand" | "datapackFailure.safeMode" | "block.minecraft.light_blue_bed" | "item.irons_spellbooks.fire_upgrade_orb" | "subtitles.block.sniffer_egg.crack" | "spell.irons_spellbooks.angel_wing.guide" | "tooltip.irons_spellbooks.imbued_tooltip" | "item.modifiers.head" | "death.attack.irons_spellbooks.blood_needles.item" | "options.on.composed" | "advancements.adventure.honey_block_slide.title" | "death.attack.irons_spellbooks.poison_breath" | "commands.worldborder.damage.buffer.success" | "subtitles.entity.player.levelup" | "block.minecraft.glass_pane" | "block.minecraft.banner.diagonal_right.cyan" | "jade.horseStat.speed" | "death.attack.irons_spellbooks.devour" | "subtitles.entity.camel.sit" | "block.minecraft.cut_copper_slab" | "gui.chatReport.report_sent_msg" | "gui.socialInteractions.blocking_hint" | "options.telemetry.button.tooltip" | "death.attack.irons_spellbooks.starfall" | "trim_pattern.minecraft.coast" | "jei.tooltip.config" | "biome.minecraft.warped_forest" | "item.minecraft.splash_potion.effect.slow_falling" | "item.minecraft.book" | "block.minecraft.banner.gradient.brown" | "entity.minecraft.magma_cube" | "patchouli.gui.lexicon.progress_tooltip.secret" | "block.minecraft.banner.curly_border.gray" | "options.particles.all" | "block.minecraft.black_shulker_box" | "subtitles.block.amethyst_block.chime" | "commands.curios.clear.success" | "advancements.nether.root.description" | "death.attack.irons_spellbooks.black_hole" | "block.minecraft.banner.straight_cross.purple" | "multiplayer.texturePrompt.serverPrompt" | "key.forward" | "item.irons_spellbooks.casters_tea" | "mco.template.trailer.tooltip" | "gamerule.showDeathMessages" | "affix.irons_spellbooks:spellbook/attribute/evocation_spell_power.suffix" | "commands.enchant.success.single" | "tooltip.titanium.facing_handler.pull" | "advancements.end.find_end_city.title" | "item.minecraft.bamboo_chest_raft" | "block.minecraft.banner.square_top_left.blue" | "spell.irons_spellbooks.spider_aspect.guide" | "block.minecraft.banner.stripe_center.yellow" | "mco.configure.world.invite.profile.name" | "entity.minecraft.evoker" | "item.minecraft.firework_star.cyan" | "block.minecraft.brick_slab" | "mco.errorMessage.generic" | "subtitles.entity.slime.hurt" | "advancements.adventure.throw_trident.title" | "block.minecraft.deepslate_emerald_ore" | "commands.jfr.stopped" | "block.minecraft.crimson_wall_sign" | "block.minecraft.bamboo_slab" | "gamerule.reducedDebugInfo.description" | "item.minecraft.apple" | "lanserverproperties.gui.always_offline.message" | "block.minecraft.brown_wool" | "subtitles.entity.ghast.ambient" | "arguments.function.tag.unknown" | "subtitles.entity.ravager.stunned" | "fml.menu.accessdenied.message" | "entity.minecraft.turtle" | "subtitles.entity.bee.loop" | "commands.datapack.list.available.success" | "advancements.story.cure_zombie_villager.title" | "item.minecraft.bone" | "entity.irons_spellbooks.priest" | "jecharacters.chat.start" | "wood_type.minecraft.bamboo" | "advancements.husbandry.netherite_hoe.description" | "selectWorld.edit.save" | "jade.instrument.bit" | "argument.angle.incomplete" | "effect.minecraft.speed" | "subtitles.entity.tadpole.death" | "item.irons_spellbooks.blood_vial" | "block.minecraft.polished_andesite" | "modernfix.option.mixin.perf.faster_font_loading" | "text.cloth-config.config" | "subtitles.block.sweet_berry_bush.pick_berries" | "time.bookshelf.month.august" | "fml.messages.version.restriction.any" | "chat.editBox" | "gui.chatReport.read_info" | "item.minecraft.lapis_lazuli" | "tooltip.titanium.facing_handler.right" | "subtitles.entity.piglin.ambient" | "multiplayer.status.version.narration" | "multiplayer.disconnect.too_many_pending_chats" | "block.minecraft.banner.diagonal_right.orange" | "mco.configure.world.buttons.switchminigame" | "entity.irons_spellbooks.fire_breath_projectile" | "biome.minecraft.small_end_islands" | "block.minecraft.banner.base.green" | "school.irons_spellbooks.ice" | "commands.experience.add.levels.success.single" | "subtitles.entity.guardian.attack" | "commands.effect.clear.specific.success.single" | "item.irons_spellbooks.archevoker_log.header" | "block.minecraft.banner.square_top_left.lime" | "stat.minecraft.walk_one_cm" | "jei.tooltip.recipe.sort.bookmarks.first.enabled" | "outOfMemory.title" | "death.attack.irons_spellbooks.sculk_tentacles.item" | "subtitles.entity.generic.death" | "block.minecraft.banner.square_bottom_left.gray" | "commands.scoreboard.objectives.display.set" | "advancements.nether.explore_nether.description" | "itemGroup.tools" | "commands.bossbar.set.visibility.unchanged.visible" | "pack.source.builtin" | "jade.instrument.skeleton" | "commands.perf.reportFailed" | "item.minecraft.tipped_arrow.effect.mana" | "block.minecraft.cyan_stained_glass" | "narrator.joining" | "item.minecraft.bee_spawn_egg" | "commands.place.structure.success" | "jei.chat.error.no.cheat.permission.1" | "enchantment.minecraft.luck_of_the_sea" | "modernfix.option.mixin.perf.blast_search_trees" | "ui.irons_spellbooks.reduced_damage" | "enchantment.improved_exp.naturalfertilizer.desc" | "item.minecraft.fox_spawn_egg" | "entity.irons_spellbooks.creeper_head_projectile" | "commands.reload.success" | "mco.connect.connecting" | "tooltip.irons_spellbooks.passive_ability" | "item.geckolib.jack_in_the_box.opening" | "block.minecraft.spruce_slab" | "sodium.options.entity_shadows.tooltip" | "painting.minecraft.bust.title" | "subtitles.entity.boat.paddle_land" | "painting.minecraft.wind.title" | "pack.dropConfirm" | "block.minecraft.banner.border.magenta" | "item.irons_spellbooks.frosted_helve" | "gui.chatReport.discard.content" | "block.minecraft.banner.creeper.red" | "entity.minecraft.tropical_fish" | "options.autoJump" | "event.minecraft.raid.raiders_remaining" | "subtitles.entity.piglin.admiring_item" | "block.minecraft.oak_trapdoor" | "options.framerate" | "block.minecraft.glass" | "subtitles.entity.elder_guardian.hurt" | "gui.chatReport.title" | "container.hopper" | "entity.minecraft.bee" | "block.minecraft.budding_amethyst" | "jei.tooltip.recipe.sort.bookmarks.first.disabled" | "arguments.item.tag.unknown" | "block.minecraft.white_bed" | "createWorld.customize.custom.presets.title" | "commands.debug.function.success.single" | "subtitles.entity.pillager.ambient" | "block.minecraft.banner.rhombus.red" | "mco.notification.visitUrl.buttonText.default" | "stat.minecraft.damage_dealt_resisted" | "createWorld.customize.custom.defaults" | "entity.minecraft.item_frame" | "block.minecraft.brain_coral_block" | "item.minecraft.tropical_fish" | "stat.minecraft.mob_kills" | "death.attack.fall.player" | "mco.download.percent" | "modernfix.option.category.expert_only.description" | "options.telemetry.state.minimal" | "gui.socialInteractions.status_blocked_offline" | "death.attack.irons_spellbooks.poison_breath.item" | "death.attack.irons_spellbooks.lob_creeper.item" | "block.minecraft.banner.piglin.pink" | "block.minecraft.banner.stripe_right.cyan" | "accessibility.onboarding.screen.title" | "subtitles.entity.villager.work_toolsmith" | "config.jade.plugin_minecraft.furnace" | "school.irons_spellbooks.nature" | "item.irons_spellbooks.cultist_chestplate" | "block.minecraft.banner.border.white" | "item.minecraft.tipped_arrow.effect.harming" | "stat.minecraft.animals_bred" | "block.minecraft.dark_oak_slab" | "createWorld.customize.custom.riverSize" | "subtitles.block.respawn_anchor.ambient" | "block.minecraft.banner.triangle_bottom.light_blue" | "config.jade.display_item_extra_msg" | "block.minecraft.cartography_table" | "itemGroup.consumables" | "permissions.requires.entity" | "subtitles.block.bubble_column.whirlpool_ambient" | "subtitles.entity.dolphin.ambient" | "subtitles.entity.guardian.death" | "jei.chat.error.no.cheat.permission.enabled" | "entity.minecraft.bat" | "rarity.irons_spellbooks.common" | "item.irons_spellbooks.netherward_tincture" | "block.minecraft.stripped_birch_log" | "text.cloth-config.list.remove" | "subtitles.entity.dolphin.death" | "death.attack.thrown.item" | "commands.enchant.success.multiple" | "sodium.options.use_compact_vertex_format.tooltip" | "commands.advancement.grant.many.to.one.failure" | "text.cloth-config.list.add" | "effect.irons_spellbooks.angel_wings" | "subtitles.entity.llama.spit" | "options.viewBobbing" | "patchouli.gui.lexicon.button.history" | "enchantment.minecraft.flame" | "enchantment.shieldsplus.lightweight.desc" | "commands.advancement.revoke.many.to.many.failure" | "advancements.adventure.hero_of_the_village.title" | "advancements.story.deflect_arrow.description" | "tooltip.titanium.facing_handler.push" | "tooltip.jade.state_on" | "block.minecraft.pink_bed" | "debug.creative_spectator.help" | "modernfix.config.done_restart" | "block.minecraft.glow_lichen" | "menu.options" | "text.cloth-config.error.color.invalid_green" | "item.irons_spellbooks.necronomicon_spell_book" | "block.minecraft.mangrove_hanging_sign" | "stat_type.minecraft.killed.none" | "entity.minecraft.villager.butcher" | "subtitles.entity.panda.death" | "block.minecraft.banner.bricks.black" | "item.irons_spellbooks.frozen_bone.guide" | "tooltip.titanium.facing_handler.bottom" | "block.minecraft.banner.half_horizontal_bottom.light_gray" | "block.minecraft.raw_copper_block" | "mco.configure.world.subscription.recurring.daysleft" | "tooltip.titanium.facing_handler.none" | "block.minecraft.packed_mud" | "entity.minecraft.mule" | "gamerule.doMobSpawning.description" | "patchouli.subtitle.book_flip" | "block.minecraft.gray_shulker_box" | "block.minecraft.skeleton_skull" | "gui.chatReport.more_comments" | "subtitles.block.shulker_box.close" | "team.visibility.hideForOwnTeam" | "ui.irons_spellbooks.slowed" | "options.customizeTitle" | "entity.irons_spellbooks.target_area" | "selectWorld.data_read" | "gui.stats" | "spell.irons_spellbooks.cone_of_cold.guide" | "gui.abuseReport.reason.description" | "item.minecraft.golden_pickaxe" | "spell.irons_spellbooks.firebolt.guide" | "block.minecraft.banner.stripe_downright.yellow" | "block.minecraft.banner.stripe_left.pink" | "entity.minecraft.chicken" | "subtitles.entity.wolf.death" | "potion.withDuration" | "argument.literal.incorrect" | "block.minecraft.lilac" | "advancements.irons_spellbooks.make_arcane_anvil.description" | "gamerule.doLimitedCrafting" | "mco.upload.done" | "block.minecraft.banner.base.black" | "item.minecraft.tipped_arrow.effect.leaping" | "item.minecraft.burn_pottery_sherd" | "item.minecraft.snort_pottery_sherd" | "mco.connect.success" | "block.minecraft.banner.triangles_top.purple" | "commands.bossbar.get.visible.visible" | "block.minecraft.oxidized_cut_copper_slab" | "commands.data.entity.query" | "block.minecraft.bricks" | "block.minecraft.warped_nylium" | "stats.tooltip.type.statistic" | "config.jade.plugin_jade.registry_name_extra_msg" | "block.minecraft.diorite_slab" | "item.patchouli:test_completion.landing" | "block.minecraft.banner.border.black" | "config.jei.advanced.modNameFormat" | "block.minecraft.banner.square_bottom_right.brown" | "block.minecraft.banner.triangles_bottom.brown" | "mco.account.privacy.info" | "menu.respawning" | "container.crafting" | "pack.incompatible" | "spell.irons_spellbooks.sacrifice.guide" | "debug.pause_focus.on" | "tutorial.open_inventory.description" | "block.minecraft.dark_oak_planks" | "argument.pos.missing.int" | "item.minecraft.pig_spawn_egg" | "item.minecraft.skull_pottery_shard" | "advancements.irons_spellbooks.make_wayward_compass.title" | "advancements.end.root.description" | "block.minecraft.melon_stem" | "argument.long.low" | "color.minecraft.yellow" | "block.minecraft.banner.half_horizontal.light_gray" | "multiplayer.status.unknown" | "time.bookshelf.month.may" | "modernfix.option.mixin.perf.dynamic_resources.ae2" | "item.minecraft.iron_pickaxe" | "forge.experimentalsettings.tooltip" | "block.minecraft.mossy_cobblestone_stairs" | "config.jei.valid" | "block.minecraft.cobbled_deepslate_wall" | "enchantment.minecraft.fire_aspect" | "commands.whitelist.alreadyOn" | "subtitles.entity.iron_golem.attack" | "commands.bossbar.create.failed" | "item.irons_spellbooks.epic_ink" | "config.jade.plugin_minecraft.crop_progress" | "mco.configure.world.spawnMonsters" | "disconnect.loginFailedInfo" | "subtitles.entity.villager.work_armorer" | "enchantment.improved_exp.easy_movement.desc" | "multiplayer.requiredTexturePrompt.disconnect" | "block.minecraft.potted_orange_tulip" | "subtitles.entity.shulker_bullet.hurt" | "block.minecraft.bubble_coral_fan" | "block.minecraft.deepslate_coal_ore" | "block.minecraft.dead_fire_coral" | "block.minecraft.banner.gradient.light_gray" | "tutorial.socialInteractions.description" | "block.minecraft.brain_coral_fan" | "__support_improved_exp" | "attribute.irons_spellbooks.spell_power" | "item.irons_spellbooks.emerald_stoneplate_ring" | "argument.entity.notfound.player" | "sleep.skipping_night" | "tooltip.titanium.unlocks" | "telemetry.property.server_modded.title" | "entity.minecraft.zombie_villager" | "container.enchant.lapis.many" | "item.minecraft.wandering_trader_spawn_egg" | "subtitles.entity.parrot.imitate.witch" | "multiplayer.disconnect.missing_tags" | "options.chat.height.unfocused" | "subtitles.entity.stray.ambient" | "argument.block.property.novalue" | "block.minecraft.bed.not_safe" | "commands.kill.success.single" | "options.chat.links" | "block.minecraft.banner.straight_cross.light_blue" | "block.minecraft.banner.diagonal_up_right.gray" | "flat_world_preset.minecraft.desert" | "commands.place.template.failed" | "fml.modmismatchscreen.additional" | "item.irons_spellbooks.iron_spell_book" | "advancements.end.find_end_city.description" | "commands.drop.success.multiple" | "item.minecraft.cooked_salmon" | "narrator.select" | "selectWorld.gameMode.spectator.info" | "config.jade.general" | "block.minecraft.banner.globe.brown" | "biome.minecraft.end_barrens" | "config.jade.boss_bar_overlap_push_down" | "subtitles.block.anvil.land" | "block.minecraft.banner.diagonal_up_left.pink" | "item.minecraft.iron_axe" | "block.minecraft.banner.border.green" | "mco.selectServer.openserver" | "item.minecraft.archer_pottery_sherd" | "block.minecraft.iron_door" | "commands.team.option.collisionRule.unchanged" | "options.vsync" | "gamerule.commandModificationBlockLimit.description" | "block.minecraft.piston" | "enchantment.improved_exp.jumper.desc" | "fml.menu.mods.z_to_a" | "config.jade.display_mode_hold_key" | "patchouli.gui.lexicon.structure_complete" | "block.minecraft.mangrove_fence_gate" | "narration.button.usage.hovered" | "container.enchant.level.requirement" | "gamerule.forgiveDeadPlayers.description" | "subtitles.entity.piglin_brute.angry" | "jade.potion" | "commands.attribute.failed.no_modifier" | "gamerule.doTileDrops" | "painting.minecraft.skull_and_roses.title" | "entity.minecraft.llama_spit" | "structure_block.show_air" | "item.minecraft.lingering_potion.effect.weakness" | "subtitles.block.iron_trapdoor.open" | "death.attack.irons_spellbooks.scorch" | "options.accessibility.text_background.chat" | "spell.irons_spellbooks.gluttony" | "item.irons_spellbooks.cryomancer_leggings" | "key.jei.maxTransferRecipeBookmark" | "fml.menu.mods.info.securejardisabled" | "chat.type.text.narrate" | "tetra.stats.irons_spellbooks:freeze.tooltip_short" | "block.minecraft.grass_block" | "narration.tab_navigation.usage" | "commands.enchant.failed.level" | "options.graphics.fabulous" | "chat.link.confirmTrusted" | "text.cloth-config.quit_config" | "block.minecraft.brown_bed" | "subtitles.entity.dolphin.ambient_water" | "translation.test.complex" | "block.minecraft.banner.square_top_right.red" | "commands.setidletimeout.success" | "ui.irons_spellbooks.cast_error_cooldown" | "title.multiplayer.disabled.banned.temporary" | "commands.team.option.friendlyfire.enabled" | "item.minecraft.lodestone_compass" | "block.minecraft.banner.gradient_up.white" | "block.minecraft.banner.small_stripes.yellow" | "painting.minecraft.graham.title" | "subtitles.entity.witch.drink" | "commands.banip.failed" | "narrator.ready_to_play" | "block.minecraft.banner.bricks.green" | "key.right" | "subtitles.entity.villager.yes" | "gui.multiLineEditBox.character_limit" | "block.minecraft.infested_chiseled_stone_bricks" | "spell.irons_spellbooks.void_tentacles" | "advancements.adventure.totem_of_undying.description" | "options.darknessEffectScale" | "enchantment.minecraft.sweeping.desc" | "death.attack.lava" | "block.minecraft.jungle_wall_hanging_sign" | "gamerule.drowningDamage" | "block.minecraft.banner.triangle_top.cyan" | "entity.irons_spellbooks.black_hole" | "subtitles.entity.zombie.infect" | "ui.irons_spellbooks.inscription_table_rarity_error" | "subtitles.entity.generic.splash" | "event.minecraft.raid.victory" | "item.minecraft.firework_star.red" | "death.attack.fireball.item" | "key.keyboard.keypad.equal" | "subtitles.block.pressure_plate.click" | "subtitles.entity.husk.ambient" | "options.difficulty" | "argument.uuid.invalid" | "death.attack.inFire" | "entity.irons_spellbooks.apothecarist" | "config.jei.advanced.addBookmarksToFront" | "commands.scoreboard.players.set.success.single" | "entity.minecraft.skeleton" | "patchouli.gui.lexicon.loading_error" | "item.minecraft.blaze_spawn_egg" | "multiplayerWarning.message" | "time.bookshelf.day.thursday" | "itemGroup.resources" | "effect.irons_spellbooks.blight.description" | "block.minecraft.banner.triangle_bottom.black" | "commands.advancement.grant.criterion.to.one.success" | "death.attack.irons_spellbooks.flaming_strike" | "jei.key.combo.shift" | "block.minecraft.warped_slab" | "enchantment.improved_exp.drill.desc" | "config.jade.item_mod_name_extra_msg" | "item.modifiers.offhand" | "multiplayer.status.incompatible" | "item.irons_spellbooks.hogskin" | "death.attack.irons_spellbooks.ascension.item" | "commands.drop.no_loot_table" | "item.dyed" | "subtitles.entity.wandering_trader.yes" | "jei.key.shift" | "entity.minecraft.tnt_minecart" | "item.irons_spellbooks.amethyst_rapier" | "key.mouse.left" | "spell.irons_spellbooks.magic_arrow" | "item.geckolib.gecko_armor_helmet" | "block.minecraft.banner.stripe_middle.orange" | "mco.configure.world.spawnAnimals" | "affix.irons_spellbooks:spellbook/attribute/fire_spell_power.suffix" | "block.minecraft.magma_block" | "modernfix.option.disabled" | "block.minecraft.lime_candle_cake" | "item.apotheosis.gem.irons_spellbooks:spell_resist" | "commands.forge.gen.complete" | "fml.modloading.missinglicense" | "item.minecraft.splash_potion.effect.awkward" | "block.minecraft.decorated_pot" | "block.minecraft.spruce_door" | "tutorial.find_tree.title" | "modernfix.option.mixin.perf.deduplicate_climate_parameters" | "block.minecraft.pumpkin" | "subtitles.entity.mule.death" | "subtitles.block.candle.crackle" | "commands.ride.already_riding" | "effect.irons_spellbooks.raise_dead_timer.description" | "block.minecraft.banner.circle.pink" | "subtitles.entity.chicken.egg" | "painting.minecraft.creebet.author" | "block.minecraft.sponge" | "options.online.title" | "subtitles.entity.zoglin.death" | "block.minecraft.light_gray_candle" | "forge.configgui.logCascadingWorldGeneration" | "advancements.nether.create_beacon.description" | "subtitles.entity.warden.death" | "spell.irons_spellbooks.greater_heal" | "options.sounds" | "stat.minecraft.player_kills" | "telemetry.property.advancement_id.title" | "item.minecraft.golden_boots" | "key.keyboard.delete" | "spell.irons_spellbooks.healing_circle.guide" | "commands.advancement.revoke.many.to.many.success" | "gui.chatSelection.selected" | "advancements.nether.all_effects.title" | "advancements.irons_spellbooks.spell_book_equip.title" | "item.minecraft.birch_chest_boat" | "config.jei.interface.overlayEnabled" | "key.jei.previousSearch" | "subtitles.entity.evoker.prepare_summon" | "gui.jei.category.blasting" | "block.minecraft.bamboo_door" | "block.minecraft.banner.stripe_downright.light_blue" | "config.jade.plugin_minecraft.breaking_progress" | "menu.working" | "advMode.mode.auto" | "narrator.controls.reset" | "jei.tooltip.error.recipe.transfer.disabled" | "gui.socialInteractions.tooltip.report.not_reportable" | "mco.template.title.minigame" | "config.jade.display_item" | "dataPack.validation.working" | "effect.irons_spellbooks.thunderstorm.description" | "argument.entity.options.y.description" | "block.minecraft.cocoa" | "advancements.adventure.sleep_in_bed.description" | "enchantment.improved_exp.autosmelt.desc" | "entity.irons_spellbooks.magma_ball" | "spell.irons_spellbooks.heartstop.guide" | "block.minecraft.banner.cross.purple" | "commands.curios.clearAll.success" | "gui.hours" | "config.jade.tts_mode_toggle" | "block.minecraft.andesite_stairs" | "item.minecraft.carrot" | "patchouli.gui.lexicon.added_by" | "block.minecraft.banner.skull.orange" | "block.minecraft.red_sand" | "death.attack.witherSkull.item" | "affix.irons_spellbooks:armor/attribute/spell_power.suffix" | "block.minecraft.banner.half_horizontal.gray" | "painting.minecraft.wasteland.title" | "advancements.nether.return_to_sender.description" | "gamerule.doWardenSpawning" | "item.minecraft.iron_ingot" | "painting.minecraft.sea.author" | "subtitles.entity.cat.death" | "config.jade.plugin_create.goggles.detailed" | "item.minecraft.snowball" | "item.irons_spellbooks.shadowwalker_chestplate" | "block.minecraft.banner.curly_border.yellow" | "item.irons_spellbooks.fireward_ring.desc" | "subtitles.entity.illusioner.prepare_blindness" | "jade.fluid2" | "disconnect.endOfStream" | "rarity.irons_spellbooks.legendary" | "jigsaw_block.levels" | "commands.locate.structure.not_found" | "block.minecraft.wet_sponge" | "stat.minecraft.open_chest" | "container.repair.cost" | "subtitles.entity.witch.death" | "block.minecraft.banner.triangles_top.light_blue" | "item.minecraft.music_disc_mall" | "subtitles.entity.warden.ambient" | "block.minecraft.quartz_stairs" | "argument.resource_tag.not_found" | "commands.advancement.grant.many.to.one.success" | "attribute.irons_spellbooks.evocation_spell_power" | "connect.joining" | "tooltip.irons_spellbooks.can_be_imbued" | "block.minecraft.banner.square_top_left.purple" | "item.minecraft.enchanted_book" | "pack.selected.title" | "commands.team.option.name.success" | "selectWorld.gameMode.adventure.line2" | "item.minecraft.oak_boat" | "selectWorld.gameMode.adventure.line1" | "key.mount_jump" | "clear.failed.multiple" | "selectWorld.warning.deprecated.title" | "key.left" | "block.minecraft.banner.triangles_top.magenta" | "entity.minecraft.spawner_minecart" | "item.patchouli:intro_book.landing" | "item.minecraft.stone_sword" | "block.minecraft.white_shulker_box" | "jei.alias.panda.spawn.egg" | "options.off.composed" | "advancements.husbandry.breed_all_animals.title" | "entity.irons_spellbooks.chain_lightning" | "block.minecraft.flowering_azalea" | "block.minecraft.chiseled_nether_bricks" | "item.irons_spellbooks.uncommon_ink" | "key.jei.clearSearchBar" | "block.minecraft.melon" | "tetra.material.irons_spellbooks_fire_rune_socket" | "block.minecraft.acacia_planks" | "item.minecraft.music_disc_stal" | "entity.minecraft.villager.mason" | "modernfix.option.mixin.bugfix.edge_chunk_not_saved" | "block.minecraft.banner.globe.light_gray" | "item.minecraft.flower_banner_pattern" | "mco.configure.world.subscription.extend" | "container.repair" | "connect.negotiating" | "filled_map.monument" | "narration.button.usage.focused" | "time.bookshelf.day.wednesday" | "block.minecraft.chipped_anvil" | "affix.irons_spellbooks:spellbook/attribute/ice_spell_power" | "options.category" | "argument.entity.options.type.invalid" | "item.irons_spellbooks.pyromancer_spawn_egg" | "options.chat.scale" | "config.jade.plugin_minecraft.item_storage.normal_amount_desc" | "biome.minecraft.end_midlands" | "block.minecraft.infested_deepslate" | "affix.irons_spellbooks:spellbook/attribute/ice_spell_power.suffix" | "mco.reset.world.experience" | "subtitles.entity.warden.listening_angry" | "patchouli.gui.lexicon.chapters" | "effect.minecraft.bad_omen" | "optimizeWorld.stage.finished" | "ui.irons_spellbooks.cast_error_spectral_hammer" | "subtitles.entity.experience_orb.pickup" | "gui.chatReport.select_reason" | "spell.irons_spellbooks.fang_ward.guide" | "subtitles.entity.ender_pearl.throw" | "commands.experience.query.levels" | "debug.inspect.client.entity" | "mco.brokenworld.minigame.title" | "enchantment.improved_exp.bakingpowder.desc" | "enchantment.improved_exp.levitation.desc" | "leaves_type.minecraft.cherry" | "subtitles.entity.turtle.hurt_baby" | "text.cloth-config.error.color.no_hash" | "block.minecraft.stripped_mangrove_log" | "block.minecraft.banner.circle.yellow" | "block.minecraft.banner.triangle_bottom.green" | "editGamerule.default" | "gui.jade.save_and_quit" | "item.minecraft.firework_star.fade_to" | "death.attack.irons_spellbooks.fireball" | "item.minecraft.music_disc_cat" | "block.minecraft.banner.gradient_up.orange" | "block.minecraft.black_stained_glass_pane" | "subtitles.entity.ghast.death" | "attribute.irons_spellbooks.max_mana" | "subtitles.entity.cow.ambient" | "effect.irons_spellbooks.vigor" | "block.minecraft.oak_wood" | "block.minecraft.powered_rail" | "datapackFailure.safeMode.failed.title" | "argument.dimension.invalid" | "commands.curios.drop.success" | "effect.irons_spellbooks.summon_horse_timer" | "debug.dump_dynamic_textures" | "argument.entity.selector.self" | "commands.team.option.prefix.success" | "item.patchouli:intro_book.subtitle" | "fml.menu.mods.a_to_z" | "entity.minecraft.husk" | "fml.menu.mods.title" | "commands.worldborder.center.success" | "block.minecraft.banner.half_vertical_right.yellow" | "tetra.material.irons_spellbooks_ender_rune_socket" | "block.minecraft.banner.mojang.light_blue" | "effect.irons_spellbooks.spider_aspect" | "title.multiplayer.disabled" | "biome.minecraft.windswept_gravelly_hills" | "block.minecraft.green_shulker_box" | "entity.minecraft.wither_skeleton" | "selectWorld.seedInfo" | "jade.theme.jade.waila" | "commands.bossbar.set.name.success" | "argument.integer.big" | "modernfix.option.mixin.perf.use_integrated_resources" | "commands.reload.failure" | "argument.bookshelf.unknown_value" | "death.attack.irons_spellbooks.chain_lightning" | "item.minecraft.dark_oak_chest_boat" | "block.minecraft.petrified_oak_slab" | "block.minecraft.banner.square_bottom_left.light_gray" | "item.irons_spellbooks.arcane_salvage" | "selectWorld.gameMode.adventure" | "effect.minecraft.levitation" | "spell.irons_spellbooks.dragon_breath" | "advancements.adventure.arbalistic.description" | "subtitles.item.honeycomb.wax_on" | "subtitles.entity.item.break" | "subtitles.entity.tadpole.grow_up" | "wood_type.minecraft.oak" | "item.minecraft.chest_minecart" | "commands.defaultgamemode.success" | "block.minecraft.banner.half_vertical.pink" | "argument.component.invalid" | "block.minecraft.zombie_head" | "commands.tag.remove.success.multiple" | "block.minecraft.warped_roots" | "telemetry.property.client_modded.title" | "commands.recipe.take.success.single" | "biome.minecraft.ocean" | "block.minecraft.piglin_head" | "options.attack.hotbar" | "sodium.options.translucent_face_sorting.tooltip" | "block.minecraft.banner.bricks.white" | "commands.message.display.outgoing" | "effect.minecraft.weakness" | "arguments.swizzle.invalid" | "menu.multiplayer" | "spell.irons_spellbooks.counterspell.guide" | "mco.news" | "subtitles.entity.arrow.hit" | "item.minecraft.music_disc_relic.desc" | "options.prioritizeChunkUpdates.nearby" | "entity.irons_spellbooks.magic_missile_projectile" | "tetra.material.irons_spellbooks_arcane_cloth" | "advancements.adventure.fall_from_world_height.title" | "block.minecraft.banner.gradient.yellow" | "enchantment.minecraft.soul_speed" | "subtitles.entity.warden.dig" | "block.minecraft.sand" | "item.minecraft.zombified_piglin_spawn_egg" | "advancements.adventure.read_power_from_chiseled_bookshelf.description" | "selectWorld.versionUnknown" | "spell.irons_spellbooks.guiding_bolt.guide" | "subtitles.block.sniffer_egg.hatch" | "biome.minecraft.bamboo_jungle" | "structure_block.integrity" | "block.minecraft.stripped_oak_log" | "selectWorld.import_worldgen_settings.select_file" | "debug.show_hitboxes.off" | "block.minecraft.smooth_quartz_stairs" | "death.attack.irons_spellbooks.sacrifice.item" | "block.minecraft.ender_chest" | "commands.data.get.invalid" | "options.mouseWheelSensitivity" | "argument.double.low" | "subtitles.block.end_portal_frame.fill" | "subtitles.entity.puffer_fish.flop" | "tooltip.irons_spellbooks.mana_cost" | "rarity.irons_spellbooks.rare" | "modernfix.option.mixin.perf.state_definition_construct" | "block.minecraft.bamboo_mosaic_slab" | "config.jade.plugin_deepresonance.generator_part" | "dataPack.update_1_20.description" | "item.irons_spellbooks.pumpkin_boots" | "block.minecraft.azalea_leaves" | "effect.duration.infinite" | "wood_type.minecraft.birch" | "structure_block.size_success" | "item.minecraft.potion.effect.poison" | "block.minecraft.banner.bricks.blue" | "advancements.husbandry.safely_harvest_honey.title" | "mco.configure.world.restore.download.question.line2" | "mco.configure.world.restore.download.question.line1" | "item.apotheosis.gem.irons_spellbooks:nature" | "item.irons_spellbooks.handwritten_invoice" | "forge.step_height" | "options.multiplayer.title" | "item.irons_spellbooks.dragonskin.guide" | "mco.create.world.wait" | "key.keyboard.right.alt" | "stat.minecraft.damage_absorbed" | "translation.test.none" | "gamerule.doMobSpawning" | "commands.op.failed" | "selectWorld.gameMode.hardcore.line2" | "selectWorld.gameMode.hardcore.line1" | "block.minecraft.acacia_slab" | "commands.attribute.modifier.remove.success" | "item.minecraft.tipped_arrow.effect.slowness" | "subtitles.entity.dolphin.jump" | "item.minecraft.ender_pearl" | "config.jade.display_fluids_source_only" | "subtitles.entity.piglin_brute.hurt" | "painting.minecraft.match.title" | "tooltip.irons_spellbooks.spellbook_spell_count" | "ui.irons_spellbooks.cooldown" | "multiplayer.status.player_count.narration" | "block.minecraft.banner.triangles_bottom.yellow" | "text.cloth-config.disabled_tooltip" | "subtitles.item.bucket.fill_fish" | "item.minecraft.music_disc_otherside.desc" | "block.minecraft.banner.base.light_blue" | "mco.configure.world.buttons.delete" | "tooltip.titanium.redstone.once" | "subtitles.entity.fox.sniff" | "jei.tooltip.error.recipe.transfer.inventory.full" | "item.minecraft.music_disc_5.desc" | "selectWorld.incompatible_series" | "soundCategory.voice" | "attribute.name.generic.knockback_resistance" | "subtitles.entity.rabbit.attack" | "item.irons_spellbooks.lightning_bottle.guide" | "entity.irons_spellbooks.cryomancer" | "createWorld.customize.custom.lowerLimitScale" | "lanserverproperties.gui.port" | "subtitles.entity.wolf.shake" | "advancements.story.root.description" | "commands.stop.stopping" | "titanium.rewards.granted_success" | "biome.minecraft.old_growth_spruce_taiga" | "multiplayer.texturePrompt.failure.line1" | "enchantment.minecraft.feather_falling.desc" | "tetra.material.frosted_helve.prefix" | "multiplayer.texturePrompt.failure.line2" | "advancements.adventure.trade_at_world_height.title" | "gui.abuseReport.reason.self_harm_or_suicide" | "block.minecraft.light_gray_concrete_powder" | "item.minecraft.splash_potion.effect.mundane" | "block.minecraft.banner.gradient.pink" | "key.jade.show_overlay" | "block.minecraft.activator_rail" | "jei.tooltip.cheat.mode.button.enabled" | "modernfix.option.mixin.perf.compact_mojang_registries" | "commands.list.players" | "createWorld.customize.custom.biomeDepthWeight" | "multiplayer.status.motd.narration" | "config.jade.overlay_alpha" | "block.minecraft.red_sandstone_wall" | "item.minecraft.diamond_axe" | "item.irons_spellbooks.silver_ring" | "argument.pos.unloaded" | "block.minecraft.mangrove_planks" | "commands.scoreboard.players.list.success" | "book.byAuthor" | "options.percent_value" | "advancements.nether.all_potions.description" | "item.minecraft.diamond_helmet" | "sodium.options.animate_only_visible_textures.tooltip" | "item.minecraft.fire_charge" | "subtitles.entity.parrot.imitate.illusioner" | "entity.irons_spellbooks.acid_orb" | "enchantment.improved_exp.collector.desc" | "item.irons_spellbooks.pyromancer_helmet" | "subtitles.item.book.put" | "gui.jade.no_results" | "subtitles.entity.zombified_piglin.angry" | "jei.tooltip.error.recipe.transfer.unknown" | "forge.configgui.clumpingThreshold" | "item.irons_spellbooks.netherward_tincture.desc" | "block.minecraft.birch_leaves" | "tetra.material.irons_spellbooks_cooldown_rune_socket.prefix" | "block.minecraft.banner.square_bottom_right.pink" | "item.minecraft.diamond_pickaxe" | "block.minecraft.sea_pickle" | "entity.minecraft.sheep" | "enchantment.minecraft.flame.desc" | "block.minecraft.dark_oak_door" | "subtitles.entity.player.hurt_drown" | "block.minecraft.light_gray_carpet" | "jei.tooltip.bookmarks.tooltips.transfer.max.usage" | "fml.loadingerrorscreen.errorheader" | "selectWorld.delete" | "subtitles.entity.item.pickup" | "mco.terms.buttons.disagree" | "patchouli.gui.lexicon.toast" | "commands.irons_spellbooks.create_imbued_sword.failed" | "biome.minecraft.snowy_plains" | "resourcepack.progress" | "block.minecraft.light_blue_wool" | "tetra.material.irons_spellbooks_frozen_bone" | "item.minecraft.netherite_hoe" | "subtitles.entity.player.hurt_on_fire" | "options.modelPart.cape" | "lanserverproperties.options.online_mode.on.message" | "fml.menu.accessdenied.title" | "fml.menu.mods.info.childmods" | "enchantment.minecraft.soul_speed.desc" | "config.jade.display_mode_lite_desc.fabric" | "key.jei.closeRecipeGui" | "commands.whitelist.disabled" | "options.generic_value" | "subtitles.entity.panda.bite" | "enchantment.grapplemod.doublejumpenchantment.desc" | "block.minecraft.banner.square_bottom_right.yellow" | "subtitles.block.portal.ambient" | "jade.distance1" | "subtitles.entity.parrot.death" | "jade.distance2" | "block.minecraft.trapped_chest" | "block.minecraft.banner.triangles_top.gray" | "subtitles.entity.illusioner.ambient" | "commands.whitelist.reloaded" | "block.minecraft.mud_bricks" | "enchantment.dungeonsenchantments.leeching.desc" | "commands.data.merge.failed" | "subtitles.entity.axolotl.attack" | "block.minecraft.potted_warped_fungus" | "biome.minecraft.river" | "createWorld.customize.custom.stretchY" | "subtitles.block.conduit.ambient" | "subtitles.item.axe.strip" | "spell.irons_spellbooks.raise_dead.guide" | "subtitles.block.beehive.drip" | "subtitles.entity.bat.ambient" | "commands.tag.add.success.multiple" | "entity.minecraft.spectral_arrow" | "selectWorld.deleteQuestion" | "block.minecraft.cherry_pressure_plate" | "selectWorld.edit.export_worldgen_settings.failure" | "createWorld.customize.custom.depthNoiseScaleZ" | "item.minecraft.netherite_pickaxe" | "block.minecraft.mangrove_wood" | "item.minecraft.husk_spawn_egg" | "commands.recipe.give.success.single" | "config.jade.boss_bar_overlap_no_operation" | "subtitles.block.generic.footsteps" | "fml.menu.mods.info.nochildmods" | "block.minecraft.mangrove_wall_hanging_sign" | "spell.irons_spellbooks.sonic_boom.guide" | "commands.attribute.modifier.add.success" | "block.minecraft.orange_tulip" | "item.minecraft.disc_fragment_5" | "commands.title.show.actionbar.multiple" | "block.minecraft.banner.stripe_bottom.red" | "block.minecraft.netherite_block" | "spell.irons_spellbooks.invisibility.guide" | "commands.debug.started" | "block.minecraft.infested_cracked_stone_bricks" | "filled_map.unknown" | "death.attack.irons_spellbooks.magic_arrow.item" | "item.minecraft.tipped_arrow.effect.thick" | "subtitles.entity.guardian.ambient" | "commands.team.list.teams.empty" | "enchantment.dungeonsenchantments.radiance_shot.desc" | "item.minecraft.goat_spawn_egg" | "moon.phase.waning.gibbous" | "block.minecraft.oak_hanging_sign" | "block.minecraft.banner.piglin.light_gray" | "subtitles.block.dispenser.dispense" | "tooltip.titanium.redstone.ignored" | "subtitles.block.sculk_sensor.clicking_stop" | "block.minecraft.banner.gradient_up.brown" | "stat.itemsButton" | "block.minecraft.banner.stripe_downleft.brown" | "subtitles.entity.panda.ambient" | "config.jade.plugin_minecraft.item_storage" | "item.minecraft.lingering_potion.effect.fire_resistance" | "telemetry.property.render_distance.title" | "block.minecraft.repeater" | "block.minecraft.tuff" | "patchouli.gui.lexicon.toast.info" | "options.graphics.warning.accept" | "createWorld.customize.custom.depthNoiseScaleX" | "subtitles.block.chorus_flower.grow" | "jade.instrument.dragon" | "advancements.adventure.salvage_sherd.title" | "spell.irons_spellbooks.arrow_volley" | "debug.chunk_boundaries.help" | "container.dispenser" | "painting.minecraft.creebet.title" | "block.minecraft.potted_flowering_azalea_bush" | "subtitles.entity.turtle.ambient_land" | "config.jade.plugin_create.blaze_burner" | "ui.irons_spellbooks.frostbite_success_chance" | "container.chestDouble" | "flat_world_preset.minecraft.classic_flat" | "advancements.husbandry.wax_on.title" | "painting.minecraft.aztec2.title" | "gui.abuseReport.send.generic_error" | "entity.irons_spellbooks.ray_of_frost" | "config.jade.display_mode" | "item.minecraft.splash_potion.effect.weakness" | "multiplayer.disconnect.illegal_characters" | "config.jade.plugin_minecraft.enchantment_power_desc" | "subtitles.entity.bee.hurt" | "jade.mobduplication.time" | "subtitles.entity.warden.step" | "item.minecraft.ghast_tear" | "commands.worldborder.set.failed.big" | "Moonlight Generated Pack" | "block.minecraft.red_sandstone_stairs" | "commands.debug.notRunning" | "tetra.material.irons_spellbooks_hogskin" | "block.minecraft.banner.bricks.light_blue" | "ui.irons_spellbooks.cast_instant" | "ui.irons_spellbooks.shatter_damage" | "block.minecraft.cobbled_deepslate" | "argument.id.unknown" | "selectWorld.moreWorldOptions" | "painting.minecraft.stage.author" | "subtitles.entity.allay.item_given" | "subtitles.entity.stray.hurt" | "advancements.story.enter_the_end.title" | "block.minecraft.lime_banner" | "tooltip.irons_spellbooks.empty_affinity_ring" | "selectWorld.edit.backupFailed" | "jei.tooltip.bookmarks.usage.key" | "death.attack.irons_spellbooks.fang_strike.item" | "spell.irons_spellbooks.blood_needles.guide" | "fml.modloading.cycle" | "container.smoker" | "block.minecraft.banner.half_vertical.light_blue" | "block.minecraft.brown_carpet" | "quickplay.error.realm_connect" | "item.irons_spellbooks.nature_upgrade_orb" | "advancements.story.enter_the_nether.title" | "ui.irons_spellbooks.hastened" | "key.jei.nextRecipePage" | "block.minecraft.dark_oak_wall_hanging_sign" | "selectWorld.bonusItems" | "block.minecraft.brain_coral_wall_fan" | "mco.minigame.world.stopButton" | "selectWorld.edit.openFolder" | "block.minecraft.cake" | "entity.minecraft.frog" | "commands.worldborder.warning.distance.failed" | "item.apotheosis.gem.irons_spellbooks:holy" | "mco.selectServer.popup" | "block.minecraft.end_stone_bricks" | "mco.create.world.reset.title" | "fabric-registry-sync-v0.unknown-remote.subtitle.2" | "fabric-registry-sync-v0.unknown-remote.subtitle.1" | "stat_type.minecraft.killed" | "config.jade.plugin_minecraft.tnt_stability" | "block.minecraft.banner.diagonal_right.gray" | "item.minecraft.splash_potion" | "block.minecraft.jungle_log" | "argument.float.big" | "arguments.nbtpath.too_large" | "spell.irons_spellbooks.flaming_strike.guide" | "item.minecraft.mangrove_chest_boat" | "block.minecraft.gray_glazed_terracotta" | "commands.curios.replace.success" | "item.irons_spellbooks.evasion_elixir" | "effect.irons_spellbooks.echoing_strikes.description" | "gui.all" | "curios.identifier.ring" | "death.attack.stalagmite" | "subtitles.entity.witch.celebrate" | "block.minecraft.chiseled_polished_blackstone" | "container.dropper" | "leaves_type.minecraft.flowering_azalea" | "commands.particle.success" | "advancements.story.deflect_arrow.title" | "flat_world_preset.unknown" | "options.sortNone" | "block.minecraft.black_terracotta" | "instrument.minecraft.admire_goat_horn" | "block.minecraft.lily_pad" | "commands.data.block.invalid" | "trim_pattern.minecraft.rib" | "subtitles.entity.chicken.ambient" | "modernfix.option.mixin.perf.dedicated_reload_executor" | "commands.forceload.added.none" | "entity.geckolib.bat" | "item.minecraft.smithing_template.armor_trim.applies_to" | "block.irons_spellbooks.armor_pile" | "advancements.husbandry.balanced_diet.description" | "subtitles.block.bubble_column.bubble_pop" | "sodium.options.biome_blend.tooltip" | "key.saveToolbarActivator" | "narration.jade.bookName" | "item.minecraft.netherite_boots" | "argument.entity.options.nbt.description" | "spell.irons_spellbooks.eldritch_blast" | "block.minecraft.banner.square_bottom_left.pink" | "block.minecraft.warped_trapdoor" | "advMode.triggering" | "key.keyboard.right.shift" | "death.attack.irons_spellbooks.lightning_lance.item" | "jei.tooltip.ingredient.list.disabled.how.to.fix" | "jei.tooltip.recipe.sort.craftable.first.disabled" | "subtitles.entity.villager.work_fletcher" | "enchantment.minecraft.vanishing_curse" | "options.mainHand" | "item.irons_spellbooks.cast_time_ring" | "item.minecraft.pumpkin_seeds" | "fml.modmismatchscreen.table.youneed" | "block.minecraft.nether_brick_wall" | "death.attack.irons_spellbooks.void_tentacles" | "enchantment.improved_exp.fear_of_height.desc" | "item.minecraft.plenty_pottery_sherd" | "item.minecraft.firework_star.trail" | "block.minecraft.banner.creeper.magenta" | "advMode.allEntities" | "subtitles.entity.zombified_piglin.ambient" | "item.minecraft.armor_stand" | "death.attack.fall" | "disconnect.spam" | "key.keyboard.insert" | "item.irons_spellbooks.invisibility_ring.desc" | "block.minecraft.banner.creeper.green" | "block.minecraft.dragon_wall_head" | "advancements.husbandry.breed_an_animal.title" | "block.minecraft.cyan_glazed_terracotta" | "patchouli.gui.lexicon.relations" | "config.jade.display_mode_toggle_desc" | "config.jade.plugin_minecraft.mob_breeding" | "block.minecraft.potted_spruce_sapling" | "item.minecraft.cave_spider_spawn_egg" | "subtitles.entity.parrot.imitate.hoglin" | "block.minecraft.banner.gradient.magenta" | "block.minecraft.deepslate_tile_wall" | "multiplayer.status.request_handled" | "item.minecraft.splash_potion.effect.swiftness" | "subtitles.entity.pig.saddle" | "tooltip.irons_spellbooks.enhance_spell_level" | "block.minecraft.banner.circle.magenta" | "tooltip.titanium.tank.no_action" | "item.minecraft.trader_llama_spawn_egg" | "gui.abuseReport.error.title" | "config.jade.boss_bar_overlap_hide_boss_bar" | "commands.worldborder.warning.distance.success" | "jade.horseStat.jump" | "block.minecraft.banner.stripe_bottom.yellow" | "block.minecraft.cut_sandstone_slab" | "options.accessibility.high_contrast.tooltip" | "fml.modmismatchscreen.missingmods.client" | "block.minecraft.potted_cherry_sapling" | "attribute.irons_spellbooks.blood_spell_power" | "block.minecraft.dark_oak_sapling" | "enchantment.improved_exp.blindness.desc" | "block.minecraft.banner.cross.cyan" | "selectServer.delete" | "commands.forge.dimensions.list" | "commands.spreadplayers.success.entities" | "gui.jade.server_feature" | "config.jade.plugin_minecraft.total_enchantment_power" | "biome.minecraft.deep_lukewarm_ocean" | "createWorld.customize.custom.preset.goodLuck" | "mco.download.downloading" | "commands.execute.conditional.pass_count" | "block.minecraft.potted_poppy" | "advancements.nether.find_fortress.description" | "mco.selectServer.expires.day" | "subtitles.entity.mooshroom.convert" | "subtitles.entity.sheep.hurt" | "subtitles.item.bottle.fill" | "block.minecraft.dead_tube_coral_block" | "block.minecraft.banner.stripe_downright.magenta" | "block.minecraft.spruce_sapling" | "block.minecraft.sticky_piston" | "item.minecraft.birch_boat" | "subtitles.block.amethyst_block.resonate" | "advancements.irons_spellbooks.staff_root.title" | "block.minecraft.banner.skull.pink" | "item.minecraft.wooden_sword" | "jigsaw_block.generate" | "commands.banlist.entry" | "gui.socialInteractions.search_empty" | "subtitles.entity.llama.chest" | "mco.errorMessage.realmsService" | "painting.minecraft.pigscene.author" | "block.minecraft.magenta_concrete_powder" | "screenshot.success" | "entity.irons_spellbooks.cultist" | "config.jade.plugin_minecraft.harvest_tool.creative" | "commands.effect.give.success.multiple" | "advMode.mode.redstone" | "block.minecraft.black_concrete" | "death.attack.irons_spellbooks.void_tentacles.item" | "block.minecraft.banner.globe.yellow" | "selectServer.title" | "item.apotheosis.gem.irons_spellbooks:fire" | "block.minecraft.prismarine_wall" | "subtitles.entity.evoker.prepare_attack" | "block.minecraft.banner.diagonal_left.gray" | "entity.irons_spellbooks.wither_skull_projectile" | "config.jade.plugin_jade.mod_name_extra_msg" | "block.minecraft.banner.gradient_up.black" | "item.irons_spellbooks.hogskin.guide" | "block.minecraft.spruce_button" | "mymod.fuel" | "commands.bossbar.set.players.success.none" | "commands.forge.tags.copy_element_names" | "options.fullscreen.unavailable" | "argument.scoreboardDisplaySlot.invalid" | "item.unbreakable" | "telemetry.property.new_world.title" | "block.minecraft.tinted_glass" | "block.minecraft.banner.triangle_bottom.pink" | "commands.team.join.success.multiple" | "death.attack.sonic_boom" | "item.irons_spellbooks.furled_map" | "multiplayer.disconnect.invalid_entity_attacked" | "spectatorMenu.next_page" | "block.minecraft.banner.skull.black" | "advancements.irons_spellbooks.ink_root.description" | "block.minecraft.blue_ice" | "demo.help.jump" | "subtitles.entity.ender_eye.death" | "description.jei.debug.formatting.1" | "lanServer.scanning" | "parsing.double.expected" | "description.jei.debug.formatting.3" | "description.jei.debug.formatting.2" | "commands.gamemode.success.self" | "mco.configure.world.slot.tooltip.minigame" | "attribute.irons_spellbooks.ice_spell_power" | "menu.sendFeedback" | "entity.minecraft.parrot" | "gui.abuseReport.reason.non_consensual_intimate_imagery.description" | "argument.entity.options.sort.irreversible" | "block.minecraft.acacia_log" | "gui.jei.category.fuel" | "subtitles.entity.slime.squish" | "forge.configgui.removeErroringEntities" | "subtitles.entity.donkey.death" | "block.minecraft.orange_glazed_terracotta" | "tetra.material.irons_spellbooks_holy_rune_socket" | "item.minecraft.shield.lime" | "parsing.quote.expected.start" | "spell.irons_spellbooks.blight" | "entity.minecraft.phantom" | "item.minecraft.egg" | "commands.worldborder.set.failed.far" | "modernfix.option.mixin.perf.clear_mixin_classinfo" | "item.minecraft.music_disc_blocks.desc" | "gui.jade.forced_plugin_config" | "item.irons_spellbooks.villager_spell_book" | "entity.minecraft.dolphin" | "biome.minecraft.plains" | "item.minecraft.honey_bottle" | "gui.entity_tooltip.type" | "block.minecraft.banner.creeper.black" | "commands.advancement.grant.criterion.to.one.failure" | "block.minecraft.banner.bricks.lime" | "forge.configgui.removeErroringBlockEntities.tooltip" | "subtitles.entity.wandering_trader.drink_potion" | "enchantment.minecraft.bane_of_arthropods.desc" | "item.irons_spellbooks.shadowwalker_leggings" | "commands.scoreboard.objectives.list.empty" | "forge.update.newversion" | "item.minecraft.glow_berries" | "fml.menu.multiplayer.missingdatapackregistries" | "patchouli.gui.lexicon.reloaded" | "rarity.irons_spellbooks.epic" | "block.minecraft.bed.occupied" | "structure_block.hover.load" | "jade.instrument.snare" | "item.minecraft.dragon_breath" | "subtitles.block.bubble_column.whirlpool_inside" | "config.jei.search.tooltipSearchMode.comment" | "chat.filtered" | "block.minecraft.banner.stripe_left.gray" | "subtitles.entity.parrot.imitate.drowned" | "block.minecraft.banner.rhombus.cyan" | "modernfix.option.mixin.perf.cache_blockstate_cache_arrays" | "color.minecraft.lime" | "gamerule.category.updates" | "item.irons_spellbooks.autoloader_crossbow" | "advancements.irons_spellbooks.staff_artificer.description" | "block.minecraft.yellow_stained_glass_pane" | "config.jade.plugin_minecraft.energy_storage.detailed_desc" | "block.minecraft.banner.stripe_downleft.light_gray" | "commands.locate.biome.not_found" | "attribute.modifier.equals.2" | "attribute.modifier.equals.1" | "attribute.modifier.equals.0" | "block.minecraft.polished_blackstone_bricks" | "config.jei.mode.cheatItemsEnabled" | "options.accessibility.high_contrast.error.tooltip" | "effect.irons_spellbooks.angel_wings.description" | "attribute.name.zombie.spawn_reinforcements" | "subtitles.entity.panda.sneeze" | "ui.irons_spellbooks.slowness_effect" | "block.minecraft.banner.gradient_up.green" | "block.minecraft.banner.globe.lime" | "telemetry.property.world_session_id.title" | "block.minecraft.warped_hanging_sign" | "subtitles.entity.villager.work_fisherman" | "enchantment.minecraft.fire_protection" | "spell.irons_spellbooks.magic_missile" | "chat.type.advancement.goal" | "block.minecraft.cherry_planks" | "argument.range.empty" | "multiplayer.disconnect.server_shutdown" | "multiplayer.disconnect.banned_ip.reason" | "key.use" | "spell.irons_spellbooks.none.guide" | "direction.titanium.west" | "entity.irons_spellbooks.portal" | "resourcepack.downloading" | "generator.single_biome_floating_islands" | "commands.enchant.failed.itemless" | "createWorld.customize.presets.share" | "sleep.not_possible" | "block.minecraft.brown_candle" | "structure_block.show_boundingbox" | "gui.chatReport.discard.title" | "stat.minecraft.clean_banner" | "block.minecraft.banner.straight_cross.black" | "key.jei.showRecipe" | "config.jade.reset_settings.confirm" | "item.minecraft.firework_star.purple" | "item.minecraft.shield.yellow" | "key.keyboard.backspace" | "block.minecraft.banner.stripe_middle.red" | "block.minecraft.stripped_birch_wood" | "item.minecraft.firework_star.flicker" | "item.minecraft.creeper_banner_pattern.desc" | "config.jei.search.resourceIdSearchMode.comment" | "gameMode.spectator" | "subtitles.entity.shulker.shoot" | "menu.modded" | "block.minecraft.banner.curly_border.cyan" | "subtitles.item.shears.shear" | "stat.generalButton" | "block.minecraft.banner.square_top_right.light_blue" | "structure_block.hover.save" | "fml.menu.multiplayer.truncated" | "argument.angle.invalid" | "item.minecraft.echo_shard" | "block.minecraft.stonecutter" | "painting.minecraft.earth.title" | "block.minecraft.jukebox" | "block.minecraft.potted_mangrove_propagule" | "entity.minecraft.command_block_minecart" | "effect.minecraft.nausea" | "entity.geckolib.cool_kid" | "time.bookshelf.day.sunday" | "block.minecraft.gold_block" | "block.minecraft.lime_concrete_powder" | "telemetry.property.platform.title" | "advancements.adventure.lightning_rod_with_villager_no_fire.title" | "advancements.irons_spellbooks.staff_blood_staff.description" | "block.minecraft.banner.square_top_left.magenta" | "gui.jei.category.compostable.chance" | "subtitles.entity.zoglin.attack" | "enchantment.minecraft.looting" | "key.chat" | "block.minecraft.ancient_debris" | "block.minecraft.banner.stripe_right.black" | "disconnect.kicked" | "fml.messages.version.restriction.bounded.lowerexclusive" | "death.attack.irons_spellbooks.arrow_volley" | "block.minecraft.banner.skull.green" | "block.minecraft.banner.square_top_right.magenta" | "advancements.nether.ride_strider_in_overworld_lava.description" | "gui.none" | "commands.schedule.cleared.failure" | "block.minecraft.banner.diagonal_up_right.cyan" | "color.minecraft.blue" | "block.minecraft.banner.gradient_up.light_blue" | "enchantment.minecraft.efficiency" | "enchantment.improved_exp.water_breathing.desc" | "demo.help.later" | "block.minecraft.exposed_copper" | "selectWorld.edit.backupCreated" | "options.hideMatchedNames" | "curios.modifiers.charm" | "sodium.options.buttons.apply" | "compliance.playtime.message" | "forge.gui.exit" | "block.minecraft.banner.square_bottom_left.green" | "advancements.husbandry.plant_any_sniffer_seed.description" | "__support_grapplemod" | "modernfix.option.mixin.bugfix.chunk_deadlock" | "effect.minecraft.unluck" | "tetra.material.irons_spellbooks_ice_rune_socket.prefix" | "commands.data.storage.modified" | "forge.configgui.dimensionUnloadQueueDelay.tooltip" | "block.minecraft.dead_horn_coral_fan" | "narrator.select.world_info" | "mco.configure.world.subscription.days" | "subtitles.entity.vindicator.hurt" | "block.minecraft.banner.globe.blue" | "createWorld.customize.custom.preset.drought" | "sodium.options.use_block_face_culling.name" | "block.minecraft.iron_trapdoor" | "item.minecraft.music_disc_11.desc" | "item.minecraft.polar_bear_spawn_egg" | "arguments.item.overstacked" | "block.minecraft.banner.diagonal_right.brown" | "death.attack.fallingBlock" | "block.minecraft.banner.flower.magenta" | "block.minecraft.black_glazed_terracotta" | "mco.invites.title" | "mco.account.update" | "block.minecraft.light_blue_candle" | "config.jei.search.colorSearchMode.comment" | "item.minecraft.firework_star" | "irons_spellbooks.tetra_bar.max_mana.tooltip" | "createWorld.customize.custom.mainNoiseScaleX" | "block.minecraft.cherry_trapdoor" | "createWorld.customize.custom.mainNoiseScaleY" | "createWorld.customize.custom.mainNoiseScaleZ" | "key.categories.ui" | "options.gamma.min" | "mco.configure.world.subscription.unknown" | "enchantment.improved_exp.habitual_place.desc" | "block.minecraft.banner.half_vertical.orange" | "mco.minigame.world.startButton" | "jecharacters.chat.taiwan" | "commands.data.modify.invalid_index" | "patchouli.gui.lexicon.button.resize.verybig.message" | "block.minecraft.banner.square_bottom_left.black" | "block.minecraft.spruce_wall_hanging_sign" | "biome.minecraft.wooded_badlands" | "block.minecraft.cornflower" | "options.discrete_mouse_scroll" | "chat_screen.title" | "structure_block.mode_info.corner" | "block.minecraft.bamboo_fence" | "debug.inspect.client.block" | "fml.messages.version.restriction.lower.inclusive" | "dataPack.validation.failed" | "mco.activity.noactivity" | "entity.minecraft.villager.weaponsmith" | "block.minecraft.purple_glazed_terracotta" | "menu.paused" | "mco.selectServer.play" | "fml.menu.modoptions" | "block.minecraft.spawner.desc2" | "block.minecraft.spawner.desc1" | "death.attack.blood_magic.item" | "subtitles.entity.magma_cube.hurt" | "advancements.story.cure_zombie_villager.description" | "commands.trigger.failed.unprimed" | "advancements.husbandry.complete_catalogue.title" | "enchantment.improved_exp.saturation.desc" | "key.jade.show_details_alternative" | "selectWorld.unable_to_load" | "subtitles.entity.goat.screaming.ambient" | "options.language" | "block.minecraft.vine" | "block.minecraft.banner.diagonal_left.yellow" | "block.minecraft.orange_concrete" | "death.attack.irons_spellbooks.wisp.item" | "subtitles.entity.illusioner.mirror_move" | "item.irons_spellbooks.fire_rune" | "death.attack.irons_spellbooks.blaze_storm" | "death.attack.irons_spellbooks.wall_of_fire.item" | "block.minecraft.infested_stone_bricks" | "commands.playsound.failed" | "death.attack.irons_spellbooks.guiding_bolt.item" | "spell.irons_spellbooks.wall_of_fire.guide" | "block.minecraft.banner.flower.lime" | "commands.whitelist.enabled" | "config.jei.advanced.maxColumns.comment" | "sodium.options.simulation_distance.tooltip" | "block.minecraft.magenta_wool" | "entity.minecraft.villager.fletcher" | "debug.gamemodes.select_next" | "item.irons_spellbooks.pyromancer_leggings" | "subtitles.entity.goat.hurt" | "commands.irons_spellbooks.irons_debug_command.success" | "block.minecraft.brown_concrete_powder" | "subtitles.entity.wither_skeleton.ambient" | "trim_pattern.minecraft.silence" | "block.minecraft.acacia_trapdoor" | "sodium.options.always_defer_chunk_updates.tooltip" | "fml.menu.mods.info.trust" | "commands.spectate.success.stopped" | "enchantment.minecraft.fire_aspect.desc" | "block.minecraft.stripped_cherry_log" | "createWorld.customize.custom.depthNoiseScaleExponent" | "tutorial.move.description" | "block.minecraft.amethyst_cluster" | "entity.geckolib.parasite" | "block.minecraft.banner.straight_cross.green" | "commands.bossbar.set.style.unchanged" | "jade.instrument.piglin" | "gui.days" | "advancements.irons_spellbooks.make_antiquated_compass.title" | "item.geckolib.mutant_zombie_spawn_egg" | "options.showAll" | "spell.irons_spellbooks.stomp" | "subtitles.block.fire.extinguish" | "resourcePack.vanilla.name" | "mco.configure.world.slot" | "block.minecraft.waxed_cut_copper" | "fml.modloading.brokenfile.liteloader" | "block.minecraft.birch_slab" | "sodium.console.core_shaders_info" | "gui.chatSelection.fold" | "painting.minecraft.alban.title" | "item.irons_spellbooks.rotten_spell_book" | "mco.upload.failed" | "biome.minecraft.cold_ocean" | "block.minecraft.banner.half_horizontal_bottom.pink" | "tetra.stats.irons_spellbooks:mana_siphon" | "options.framerateLimit" | "enchantment.shieldsplus.reinforced.desc" | "trim_material.minecraft.amethyst" | "narrator.button.difficulty_lock.unlocked" | "commands.datapack.list.available.none" | "enchantment.minecraft.riptide" | "selectWorld.warning.deprecated.question" | "argument.nbt.array.mixed" | "block.minecraft.banner.triangle_top.gray" | "commands.kill.success.multiple" | "block.minecraft.brown_concrete" | "disconnect.loginFailedInfo.userBanned" | "block.minecraft.potted_bamboo" | "config.jade.plugin_minecraft.fluid_storage" | "block.minecraft.blackstone_wall" | "advMode.command" | "spell.irons_spellbooks.charge" | "subtitles.entity.parrot.imitate.warden" | "options.chat.line_spacing" | "block.minecraft.banner.flower.blue" | "datapackFailure.title" | "biome.minecraft.frozen_peaks" | "item.irons_spellbooks.archevoker_spawn_egg" | "key.keyboard.keypad.divide" | "block.minecraft.sugar_cane" | "item.color" | "block.minecraft.end_gateway" | "advancements.nether.summon_wither.description" | "patchouli.gui.lexicon.not_anchored" | "block.minecraft.deepslate_copper_ore" | "spell.irons_spellbooks.ray_of_siphoning" | "item.minecraft.shelter_pottery_sherd" | "resourcePack.server.name" | "block.minecraft.cracked_deepslate_bricks" | "effect.irons_spellbooks.abyssal_shroud" | "advancements.irons_spellbooks.enter_catacombs.title" | "subtitles.block.door.toggle" | "commands.forge.tracking.be.reset" | "multiplayer.disconnect.outdated_client" | "block.minecraft.horn_coral_wall_fan" | "entity.minecraft.warden" | "mco.selectServer.mapOnlySupportedForVersion" | "config.jade.key_binds" | "item.minecraft.golden_axe" | "item.minecraft.skull_pottery_sherd" | "block.minecraft.deepslate_tiles" | "commands.execute.conditional.pass" | "gui.abuseReport.reason.defamation_impersonation_false_information.description" | "fml.messages.version.restriction.lower.exclusive" | "block.minecraft.banner.gradient_up.cyan" | "mco.backup.entry.undefined" | "subtitles.entity.turtle.shamble_baby" | "biome.minecraft.snowy_slopes" | "death.attack.fallingStalactite" | "block.minecraft.blue_concrete" | "block.minecraft.banner.creeper.white" | "selectWorld.import_worldgen_settings" | "block.minecraft.banner.triangles_bottom.lime" | "item.minecraft.smithing_template.ingredients" | "tooltip.irons_spellbooks.improved_format" | "mco.terms.title" | "item.minecraft.light_gray_dye" | "modernfix.connectedness_dynresoruces" | "block.minecraft.banner.border.brown" | "block.minecraft.fire_coral_wall_fan" | "fml.modloading.brokenfile.fabric" | "block.minecraft.dispenser" | "item.irons_spellbooks.amethyst_resonance_charm" | "subtitles.item.armor.equip" | "biome.minecraft.meadow" | "subtitles.entity.parrot.imitate.skeleton" | "argument.entity.toomany" | "item.minecraft.heartbreak_pottery_shard" | "commands.playsound.success.single" | "subtitles.entity.ravager.celebrate" | "affix.irons_spellbooks:spellbook/attribute/holy_spell_power.suffix" | "spell.irons_spellbooks.blessing_of_life.guide" | "fml.modloading.failedtoloadmodclass" | "lanServer.start" | "subtitles.entity.player.attack.sweep" | "block.minecraft.emerald_ore" | "enchdesc.jei.compatible_items.title" | "item.geckolib.wolf_armor_boots" | "mco.template.select.narrate.version" | "death.attack.irons_spellbooks.magic_missile" | "modernfix.option.category.bugfixes.description" | "subtitles.entity.elder_guardian.ambient" | "advancements.nether.brew_potion.description" | "chat.disabled.launcher" | "key.curios.open.desc" | "subtitles.entity.magma_cube.squish" | "block.minecraft.dead_tube_coral_wall_fan" | "subtitles.block.beehive.exit" | "options.gamma.max" | "block.minecraft.polished_blackstone_pressure_plate" | "commands.enchant.failed.entity" | "config.jade.plugin_minecraft.tnt_stability_desc" | "subtitles.block.chest.open" | "block.minecraft.banner.border.orange" | "curios.tooltip.slot" | "advancements.irons_spellbooks.spell_book_rotten.title" | "subtitles.entity.husk.converted_to_zombie" | "tooltip.jade.villager_profession" | "subtitles.entity.pig.death" | "enchantment.endlessbiomes.vwooping.desc" | "options.sortZA" | "argument.id.invalid" | "block.minecraft.purple_bed" | "pack.incompatible.compatible" | "options.credits_and_attribution" | "jei.tooltip.bookmarks.not.enough.space" | "mco.create.world.subtitle" | "options.screenEffectScale" | "block.minecraft.banner.flower.purple" | "jadeaddons.mcjtylib.ownedBy.warning" | "irons_spellbooks.tetra_bar.holy_spell_power.tooltip" | "mco.configure.world.edit.subscreen.inspiration" | "death.attack.irons_spellbooks.blood_needles" | "jadeaddons.mcjtylib.infused" | "entity.minecraft.small_fireball" | "death.attack.irons_spellbooks.echoing_strikes.item" | "enchantment.dungeonsenchantments.cowardice.desc" | "modernfix.option.name.mixin.perf.async_jei" | "advancements.toast.goal" | "block.minecraft.banner.circle.light_blue" | "curios.name" | "item.minecraft.bundle" | "block.minecraft.banner.stripe_top.red" | "key.categories.movement" | "key.jei.cheatItemStack" | "block.minecraft.magenta_glazed_terracotta" | "item.irons_spellbooks.legendary_ink" | "subtitles.entity.puffer_fish.hurt" | "text.cloth-config.error.too_small" | "advancements.adventure.lightning_rod_with_villager_no_fire.description" | "commands.bossbar.set.players.unchanged" | "sodium.options.use_fog_occlusion.name" | "item.irons_spellbooks.cryomancer_boots" | "block.minecraft.moving_piston" | "modernfix.option.category.performance.description" | "subtitles.entity.squid.ambient" | "block.minecraft.fire" | "option.cloth-config.setDefaultSmoothScroll" | "item.irons_spellbooks.shadowwalker_boots" | "curios.modifiers.back" | "spell.irons_spellbooks.gluttony.guide" | "block.minecraft.banner.stripe_downleft.yellow" | "block.minecraft.birch_door" | "block.minecraft.cyan_shulker_box" | "__comment" | "advancements.nether.obtain_blaze_rod.description" | "death.attack.irons_spellbooks.raise_dead.item" | "block.minecraft.smooth_sandstone_stairs" | "subtitles.entity.spider.death" | "key.jade.show_uses" | "item.irons_spellbooks.crypt_skull" | "block.minecraft.lime_glazed_terracotta" | "subtitles.entity.ender_dragon.death" | "gui.jei.category.compostable" | "key.keyboard.down" | "stat.minecraft.open_barrel" | "debug.creative_spectator.error" | "mco.brokenworld.nonowner.title" | "config.jei.advanced.colorSearchEnabled" | "block.minecraft.heavy_weighted_pressure_plate" | "telemetry.property.frame_rate_samples.title" | "commands.forge.setdim.deprecated" | "block.minecraft.banner.half_vertical.gray" | "effect.irons_spellbooks.blight" | "gui.socialInteractions.search_hint" | "entity.minecraft.cod" | "argument.entity.options.sort.description" | "commands.banlist.list" | "entity.minecraft.hoglin" | "biome.minecraft.basalt_deltas" | "block.minecraft.banner.stripe_right.green" | "argument.block.tag.disallowed" | "options.videoTitle" | "entity.minecraft.cow" | "enchantment.improved_exp.oxidation.desc" | "generator.minecraft.debug_all_block_states" | "death.attack.irons_spellbooks.firefly_swarm" | "block.minecraft.pink_glazed_terracotta" | "painting.minecraft.bust.author" | "telemetry.property.ticks_since_load.title" | "modernfix.option.mixin.bugfix.fix_config_crashes" | "subtitles.entity.hoglin.retreat" | "ui.irons_spellbooks.cast_error_unlearned" | "commands.forceload.removed.single" | "block.minecraft.light_blue_carpet" | "subtitles.entity.axolotl.death" | "narration.jade.clear_content.usage" | "advancements.irons_spellbooks.make_wayward_compass.description" | "config.jei.search.comment" | "chat.disabled.chain_broken" | "enchantment.minecraft.piercing" | "entity.minecraft.ravager" | "mco.configure.world.invited" | "options.glintStrength.tooltip" | "death.attack.thrown" | "entity.minecraft.tnt" | "tooltip.irons_spellbooks.upgrade_tooltip" | "item.minecraft.potion.effect.slowness" | "block.minecraft.mossy_stone_brick_slab" | "createWorld.customize.custom.useLavaOceans" | "biome.minecraft.stony_peaks" | "item.irons_spellbooks.conjurers_talisman" | "color.minecraft.light_gray" | "subtitles.entity.slime.death" | "subtitles.entity.firework_rocket.blast" | "addServer.title" | "key.keyboard.grave.accent" | "block.minecraft.lime_candle" | "subtitles.particle.soul_escape" | "mco.selectServer.expired" | "color.minecraft.white" | "fluid_type.minecraft.flowing_milk" | "config.jei.advanced.maxColumns" | "commands.datapack.enable.failed" | "jei.tooltip.bookmarks.recipe.remove" | "block.minecraft.enchanting_table" | "block.minecraft.barrel" | "narrator.button.language" | "gui.recipebook.toggleRecipes.blastable" | "mco.configure.world.leave.question.line2" | "mco.configure.world.leave.question.line1" | "config.jade.plugin_create.goggles" | "subtitles.item.crossbow.charge" | "block.minecraft.chain" | "painting.minecraft.plant.title" | "item.minecraft.potion.effect.regeneration" | "item.irons_spellbooks.emerald_stoneplate_ring.desc" | "subtitles.entity.villager.death" | "subtitles.entity.phantom.bite" | "block.minecraft.banner.triangle_top.red" | "stat.minecraft.interact_with_smithing_table" | "item.minecraft.tipped_arrow.effect.fire_resistance" | "sodium.options.chunk_update_threads.name" | "jei.tooltip.liquid.flowing" | "block.minecraft.cave_vines_plant" | "subtitles.entity.glow_item_frame.remove_item" | "block.minecraft.quartz_block" | "subtitles.block.shulker_box.open" | "commands.bossbar.set.max.unchanged" | "block.minecraft.banner.gradient.gray" | "key.mouse" | "block.minecraft.cut_copper_stairs" | "block.minecraft.banner.triangles_bottom.blue" | "config.jade.plugin_minecraft.villager_profession" | "block.minecraft.stripped_dark_oak_wood" | "commands.worldborder.warning.time.success" | "block.minecraft.banner.border.pink" | "mco.configure.world.restore.question.line2" | "subtitles.entity.strider.idle" | "item.irons_spellbooks.lesser_spell_slot_upgrade" | "mco.configure.world.restore.question.line1" | "dataPack.update_1_20.name" | "selectWorld.edit.resetIcon" | "disconnect.genericReason" | "block.minecraft.bamboo_mosaic_stairs" | "biome.minecraft.flower_forest" | "subtitles.chiseled_bookshelf.take" | "enchantment.improved_exp.random_teleport.desc" | "stat.minecraft.bell_ring" | "subtitles.entity.bat.hurt" | "subtitles.entity.squid.death" | "menu.playdemo" | "fabric-registry-sync-v0.unknown-remote.footer" | "block.minecraft.big_dripleaf_stem" | "advancements.irons_spellbooks.make_scroll_forge.description" | "options.allowServerListing.tooltip" | "modernfix.option.mixin.bugfix.mantle_model_cme" | "item.patchouli:pamphlet.landing" | "block.minecraft.stone_pressure_plate" | "attribute.irons_spellbooks.nature_spell_power" | "biome.minecraft.mangrove_swamp" | "block.minecraft.bamboo_button" | "block.minecraft.banner.straight_cross.white" | "item.irons_spellbooks.copper_spell_book" | "ui.irons_spellbooks.unlearned_error" | "advancements.husbandry.breed_an_animal.description" | "block.minecraft.banner.mojang.yellow" | "narrator.loading" | "block.minecraft.campfire" | "sodium.options.v_sync.tooltip" | "argument.entity.options.distance.negative" | "item.minecraft.oak_chest_boat" | "demo.help.inventory" | "gui.abuseReport.reason.imminent_harm.description" | "subtitles.entity.skeleton_horse.death" | "block.minecraft.spawner" | "commands.enchant.failed" | "parsing.long.invalid" | "enchantment.improved_exp.resistance.desc" | "mco.selectServer.buy" | "block.minecraft.spruce_wall_sign" | "block.minecraft.banner.gradient_up.red" | "gamerule.category.drops" | "item.minecraft.music_disc_pigstep.desc" | "subtitles.entity.zombie_horse.hurt" | "advancements.adventure.arbalistic.title" | "subtitles.entity.glow_squid.squirt" | "school.irons_spellbooks.holy" | "item.minecraft.splash_potion.effect.slowness" | "painting.minecraft.sunset.title" | "item.minecraft.music_disc_mall.desc" | "item.minecraft.shield.blue" | "death.attack.player" | "createWorld.customize.custom.confirm2" | "mco.worldSlot.minigame" | "config.jade.plugin_minecraft.harvest_tool" | "createWorld.customize.custom.confirm1" | "jade.infinity" | "item.apotheosis.gem.irons_spellbooks:ice" | "block.minecraft.cherry_button" | "block.minecraft.andesite_wall" | "key.jade.config" | "options.gamma" | "subtitles.entity.warden.roar" | "sodium.options.always_defer_chunk_updates.name" | "advancements.adventure.fall_from_world_height.description" | "parsing.int.invalid" | "sodium.options.fps_limit.tooltip" | "chat.tag.system_single_player" | "commands.data.get.unknown" | "spell.irons_spellbooks.magma_bomb.guide" | "advancements.story.follow_ender_eye.description" | "block.minecraft.birch_trapdoor" | "gamerule.logAdminCommands" | "item.minecraft.blue_dye" | "block.minecraft.moss_block" | "block.minecraft.banner.stripe_top.pink" | "fml.modloading.missingmetadata" | "block.minecraft.torch" | "advancements.story.smelt_iron.title" | "block.minecraft.light_gray_shulker_box" | "block.minecraft.orange_candle_cake" | "forge.chatType.system" | "color.minecraft.green" | "advancements.story.enchant_item.title" | "mco.upload.select.world.subtitle" | "recipe.notFound" | "options.difficulty.easy" | "advMode.mode.redstoneTriggered" | "options.darknessEffectScale.tooltip" | "subtitles.entity.parrot.imitate.silverfish" | "language.code" | "commands.teammsg.failed.noteam" | "block.minecraft.banner.stripe_middle.cyan" | "painting.minecraft.void.title" | "block.minecraft.dark_oak_button" | "gui.jei.category.smoking" | "block.irons_spellbooks.arcane_anvil" | "death.attack.irons_spellbooks.ice_block.item" | "block.minecraft.large_amethyst_bud" | "jei.key.category.search" | "advancements.irons_spellbooks.make_antiquated_compass.description" | "trim_pattern.minecraft.spire" | "item.minecraft.golden_helmet" | "block.minecraft.soul_lantern" | "spell.irons_spellbooks.spider_aspect" | "item.irons_spellbooks.wandering_magician_boots" | "block.minecraft.banner.stripe_bottom.pink" | "commands.team.option.seeFriendlyInvisibles.alreadyDisabled" | "block.minecraft.chiseled_stone_bricks" | "block.minecraft.bamboo_planks" | "block.minecraft.banner.small_stripes.purple" | "gamerule.category.chat" | "block.minecraft.banner.stripe_right.white" | "block.minecraft.potted_warped_roots" | "painting.minecraft.wind.author" | "entity.minecraft.cat" | "item.minecraft.lingering_potion.effect.night_vision" | "argument.entity.selector.randomPlayer" | "commands.bossbar.set.players.success.some" | "gamerule.playersSleepingPercentage" | "commands.clear.success.multiple" | "block.minecraft.warped_sign" | "block.minecraft.banner.stripe_top.brown" | "death.attack.sonic_boom.player" | "key.irons_spellbooks.spellbook_cast" | "enchantment.improved_exp.indestructible.desc" | "forge.configgui.indexModPackCachesOnThread" | "block.minecraft.bamboo" | "death.attack.thorns.item" | "item.minecraft.cooked_porkchop" | "commands.experience.set.points.success.single" | "subtitles.entity.llama.ambient" | "block.minecraft.banner.square_bottom_left.red" | "block.minecraft.sculk" | "item.irons_spellbooks.divine_pearl" | "painting.minecraft.water.title" | "spell.irons_spellbooks.shockwave.guide" | "selectWorld.gameMode.creative.line1" | "time.bookshelf.month.february" | "block.minecraft.potted_dandelion" | "commands.mana.set.success.multiple" | "ui.irons_spellbooks.cast_range" | "options.chat.visibility.full" | "advancements.adventure.shoot_arrow.title" | "embeddium.options.use_quad_normals_for_lighting.tooltip" | "mco.configure.world.buttons.subscription" | "subtitles.entity.parrot.imitate.creeper" | "patchouli.gui.lexicon.keybind_missing" | "advancements.adventure.adventuring_time.title" | "gui.abuseReport.reason.non_consensual_intimate_imagery" | "commands.advancement.grant.many.to.many.failure" | "selectWorld.mapFeatures.info" | "entity.minecraft.tropical_fish.type.snooper" | "item.minecraft.firework_star.shape.small_ball" | "entity.minecraft.interaction" | "spell.irons_spellbooks.lightning_lance.guide" | "item.minecraft.firework_star.light_blue" | "time.bookshelf.month.december" | "effect.minecraft.strength" | "block.minecraft.banner.stripe_downright.blue" | "key.jei.copy.recipe.id" | "item.minecraft.tipped_arrow.effect.water_breathing" | "block.minecraft.lectern" | "selectWorld.gameMode.creative.line2" | "selectWorld.allowCommands" | "advancements.nether.all_potions.title" | "tooltip.titanium.facing_handler.real_output" | "painting.minecraft.fire.author" | "block.minecraft.dead_fire_coral_fan" | "subtitles.entity.pillager.hurt" | "config.jade.plugin_minecraft.profession" | "attribute.irons_spellbooks.cast_time_reduction" | "parsing.long.expected" | "item.minecraft.prize_pottery_shard" | "options.mipmapLevels" | "block.minecraft.banner.rhombus.purple" | "enchantment.dungeonsenchantments.ambush.desc" | "item.irons_spellbooks.evocation_upgrade_orb" | "death.attack.irons_spellbooks.fireball.item" | "createWorld.customize.custom.useStrongholds" | "block.minecraft.red_stained_glass_pane" | "commands.data.block.modified" | "commands.bossbar.unknown" | "block.minecraft.smooth_sandstone_slab" | "entity.minecraft.tropical_fish.predefined.0" | "spell.irons_spellbooks.fang_ward" | "commands.advancement.grant.many.to.many.success" | "config.jade.plugin_minecraft.zombie_villager" | "subtitles.entity.fox.hurt" | "advancements.adventure.trade.title" | "block.minecraft.orange_banner" | "entity.minecraft.tropical_fish.predefined.9" | "commands.config.getwithtype" | "block.minecraft.stripped_oak_wood" | "entity.minecraft.salmon" | "stat.minecraft.interact_with_crafting_table" | "key.jei.toggleOverlay" | "entity.minecraft.tropical_fish.predefined.3" | "entity.minecraft.tropical_fish.predefined.4" | "entity.minecraft.tropical_fish.predefined.1" | "entity.irons_spellbooks.large_fireball" | "entity.minecraft.tropical_fish.predefined.2" | "entity.minecraft.tropical_fish.predefined.7" | "entity.minecraft.tropical_fish.predefined.8" | "block.minecraft.mangrove_roots" | "entity.minecraft.tropical_fish.predefined.5" | "team.collision.pushOwnTeam" | "fml.menu.loadingmods" | "entity.minecraft.tropical_fish.predefined.6" | "multiplayer.disconnect.slow_login" | "block.minecraft.banner.stripe_top.yellow" | "block.minecraft.redstone_ore" | "modernfix.option.mixin.bugfix.unsafe_modded_shape_caches" | "config.jei.search.searchAdvancedTooltips" | "subtitles.item.shovel.flatten" | "filled_map.scale" | "effect.irons_spellbooks.enchanted_ward.description" | "block.minecraft.banner.stripe_left.red" | "config.jade.plugin_minecraft.energy_storage" | "item.irons_spellbooks.gold_spell_book" | "commands.scoreboard.players.enable.failed" | "config.jade.plugin_jade.registry_name_advanced_tooltips_desc" | "block.minecraft.banner.stripe_downright.lime" | "subtitles.block.frogspawn.hatch" | "connect.failed" | "disconnect.disconnected" | "key.jei.bookmark" | "block.minecraft.warped_hyphae" | "enchantment.minecraft.knockback" | "subtitles.entity.elder_guardian.flop" | "block.minecraft.dark_oak_fence_gate" | "item.minecraft.splash_potion.effect.healing" | "subtitles.entity.piglin.retreat" | "death.attack.irons_spellbooks.sunbeam" | "effect.irons_spellbooks.oakskin.description" | "block.minecraft.torchflower" | "subtitles.entity.ravager.death" | "subtitles.item.firecharge.use" | "block.minecraft.warped_stairs" | "entity.minecraft.camel" | "item.minecraft.minecart" | "advancements.adventure.kill_all_mobs.title" | "optimizeWorld.stage.upgrading" | "commands.forge.tags.tag_key" | "mco.backup.generate.world" | "painting.minecraft.stage.title" | "item.minecraft.jungle_boat" | "block.minecraft.waxed_oxidized_cut_copper" | "spell.irons_spellbooks.electrocute" | "commands.banlist.none" | "moon.phase.first.quarter" | "tutorial.punch_tree.title" | "ui.irons_spellbooks.cast_charge" | "painting.minecraft.match.author" | "key.sprint" | "config.jade.plugin_minecraft.item_frame" | "config.jade.plugin_minecraft.item_storage.detailed_amount" | "subtitles.block.button.click" | "patchouli.gui.lexicon.button.resize" | "trim_material.minecraft.redstone" | "subtitles.item.chorus_fruit.teleport" | "commands.scoreboard.players.remove.success.single" | "config.jade.display_bosses" | "item.minecraft.guardian_spawn_egg" | "jade.instrument.iron_xylophone" | "time.bookshelf.day.friday" | "lanServer.port.invalid.new" | "jade.harvest_tool.unbreakable" | "advancements.story.mine_stone.description" | "school.irons_spellbooks.fire" | "spell.irons_spellbooks.gust" | "death.attack.irons_spellbooks.shockwave" | "chat.disabled.missingProfileKey" | "painting.minecraft.pointer.author" | "block.minecraft.banner.base.white" | "mco.configure.world.slot.tooltip" | "block.minecraft.banner.cross.black" | "block.minecraft.banner.curly_border.purple" | "block.minecraft.banner.diagonal_up_right.orange" | "item.minecraft.clay_ball" | "item.minecraft.rabbit_hide" | "leaves_type.minecraft.azalea" | "color.minecraft.black" | "item.minecraft.netherite_leggings" | "block.minecraft.banner.small_stripes.light_blue" | "death.attack.dragonBreath.player" | "advancements.adventure.two_birds_one_arrow.description" | "jigsaw_block.joint.rollable" | "subtitles.entity.cow.milk" | "jadeaddons.deepresonance.crystalPower" | "block.minecraft.light_gray_wool" | "advancements.nether.return_to_sender.title" | "modernfix.option.mixin.bugfix.entity_pose_stack" | "block.minecraft.lime_stained_glass" | "block.minecraft.banner.half_horizontal.pink" | "item.minecraft.pufferfish_bucket" | "spell.irons_spellbooks.portal" | "config.jei.advanced.giveMode.comment" | "text.cloth-config.quit_config_sure" | "advancements.husbandry.complete_catalogue.description" | "sleep.players_sleeping" | "modernfix.option.mixin.perf.nuke_empty_chunk_sections" | "block.minecraft.banner.triangles_top.pink" | "block.minecraft.polished_blackstone" | "config.jade.plugin_minecraft.mob_spawner" | "subtitles.entity.vindicator.death" | "advancements.end.dragon_egg.description" | "item.patchouli.comprehensive_test_book.name" | "debug.pause.help" | "spectatorMenu.teleport" | "narration.jade.negative" | "commands.trigger.failed.invalid" | "block.minecraft.banner.square_bottom_right.gray" | "advancements.adventure.very_very_frightening.title" | "item.minecraft.tnt_minecart" | "commands.forge.tags.copy_tag_names" | "argument.block.property.invalid" | "selectWorld.versionWarning" | "death.attack.lava.player" | "subtitles.item.trident.hit" | "config.jade.plugin_minecraft.energy_storage.detailed" | "gui.jade.jade_settings" | "key.keyboard.enter" | "advancements.story.enter_the_end.description" | "advMode.notEnabled" | "book.pageIndicator" | "block.minecraft.purple_terracotta" | "subtitles.entity.squid.hurt" | "block.minecraft.banner.small_stripes.green" | "advancements.irons_spellbooks.spell_book_villager.title" | "item.minecraft.redstone" | "advancements.adventure.trim_with_all_exclusive_armor_patterns.description" | "_comment" | "block.minecraft.crimson_wall_hanging_sign" | "demo.help.fullWrapped" | "item.irons_spellbooks.electromancer_helmet" | "commands.perf.alreadyRunning" | "biome.minecraft.deep_dark" | "config.jade.plugin_create.backtank_capacity" | "block.minecraft.oak_sapling" | "commands.bookshelf.loot_tables.wildcard" | "death.attack.irons_spellbooks.electrocute.item" | "commands.ride.mount.failure.wrong_dimension" | "effect.minecraft.darkness" | "key.loadToolbarActivator" | "attribute.name.generic.armor" | "attribute.name.generic.follow_range" | "jadeaddons.lootr.refresh" | "argument.range.ints" | "forge.configgui.disableStairSlabCulling" | "item.irons_spellbooks.pyromancer_boots" | "options.title" | "biome.minecraft.savanna" | "block.minecraft.yellow_carpet" | "item.irons_spellbooks.priest_helmet" | "block.minecraft.banner.stripe_center.cyan" | "death.attack.irons_spellbooks.wither_skull.item" | "subtitles.entity.warden.sonic_charge" | "commands.team.leave.success.multiple" | "attribute.irons_spellbooks.holy_magic_resist" | "createWorld.customize.custom.biomeScaleOffset" | "advancements.end.kill_dragon.description" | "subtitles.entity.ender_eye.launch" | "jecharacters.chat.error" | "subtitles.entity.fox.eat" | "inventory.hotbarInfo" | "painting.minecraft.void.author" | "forge.configgui.skipEmptyShapelessCheck" | "block.minecraft.green_terracotta" | "options.prioritizeChunkUpdates.nearby.tooltip" | "subtitles.entity.warden.nearby_close" | "block.minecraft.chorus_flower" | "item.minecraft.scute" | "mco.create.world" | "subtitles.entity.camel.dash" | "item.minecraft.popped_chorus_fruit" | "item.minecraft.lingering_potion.effect.swiftness" | "stat.minecraft.inspect_hopper" | "block.minecraft.bubble_column" | "jigsaw_block.joint_label" | "addServer.resourcePack.prompt" | "advancements.husbandry.tactical_fishing.title" | "block.minecraft.waxed_weathered_cut_copper_slab" | "item.minecraft.brewer_pottery_sherd" | "config.jei.title" | "arguments.operation.div0" | "enchantment.minecraft.projectile_protection.desc" | "key.keyboard.f22" | "mco.configure.world.status" | "key.keyboard.f23" | "key.keyboard.f20" | "key.keyboard.f21" | "block.minecraft.banner.mojang.purple" | "text.cloth-config.not_editable" | "advancements.adventure.summon_iron_golem.title" | "enchantment.improved_exp.the_hatred_of_others.desc" | "block.minecraft.banner.half_horizontal_bottom.gray" | "commands.schedule.same_tick" | "commands.spreadplayers.success.teams" | "key.keyboard.f24" | "subtitles.entity.allay.ambient_with_item" | "tetra.material.irons_spellbooks_blood_rune_socket.prefix" | "key.keyboard.f25" | "filled_map.locked" | "mco.connect.failed" | "item.irons_spellbooks.frostward_ring.desc" | "selectWorld.mapType" | "death.attack.outOfWorld.player" | "gui.narrate.slider" | "selectWorld.access_failure" | "multiplayer.downloadingTerrain" | "block.minecraft.banner.small_stripes.red" | "block.minecraft.deepslate_redstone_ore" | "argument.rotation.incomplete" | "effect.irons_spellbooks.echoing_strikes" | "advancements.irons_spellbooks.spell_book_druidic.title" | "gamerule.category.spawning" | "fml.modloading.missingclasses" | "subtitles.entity.witch.throw" | "block.minecraft.tall_seagrass" | "createWorld.customize.custom.useDungeons" | "painting.minecraft.fire.title" | "commands.clone.failed" | "item.minecraft.axolotl_bucket" | "block.minecraft.banner.stripe_right.red" | "fml.messages.version.restriction.bounded" | "subtitles.item.trident.hit_ground" | "affix.irons_spellbooks:sword/attribute/mana_regen" | "advMode.setCommand" | "config.jade.display_item_top" | "fml.menu.mods.config" | "patchouli.gui.lexicon.button.advancements" | "block.minecraft.mangrove_pressure_plate" | "commands.save.alreadyOff" | "advancements.irons_spellbooks.staff_ice.description" | "item.minecraft.melon_seeds" | "lanserverproperties.options.preference_enabled" | "commands.whitelist.list" | "block.minecraft.white_glazed_terracotta" | "multiplayer.disconnect.incompatible" | "subtitles.entity.snow_golem.hurt" | "block.minecraft.nether_bricks" | "subtitles.entity.piglin.angry" | "block.minecraft.banner.diagonal_right.yellow" | "key.keyboard.f11" | "key.keyboard.f12" | "key.keyboard.f10" | "options.accessibility.text_background" | "item.minecraft.rabbit" | "block.minecraft.mushroom_stem" | "painting.minecraft.bomb.title" | "item.minecraft.tipped_arrow.effect.weakness" | "forge.controlsgui.alt" | "block.minecraft.light_blue_glazed_terracotta" | "commands.place.feature.success" | "advancements.nether.use_lodestone.description" | "block.minecraft.crying_obsidian" | "options.allowServerListing" | "key.keyboard.f15" | "modernfix.option.mixin.bugfix.packet_leak" | "item.minecraft.music_disc_mellohi.desc" | "key.keyboard.f16" | "key.keyboard.f13" | "item.irons_spellbooks.netherite_mage_chestplate" | "key.keyboard.f14" | "key.keyboard.f19" | "key.keyboard.f17" | "options.autoSuggestCommands" | "key.keyboard.f18" | "item.minecraft.creeper_banner_pattern" | "painting.minecraft.skull_and_roses.author" | "block.minecraft.polished_blackstone_brick_slab" | "commands.playsound.success.multiple" | "advancements.nether.fast_travel.description" | "subtitles.item.trident.return" | "block.minecraft.deepslate_diamond_ore" | "book.editTitle" | "subtitles.entity.mule.chest" | "effect.irons_spellbooks.antigravity.description" | "pack.source.fabricmod" | "block.minecraft.waxed_oxidized_cut_copper_stairs" | "modernfix.option.mixin.perf.cache_model_materials" | "modernfix.option.enabled" | "mco.template.button.select" | "selectWorld.edit" | "advancements.irons_spellbooks.staff_lightning_rod.title" | "death.attack.sonic_boom.item" | "config.jade.plugin_jade.mod_name" | "spell.irons_spellbooks.burning_dash.guide" | "block.minecraft.banner.stripe_top.white" | "subtitles.entity.drowned.swim" | "commands.title.show.title.multiple" | "block.minecraft.banner.creeper.light_blue" | "commands.damage.invulnerable" | "item.minecraft.zombie_horse_spawn_egg" | "telemetry.event.world_unloaded.title" | "gui.abuseReport.reason.harassment_or_bullying" | "item.irons_spellbooks.wayward_compass_desc" | "commands.spawnpoint.success.multiple" | "enchantment.dungeonsenchantments.exploding.desc" | "spell.irons_spellbooks.sculk_tentacles.guide" | "mco.configure.world.subscription.remaining.months" | "commands.bossbar.set.color.success" | "biome.minecraft.desert" | "gui.jade.disabled_by_mods" | "commands.item.target.no_changes" | "mco.gui.ok" | "pack.source.builtinMod" | "spell.irons_spellbooks.slow.guide" | "item.minecraft.spider_eye" | "stat.minecraft.treasure_fished" | "commands.clone.toobig" | "block.minecraft.stripped_warped_stem" | "item.minecraft.glow_squid_spawn_egg" | "item.minecraft.smithing_template" | "leaves_type.minecraft.oak" | "block.minecraft.black_concrete_powder" | "block.minecraft.banner.diagonal_up_left.blue" | "enchantment.improved_exp.flight.desc" | "difficulty.lock.title" | "config.jade.overlay_pos_x_extra_msg" | "options.difficulty.online" | "argument.color.invalid" | "menu.game" | "forge.configgui.zombieBabyChance.tooltip" | "block.minecraft.banner.stripe_center.white" | "effect.irons_spellbooks.vex_timer.description" | "forge.configgui.calculateAllNormals.tooltip" | "entity.minecraft.villager.shepherd" | "block.minecraft.obsidian" | "attribute.name.horse.jump_strength" | "item.minecraft.evoker_spawn_egg" | "title.32bit.deprecation" | "resourcePack.title" | "spell.irons_spellbooks.ball_lightning" | "block.minecraft.beehive" | "item.minecraft.diamond_boots" | "key.keyboard.print.screen" | "item.minecraft.acacia_boat" | "entity.minecraft.vindicator" | "tutorial.find_tree.description" | "mco.template.select.none" | "effect.minecraft.saturation" | "commands.effect.clear.everything.success.single" | "tetra.material.irons_spellbooks_protection_rune_socket.prefix" | "block.minecraft.orange_terracotta" | "multiplayer.status.online" | "config.jei.interface.bookmarkOverlayEnabled" | "subtitles.entity.sniffer.step" | "argument.resource_tag.invalid_type" | "mco.template.name" | "entity.irons_spellbooks.small_fireball" | "subtitles.block.chest.locked" | "spell.irons_spellbooks.sunbeam" | "item.minecraft.mourner_pottery_shard" | "death.attack.irons_spellbooks.sonic_boom" | "potion.whenDrank" | "block.minecraft.warped_wall_hanging_sign" | "subtitles.entity.ghast.hurt" | "block.minecraft.verdant_froglight" | "ui.irons_spellbooks.level" | "advancements.adventure.sleep_in_bed.title" | "config.jade.overlay_pos_y_extra_msg" | "forge.configgui.cachePackAccess.tooltip" | "subtitles.block.conduit.deactivate" | "affix.irons_spellbooks:spellbook/attribute/holy_spell_power" | "block.minecraft.bamboo_mosaic" | "block.minecraft.kelp_plant" | "controls.keybinds" | "key.keyboard.right.control" | "option.cloth-config.scrollDuration" | "tutorial.look.title" | "fml.messages.artifactversion.notinstalled" | "config.jade.plugin_debug.furnace_fuel.str_cfg" | "block.minecraft.orange_stained_glass" | "advancements.adventure.craft_decorated_pot_using_only_sherds.description" | "block.minecraft.attached_pumpkin_stem" | "options.accessibility.panorama_speed" | "block.minecraft.banner.diagonal_up_left.lime" | "advMode.randomPlayer" | "block.minecraft.acacia_sign" | "subtitles.entity.player.attack.weak" | "tooltip.irons_spellbooks.mana_cost_per_second" | "item.minecraft.splash_potion.effect.invisibility" | "spell.irons_spellbooks.acid_orb" | "curios.modifiers.spellbook" | "leaves_type.minecraft.mangrove" | "block.minecraft.soul_torch" | "jei.tooltip.liquid.amount.with.capacity" | "enchantment.minecraft.punch" | "key.keyboard.page.down" | "subtitles.entity.puffer_fish.death" | "block.minecraft.cherry_sign" | "item.irons_spellbooks.shriving_stone_desc" | "death.fell.accident.ladder" | "mco.backup.button.reset" | "mco.selectServer.expiredSubscribe" | "jade.instrument.zombie" | "entity.irons_spellbooks.spectral_steed" | "block.minecraft.red_concrete" | "debug.chunk_boundaries.off" | "gamerule.commandModificationBlockLimit" | "irons_spellbooks.tetra_effect.mana_siphon" | "config.jade.plugin_jade.block_face" | "gui.banned.reason.imminent_harm_to_person_or_property" | "block.minecraft.cactus" | "tooltip.irons_spellbooks.instant_mana_description" | "sodium.options.clouds_quality.tooltip" | "spell.irons_spellbooks.chain_lightning" | "death.attack.irons_spellbooks.firebolt" | "chat.type.team.hover" | "block.titanium.block_asset_test" | "block.minecraft.dark_oak_wall_sign" | "container.upgrade.error_tooltip" | "subtitles.entity.glow_item_frame.break" | "block.minecraft.red_nether_brick_stairs" | "option.cloth-config.disableSmoothScroll" | "block.minecraft.diamond_ore" | "commands.kick.success" | "key.keyboard.keypad.subtract" | "item.irons_spellbooks.blood_vial.guide" | "block.minecraft.potted_torchflower" | "commands.forceload.toobig" | "item.minecraft.leather" | "key.categories.inventory" | "painting.minecraft.pool.title" | "multiplayer.disconnect.duplicate_login" | "createWorld.customize.custom.presets" | "options.particles.decreased" | "block.minecraft.banner.stripe_left.orange" | "optimizeWorld.confirm.title" | "config.jade.display_mode_lite" | "merchant.level.4" | "merchant.level.5" | "merchant.level.2" | "merchant.level.3" | "block.minecraft.banner.stripe_middle.lime" | "merchant.level.1" | "config.jade.plugin_jade.item_mod_name" | "commands.item.target.not_a_container" | "block.minecraft.warped_fungus" | "deathScreen.spectate" | "item.minecraft.firework_star.shape.creeper" | "block.minecraft.birch_log" | "predicate.unknown" | "effect.irons_spellbooks.planar_sight" | "block.minecraft.waxed_oxidized_cut_copper_slab" | "advancements.adventure.whos_the_pillager_now.title" | "subtitles.block.sculk_shrieker.shriek" | "tooltip.irons_spellbooks.imbue_slots" | "block.minecraft.diorite" | "fml.menu.mods.info.license" | "subtitles.entity.glow_squid.death" | "fml.modloading.brokenfile" | "sodium.options.biome_blend.value" | "item.irons_spellbooks.greater_evasion_elixir" | "item.geckolib.wolf_armor_leggings" | "mco.minigame.world.changeButton" | "debug.clear_chat.help" | "item.minecraft.parrot_spawn_egg" | "options.fullscreen.current" | "stat.minecraft.junk_fished" | "enchantment.betterarcheology.penetrating_strike.desc" | "modernfix.option.mixin.bugfix.entity_load_deadlock" | "commands.curios.add.success" | "subtitles.entity.skeleton.ambient" | "jei.tooltip.bookmarks" | "commands.whitelist.none" | "block.minecraft.banner.base.orange" | "selectWorld.backupWarning.customized" | "trim_pattern.minecraft.dune" | "advancements.story.mine_stone.title" | "advancements.husbandry.allay_deliver_item_to_player.title" | "mco.upload.cancelled" | "options.availableKeys" | "time.bookshelf.month.april" | "entity.minecraft.tropical_fish.type.kob" | "block.minecraft.composter" | "death.attack.onFire" | "item.minecraft.iron_shovel" | "item.irons_spellbooks.concentration_amulet.desc" | "block.minecraft.stripped_warped_hyphae" | "chat.copy.click" | "item.minecraft.wooden_hoe" | "enchantment.minecraft.blast_protection" | "entity.minecraft.squid" | "container.enchant.level.many" | "item.minecraft.smithing_template.armor_trim.base_slot_description" | "spell.irons_spellbooks.summon_ender_chest.guide" | "item.minecraft.lingering_potion.effect.strength" | "advancements.nether.distract_piglin.description" | "block.minecraft.banner.diagonal_left.orange" | "narration.slider.usage.focused" | "commands.team.add.duplicate" | "mco.configure.world.spawn_toggle.message.npc" | "sodium.options.translucent_face_sorting.name" | "commands.scoreboard.players.reset.all.single" | "multiplayer.disconnect.banned_ip.expiration" | "structure_block.button.load" | "block.minecraft.bubble_coral" | "commands.banip.success" | "item.minecraft.tipped_arrow.effect.invisibility" | "forge.configgui.indexModPackCachesOnThread.tooltip" | "toast.jade.toggle_hint.1" | "toast.jade.toggle_hint.2" | "entity.geckolib.fake_glass" | "subtitles.item.lodestone_compass.lock" | "biome.minecraft.jungle" | "item.minecraft.glow_ink_sac" | "entity.minecraft.piglin" | "enchantment.improved_exp.fertilizing.desc" | "config.jade.animation_extra_msg" | "block.minecraft.banner.stripe_top.green" | "fml.modmismatchscreen.table.modname" | "item.irons_spellbooks.arcane_salvage_desc" | "item.minecraft.lingering_potion.effect.poison" | "block.minecraft.banner.base.lime" | "selectWorld.createDemo" | "subtitles.entity.mule.eat" | "sodium.options.gui_scale.tooltip" | "key.jei.nextSearch" | "modernfix.option.mixin.perf.dynamic_sounds" | "spell.irons_spellbooks.poison_arrow.guide" | "gui.recipebook.toggleRecipes.craftable" | "stat.minecraft.pot_flower" | "commands.forge.entity.list.none" | "block.minecraft.banner.square_bottom_right.light_blue" | "jade.instrument.bass" | "block.minecraft.banner.triangle_top.pink" | "death.attack.irons_spellbooks.black_hole.item" | "options.showNone" | "config.jade.plugin_minecraft.potion_effects" | "item.minecraft.iron_leggings" | "death.attack.irons_spellbooks.ball_lightning.item" | "block.minecraft.light_blue_shulker_box" | "block.minecraft.yellow_shulker_box" | "options.graphics.fast.tooltip" | "itemGroup.combat" | "chat.square_brackets" | "time.bookshelf.month.november" | "message.moonlight.anti_repost" | "modifier.cloth-config.alt" | "entity.minecraft.tropical_fish.type.betty" | "attribute.irons_spellbooks.mana_regen" | "block.minecraft.deepslate_brick_stairs" | "item.minecraft.potion.effect.night_vision" | "mco.configure.world.edit.subscreen.experience" | "selectServer.deleteQuestion" | "jade.instrument.chime" | "mco.configure.world.resourcepack.question.line1" | "mco.reset.world.resetting.screen.title" | "mco.configure.world.resourcepack.question.line2" | "advancements.adventure.root.title" | "subtitles.entity.generic.explode" | "multiplayer.disconnect.not_whitelisted" | "ui.irons_spellbooks.hits_dodged" | "block.minecraft.banner.stripe_center.purple" | "spell.irons_spellbooks.ball_lightning.guide" | "death.attack.irons_spellbooks.icicle.item" | "block.minecraft.chiseled_red_sandstone" | "debug.gamemodes.error" | "commands.worldborder.set.immediate" | "team.visibility.never" | "subtitles.entity.glow_item_frame.place" | "patchouli.gui.lexicon.progress_tooltip" | "commands.locate.structure.invalid" | "ui.irons_spellbooks.portal_duration" | "painting.minecraft.skeleton.title" | "ui.irons_spellbooks.aoe_healing" | "subtitles.entity.shulker.close" | "fml.modloading.failedtoloadmod" | "block.minecraft.banner.half_horizontal_bottom.yellow" | "commands.title.show.subtitle.single" | "spell.irons_spellbooks.haste.guide" | "block.minecraft.banner.base.blue" | "item.irons_spellbooks.electromancer_boots" | "ui.irons_spellbooks.base_damage" | "block.minecraft.banner.stripe_left.lime" | "block.minecraft.banner.triangle_bottom.brown" | "commands.irons_spellbooks.generate_mod_list.failed" | "stat_type.minecraft.killed_by.none" | "forge.configgui.showLoadWarnings.tooltip" | "subtitles.block.bell.resonate" | "block.minecraft.banner.half_vertical_right.orange" | "block.minecraft.snow_block" | "structure_block.mode_info.load" | "item.minecraft.end_crystal" | "advancements.irons_spellbooks.enter_catacombs.description" | "subtitles.item.spyglass.stop_using" | "container.cartography_table" | "death.attack.irons_spellbooks.ray_of_frost" | "block.minecraft.purple_carpet" | "block.minecraft.lava" | "parsing.float.expected" | "subtitles.entity.horse.eat" | "trim_material.minecraft.diamond" | "debug.copy_location.message" | "block.minecraft.beetroots" | "telemetry.property.operating_system.title" | "attribute.irons_spellbooks.eldritch_spell_power" | "item.irons_spellbooks.archevoker_leggings" | "commands.data.modify.expected_list" | "entity.not_summonable" | "subtitles.entity.goat.milk" | "gui.socialInteractions.tab_blocked" | "subtitles.entity.drowned.ambient_water" | "block.minecraft.banner.triangles_bottom.gray" | "ui.irons_spellbooks.sacrifice_target_failure" | "subtitles.entity.potion.throw" | "commands.place.structure.invalid" | "block.minecraft.barrier" | "item.minecraft.leather_boots" | "block.minecraft.waxed_cut_copper_stairs" | "mco.terms.sentence.2" | "mco.terms.sentence.1" | "fml.messages.version.restriction.bounded.upperexclusive" | "options.framerateLimit.max" | "block.minecraft.banner.half_horizontal_bottom.red" | "enchantment.improved_exp.preview.desc" | "subtitles.block.honey_block.slide" | "item.irons_spellbooks.holy_rune" | "attribute.irons_spellbooks.lightning_spell_power" | "tetra.material.irons_spellbooks_ice_rune_socket" | "block.minecraft.banner.border.purple" | "commands.worldborder.set.failed.nochange" | "item.minecraft.powder_snow_bucket" | "block.minecraft.suspicious_sand" | "block.minecraft.banner.stripe_left.blue" | "block.minecraft.blackstone" | "subtitles.entity.hoglin.ambient" | "block.minecraft.warped_wart_block" | "key.jei.toggleWildcardHideIngredient" | "itemGroup.crafting" | "telemetry.event.world_unloaded.description" | "curios.identifier.curio" | "language.name" | "block.minecraft.banner.piglin.cyan" | "subtitles.entity.cod.hurt" | "config.jade.display_blocks" | "block.minecraft.banner.straight_cross.magenta" | "block.minecraft.tube_coral_wall_fan" | "itemGroup.irons_spellbooks.spellbook_scrolls_tab" | "subtitles.block.water.ambient" | "sodium.options.view_bobbing.tooltip" | "entity.minecraft.dragon_fireball" | "block.minecraft.red_terracotta" | "enchantment.improved_exp.night_vision.desc" | "item.irons_spellbooks.lurker_ring" | "jei.tooltip.cheat.mode.how.to.disable.hover.config.button.hotkey" | "block.minecraft.polished_blackstone_button" | "entity.minecraft.tropical_fish.type.spotty" | "block.minecraft.coal_block" | "block.minecraft.banner.creeper.yellow" | "painting.minecraft.wasteland.author" | "subtitles.entity.llama.step" | "createWorld.customize.custom.useVillages" | "death.attack.trident.item" | "block.minecraft.banner.stripe_center.light_blue" | "commands.tag.list.single.empty" | "subtitles.entity.piglin.hurt" | "enchantment.hunterillager.bounce.desc" | "entity.minecraft.axolotl" | "item.minecraft.raw_gold" | "block.minecraft.white_wool" | "block.minecraft.dark_oak_fence" | "tetra.material.irons_spellbooks_evocation_rune_socket.prefix" | "commands.fill.toobig" | "multiplayer.disconnect.banned" | "block.irons_spellbooks.scroll_forge" | "item.minecraft.potion.effect.harming" | "item.minecraft.cookie" | "config.jade.boss_bar_overlap_extra_msg" | "block.minecraft.banner.square_bottom_right.blue" | "block.minecraft.banner.square_top_right.blue" | "createWorld.customize.custom.biomeSize" | "item.minecraft.leather_leggings" | "death.attack.irons_spellbooks.firebolt.item" | "asynclocator.map.locating" | "mco.configure.world.buttons.settings" | "block.minecraft.dried_kelp_block" | "tooltip.jade.state" | "mco.configure.world.buttons.resetworld" | "modmenu.nameTranslation.jade" | "block.minecraft.sunflower" | "block.minecraft.banner.square_bottom_right.black" | "block.minecraft.redstone_wire" | "item.minecraft.blade_pottery_sherd" | "block.minecraft.banner.triangles_bottom.black" | "config.jade.edit_blocklist" | "advancements.husbandry.safely_harvest_honey.description" | "menu.returnToMenu" | "enchantment.minecraft.smite.desc" | "pack.forge.description" | "commands.function.success.multiple.result" | "config.jade.plugin_minecraft.waxed" | "block.minecraft.banner.creeper.lime" | "options.prioritizeChunkUpdates" | "item.minecraft.potion.effect.water" | "moon.phase.waxing.gibbous" | "item.minecraft.snow_golem_spawn_egg" | "block.minecraft.bamboo_wall_hanging_sign" | "book.signButton" | "telemetry.property.event_timestamp_utc.title" | "subtitles.entity.zombie.hurt" | "subtitles.block.respawn_anchor.set_spawn" | "biome.minecraft.frozen_river" | "item.minecraft.tipped_arrow.effect.regeneration" | "subtitles.entity.firework_rocket.launch" | "effect.irons_spellbooks.heartstop" | "translation.test.invalid" | "item.irons_spellbooks.plagued_chestplate" | "item.minecraft.endermite_spawn_egg" | "subtitles.entity.shulker.hurt" | "spell.irons_spellbooks.sunbeam.guide" | "fml.menu.multiplayer.incompatible" | "block.minecraft.jungle_leaves" | "subtitles.entity.bee.loop_aggressive" | "createWorld.customize.custom.preset.caveDelight" | "painting.minecraft.kebab.title" | "commands.irons_spellbooks.create_scroll.failed" | "death.attack.irons_spellbooks.devour.item" | "text.cloth-config.error.not_valid_number_int" | "commands.forge.tags.containing_tag_count" | "gamerule.category.mobs" | "recipe.toast.title" | "createWorld.preparing" | "block.minecraft.horn_coral_block" | "key.sneak" | "options.ao" | "advancements.story.enter_the_nether.description" | "block.minecraft.banner.square_bottom_right.lime" | "enchantment.improved_exp.professional_rider.desc" | "block.minecraft.banner.triangle_top.orange" | "options.modelPart.left_sleeve" | "key.keyboard.right.win" | "block.minecraft.mossy_stone_bricks" | "options.modelPart.hat" | "subtitles.ui.cartography_table.take_result" | "sodium.option_impact.extreme" | "modernfix.option.mixin.perf.faster_item_rendering" | "gameMode.hardcore" | "key.jei.nextPage" | "selectWorld.backupJoinSkipButton" | "item.minecraft.iron_boots" | "narrator.button.difficulty_lock" | "block.minecraft.mossy_stone_brick_wall" | "spell.irons_spellbooks.abyssal_shroud.guide" | "key.jei.recipeBack" | "gui.minutes" | "entity.irons_spellbooks.gust" | "options.chat.visibility.hidden" | "block.minecraft.banner.small_stripes.white" | "block.minecraft.white_terracotta" | "item.minecraft.flower_pot" | "block.minecraft.potted_oxeye_daisy" | "selectWorld.gameMode.spectator.line2" | "selectWorld.gameMode.spectator.line1" | "block.minecraft.banner.creeper.blue" | "jade.locked" | "item.irons_spellbooks.evoker_fort_battle_plans" | "pack.name.fabricMod" | "key.hotbar.8" | "commands.publish.success" | "key.hotbar.7" | "config.jade.overlay" | "patchouli.gui.lexicon.button.visualize.info" | "key.hotbar.6" | "key.hotbar.5" | "subtitles.entity.evoker.cast_spell" | "key.hotbar.4" | "key.hotbar.3" | "key.hotbar.2" | "key.hotbar.1" | "mco.configure.world.backup" | "block.minecraft.banner.globe.gray" | "itemGroup.hotbar" | "block.minecraft.banner.skull.red" | "item.minecraft.mushroom_stew" | "sodium.options.leaves_quality.name" | "block.minecraft.banner.gradient.cyan" | "gui.chatReport.comments" | "commands.worldborder.center.failed" | "item.irons_spellbooks.upgrade_orb" | "block.irons_spellbooks.firefly_jar" | "subtitles.entity.sniffer.hurt" | "key.hotbar.9" | "commands.item.source.no_such_slot" | "advancements.irons_spellbooks.spell_book_blaze.title" | "advancements.nether.distract_piglin.title" | "options.showConflicts" | "item.irons_spellbooks.shadowwalker_helmet" | "block.minecraft.quartz_bricks" | "multiplayer.socialInteractions.not_available" | "block.minecraft.chiseled_quartz_block" | "subtitles.entity.vex.death" | "selectWorld.warning.experimental.title" | "spectatorMenu.teleport.prompt" | "subtitles.block.decorated_pot.shatter" | "jei.chat.error.no.cheat.permission.op" | "tutorial.bundleInsert.title" | "block.minecraft.purple_concrete_powder" | "subtitles.entity.blaze.shoot" | "block.minecraft.bookshelf" | "block.minecraft.blue_shulker_box" | "subtitles.entity.sniffer.eat" | "death.attack.onFire.item" | "item.minecraft.potion.effect.empty" | "commands.scoreboard.players.get.null" | "item.geckolib.gecko_armor_leggings" | "mco.time.minutesAgo" | "death.fell.finish.item" | "createWorld.customize.custom.spread" | "commands.irons_spellbooks.create_debug_wizard.failed" | "modernfix.option.mixin.perf.fast_registry_validation" | "chat.link.open" | "block.minecraft.banner.diagonal_up_right.green" | "commands.forge.entity.list.single.header" | "block.minecraft.banner.gradient_up.magenta" | "menu.shareToLan" | "block.minecraft.polished_blackstone_wall" | "block.minecraft.tripwire_hook" | "argument.entity.options.dy.description" | "block.minecraft.banner.stripe_middle.light_gray" | "block.minecraft.smooth_red_sandstone" | "block.minecraft.candle" | "item.irons_spellbooks.lightning_upgrade_orb" | "block.minecraft.banner.circle.blue" | "commands.recipe.take.failed" | "mco.errorMessage.realmsService.realmsError" | "spell.irons_spellbooks.ray_of_frost" | "item.minecraft.shulker_shell" | "multiplayer.disconnect.invalid_public_key_signature.new" | "biome.minecraft.frozen_ocean" | "commands.datapack.unknown" | "soundCategory.music" | "jei.tooltip.error.crash" | "subtitles.entity.villager.work_cartographer" | "spell.irons_spellbooks.teleport" | "commands.whitelist.add.failed" | "subtitles.entity.player.attack.knockback" | "sodium.options.use_persistent_mapping.tooltip" | "death.attack.even_more_magic" | "config.jei.advanced.maxRecipeGuiHeight.comment" | "enchantment.minecraft.fortune" | "mco.template.select.narrate.authors" | "death.attack.irons_spellbooks.ice_block" | "death.attack.wither" | "text.cloth-config.error.not_valid_number_double" | "advancements.nether.uneasy_alliance.description" | "key.keyboard.tab" | "options.biomeBlendRadius.13" | "options.biomeBlendRadius.15" | "enchantment.minecraft.loyalty.desc" | "gamerule.disableRaids" | "options.biomeBlendRadius.11" | "subtitles.entity.evoker.hurt" | "spell.irons_spellbooks.haste" | "item.apotheosis.gem.irons_spellbooks:summoning" | "structure_block.detect_size" | "block.minecraft.end_portal" | "spell.irons_spellbooks.devour" | "block.minecraft.black_banner" | "disconnect.loginFailed" | "block.minecraft.banner.diagonal_up_right.black" | "block.minecraft.tube_coral_block" | "enchantment.minecraft.channeling" | "subtitles.entity.endermite.ambient" | "spell.irons_spellbooks.arrow_volley.guide" | "patchouli.gui.lexicon.shift_for_recipe" | "block.minecraft.banner.stripe_left.magenta" | "block.minecraft.banner.square_top_right.lime" | "createWorld.customize.flat.layer.bottom" | "item.irons_spellbooks.ender_upgrade_orb" | "tutorial.craft_planks.title" | "item.minecraft.pottery_shard_arms_up" | "instrument.minecraft.feel_goat_horn" | "subtitles.entity.sniffer.searching" | "item.minecraft.potion.effect.luck" | "sodium.options.use_entity_culling.name" | "block.minecraft.purple_wool" | "options.chat.delay" | "spell.irons_spellbooks.heal" | "block.minecraft.yellow_concrete_powder" | "item.minecraft.potion.effect.thick" | "block.minecraft.banner.stripe_left.green" | "entity.minecraft.tadpole" | "modernfix.option.category.troubleshooting.description" | "item.minecraft.tropical_fish_bucket" | "lanserverproperties.options.online_mode.off.fixed.message" | "argument.entity.options.z.description" | "argument.entity.options.limit.toosmall" | "gamerule.doDaylightCycle" | "block.minecraft.banner.circle.lime" | "commands.forge.tags.element_count" | "block.minecraft.banner.skull.yellow" | "block.minecraft.dirt" | "build.tooHigh" | "item.irons_spellbooks.pyromancer_chestplate" | "advancements.nether.charge_respawn_anchor.description" | "subtitles.item.shield.block" | "config.jade.plugin_jade.registry_name_advanced_tooltips" | "narration.jade.distance" | "death.attack.poison_cloud.item" | "mco.configure.world.subscription.expired" | "key.jade.toggle_liquid" | "container.stonecutter" | "item.irons_spellbooks.holy_upgrade_orb" | "commands.title.show.title.single" | "subtitles.item.glow_ink_sac.use" | "fml.button.continue.launch" | "telemetry.property.realms_map_content.title" | "commands.forge.entity.list.invalid" | "patchouli.gui.lexicon.objective" | "options.particles" | "subtitles.item.bucket.fill" | "block.minecraft.white_tulip" | "gamerule.keepInventory" | "block.minecraft.banner.stripe_downright.purple" | "block.minecraft.banner.creeper.brown" | "block.minecraft.yellow_candle" | "subtitles.entity.parrot.imitate.ghast" | "jade.beehive.bees" | "block.minecraft.gray_wool" | "gui.banned.reason.hate_terrorism_notorious_figure" | "gamerule.doWeatherCycle" | "item.minecraft.firework_star.gray" | "debug.copy_location.help" | "gui.abuseReport.send.error_message" | "direction.titanium.south" | "effect.irons_spellbooks.planar_sight.description" | "caelus.fallFlying" | "createWorld.tab.game.title" | "gui.chatReport.discard.draft" | "subtitles.entity.villager.work_butcher" | "trim_pattern.minecraft.host" | "block.minecraft.banner.skull.light_blue" | "recipe.toast.description" | "item.minecraft.leather_horse_armor" | "block.minecraft.banner.stripe_downleft.magenta" | "block.minecraft.soul_campfire" | "spell.irons_spellbooks.poison_breath" | "block.minecraft.nether_brick_slab" | "entity.minecraft.trader_llama" | "block.minecraft.nether_wart_block" | "item.irons_spellbooks.antiquated_compass_desc" | "effect.irons_spellbooks.oakskin" | "spell.irons_spellbooks.magic_arrow.guide" | "createWorld.customize.flat.tile" | "mco.invites.button.accept" | "patchouli.gui.lexicon.history" | "tetra.stats.irons_spellbooks:freeze" | "multiplayerWarning.header" | "item.irons_spellbooks.enchanted_ward_amulet_desc" | "block.minecraft.granite_wall" | "commands.help.failed" | "mco.configure.world.buttons.edit" | "multiplayer.status.and_more" | "config.jei.interface.bookmarkOverlayEnabled.comment" | "advMode.setCommand.success" | "modernfix.option.mixin.perf.twilightforest.structure_spawn_fix" | "commands.fillbiome.success" | "commands.jfr.started" | "container.shulkerBox" | "item.irons_spellbooks.wandering_magician_helmet" | "forge.configgui.indexVanillaPackCachesOnThread.tooltip" | "item.irons_spellbooks.alchemical_trade_route" | "advancements.end.levitate.title" | "selectWorld.recreate.customized.title" | "block.minecraft.crimson_stairs" | "item.minecraft.music_disc_chirp.desc" | "createWorld.customize.custom.lavaLakeChance" | "spell.irons_spellbooks.ice_block" | "block.minecraft.cobbled_deepslate_stairs" | "block.minecraft.tripwire" | "enchantment.minecraft.infinity" | "telemetry.event.optional" | "config.jei.mode.cheatItemsEnabled.comment" | "block.minecraft.lever" | "block.minecraft.oak_stairs" | "death.attack.outsideBorder" | "options.narrator.notavailable" | "subtitles.entity.wandering_trader.trade" | "argument.entity.selector.allEntities" | "jei.tooltip.recipe.id" | "container.lectern" | "subtitles.entity.cat.hurt" | "enchantment.improved_exp.treatment.desc" | "block.minecraft.sandstone_stairs" | "subtitles.entity.horse.death" | "block.minecraft.polished_blackstone_brick_stairs" | "ui.irons_spellbooks.research_warning" | "advancements.husbandry.balanced_diet.title" | "subtitles.item.trident.riptide" | "block.minecraft.beacon.primary" | "jei.tooltip.recipe.by" | "block.minecraft.banner.stripe_top.gray" | "block.minecraft.acacia_wall_sign" | "createWorld.customize.buffet.biome" | "spell.irons_spellbooks.blessing_of_life" | "subtitles.entity.sniffer.digging_stop" | "direction.titanium.north" | "item.minecraft.pink_dye" | "modernfix.option.mixin.feature.spam_thread_dump" | "item.minecraft.coal" | "spell.irons_spellbooks.acupuncture" | "entity.minecraft.evoker_fangs" | "ui.irons_spellbooks.cast_error_adventure" | "options.simulationDistance" | "block.minecraft.banner.circle.light_gray" | "death.attack.irons_spellbooks.magic_arrow" | "block.minecraft.dead_brain_coral_wall_fan" | "block.minecraft.magenta_shulker_box" | "death.attack.arrow.item" | "subtitles.entity.vindicator.ambient" | "block.minecraft.infested_cobblestone" | "enchantment.minecraft.silk_touch" | "block.irons_spellbooks.pedestal" | "block.minecraft.tube_coral" | "item.minecraft.creeper_spawn_egg" | "options.on" | "spell.irons_spellbooks.firefly_swarm.guide" | "advancements.husbandry.plant_seed.description" | "block.minecraft.banner.diagonal_right.light_blue" | "gamerule.forgiveDeadPlayers" | "commands.save.disabled" | "block.minecraft.banner.stripe_center.black" | "tooltip.titanium.facing_handler.top" | "commands.tag.add.failed" | "subtitles.entity.camel.ambient" | "item.minecraft.friend_pottery_sherd" | "mco.upload.select.world.title" | "subtitles.entity.villager.work_weaponsmith" | "effect.minecraft.dolphins_grace" | "mco.minigame.world.info.line1" | "gameMode.creative" | "enchantment.improved_exp.constant_surveillance.desc" | "item.minecraft.chorus_fruit" | "mco.minigame.world.info.line2" | "advancements.adventure.trade.description" | "options.fov" | "block.minecraft.banner.stripe_left.black" | "block.minecraft.banner.triangles_bottom.green" | "spell.irons_spellbooks.fire_breath" | "debug.inspect.server.entity" | "item.minecraft.flint" | "selectWorld.cheats" | "item.irons_spellbooks.poisonward_ring.desc" | "block.minecraft.polished_deepslate" | "subtitles.entity.parrot.imitate.elder_guardian" | "forge.configgui.skipEmptyShapelessCheck.tooltip" | "item.minecraft.explorer_pottery_sherd" | "key.keyboard.right" | "stat.minecraft.time_since_rest" | "title.multiplayer.realms" | "addServer.resourcePack.disabled" | "advancements.nether.explore_nether.title" | "block.minecraft.banner.triangle_bottom.orange" | "spell.irons_spellbooks.flaming_strike" | "block.minecraft.banner.half_vertical.blue" | "debug.prefix" | "stat.minecraft.time_since_death" | "subtitles.block.lava.extinguish" | "item.irons_spellbooks.dragonskin" | "block.minecraft.banner.square_bottom_right.orange" | "mco.upload.uploading" | "options.chat.links.prompt" | "tooltip.titanium.facing_handler.test" | "block.minecraft.banner.stripe_center.green" | "forge.entity_reach" | "block.minecraft.banner.half_horizontal.orange" | "gui.back" | "death.attack.dryout" | "key.irons_spellbooks.spell_bar_modifier" | "biome.minecraft.sparse_jungle" | "subtitles.entity.shulker.teleport" | "wood_type.minecraft.cherry" | "enchantment.minecraft.aqua_affinity.desc" | "config.moonlight.general.lazy_map_upload.description" | "advancements.story.iron_tools.description" | "jade.tnt.unstable" | "argument.entity.selector.nearestPlayer" | "item.minecraft.bucket" | "structure_block.structure_name" | "entity.geckolib.bike" | "commands.scoreboard.players.operation.success.multiple" | "advancements.irons_spellbooks.staff_artificer.title" | "argument.gamemode.invalid" | "enchantment.minecraft.channeling.desc" | "commands.forge.tracking.invalid" | "block.minecraft.banner.small_stripes.black" | "item.irons_spellbooks.illusioner_spell_book" | "enchantment.shieldsplus.aegis.desc" | "block.minecraft.yellow_glazed_terracotta" | "config.jade.plugin_minecraft.harvest_tool.effective_tool" | "tetra.material.irons_spellbooks_blood_rune_socket" | "block.minecraft.brown_shulker_box" | "block.minecraft.lily_of_the_valley" | "block.minecraft.twisting_vines" | "block.minecraft.banner.bricks.pink" | "death.attack.irons_spellbooks.ball_lightning" | "subtitles.entity.player.hurt" | "subtitles.ui.loom.take_result" | "gui.socialInteractions.server_label.single" | "affix.irons_spellbooks:spellbook/attribute/ender_spell_power.suffix" | "item.irons_spellbooks.dev_staff" | "commands.stopsound.success.sourceless.sound" | "mco.backup.entry.gameDifficulty" | "block.minecraft.banner.gradient_up.yellow" | "subtitles.entity.panda.aggressive_ambient" | "death.attack.heartstop" | "argument.scoreHolder.empty" | "advMode.nearestPlayer" | "ui.irons_spellbooks.percent_damage" | "block.minecraft.crimson_hanging_sign" | "enchantment.improved_exp.unstable.desc" | "advancements.nether.obtain_blaze_rod.title" | "advancements.irons_spellbooks.make_inscription_table.description" | "block.minecraft.banner.straight_cross.yellow" | "advancements.story.root.title" | "block.minecraft.pumpkin_stem" | "argument.nbt.expected.key" | "stat.minecraft.traded_with_villager" | "mco.download.done" | "sodium.options.autosave_indicator.tooltip" | "modernfix.option.mixin.perf.deduplicate_location" | "subtitles.entity.horse.jump" | "item.minecraft.poisonous_potato" | "options.difficulty.normal" | "options.darkMojangStudiosBackgroundColor.tooltip" | "ui.irons_spellbooks.summon_despawn_message" | "block.minecraft.banner.stripe_right.purple" | "block.minecraft.banner.half_vertical.lime" | "advancements.irons_spellbooks.magic_aura.title" | "argument.entity.options.scores.description" | "block.minecraft.banner.piglin.yellow" | "painting.minecraft.fighters.title" | "commands.forge.tags.element" | "selectWorld.gameMode.hardcore.info" | "subtitles.entity.illusioner.cast_spell" | "debug.help.help" | "block.minecraft.magenta_candle_cake" | "spell.irons_spellbooks.spectral_hammer" | "commands.publish.started" | "config.jade.display_tooltip_desc" | "biome.minecraft.windswept_hills" | "block.minecraft.tube_coral_fan" | "death.attack.anvil.player" | "tooltip.jade.empty" | "subtitles.entity.ghast.shoot" | "enchantment.minecraft.binding_curse.desc" | "item.geckolib.race_car_spawn_egg" | "parsing.double.invalid" | "subtitles.block.sculk.spread" | "spell.irons_spellbooks.acid_orb.guide" | "item.minecraft.donkey_spawn_egg" | "deathScreen.title" | "options.notifications.display_time" | "effect.irons_spellbooks.slowed" | "death.attack.blood_magic" | "enchantment.improved_exp.evasion.desc" | "structure_block.button.save" | "block.minecraft.banner.small_stripes.cyan" | "block.minecraft.potted_azure_bluet" | "structure_block.mode_info.save" | "options.skinCustomisation" | "gui.socialInteractions.tab_hidden" | "ui.irons_spellbooks.empty_slot" | "disconnect.loginFailedInfo.invalidSession" | "ui.irons_spellbooks.healing" | "patchouli.gui.lexicon.add_bookmark" | "mco.upload.close.failure" | "curios.modifiers.head" | "subtitles.block.anvil.destroy" | "spell.irons_spellbooks.poison_splash" | "color.minecraft.purple" | "enchantment.betterarcheology.soaring_winds.desc" | "options.touchscreen" | "createWorld.customize.custom.useLavaLakes" | "item.minecraft.salmon_spawn_egg" | "item.minecraft.yellow_dye" | "commands.locate.poi.not_found" | "block.minecraft.soul_sand" | "stat.minecraft.raid_win" | "spell.irons_spellbooks.counterspell" | "subtitles.entity.donkey.ambient" | "death.attack.stalagmite.player" | "item.minecraft.shield.magenta" | "jade.error" | "patchouli.gui.lexicon.editor" | "item.minecraft.knowledge_book" | "parsing.quote.expected.end" | "item.minecraft.clock" | "config.jade.tts_mode" | "block.minecraft.banner.mojang.green" | "block.minecraft.banner.triangle_bottom.blue" | "entity.minecraft.tropical_fish.predefined.20" | "item.minecraft.splash_potion.effect.poison" | "block.minecraft.bedrock" | "attribute.irons_spellbooks.nature_magic_resist" | "entity.minecraft.tropical_fish.predefined.13" | "item.irons_spellbooks.archevoker_chestplate" | "entity.minecraft.tropical_fish.predefined.12" | "entity.minecraft.tropical_fish.predefined.11" | "entity.minecraft.tropical_fish.predefined.10" | "commands.forge.entity.list.invalidworld" | "advancements.nether.find_bastion.description" | "block.minecraft.brown_banner" | "entity.minecraft.tropical_fish.predefined.17" | "entity.minecraft.tropical_fish.predefined.16" | "entity.minecraft.tropical_fish.predefined.15" | "entity.minecraft.tropical_fish.predefined.14" | "modernfix.option.mixin.perf.faster_texture_loading" | "item.minecraft.tipped_arrow" | "entity.minecraft.tropical_fish.predefined.19" | "entity.minecraft.tropical_fish.predefined.18" | "block.minecraft.banner.curly_border.pink" | "block.minecraft.banner.stripe_left.light_blue" | "block.minecraft.dead_bubble_coral_wall_fan" | "death.attack.cramming.player" | "block.minecraft.banner.triangles_bottom.orange" | "sodium.options.leaves_quality.tooltip" | "block.minecraft.polished_granite_slab" | "options.clouds.fancy" | "config.jade.plugin_minecraft.waxed_desc" | "item.irons_spellbooks.arcane_essence" | "advancements.end.respawn_dragon.title" | "block.minecraft.banner.triangle_bottom.yellow" | "advancements.husbandry.obtain_sniffer_egg.description" | "block.minecraft.stone_stairs" | "stat.minecraft.total_world_time" | "block.minecraft.banner.bricks.purple" | "item.minecraft.warped_fungus_on_a_stick" | "spell.irons_spellbooks.icicle" | "item.minecraft.music_disc_cat.desc" | "item.minecraft.wooden_pickaxe" | "death.attack.thorns" | "block.minecraft.light_blue_stained_glass_pane" | "key.back" | "block.minecraft.banner.skull.brown" | "item.minecraft.piglin_banner_pattern" | "block.minecraft.banner.diagonal_up_left.light_gray" | "telemetry_info.screen.title" | "block.minecraft.banner.stripe_downleft.lime" | "commands.datapack.list.enabled.none" | "block.minecraft.dead_tube_coral" | "subtitles.entity.ravager.ambient" | "advancements.husbandry.wax_off.description" | "block.minecraft.banner.half_horizontal_bottom.cyan" | "commands.execute.conditional.fail_count" | "itemGroup.op" | "subtitles.entity.axolotl.hurt" | "block.minecraft.small_dripleaf" | "item.minecraft.sugar" | "config.jade.plugin_debug.furnace_fuel" | "argument.entity.options.limit.description" | "block.minecraft.banner.curly_border.green" | "jade.blockFace" | "modernfix.no_ferritecore" | "item.minecraft.music_disc_13.desc" | "jadeaddons.deepresonance.id" | "commands.weather.set.rain" | "advMode.mode.conditional" | "block.minecraft.blue_candle_cake" | "color.minecraft.pink" | "advancements.nether.brew_potion.title" | "block.minecraft.mangrove_sign" | "advancements.adventure.hero_of_the_village.description" | "key.modernfix" | "item.minecraft.music_disc_wait" | "jade.north" | "block.minecraft.light_blue_candle_cake" | "item.minecraft.firework_star.custom_color" | "subtitles.block.sign.waxed_interact_fail" | "death.attack.generic" | "subtitles.entity.turtle.hurt" | "container.enchant.level.one" | "stat.minecraft.use_cauldron" | "affix.irons_spellbooks:spellbook/attribute/nature_spell_power.suffix" | "jade.south" | "item.minecraft.potion.effect.leaping" | "subtitles.entity.parrot.ambient" | "jade.instrument.guitar" | "item.minecraft.potato" | "mco.notification.visitUrl.message.default" | "painting.minecraft.wither.title" | "config.jade.plugin_minecraft.beehive_extra_msg" | "gui.chatReport.select_chat" | "block.minecraft.banner.stripe_right.brown" | "block.minecraft.banner.triangle_bottom.lime" | "subtitles.block.beacon.ambient" | "mco.backup.button.upload" | "subtitles.item.armor.equip_iron" | "block.minecraft.cherry_leaves" | "subtitles.entity.drowned.hurt" | "advancements.story.upgrade_tools.description" | "block.minecraft.fire_coral_block" | "tooltip.titanium.facing_handler.back" | "item.minecraft.shield.green" | "narration.component_list.usage" | "spell.irons_spellbooks.root" | "tetra.material.irons_spellbooks_nature_rune_socket" | "argument.entity.options.unterminated" | "block.minecraft.small_amethyst_bud" | "mco.configure.world.description" | "time.bookshelf.day.tuesday" | "block.minecraft.banner.diagonal_up_right.light_blue" | "biome.minecraft.grove" | "commands.forge.tracking.entity.reset" | "block.minecraft.nether_sprouts" | "block.minecraft.creeper_wall_head" | "config.jade.reset_settings" | "debug.reload_resourcepacks.help" | "optimizeWorld.info.total" | "key.jei.toggleEditMode" | "entity.minecraft.giant" | "subtitles.block.fence_gate.toggle" | "config.jade.plugin_minecraft.container_entity" | "curios.identifier.spellbook" | "item.minecraft.smithing_template.applies_to" | "advancements.husbandry.froglights.title" | "death.attack.irons_spellbooks.thunder_step.item" | "modernfix.option.mixin.perf.faster_texture_stitching" | "block.minecraft.banner.triangle_top.light_gray" | "block.minecraft.banner.flower.light_gray" | "block.minecraft.banner.skull.blue" | "block.minecraft.green_concrete" | "gui.socialInteractions.narration.show" | "argument.pos.missing.double" | "block.minecraft.potted_brown_mushroom" | "menu.convertingLevel" | "advancements.irons_spellbooks.magic_aura.description" | "soundCategory.hostile" | "block.minecraft.orange_concrete_powder" | "block.minecraft.smithing_table" | "mco.configure.world.subscription.start" | "entity.irons_spellbooks.echoing_strike" | "config.jade.plugin_minecraft.enchantment_power" | "stat.minecraft.ring_bell" | "itemGroup.irons_spellbooks.spell_materials_tab" | "selectWorld.gameMode.adventure.info" | "subtitles.entity.puffer_fish.blow_out" | "item.minecraft.wither_skeleton_spawn_egg" | "block.minecraft.banner.triangles_bottom.white" | "gui.chatReport.discard.discard" | "subtitles.block.tripwire.click" | "subtitles.entity.cod.flop" | "entity.minecraft.tropical_fish.predefined.21" | "commands.scoreboard.players.add.success.multiple" | "death.fell.killer" | "item.minecraft.quartz" | "item.modifiers.mainhand" | "options.graphics.fancy" | "structure_block.save_failure" | "block.minecraft.banner.square_bottom_right.white" | "structure_block.integrity.seed" | "itemGroup.natural" | "subtitles.entity.warden.heartbeat" | "tetra.variant.sword_socket/permafrost_shard" | "options.mainHand.right" | "subtitles.entity.parrot.eats" | "jei.tooltip.not.enough.space" | "mco.template.button.publisher" | "fml.menu.mods.info.changelogheader" | "mco.configure.world.close.question.line1" | "mco.configure.world.close.question.line2" | "block.minecraft.banner.stripe_center.red" | "subtitles.entity.parrot.imitate.evoker" | "block.minecraft.banner.curly_border.black" | "item.minecraft.prismarine_shard" | "item.minecraft.slime_spawn_egg" | "options.skinCustomisation.title" | "subtitles.entity.parrot.imitate.guardian" | "block.minecraft.banner.half_horizontal.blue" | "jade.instrument.flute" | "block.minecraft.sandstone" | "item.geckolib.bike_spawn_egg" | "config.jade.plugin_minecraft.block_states" | "multiplayer.unsecureserver.toast.title" | "narration.suggestion" | "spell.irons_spellbooks.blood_slash" | "entity.minecraft.villager.farmer" | "config.jei.interface" | "attribute.modifier.plus.0" | "gui.abuseReport.reason.terrorism_or_violent_extremism" | "attribute.modifier.plus.2" | "attribute.modifier.plus.1" | "block.minecraft.banner.triangle_top.green" | "telemetry.property.game_version.title" | "block.minecraft.brown_mushroom" | "commands.setblock.failed" | "block.minecraft.lodestone" | "commands.item.entity.set.success.single" | "gui.banned.reason.fraud" | "entity.irons_spellbooks.summoned_polar_bear" | "block.minecraft.stone_brick_wall" | "subtitles.entity.llama.swag" | "enchantment.improved_exp.bury.desc" | "commands.scoreboard.players.reset.all.multiple" | "gamerule.tntExplosionDropDecay.description" | "entity.minecraft.furnace_minecart" | "attribute.name.generic.flying_speed" | "patchouli.gui.lexicon.view" | "gui.socialInteractions.tooltip.hide" | "block.minecraft.soul_fire" | "item.irons_spellbooks.wimpy_spell_book" | "tooltip.irons_spellbooks.upgrade_plus_format" | "death.fell.accident.generic" | "mco.configure.world.delete.question.line1" | "gui.advancements" | "selectWorld.conversion" | "item.minecraft.iron_hoe" | "mco.configure.world.delete.question.line2" | "mco.selectServer.purchase" | "block.minecraft.magenta_carpet" | "item.minecraft.shield.black" | "block.minecraft.banner.piglin.orange" | "sodium.options.mipmap_levels.tooltip" | "commands.ride.mount.failure.loop" | "commands.setworldspawn.success" | "commands.pardon.success" | "item.minecraft.music_disc_ward" | "block.minecraft.blue_orchid" | "menu.savingChunks" | "block.minecraft.banner.flower.brown" | "commands.jfr.start.failed" | "stat.mobsButton" | "spell.irons_spellbooks.fortify.guide" | "text.cloth-config.restart_required_sub" | "block.minecraft.banner.stripe_center.brown" | "createWorld.customize.custom.seaLevel" | "__support_deeperdarker" | "block.minecraft.red_candle_cake" | "block.minecraft.gray_concrete" | "mco.minigame.world.starting.screen.title" | "death.attack.irons_spellbooks.flaming_strike.item" | "block.minecraft.light_weighted_pressure_plate" | "subtitles.entity.drowned.death" | "commands.forge.tps.summary.named" | "commands.bossbar.set.value.unchanged" | "block.minecraft.black_stained_glass" | "entity.minecraft.endermite" | "commands.team.option.collisionRule.success" | "pack.folderInfo" | "item.irons_spellbooks.archevoker_log" | "spell.irons_spellbooks.oakskin" | "block.minecraft.banner.stripe_downleft.blue" | "block.minecraft.red_nether_bricks" | "block.minecraft.banner.square_top_right.yellow" | "forge.block_reach" | "argument.entity.options.gamemode.description" | "lanServer.port.invalid" | "entity.irons_spellbooks.void_tentacle" | "block.minecraft.banner.half_horizontal.lime" | "block.minecraft.banner.circle.purple" | "sodium.options.vignette.name" | "commands.scoreboard.players.list.entity.empty" | "block.minecraft.emerald_block" | "item.minecraft.pufferfish" | "block.minecraft.banner.stripe_downleft.orange" | "death.attack.bleed_effect" | "enchantment.minecraft.feather_falling" | "enchantment.shieldsplus.reflection.desc" | "affix.irons_spellbooks:sword/attribute/spell_power.suffix" | "commands.tag.list.single.success" | "fml.messages.artifactversion" | "advancements.adventure.kill_a_mob.description" | "options.confirmReset" | "block.minecraft.smooth_quartz_slab" | "item.irons_spellbooks.poisonward_ring" | "entity.irons_spellbooks.frozen_humanoid" | "stat_type.minecraft.picked_up" | "commands.forceload.added.failure" | "gamerule.maxCommandChainLength" | "entity.irons_spellbooks.dead_king_corpse" | "block.minecraft.gold_ore" | "block.minecraft.lime_stained_glass_pane" | "stat.minecraft.fish_caught" | "commands.teleport.success.location.multiple" | "item.minecraft.pottery_shard_skull" | "sodium.options.graphics_quality.tooltip" | "options.chat.height.focused" | "item.minecraft.written_book" | "multiplayer.disconnect.unsigned_chat" | "key.jei.toggleBookmarkOverlay" | "forge.configgui.stabilizeDirectionGetNearest.tooltip" | "enchantment.minecraft.mending" | "commands.curios.lock.success" | "item.minecraft.beetroot" | "gamerule.blockExplosionDropDecay.description" | "item.minecraft.string" | "option.cloth-config.bounceBackMultiplier" | "commands.execute.blocks.toobig" | "subtitles.entity.piglin_brute.converted_to_zombified" | "embeddium.options.added_by_mod_string" | "gui.recipebook.toggleRecipes.smokable" | "entity.irons_spellbooks.sculk_tentacle" | "subtitles.entity.sniffer.sniffing" | "stat.minecraft.damage_taken" | "modernfix.option.mixin.bugfix.model_data_manager_cme" | "block.minecraft.banner.square_bottom_right.red" | "__support_gofish" | "tooltip.irons_spellbooks.spellbook_tooltip" | "generator.minecraft.single_biome_surface" | "createWorld.customize.custom.biomeDepthOffset" | "modernfix.option.mixin.bugfix.blueprint_modif_memory_leak" | "tooltip.jade.delay" | "advancements.husbandry.fishy_business.description" | "selectServer.deleteButton" | "subtitles.entity.evoker.ambient" | "block.minecraft.pink_stained_glass_pane" | "enchantment.minecraft.unbreaking" | "item.minecraft.music_disc_blocks" | "createWorld.customize.custom.upperLimitScale" | "item.minecraft.lava_bucket" | "block.minecraft.oak_log" | "subtitles.entity.glow_squid.ambient" | "entity.irons_spellbooks.archevoker" | "commands.experience.add.levels.success.multiple" | "dataPack.title" | "config.jade.flip_main_hand_desc" | "block.minecraft.jungle_hanging_sign" | "commands.scoreboard.players.reset.specific.single" | "item.minecraft.angler_pottery_shard" | "moon.phase.new" | "school.irons_spellbooks.ender" | "selectWorld.targetFolder" | "modernfix.config.wiki" | "mco.configure.world.spawn_toggle.title" | "chat.type.advancement.challenge" | "createWorld.customize.custom.waterLakeChance" | "datapackFailure.safeMode.failed.description" | "block.minecraft.potted_oak_sapling" | "subtitles.entity.arrow.shoot" | "patchouli.gui.lexicon.no_results" | "item.durability" | "item.minecraft.wither_spawn_egg" | "painting.minecraft.aztec.title" | "spell.irons_spellbooks.scorch.guide" | "item.minecraft.command_block_minecart" | "block.minecraft.honey_block" | "credits_and_attribution.button.credits" | "jei.key.combo.command" | "entity.minecraft.chest_minecart" | "multiplayer.disconnect.invalid_player_data" | "subtitles.entity.piglin.converted_to_zombified" | "telemetry.property.render_time_samples.title" | "item.irons_spellbooks.magehunter" | "block.minecraft.lime_terracotta" | "death.attack.irons_spellbooks.earthquake" | "modernfix.option.mixin.bugfix.starlight_emptiness" | "item.minecraft.shield" | "ui.irons_spellbooks.cast_type" | "realms.missing.snapshot.error.text" | "item.minecraft.pottery_shard_prize" | "item.minecraft.splash_potion.effect.mana" | "mco.configure.world.slot.tooltip.active" | "block.minecraft.repeating_command_block" | "block.minecraft.chiseled_bookshelf" | "arguments.block.tag.unknown" | "block.minecraft.red_nether_brick_wall" | "key.jei.nextCategory" | "enchantment.improved_exp.flammable.desc" | "commands.worldborder.set.grow" | "block.minecraft.purple_stained_glass" | "subtitles.block.pumpkin.carve" | "block.minecraft.banner.triangles_bottom.pink" | "block.minecraft.peony" | "narrator.select.world" | "item.minecraft.mojang_banner_pattern" | "commands.recipe.give.success.multiple" | "commands.forceload.query.failure" | "block.minecraft.potted_birch_sapling" | "commands.damage.success" | "advancements.adventure.trade_at_world_height.description" | "subtitles.chiseled_bookshelf.take_enchanted" | "config.jade.display_entities_extra_msg" | "block.minecraft.mud_brick_wall" | "gui.jei.category.craftingTable" | "subtitles.block.comparator.click" | "subtitles.entity.potion.splash" | "flat_world_preset.minecraft.tunnelers_dream" | "item.minecraft.tipped_arrow.effect.luck" | "gui.socialInteractions.report" | "key.keyboard.num.lock" | "enchantment.minecraft.swift_sneak.desc" | "entity.irons_spellbooks.ice_block_projectile" | "time.bookshelf.month.march" | "item.minecraft.torchflower_seeds" | "item.geckolib.jack_in_the_box" | "tooltip.titanium.facing_handler.fluid" | "selectWorld.edit.backup" | "item.geckolib.parasite_spawn_egg" | "item.minecraft.enchanted_golden_apple" | "subtitles.entity.fox.spit" | "commands.gamerule.query" | "block.minecraft.birch_wall_hanging_sign" | "title.multiplayer.other" | "subtitles.item.armor.equip_leather" | "spell.irons_spellbooks.ascension.guide" | "parsing.bool.invalid" | "subtitles.entity.hoglin.attack" | "item.minecraft.cocoa_beans" | "block.minecraft.brown_stained_glass" | "advancements.irons_spellbooks.spell_book_netherite.description" | "multiplayer.disconnect.unverified_username" | "block.minecraft.mangrove_fence" | "narration.checkbox.usage.hovered" | "block.minecraft.dead_tube_coral_fan" | "block.minecraft.prismarine_stairs" | "resourcePack.load_fail" | "mco.configure.world.buttons.invite" | "block.minecraft.cut_red_sandstone_slab" | "block.minecraft.banner.square_bottom_right.green" | "mco.configure.world.subscription.recurring.info" | "key.keyboard.backslash" | "commands.worldborder.damage.amount.failed" | "forge.container.enchant.limitedEnchantability" | "block.minecraft.dead_bush" | "translation.test.invalid2" | "telemetry.property.load_time_pre_window_ms.title" | "block.minecraft.banner.half_horizontal_bottom.orange" | "block.minecraft.banner.half_vertical.yellow" | "selectServer.add" | "entity.minecraft.skeleton_horse" | "subtitles.entity.evoker_fangs.attack" | "death.attack.indirectMagic" | "options.renderDistance" | "moon.phase.waning.crescent" | "item.minecraft.music_disc_far.desc" | "title.multiplayer.disabled.banned.permanent" | "block.minecraft.banner.piglin.gray" | "attribute.name.generic.attack_damage" | "item.minecraft.netherite_ingot" | "mco.configure.world.name" | "gui.curios.toggle.cosmetics" | "chat.disabled.expiredProfileKey" | "tooltip.irons_spellbooks.scroll_tooltip" | "spell.irons_spellbooks.summon_ender_chest" | "advancements.end.levitate.description" | "advancements.story.enchant_item.description" | "item.patchouli:test_book_1.landing" | "subtitles.entity.frog.hurt" | "block.minecraft.rail" | "item.minecraft.stone_axe" | "entity.irons_spellbooks.icicle_projectile" | "argument.pos.outofbounds" | "config.jade.plugin_tconstruct.casting_table" | "block.minecraft.bamboo_wall_sign" | "item.minecraft.bread" | "spell.irons_spellbooks.eldritch_blast.guide" | "block.minecraft.banner.triangle_top.white" | "enchantment.improved_exp.slow_falling.desc" | "mco.configure.world.buttons.options" | "block.minecraft.jungle_fence_gate" | "multiplayer.status.ping" | "gamerule.doFireTick" | "subtitles.block.conduit.attack.target" | "entity.minecraft.witch" | "gamerule.universalAnger.description" | "gui.toMenu" | "block.minecraft.banner.rhombus.yellow" | "death.attack.irons_spellbooks.blood_slash.item" | "block.minecraft.smooth_sandstone" | "mco.configure.world.forceGameMode" | "chat.filtered_full" | "patchouli.gui.lexicon.shapeless" | "itemGroup.spawnEggs" | "debug.crash.warning" | "advancements.adventure.spyglass_at_dragon.description" | "block.minecraft.jungle_wood" | "subtitles.entity.polar_bear.warning" | "painting.minecraft.fighters.author" | "entity.minecraft.wither" | "tetra.material.irons_spellbooks_holy_rune_socket.prefix" | "item.minecraft.music_disc_stal.desc" | "item.minecraft.cow_spawn_egg" | "options.search" | "sodium.option_impact.low" | "block.minecraft.reinforced_deepslate" | "subtitles.item.brush.brushing.sand" | "description.jei.wooden.door.1" | "commands.title.show.subtitle.multiple" | "item.minecraft.skeleton_spawn_egg" | "description.jei.wooden.door.3" | "description.jei.wooden.door.2" | "commands.bossbar.set.style.success" | "modernfix.option.mixin.perf.forge_registry_lambda" | "enchantment.minecraft.looting.desc" | "container.blast_furnace" | "enchantment.minecraft.respiration" | "enchantment.minecraft.impaling.desc" | "block.minecraft.cherry_door" | "item.irons_spellbooks.ruined_book.guide" | "patchouli.gui.lexicon.button.next_page" | "death.attack.explosion.player" | "config.jei.interface.comment" | "subtitles.entity.glow_item_frame.rotate_item" | "text.cloth-config.apply" | "block.minecraft.banner.stripe_center.magenta" | "block.minecraft.mud" | "item.irons_spellbooks.priest_spawn_egg" | "effect.minecraft.luck" | "block.minecraft.chiseled_sandstone" | "options.fullscreen" | "subtitles.entity.wither.spawn" | "effect.irons_spellbooks.airborne" | "ui.irons_spellbooks.spell_target_success" | "options.difficulty.peaceful" | "subtitles.entity.hoglin.angry" | "death.attack.hotFloor" | "team.notFound" | "selectWorld.enterName" | "enchantment.dungeonsenchantments.thundering.desc" | "spell.irons_spellbooks.blaze_storm" | "spell.irons_spellbooks.summon_polar_bear" | "block.minecraft.infested_stone" | "debug.advanced_tooltips.help" | "subtitles.entity.tropical_fish.hurt" | "death.attack.wither.player" | "itemGroup.coloredBlocks" | "painting.minecraft.bomb.author" | "telemetry.property.used_memory_samples.title" | "forge.configgui.selectiveResourceReloadEnabled.tooltip" | "stat.minecraft.horse_one_cm" | "block.minecraft.jigsaw" | "spell.irons_spellbooks.sonic_boom" | "commands.forge.setdim.invalid.nochange" | "subtitles.block.respawn_anchor.charge" | "subtitles.entity.blaze.death" | "forge.update.beta.1" | "forge.update.beta.2" | "gui.socialInteractions.empty_hidden" | "curios.identifier.body" | "text.cloth-config.boolean.value.true" | "commands.advancement.grant.criterion.to.many.failure" | "options.graphics.warning.vendor" | "selectWorld.locked" | "demo.help.movement" | "mco.configure.world.invites.ops.tooltip" | "block.minecraft.dead_brain_coral_block" | "gui.abuseReport.reason.child_sexual_exploitation_or_abuse" | "block.minecraft.fire_coral_fan" | "generator.minecraft.amplified.info" | "subtitles.entity.dolphin.attack" | "modernfix.option.category.performance" | "block.minecraft.acacia_door" | "item.minecraft.shield.orange" | "item.patchouli.guide_book.undefined" | "item.irons_spellbooks.cultist_leggings" | "block.minecraft.blue_terracotta" | "block.minecraft.soul_soil" | "modernfix.option.mixin.perf.async_jei" | "block.minecraft.orange_stained_glass_pane" | "subtitles.entity.villager.work_leatherworker" | "death.attack.irons_spellbooks.ray_of_siphoning.item" | "controls.resetAll" | "telemetry.event.advancement_made.title" | "telemetry.property.opt_in.title" | "lanServer.port" | "block.minecraft.banner.square_top_left.cyan" | "item.minecraft.danger_pottery_sherd" | "block.minecraft.banner.curly_border.white" | "entity.minecraft.tropical_fish.type.clayfish" | "block.minecraft.banner.stripe_right.light_gray" | "subtitles.block.portal.trigger" | "effect.minecraft.mining_fatigue" | "demo.day.warning" | "gui.banned.description.temporary" | "sodium.options.cpu_render_ahead_limit.name" | "block.minecraft.banner.stripe_left.yellow" | "key.keyboard.left.control" | "commands.datapack.disable.failed" | "block.minecraft.piglin_wall_head" | "block.minecraft.oxidized_cut_copper_stairs" | "item.minecraft.firework_star.shape.star" | "block.minecraft.wither_skeleton_skull" | "item.minecraft.raw_copper" | "block.minecraft.mangrove_log" | "death.attack.sting" | "item.minecraft.silverfish_spawn_egg" | "block.minecraft.mangrove_stairs" | "subtitles.entity.creeper.hurt" | "structure_block.load_not_found" | "optimizeWorld.stage.failed" | "block.minecraft.banner.diagonal_up_left.purple" | "key.keyboard.left.win" | "advancements.adventure.walk_on_powder_snow_with_leather_boots.description" | "block.minecraft.allium" | "death.attack.irons_spellbooks.summon_vex.item" | "text.cloth-config.cancel_discard" | "multiplayer.unsecureserver.toast" | "stat.minecraft.inspect_dispenser" | "jei.tooltip.bookmarks.tooltips.transfer.usage" | "block.minecraft.loom" | "selectWorld.experimental.details.title" | "telemetry.property.dedicated_memory_kb.title" | "particle.notFound" | "patchouli.gui.lexicon.sad" | "block.minecraft.banner.border.lime" | "subtitles.entity.creeper.death" | "config.jade.plugin_minecraft.harvest_tool.creative_desc" | "block.minecraft.banner.mojang.magenta" | "selectWorld.gameMode.survival.line1" | "subtitles.entity.piglin_brute.step" | "item.apotheosis.gem.irons_spellbooks:cooldown" | "selectWorld.gameMode.survival.line2" | "trim_pattern.minecraft.wild" | "patchouli.gui.lexicon.needs_air" | "death.attack.irons_spellbooks.firecracker.item" | "block.minecraft.spawn.not_valid" | "config.jei.mode.editEnabled.comment" | "advancements.nether.obtain_ancient_debris.description" | "chat.type.team.sent" | "mco.template.default.name" | "subtitles.block.bubble_column.upwards_ambient" | "commands.scoreboard.players.list.entity.entry" | "commands.give.success.single" | "subtitles.entity.generic.big_fall" | "subtitles.entity.bee.sting" | "item.irons_spellbooks.concentration_amulet" | "commands.data.storage.query" | "time.bookshelf.month.october" | "config.jei.search.colorSearchMode" | "gamerule.globalSoundEvents" | "selectWorld.edit.title" | "gui.jade.configuration.desc2" | "block.minecraft.banner.stripe_top.black" | "death.attack.fallingBlock.player" | "gui.jade.configuration.desc1" | "mco.configure.world.invite.narration" | "affix.irons_spellbooks:armor/attribute/spell_power" | "config.jade.plugin_minecraft.item_storage.show_name_amount" | "spectatorMenu.team_teleport.prompt" | "sodium.options.use_compact_vertex_format.name" | "block.minecraft.rose_bush" | "config.jade.plugin_secretroomsmod.jadeaddons" | "block.minecraft.iron_bars" | "commands.worldborder.damage.amount.success" | "death.attack.poison_cloud" | "block.minecraft.banner.small_stripes.gray" | "commands.advancement.grant.one.to.one.success" | "mco.backup.entry.seed" | "commands.drop.success.single" | "block.minecraft.banner.diagonal_left.light_gray" | "item.irons_spellbooks.eldritch_manuscript_desc" | "options.narrator.system" | "death.attack.explosion.player.item" | "entity.minecraft.tropical_fish.type.brinely" | "item.minecraft.blaze_powder" | "tutorial.bundleInsert.description" | "chat.type.advancement.task" | "config.jade.overlay_anchor_x" | "disconnect.quitting" | "block.minecraft.quartz_slab" | "config.jade.overlay_anchor_y" | "block.minecraft.banner.half_horizontal_bottom.light_blue" | "effect.minecraft.slow_falling" | "subtitles.entity.glow_squid.hurt" | "advancements.irons_spellbooks.spell_book_evoker.title" | "tooltip.titanium.tank.no_tank" | "commands.spectate.not_spectator" | "item.irons_spellbooks.tarnished_helmet" | "block.minecraft.yellow_candle_cake" | "commands.perf.reportSaved" | "death.attack.irons_spellbooks.divine_smite" | "advancements.empty" | "fml.loadingerrorscreen.warningheader" | "block.minecraft.acacia_stairs" | "modernfix.option.mixin.perf.remove_spawn_chunks" | "jade.instrument.harp" | "block.minecraft.dark_oak_sign" | "block.minecraft.jack_o_lantern" | "block.minecraft.banner.square_bottom_right.magenta" | "block.minecraft.lime_wool" | "item.minecraft.shield.light_gray" | "item.minecraft.wooden_shovel" | "key.keyboard.end" | "block.minecraft.deepslate_brick_wall" | "item.minecraft.green_dye" | "enchantment.deeperdarker.catalysis.desc" | "spell.irons_spellbooks.heartstop" | "block.minecraft.banner.border.blue" | "block.minecraft.crimson_planks" | "block.minecraft.sandstone_wall" | "item.minecraft.potion.effect.strength" | "subtitles.entity.parrot.imitate.shulker" | "block.minecraft.carved_pumpkin" | "commands.datapack.modify.enable" | "block.minecraft.banner.stripe_downright.red" | "item.minecraft.shield.white" | "block.minecraft.potted_acacia_sapling" | "item.apotheosis.gem.irons_spellbooks:cast_time" | "commands.stopsound.success.sourceless.any" | "block.minecraft.weathered_cut_copper_stairs" | "block.minecraft.nether_brick_stairs" | "argument.entity.selector.unknown" | "key.jei.transferRecipeBookmark" | "advancements.story.obtain_armor.description" | "commands.experience.set.points.invalid" | "entity.minecraft.pig" | "curios.modifiers.slots.plus.0" | "commands.advancement.criterionNotFound" | "curios.modifiers.slots.plus.1" | "patchouli.gui.lexicon.loading_error_hover" | "mco.configure.worlds.title" | "curios.modifiers.slots.plus.2" | "commands.mana.set.success.single" | "affix.irons_spellbooks:spellbook/attribute/fire_spell_power" | "dataPack.validation.reset" | "spell.irons_spellbooks.devour.guide" | "commands.stopsound.success.source.any" | "curios.modifiers.belt" | "block.minecraft.banner.stripe_bottom.lime" | "block.minecraft.banner.square_top_right.brown" | "commands.teleport.success.entity.multiple" | "tetra.material.irons_spellbooks_arcane_ingot.prefix" | "entity.minecraft.falling_block" | "item.minecraft.debug_stick.empty" | "lanserverproperties.button.preference_save" | "subtitles.entity.donkey.chest" | "entity.minecraft.villager" | "advancements.husbandry.wax_off.title" | "item.minecraft.firework_star.shape.burst" | "options.sort" | "gui.chatSelection.message.narrate" | "block.minecraft.banner.flower.pink" | "item.minecraft.axolotl_spawn_egg" | "gamerule.lavaSourceConversion.description" | "subtitles.block.composter.ready" | "subtitles.entity.warden.hurt" | "biome.minecraft.sunflower_plains" | "chat.type.text" | "menu.returnToGame" | "commands.attribute.base_value.get.success" | "item.minecraft.compass" | "enchantment.improved_exp.warmblooded.desc" | "mco.reset.world.upload" | "subtitles.entity.zombie_villager.converted" | "enchantment.dungeonsenchantments.rush.desc" | "key.keyboard.home" | "painting.minecraft.plant.author" | "item.irons_spellbooks.ice_rune" | "forge.configgui.zombieBaseSummonChance.tooltip" | "connect.encrypting" | "options.invertMouse" | "gui.chatReport.draft.edit" | "block.minecraft.redstone_block" | "item.minecraft.melon_slice" | "sodium.option_impact.high" | "commands.forge.gen.progress" | "block.minecraft.acacia_hanging_sign" | "block.minecraft.zombie_wall_head" | "stat.minecraft.fill_cauldron" | "effect.irons_spellbooks.hastened.description" | "block.minecraft.polished_deepslate_stairs" | "tutorial.look.description" | "container.shulkerBox.more" | "debug.profiling.help" | "item.minecraft.paper" | "entity.minecraft.villager.cartographer" | "block.minecraft.smooth_stone" | "argument.entity.options.name.description" | "subtitles.entity.vindicator.celebrate" | "item.minecraft.brush" | "jei.tooltip.show.all.recipes.hotkey" | "item.minecraft.lingering_potion.effect.mana" | "jei.tooltip.delete.item" | "leaves_type.minecraft.birch" | "block.minecraft.banner.stripe_bottom.blue" | "patchouli.gui.lexicon.loading_error_log" | "jei.key.category.edit.mode" | "subtitles.entity.llama.death" | "item.minecraft.globe_banner_pattern.desc" | "language.region" | "narration.cycle_button.usage.focused" | "subtitles.entity.wandering_trader.ambient" | "block.minecraft.banner.straight_cross.lime" | "key.jade.narrate" | "stat.minecraft.play_record" | "effect.minecraft.poison" | "block.minecraft.crimson_stem" | "jei.tooltip.shapeless.recipe" | "advancements.husbandry.plant_any_sniffer_seed.title" | "selectWorld.search" | "block.minecraft.banner.bricks.brown" | "realms.missing.module.error.text" | "block.minecraft.mangrove_wall_sign" | "item.minecraft.netherite_shovel" | "jei.message.configured" | "stat.minecraft.swim_one_cm" | "narrator.toast.enabled" | "key.irons_spellbooks.group_2" | "key.irons_spellbooks.group_1" | "jei.chat.error.no.cheat.permission.creative" | "item.minecraft.piglin_spawn_egg" | "sodium.options.pages.advanced" | "enchantment.improved_exp.haste.desc" | "options.modelPart.jacket" | "argument.block.id.invalid" | "block.minecraft.crafting_table" | "config.jade.plugin_minecraft.item_tooltip" | "sodium.options.use_no_error_context.tooltip" | "block.minecraft.red_glazed_terracotta" | "block.minecraft.banner.globe.pink" | "block.minecraft.banner.diagonal_up_left.white" | "selectWorld.tooltip.snapshot1" | "selectWorld.tooltip.snapshot2" | "block.minecraft.coal_ore" | "jade.collectingItems" | "school.irons_spellbooks.lightning" | "death.attack.irons_spellbooks.fang_ward.item" | "argument.pos.outofworld" | "item.minecraft.sheaf_pottery_sherd" | "block.minecraft.end_stone_brick_slab" | "item.minecraft.iron_chestplate" | "key.keyboard.escape" | "config.jade.plugin_jade.coordinates_desc" | "commands.team.option.seeFriendlyInvisibles.disabled" | "death.attack.irons_spellbooks.lob_creeper" | "stat.minecraft.damage_resisted" | "subtitles.entity.drowned.step" | "painting.minecraft.courbet.author" | "argument.time.tick_count_too_low" | "irons_spellbooks.tetra_bar.spell_resist.tooltip" | "commands.experience.set.points.success.multiple" | "block.minecraft.cherry_fence_gate" | "block.minecraft.exposed_cut_copper_stairs" | "subtitles.item.brush.brushing.gravel" | "mco.brokenworld.nonowner.error" | "entity.minecraft.tropical_fish.type.glitter" | "item.minecraft.vindicator_spawn_egg" | "school.irons_spellbooks.eldritch" | "mco.configure.world.edit.slot.name" | "block.minecraft.blast_furnace" | "subtitles.item.totem.use" | "commands.forge.tps.summary.basic" | "block.minecraft.black_candle_cake" | "options.directionalAudio.off.tooltip" | "block.minecraft.attached_melon_stem" | "block.minecraft.banner.mojang.white" | "block.minecraft.banner.straight_cross.blue" | "block.minecraft.banner.stripe_downright.pink" | "mco.configure.world.uninvite.player" | "effect.irons_spellbooks.polar_bear_timer" | "subtitles.entity.generic.small_fall" | "mco.errorMessage.serviceBusy" | "subtitles.entity.warden.agitated" | "command.failed" | "ui.irons_spellbooks.unlearned_spell" | "lanserverproperties.options.online_mode.on" | "block.minecraft.lime_bed" | "block.minecraft.banner.diagonal_left.brown" | "leaves_type.ulterlands.souldrained" | "ui.irons_spellbooks.cast_error_mana" | "mco.configure.world.pvp" | "block.minecraft.spruce_fence_gate" | "block.minecraft.banner.diagonal_up_right.red" | "ui.irons_spellbooks.greater_healing" | "subtitles.entity.polar_bear.death" | "advancements.husbandry.kill_axolotl_target.title" | "spell.irons_spellbooks.thunderstorm.guide" | "entity.minecraft.elder_guardian" | "generator.minecraft.normal" | "advancements.husbandry.axolotl_in_a_bucket.title" | "advancements.nether.loot_bastion.description" | "structure_block.load_success" | "advancements.husbandry.tame_an_animal.description" | "item.minecraft.horse_spawn_egg" | "item.minecraft.zombie_spawn_egg" | "generator.minecraft.large_biomes" | "stat.minecraft.interact_with_brewingstand" | "block.minecraft.banner.rhombus.light_gray" | "multiplayer.player.joined" | "subtitles.entity.mule.ambient" | "subtitles.entity.parrot.imitate.zombie" | "options.controls" | "entity.minecraft.tropical_fish.type.flopper" | "effect.minecraft.wither" | "block.minecraft.banner.diagonal_left.pink" | "stat.minecraft.clean_armor" | "subtitles.entity.donkey.eat" | "modernfix.option.mixin.perf.cache_strongholds" | "item.irons_spellbooks.pumpkin_leggings" | "subtitles.entity.parrot.imitate.ender_dragon" | "block.minecraft.jungle_pressure_plate" | "block.minecraft.banner.triangle_top.black" | "effect.minecraft.blindness" | "commands.team.option.color.success" | "block.minecraft.pink_shulker_box" | "subtitles.entity.strider.death" | "options.operatorItemsTab" | "block.minecraft.waxed_exposed_cut_copper" | "config.jade.hide_from_tab_list" | "item.minecraft.bat_spawn_egg" | "commands.datapack.modify.disable" | "item.minecraft.trident" | "block.minecraft.acacia_sapling" | "block.minecraft.dragon_head" | "subtitles.block.beehive.work" | "commands.message.display.incoming" | "block.minecraft.banner.diagonal_up_left.black" | "item.minecraft.potion_lingering" | "item.geckolib.fake_glass_spawn_egg" | "block.minecraft.banner.stripe_right.lime" | "block.minecraft.spruce_leaves" | "titanium.rewards.remove_success" | "gui.socialInteractions.narration.hide" | "tooltip.titanium.tank.action_fill" | "lanserverproperties.button.preference_load" | "death.attack.drown.player" | "commands.data.modify.expected_value" | "death.attack.sweetBerryBush" | "modernfix.option.category.troubleshooting" | "mco.invites.pending" | "telemetry_info.property_title" | "mco.minigame.world.switch.new" | "tooltip.jade.mode_comparator" | "commands.team.option.deathMessageVisibility.unchanged" | "gui.abuseReport.reason.hate_speech.description" | "block.minecraft.banner.square_top_left.yellow" | "block.minecraft.stripped_cherry_wood" | "item.minecraft.splash_potion.effect.regeneration" | "block.minecraft.banner.mojang.black" | "fabric.gui.creativeTabPage" | "subtitles.entity.llama.hurt" | "block.minecraft.banner.rhombus.gray" | "sodium.options.pages.quality" | "modernfix.option.mixin.bugfix.restore_old_dragon_movement" | "advancements.end.root.title" | "block.minecraft.purple_candle" | "subtitles.entity.fishing_bobber.throw" | "narrator.screen.usage" | "jei.tooltip.error.recipe.transfer.missing" | "subtitles.entity.shulker.death" | "argument.entity.options.distance.description" | "item.minecraft.recovery_compass" | "options.graphics.fabulous.tooltip" | "item.irons_spellbooks.invisibility_elixir" | "subtitles.entity.fox.sleep" | "narrator.button.accessibility" | "block.minecraft.banner.half_vertical_right.lime" | "options.onlyShowSecureChat" | "__support_hunterillager" | "modernfix.option.mixin.perf.jeresources_startup" | "block.minecraft.banner.border.light_blue" | "block.minecraft.banner.stripe_top.orange" | "sodium.options.view_distance.tooltip" | "death.attack.irons_spellbooks.electrocute" | "options.accessibility.text_background_opacity" | "spectatorMenu.team_teleport" | "subtitles.entity.frog.lay_spawn" | "createWorld.customize.custom.dungeonChance" | "mco.configure.world.spawn_toggle.message" | "entity.minecraft.pillager" | "gui.banned.reason.sexually_inappropriate" | "block.minecraft.bed.obstructed" | "subtitles.entity.polar_bear.hurt" | "key.jei.toggleCheatMode" | "advancements.adventure.bullseye.title" | "gui.chatReport.send" | "block.minecraft.pink_candle_cake" | "key.categories.misc" | "spell.irons_spellbooks.earthquake" | "tutorial.open_inventory.title" | "item.irons_spellbooks.cultist_boots" | "mco.backup.entry.description" | "subtitles.block.trapdoor.toggle" | "mco.configure.world.slot.switch.question.line2" | "mco.configure.world.slot.switch.question.line1" | "block.minecraft.banner.stripe_right.blue" | "block.minecraft.cherry_slab" | "disconnect.exceeded_packet_rate" | "gamerule.mobExplosionDropDecay" | "advancements.adventure.spyglass_at_ghast.description" | "advancement.advancementNotFound" | "subtitles.entity.rabbit.jump" | "text.cloth-config.exit_minecraft" | "commands.forge.tags.error.unknown_tag" | "modernfix.jei_load" | "mco.template.button.trailer" | "wood_type.minecraft.crimson" | "block.minecraft.light_blue_banner" | "school.irons_spellbooks.blood" | "parsing.bool.expected" | "block.minecraft.banner.square_bottom_left.lime" | "gui.chatReport.describe" | "createWorld.customize.presets" | "ui.irons_spellbooks.projectile_count" | "flat_world_preset.minecraft.redstone_ready" | "block.minecraft.cauldron" | "container.upgrade" | "multiplayer.status.finished" | "subtitles.entity.parrot.imitate.magma_cube" | "block.minecraft.nether_brick_fence" | "commands.forceload.list.multiple" | "flat_world_preset.minecraft.the_void" | "block.minecraft.banner.globe.orange" | "block.minecraft.banner.skull.lime" | "gui.jei.category.brewing.steps" | "soundCategory.player" | "enchantment.dungeonsenchantments.deflect.desc" | "stat_type.minecraft.mined" | "subtitles.entity.goat.horn_break" | "argument.entity.options.dx.description" | "item_modifier.unknown" | "block.minecraft.banner.globe.light_blue" | "item.minecraft.heartbreak_pottery_sherd" | "patchouli.gui.lexicon.progress_tooltip.info" | "gui.socialInteractions.status_hidden_offline" | "item.minecraft.splash_potion.effect.night_vision" | "block.minecraft.wither_skeleton_wall_skull" | "item.minecraft.cooked_beef" | "block.minecraft.banner.half_vertical_right.blue" | "enchantment.minecraft.multishot.desc" | "item.minecraft.magma_cube_spawn_egg" | "advancements.husbandry.kill_axolotl_target.description" | "painting.minecraft.donkey_kong.author" | "__support_create_stuff" | "subtitles.chiseled_bookshelf.insert_enchanted" | "tooltip.jade.state_off" | "commands.advancement.revoke.one.to.one.failure" | "container.repair.expensive" | "optimizeWorld.stage.counting" | "mco.minigame.world.title" | "container.inventory" | "trim_pattern.minecraft.snout" | "arguments.nbtpath.too_deep" | "block.minecraft.magenta_stained_glass" | "entity.irons_spellbooks.magic_arrow_projectile" | "block.minecraft.weathered_cut_copper" | "mco.account.privacyinfo" | "options.pixel_value" | "patchouli.gui.lexicon.mark_incomplete" | "death.attack.irons_spellbooks.eldritch_blast" | "item.minecraft.splash_potion.effect.water_breathing" | "entity.irons_spellbooks.cone_of_cold_projectile" | "mco.create.world.error" | "gui.socialInteractions.tab_all" | "entity.geckolib.race_car" | "death.attack.freeze" | "argument.integer.low" | "block.minecraft.banner.stripe_bottom.purple" | "resourcePack.broken_assets" | "subtitles.entity.pig.hurt" | "tooltip.titanium.tank.amount" | "block.minecraft.banner.square_bottom_left.blue" | "item.minecraft.potion.effect.awkward" | "modernfix.option.mixin.perf.dynamic_resources.diagonalfences" | "block.minecraft.banner.stripe_top.light_gray" | "entity.irons_spellbooks.spectral_hammer" | "jei.tooltip.show.recipes" | "block.minecraft.white_banner" | "jade.ench_power" | "modernfix.option.mixin.feature.warn_missing_perf_mods" | "entity.minecraft.rabbit" | "block.minecraft.large_fern" | "options.reducedDebugInfo" | "arguments.objective.notFound" | "block.minecraft.banner.diagonal_up_left.green" | "multiplayer.status.unrequested" | "sodium.options.use_entity_culling.tooltip" | "enchantment.minecraft.silk_touch.desc" | "item.irons_spellbooks.protection_rune" | "spell.irons_spellbooks.oakskin.guide" | "spell.irons_spellbooks.scorch" | "block.minecraft.banner.triangles_top.brown" | "spell.irons_spellbooks.poison_breath.guide" | "advancements.story.iron_tools.title" | "config.jade.hide_from_tab_list_extra_msg" | "config.jade.plugin_minecraft.potion_effects_extra_msg" | "menu.generatingLevel" | "block.minecraft.banner.square_bottom_left.purple" | "block.minecraft.dirt_path" | "subtitles.entity.generic.hurt" | "entity.minecraft.villager.none" | "narrator.position.tab" | "subtitles.item.goat_horn.play" | "item.irons_spellbooks.wandering_magician_chestplate" | "fml.modloading.feature.missing" | "commands.scoreboard.players.enable.success.single" | "subtitles.entity.villager.work_cleric" | "curios.slot" | "ui.irons_spellbooks.inscription_table_title" | "advancements.husbandry.silk_touch_nest.title" | "gui.banned.reason.false_reporting" | "block.minecraft.coarse_dirt" | "spell.irons_spellbooks.echoing_strikes.guide" | "item.minecraft.crossbow" | "selectServer.select" | "block.minecraft.banner.stripe_top.cyan" | "death.attack.player.item" | "commands.execute.conditional.fail" | "subtitles.entity.wither_skeleton.hurt" | "modernfix.config" | "inventory.binSlot" | "jade.instrument.pling" | "jecharacters.chat.help" | "mco.configure.world.spawnProtection" | "gui.recipebook.moreRecipes" | "commands.locate.poi.success" | "item.minecraft.globe_banner_pattern" | "item.minecraft.splash_potion.effect.levitation" | "gui.socialInteractions.narration.report" | "commands.advancement.revoke.many.to.one.failure" | "chat.link.warning" | "subtitles.entity.allay.hurt" | "item.minecraft.music_disc_chirp" | "item.minecraft.howl_pottery_sherd" | "modernfix.option.mixin.perf.rewrite_registry" | "options.toggleFree" | "block.minecraft.lapis_ore" | "subtitles.entity.fishing_bobber.splash" | "block.minecraft.bamboo_stairs" | "block.minecraft.banner.base.yellow" | "item.minecraft.stray_spawn_egg" | "block.minecraft.banner.base.pink" | "tetra.variant.basic_handle/frosted_helve" | "forge.configgui.zoomInMissingModelTextInGui" | "text.cloth-config.error.color.invalid_alpha" | "commands.debug.function.success.multiple" | "mco.configure.world.invited.number" | "item.minecraft.splash_potion.effect.thick" | "enchantment.minecraft.mending.desc" | "item.minecraft.cooked_cod" | "clear.failed.single" | "ui.irons_spellbooks.cast_error_scroll" | "gui.socialInteractions.tooltip.report" | "block.minecraft.observer" | "block.minecraft.banner.stripe_bottom.cyan" | "block.minecraft.banner.creeper.purple" | "subtitles.entity.silverfish.ambient" | "block.minecraft.banner.half_horizontal_bottom.brown" | "commands.team.option.friendlyfire.alreadyDisabled" | "death.attack.dragon_breath_pool" | "item.minecraft.firework_star.shape.large_ball" | "item.minecraft.heart_pottery_sherd" | "telemetry.property.server_type.title" | "block.minecraft.prismarine_brick_slab" | "death.fell.accident.twisting_vines" | "modernfix.option.mixin.bugfix.mc218112" | "block.minecraft.jungle_trapdoor" | "category.cloth-config.testing" | "connect.aborted" | "block.minecraft.banner.triangles_top.lime" | "enchantment.improved_exp.medication.desc" | "rarity.irons_spellbooks.uncommon" | "key.jei.showUses2" | "commands.team.list.teams.success" | "gui.abuseReport.reason.narration" | "spell.irons_spellbooks.magma_bomb" | "options.narrator.all" | "subtitles.entity.donkey.angry" | "config.jade.animation" | "multiplayer.status.cannot_resolve" | "jade.instrument.cow_bell" | "attribute.name.generic.movement_speed" | "narrator.position.list" | "config.jade.display_mode_desc" | "commands.item.target.no_such_slot" | "gui.abuseReport.reason.title" | "block.minecraft.banner.diagonal_up_left.magenta" | "block.minecraft.banner.square_top_right.light_gray" | "block.minecraft.dead_brain_coral_fan" | "block.minecraft.banner.flower.white" | "item.irons_spellbooks.enchanted_ward_amulet" | "stat.minecraft.sneak_time" | "sodium.options.particle_quality.tooltip" | "argument.nbt.trailing" | "mco.selectServer.note" | "item.irons_spellbooks.common_ink" | "options.fov.min" | "mco.minigame.world.restore.question.line2" | "subtitles.entity.zombie.destroy_egg" | "biome.minecraft.lukewarm_ocean" | "entity.minecraft.wither_skull" | "mco.minigame.world.restore.question.line1" | "patchouli.gui.lexicon.dev_edition" | "config.jade.item_mod_name" | "entity.minecraft.eye_of_ender" | "createWorld.tab.world.title" | "tetra.variant.basic_hilt/frosted_helve" | "block.minecraft.banner.triangle_bottom.red" | "block.minecraft.cyan_carpet" | "argument.double.big" | "color.minecraft.red" | "block.minecraft.oak_door" | "enchantment.improved_exp.recovery.desc" | "death.attack.irons_spellbooks.stomp.item" | "block.minecraft.flowering_azalea_leaves" | "item.minecraft.prismarine_crystals" | "enchantment.improved_exp.speed.desc" | "commands.scoreboard.players.enable.success.multiple" | "menu.disconnect" | "entity.minecraft.chest_boat" | "item.minecraft.tipped_arrow.effect.slow_falling" | "stat_type.minecraft.killed_by" | "commands.place.jigsaw.invalid" | "key.jei.cheatOneItem" | "options.online" | "lanserverproperties.gui.always_offline" | "commands.banip.invalid" | "block.minecraft.banner.square_top_left.light_gray" | "tetra.material.irons_spellbooks_ender_rune_socket.prefix" | "advancements.adventure.kill_mob_near_sculk_catalyst.title" | "subtitles.entity.elder_guardian.death" | "config.jade.plugin_jade.coordinates" | "multiplayer.disconnect.authservers_down" | "enchantment.improved_exp.auto_explosion.desc" | "color.minecraft.gray" | "effect.irons_spellbooks.burning_dash" | "item.minecraft.furnace_minecart" | "mco.selectServer.expiredList" | "gui.abuseReport.reason.harassment_or_bullying.description" | "fml.menu.multiplayer.compatible" | "multiplayer.disconnect.idling" | "soundCategory.record" | "config.jei.advanced.giveMode" | "block.minecraft.prismarine_slab" | "block.minecraft.nether_portal" | "advancements.story.obtain_armor.title" | "subtitles.entity.ender_dragon.flap" | "sodium.options.performance_impact_string" | "sodium.options.buttons.donate" | "fml.menu.mods.info.idstate" | "block.minecraft.purple_banner" | "entity.minecraft.spider" | "modernfix.option.mixin.devenv" | "commands.irons_spellbooks.create_spell.failed_max_level" | "subtitles.entity.endermite.death" | "telemetry.event.advancement_made.description" | "container.isLocked" | "commands.time.set" | "config.jade.reach_distance" | "config.jade.plugin_jade.registry_name" | "block.minecraft.yellow_banner" | "item.minecraft.potion.effect.swiftness" | "subtitles.entity.frog.long_jump" | "container.grindstone_title" | "mco.configure.world.opening" | "block.minecraft.clay" | "container.barrel" | "fml.messages.version.restriction.upper.exclusive" | "commands.title.times.single" | "spell.irons_spellbooks.starfall" | "key.keyboard.period" | "key.mouse.right" | "death.attack.fireball" | "itemGroup.search" | "argument.entity.notfound.entity" | "block.minecraft.polished_diorite_slab" | "death.attack.irons_spellbooks.magic_missile.item" | "block.minecraft.banner.piglin.green" | "resourcepack.requesting" | "block.minecraft.banner.cross.magenta" | "block.minecraft.cobblestone_slab" | "enchantment.improved_exp.magnet.desc" | "mco.question" | "block.minecraft.banner.diagonal_right.purple" | "block.minecraft.big_dripleaf" | "item.minecraft.camel_spawn_egg" | "commands.bossbar.list.bars.none" | "advancements.nether.find_fortress.title" | "painting.minecraft.courbet.title" | "item.irons_spellbooks.dead_king_corpse_spawn_egg" | "spell.irons_spellbooks.firecracker.guide" | "block.minecraft.blackstone_stairs" | "advancements.husbandry.feed_snifflet.title" | "block.minecraft.banner.triangles_top.blue" | "effect.none" | "block.minecraft.deepslate_tile_slab" | "item.irons_spellbooks.gold_crown" | "commands.locate.structure.success" | "mco.backup.entry" | "spell.irons_spellbooks.wall_of_fire" | "telemetry_info.button.give_feedback" | "item.minecraft.piglin_banner_pattern.desc" | "subtitles.entity.blaze.hurt" | "gamerule.doEntityDrops" | "effect.irons_spellbooks.thunderstorm" | "block.minecraft.exposed_cut_copper_slab" | "selectWorld.create" | "commands.forge.tracking.no_data" | "config.jade.display_fluids" | "death.attack.fireworks" | "jade.hopper.locked" | "block.minecraft.banner.triangle_top.lime" | "block.minecraft.potted_dead_bush" | "jade.input_signal" | "subtitles.entity.ender_dragon.growl" | "block.minecraft.banner.half_horizontal.brown" | "item.patchouli.guide_book" | "commands.advancement.revoke.one.to.many.success" | "item.minecraft.splash_potion.effect.water" | "config.jei.advanced.modNameFormat.comment" | "tooltip.irons_spellbooks.cast_charge" | "mco.configure.world.subscription.months" | "createWorld.customize.custom.preset.waterWorld" | "block.minecraft.banner.diagonal_right.red" | "entity.minecraft.experience_orb" | "commands.function.success.multiple" | "death.attack.inWall" | "advancements.husbandry.plant_seed.title" | "jei.tooltip.transfer" | "chat.type.announcement" | "advancements.end.dragon_breath.title" | "mco.errorMessage.6003" | "mco.errorMessage.6002" | "item.irons_spellbooks.ice_upgrade_orb" | "commands.attribute.base_value.set.success" | "mco.errorMessage.6001" | "jadeaddons.create.backtank_air" | "commands.title.cleared.multiple" | "key.keyboard.page.up" | "mco.errorMessage.6007" | "telemetry.property.minecraft_session_id.title" | "mco.errorMessage.6006" | "mco.errorMessage.6005" | "mco.errorMessage.6004" | "block.minecraft.banner.piglin.light_blue" | "event.minecraft.raid.defeat" | "mco.errorMessage.6009" | "tooltip.titanium.tank.action_drain" | "mco.errorMessage.6008" | "forge.configgui.removeErroringBlockEntities" | "options.rawMouseInput" | "gui.yes" | "soundCategory.ambient" | "config.jade.boss_bar_overlap" | "block.minecraft.medium_amethyst_bud" | "block.minecraft.banner.straight_cross.orange" | "spell.irons_spellbooks.evasion.guide" | "config.jade.display_fluids_any" | "patchouli.gui.lexicon.incomplete" | "entity.minecraft.stray" | "commands.bossbar.get.players.some" | "options.gamma.default" | "fml.menu.mods.info.updateavailable" | "subtitles.entity.axolotl.splash" | "modernfix.option.mixin.core" | "progress.working" | "lanserverproperties.options.online_mode.off.fixed" | "block.minecraft.potted_crimson_fungus" | "fml.modmismatchscreen.table.serverhas" | "commands.teleport.success.entity.single" | "advancements.adventure.bullseye.description" | "block.minecraft.pink_terracotta" | "chat.type.team.text" | "curios.identifier.necklace" | "connect.connecting" | "death.attack.flyIntoWall" | "item.minecraft.orange_dye" | "advancements.husbandry.leash_all_frog_variants.description" | "config.jade.plugin_minecraft.fluid_storage.detailed" | "block.minecraft.warped_fence_gate" | "itemGroup.functional" | "ui.irons_spellbooks.cast_long" | "block.minecraft.magenta_stained_glass_pane" | "subtitles.event.raid.horn" | "biome.minecraft.soul_sand_valley" | "block.minecraft.flower_pot" | "item.minecraft.fishing_rod" | "advancements.irons_spellbooks.make_scroll_forge.title" | "forge.configgui.fixVanillaCascading" | "item.irons_spellbooks.netherite_spell_book" | "modernfix.option.mixin.feature.direct_stack_trace" | "death.attack.irons_spellbooks.dragon_breath.item" | "entity.geckolib.mutant_zombie" | "argument.player.toomany" | "block.minecraft.light_gray_stained_glass_pane" | "item.irons_spellbooks.priest_boots" | "mco.configure.world.buttons.done" | "block.minecraft.banner.triangle_top.blue" | "selectWorld.allowCommands.info" | "block.minecraft.mossy_stone_brick_stairs" | "block.minecraft.brown_mushroom_block" | "commands.ride.mount.success" | "selectWorld.experimental.title" | "subtitles.block.barrel.close" | "subtitles.block.growing_plant.crop" | "subtitles.entity.rabbit.death" | "telemetry.event.required" | "block.minecraft.polished_andesite_stairs" | "key.pickItem" | "patchouli.gui.lexicon.button.mark_category_read" | "death.attack.irons_spellbooks.arrow_volley.item" | "block.minecraft.banner.half_vertical_right.brown" | "biome.minecraft.cherry_grove" | "commands.bossbar.set.color.unchanged" | "argument.block.property.unclosed" | "block.minecraft.banner.bricks.red" | "subtitles.entity.sniffer.drop_seed" | "subtitles.entity.panda.step" | "createWorld.customize.custom.page1" | "item.minecraft.enderman_spawn_egg" | "createWorld.customize.custom.page2" | "createWorld.customize.custom.page3" | "effect.irons_spellbooks.true_invisibility" | "advancements.adventure.voluntary_exile.description" | "block.minecraft.pink_concrete_powder" | "subtitles.entity.enderman.death" | "createWorld.customize.custom.page0" | "subtitles.entity.axolotl.swim" | "trim_pattern.minecraft.shaper" | "key.mouse.middle" | "block.minecraft.spruce_fence" | "death.attack.starve" | "block.minecraft.polished_granite" | "forge.configgui.forceSystemNanoTime" | "subtitles.entity.cat.eat" | "options.telemetry.button" | "command.jade.dump.success" | "gui.socialInteractions.tooltip.report.no_messages" | "text.cloth-config.error.color.invalid_color" | "debug.reload_chunks.help" | "key.jei.showUses" | "forge.controlsgui.control" | "block.minecraft.tnt" | "commands.experience.set.levels.success.multiple" | "subtitles.entity.witch.hurt" | "enchantment.minecraft.luck_of_the_sea.desc" | "curios.identifier.hands" | "modernfix.option.mixin.perf.clear_fabric_mapping_tables" | "tooltip.titanium.facing_handler.fluid_input" | "selectWorld.gameMode.hardcore" | "subtitles.entity.item_frame.remove_item" | "subtitles.entity.zoglin.ambient" | "item.minecraft.turtle_spawn_egg" | "narration.cycle_button.usage.hovered" | "block.minecraft.banner.half_vertical.light_gray" | "item.irons_spellbooks.heavy_chain_necklace" | "commands.curios.reset.success" | "item.minecraft.pottery_shard_archer" | "forge.froge.warningScreen.text" | "entity.minecraft.leash_knot" | "key.categories.multiplayer" | "advancements.adventure.shoot_arrow.description" | "soundCategory.block" | "multiplayer.disconnect.expired_public_key" | "subtitles.entity.mule.hurt" | "createWorld.customize.flat.layer" | "tooltip.irons_spellbooks.level_plus" | "entity.minecraft.ocelot" | "block.minecraft.cyan_candle" | "enchantment.stalwart_dungeons.thunder_strike.desc" | "fml.menu.mods.openmodsfolder" | "__comment_jei" | "stat.minecraft.interact_with_lectern" | "advancements.irons_spellbooks.spell_book_blood_staff.description" | "structure_block.mode.save" | "block.minecraft.chest" | "stat_type.minecraft.dropped" | "block.minecraft.furnace" | "curios.modifiers.curio" | "commands.attribute.failed.modifier_already_present" | "gamerule.naturalRegeneration" | "config.jade.display_fluids_none" | "mco.configure.world.switch.slot" | "subtitles.entity.chicken.death" | "item.minecraft.phantom_membrane" | "block.minecraft.banner.border.red" | "subtitles.entity.evoker.prepare_wololo" | "enchantment.improved_exp.pain_relief.desc" | "selectWorld.tooltip.fromNewerVersion2" | "item.minecraft.cat_spawn_egg" | "selectWorld.tooltip.fromNewerVersion1" | "jade.theme.jade.dark" | "block.minecraft.cut_red_sandstone" | "block.minecraft.oxidized_copper" | "commands.ban.success" | "options.realmsNotifications" | "jade.nextEgg" | "config.jade.debug_mode" | "advancements.adventure.trim_with_any_armor_pattern.title" | "block.minecraft.jungle_sign" | "subtitles.entity.firework_rocket.twinkle" | "block.minecraft.banner.circle.white" | "affix.irons_spellbooks:spellbook/attribute/mana" | "biome.minecraft.jagged_peaks" | "entity.irons_spellbooks.summoned_skeleton" | "commands.difficulty.failure" | "multiplayer.disconnect.generic" | "gui.cancel" | "block.minecraft.redstone_wall_torch" | "commands.data.storage.get" | "demo.help.movementShort" | "block.minecraft.white_carpet" | "item.irons_spellbooks.cryomancer_spawn_egg" | "enchantment.dungeonsenchantments.recycler.desc" | "death.attack.cramming" | "subtitles.entity.vex.hurt" | "spell.irons_spellbooks.fireball" | "block.minecraft.red_sandstone" | "subtitles.item.bottle.empty" | "item.irons_spellbooks.blood_rune" | "commands.difficulty.success" | "commands.team.option.friendlyfire.alreadyEnabled" | "options.difficulty.hard" | "item.minecraft.smithing_template.upgrade" | "item.minecraft.ocelot_spawn_egg" | "mco.configure.world.reset.question.line1" | "affix.irons_spellbooks:sword/attribute/mana_regen.suffix" | "mco.configure.world.reset.question.line2" | "jade.instrument.xylophone" | "item.minecraft.potion.effect.invisibility" | "telemetry.event.world_load_times.title" | "commands.clear.success.single" | "spell.irons_spellbooks.icicle.guide" | "block.minecraft.mangrove_door" | "createWorld.customize.custom.useCaves" | "advancements.adventure.ol_betsy.description" | "item.minecraft.music_disc_wait.desc" | "block.minecraft.banner.stripe_downright.light_gray" | "gui.banned.description.temporary.duration" | "effect.irons_spellbooks.evasion" | "subtitles.entity.sniffer.death" | "sodium.console.broken_nvidia_driver" | "addServer.add" | "attribute.name.generic.attack_knockback" | "mco.configure.world.uninvite.question" | "enchantment.improved_exp.auto_repair.desc" | "entity.irons_spellbooks.sunbeam" | "config.jade.plugin_minecraft.entity_health.show_fractions" | "block.minecraft.light_gray_stained_glass" | "subtitles.entity.villager.work_librarian" | "spell.irons_spellbooks.summon_vex" | "ui.irons_spellbooks.aoe_damage" | "commands.forge.tags.error.unknown_registry" | "filled_map.mansion" | "item.minecraft.gold_nugget" | "permissions.requires.player" | "subtitles.entity.zombie_horse.death" | "item.minecraft.smithing_template.armor_trim.additions_slot_description" | "block.minecraft.banner.diagonal_up_right.brown" | "block.minecraft.black_candle" | "block.minecraft.dripstone_block" | "commands.place.feature.invalid" | "mco.configure.world.switch.slot.subtitle" | "jigsaw_block.final_state" | "jade.up" | "item.minecraft.shield.light_blue" | "mco.download.speed" | "trim_material.minecraft.gold" | "ui.irons_spellbooks.freeze_time" | "fml.menu.mods.info.signature.unsigned" | "block.minecraft.banner.stripe_bottom.white" | "block.minecraft.daylight_detector" | "entity.minecraft.illusioner" | "tooltip.jade.mode_subtractor" | "item.irons_spellbooks.cultist_helmet" | "subtitles.entity.cat.beg_for_food" | "patchouli.gui.lexicon.external_link" | "options.visible" | "block.minecraft.green_candle" | "advancements.irons_spellbooks.spell_book_netherite.title" | "effect.irons_spellbooks.gluttony" | "commands.scoreboard.objectives.display.cleared" | "tetra.material.irons_spellbooks_lightning_rune_socket.prefix" | "subtitles.block.piston.move" | "key.jei.cheatItemStack2" | "block.minecraft.orange_carpet" | "forge.configgui.forgeLightPipelineEnabled.tooltip" | "mco.configure.world.players.inviting" | "options.chat.width" | "text.apotheosis.category.curios:spellbook.plural" | "item.minecraft.danger_pottery_shard" | "mco.configure.world.buttons.activity" | "options.graphics.fast" | "enchantment.minecraft.efficiency.desc" | "spell.irons_spellbooks.wither_skull" | "sodium.options.pages.performance" | "debug.show_hitboxes.on" | "attribute.name.generic.max_health" | "entity.minecraft.block_display" | "selectWorld.gameMode.spectator" | "entity.minecraft.tropical_fish.type.blockfish" | "painting.dimensions" | "container.chest" | "item.minecraft.gunpowder" | "gui.jade.search.hint" | "patchouli.gui.lexicon.mark_complete" | "gui.banned.reason.generic_violation" | "jei.tooltip.error.recipe.transfer.too.large.player.inventory" | "block.minecraft.banner.stripe_right.yellow" | "painting.minecraft.burning_skull.author" | "block.minecraft.polished_diorite_stairs" | "item.irons_spellbooks.evocation_rune" | "mco.download.extracting" | "block.minecraft.banner.piglin.white" | "entity.irons_spellbooks.poison_cloud" | "block.minecraft.banner.diagonal_left.magenta" | "block.minecraft.dark_oak_trapdoor" | "subtitles.entity.parrot.hurts" | "mco.configure.world.title" | "commands.scoreboard.players.set.success.multiple" | "forge.configgui.zombieBaseSummonChance" | "mco.selectServer.expires.soon" | "item.irons_spellbooks.translated_archevoker_log" | "commands.team.list.members.success" | "item.irons_spellbooks.pumpkin_helmet" | "advancements.irons_spellbooks.make_arcane_anvil.title" | "block.minecraft.potted_wither_rose" | "block.minecraft.powder_snow_cauldron" | "item.minecraft.leather_helmet" | "block.minecraft.spruce_wood" | "tooltip.irons_spellbooks.can_be_imbued_number" | "commands.bossbar.set.visibility.unchanged.hidden" | "fml.modloading.failedtoprocesswork" | "block.minecraft.smooth_red_sandstone_stairs" | "options.fov.max" | "config.jei.search.modNameSearchMode.comment" | "commands.advancement.grant.one.to.many.failure" | "item.irons_spellbooks.oakskin_elixir" | "commands.advancement.grant.one.to.many.success" | "item.minecraft.brewer_pottery_shard" | "spell.irons_spellbooks.electrocute.guide" | "options.fullscreen.resolution" | "jade.instrument.wither_skeleton" | "death.attack.irons_spellbooks.lightning_lance" | "entity.minecraft.silverfish" | "multiplayer.status.cannot_connect" | "enchantment.minecraft.binding_curse" | "block.minecraft.birch_fence_gate" | "commands.pardonip.success" | "block.minecraft.banner.mojang.light_gray" | "options.chat.color" | "advancements.irons_spellbooks.spell_book_blood_staff.title" | "debug.chunk_boundaries.on" | "item.irons_spellbooks.scroll.unlearned" | "subtitles.entity.strider.happy" | "subtitles.entity.zombie_villager.death" | "block.minecraft.red_stained_glass" | "commands.team.empty.unchanged" | "selectWorld.import_worldgen_settings.failure" | "item.minecraft.firework_rocket.flight" | "advancements.end.dragon_egg.title" | "death.attack.irons_spellbooks.burning_dash.item" | "options.ao.off" | "forge.configgui.forgeCloudsEnabled" | "block.minecraft.potted_lily_of_the_valley" | "block.minecraft.banner.diagonal_up_right.purple" | "subtitles.item.honey_bottle.drink" | "lanserverproperties.gui.pvp_allowed" | "item.minecraft.lime_dye" | "enchantment.improved_exp.fire_resistance.desc" | "mco.configure.world.buttons.moreoptions" | "block.minecraft.spruce_trapdoor" | "block.titanium.machine_test" | "entity.minecraft.fishing_bobber" | "subtitles.entity.llama.eat" | "block.minecraft.acacia_fence_gate" | "narration.jade.blockpos" | "commands.irons_spellbooks.create_spell_book.failed" | "gui.recipebook.toggleRecipes.all" | "block.minecraft.deepslate_lapis_ore" | "options.sounds.title" | "biome.minecraft.badlands" | "item.irons_spellbooks.lightning_rune" | "block.minecraft.dark_oak_wood" | "block.minecraft.dark_prismarine_stairs" | "command.exception" | "enchantment.improved_exp.passage.desc" | "config.jade.plugin_minecraft.note_block" | "block.minecraft.blue_bed" | "block.minecraft.oak_leaves" | "subtitles.entity.silverfish.death" | "modernfix.option.mixin.perf.cache_profile_texture_url" | "item.minecraft.smithing_template.netherite_upgrade.base_slot_description" | "sodium.options.smooth_lighting.tooltip" | "block.minecraft.moss_carpet" | "config.jade.plugin_create.placard" | "block.minecraft.cracked_polished_blackstone_bricks" | "item.minecraft.wolf_spawn_egg" | "structure_block.save_success" | "entity.minecraft.slime" | "modernfix.option.mixin.perf.patchouli_deduplicate_books" | "enchantment.improved_exp.true_shot.desc" | "advancements.story.form_obsidian.description" | "commands.scoreboard.objectives.list.success" | "block.minecraft.banner.stripe_middle.purple" | "item.minecraft.witch_spawn_egg" | "selectWorld.experiments" | "advancements.husbandry.netherite_hoe.title" | "commands.worldborder.set.shrink" | "block.minecraft.banner.flower.green" | "subtitles.entity.guardian.hurt" | "fabric-registry-sync-v0.unknown-remote.title.singular" | "item.minecraft.shield.gray" | "mco.template.info.tooltip" | "enchantment.minecraft.vanishing_curse.desc" | "commands.perf.started" | "entity.irons_spellbooks.summoned_zombie" | "gui.banned.reason.hate_speech" | "key.keyboard.comma" | "options.telemetry" | "config.jade.display_mode_lite_desc" | "selectWorld.backupQuestion.customized" | "options.mainHand.left" | "gui.banned.description.reason" | "structure_block.hover.data" | "commands.mana.get.success" | "block.minecraft.cyan_concrete" | "fml.dependencyloading.conflictingdependencies" | "block.minecraft.banner.diagonal_up_left.orange" | "quickplay.error.invalid_identifier" | "gui.curios.page" | "subtitles.entity.villager.no" | "spell.irons_spellbooks.wisp.guide" | "menu.resetdemo" | "enchantment.minecraft.quick_charge.desc" | "enchantment.minecraft.riptide.desc" | "block.minecraft.sweet_berry_bush" | "modernfix.option.mixin.perf.compact_bit_storage" | "block.minecraft.acacia_pressure_plate" | "block.minecraft.weathered_copper" | "enchantment.minecraft.depth_strider" | "entity.minecraft.experience_bottle" | "death.attack.irons_spellbooks.firefly_swarm.item" | "block.minecraft.banner.triangle_bottom.light_gray" | "subtitles.entity.generic.swim" | "subtitles.entity.villager.celebrate" | "item.irons_spellbooks.scroll" | "enchantment.improved_exp.rock_crusher.desc" | "spell.irons_spellbooks.spectral_hammer.guide" | "block.minecraft.turtle_egg" | "ui.irons_spellbooks.scroll_forge_title" | "enchantment.minecraft.power.desc" | "subtitles.entity.llama.angry" | "subtitles.entity.spider.ambient" | "debug.profiling.start" | "subtitles.block.anvil.use" | "options.difficulty.hardcore" | "subtitles.entity.warden.angry" | "item.minecraft.phantom_spawn_egg" | "block.minecraft.end_stone_brick_stairs" | "death.attack.cactus.player" | "block.minecraft.warped_button" | "chat.type.emote" | "subtitles.item.bucket.fill_tadpole" | "key.keyboard.keypad.enter" | "enchantment.improved_exp.healing_waters.desc" | "block.minecraft.dark_oak_log" | "commands.pardon.failed" | "argument.entity.options.x_rotation.description" | "options.multiplier" | "commands.advancement.revoke.one.to.many.failure" | "options.clouds.fast" | "mco.errorMessage.connectionFailure" | "item.irons_spellbooks.cryomancer_chestplate" | "biome.minecraft.snowy_taiga" | "options.attack.crosshair" | "death.attack.irons_spellbooks.firecracker" | "jigsaw_block.joint.aligned" | "record.nowPlaying" | "advancements.husbandry.axolotl_in_a_bucket.description" | "modernfix.option.mixin.perf.dynamic_structure_manager" | "block.minecraft.black_carpet" | "block.minecraft.bubble_coral_block" | "text.cloth-config.testing.3" | "commands.spreadplayers.failed.invalid.height" | "text.cloth-config.testing.2" | "options.key" | "block.minecraft.brown_candle_cake" | "text.cloth-config.testing.1" | "enchantment.minecraft.lure.desc" | "config.jei" | "block.minecraft.banner.skull.purple" | "commands.trigger.set.success" | "commands.forge.entity.list.multiple.header" | "item.minecraft.netherite_chestplate" | "item.minecraft.mojang_banner_pattern.desc" | "trim_material.minecraft.emerald" | "spell.irons_spellbooks.chain_lightning.guide" | "block.minecraft.magenta_candle" | "spell.irons_spellbooks.poison_arrow" | "mco.configure.world.settings.title" | "config.jade.plugin_minecraft.lectern" | "block.minecraft.pitcher_crop" | "fml.modloading.missingdependency.optional" | "item.minecraft.smithing_template.netherite_upgrade.ingredients" | "death.attack.magic" | "config.jei.search.tagSearchMode" | "commands.fill.success" | "enchantment.shieldsplus.shield_bash.desc" | "modernfix.option.mixin.perf.dynamic_block_codecs" | "item.minecraft.music_disc_mellohi" | "block.minecraft.mud_brick_stairs" | "block.minecraft.jungle_button" | "stat.minecraft.open_shulker_box" | "item.irons_spellbooks.blood_upgrade_orb" | "createWorld.customize.custom.useMineShafts" | "item.minecraft.lead" | "subtitles.entity.turtle.egg_break" | "subtitles.block.lever.click" | "item.minecraft.golden_apple" | "spell.irons_spellbooks.chain_creeper" | "block.minecraft.banner.stripe_downright.gray" | "enchantment.improved_exp.golden_fever.desc" | "block.minecraft.hopper" | "commands.save.alreadyOn" | "subtitles.entity.cod.death" | "item.irons_spellbooks.cryomancer_helmet" | "gui.socialInteractions.status_blocked" | "modernfix.option.mixin.bugfix.item_cache_flag" | "modernfix.option.mixin.perf.faster_advancements" | "advancements.nether.fast_travel.title" | "subtitles.entity.dolphin.swim" | "advancements.nether.ride_strider.description" | "option.cloth-config.scrollStep" | "fml.menu.mods.info.version" | "block.minecraft.cracked_stone_bricks" | "block.minecraft.banner.half_horizontal.light_blue" | "block.minecraft.slime_block" | "config.jade.plugin_create.exact_block" | "block.minecraft.banner.bricks.cyan" | "patchouli.gui.lexicon.button.prev_page" | "createWorld.customize.custom.baseSize" | "commands.effect.clear.specific.failed" | "block.minecraft.end_rod" | "block.minecraft.pink_carpet" | "item.irons_spellbooks.nature_rune" | "spell.irons_spellbooks.burning_dash" | "painting.minecraft.pool.author" | "item.minecraft.tipped_arrow.effect.strength" | "biome.minecraft.eroded_badlands" | "block.minecraft.polished_granite_stairs" | "upgrade.minecraft.netherite_upgrade" | "config.jade.plugin_minecraft.harvest_tool.new_line" | "block.minecraft.smooth_quartz" | "subtitles.entity.tnt.primed" | "modernfix.option.mixin.perf.datapack_reload_exceptions" | "symlink_warning.message" | "block.minecraft.banner.curly_border.light_gray" | "entity.irons_spellbooks.guiding_bolt" | "gui.chatReport.draft.quittotitle.content" | "block.minecraft.banner.half_horizontal.yellow" | "subtitles.block.brewing_stand.brew" | "selectWorld.deleteButton" | "commands.forceload.removed.failure" | "selectWorld.experiments.info" | "item.minecraft.splash_potion.effect.turtle_master" | "gui.socialInteractions.hide" | "gui.jei.category.smelting.experience" | "block.minecraft.banner.gradient.light_blue" | "selectWorld.title" | "subtitles.entity.armor_stand.fall" | "mco.upload.entry.id" | "block.minecraft.acacia_fence" | "entity.minecraft.tropical_fish.type.dasher" | "block.minecraft.warped_wall_sign" | "block.minecraft.white_candle" | "entity.minecraft.enderman" | "item.apotheosis.gem.irons_spellbooks:evocation" | "subtitles.block.portal.travel" | "block.minecraft.orange_candle" | "block.minecraft.stripped_acacia_wood" | "block.minecraft.gray_terracotta" | "block.minecraft.light_blue_concrete_powder" | "subtitles.entity.item_frame.add_item" | "forge.configgui.showLoadWarnings" | "jade.zombieConversion.time" | "advancements.nether.root.title" | "block.minecraft.banner.diagonal_up_right.blue" | "key.keyboard.semicolon" | "gamerule.blockExplosionDropDecay" | "fluid.moonlight.generic_fluid" | "block.minecraft.banner.straight_cross.light_gray" | "block.minecraft.banner.triangles_top.orange" | "biome.minecraft.deep_ocean" | "mco.backup.entry.gameServerVersion" | "tooltip.titanium.facing_handler.front" | "sodium.console.core_shaders_warn" | "effect.minecraft.glowing" | "block.minecraft.banner.small_stripes.light_gray" | "options.mouse_settings" | "fml.menu.multiplayer.extraservermods" | "advancements.nether.all_effects.description" | "commands.item.target.no_changed.known_item" | "subtitles.entity.generic.burn" | "block.minecraft.spruce_stairs" | "death.attack.irons_spellbooks.summon_polar_bear" | "advancements.adventure.trim_with_any_armor_pattern.description" | "block.minecraft.banner.small_stripes.pink" | "debug.profiling.stop" | "item.minecraft.drowned_spawn_egg" | "item.minecraft.glow_item_frame" | "narration.jade.health" | "config.jade.plugin_minecraft.item_storage.normal_amount" | "advancements.husbandry.fishy_business.title" | "multiplayer.requiredTexturePrompt.line2" | "multiplayer.requiredTexturePrompt.line1" | "item.minecraft.splash_potion.effect.empty" | "selectWorld.experimental.details.entry" | "tetra.material.irons_spellbooks_evocation_rune_socket" | "subtitles.entity.generic.extinguish_fire" | "spectatorMenu.root.prompt" | "painting.minecraft.burning_skull.title" | "options.accessibility.link" | "translation.test.world" | "block.minecraft.polished_deepslate_slab" | "options.graphics" | "commands.trigger.add.success" | "subtitles.block.pointed_dripstone.drip_water" | "gui.banned.reason.nudity_or_pornography" | "enchantment.improved_exp.harm.desc" | "block.minecraft.blue_banner" | "block.minecraft.mangrove_slab" | "block.minecraft.banner.rhombus.brown" | "chat.type.admin" | "gui.jei.editMode.description.hide.wild" | "tooltip.irons_spellbooks.cast_type" | "deathScreen.respawn" | "subtitles.block.beacon.activate" | "subtitles.entity.warden.sonic_boom" | "createWorld.customize.custom.preset.isleLand" | "options.glintSpeed.tooltip" | "mount.onboard" | "subtitles.entity.cat.hiss" | "block.minecraft.nether_gold_ore" | "modernfix.option.mixin.perf.reuse_datapacks" | "item.minecraft.explorer_pottery_shard" | "block.minecraft.banner.flower.gray" | "multiplayer.disconnect.outdated_server" | "block.minecraft.banner.diagonal_up_right.lime" | "block.minecraft.nether_wart" | "commands.ban.failed" | "stat.minecraft.interact_with_stonecutter" | "key.jei.previousPage" | "item.minecraft.smithing_template.netherite_upgrade.additions_slot_description" | "subtitles.block.lava.ambient" | "block.minecraft.scaffolding" | "subtitles.entity.fox.bite" | "item.minecraft.potion.effect.levitation" | "mco.upload.select.world.none" | "death.attack.blood_cauldron" | "spell.irons_spellbooks.summon_horse.guide" | "createWorld.customize.custom.center" | "createWorld.customize.custom.confirmTitle" | "subtitles.entity.camel.stand" | "spell.irons_spellbooks.raise_dead" | "spell.irons_spellbooks.wololo.guide" | "item.minecraft.pufferfish_spawn_egg" | "commands.team.option.nametagVisibility.success" | "item.minecraft.elytra" | "modernfix.option.mixin.perf.sync_executor_sleep" | "biome.minecraft.deep_frozen_ocean" | "block.minecraft.banner.creeper.pink" | "commands.scoreboard.players.remove.success.multiple" | "lanserverproperties.options.online_mode.off.vanilla.message" | "block.minecraft.banner.diagonal_right.blue" | "key.inventory" | "structure_block.mode_info.data" | "gui.socialInteractions.server_label.multiple" | "options.telemetry.state.none" | "gamerule.doImmediateRespawn" | "modernfix.option.mixin.perf.dynamic_entity_renderers" | "advancements.adventure.voluntary_exile.title" | "enchantment.improved_exp.rebound.desc" | "mco.backup.nobackups" | "gui.chatReport.selected_chat" | "argument.entity.options.unknown" | "commands.place.feature.failed" | "subtitles.entity.turtle.egg_hatch" | "item.minecraft.mutton" | "fml.menu.multiplayer.vanilla.incompatible" | "modernfix.option.mixin.perf.forge_cap_retrieval" | "jade.beehive.honey" | "block.minecraft.banner.curly_border.brown" | "entity.minecraft.cave_spider" | "disconnect.unknownHost" | "gui.continue" | "sodium.options.use_no_error_context.name" | "controls.keybinds.title" | "forge.configgui.alwaysSetupTerrainOffThread.tooltip" | "spell.irons_spellbooks.summon_polar_bear.guide" | "block.minecraft.banner.half_vertical_right.magenta" | "enchantment.improved_exp.weight.desc" | "subtitles.item.bundle.remove_one" | "commands.data.entity.get" | "entity.geckolib.mutant_zombie.equip" | "enchantment.improved_exp.ore_detector.desc" | "commands.advancement.revoke.criterion.to.one.failure" | "block.minecraft.skeleton_wall_skull" | "subtitles.entity.frog.death" | "gameMode.survival" | "item.minecraft.sign" | "forge.froge.supportWarning" | "block.minecraft.purpur_stairs" | "commands.scoreboard.objectives.display.alreadySet" | "block.minecraft.banner.circle.green" | "entity.minecraft.llama" | "commands.forge.tags.page_info" | "subtitles.entity.iron_golem.death" | "subtitles.entity.parrot.imitate.stray" | "item.minecraft.lingering_potion.effect.healing" | "mco.configure.world.location" | "tooltip.irons_spellbooks.cooldown_length_seconds" | "enchantment.grapplemod.slidingenchantment.desc" | "death.attack.blood_magic.player" | "modernfix.option.mixin.perf.mojang_registry_size" | "forge.controlsgui.shift" | "tetra.material.irons_spellbooks_protection_rune_socket" | "argument.float.low" | "block.minecraft.banner.half_vertical.brown" | "lanserverproperties.options.preference_enabled.message" | "ui.irons_spellbooks.no_selection" | "block.minecraft.hay_block" | "createWorld.customize.flat.removeLayer" | "mco.configure.world.players.error" | "block.minecraft.banner.stripe_bottom.light_gray" | "block.minecraft.crimson_fungus" | "item.irons_spellbooks.protection_upgrade_orb" | "subtitles.entity.sniffer.happy" | "curios.identifier.back" | "ui.irons_spellbooks.max_victims" | "sodium.options.use_block_face_culling.tooltip" | "selectWorld.versionJoinButton" | "gameMode.adventure" | "tooltip.irons_spellbooks.level_minus" | "tooltip.irons_spellbooks.evasion_description" | "config.jei.search.modNameSearchMode" | "subtitles.entity.bee.pollinate" | "block.minecraft.note_block" | "item.minecraft.golden_leggings" | "item.minecraft.pumpkin_pie" | "subtitles.item.crop.plant" | "mco.configure.world.subscription.remaining.months.days" | "subtitles.entity.camel.saddle" | "commands.bossbar.create.success" | "item.irons_spellbooks.cooldown_upgrade_orb" | "moon.phase.full" | "block.minecraft.banner.curly_border.lime" | "advancements.irons_spellbooks.spell_book_gold.title" | "mco.brokenworld.downloaded" | "patchouli.gui.lexicon.progress_tooltip.secret1" | "advancements.story.mine_diamond.description" | "block.minecraft.red_shulker_box" | "subtitles.entity.turtle.swim" | "block.minecraft.banner.flower.light_blue" | "painting.minecraft.aztec2.author" | "stat_type.minecraft.broken" | "subtitles.entity.fishing_bobber.retrieve" | "block.minecraft.wall_torch" | "entity.minecraft.horse" | "mco.backup.info.title" | "config.jade.plugin_minecraft.entity_health" | "options.audioDevice" | "key.spectatorOutlines" | "block.minecraft.diorite_stairs" | "block.minecraft.acacia_wall_hanging_sign" | "block.minecraft.light_gray_terracotta" | "ui.irons_spellbooks.mana_recovery" | "block.minecraft.banner.piglin.black" | "config.jade.plugin_jade.coordinates.rel" | "attribute.name.generic.armor_toughness" | "block.minecraft.banner.stripe_bottom.green" | "block.minecraft.banner.square_top_left.red" | "item.geckolib.bat_spawn_egg" | "death.attack.indirectMagic.item" | "config.jade.plugin_mcjtylib.jadeaddons" | "gamerule.doMobLoot" | "item.minecraft.music_disc_otherside" | "block.minecraft.banner.small_stripes.brown" | "block.minecraft.player_head" | "item.irons_spellbooks.electromancer_chestplate" | "advancements.end.enter_end_gateway.description" | "item.patchouli:test_book_2.landing" | "__support_endlessbiomes" | "dataPack.validation.back" | "item.minecraft.netherite_scrap" | "modernfix.option.mixin.bugfix.removed_dimensions" | "argument.item.tag.disallowed" | "options.key.hold" | "spell.irons_spellbooks.blood_step.guide" | "selectWorld.recreate.error.title" | "patchouli.gui.lexicon.multiblock_bookmark" | "jade.instrument.creeper" | "filled_map.id" | "gui.socialInteractions.tooltip.show" | "subtitles.entity.phantom.flap" | "generator.single_biome_caves" | "subtitles.entity.rabbit.hurt" | "subtitles.entity.ravager.roar" | "sodium.option_impact.medium" | "block.minecraft.banner.mojang.blue" | "advancements.irons_spellbooks.spell_book_druidic.description" | "item.irons_spellbooks.netherite_mage_helmet" | "mco.upload.preparing" | "item.irons_spellbooks.ancient_knowledge_fragment" | "block.minecraft.banner.stripe_left.brown" | "enchantment.minecraft.loyalty" | "block.minecraft.banner.circle.black" | "menu.loadingForcedChunks" | "subtitles.entity.illusioner.hurt" | "block.minecraft.torchflower_crop" | "config.jei.search" | "item.irons_spellbooks.arcane_rune" | "subtitles.entity.silverfish.hurt" | "gui.jei.editMode.description" | "block.minecraft.banner.square_top_right.pink" | "block.minecraft.banner.curly_border.blue" | "item.minecraft.blade_pottery_shard" | "block.minecraft.banner.square_top_left.gray" | "block.minecraft.mangrove_leaves" | "selectWorld.enterSeed" | "subtitles.block.pointed_dripstone.land" | "pack.source.feature" | "ui.irons_spellbooks.ring_count" | "forge.configgui.clumpingThreshold.tooltip" | "commands.publish.failed" | "gui.proceed" | "time.bookshelf.day.monday" | "block.minecraft.banner.rhombus.pink" | "item.minecraft.blaze_rod" | "ui.irons_spellbooks.arcane_anvil_title" | "structure_block.position" | "item.minecraft.tipped_arrow.effect.turtle_master" | "config.jade.plugin_deepresonance.crystal" | "ui.irons_spellbooks.duration" | "spell.irons_spellbooks.echoing_strikes" | "item.minecraft.iron_sword" | "subtitles.entity.mooshroom.suspicious_milk" | "death.fell.accident.vines" | "spell.irons_spellbooks.sculk_tentacles" | "effect.irons_spellbooks.heartstop.description" | "jei.key.category.overlays" | "block.minecraft.banner.stripe_downleft.cyan" | "block.minecraft.banner.bricks.magenta" | "effect.irons_spellbooks.abyssal_shroud.description" | "gui.socialInteractions.show" | "container.creative" | "block.minecraft.banner.mojang.lime" | "entity.minecraft.armor_stand" | "telemetry.property.world_load_time_ms.title" | "block.minecraft.banner.stripe_center.gray" | "spell.irons_spellbooks.fire_breath.guide" | "entity.minecraft.zoglin" | "gui.narrate.tab" | "modernfix.option.on" | "block.minecraft.candle_cake" | "fml.modloading.brokenfile.invalidzip" | "subtitles.entity.cow.death" | "lanserverproperties.options.online_mode.off.vanilla" | "effect.minecraft.invisibility" | "modernfix.option.mixin.bugfix.forge_vehicle_packets" | "gamerule.mobExplosionDropDecay.description" | "block.minecraft.acacia_leaves" | "block.minecraft.banner.stripe_bottom.black" | "time.bookshelf.month.january" | "commands.effect.clear.everything.failed" | "block.minecraft.banner.gradient.red" | "spell.irons_spellbooks.angel_wing" | "block.minecraft.banner.diagonal_right.lime" | "block.minecraft.banner.flower.black" | "options.chat.visibility" | "block.minecraft.warped_stem" | "effect.irons_spellbooks.antigravity" | "enchantment.minecraft.punch.desc" | "block.minecraft.soul_wall_torch" | "death.attack.witherSkull" | "mco.brokenworld.reset" | "block.minecraft.banner.triangle_bottom.cyan" | "potion.potency.5" | "tutorial.craft_planks.description" | "key.keyboard.keypad.multiply" | "commands.scoreboard.players.add.success.single" | "item.minecraft.lingering_potion.effect.luck" | "gui.chatReport.draft.title" | "block.minecraft.banner.stripe_right.magenta" | "gamerule.universalAnger" | "subtitles.entity.cow.hurt" | "subtitles.item.hoe.till" | "stat.minecraft.walk_on_water_one_cm" | "item.minecraft.friend_pottery_shard" | "block.titanium.block_twenty_four_test" | "commands.save.saving" | "item.irons_spellbooks.lightning_rod" | "item.irons_spellbooks.necromancer_spawn_egg" | "forge.name_tag_distance" | "block.minecraft.dead_fire_coral_block" | "block.minecraft.birch_planks" | "block.minecraft.stone_slab" | "gui.jei.category.fuel.smeltCount.single" | "gamerule.spectatorsGenerateChunks" | "entity.minecraft.guardian" | "potion.potency.0" | "death.attack.irons_spellbooks.wither_skull" | "config.jade.display_mode_extra_msg" | "gui.abuseReport.reason.false_reporting" | "block.minecraft.frosted_ice" | "modernfix.option.mixin.feature.disable_unihex_font" | "potion.potency.4" | "block.minecraft.oak_slab" | "commands.whitelist.alreadyOff" | "potion.potency.3" | "advancements.irons_spellbooks.root.description" | "potion.potency.2" | "potion.potency.1" | "selectWorld.futureworld.error.text" | "block.minecraft.pearlescent_froglight" | "mco.selectServer.minigameNotSupportedInVersion" | "translation.test.args" | "forge.configgui.disableVersionCheck" | "entity.minecraft.painting" | "__support_dungeonsenchantments" | "config.jade.overlay_alpha_extra_msg" | "selectWorld.experimental.details" | "item.apotheosis.gem.irons_spellbooks:lightning" | "hanging_sign.edit" | "config.jade.plugin_jade.block_face_extra_msg" | "entity.minecraft.villager.librarian" | "config.jei.interface.overlayEnabled.comment" | "enchantment.minecraft.fortune.desc" | "argument.entity.options.y_rotation.description" | "config.jade.plugin_minecraft.chicken_egg" | "affix.irons_spellbooks:sword/attribute/spell_power" | "commands.forge.tags.registry_key" | "advancements.story.lava_bucket.title" | "narration.checkbox" | "argument.curios.type.unknown" | "item.minecraft.vex_spawn_egg" | "stat.minecraft.boat_one_cm" | "biome.minecraft.dripstone_caves" | "subtitles.block.big_dripleaf.tilt_up" | "gui.banned.description.reason_id_message" | "advancements.adventure.spyglass_at_parrot.title" | "block.minecraft.banner.circle.red" | "debug.gamemodes.press_f4" | "tooltip.irons_spellbooks.can_be_imbued_frame" | "spell.irons_spellbooks.fang_strike" | "block.minecraft.muddy_mangrove_roots" | "event.minecraft.raid" | "enchantment.minecraft.power" | "options.prioritizeChunkUpdates.none" | "subtitles.entity.ravager.hurt" | "block.minecraft.warped_pressure_plate" | "block.minecraft.horn_coral_fan" | "enchantment.improved_exp.digger.desc" | "effect.irons_spellbooks.charged" | "advancements.toast.challenge" | "enchantment.improved_exp.fear_of_dark.desc" | "commands.experience.add.points.success.single" | "item.minecraft.zoglin_spawn_egg" | "rarity.irons_spellbooks.mythic" | "generator.minecraft.amplified" | "advancements.irons_spellbooks.spell_book_gold.description" | "subtitles.block.bubble_column.upwards_inside" | "item.minecraft.lingering_potion.effect.water" | "tooltip.titanium.facing_handler.direction" | "commands.team.empty.success" | "death.fell.accident.weeping_vines" | "mco.configure.world.slot.empty" | "enchantment.minecraft.lure" | "item.minecraft.miner_pottery_shard" | "affix.irons_spellbooks:armor/attribute/spell_resist" | "commands.team.option.color.unchanged" | "subtitles.entity.axolotl.idle_air" | "spell.irons_spellbooks.evasion" | "argument.nbt.expected.value" | "mco.backup.entry.name" | "soundCategory.neutral" | "block.minecraft.pointed_dripstone" | "subtitles.block.generic.place" | "enchantment.minecraft.piercing.desc" | "advancements.nether.summon_wither.title" | "mco.configure.world.edit.subscreen.adventuremap" | "block.minecraft.banner.diagonal_left.white" | "block.minecraft.banner.small_stripes.magenta" | "subtitles.entity.blaze.ambient" | "gamerule.fireDamage" | "commands.pardonip.failed" | "telemetry.event.game_load_times.title" | "block.minecraft.banner.diagonal_up_right.white" | "telemetry.event.world_loaded.title" | "stat.minecraft.talked_to_villager" | "fml.messages.version.restriction.upper.inclusive" | "title.multiplayer.lan" | "advancements.irons_spellbooks.staff_ice.title" | "spell.irons_spellbooks.wisp" | "commands.effect.give.failed" | "subtitles.entity.zombified_piglin.hurt" | "spell.irons_spellbooks.black_hole.guide" | "advancements.husbandry.tadpole_in_a_bucket.description" | "item.irons_spellbooks.invisibility_ring" | "block.minecraft.bamboo_pressure_plate" | "painting.minecraft.aztec.author" | "item.irons_spellbooks.cinder_essence" | "jei.key.category.cheat.mode" | "demo.help.buy" | "mco.error.invalid.session.title" | "subtitles.entity.lightning_bolt.thunder" | "disconnect.loginFailedInfo.serversUnavailable" | "mco.warning" | "item.minecraft.disc_fragment_5.desc" | "mco.configure.world.closing" | "block.minecraft.yellow_concrete" | "entity.minecraft.villager.armorer" | "subtitles.entity.sniffer.idle" | "config.jade.plugin_debug.furnace_fuel.float_cfg" | "block.minecraft.cherry_stairs" | "mco.backup.button.restore" | "gui.socialInteractions.title" | "item.minecraft.ravager_spawn_egg" | "block.minecraft.twisting_vines_plant" | "block.minecraft.banner.half_vertical.white" | "effect.minecraft.hero_of_the_village" | "createWorld.customize.flat.layer.top" | "patchouli.subtitle.book_open" | "mco.reset.world.warning" | "death.attack.arrow" | "block.minecraft.void_air" | "effect.irons_spellbooks.hastened" | "item.minecraft.ghast_spawn_egg" | "effect.irons_spellbooks.true_invisibility.description" | "block.minecraft.gray_concrete_powder" | "commands.place.template.invalid" | "multiplayer.disconnect.ip_banned" | "mco.download.cancelled" | "options.percent_add_value" | "text.cloth-config.dropdown.value.unknown" | "item.minecraft.firework_star.light_gray" | "advancements.irons_spellbooks.spell_book_blaze.description" | "enchantment.deeperdarker.sculk_smite.desc" | "entity.minecraft.zombie_horse" | "argument.resource.not_found" | "flat_world_preset.minecraft.bottomless_pit" | "subtitles.entity.turtle.shamble" | "argument.entity.options.valueless" | "addServer.resourcePack" | "commands.worldborder.get" | "key.screenshot" | "entity.irons_spellbooks.shield" | "gui.banned.title.temporary" | "block.minecraft.banner.triangles_bottom.cyan" | "block.minecraft.white_concrete" | "attribute.irons_spellbooks.spell_resist" | "block.minecraft.birch_wall_sign" | "enchantment.improved_exp.quick_kill.desc" | "advancements.husbandry.ride_a_boat_with_a_goat.title" | "death.attack.irons_spellbooks.fire_breath" | "block.minecraft.banner.base.gray" | "death.attack.dragon_breath_pool.item" | "config.jade.plugin_jade.distance" | "item.minecraft.experience_bottle" | "subtitles.entity.bat.death" | "death.attack.irons_spellbooks.wisp" | "instrument.minecraft.sing_goat_horn" | "subtitles.block.generic.break" | "gui.banned.description.unknownreason" | "commands.whitelist.add.success" | "commands.clone.success" | "enchantment.dungeonsenchantments.illagers_bane.desc" | "death.attack.explosion" | "entity.minecraft.glow_squid" | "block.minecraft.crimson_hyphae" | "pack.dropInfo" | "modernfix.option.mixin.perf.use_integrated_resources.jeresources" | "block.minecraft.black_wool" | "config.jei.default" | "selectWorld.warning.experimental.question" | "advancements.irons_spellbooks.spell_book_iron.description" | "block.minecraft.magenta_bed" | "advancements.irons_spellbooks.spell_book_equip.description" | "subtitles.entity.snow_golem.death" | "enchantment.create_sa.hellfire.desc" | "commands.spectate.self" | "item.minecraft.lingering_potion.effect.regeneration" | "telemetry.property.load_time_loading_overlay_ms.title" | "ui.irons_spellbooks.max_hp_on_kill" | "block.minecraft.banner.cross.red" | "block.minecraft.red_mushroom_block" | "entity.minecraft.fireball" | "enchantment.minecraft.infinity.desc" | "instrument.minecraft.ponder_goat_horn" | "mirror.none" | "fml.menu.multiplayer.clientoutdated" | "subtitles.entity.zombie.converted_to_drowned" | "subtitles.entity.wandering_trader.no" | "stat.minecraft.leave_game" | "death.attack.irons_spellbooks.blood_slash" | "block.minecraft.banner.gradient_up.blue" | "config.jei.mode.editEnabled" | "advancements.nether.ride_strider_in_overworld_lava.title" | "item.minecraft.mooshroom_spawn_egg" | "spell.irons_spellbooks.divine_smite" | "commands.attribute.modifier.value.get.success" | "stat.minecraft.damage_blocked_by_shield" | "item.minecraft.smithing_template.armor_trim.ingredients" | "argument.long.big" | "death.attack.irons_spellbooks.lightning_bolt.item" | "subtitles.entity.goat.death" | "forge.configgui.alwaysSetupTerrainOffThread" | "death.attack.irons_spellbooks.poison_arrow" | "fml.menu.multiplayer.serveroutdated" | "item.minecraft.netherite_helmet" | "telemetry.property.user_id.title" | "key.swapOffhand" | "subtitles.item.armor.equip_chain" | "key.jump" | "modernfix.option.mixin.perf.dynamic_dfu" | "modernfix.option.mod_override" | "jade.down" | "item.irons_spellbooks.apothecarist_spawn_egg" | "jei.key.mouse.left" | "selectWorld.delete_failure" | "block.minecraft.banner.bricks.orange" | "selectWorld.futureworld.error.title" | "block.minecraft.banner.triangle_top.yellow" | "ui.irons_spellbooks.blast_count" | "soundCategory.master" | "jigsaw_block.keep_jigsaws" | "config.jei.mode" | "subtitles.item.ink_sac.use" | "jade.east" | "subtitles.entity.villager.trade" | "block.minecraft.frogspawn" | "death.attack.irons_spellbooks.guiding_bolt" | "subtitles.entity.wolf.hurt" | "argument.entity.options.team.description" | "telemetry.property.advancement_game_time.title" | "item.minecraft.music_disc_5" | "item.irons_spellbooks.greater_oakskin_elixir" | "commands.forge.tags.error.unknown_element" | "commands.team.option.nametagVisibility.unchanged" | "Moonlight Mods Dynamic Assets" | "jei.key.category.dev.tools" | "block.minecraft.oak_pressure_plate" | "tooltip.irons_spellbooks.casting_implement_tooltip" | "mco.backup.button.download" | "advancements.adventure.spyglass_at_dragon.title" | "commands.title.show.actionbar.single" | "tooltip.irons_spellbooks.no_affinity" | "lectern.take_book" | "enchantment.minecraft.frost_walker.desc" | "subtitles.entity.painting.break" | "block.minecraft.birch_wood" | "patchouli.gui.lexicon.history.info" | "createWorld.customize.custom.randomize" | "block.minecraft.banner.gradient_up.lime" | "enchantment.minecraft.thorns" | "ui.irons_spellbooks.charge_ready" | "commands.bossbar.set.name.unchanged" | "argument.criteria.invalid" | "connect.authorizing" | "death.attack.flyIntoWall.player" | "commands.tag.list.multiple.empty" | "key.keyboard.space" | "key.socialInteractions" | "enchantment.improved_exp.lavawalker.desc" | "fml.menu.mods.search" | "item.apotheosis.gem.irons_spellbooks:ender" | "modernfix.option.mixin.feature.integrated_server_watchdog" | "commands.team.option.deathMessageVisibility.success" | "gui.chatReport.discard.return" | "spell.irons_spellbooks.frostwave" | "block.minecraft.amethyst_block" | "item.minecraft.red_dye" | "subtitles.entity.painting.place" | "spell.irons_spellbooks.fang_strike.guide" | "mco.minigame.world.noSelection" | "spell.irons_spellbooks.shield" | "block.minecraft.banner.small_stripes.orange" | "subtitles.entity.iron_golem.damage" | "item.irons_spellbooks.diamond_spell_book" | "pack.openFolder" | "addServer.resourcePack.enabled" | "block.minecraft.air" | "title.32bit.deprecation.realms.header" | "commands.place.jigsaw.failed" | "subtitles.entity.parrot.imitate.slime" | "death.attack.blood_cauldron.player" | "commands.debug.alreadyRunning" | "block.minecraft.banner.curly_border.orange" | "forge.configgui.fullBoundingBoxLadders" | "config.jade.reach_distance_desc" | "block.minecraft.poppy" | "block.minecraft.cherry_hanging_sign" | "item.minecraft.firework_rocket" | "jei.tooltip.bookmarks.usage.nokey" | "advancements.nether.create_full_beacon.title" | "block.minecraft.crimson_pressure_plate" | "jei.message.copy.recipe.id.failure" | "item.canPlace" | "subtitles.entity.illusioner.prepare_mirror" | "config.jade.display_item_hide" | "gamerule.doEntityDrops.description" | "item.minecraft.shield.brown" | "subtitles.entity.wither.shoot" | "spell.irons_spellbooks.planar_sight" | "mco.selectServer.configure" | "config.jade.plugin_minecraft.painting" | "commands.debug.function.traceFailed" | "forge.configgui.treatEmptyTagsAsAir.tooltip" | "key.irons_spellbooks.spell_quick_cast_15" | "options.sensitivity.max" | "key.irons_spellbooks.spell_quick_cast_14" | "key.irons_spellbooks.spell_quick_cast_13" | "gui.up" | "config.moonlight.general.merge_dynamic_packs.description" | "commands.fill.failed" | "modernfix.option.mixin.perf.kubejs" | "options.prioritizeChunkUpdates.byPlayer.tooltip" | "key.irons_spellbooks.spell_quick_cast_12" | "commands.scoreboard.objectives.modify.rendertype" | "key.irons_spellbooks.spell_quick_cast_11" | "enchantment.minecraft.depth_strider.desc" | "key.irons_spellbooks.spell_quick_cast_10" | "commands.advancement.revoke.criterion.to.many.success" | "block.minecraft.deepslate_brick_slab" | "createWorld.tab.more.title" | "commands.team.option.suffix.success" | "mco.selectServer.leave" | "death.attack.irons_spellbooks.eldritch_blast.item" | "block.minecraft.purpur_block" | "item.minecraft.cooked_chicken" | "item.patchouli:intro_book.name" | "options.accessibility.high_contrast" | "options.attackIndicator" | "structure_block.custom_data" | "gui.jei.category.brewing" | "block.minecraft.oak_sign" | "selectWorld.newWorld" | "jade.instrument.hat" | "enchantment.minecraft.blast_protection.desc" | "item.minecraft.nether_star" | "patchouli.gui.lexicon.button.editor.info" | "subtitles.entity.pillager.celebrate" | "block.minecraft.structure_block" | "item.minecraft.splash_potion.effect.harming" | "modernfix.option.mixin.bugfix.paper_chunk_patches" | "entity.minecraft.falling_block_type" | "chat.link.confirm" | "demo.help.title" | "subtitles.entity.parrot.imitate.spider" | "entity.tconstruct.flint_shuriken" | "mco.reset.world.seed" | "subtitles.item.nether_wart.plant" | "block.minecraft.bone_block" | "gui.jei.category.fuel.smeltCount" | "options.ao.min" | "fml.modmismatchscreen.homepage" | "block.minecraft.banner.half_vertical.magenta" | "jei.key.category.mouse.hover" | "chat.deleted_marker" | "subtitles.entity.camel.dash_ready" | "block.minecraft.suspicious_gravel" | "enchantment.improved_exp.suspicious_look.desc" | "subtitles.entity.phantom.hurt" | "block.minecraft.azalea" | "telemetry.property.client_id.title" | "school.irons_spellbooks.void" | "block.minecraft.banner.rhombus.orange" | "key.command" | "subtitles.entity.piglin_brute.ambient" | "commands.ride.mount.failure.generic" | "sign.edit" | "narration.checkbox.usage.focused" | "block.minecraft.spruce_pressure_plate" | "block.minecraft.set_spawn" | "gameMode.changed" | "subtitles.entity.parrot.imitate.zoglin" | "commands.data.entity.invalid" | "multiplayer.disconnect.invalid_packet" | "item.minecraft.sheaf_pottery_shard" | "jei.tooltip.item.search.aliases" | "biome.minecraft.windswept_forest" | "debug.reload_resourcepacks.message" | "argument.nbt.list.mixed" | "effect.irons_spellbooks.spider_aspect.description" | "advancements.sad_label" | "config.jade.tts_mode_extra_msg" | "item.minecraft.music_disc_strad" | "entity.minecraft.boat" | "entity.irons_spellbooks.stomp_aoe" | "advancements.adventure.summon_iron_golem.description" | "affix.irons_spellbooks:spellbook/attribute/lightning_spell_power.suffix" | "subtitles.entity.camel.death" | "config.jade.plugin_lootr.info" | "disconnect.ignoring_status_request" | "subtitles.entity.villager.hurt" | "block.minecraft.birch_fence" | "fml.modloading.brokenfile.optifine" | "spell.irons_spellbooks.blood_needles" | "forge.configgui.cachePackAccess" | "subtitles.item.brush.brushing.generic" | "embeddium.conflicting_mod" | "debug.crash.message" | "subtitles.entity.illusioner.death" | "gui.toWorld" | "modernfix.option.mixin.bugfix.recipe_book_type_desync" | "commands.datapack.list.enabled.success" | "block.minecraft.banner.half_vertical.green" | "gamerule.spawnRadius" | "advancements.irons_spellbooks.root.title" | "painting.minecraft.earth.author" | "gui.jade.configuration" | "death.attack.heartstop.player" | "block.minecraft.banner.triangles_top.light_gray" | "createWorld.customize.custom.coordinateScale" | "config.jade.overlay_square" | "block.minecraft.banner.square_top_left.black" | "effect.minecraft.conduit_power" | "commands.forge.tracking.timing_entry" | "spell.irons_spellbooks.black_hole" | "advancements.end.elytra.description" | "subtitles.entity.blaze.burn" | "advancements.end.dragon_breath.description" | "multiplayer.disconnect.name_taken" | "effect.irons_spellbooks.gluttony.description" | "disconnect.loginFailedInfo.insufficientPrivileges" | "block.minecraft.dead_horn_coral_block" | "gamerule.doVinesSpread" | "jei.tooltip.item.colors" | "jei.tooltip.ingredient.list.disabled" | "entity.minecraft.firework_rocket" | "block.minecraft.banner.rhombus.black" | "effect.irons_spellbooks.evasion.description" | "spell.irons_spellbooks.blood_slash.guide" | "tooltip.titanium.facing_handler.action" | "commands.forge.setdim.invalid.entity" | "subtitles.entity.elder_guardian.ambient_land" | "curios.modifiers.ring" | "death.attack.irons_spellbooks.shockwave.item" | "block.minecraft.waxed_exposed_cut_copper_stairs" | "modernfix.option.mixin.bugfix.ctm_resourceutil_cme" | "tetra.material.irons_spellbooks_hogskin.prefix" | "death.attack.outOfWorld" | "options.sensitivity.min" | "enchantment.improved_exp.werewolf.desc" | "mco.connect.authorizing" | "menu.quit" | "stat.minecraft.interact_with_cartography_table" | "forge.configgui.zombieBabyChance" | "block.minecraft.banner.stripe_left.white" | "item.geckolib.gecko_armor_chestplate" | "modernfix.option.mixin.perf.compress_biome_container" | "chat.queue" | "tooltip.irons_spellbooks.shift_tooltip" | "irons_spellbooks.tetra_bar.lightning_spell_power.tooltip" | "commands.scoreboard.players.operation.success.single" | "selectWorld.experimental" | "item.minecraft.angler_pottery_sherd" | "block.minecraft.deepslate_gold_ore" | "block.minecraft.end_stone_brick_wall" | "gui.banned.description.permanent" | "subtitles.entity.puffer_fish.blow_up" | "enchantment.dungeonsenchantments.radiance.desc" | "jade.mobgrowth.time" | "enchantment.minecraft.aqua_affinity" | "commands.scoreboard.players.reset.specific.multiple" | "entity.minecraft.ender_pearl" | "narration.jade.armor" | "block.minecraft.blue_stained_glass_pane" | "block.minecraft.smoker" | "spell.irons_spellbooks.thunderstorm" | "gui.socialInteractions.hidden_in_chat" | "commands.bossbar.list.bars.some" | "effect.minecraft.instant_damage" | "forge.configgui.stabilizeDirectionGetNearest" | "item.canBreak" | "death.attack.trident" | "sodium.options.brightness.tooltip" | "block.minecraft.blue_stained_glass" | "enchantment.minecraft.protection" | "options.guiScale.auto" | "block.minecraft.spruce_hanging_sign" | "subtitles.entity.sheep.ambient" | "block.minecraft.blue_candle" | "item.irons_spellbooks.arcane_ingot" | "spell.irons_spellbooks.heat_surge.guide" | "block.minecraft.weeping_vines" | "gui.banned.reason.defamation_impersonation_false_information" | "subtitles.entity.fox.teleport" | "key.modernfix.config" | "subtitles.entity.snowball.throw" | "subtitles.block.note_block.note" | "block.minecraft.banner.triangles_top.white" | "modernfix.option.mixin.safety" | "item.irons_spellbooks.affinity_ring" | "enchantment.level.10" | "subtitles.entity.vex.charge" | "spell.irons_spellbooks.cone_of_cold" | "item.minecraft.black_dye" | "menu.playerReporting" | "block.minecraft.polished_blackstone_brick_wall" | "commands.time.query" | "advancements.end.enter_end_gateway.title" | "advancements.husbandry.make_a_sign_glow.title" | "structure_block.button.detect_size" | "forge.configgui.treatEmptyTagsAsAir" | "container.loom" | "entity.minecraft.ender_dragon" | "block.minecraft.banner.half_horizontal_bottom.white" | "block.minecraft.anvil" | "selectServer.edit" | "mco.backup.entry.templateName" | "spell.irons_spellbooks.frost_step.guide" | "entity.irons_spellbooks.lightning_lance_projectile" | "config.jade.plugin_minecraft.fluid_storage.detailed_desc" | "subtitles.enchant.thorns.hit" | "options.ao.max" | "block.minecraft.cyan_candle_cake" | "block.minecraft.oak_wall_sign" | "item.irons_spellbooks.improved_blood_staff" | "tooltip.jade.power" | "block.minecraft.brewing_stand" | "telemetry.property.number_of_samples.title" | "block.minecraft.pink_candle" | "entity.irons_spellbooks.lightning_strike" | "block.minecraft.banner.square_top_left.green" | "death.attack.lightningBolt.player" | "options.key.toggle" | "jei.message.copy.recipe.id.success" | "block.minecraft.deepslate_bricks" | "itemGroup.ingredients" | "sodium.options.use_fog_occlusion.tooltip" | "moon.phase.last.quarter" | "item.minecraft.villager_spawn_egg" | "effect.minecraft.absorption" | "block.minecraft.light_gray_concrete" | "ui.irons_spellbooks.research_already_learned" | "commands.datapack.enable.failed.no_flags" | "block.minecraft.dead_brain_coral" | "compliance.playtime.hours" | "block.minecraft.banner.rhombus.green" | "item.minecraft.saddle" | "menu.loadingLevel" | "structure_block.size" | "tetra.material.irons_spellbooks_lightning_rune_socket" | "config.jei.advanced.maxRecipeGuiHeight" | "lanServer.otherPlayers" | "block.minecraft.green_concrete_powder" | "subtitles.entity.goat.long_jump" | "block.minecraft.red_mushroom" | "structure_block.integrity.integrity" | "subtitles.item.crossbow.load" | "advancements.story.shiny_gear.description" | "subtitles.entity.phantom.swoop" | "block.minecraft.banner.cross.lime" | "block.minecraft.banner.stripe_downleft.light_blue" | "book.finalizeWarning" | "demo.day.2" | "demo.day.1" | "spell.irons_spellbooks.dragon_breath.guide" | "demo.day.4" | "commands.data.block.get" | "demo.day.3" | "enchantment.minecraft.sharpness" | "item.minecraft.slime_ball" | "demo.day.6" | "demo.day.5" | "item.minecraft.magenta_dye" | "item.minecraft.glistering_melon_slice" | "subtitles.entity.slime.attack" | "effect.irons_spellbooks.vigor.description" | "subtitles.entity.enderman.ambient" | "block.minecraft.potted_red_tulip" | "commands.forge.tps.summary.all" | "gamerule.playersSleepingPercentage.description" | "subtitles.entity.turtle.egg_crack" | "chat.tag.modified" | "spell.irons_spellbooks.ray_of_siphoning.guide" | "gamerule.doLimitedCrafting.description" | "advancements.husbandry.tadpole_in_a_bucket.title" | "block.minecraft.banner.stripe_downright.cyan" | "item.minecraft.skull_banner_pattern.desc" | "block.minecraft.banner.cross.orange" | "disconnect.closed" | "commands.experience.set.levels.success.single" | "__support_betterarcheology" | "container.spectatorCantOpen" | "item.irons_spellbooks.antiquated_compass" | "block.minecraft.banner.diagonal_left.lime" | "death.attack.irons_spellbooks.chain_lightning.item" | "item.irons_spellbooks.rare_ink" | "block.minecraft.infested_mossy_stone_bricks" | "resourcePack.vanilla.description" | "multiplayer.disconnect.invalid_public_key_signature" | "death.attack.anvil" | "subtitles.entity.wandering_trader.drink_milk" | "gui.toTitle" | "selectServer.refresh" | "enchantment.minecraft.swift_sneak" | "block.minecraft.banner.bricks.gray" | "block.minecraft.packed_ice" | "gui.chatReport.observed_what" | "narrator.controls.unbound" | "commands.effect.give.success.single" | "advMode.mode.unconditional" | "spectatorMenu.close" | "spell.irons_spellbooks.abyssal_shroud" | "block.minecraft.banner.gradient.purple" | "item.minecraft.brick" | "block.minecraft.mossy_cobblestone_slab" | "subtitles.ambient.cave" | "death.attack.irons_spellbooks.echoing_strikes" | "subtitles.block.pointed_dripstone.drip_lava" | "sodium.options.cpu_render_ahead_limit.tooltip" | "entity.minecraft.shulker" | "pack.available.title" | "block.minecraft.banner.square_top_right.orange" | "commands.save.success" | "subtitles.item.armor.equip_diamond" | "subtitles.item.armor.equip_netherite" | "config.jade.display_tooltip" | "createWorld.customize.custom.useTemples" | "block.minecraft.dark_oak_stairs" | "advancements.nether.uneasy_alliance.title" | "jadeaddons.mcjtylib.ownedBy.withChannel" | "block.minecraft.andesite" | "subtitles.entity.skeleton.death" | "config.jei.advanced.colorSearchEnabled.comment" | "block.minecraft.banner.stripe_middle.brown" | "block.minecraft.banner.diagonal_left.green" | "config.jade.plugin_minecraft.mob_breeding_extra_msg" | "block.minecraft.pink_petals" | "stat.minecraft.pig_one_cm" | "subtitles.entity.zoglin.angry" | "argument.entity.selector.not_allowed" | "block.minecraft.gray_carpet" | "item.nbt_tags" | "subtitles.item.armor.equip_gold" | "potion.withAmplifier" | "item.minecraft.diamond_leggings" | "argument.player.entities" | "subtitles.entity.ravager.attack" | "effect.irons_spellbooks.chilled.description" | "item.minecraft.arms_up_pottery_shard" | "block.minecraft.cobbled_deepslate_slab" | "block.minecraft.banner.base.light_gray" | "advancements.irons_spellbooks.spell_book_evoker.description" | "block.minecraft.chain_command_block" | "block.minecraft.iron_ore" | "forge.configgui.forgeCloudsEnabled.tooltip" | "block.minecraft.banner.square_top_left.orange" | "multiplayer.disconnect.chat_validation_failed" | "options.narrator.off" | "block.minecraft.purpur_pillar" | "multiplayer.disconnect.banned.reason" | "block.minecraft.banner.triangle_top.brown" | "item.minecraft.smithing_template.netherite_upgrade.applies_to" | "entity.minecraft.iron_golem" | "subtitles.block.pointed_dripstone.drip_water_into_cauldron" | "death.attack.irons_spellbooks.summon_polar_bear.item" | "subtitles.entity.goat.prepare_ram" | "advancements.adventure.walk_on_powder_snow_with_leather_boots.title" | "commands.save.failed" | "translation.test.escape" | "item.minecraft.stick" | "itemGroup.buildingBlocks" | "affix.irons_spellbooks:armor/attribute/cooldown" | "mco.brokenworld.title" | "createWorld.customize.flat.height" | "death.attack.irons_spellbooks.chain_creeper.item" | "command.unknown.argument" | "ui.irons_spellbooks.absorption" | "lanServer.port.unavailable.new" | "block.minecraft.deepslate_tile_stairs" | "time.bookshelf.month.september" | "advancements.husbandry.allay_deliver_cake_to_note_block.title" | "fml.modloading.uncaughterror" | "block.minecraft.polished_blackstone_slab" | "biome.minecraft.the_void" | "advancements.adventure.ol_betsy.title" | "lanserverproperties.gui.port_listening" | "death.attack.sting.item" | "advancements.irons_spellbooks.staff_blood_staff.title" | "narration.jade.category" | "block.minecraft.light" | "item.minecraft.tadpole_bucket" | "advancements.adventure.throw_trident.description" | "commands.scoreboard.players.get.success" | "entity.minecraft.text_display" | "options.chat.visibility.system" | "gamerule.doVinesSpread.description" | "subtitles.entity.shulker.ambient" | "item.apotheosis.gem.irons_spellbooks:blood" | "block.minecraft.redstone_torch" | "item.geckolib.cool_kid_spawn_egg" | "block.minecraft.banner.triangles_bottom.magenta" | "config.jei.advanced.addBookmarksToFront.comment" | "advancements.adventure.play_jukebox_in_meadows.title" | "entity.minecraft.ghast" | "team.collision.never" | "block.minecraft.banner.cross.white" | "block.minecraft.light_gray_candle_cake" | "__support_shield+" | "fluid_type.minecraft.milk" | "irons_spellbooks.tetra_bar.ender_spell_power.tooltip" | "affix.irons_spellbooks:spellbook/attribute/blood_spell_power" | "moon.phase.waxing.crescent" | "block.minecraft.waxed_oxidized_copper" | "multiplayer.status.cancelled" | "createWorld.customize.custom.useWaterLakes" | "wood_type.minecraft.acacia" | "block.minecraft.mangrove_propagule" | "subtitles.entity.player.burp" | "gui.ok" | "gui.abuseReport.reason.child_sexual_exploitation_or_abuse.description" | "block.minecraft.stripped_spruce_wood" | "modernfix.option.mixin.perf.fix_loop_spin_waiting" | "school.irons_spellbooks.evocation" | "block.minecraft.banner.half_horizontal.white" | "subtitles.entity.bee.ambient" | "debug.dump_dynamic_textures.help" | "subtitles.entity.pillager.death" | "item.irons_spellbooks.shriving_stone" | "chat.tag.system" | "effect.minecraft.health_boost" | "block.minecraft.stripped_dark_oak_log" | "commands.give.success.multiple" | "block.minecraft.red_banner" | "death.attack.generic.player" | "block.minecraft.banner.flower.orange" | "selectWorld.dataPacks" | "item.minecraft.cod_bucket" | "block.minecraft.banner.diagonal_left.black" | "enchantment.betterarcheology.seas_bounty.desc" | "block.minecraft.banner.diagonal_up_left.brown" | "ui.irons_spellbooks.distance" | "biome.minecraft.savanna_plateau" | "gui.no" | "commands.bossbar.get.max" | "text.cloth-config.error.color.no_alpha_allowed" | "block.minecraft.banner.stripe_middle.blue" | "subtitles.entity.warden.tendril_clicks" | "block.minecraft.warped_fence" | "mco.invites.button.reject" | "config.jade.plugin_create.filter" | "item.minecraft.water_bucket" | "advancements.husbandry.allay_deliver_cake_to_note_block.description" | "block.minecraft.banner.cross.light_gray" | "subtitles.block.conduit.activate" | "death.attack.drown" | "jigsaw_block.name" | "spell.irons_spellbooks.planar_sight.guide" | "entity.irons_spellbooks.earthquake_aoe" | "item.minecraft.ender_dragon_spawn_egg" | "modifier.cloth-config.shift" | "block.minecraft.bell" | "item.minecraft.shield.cyan" | "subtitles.block.composter.fill" | "enchantment.minecraft.respiration.desc" | "item.geckolib.gremlin_spawn_egg" | "block.minecraft.banner.gradient_up.purple" | "createWorld.customize.buffet.title" | "block.minecraft.exposed_cut_copper" | "item.irons_spellbooks.failed_arctic_voyage_map" | "block.minecraft.sniffer_egg" | "item.minecraft.allay_spawn_egg" | "subtitles.block.beehive.shear" | "telemetry.property.load_time_total_time_ms.title" | "selectServer.direct" | "commands.advancement.revoke.criterion.to.many.failure" | "spell.irons_spellbooks.invisibility" | "death.attack.irons_spellbooks.sunbeam.item" | "spell.irons_spellbooks.lob_creeper.guide" | "structure_block.position.z" | "structure_block.position.y" | "forge.froge.warningScreen.title" | "structure_block.position.x" | "item.irons_spellbooks.wandering_magician_leggings" | "forge.configgui.fixVanillaCascading.tooltip" | "block.minecraft.banner.mojang.brown" | "block.minecraft.dandelion" | "item.irons_spellbooks.electromancer_leggings" | "item.minecraft.tropical_fish_spawn_egg" | "config.jade.overlay_scale" | "biome.minecraft.beach" | "patchouli.gui.lexicon.button.mark_all_read" | "item.irons_spellbooks.claymore" | "commands.team.join.success.single" | "item.irons_spellbooks.permafrost_shard" | "subtitles.entity.bee.death" | "subtitles.entity.evoker.celebrate" | "advancements.story.mine_diamond.title" | "affix.irons_spellbooks:spellbook/attribute/nature_spell_power" | "item.minecraft.cod_spawn_egg" | "item.minecraft.music_disc_relic" | "entity.minecraft.villager.leatherworker" | "item.minecraft.writable_book" | "block.minecraft.rooted_dirt" | "config.jade.plugin_jade.distance_desc" | "subtitles.entity.parrot.imitate.vex" | "subtitles.entity.dolphin.eat" | "config.jade.tts_mode_press" | "subtitles.block.fire.ambient" | "subtitles.entity.panda.eat" | "block.minecraft.banner.cross.blue" | "block.minecraft.banner.half_horizontal_bottom.green" | "narration.recipe.usage" | "jei.alias.villager.spawn.egg" | "block.minecraft.banner.square_top_right.black" | "block.minecraft.raw_gold_block" | "block.minecraft.banner.triangles_top.green" | "mco.selectServer.configureRealm" | "item.minecraft.potion.effect.turtle_master" | "block.minecraft.gray_stained_glass_pane" | "advancements.irons_spellbooks.staff_lightning_rod.description" | "enchantment.minecraft.quick_charge" | "block.minecraft.grindstone" | "subtitles.block.smoker.smoke" | "subtitles.entity.allay.item_taken" | "enchantment.minecraft.knockback.desc" | "advancements.nether.obtain_ancient_debris.title" | "jade.modName.cpp" | "subtitles.entity.zombified_piglin.death" | "sodium.option_impact.varies" | "enchantment.improved_exp.boer_1.desc" | "enchantment.minecraft.sharpness.desc" | "advancements.nether.create_beacon.title" | "block.minecraft.banner.rhombus.white" | "block.minecraft.banner.bricks.light_gray" | "commands.item.block.set.success" | "modernfix.option.mixin.bugfix.ender_dragon_leak" | "team.collision.pushOtherTeams" | "deathScreen.title.hardcore" | "item.minecraft.spider_spawn_egg" | "sodium.options.attack_indicator.tooltip" | "debug.pause_focus.off" | "spell.irons_spellbooks.thunder_step" | "mco.configure.world.subscription.less_than_a_day" | "modernfix.no_lazydfu" | "gui.chatReport.send.no_reported_messages" | "commands.tag.remove.success.single" | "block.minecraft.green_bed" | "advancements.story.follow_ender_eye.title" | "biome.minecraft.swamp" | "mco.selectServer.open" | "jadeaddons.lootr.decay" | "death.attack.cactus" | "mco.reset.world.inspiration" | "block.minecraft.crimson_trapdoor" | "subtitles.entity.dolphin.hurt" | "item.patchouli:test_completion.name" | "commands.enchant.failed.incompatible" | "block.minecraft.red_bed" | "merchant.current_level" | "spell.irons_spellbooks.charge.guide" | "block.minecraft.dead_horn_coral_wall_fan" | "commands.bookshelf.loot_tables" | "advMode.mode" | "item.minecraft.firework_star.orange" | "block.minecraft.banner.square_top_right.gray" | "death.fell.assist" | "gamerule.globalSoundEvents.description" | "spell.irons_spellbooks.summon_vex.guide" | "entity.minecraft.player" | "block.minecraft.smooth_basalt" | "multiplayer.disconnect.server_full" | "entity.minecraft.donkey" | "subtitles.item.bucket.empty" | "item.minecraft.turtle_helmet" | "block.minecraft.stripped_acacia_log" | "modernfix.option.mixin.perf.tag_id_caching" | "subtitles.entity.panda.hurt" | "subtitles.entity.panda.pre_sneeze" | "mco.time.daysAgo" | "subtitles.entity.allay.item_thrown" | "block.minecraft.magenta_concrete" | "entity.minecraft.arrow" | "item.minecraft.netherite_axe" | "death.attack.irons_spellbooks.cone_of_cold.item" | "block.minecraft.birch_stairs" | "mco.selectServer.expires.days" | "advancements.adventure.salvage_sherd.description" | "death.attack.irons_spellbooks.scorch.item" | "ui.irons_spellbooks.cast_ready" | "lanServer.title" | "tetra.variant.single_socket/permafrost_shard" | "subtitles.entity.polar_bear.ambient" | "commands.title.reset.single" | "effect.irons_spellbooks.vex_timer" | "block.minecraft.banner.half_vertical_right.light_blue" | "key.curios.category" | "item.minecraft.lingering_potion.effect.slow_falling" | "entity.minecraft.lightning_bolt" | "ui.irons_spellbooks.spell_target_success_self" | "item.minecraft.firework_star.black" | "commands.banip.info" | "commands.scoreboard.objectives.add.duplicate" | "category.cloth-config.scrolling" | "tooltip.titanium.redstone.no_redstone" | "block.minecraft.cherry_log" | "stat.minecraft.raid_trigger" | "spell.irons_spellbooks.root.guide" | "options.video" | "block.minecraft.bamboo_hanging_sign" | "item.patchouli:pamphlet.name" | "block.minecraft.banner.half_horizontal_bottom.magenta" | "mco.configure.world.buttons.open" | "jadeaddons.deepresonance.sep" | "block.minecraft.banner.square_top_right.green" | "block.minecraft.banner.stripe_center.pink" | "spell.irons_spellbooks.lob_creeper" | "itemGroup.inventory" | "item.irons_spellbooks.furled_map_descriptor_framing" | "fml.modloading.missingdependency" | "block.minecraft.banner.triangles_top.black" | "options.chunks" | "item.minecraft.salmon" | "death.attack.irons_spellbooks.wall_of_fire" | "block.minecraft.comparator" | "item.minecraft.tipped_arrow.effect.healing" | "item.minecraft.beetroot_seeds" | "item.minecraft.totem_of_undying" | "subtitles.entity.tropical_fish.flop" | "death.attack.irons_spellbooks.chain_creeper" | "block.minecraft.banner.curly_border.magenta" | "item.minecraft.cauldron" | "advancements.nether.obtain_crying_obsidian.description" | "block.minecraft.banner.flower.cyan" | "commands.team.option.seeFriendlyInvisibles.enabled" | "item.irons_spellbooks.handwritten_invoice.desc" | "commands.effect.clear.everything.success.multiple" | "entity.irons_spellbooks.firefly_swarm" | "block.minecraft.banner.square_top_right.white" | "demo.reminder" | "config.jade.plugin_minecraft.entity_health.icons_per_line" | "block.minecraft.dead_fire_coral_wall_fan" | "block.minecraft.magenta_banner" | "selectWorld.select" | "block.minecraft.wither_rose" | "stat.minecraft.strider_one_cm" | "debug.gamemodes.help" | "advancements.nether.get_wither_skull.description" | "structure_block.mode.load" | "debug.advanced_tooltips.off" | "item.minecraft.firework_star.green" | "chat.tag.not_secure" | "curios.cosmetic" | "block.minecraft.banner.half_horizontal_bottom.black" | "block.minecraft.brick_wall" | "tetra.material.irons_spellbooks_mana_rune_socket.prefix" | "modernfix.option.mixin.bugfix.tf_cme_on_load" | "item.minecraft.howl_pottery_shard" | "subtitles.entity.skeleton_horse.hurt" | "item.minecraft.lingering_potion.effect.thick" | "block.minecraft.bee_nest" | "text.cloth-config.quit_discard" | "mco.activity.title" | "tooltip.jade.crop_growth" | "block.minecraft.cut_copper" | "item.patchouli:test_book_2.name" | "item.minecraft.firework_star.pink" | "block.minecraft.spruce_planks" | "text.cloth-config.error.color.invalid_red" | "patchouli.gui.lexicon.visualize_letter" | "item.minecraft.map" | "block.minecraft.lapis_block" | "tetra.material.irons_spellbooks_mana_rune_socket" | "item.minecraft.honeycomb" | "debug.show_hitboxes.help" | "item.minecraft.magma_cream" | "commands.team.option.name.unchanged" | "item.minecraft.lingering_potion.effect.empty" | "asynclocator.map.none" | "config.jade.plugin_minecraft.entity_health.max_for_render" | "jei.tooltip.error.recipe.transfer.no.server" | "options.accessibility.title" | "subtitles.entity.dolphin.play" | "item.minecraft.music_disc_11" | "jade.fluid" | "death.attack.irons_spellbooks.burning_dash" | "item.minecraft.music_disc_13" | "block.minecraft.green_banner" | "item.minecraft.firework_star.shape" | "entity.minecraft.killer_bunny" | "commands.data.entity.modified" | "spell.irons_spellbooks.flaming_barrage.guide" | "block.minecraft.red_sandstone_slab" | "affix.irons_spellbooks:armor/attribute/spell_resist.suffix" | "argument.pos.mixed" | "gui.banned.description.reason_id" | "item.minecraft.golden_horse_armor" | "enchantment.dungeonsenchantments.weakening.desc" | "biome.minecraft.nether_wastes" | "stat.minecraft.crouch_one_cm" | "tooltip.titanium.tank.fluid" | "painting.minecraft.kebab.author" | "subtitles.entity.chicken.hurt" | "config.jade.danger_zone" | "jade.seconds" | "subtitles.block.dispenser.fail" | "forge.configgui.logCascadingWorldGeneration.tooltip" | "commands.bossbar.set.value.success" | "death.attack.mob.item" | "argument.time.invalid_unit" | "spell.irons_spellbooks.blight.guide" | "enchantment.shieldsplus.fast_recovery.desc" | "subtitles.entity.horse.angry" | "tetra.material.frosted_helve" | "block.minecraft.end_portal_frame" | "item.minecraft.tipped_arrow.effect.poison" | "item.irons_spellbooks.archevoker_log.page_4" | "subtitles.entity.wolf.growl" | "enchantment.improved_exp.fear_of_depth.desc" | "gui.jei.category.stoneCutter" | "advancements.end.kill_dragon.title" | "block.minecraft.waxed_exposed_copper" | "item.minecraft.potion.effect.mundane" | "stat.minecraft.eat_cake_slice" | "wood_type.minecraft.warped" | "block.minecraft.calibrated_sculk_sensor" | "block.minecraft.shroomlight" | "block.minecraft.banner.skull.magenta" | "item.minecraft.skull_banner_pattern" | "selectWorld.edit.optimize" | "item.irons_spellbooks.archevoker_log.page_2" | "item.irons_spellbooks.archevoker_log.page_3" | "commands.bossbar.get.players.none" | "entity.minecraft.strider" | "item.irons_spellbooks.archevoker_log.page_1" | "argument.block.property.duplicate" | "subtitles.entity.parrot.imitate.vindicator" | "jei.tooltip.liquid.amount" | "subtitles.entity.parrot.imitate.zombie_villager" | "entity.geckolib.gremlin" | "debug.reload_chunks.message" | "mco.selectServer.minigame" | "createWorld.customize.custom.next" | "item.irons_spellbooks.wayward_compass" | "stat.minecraft.open_enderchest" | "subtitles.entity.parrot.fly" | "mco.configure.world.invites.remove.tooltip" | "subtitles.entity.allay.ambient_without_item" | "optimizeWorld.confirm.description" | "block.minecraft.orange_wool" | "item.minecraft.diamond" | "chat.disabled.profile" | "painting.minecraft.wither.author" | "jei.chat.error.no.cheat.permission.disabled" | "item.minecraft.copper_ingot" | "key.keyboard.keypad.decimal" | "block.minecraft.orange_shulker_box" | "commands.teleport.invalidPosition" | "subtitles.entity.phantom.death" | "gamerule.lavaSourceConversion" | "item.minecraft.diamond_hoe" | "death.attack.irons_spellbooks.ray_of_siphoning" | "commands.tag.add.success.single" | "narrator.button.difficulty_lock.locked" | "curios.identifier.head" | "death.attack.message_too_long" | "block.minecraft.banner.globe.cyan" | "forge.menu.updatescreen.title" | "ui.irons_spellbooks.rend" | "block.minecraft.banner.diagonal_left.blue" | "enchantment.improved_exp.dolphins_grace.desc" | "block.minecraft.banner.half_horizontal.green" | "commands.scoreboard.players.enable.invalid" | "patchouli.gui.lexicon.button.resize.verybig.container" | "advancements.nether.netherite_armor.title" | "painting.minecraft.sunset.author" | "commands.clear.test.multiple" | "commands.summon.success" | "subtitles.entity.cat.ambient" | "block.minecraft.horn_coral" | "item.minecraft.raw_iron" | "subtitles.entity.enderman.hurt" | "subtitles.entity.husk.death" | "patchouli.gui.lexicon.complete" | "subtitles.entity.piglin.step" | "effect.minecraft.hunger" | "block.minecraft.gray_candle" | "mco.selectServer.closeserver" | "mco.time.now" | "item.minecraft.lingering_potion.effect.mundane" | "multiplayer.status.pinging" | "commands.forceload.removed.all" | "block.minecraft.dead_bubble_coral_block" | "spell.irons_spellbooks.creeper_revenge" | "death.attack.irons_spellbooks.fire_breath.item" | "item.minecraft.music_disc_pigstep" | "subtitles.entity.player.freeze_hurt" | "key.irons_spellbooks.spell_quick_cast_3" | "key.irons_spellbooks.spell_quick_cast_2" | "key.irons_spellbooks.spell_quick_cast_5" | "block.minecraft.banner.square_top_left.pink" | "key.irons_spellbooks.spell_quick_cast_4" | "key.irons_spellbooks.spell_quick_cast_1" | "enchantment.improved_exp.hungry.desc" | "block.minecraft.banner.half_vertical.purple" | "block.minecraft.dark_oak_pressure_plate" | "subtitles.entity.drowned.shoot" | "block.minecraft.crimson_roots" | "key.irons_spellbooks.spell_quick_cast_7" | "key.irons_spellbooks.spell_quick_cast_6" | "key.irons_spellbooks.spell_quick_cast_9" | "biome.minecraft.the_end" | "key.irons_spellbooks.spell_quick_cast_8" | "effect.minecraft.haste" | "block.minecraft.polished_blackstone_stairs" | "options.showSubtitles" | "tetra.material.irons_spellbooks_arcane_ingot" | "fml.menu.mods.info.displayurl" | "block.minecraft.banner.square_bottom_left.light_blue" | "tetra.material.irons_spellbooks_cooldown_rune_socket" | "advancements.adventure.craft_decorated_pot_using_only_sherds.title" | "advancements.husbandry.silk_touch_nest.description" | "gui.copy_link_to_clipboard" | "block.minecraft.nether_quartz_ore" | "color.minecraft.cyan" | "subtitles.entity.ravager.step" | "modernfix.option.mixin.feature.spark_profile_launch" | "commands.forge.tracking.be.enabled" | "item.patchouli.guide_book.invalid" | "advancements.irons_spellbooks.spell_book_diamond.description" | "debug.advanced_tooltips.on" | "commands.seed.success" | "argument.entity.options.predicate.description" | "rarity.irons_spellbooks.ancient" | "subtitles.entity.strider.retreat" | "enchantment.minecraft.impaling" | "block.minecraft.banner.stripe_left.cyan" | "attribute.irons_spellbooks.eldritch_magic_resist" | "block.minecraft.crimson_button" | "advancements.story.upgrade_tools.title" | "createWorld.customize.custom.useRavines" | "subtitles.entity.pig.ambient" | "entity.irons_spellbooks.poison_splash" | "block.minecraft.banner.half_horizontal.black" | "block.minecraft.banner.stripe_right.pink" | "trim_material.minecraft.copper" | "advancements.irons_spellbooks.spell_book_dragon.title" | "narrator.toast.disabled" | "config.jei.advanced.itemBlacklist.comment" | "block.minecraft.banner.gradient.black" | "block.minecraft.ochre_froglight" | "enchantment.level.8" | "enchantment.level.7" | "enchantment.level.6" | "enchantment.level.5" | "config.jade.plugin_minecraft.command_block" | "enchantment.level.4" | "enchantment.level.3" | "enchantment.level.2" | "narration.suggestion.tooltip" | "enchantment.level.1" | "entity.tconstruct.glow_ball" | "modernfix.option.mixin.feature.stalled_chunk_load_detection" | "tooltip.irons_spellbooks.spellbook_unique" | "advancements.adventure.spyglass_at_parrot.description" | "commands.forceload.added.single" | "enchantment.level.9" | "item.minecraft.stone_shovel" | "item.minecraft.arrow" | "subtitles.block.end_portal.spawn" | "block.minecraft.banner.base.magenta" | "advMode.mode.sequence" | "options.hideLightningFlashes.tooltip" | "block.minecraft.yellow_wool" | "advancements.husbandry.feed_snifflet.description" | "mco.terms.buttons.agree" | "block.minecraft.oak_wall_hanging_sign" | "block.minecraft.crimson_fence" | "advancements.adventure.avoid_vibration.title" | "attribute.name.generic.luck" | "attribute.name.generic.attack_speed" | "block.minecraft.banner.gradient.lime" | "block.minecraft.banner.stripe_downright.brown" | "commands.pardonip.invalid" | "selectWorld.load_folder_access" | "advancements.adventure.play_jukebox_in_meadows.description" | "key.keyboard.equal" | "mco.configure.world.subscription.day" | "entity.minecraft.polar_bear" | "subtitles.entity.warden.sniff" | "block.minecraft.green_candle_cake" | "narration.recipe.usage.more" | "painting.random" | "item.irons_spellbooks.priest_leggings" | "subtitles.entity.villager.work_farmer" | "modernfix.perf_mod_warning" | "block.minecraft.banner.mojang.orange" | "modernfix.option.mixin.perf.thread_priorities" | "key.advancements" | "subtitles.block.tripwire.detach" | "commands.forge.gen.start" | "patchouli.gui.lexicon.keybind" | "block.minecraft.cracked_deepslate_tiles" | "death.attack.starve.player" | "item.minecraft.elder_guardian_spawn_egg" | "block.minecraft.stripped_mangrove_wood" | "modernfix.option.off" | "enchantment.improved_exp.strength.desc" | "jade.fluid.empty" | "painting.minecraft.graham.author" | "death.attack.irons_spellbooks.thunder_step" | "painting.minecraft.wanderer.title" | "wood_type.minecraft.spruce" | "block.minecraft.chiseled_deepslate" | "item.minecraft.spectral_arrow" | "stat.minecraft.interact_with_loom" | "modernfix.option.mixin.bugfix.refinedstorage.te_bug" | "text.cloth-config.reset_value" | "subtitles.item.brush.brushing.sand.complete" | "block.minecraft.banner.piglin.lime" | "enchantment.improved_exp.weakness.desc" | "selectWorld.versionQuestion" | "item.minecraft.salmon_bucket" | "advancements.husbandry.root.description" | "outOfMemory.message" | "spell.irons_spellbooks.earthquake.guide" | "biome.minecraft.crimson_forest" | "block.minecraft.banner.gradient_up.light_gray" | "subtitles.entity.enderman.stare" | "block.minecraft.cyan_banner" | "block.minecraft.andesite_slab" | "mco.backup.entry.worldType" | "entity.minecraft.goat" | "commands.item.entity.set.success.multiple" | "block.minecraft.banner.diagonal_right.white" | "subtitles.entity.goat.step" | "commands.save.enabled" | "modernfix.option.mixin.perf.model_optimizations" | "fml.modloading.errorduringevent" | "item.minecraft.golden_carrot" | "entity.irons_spellbooks.wall_of_fire" | "mco.upload.button.name" | "commands.place.structure.failed" | "block.minecraft.pitcher_plant" | "commands.spreadplayers.failed.entities" | "item.disabled" | "block.minecraft.banner.stripe_downleft.black" | "config.jade.plugin_minecraft.mob_growth" | "generator.custom" | "argument.entity.selector.missing" | "narration.slider.usage.hovered" | "item.minecraft.baked_potato" | "config.jade.plugin_minecraft.item_storage.show_name_amount_desc" | "block.minecraft.smooth_red_sandstone_slab" | "death.attack.badRespawnPoint.link" | "gamerule.fallDamage" | "enchantment.improved_exp.toxic_1.desc" | "block.minecraft.banner.diagonal_up_right.yellow" | "block.minecraft.warped_planks" | "entity.irons_spellbooks.debug_wizard" | "dataPack.bundle.name" | "item.minecraft.mangrove_boat" | "narrator.position.screen" | "block.minecraft.banner.half_vertical_right.purple" | "enchantment.improved_exp.return_from_void.desc" | "block.minecraft.banner.diagonal_right.light_gray" | "entity.irons_spellbooks.firebolt_projectile" | "block.minecraft.banner.cross.green" | "death.attack.fire_field.item" | "block.minecraft.cracked_nether_bricks" | "key.keyboard.up" | "attribute.irons_spellbooks.blood_magic_resist" | "config.jei.search.creativeTabSearchMode.comment" | "leaves_type.minecraft.acacia" | "block.minecraft.banner.stripe_downleft.green" | "block.minecraft.banner.diagonal_right.pink" | "mco.configure.current.minigame" | "modernfix.option.mixin.perf.cache_upgraded_structures" | "block.minecraft.banner.piglin.blue" | "item.irons_spellbooks.misery" | "irons_spellbooks.tetra_effect.freeze.tooltip" | "item.minecraft.zombie_villager_spawn_egg" | "subtitles.entity.parrot.imitate.blaze" | "block.minecraft.stone_bricks" | "block.minecraft.blackstone_slab" | "block.minecraft.snow" | "options.difficulty.peaceful.info" | "item.minecraft.shulker_spawn_egg" | "commands.publish.alreadyPublished" | "config.jade.plugin_minecraft.item_storage.detailed_amount_desc" | "subtitles.entity.goat.eat" | "ui.irons_spellbooks.effect_length" | "item.minecraft.heart_pottery_shard" | "block.minecraft.purple_stained_glass_pane" | "inventory.hotbarSaved" | "structure_block.load_prepare" | "spell.irons_spellbooks.blood_step" | "subtitles.entity.warden.emerge" | "subtitles.item.axe.scrape" | "gamerule.announceAdvancements" | "forge.configgui.calculateAllNormals" | "subtitles.entity.stray.death" | "key.jei.cheatOneItem2" | "item.modifiers.chest" | "advancements.irons_spellbooks.spell_book_rotten.description" | "forge.configgui.removeErroringEntities.tooltip" | "irons_spellbooks.tetra_bar.blood_spell_power.tooltip" | "block.minecraft.banner.square_top_right.cyan" | "block.minecraft.cobweb" | "color.minecraft.brown" | "options.entityShadows" | "entity.minecraft.item_display" | "filled_map.buried_treasure" | "subtitles.entity.guardian.flop" | "subtitles.entity.bat.takeoff" | "entity.minecraft.tropical_fish.type.sunstreak" | "block.minecraft.mycelium" | "multiplayer.applyingPack" | "item.irons_spellbooks.netherite_mage_leggings" | "item.minecraft.milk_bucket" | "painting.minecraft.pigscene.title" | "modernfix.option.mixin.bugfix.chunk_deadlock.valhesia" | "commands.debug.stopped" | "entity.minecraft.blaze" | "selectWorld.backupQuestion.experimental" | "gui.narrate.editBox" | "fml.menu.multiplayer.unknown" | "block.minecraft.bamboo_trapdoor" | "argument.entity.options.inapplicable" | "block.minecraft.beacon" | "telemetry_info.screen.description" | "stat.minecraft.aviate_one_cm" | "book.finalizeButton" | "subtitles.entity.strider.hurt" | "text.cloth-config.error_cannot_save" | "block.minecraft.smooth_stone_slab" | "death.attack.irons_spellbooks.fang_ward" | "biome.minecraft.snowy_beach" | "enchantment.improved_exp.spurt.desc" | "spell.irons_spellbooks.teleport.guide" | "death.fell.accident.other_climbable" | "item.minecraft.iron_horse_armor" | "sodium.options.cpu_render_ahead_limit.value" | "chat.copy" | "death.attack.irons_spellbooks.sculk_tentacles" | "entity.minecraft.fox" | "mco.selectServer.uninitialized" | "fml.modmismatchscreen.table.youhave" | "selectWorld.backupWarning.snapshot" | "subtitles.entity.rabbit.ambient" | "spell.irons_spellbooks.fortify" | "subtitles.entity.sniffer.digging" | "spectatorMenu.previous_page" | "sodium.options.use_persistent_mapping.name" | "item.minecraft.filled_map" | "options.sortAZ" | "stat.minecraft.interact_with_beacon" | "key.jei.previousCategory" | "block.minecraft.banner.piglin.red" | "item.minecraft.cherry_boat" | "spell.irons_spellbooks.chain_creeper.guide" | "block.geckolib.fertilizer.tooltip" | "forge.configgui.selectiveResourceReloadEnabled" | "block.minecraft.cave_air" | "block.minecraft.podzol" | "gamerule.snowAccumulationHeight" | "death.attack.irons_spellbooks.sacrifice" | "slot.unknown" | "subtitles.block.iron_trapdoor.close" | "affix.irons_spellbooks:armor/attribute/cooldown.suffix" | "block.minecraft.banner.square_bottom_left.magenta" | "item.irons_spellbooks.eldritch_manuscript" | "options.autosaveIndicator" | "selectWorld.version" | "death.attack.inWall.player" | "item.minecraft.llama_spawn_egg" | "item.minecraft.splash_potion.effect.luck" | "fml.menu.mods.info.signature" | "options.narrator.chat" | "death.fell.accident.scaffolding" | "config.jade.display_fluids_extra_msg" | "item.minecraft.stone_hoe" | "block.minecraft.banner.flower.red" | "item.minecraft.iron_nugget" | "item.minecraft.dolphin_spawn_egg" | "commands.teleport.success.location.single" | "ui.irons_spellbooks.dimensions" | "options.graphics.fancy.tooltip" | "item.irons_spellbooks.evoker_spell_book" | "block.minecraft.banner.half_vertical_right.red" | "death.attack.irons_spellbooks.dragon_breath" | "key.keyboard.caps.lock" | "itemGroup.foodAndDrink" | "merchant.next_level" | "effect.irons_spellbooks.fortify.description" | "block.minecraft.banner.diagonal_left.red" | "item.minecraft.item_frame" | "block.minecraft.banner.half_vertical_right.cyan" | "subtitles.entity.generic.eat" | "irons_spellbooks.tetra_effect.freeze" | "spell.irons_spellbooks.shockwave" | "biome.minecraft.old_growth_pine_taiga" | "subtitles.entity.hoglin.death" | "arguments.nbtpath.nothing_found" | "mco.reset.world.adventure" | "painting.minecraft.sea.title" | "options.difficulty.easy.info" | "config.jei.advanced.centerSearchBarEnabled.comment" | "options.darkMojangStudiosBackgroundColor" | "stat.minecraft.interact_with_campfire" | "subtitles.entity.shulker_bullet.hit" | "item.irons_spellbooks.priest_chestplate" | "block.minecraft.cyan_wool" | "death.attack.magic.player" | "commands.attribute.failed.no_attribute" | "item.minecraft.music_disc_strad.desc" | "commands.gamemode.success.other" | "item.minecraft.lingering_potion.effect.harming" | "block.minecraft.banner.straight_cross.pink" | "subtitles.entity.shulker.open" | "argument.entity.selector.allPlayers" | "enchantment.minecraft.thorns.desc" | "spell.irons_spellbooks.lightning_bolt" | "trim_pattern.minecraft.sentry" | "container.enchant.lapis.one" | "stat.minecraft.fly_one_cm" | "item.modifiers.legs" | "block.minecraft.banner.diagonal_up_left.cyan" | "commands.bossbar.set.visible.success.visible" | "block.minecraft.banner.small_stripes.lime" | "enchantment.gofish.deepfry.desc" | "block.minecraft.cut_sandstone" | "block.minecraft.red_tulip" | "spell.irons_spellbooks.slow" | "subtitles.block.cake.add_candle" | "gui.chatReport.send.no_reason" | "modernfix.option.category.bugfixes" | "controls.title" | "text.cloth-config.boolean.value.false" | "item.irons_spellbooks.plagued_leggings" | "subtitles.entity.piglin.jealous" | "telemetry.event.performance_metrics.description" | "block.minecraft.light_gray_banner" | "multiplayer.title" | "fml.menu.backupfailed.title" | "gamerule.randomTickSpeed" | "item.minecraft.heart_of_the_sea" | "death.attack.irons_spellbooks.raise_dead" | "jade.instrument.basedrum" | "sodium.console.game_restart" | "key.keyboard.left.alt" | "block.minecraft.banner.diagonal_up_left.red" | "deathScreen.score" | "block.minecraft.banner.diagonal_up_right.magenta" | "optimizeWorld.info.skipped" | "attribute.irons_spellbooks.lightning_magic_resist" | "commands.ride.dismount.success" | "subtitles.entity.turtle.death" | "item.minecraft.name_tag" | "effect.irons_spellbooks.polar_bear_timer.description" | "stat.minecraft.jump" | "config.jade.plugin_minecraft.item_storage.items_per_line" | "forge.swim_speed" | "block.minecraft.polished_deepslate_wall" | "subtitles.entity.elder_guardian.curse" | "block.minecraft.banner.stripe_top.purple" | "commands.fillbiome.success.count" | "modmenu.descriptionTranslation.jade" | "item.minecraft.glass_bottle" | "block.minecraft.banner.piglin.magenta" | "item.minecraft.ender_eye" | "chat.disabled.options" | "item.minecraft.archer_pottery_shard" | "key.keyboard.pause" | "block.minecraft.jungle_wall_sign" | "block.minecraft.waxed_copper_block" | "item.minecraft.pitcher_pod" | "mco.template.select.failure" | "pack.name.fabricMods" | "commands.trigger.simple.success" | "quickplay.error.title" | "item.minecraft.firework_star.white" | "block.minecraft.gray_stained_glass" | "config.jade.plugin_secretrooms.jadeaddons" | "block.minecraft.sandstone_slab" | "item.minecraft.lingering_potion.effect.leaping" | "spell.irons_spellbooks.wither_skull.guide" | "container.furnace" | "config.jade.plugin_minecraft.redstone" | "spell.irons_spellbooks.lightning_bolt.guide" | "commands.forceload.query.success" | "fml.dependencyloading.mismatchedcontaineddependencies" | "commands.whitelist.remove.failed" | "block.minecraft.banner.skull.white" | "block.minecraft.banner.square_bottom_left.yellow" | "block.minecraft.banner.circle.cyan" | "tooltip.irons_spellbooks.cast_continuous" | "subtitles.item.flintandsteel.use" | "options.telemetry.state.all" | "block.minecraft.potted_allium" | "subtitles.entity.endermite.hurt" | "tooltip.irons_spellbooks.rarity" | "commands.debug.function.noRecursion" | "spell.irons_spellbooks.acupuncture.guide" | "block.minecraft.banner.small_stripes.blue" | "death.attack.irons_spellbooks.ray_of_frost.item" | "key.jei.toggleCheatModeConfigButton" | "block.minecraft.waxed_weathered_cut_copper_stairs" | "block.minecraft.stone" | "item.irons_spellbooks.ruined_book" | "item.irons_spellbooks.frostward_ring" | "subtitles.entity.allay.death" | "dataPack.vanilla.description" | "key.jade.show_details" | "block.minecraft.banner.diagonal_up_left.light_blue" | "commands.place.jigsaw.success" | "trim_pattern.minecraft.wayfinder" | "block.minecraft.banner.globe.black" | "jadeaddons.deepresonance.generators" | "block.minecraft.banner.skull.gray" | "text.cloth-config.restart_required" | "advancements.adventure.very_very_frightening.description" | "selectWorld.backupQuestion.snapshot" | "sodium.options.animate_only_visible_textures.name" | "telemetry.property.game_mode.title" | "commands.scoreboard.players.list.empty" | "gamerule.doTraderSpawning" | "advancements.story.lava_bucket.description" | "key.keyboard.minus" | "options.entityDistanceScaling" | "item.minecraft.diamond_horse_armor" | "gamerule.maxEntityCramming" | "tooltip.irons_spellbooks.oakskin_description" | "advancements.adventure.totem_of_undying.title" | "entity.minecraft.snow_golem" | "options.particles.minimal" | "subtitles.block.barrel.open" | "title.32bit.deprecation.realms" | "text.cloth-config.error.too_large" | "block.minecraft.copper_ore" | "gui.socialInteractions.empty_blocked" | "patchouli.gui.lexicon.no_entries" | "block.minecraft.green_wool" | "block.minecraft.carrots" | "item.irons_spellbooks.archevoker_boots" | "subtitles.entity.villager.work_mason" | "toast.jade.tts_hint.1" | "mco.notification.dismiss" | "toast.jade.tts_hint.2" | "mco.configure.world.minigame" | "commands.summon.failed.uuid" | "advMode.trackOutput" | "mco.minigame.world.switch.title" | "config.jade.plugin_minecraft.beehive" | "item.minecraft.cod" | "block.minecraft.gray_candle_cake" | "item.minecraft.debug_stick.select" | "block.minecraft.piston_head" | "item.minecraft.potion.effect.slow_falling" | "options.resourcepack" | "subtitles.entity.wither.hurt" | "fml.button.open.file" | "death.attack.mob" | "block.minecraft.lime_carpet" | "advancements.nether.netherite_armor.description" | "subtitles.item.armor.equip_elytra" | "selectServer.hiddenAddress" | "commands.weather.set.thunder" | "death.attack.fire_field" | "jadeaddons.mcjtylib.ownedBy" | "color.minecraft.light_blue" | "block.minecraft.banner.mojang.red" | "subtitles.entity.salmon.flop" | "block.minecraft.potted_crimson_roots" | "tooltip.titanium.tank.empty" | "text.cloth-config.multi_error" | "spell.irons_spellbooks.cloud_of_regeneration.guide" | "wood_type.minecraft.dark_oak" | "item.minecraft.debug_stick.update" | "pack.incompatible.confirm.old" | "options.narrator" | "tetra.stats.irons_spellbooks:mana_siphon.tooltip_short" | "jei.tooltip.recipe.sort.craftable.first.enabled" | "block.minecraft.stripped_crimson_hyphae" | "gui.chatReport.draft.content" | "mco.brokenworld.download" | "subtitles.entity.zombie.break_wooden_door" | "block.minecraft.banner.gradient_up.gray" | "multiplayer.player.list.narration" | "item.irons_spellbooks.cooldown_ring" | "block.geckolib.gecko_habitat" | "item.minecraft.bundle.fullness" | "subtitles.entity.hoglin.step" | "death.attack.dryout.player" | "item.minecraft.iron_helmet" | "commands.experience.add.points.success.multiple" | "subtitles.entity.parrot.imitate.piglin_brute" | "subtitles.entity.polar_bear.ambient_baby" | "config.jei.search.tooltipSearchMode" | "options.difficulty.normal.info" | "tooltip.titanium.facing_handler.left" | "gui.toRealms" | "selectWorld.gameMode.survival" | "key.playerlist" | "options.graphics.warning.cancel" | "debug.help.message" | "block.minecraft.potted_blue_orchid" | "modernfix.option.mixin.perf.reduce_blockstate_cache_rebuilds" | "jade.instrument.didgeridoo" | "block.minecraft.brick_stairs" | "structure_block.mode.data" | "gui.jei.category.campfire" | "fml.menu.backupfailed.message" | "item.minecraft.beetroot_soup" | "enchantment.dungeonsenchantments.pain_cycle.desc" | "subtitles.entity.turtle.death_baby" | "config.jade.animation_desc" | "addServer.enterName" | "modernfix.option.mixin.perf.resourcepacks" | "multiplayer.disconnect.kicked" | "block.minecraft.waxed_cut_copper_slab" | "mco.backup.changes.tooltip" | "subtitles.entity.skeleton.converted_to_stray" | "commands.forge.tags.tag_count" | "block.minecraft.banner.flower.yellow" | "block.minecraft.banner.diagonal_right.magenta" | "mco.upload.size.failure.line2" | "mco.upload.size.failure.line1" | "wood_type.minecraft.mangrove" | "createWorld.customize.custom.minHeight" | "item.minecraft.burn_pottery_shard" | "block.minecraft.banner.square_bottom_right.purple" | "commands.scoreboard.objectives.add.success" | "flat_world_preset.minecraft.water_world" | "ui.irons_spellbooks.damage" | "key.keyboard.left.shift" | "block.minecraft.banner.base.brown" | "enchantment.create_sa.gravity_gun.desc" | "block.minecraft.banner.base.red" | "command.context.here" | "mco.template.title" | "subtitles.entity.horse.ambient" | "block.minecraft.cherry_wall_hanging_sign" | "mco.configure.world.spawnNPCs" | "enchantment.improved_exp.absorption.desc" | "embeddium.options.use_quad_normals_for_lighting.name" | "item.minecraft.pillager_spawn_egg" | "tetra.material.irons_spellbooks_nature_rune_socket.prefix" | "structure_block.include_entities" | "multiplayerWarning.check" | "subtitles.entity.leash_knot.break" | "block.minecraft.banner.triangle_bottom.magenta" | "options.hidden" | "effect.irons_spellbooks.ascension" | "block.minecraft.banner.circle.brown" | "commands.curios.set.success" | "modernfix.option.mixin.feature.snapshot_easter_egg" | "item.minecraft.strider_spawn_egg" | "subtitles.entity.parrot.imitate.wither_skeleton" | "mco.gui.button" | "patchouli.gui.lexicon.button.back" | "text.cloth-config.ignore_restart" | "block.minecraft.banner.diagonal_up_right.pink" | "gui.socialInteractions.status_offline" | "block.minecraft.weeping_vines_plant" | "mco.download.preparing" | "block.minecraft.banner.rhombus.light_blue" | "mco.upload.entry.cheats" | "death.attack.outsideBorder.player" | "block.minecraft.gray_banner" | "commands.function.success.single" | "item.irons_spellbooks.dragonskin_spell_book" | "fml.modmismatchscreen.mismatchedmods" | "multiplayer.message_not_delivered" | "subtitles.entity.fox.aggro" | "tooltip.irons_spellbooks.spellbook_rarity" | "gamerule.mobGriefing" | "item.minecraft.spyglass" | "subtitles.item.bucket.fill_axolotl" | "options.screenEffectScale.tooltip" | "selectWorld.gameMode" | "entity.minecraft.tropical_fish.type.stripey" | "createWorld.customize.custom.prev" | "effect.irons_spellbooks.instant_mana" | "createWorld.customize.presets.title" | "enchantment.improved_exp.in_all_seriousness.desc" | "block.minecraft.white_stained_glass_pane" | "block.minecraft.potted_jungle_sapling" | "options.modelPart.right_sleeve" | "gui.curios.toggle" | "commands.summon.failed" | "arguments.operation.invalid" | "block.minecraft.banner.half_vertical.black" | "item.minecraft.lingering_potion" | "direction.titanium.east" | "subtitles.entity.villager.ambient" | "spell.irons_spellbooks.thunder_step.guide" | "block.minecraft.banner.rhombus.lime" | "block.minecraft.banner.half_vertical.cyan" | "enchantment.improved_exp.far_swing.desc" | "item.patchouli:test_book_1.name" | "key.keyboard.left.bracket" | "item.minecraft.tipped_arrow.effect.swiftness" | "jade.blockpos" | "subtitles.item.trident.thunder" | "config.jade.plugin_jade.coordinates.rel_desc" | "argument.time.invalid_tick_count" | "jade.west" | "block.minecraft.banner.stripe_top.magenta" | "menu.reportBugs" | "enchantment.minecraft.frost_walker" | "block.minecraft.banner.half_vertical_right.light_gray" | "block.minecraft.banner.stripe_downright.orange" | "curios.identifier.charm" | "biome.minecraft.stony_shore" | "item.minecraft.goat_horn" | "painting.minecraft.pointer.title" | "tooltip.titanium.locks" | "block.minecraft.birch_button" | "subtitles.weather.rain" | "gamerule.tntExplosionDropDecay" | "enchantment.improved_exp.damage_suppression.desc" | "block.minecraft.purple_candle_cake" | "commands.summon.invalidPosition" | "block.minecraft.stripped_crimson_stem" | "subtitles.block.sculk_sensor.clicking" | "subtitles.entity.camel.eat" | "subtitles.entity.wandering_trader.death" | "gui.abuseReport.reason.hate_speech" | "block.minecraft.jungle_fence" | "entity.minecraft.item" | "selectWorld.mapType.normal" | "instrument.minecraft.yearn_goat_horn" | "commands.schedule.cleared.success" | "block.minecraft.banner.globe.magenta" | "advMode.type" | "generator.minecraft.flat" | "menu.singleplayer" | "config.jei.search.tagSearchMode.comment" | "narrator.loading.done" | "commands.attribute.failed.entity" | "disconnect.timeout" | "modernfix.option.mixin.feature.measure_time" | "selectWorld.recreate.error.text" | "book.generation.3" | "jecharacters.chat.saved" | "book.generation.1" | "book.generation.2" | "gamerule.waterSourceConversion.description" | "subtitles.entity.wandering_trader.reappeared" | "block.minecraft.seagrass" | "commands.irons_spellbooks.create_debug_wizard.failed_max_level" | "block.minecraft.diamond_block" | "item.minecraft.potion.effect.healing" | "mco.configure.world.subscription.remaining.days" | "ui.irons_spellbooks.summon_count" | "block.minecraft.blue_carpet" | "block.minecraft.lightning_rod" | "config.jei.advanced.debugModeEnabled.comment" | "item.irons_spellbooks.magic_cloth" | "item.irons_spellbooks.wayward_compass.error" | "enchantment.minecraft.sweeping" | "commands.data.block.query" | "subtitles.entity.zombie.attack_wooden_door" | "jei.message.config.folder" | "config.jade.plugin_minecraft.horse_stats" | "item.minecraft.dark_oak_boat" | "item.irons_spellbooks.spell_slot_upgrade_desc" | "options.chat.delay_none" | "spell.irons_spellbooks.guiding_bolt" | "enchantment.dungeonsenchantments.freezing.desc" | "item.minecraft.white_dye" | "block.minecraft.potted_cactus" | "gui.chatReport.send.comments_too_long" | "item.minecraft.crossbow.projectile" | "gui.moonlight.open_mod_page" | "container.enchant.clue" | "block.minecraft.banner.rhombus.blue" | "selectWorld.edit.export_worldgen_settings" | "subtitles.entity.zombie.ambient" | "item.minecraft.feather" | "options.languageWarning" | "spell.irons_spellbooks.telekinesis" | "painting.minecraft.skeleton.author" | "block.minecraft.banner.border.light_gray" | "subtitles.entity.zombie.death" | "item.minecraft.chainmail_helmet" | "gui.banned.title.permanent" | "item.minecraft.warden_spawn_egg" | "commands.forceload.removed.multiple" | "options.damageTiltStrength" | "team.visibility.always" | "forge.configgui.dimensionUnloadQueueDelay" | "block.minecraft.mud_brick_slab" | "argument.entity.options.level.description" | "fml.menu.mods.info.credits" | "block.minecraft.banner.gradient.orange" | "block.minecraft.netherrack" | "block.minecraft.ice" | "item.minecraft.tadpole_spawn_egg" | "block.minecraft.banner.square_bottom_right.light_gray" | "book.generation.0" | "block.minecraft.banner.square_top_right.purple" | "block.minecraft.crimson_sign" | "block.minecraft.lantern" | "mco.configure.world.invites.normal.tooltip" | "wood_type.twilightforest.dark" | "patchouli.gui.lexicon.landing_info" | "config.jade.plugin_jade.block_face_desc" | "block.minecraft.banner.stripe_bottom.brown" | "color.minecraft.magenta" | "gui.jei.category.itemInformation" | "config.jei.advanced.itemBlacklist" | "gui.banned.reason.extreme_violence_or_gore" | "block.minecraft.banner.half_horizontal.purple" | "block.minecraft.dropper" | "commands.perf.notRunning" | "subtitles.entity.goat.ambient" | "commands.forge.tps.invalid" | "subtitles.entity.tadpole.flop" | "advMode.self" | "key.categories.gameplay" | "narration.selection.usage" | "spell.irons_spellbooks.portal.guide" | "enchantment.improved_exp.invulnerability.desc" | "block.minecraft.banner.straight_cross.brown" | "jade.spawner" | "advancements.toast.task" | "block.minecraft.banner.triangles_top.red" | "death.attack.irons_spellbooks.summon_vex" | "block.minecraft.banner.half_horizontal_bottom.lime" | "options.sensitivity" | "subtitles.entity.enderman.teleport" | "spell.irons_spellbooks.stomp.guide" | "block.minecraft.pink_banner" | "commands.mana.add.success.multiple" | "spell.irons_spellbooks.firefly_swarm" | "entity.irons_spellbooks.electrocute_projectile" | "commands.clear.test.single" | "block.minecraft.pink_tulip" | "commands.drop.no_held_items" | "narrator.position.object_list" | "spell.irons_spellbooks.void_tentacles.guide" | "mco.trial.message.line1" | "mco.trial.message.line2" | "quickplay.error.realm_permission" | "subtitles.entity.strider.eat" | "block.minecraft.banner.globe.green" | "argument.entity.options.tag.description" | "item.irons_spellbooks.frozen_bone" | "argument.entity.options.dz.description" | "item.minecraft.golden_shovel" | "subtitles.entity.leash_knot.place" | "block.titanium.block_test" | "advancements.husbandry.allay_deliver_item_to_player.description" | "block.minecraft.redstone_lamp" | "effect.minecraft.jump_boost" | "commands.scoreboard.objectives.display.alreadyEmpty" | "effect.minecraft.instant_health" | "mco.brokenworld.play" | "options.modelPart.right_pants_leg" | "subtitles.entity.skeleton_horse.swim" | "spell.irons_spellbooks.lightning_lance" | "commands.team.add.success" | "subtitles.entity.parrot.imitate.piglin" | "debug.inspect.server.block" | "block.irons_spellbooks.arcane_debris" | "block.minecraft.diorite_wall" | "commands.effect.clear.specific.success.multiple" | "item.irons_spellbooks.lurker_ring.desc" | "advancements.husbandry.breed_all_animals.description" | "subtitles.block.beacon.power_select" | "resourcePack.programmer_art.name" | "time.bookshelf.day.saturday" | "subtitles.block.beacon.deactivate" | "modernfix.option.mixin.perf.dynamic_resources.ctm" | "options.off" | "item.minecraft.tipped_arrow.effect.levitation" | "item.minecraft.painting" | "effect.irons_spellbooks.rend.description" | "direction.titanium.up" | "block.minecraft.oak_button" | "patchouli.gui.lexicon.button.resize.size5" | "text.cloth.reset_value" | "patchouli.gui.lexicon.button.resize.size4" | "patchouli.gui.lexicon.button.resize.size3" | "commands.perf.stopped" | "death.attack.irons_spellbooks.magma_bomb" | "commands.stopsound.success.source.sound" | "attribute.irons_spellbooks.ender_magic_resist" | "spell.irons_spellbooks.ice_block.guide" | "patchouli.gui.lexicon.locked" | "patchouli.gui.lexicon.button.resize.size2" | "patchouli.gui.lexicon.button.resize.size1" | "subtitles.item.crossbow.hit" | "patchouli.gui.lexicon.button.resize.size0" | "entity.minecraft.minecart" | "item.irons_spellbooks.fire_ale" | "block.minecraft.polished_basalt" | "item.minecraft.lingering_potion.effect.water_breathing" | "item.minecraft.acacia_chest_boat" | "multiplayer.status.old" | "fml.menu.multiplayer.incompatible.extra" | "command.context.parse_error" | "stat.minecraft.drop" | "block.minecraft.banner.stripe_downleft.red" | "block.minecraft.light_gray_bed" | "stat_type.minecraft.crafted" | "item.irons_spellbooks.greater_healing_potion" | "subtitles.block.sniffer_egg.plop" | "block.minecraft.polished_andesite_slab" | "item.minecraft.firework_star.magenta" | "subtitles.entity.villager.work_shepherd" | "patchouli.gui.lexicon.index" | "block.minecraft.mossy_cobblestone_wall" | "advancements.irons_spellbooks.staff_root.description" | "modernfix.option.mixin.bugfix.file_dialog_title" | "multiplayer.stopSleeping" | "commands.particle.failed" | "subtitles.entity.camel.hurt" | "advancements.husbandry.froglights.description" | "screenshot.failure" | "parsing.quote.escape" | "advancements.adventure.read_power_from_chiseled_bookshelf.title" | "stat.minecraft.sprint_one_cm" | "commands.scoreboard.objectives.remove.success" | "tooltip.irons_spellbooks.selected_spell" | "sodium.options.buttons.undo" | "config.jei.search.creativeTabSearchMode" | "biome.minecraft.dark_forest" | "modernfix.option.mixin.perf.faster_command_suggestions" | "entity.minecraft.trident" | "spell.irons_spellbooks.shield.guide" | "multiplayer.disconnect.unexpected_query_response" | "block.minecraft.gilded_blackstone" | "subtitles.entity.husk.hurt" | "advancements.story.form_obsidian.title" | "death.attack.irons_spellbooks.poison_arrow.item" | "advancements.nether.charge_respawn_anchor.title" | "block.minecraft.jungle_slab" | "multiplayer.downloadingStats" | "tooltip.titanium.facing_handler.test2" | "subtitles.entity.cat.purr" | "entity.irons_spellbooks.poison_arrow" | "embeddium.conflicting_mod_list" | "difficulty.lock.question" | "config.jade.hide_from_debug" | "config.jade.plugin_jade" | "item.minecraft.jungle_chest_boat" | "jei.tooltip.bookmarks.recipe.add" | "team.visibility.hideForOtherTeams" | "spell.irons_spellbooks.firebolt" | "block.minecraft.mangrove_button" | "item.minecraft.chicken" | "block.minecraft.banner.square_bottom_left.white" | "death.attack.fireworks.item" | "mco.selectServer.trial" | "tooltip.titanium.tank.can_fill_from_item" | "block.minecraft.yellow_stained_glass" | "chat.coordinates" | "subtitles.entity.skeleton_horse.ambient" | "subtitles.block.chest.close" | "spell.irons_spellbooks.magic_missile.guide" | "advancements.nether.find_bastion.title" | "item.minecraft.tipped_arrow.effect.empty" | "block.minecraft.banner.square_top_left.white" | "block.minecraft.weathered_cut_copper_slab" | "gui.abuseReport.reason.alcohol_tobacco_drugs.description" | "options.prioritizeChunkUpdates.none.tooltip" | "block.minecraft.banner.mojang.pink" | "effect.irons_spellbooks.instant_mana.description" | "gui.abuseReport.reason.defamation_impersonation_false_information" | "block.minecraft.birch_sign" | "block.minecraft.banner.stripe_left.light_gray" | "config.jei.advanced.debugModeEnabled" | "death.attack.irons_spellbooks.blaze_storm.item" | "subtitles.entity.hoglin.hurt" | "chat_screen.usage" | "key.drop" | "mco.configure.world.players.title" | "config.moonlight.general.maps_mipmap.description" | "flat_world_preset.minecraft.snowy_kingdom" | "item.minecraft.wheat" | "entity.minecraft.end_crystal" | "spell.irons_spellbooks.recall.guide" | "jadeaddons.lootr.refreshed" | "options.mouse_settings.title" | "advancements.irons_spellbooks.ink_legendary.title" | "block.minecraft.shulker_box" | "subtitles.entity.zombie_horse.ambient" | "spell.irons_spellbooks.firecracker" | "subtitles.entity.mooshroom.eat" | "patchouli.gui.lexicon.button.back.info" | "block.minecraft.banner.base.cyan" | "gui.abuseReport.sending.title" | "credits_and_attribution.button.attribution" | "selectWorld.backupWarning.downgrade" | "key.keyboard.keypad.add" | "block.minecraft.player_head.named" | "key.keyboard.slash" | "modernfix.option.mixin.perf.remove_biome_temperature_cache" | "subtitles.entity.player.death" | "config.jade.item_mod_name_desc" | "block.minecraft.banner.diagonal_up_left.yellow" | "advancements.irons_spellbooks.make_inscription_table.title" | "menu.generatingTerrain" | "item.minecraft.golden_sword" | "mco.error.invalid.session.message" | "commands.ride.not_riding" | "createWorld.customize.custom.preset.mountains" | "effect.irons_spellbooks.fortify" | "block.minecraft.farmland" | "commands.data.get.multiple" | "options.forceUnicodeFont" | "config.jade.boss_bar_overlap_hide_tooltip" | "block.minecraft.cobblestone" | "entity.minecraft.egg" | "block.minecraft.cyan_terracotta" | "gui.chatReport.send.too_many_messages" | "merchant.trades" | "block.minecraft.light_blue_concrete" | "fml.menu.mods.normal" | "block.minecraft.acacia_button" | "item.minecraft.fermented_spider_eye" | "mco.configure.world.activityfeed.disabled" | "block.minecraft.honeycomb_block" | "commands.deop.success" | "key.fullscreen" | "block.minecraft.banner.border.gray" | "commands.function.success.single.result" | "selectWorld.mapFeatures" | "subtitles.block.chorus_flower.death" | "subtitles.block.sculk_catalyst.bloom" | "subtitles.entity.warden.attack_impact" | "block.minecraft.magenta_terracotta" | "accessibility.onboarding.screen.narrator" | "enchantment.minecraft.projectile_protection" | "subtitles.block.beehive.enter" | "enchantment.minecraft.bane_of_arthropods" | "block.minecraft.banner.base.purple" | "block.minecraft.stripped_jungle_wood" | "trim_material.minecraft.quartz" | "jade.owner" | "createWorld.customize.custom.fixedBiome" | "block.minecraft.banner.stripe_middle.magenta" | "item.irons_spellbooks.fireward_ring" | "subtitles.item.bundle.insert" | "subtitles.block.tripwire.attach" | "forge.configgui.indexVanillaPackCachesOnThread" | "subtitles.entity.zombie_villager.ambient" | "pack.incompatible.confirm.new" | "commands.advancement.advancementNotFound" | "subtitles.entity.sniffer.scenting" | "block.minecraft.banner.stripe_downleft.pink" | "patchouli.gui.lexicon.editor.mock_header" | "key.jei.focusSearch" | "painting.minecraft.water.author" | "attribute.irons_spellbooks.holy_spell_power" | "fml.resources.modresources" | "block.minecraft.yellow_bed" | "gui.done" | "commands.schedule.created.tag" | "spell.irons_spellbooks.heal.guide" | "arguments.nbtpath.node.invalid" | "config.moonlight.general.consistent_entity_renderer_shading.description" | "death.attack.dragonBreath" | "commands.jfr.dump.failed" | "mco.time.hoursAgo" | "stat.minecraft.climb_one_cm" | "subtitles.entity.iron_golem.repair" | "death.fell.assist.item" | "advancements.adventure.trim_with_all_exclusive_armor_patterns.title" | "config.jade.display_entities" | "block.minecraft.crimson_nylium" | "item.minecraft.sheep_spawn_egg" | "advancements.adventure.sniper_duel.title" | "text.cloth-config.error.not_valid_number_long" | "entity.minecraft.vex" | "advancements.nether.loot_bastion.title" | "block.minecraft.mossy_cobblestone" | "death.attack.sweetBerryBush.player" | "block.minecraft.prismarine_brick_stairs" | "block.minecraft.ladder" | "spell.irons_spellbooks.none" | "enchantment.improved_exp.machine_gun.desc" | "selectWorld.customizeType" | "subtitles.item.bundle.drop_contents" | "modifier.cloth-config.ctrl" | "block.minecraft.jungle_planks" | "subtitles.entity.frog.eat" | "argument.anchor.invalid" | "subtitles.entity.item_frame.break" | "spell.irons_spellbooks.sacrifice" | "sodium.options.weather_quality.tooltip" | "block.minecraft.banner.diagonal_left.purple" | "gui.banned.description" | "itemGroup.redstone" | "stat.minecraft.trigger_trapped_chest" | "affix.irons_spellbooks:spellbook/attribute/cast_time_reduction.suffix" | "editGamerule.title" | "tooltip.irons_spellbooks.ink_tooltip" | "item.minecraft.chainmail_leggings" | "item.minecraft.skeleton_horse_spawn_egg" | "item.minecraft.squid_spawn_egg" | "selectWorld.conversion.tooltip" | "block.minecraft.banner.square_bottom_right.cyan" | "block.minecraft.banner.creeper.light_gray" | "block.minecraft.banner.triangles_top.yellow" | "block.minecraft.oak_fence" | "item.minecraft.lingering_potion.effect.invisibility" | "commands.forge.gen.usage" | "dataPack.bundle.description" | "direction.titanium.down" | "container.beacon" | "sodium.options.entity_distance.tooltip" | "commands.clone.overlap" | "ui.irons_spellbooks.cast_error_target" | "ui.irons_spellbooks.reduced_healing" | "block.minecraft.banner.half_vertical_right.black" | "biome.minecraft.lush_caves" | "selectWorld.backupEraseCache" | "block.minecraft.crimson_fence_gate" | "block.minecraft.banner.cross.light_blue" | "block.minecraft.potted_pink_tulip" | "fml.modloading.brokenresources" | "mco.download.resourcePack.fail" | "block.minecraft.potted_fern" | "item.minecraft.nautilus_shell" | "item.minecraft.golden_hoe" | "item.minecraft.potion.effect.fire_resistance" | "gui.chatSelection.context" | "fml.modloading.brokenfile.oldforge" | "block.geckolib.fertilizer" | "subtitles.entity.tropical_fish.death" | "flat_world_preset.minecraft.overworld" | "item.minecraft.carrot_on_a_stick" | "multiplayer.disconnect.out_of_order_chat" | "affix.irons_spellbooks:spellbook/attribute/evocation_spell_power" | "narration.recipe" | "key.jei.showRecipe2" | "tooltip.titanium.tank.can_drain_from_item" | "controls.reset" | "trim_pattern.minecraft.eye" | "entity.minecraft.mooshroom" | "argument.resource.invalid_type" | "commands.team.option.seeFriendlyInvisibles.alreadyEnabled" | "item.minecraft.bow" | "options.glintStrength" | "block.minecraft.banner.stripe_bottom.gray" | "config.jade.plugin_create.goggles.requires_goggles" | "ui.irons_spellbooks.ink_rarity_error" | "block.minecraft.deepslate" | "block.minecraft.wheat" | "gamerule.maxCommandChainLength.description" | "menu.online" | "fml.menu.multiplayer.networkincompatible" | "stat.minecraft.damage_dealt_absorbed" | "block.minecraft.banner.triangle_bottom.white" | "curios.identifier.belt" | "irons_spellbooks.tetra_bar.evocation_spell_power.tooltip" | "options.accessibility.text_background.everywhere" | "item.minecraft.debug_stick" | "pack.incompatible.confirm.compatible" | "modernfix.option.mixin.perf.nbt_memory_usage" | "block.minecraft.banner.piglin.brown" | "block.minecraft.dark_oak_hanging_sign" | "mco.selectServer.expiredRenew" | "item.irons_spellbooks.keeper_flamberge" | "item.minecraft.mule_spawn_egg" | "tooltip.irons_spellbooks.level" | "instrument.minecraft.seek_goat_horn" | "block.minecraft.banner.cross.gray" | "block.minecraft.bamboo_block" | "lanServer.port.unavailable" | "modernfix.option.mixin.perf.skip_first_datapack_reload" | "embeddium.search_bar_empty" | "item.minecraft.hopper_minecart" | "demo.remainingTime" | "gamerule.waterSourceConversion" | "pack.description.modResources" | "item.minecraft.tipped_arrow.effect.awkward" | "mco.client.incompatible.title" | "block.minecraft.banner.stripe_center.orange" | "mco.selectServer.create" | "attribute.irons_spellbooks.cooldown_reduction" | "block.minecraft.banner.stripe_left.purple" | "effect.irons_spellbooks.slowed.description" | "entity.irons_spellbooks.blood_slash_projectile" | "subtitles.entity.player.attack.crit" | "attribute.irons_spellbooks.fire_magic_resist" | "subtitles.entity.panda.worried_ambient" | "subtitles.item.dye.use" | "sodium.options.vignette.tooltip" | "instrument.minecraft.dream_goat_horn" | "block.minecraft.banner.globe.white" | "dataPack.vanilla.name" | "gui.down" | "block.minecraft.black_bed" | "entity.minecraft.sniffer" | "modernfix.option.mixin.feature.branding" | "block.minecraft.banner.stripe_middle.gray" | "death.attack.onFire.player" | "subtitles.block.composter.empty" | "subtitles.entity.warden.nearby_closer" | "demo.demoExpired" | "item.minecraft.spruce_boat" | "commands.weather.set.clear" | "subtitles.item.crossbow.shoot" | "ui.irons_spellbooks.cast_continuous" | "spell.irons_spellbooks.divine_smite.guide" | "mco.backup.restoring" | "subtitles.entity.item_frame.place" | "subtitles.entity.hoglin.converted_to_zombified" | "subtitles.entity.magma_cube.death" | "jei.tooltip.cheat.mode.how.to.disable.hotkey" | "commands.worldborder.warning.time.failed" | "block.minecraft.banner.half_vertical_right.green" | "item.minecraft.tipped_arrow.effect.mundane" | "subtitles.entity.parrot.imitate.wither" | "advancements.adventure.honey_block_slide.description" | "advancements.adventure.two_birds_one_arrow.title" | "block.minecraft.banner.gradient.blue" | "enchantment.improved_exp.jump_boost.desc" | "mco.selectServer.closed" | "block.minecraft.sea_lantern" | "block.minecraft.stripped_jungle_log" | "container.brewing" | "subtitles.block.generic.hit" | "block.minecraft.prismarine_bricks" | "spell.irons_spellbooks.summon_horse" | "selectServer.deleteWarning" | "subtitles.entity.piglin.death" | "block.minecraft.banner.creeper.cyan" | "advancements.husbandry.wax_on.description" | "item.minecraft.brown_dye" | "lanserverproperties.button.lan_server_options" | "mco.upload.hardcore" | "subtitles.entity.egg.throw" | "advancements.adventure.kill_mob_near_sculk_catalyst.description" | "item.minecraft.prize_pottery_sherd" | "stat.minecraft.walk_under_water_one_cm" | "createWorld.customize.custom.preset.caveChaos" | "enchantment.minecraft.protection.desc" | "stat.minecraft.interact_with_blast_furnace" | "gui.recipebook.toggleRecipes.smeltable" | "item.minecraft.panda_spawn_egg" | "block.minecraft.conduit" | "block.minecraft.oxidized_cut_copper" | "time.bookshelf.month.june" | "commands.worldborder.damage.buffer.failed" | "block.minecraft.white_candle_cake" | "block.minecraft.dead_bubble_coral" | "death.attack.irons_spellbooks.thunderstorm.item" | "block.minecraft.cobblestone_stairs" | "titanium.rewards.enabled_success" | "item.geckolib.gecko_armor_boots" | "gui.abuseReport.reason.imminent_harm" | "mco.invites.nopending" | "subtitles.entity.parrot.imitate.husk" | "stat.minecraft.play_time" | "jei.chat.error.no.cheat.permission.give" | "block.minecraft.banner.curly_border.red" | "block.minecraft.calcite" | "subtitles.entity.skeleton.hurt" | "block.minecraft.cyan_concrete_powder" | "fml.menu.multiplayer.modsincompatible" | "commands.spawnpoint.success.single" | "tooltip.jade.crop_mature" | "block.minecraft.gray_bed" | "argument.entity.invalid" | "block.minecraft.grass" | "mirror.left_right" | "subtitles.item.spyglass.use" | "createWorld.customize.presets.select" | "argument.entity.options.curios.description" | "commands.fillbiome.toobig" | "jei.key.mouse.right" | "createWorld.customize.custom.useMansions" | "commands.advancement.revoke.one.to.one.success" | "selectWorld.recreate.customized.text" | "block.minecraft.jungle_door" | "fml.modmismatchscreen.missingmods.server" | "death.attack.freeze.player" | "commands.forge.setdim.invalid.dim" | "entity.minecraft.drowned" | "fml.menu.mods" | "entity.minecraft.pufferfish" | "block.minecraft.banner.globe.red" | "item.minecraft.dried_kelp" | "subtitles.entity.camel.step" | "block.minecraft.basalt" | "item.irons_spellbooks.druidic_spell_book" | "item.minecraft.diamond_chestplate" | "credits_and_attribution.button.licenses" | "advancements.irons_spellbooks.ink_legendary.description" | "selectWorld.resultFolder" | "block.minecraft.creeper_head" | "item.irons_spellbooks.plagued_helmet" | "commands.advancement.revoke.criterion.to.one.success" | "spell.irons_spellbooks.greater_heal.guide" | "pack.source.server" | "block.minecraft.dark_prismarine" | "subtitles.item.armor.equip_turtle" | "stat.minecraft.minecart_one_cm" | "item.irons_spellbooks.weapon_parts" | "key.jade.show_recipes" | "selectWorld.edit.backupSize" | "subtitles.entity.parrot.imitate.phantom" | "death.attack.irons_spellbooks.thunderstorm" | "subtitles.entity.dolphin.splash" | "item.minecraft.bamboo_raft" | "item.minecraft.firework_star.brown" | "patchouli.gui.lexicon.index.info" | "item.irons_spellbooks.tarnished_crown" | "item.minecraft.emerald" | "subtitles.entity.salmon.hurt" | "tutorial.punch_tree.description" | "commands.title.reset.multiple" | "pack.source.local" | "subtitles.entity.evoker.death" | "leaves_type.minecraft.dark_oak" | "modernfix.option.mixin.perf.dynamic_resources.rs" | "effect.irons_spellbooks.guided.description" | "item.modifiers.feet" | "tooltip.jade.mode" | "subtitles.entity.horse.saddle" | "subtitles.entity.wither.ambient" | "config.jade.plugin_create.crafting_blueprint" | "mco.backup.entry.uploaded" | "config.jade.plugin_minecraft.fluid_storage_extra_msg" | "entity.minecraft.zombified_piglin" | "chat.disabled.profile.moreInfo" | "stat.minecraft.play_noteblock" | "advancements.husbandry.make_a_sign_glow.description" | "block.minecraft.cherry_fence" | "enchantment.improved_exp.telekinesis.desc" | "death.attack.irons_spellbooks.poison_splash.item" | "subtitles.entity.arrow.hit_player" | "disconnect.lost" | "advMode.mode.autoexec.bat" | "block.minecraft.copper_block" | "block.minecraft.lime_shulker_box" | "fml.messages.version.restriction.bounded.exclusive" | "gui.socialInteractions.status_hidden" | "modernfix.option.mixin.bugfix.world_leaks" | "commands.spreadplayers.failed.teams" | "forge.controlsgui.control.mac" | "pack.incompatible.old" | "time.bookshelf.month.july" | "block.minecraft.acacia_wood" | "gamerule.doTileDrops.description" | "patchouli.gui.lexicon.button.visualize" | "block.minecraft.potted_azalea_bush" | "block.minecraft.banner.circle.orange" | "death.attack.irons_spellbooks.lightning_bolt" | "block.minecraft.gravel" | "block.minecraft.bubble_coral_wall_fan" | "gui.jei.category.tagInformation" | "subtitles.entity.minecart.riding" | "block.minecraft.banner.mojang.gray" | "death.attack.genericKill" | "entity.irons_spellbooks.dead_king" | "block.minecraft.light_blue_terracotta" | "commands.team.remove.success" | "key.togglePerspective" | "subtitles.entity.enderman.scream" | "curios.identifier.bracelet" | "item.minecraft.rabbit_stew" | "item.minecraft.netherite_sword" | "biome.minecraft.ice_spikes" | "config.jade.plugin_minecraft.animal_owner_extra_msg" | "options.hideMatchedNames.tooltip" | "mco.client.incompatible.msg.line1" | "block.minecraft.pink_concrete" | "item.minecraft.chainmail_chestplate" | "mco.client.incompatible.msg.line3" | "mco.client.incompatible.msg.line2" | "commands.tag.remove.failed" | "advancements.irons_spellbooks.ink_root.title" | "commands.forge.mods.list" | "enchantment.dungeonsenchantments.void_strike.desc" | "deathScreen.titleScreen" | "item.minecraft.lingering_potion.effect.levitation" | "item.minecraft.nether_brick" | "config.jade.overlay_theme" | "jade.theme.jade.create" | "death.attack.inFire.player" | "block.minecraft.prismarine" | "item.irons_spellbooks.spell_book" | "block.minecraft.banner.half_vertical_right.gray" | "item.minecraft.music_disc_far" | "structure_block.size_failure" | "entity.minecraft.panda" | "item.irons_spellbooks.staff_of_the_nines" | "narration.button" | "options.difficulty.hard.info" | "selectWorld.backupJoinConfirmButton" | "sodium.options.chunk_update_threads.tooltip" | "multiplayer.status.quitting" | "subtitles.entity.goat.ram_impact" | "subtitles.item.brush.brushing.gravel.complete" | "tooltip.titanium.facing_handler.inventory" | "block.minecraft.brown_stained_glass_pane" | "advancements.adventure.avoid_vibration.description" | "entity.minecraft.potion" | "soundCategory.weather" | "block.minecraft.banner.straight_cross.red" | "gui.chatSelection.heading" | "commands.attribute.value.get.success" | "effect.irons_spellbooks.ascension.description" | "merchant.deprecated" | "commands.title.times.multiple" | "block.minecraft.banner.stripe_middle.green" | "subtitles.entity.creeper.primed" | "leaves_type.minecraft.spruce" | "block.minecraft.light_blue_stained_glass" | "entity.minecraft.villager.toolsmith" | "item.minecraft.diamond_shovel" | "pack.copyFailure" | "gui.socialInteractions.shown_in_chat" | "subtitles.entity.axolotl.idle_water" | "modernfix.option.mixin.bugfix.concurrency" | "narrator.controls.bound" | "block.minecraft.banner.triangles_bottom.purple" | "subtitles.entity.sniffer.egg_hatch" | "telemetry_info.button.show_data" | "commands.forge.arguments.enum.invalid" | "subtitles.entity.zombie_villager.cure" | "config.jade.plugin_tconstruct.drain" | "commands.drop.success.single_with_table" | "tetra.variant.double_socket/permafrost_shard" | "affix.irons_spellbooks:spellbook/attribute/blood_spell_power.suffix" | "block.minecraft.waxed_exposed_cut_copper_slab" | "structure_block.mode.corner" | "__support_stalwart_dungeons" | "commands.ride.mount.failure.cant_ride_players" | "enchantment.improved_exp.pinger.desc" | "gamerule.doInsomnia" | "filled_map.level" | "commands.team.list.members.empty" | "subtitles.entity.wolf.ambient" | "mco.configure.world.buttons.close" | "enchantment.dungeonsenchantments.guarding_strike.desc" | "key.smoothCamera" | "block.minecraft.banner.stripe_top.light_blue" | "selectWorld.experimental.message" | "patchouli.gui.lexicon.remove_bookmark" | "options.glintSpeed" | "subtitles.entity.wither.death" | "effect.irons_spellbooks.raise_dead_timer" | "argument.item.id.invalid" | "block.minecraft.stone_brick_stairs" | "mco.backup.entry.enabledPack" | "commands.list.nameAndId" | "affix.irons_spellbooks:armor/attribute/mana.suffix" | "config.jade.plugin_minecraft.entity_armor" | "pack.incompatible.confirm.title" | "subtitles.entity.frog.ambient" | "argument.entity.options.advancements.description" | "gamerule.freezeDamage" | "subtitles.block.big_dripleaf.tilt_down" | "block.minecraft.target" | "item.minecraft.tipped_arrow.effect.water" | "block.minecraft.hanging_roots" | "ui.irons_spellbooks.spell_target_warning" | "block.minecraft.birch_sapling" | "enchantment.improved_exp.poisonous_water.desc" | "config.jade.accessibility" | "modernfix.option.mixin.perf.deduplicate_wall_shapes" | "gui.abuseReport.sent.title" | "item.minecraft.iron_golem_spawn_egg" | "block.minecraft.banner.half_vertical_right.white" | "commands.difficulty.query" | "attribute.irons_spellbooks.fire_spell_power" | "forge.configgui.fullBoundingBoxLadders.tooltip" | "item.minecraft.potion_splash" | "config.jei.search.resourceIdSearchMode" | "mco.time.secondsAgo" | "gui.jei.category.smelting" | "forge.entity_gravity" | "block.minecraft.jungle_sapling" | "block.minecraft.kelp" | "demo.help.movementMouse" | "ui.irons_spellbooks.radius" | "commands.whitelist.remove.success" | "advancements.adventure.kill_a_mob.title" | "death.attack.hotFloor.player" | "commands.spectate.success.started" | "block.minecraft.banner.stripe_right.light_blue" | "advancements.adventure.whos_the_pillager_now.description" | "entity.irons_spellbooks.dragon_breath_projectile" | "parsing.expected" | "block.minecraft.chorus_plant" | "options.graphics.warning.version" | "gui.chatReport.draft.discard" | "selectWorld.backupQuestion.downgrade" | "irons_spellbooks.tetra_effect.mana_siphon.tooltip" | "options.hideLightningFlashes" | "item.minecraft.cooked_rabbit" | "key.keyboard.right.bracket" | "entity.minecraft.shulker_bullet" | "gui.recipebook.search_hint" | "modernfix.option.mixin.bugfix.cofh_core_crash" | "mco.selectServer.expiredTrial" | "block.minecraft.banner.stripe_downleft.purple" | "argument.entity.options.type.description" | "block.minecraft.azure_bluet" | "enchantment.improved_exp.planeswalker.desc" | "trim_material.minecraft.lapis" | "trim_pattern.minecraft.tide" | "spell.irons_spellbooks.frostwave.guide" | "block.irons_spellbooks.alchemist_cauldron" | "block.minecraft.banner.stripe_middle.white" | "subtitles.entity.squid.squirt" | "effect.irons_spellbooks.rend" | "gui.abuseReport.reason.alcohol_tobacco_drugs" | "mco.create.world.skip" | "item.irons_spellbooks.mana_ring" | "fml.modloading.brokenfile.bukkit" | "debug.pause_focus.help" | "enchantment.shieldsplus.recoil.desc" | "tetra.material.irons_spellbooks_arcane_cloth.prefix" | "modernfix.option.mixin.bugfix.remove_block_chunkloading" | "options.chat.opacity" | "subtitles.block.blastfurnace.fire_crackle" | "config.jei.advanced.centerSearchBarEnabled" | "createWorld.customize.custom.size" | "block.minecraft.purpur_slab" | "item.minecraft.lingering_potion.effect.turtle_master" | "mco.selectServer.close" | "block.minecraft.banner.triangle_bottom.purple" | "block.minecraft.spruce_sign" | "spell.irons_spellbooks.cloud_of_regeneration" | "item.minecraft.light_blue_dye" | "jei.tooltip.error.render.crash" | "stat.minecraft.fall_one_cm" | "block.minecraft.dragon_egg" | "block.minecraft.banner.bricks.yellow" | "gui.jade.preview" | "block.minecraft.banner.gradient_up.pink" | "block.minecraft.banner.square_bottom_left.cyan" | "block.minecraft.sculk_catalyst" | "forge.configgui.forceSystemNanoTime.tooltip" | "config.jei.advanced.comment" | "block.minecraft.red_wool" | "config.jade.display_item_centered" | "entity.irons_spellbooks.pyromancer" | "item.minecraft.wheat_seeds" | "options.audioDevice.default" | "enchantment.betterarcheology.tunneling.desc" | "commands.bossbar.set.max.success" | "block.minecraft.polished_diorite" | "parsing.int.expected" | "item.minecraft.hoglin_spawn_egg" | "mco.upload.verifying" | "commands.experience.query.points" | "affix.irons_spellbooks:armor/attribute/mana" | "entity.tconstruct.quartz_shuriken" | "block.minecraft.banner.half_horizontal_bottom.blue" | "block.minecraft.lava_cauldron" | "options.directionalAudio" | "block.minecraft.dead_horn_coral" | "commands.curios.dropAll.success" | "item.minecraft.suspicious_stew" | "subtitles.block.bell.use" | "block.minecraft.stone_button" | "advancements.husbandry.leash_all_frog_variants.title" | "selectWorld.gameMode.creative.info" | "stat.minecraft.inspect_dropper" | "subtitles.entity.zoglin.step" | "gui.jei.category.smelting.time.seconds" | "spell.irons_spellbooks.blaze_storm.guide" | "block.minecraft.pink_stained_glass" | "death.attack.sting.player" | "item.minecraft.shears" | "biome.minecraft.taiga" | "item.irons_spellbooks.truthseeker" | "block.minecraft.banner.triangles_bottom.light_blue" | "item.minecraft.potion.effect.water_breathing" | "death.attack.fallingStalactite.player" | "enchantment.minecraft.unbreaking.desc" | "block.minecraft.banner.stripe_middle.yellow" | "multiplayer.disconnect.banned.expiration" | "subtitles.entity.sniffer.egg_crack" | "trim_pattern.minecraft.vex" | "effect.minecraft.regeneration" | "mco.configure.world.commandBlocks" | "subtitles.entity.horse.breathe" | "spell.irons_spellbooks.healing_circle" | "options.chat.delay_instant" | "block.minecraft.red_candle" | "commands.scoreboard.players.list.entity.success" | "block.minecraft.blue_concrete_powder" | "effect.irons_spellbooks.enchanted_ward" | "mco.configure.world.subscription.month" | "multiplayer.player.left" | "createWorld.customize.custom.useMonuments" | "commands.irons_spellbooks.generate_recipe_data.failed" | "mco.configure.world.subscription.title" | "block.minecraft.banner.square_top_left.light_blue" | "commands.team.option.friendlyfire.disabled" | "block.minecraft.crimson_door" | "block.minecraft.granite_stairs" | "commands.curios.unlock.success" | "block.minecraft.banner.globe.purple" | "subtitles.entity.phantom.ambient" | "block.minecraft.bed.too_far_away" | "trim_pattern.minecraft.ward" | "gui.chatSelection.join" | "block.minecraft.banner.stripe_right.gray" | "commands.place.template.success" | "block.minecraft.banner.piglin.purple" | "gui.narrate.button" | "ui.irons_spellbooks.damage_reduction" | "block.minecraft.banner.diagonal_left.light_blue" | "options.notifications.display_time.tooltip" | "advancements.irons_spellbooks.spell_book_iron.title" | "block.minecraft.bamboo_sapling" | "advancements.nether.get_wither_skull.title" | "enchantment.create_sa.digging.desc" | "block.minecraft.birch_pressure_plate" | "entity.irons_spellbooks.poison_breath" | "mco.download.failed" | "advancements.irons_spellbooks.spell_book_diamond.title" | "mco.reset.world.generate" | "selectWorld.gameMode.creative" | "advancements.husbandry.tactical_fishing.description" | "block.minecraft.banner.straight_cross.gray" | "color.minecraft.orange" | "commands.op.success" | "item.irons_spellbooks.casters_tea.desc" | "ui.irons_spellbooks.fang_count" | "gui.chatSelection.title" | "forge.configgui.forgeLightPipelineEnabled" | "ui.irons_spellbooks.hp" | "forge.configgui.zoomInMissingModelTextInGui.tooltip" | "block.minecraft.banner.half_vertical.red" | "parsing.float.invalid" | "advMode.allPlayers" | "block.minecraft.banner.stripe_right.orange" | "effect.irons_spellbooks.summon_horse_timer.description" | "block.minecraft.cherry_sapling" | "subtitles.entity.ender_dragon.ambient" | "block.minecraft.glowstone" | "mco.download.confirmation.line1" | "item.irons_spellbooks.mana_upgrade_orb" | "mco.download.confirmation.line2" | "patchouli.gui.lexicon.editor.info" | "modernfix.option.mixin.launch.class_search_cache" | "block.minecraft.potted_cornflower" | "subtitles.item.axe.wax_off" | "enchantment.improved_exp.heavyweight.desc" | "multiplayer.lan.server_found" | "subtitles.entity.spider.hurt" | "entity.minecraft.marker" | "subtitles.entity.piglin_brute.death" | "advancements.nether.use_lodestone.title" | "block.minecraft.oxeye_daisy" | "subtitles.entity.player.attack.strong" | "subtitles.entity.witch.ambient" | "tooltip.irons_spellbooks.spell_title" | "spell.irons_spellbooks.gust.guide" | "subtitles.block.pointed_dripstone.drip_lava_into_cauldron" | "block.minecraft.granite" | "book.invalid.tag" | "item.irons_spellbooks.blood_staff" | "enchantment.minecraft.fire_protection.desc" | "block.minecraft.sculk_shrieker" | "commands.deop.failed" | "block.minecraft.banner.circle.gray" | "block.minecraft.banner.diagonal_up_left.gray" | "spell.irons_spellbooks.starfall.guide" | "argument.block.property.unknown" | "key.keyboard.apostrophe" | "stat.minecraft.deaths" | "block.minecraft.banner.triangle_top.magenta" | "narrator.screen.title" | "modernfix.option.mixin.perf.use_integrated_resources.jepb" | "item.minecraft.arms_up_pottery_sherd" | "subtitles.entity.lightning_bolt.impact" | "enchantment.improved_exp.woodcutter.desc" | "subtitles.entity.sheep.death" | "commands.recipe.take.success.multiple" | "subtitles.ui.stonecutter.take_result" | "death.attack.irons_spellbooks.fang_strike" | "block.minecraft.pink_wool" | "multiplayer.status.ping.narration" | "curios.modifiers.body" | "tutorial.move.title" | "gui.jade.search" | "block.minecraft.banner.skull.cyan" | "fml.menu.notification.title" | "structure_block.hover.corner" | "patchouli.gui.lexicon.seconds" | "advancements.husbandry.root.title" | "item.minecraft.plenty_pottery_shard" | "effect.irons_spellbooks.charged.description" | "jade.fraction" | "painting.minecraft.alban.author" | "block.minecraft.green_stained_glass_pane" | "item.minecraft.wooden_axe" | "block.minecraft.cobblestone_wall" | "optimizeWorld.title" | "item.irons_spellbooks.keeper_spawn_egg" | "subtitles.block.campfire.crackle" | "item.minecraft.cyan_dye" | "jade.instrument.custom_head" | "commands.irons_spellbooks.generate_mod_list.success" | "advancements.irons_spellbooks.spell_book_dragon.description" | "commands.gamerule.set" | "block.minecraft.banner.stripe_bottom.orange" | "config.jade.plugin_minecraft.brewing_stand" | "title.singleplayer" | "item.geckolib.wolf_armor_helmet" | "block.minecraft.banner.diagonal_right.black" | "block.minecraft.banner.stripe_downleft.white" | "tetra.material.irons_spellbooks_frozen_bone.prefix" | "subtitles.entity.vex.ambient" | "spell.irons_spellbooks.ascension" | "block.minecraft.tall_grass" | "commands.advancement.grant.criterion.to.many.success" | "advancements.adventure.adventuring_time.description" | "block.minecraft.potted_dark_oak_sapling" | "entity.minecraft.villager.fisherman" | "mco.configure.world.buttons.players" | "text.cloth-config.save_and_done" | "mco.brokenworld.message.line2" | "mco.brokenworld.message.line1" | "spell.irons_spellbooks.fireball.guide" | "advancements.adventure.spyglass_at_ghast.title" | "item.minecraft.sweet_berries" | "effect.minecraft.water_breathing" | "item.minecraft.glowstone_dust" | "enchantment.dungeonsenchantments.fuse_shot.desc" | "trim_material.minecraft.netherite" | "item.minecraft.flint_and_steel" | "gui.jade.plugin_settings" | "death.attack.irons_spellbooks.magma_bomb.item" | "item.minecraft.cherry_chest_boat" | "resourcePack.high_contrast.name" | "block.minecraft.banner.half_horizontal.cyan" | "generator.customized" | "item.minecraft.firework_star.yellow" | "commands.recipe.give.failed" | "stat_type.minecraft.used" | "item.irons_spellbooks.ender_rune" | "enchantment.improved_exp.detection.desc" | "block.minecraft.banner.square_top_left.brown" | "block.minecraft.red_concrete_powder" | "item.minecraft.firework_star.blue" | "key.attack" | "block.minecraft.banner.stripe_top.lime" | "block.minecraft.banner.skull.light_gray" | "block.minecraft.spore_blossom" | "entity.minecraft.zombie" | "block.minecraft.birch_hanging_sign" | "controls.keybinds.duplicateKeybinds" | "block.minecraft.detector_rail" | "effect.irons_spellbooks.chilled" | "block.minecraft.damaged_anvil" | "block.minecraft.green_glazed_terracotta" | "gui.banned.reason.drugs" | "fml.menu.mods.info.trust.noauthority" | "item.minecraft.music_disc_ward.desc" | "subtitles.entity.mule.angry" | "block.minecraft.light_gray_glazed_terracotta" | "commands.forceload.added.multiple" | "pack.nameAndSource" | "text.cloth-config.error.not_valid_number_float" | "subtitles.entity.ender_dragon.hurt" | "commands.curios.remove.success" | "block.minecraft.banner.square_bottom_left.orange" | "selectWorld.gameRules" | "options.fovEffectScale" | "sodium.console.pojav_launcher" | "options.chat.title" | "subtitles.entity.ender_dragon.shoot" | "death.fell.finish" | "pack.incompatible.new" | "subtitles.entity.zoglin.hurt" | "block.minecraft.stripped_spruce_log" | "block.minecraft.banner.triangles_top.cyan" | "pack.source.world" | "block.minecraft.lime_concrete" | "subtitles.entity.turtle.lay_egg" | "biome.minecraft.warm_ocean" | "gamerule.snowAccumulationHeight.description" | "death.attack.irons_spellbooks.icicle" | "subtitles.entity.warden.nearby_closest" | "item.apotheosis.gem.irons_spellbooks:intelligent" | "block.minecraft.waxed_weathered_cut_copper" | "subtitles.chiseled_bookshelf.insert" | "item.irons_spellbooks.lightning_bottle" | "item.minecraft.shield.purple" | "block.minecraft.deepslate_iron_ore" | "curios.modifiers.hands" | "death.attack.badRespawnPoint.message" | "key.keyboard.keypad.0" | "key.keyboard.keypad.1" | "container.upgrade.missing_template_tooltip" | "tooltip.titanium.redstone.redstone" | "spell.irons_spellbooks.wololo" | "block.minecraft.banner.diagonal_right.green" | "patchouli.gui.lexicon.edition_str" | "item.irons_spellbooks.hither_thither_wand" | "key.keyboard.keypad.2" | "subtitles.entity.donkey.hurt" | "key.keyboard.keypad.3" | "key.keyboard.keypad.4" | "key.keyboard.keypad.5" | "key.keyboard.keypad.6" | "key.keyboard.keypad.7" | "itemGroup.geckolib.geckolib_examples" | "key.keyboard.keypad.8" | "stat.minecraft.target_hit" | "key.keyboard.keypad.9" | "modernfix.config.not_default" | "tooltip.irons_spellbooks.press_to_cast" | "commands.data.modify.expected_object" | "stat.minecraft.interact_with_anvil" | "tooltip.irons_spellbooks.cast_long" | "options.graphics.warning.title" | "block.minecraft.banner.stripe_top.blue" | "item.irons_spellbooks.artificer_cane" | "argument.entity.options.level.negative" | "block.minecraft.spruce_log" | "item.minecraft.ink_sac" | "subtitles.entity.salmon.death" | "item.minecraft.gold_ingot" | "stat.minecraft.tune_noteblock" | "subtitles.entity.wither_skeleton.death" | "ui.irons_spellbooks.impact_damage" | "block.minecraft.respawn_anchor" | "enchantment.create_sa.impact.desc" | "item.minecraft.piglin_brute_spawn_egg" | "commands.title.cleared.single" | "advancements.nether.ride_strider.title" | "commands.forceload.list.single" | "block.minecraft.brain_coral" | "commands.config.noconfig" | "config.jade.display_mode_toggle" | "ui.irons_spellbooks.mana_cost" | "effect.irons_spellbooks.blood_slashed" | "argument.nbt.array.invalid" | "options.graphics.warning.renderer" | "block.minecraft.banner.half_horizontal.magenta" | "item.minecraft.cooked_mutton" | "config.jade.plugin_minecraft.chiseled_bookshelf" | "selectWorld.world" | "block.minecraft.banner.square_bottom_left.brown" | "gui.acknowledge" | "block.minecraft.banner.rhombus.magenta" | "block.minecraft.banner.stripe_middle.pink" | "key.jei.toggleHideIngredient" | "createWorld.customize.custom.count" | "subtitles.entity.parrot.imitate.endermite" | "block.minecraft.banner.stripe_center.lime" | "patchouli.gui.lexicon.button.toggle_mock_header" | "block.minecraft.dead_bubble_coral_fan" | "config.jade.hide_from_debug_desc" | "item.irons_spellbooks.netherite_mage_boots" | "selectWorld.edit.backupFolder" | "subtitles.item.trident.throw" | "death.attack.fireworks.player" | "jade.fe" | "affix.irons_spellbooks:spellbook/attribute/ender_spell_power" | "gui.jei.editMode.description.hide" | "subtitles.entity.parrot.imitate.pillager" | "death.attack.irons_spellbooks.ascension" | "gui.abuseReport.send.json_error" | "item.minecraft.shelter_pottery_shard" | "effect.irons_spellbooks.guided" | "block.minecraft.beacon.secondary" | "block.minecraft.water_cauldron" | "item.minecraft.splash_potion.effect.strength" | "tooltip.irons_spellbooks.press_to_cast_active" | "tetra.material.irons_spellbooks_fire_rune_socket.prefix" | "effect.minecraft.night_vision" | "curios.modifiers.slots.take.2" | "affix.irons_spellbooks:spellbook/attribute/cast_time_reduction" | "subtitles.entity.fox.death" | "curios.modifiers.slots.take.1" | "enchantment.endlessbiomes.shared_pain" | "curios.modifiers.slots.take.0" | "container.enderchest" | "item.minecraft.purple_dye" | "irons_spellbooks.tetra_bar.ice_spell_power.tooltip" | "biome.minecraft.birch_forest" | "block.minecraft.banner.gradient.white" | "item.minecraft.pitcher_plant" | "fabric-registry-sync-v0.unknown-remote.title.plural" | "subtitles.block.grindstone.use" | "biome.minecraft.forest" | "gui.abuseReport.reason.self_harm_or_suicide.description" | "commands.scoreboard.objectives.modify.displayname" | "block.minecraft.water" | "subtitles.entity.boat.paddle_water" | "gui.banned.reason.harassment_or_bullying" | "selectWorld.deleteWarning" | "block.minecraft.green_carpet" | "team.collision.always" | "subtitles.entity.guardian.ambient_land" | "mco.configure.world.delete.button" | "telemetry.property.launcher_name.title" | "gamerule.sendCommandFeedback" | "block.minecraft.banner.triangle_top.purple" | "item.minecraft.lingering_potion.effect.slowness" | "mco.backup.unknown" | "multiplayer.disconnect.invalid_player_movement" | "advancements.end.respawn_dragon.description" | "block.minecraft.banner.stripe_bottom.magenta" | "subtitles.block.smithing_table.use" | "item.patchouli.comprehensive_test_book.landing" | "block.minecraft.sculk_vein" | "ui.irons_spellbooks.wandering_trader_scroll" | "command.unknown.command" | "item.irons_spellbooks.plagued_boots" | "advMode.previousOutput" | "stat.minecraft.enchant_item" | "block.minecraft.dark_oak_leaves" | "key.keyboard.unknown" | "irons_spellbooks.tetra_bar.cooldown_reduction.tooltip" | "item.minecraft.rabbit_spawn_egg" | "block.minecraft.green_stained_glass" | "mirror.front_back" | "block.minecraft.command_block" | "block.minecraft.banner.stripe_center.blue" | "advancements.nether.obtain_crying_obsidian.title" | "leaves_type.minecraft.jungle" | "mco.minigame.world.slot.screen.title" | "disconnect.overflow" | "options.directionalAudio.on.tooltip" | "death.attack.irons_spellbooks.divine_smite.item" | "block.minecraft.bed.no_sleep" | "death.attack.irons_spellbooks.starfall.item" | "affix.irons_spellbooks:spellbook/attribute/lightning_spell_power" | "fml.messages.artifactversion.ornotinstalled" | "commands.drop.success.multiple_with_table" | "message.moonlight.anti_repost_link" | "commands.worldborder.set.failed.small" | "item.minecraft.firework_star.lime" | "telemetry.event.game_load_times.description" | "subtitles.block.enchantment_table.use" | "subtitles.block.sculk.charge" | "patchouli.gui.lexicon.button.editor" | "subtitles.entity.glow_item_frame.add_item" | "block.minecraft.raw_iron_block" | "enchantment.minecraft.multishot" | "spell.irons_spellbooks.recall" | "painting.minecraft.donkey_kong.title" | "gui.abuseReport.send.service_unavailable" | "gamerule.reducedDebugInfo" | "key.keyboard.menu" | "entity.irons_spellbooks.citadel_keeper" | "advMode.notAllowed" | "symlink_warning.title" | "options.graphics.warning.message" | "forge.selectWorld.backupWarning.experimental.additional" | "tooltip.titanium.progressbar.progress" | "options.renderClouds" | "curios.modifiers.necklace" | "modernfix.option.mixin.perf.biome_zoomer" | "subtitles.entity.panda.cant_breed" | "entity.irons_spellbooks.wisp" | "item.minecraft.chainmail_boots" | "advancements.husbandry.obtain_sniffer_egg.title" | "createWorld.customize.custom.heightScale" | "structure_block.invalid_structure_name" | "text.bookshelf.ticks" | "affix.irons_spellbooks:spellbook/attribute/mana.suffix" | "config.jade.overlay_pos_y" | "death.attack.irons_spellbooks.stomp" | "config.jade.overlay_pos_x" | "block.minecraft.blue_glazed_terracotta" | "death.attack.lightningBolt" | "item.minecraft.snort_pottery_shard" | "telemetry.property.seconds_since_load.title" | "block.minecraft.cyan_stained_glass_pane" | "multiplayer.texturePrompt.line1" | "multiplayer.texturePrompt.line2" | "addServer.hideAddress" | "block.minecraft.banner.cross.yellow" | "block.minecraft.banner.triangle_bottom.gray" | "item.irons_spellbooks.greater_invisibility_elixir" | "biome.minecraft.windswept_savanna" | "block.minecraft.banner.stripe_center.light_gray" | "subtitles.entity.puffer_fish.sting" | "entity.irons_spellbooks.necromancer" | "createWorld.customize.custom.maxHeight" | "item.minecraft.splash_potion.effect.leaping" | "mco.minigame.world.restore" | "advancements.story.shiny_gear.title" | "structure_block.size.z" | "item.irons_spellbooks.pumpkin_chestplate" | "attribute.irons_spellbooks.ice_magic_resist" | "entity.irons_spellbooks.small_magic_arrow" | "structure_block.size.x" | "structure_block.size.y" | "config.jade.plugin_minecraft.player_head" | "entity.minecraft.glow_item_frame" | "config.jei.mode.comment" | "commands.forge.gen.dim_fail" | "biome.minecraft.end_highlands" | "gamerule.doMobLoot.description" | "mco.reset.world.title" | "telemetry.event.world_load_times.description" | "block.minecraft.banner.half_horizontal.red" | "key.keyboard.scroll.lock" | "block.minecraft.bamboo_fence_gate" | "enchantment.improved_exp.coldblooded.desc" | "entity.minecraft.wandering_trader" | "argument.entity.options.mode.invalid" | "spell.irons_spellbooks.ray_of_frost.guide" | "jadeaddons.deepresonance.collectors" | "modernfix.option.mixin.perf.dynamic_resources.supermartijncore" | "advancements.adventure.kill_all_mobs.description" | "effect.minecraft.fire_resistance" | "block.minecraft.ominous_banner" | "block.minecraft.white_concrete_powder" | "modernfix.option.mixin.perf.fast_forge_dummies" | "block.minecraft.banner.cross.pink" | "narration.edit_box" | "fml.button.open.mods.folder" | "fml.modloading.failedtoloadforge" | "block.minecraft.crimson_slab" | "jei.key.category.hover.config.button" | "commands.bossbar.get.value" | "commands.tag.list.multiple.success" | "selectWorld.recreate" | "item.minecraft.stone_pickaxe" | "fml.menu.multiplayer.vanilla" | "subtitles.entity.fox.screech" | "options.biomeBlendRadius.9" | "options.biomeBlendRadius.7" | "commands.mana.add.success.single" | "options.biomeBlendRadius.5" | "advancements.irons_spellbooks.spell_book_villager.description" | "options.biomeBlendRadius.3" | "commands.advancement.grant.one.to.one.failure" | "sodium.options.fullscreen.tooltip" | "options.biomeBlendRadius.1" | "spell.irons_spellbooks.frost_step" | "block.minecraft.cherry_wood" | "multiplayer.player.joined.renamed" | "item.irons_spellbooks.blaze_spell_book" | "effect.minecraft.slowness" | "fml.messages.version.restriction.bounded.inclusive" | "block.minecraft.potted_red_mushroom" | "trim_material.minecraft.iron" | "block.minecraft.banner.border.yellow" | "subtitles.entity.warden.listening" | "block.minecraft.banner.stripe_downright.black" | "block.minecraft.banner.stripe_downright.white" | "block.minecraft.banner.gradient.green" | "gamerule.commandBlockOutput" | "forge.configgui.disableVersionCheck.tooltip" | "selectServer.defaultName" | "gui.abuseReport.send.http_error" | "block.minecraft.banner.diagonal_up_right.light_gray" | "advancements.husbandry.tame_an_animal.title" | "telemetry.event.world_loaded.description" | "config.jade.display_mode_hold_key_desc" | "options.prioritizeChunkUpdates.byPlayer" | "item.minecraft.nether_wart" | "block.minecraft.banner.triangle_top.light_blue" | "death.attack.irons_spellbooks.cone_of_cold" | "item.minecraft.potion.effect.mana" | "gui.socialInteractions.tooltip.report.disabled" | "block.irons_spellbooks.inscription_table" | "block.minecraft.banner.stripe_middle.black" | "item.minecraft.spruce_chest_boat" | "item.irons_spellbooks.blank_rune" | "options.biomeBlendRadius" | "commands.give.failed.toomanyitems" | "fml.menu.mods.info.authors" | "config.jade.plugin_minecraft.note_block_desc" | "title.cloth-config.config" | "subtitles.entity.parrot.imitate.ravager" | "block.minecraft.powder_snow" | "options.guiScale" | "compliance.playtime.greaterThan24Hours" | "spell.irons_spellbooks.heat_surge" | "entity.minecraft.snowball" | "menu.savingLevel" | "jade.not_generated" | "biome.minecraft.deep_cold_ocean" | "death.attack.genericKill.player" | "block.minecraft.orange_bed" | "telemetry.event.performance_metrics.title" | "block.minecraft.jungle_stairs" | "enchantment.minecraft.smite" | "entity.minecraft.hopper_minecart" | "block.minecraft.bamboo_sign" | "block.minecraft.iron_block" | "advancements.adventure.root.description" | "gui.chatReport.draft.quittotitle.title" | "item.irons_spellbooks.energized_core" | "block.minecraft.banner.cross.brown" | "instrument.minecraft.call_goat_horn" | "subtitles.entity.drowned.ambient" | "wood_type.minecraft.jungle" | "gui.jade.by" | "trim_pattern.minecraft.raiser" | "block.minecraft.purple_concrete" | "subtitles.entity.item_frame.rotate_item" | "item.minecraft.shield.pink" | "gui.abuseReport.reason.terrorism_or_violent_extremism.description" | "irons_spellbooks.tetra_bar.fire_spell_power.tooltip" | "subtitles.block.furnace.fire_crackle" | "stat.minecraft.interact_with_furnace" | "advancements.adventure.sniper_duel.description" | "biome.minecraft.mushroom_fields" | "config.jade.plugin_minecraft.jukebox" | "attribute.irons_spellbooks.ender_spell_power" | "entity.irons_spellbooks.healing_aoe" | "block.minecraft.red_carpet" | "key.keyboard.f8" | "entity.irons_spellbooks.devour_jaw" | "key.keyboard.f9" | "curios.modifiers.bracelet" | "key.keyboard.f6" | "key.keyboard.f7" | "subtitles.entity.wandering_trader.disappeared" | "debug.inspect.help" | "key.keyboard.f1" | "options.fovEffectScale.tooltip" | "key.keyboard.f4" | "key.keyboard.f5" | "multiplayer.disconnect.invalid_vehicle_movement" | "key.keyboard.f2" | "key.keyboard.f3" | "mco.template.select.none.linkTitle" | "entity.tconstruct.efln_ball" | "block.minecraft.banner.curly_border.light_blue" | "advancements.story.smelt_iron.description" | "chat_screen.message" | "subtitles.block.redstone_torch.burnout" | "item.irons_spellbooks.spellbreaker" | "entity.minecraft.villager.nitwit" | "command.expected.separator" | "block.minecraft.oak_fence_gate" | "spell.irons_spellbooks.telekinesis.guide" | "subtitles.entity.horse.gallop" | "gamerule.category.misc" | "commands.locate.biome.success" | "jei.tooltip.recipe.tag" | "block.minecraft.banner.creeper.gray" | "subtitles.item.book.page_turn" | "painting.minecraft.wanderer.author" | "block.minecraft.cyan_bed" | "subtitles.item.bone_meal.use" | "enchantment.improved_exp.gravity.desc" | "item.minecraft.golden_chestplate" | "item.minecraft.rabbit_foot" | "entity.minecraft.villager.cleric" | "gamerule.doPatrolSpawning" | "block.minecraft.banner.stripe_middle.light_blue" | "jigsaw_block.target" | "block.minecraft.banner.stripe_downright.green" | "subtitles.entity.horse.hurt" | "stat.minecraft.interact_with_grindstone" | "biome.minecraft.old_growth_birch_forest" | "block.minecraft.player_wall_head" | "death.attack.irons_spellbooks.earthquake.item" | "optimizeWorld.info.converted" | "argument.enum.invalid" | "item.minecraft.miner_pottery_sherd" | "block.minecraft.brown_glazed_terracotta" | "enchdesc.activate.message" | "attribute.irons_spellbooks.summon_damage" | "options.modelPart.left_pants_leg" | "text.cloth-config.error.color.invalid_blue" | "mco.reset.world.template" | "enchantment.improved_exp.explosive.desc" | "effect.minecraft.resistance" | "jade.mobbreeding.time" | "arguments.function.unknown" | "subtitles.entity.zombie_villager.hurt" | "entity.irons_spellbooks.summoned_vex" | "effect.irons_spellbooks.airborne.description" | "block.minecraft.cave_vines" | "container.enchant" | "item.minecraft.frog_spawn_egg" | "jei.tooltip.bookmarks.recipe" | "commands.bossbar.set.visible.success.hidden" | "itemGroup.irons_spellbooks.spell_equipment_tab" | "item.irons_spellbooks.lightning_rod.guide" | "enchantment.grapplemod.wallrunenchantment.desc" | "stat.minecraft.interact_with_smoker" | "ui.irons_spellbooks.additional_poisoned_damage" | "config.jade.hide_from_tab_list_desc" | "createWorld.customize.flat.title" | "telemetry.property.load_time_bootstrap_ms.title" | "item.minecraft.lingering_potion.effect.awkward" | "enchantment.shieldsplus.ablaze.desc" | "block.minecraft.waxed_weathered_copper" | "config.jade.plugin_minecraft.entity_armor.max_for_render" | "argument.player.unknown" | "block.minecraft.mangrove_trapdoor" | "key.jei.previousRecipePage" | "mco.minigame.world.selected" | "item.minecraft.sniffer_spawn_egg" | "block.minecraft.banner.half_horizontal_bottom.purple" | "block.minecraft.fletching_table" | "tooltip.titanium.facing_handler.enabled" | "block.minecraft.banner.stripe_downleft.gray" | "argument.range.swapped" | "commands.setblock.success" | "item.minecraft.leather_chestplate" | "config.jade.plugin_minecraft.armor_stand" | "item.minecraft.chicken_spawn_egg" | "item.minecraft.porkchop" | "attribute.irons_spellbooks.evocation_magic_resist" | "entity.irons_spellbooks.fire_field" | "leaves_type.twilightforest.dark" | "key.irons_spellbooks.spell_wheel" | "attribute.modifier.take.1" | "attribute.modifier.take.0" | "fml.messages.artifactversion.none" | "jei.tooltip.bookmarks.tooltips.usage" | "selectWorld.gameMode.survival.info" | "item.irons_spellbooks.scroll_pouch" | "item.minecraft.flower_banner_pattern.desc" | "block.minecraft.granite_slab" | "argument.entity.options.x.description" | "ui.irons_spellbooks.no_spell_book" | "config.jei.advanced" | "modernfix.option.mixin.perf.dynamic_resources" | "subtitles.entity.skeleton.shoot" | "chat.coordinates.tooltip" | "argument.pos2d.incomplete" | "modernfix.option.mixin.perf.async_locator" | "patchouli.gui.lexicon.categories" | "block.minecraft.banner.triangles_bottom.red" | "item.minecraft.beef" | "attribute.modifier.take.2" | "block.minecraft.fern" | "entity.irons_spellbooks.dragon_breath_pool" | "item.minecraft.rotten_flesh" | "stat.minecraft.sleep_in_bed" | "spell.irons_spellbooks.poison_splash.guide" | "block.minecraft.banner.border.cyan" | "credits_and_attribution.screen.title" | "item.minecraft.brewing_stand" | "subtitles.entity.fox.ambient" | "subtitles.entity.generic.drink" | "subtitles.entity.tadpole.hurt" | "commands.advancement.revoke.many.to.one.success" | "item.minecraft.potion" | "mco.info" | "embeddium.options.fullscreen.resolution.tooltip" | "death.attack.irons_spellbooks.poison_splash" | "gamerule.category.player" | "block.minecraft.blue_wool" | "block.minecraft.fire_coral" | "advancements.husbandry.ride_a_boat_with_a_goat.description" | "jade.theme.jade.top" | "item.irons_spellbooks.archevoker_helmet" | "modernfix.option.mixin.bugfix.preserve_early_window_pos" | "jade.llamaStrength" | "entity.minecraft.wolf" | "config.jade.plugin_jadeaddons.equipment_requirement"
    type LootTable = "minecraft:blocks/nether_wart_block" | "minecraft:blocks/orange_wool" | "minecraft:entities/silverfish" | "minecraft:gameplay/hero_of_the_village/fisherman_gift" | "minecraft:blocks/chiseled_stone_bricks" | "minecraft:blocks/deepslate_bricks" | "minecraft:chests/ancient_city_ice_box" | "minecraft:blocks/bee_nest" | "minecraft:blocks/damaged_anvil" | "minecraft:chests/simple_dungeon" | "minecraft:entities/vex" | "minecraft:blocks/crimson_slab" | "minecraft:blocks/light_gray_shulker_box" | "minecraft:entities/warden" | "minecraft:blocks/detector_rail" | "minecraft:blocks/dark_oak_hanging_sign" | "minecraft:blocks/potted_bamboo" | "irons_spellbooks:chests/pyromancer_tower/burnt_chest" | "minecraft:blocks/stripped_warped_hyphae" | "irons_spellbooks:entities/archevoker" | "minecraft:archaeology/trail_ruins_common" | "minecraft:blocks/infested_cracked_stone_bricks" | "minecraft:blocks/polished_blackstone_button" | "minecraft:blocks/dark_oak_leaves" | "minecraft:chests/village/village_mason" | "minecraft:entities/slime" | "minecraft:blocks/dead_bubble_coral_block" | "minecraft:entities/ghast" | "minecraft:blocks/azalea" | "minecraft:entities/zombie" | "minecraft:blocks/sandstone_stairs" | "minecraft:entities/tadpole" | "irons_spellbooks:chests/pyromancer_tower/fire_ale_trove" | "irons_spellbooks:chests/magic_bookshelf_loot" | "minecraft:blocks/decorated_pot" | "minecraft:blocks/end_rod" | "minecraft:blocks/oxeye_daisy" | "minecraft:blocks/small_dripleaf" | "minecraft:chests/village/village_temple" | "minecraft:entities/cat" | "minecraft:blocks/sandstone" | "minecraft:blocks/medium_amethyst_bud" | "minecraft:blocks/potted_flowering_azalea_bush" | "minecraft:blocks/lever" | "minecraft:blocks/stone_button" | "minecraft:blocks/yellow_stained_glass" | "irons_spellbooks:chests/impaled_icebreaker/captain_quarters" | "minecraft:gameplay/hero_of_the_village/farmer_gift" | "minecraft:blocks/polished_granite" | "minecraft:blocks/warped_hanging_sign" | "irons_spellbooks:ring_gen_all_schools" | "minecraft:blocks/acacia_stairs" | "minecraft:blocks/brown_stained_glass" | "minecraft:blocks/torch" | "minecraft:blocks/lantern" | "minecraft:blocks/lime_concrete" | "minecraft:blocks/potted_warped_roots" | "minecraft:blocks/gray_terracotta" | "minecraft:entities/illusioner" | "minecraft:blocks/glowstone" | "minecraft:blocks/orange_glazed_terracotta" | "minecraft:blocks/deepslate_lapis_ore" | "minecraft:blocks/kelp_plant" | "minecraft:blocks/warped_roots" | "minecraft:blocks/nether_sprouts" | "minecraft:blocks/mangrove_leaves" | "minecraft:blocks/cherry_wood" | "minecraft:blocks/spruce_fence" | "minecraft:blocks/blue_concrete" | "minecraft:blocks/spore_blossom" | "minecraft:blocks/diamond_block" | "minecraft:blocks/potted_cactus" | "minecraft:blocks/dead_fire_coral" | "minecraft:blocks/spruce_stairs" | "minecraft:blocks/black_candle" | "minecraft:blocks/magenta_shulker_box" | "minecraft:blocks/warped_fence_gate" | "minecraft:blocks/crimson_button" | "minecraft:blocks/sugar_cane" | "minecraft:blocks/oak_planks" | "titanium:blocks/titanium_block_test" | "minecraft:blocks/tube_coral_block" | "minecraft:chests/bastion_treasure" | "minecraft:blocks/pumpkin" | "minecraft:blocks/verdant_froglight" | "minecraft:chests/ruined_portal" | "minecraft:blocks/green_concrete" | "minecraft:blocks/dead_fire_coral_fan" | "minecraft:blocks/acacia_wood" | "minecraft:blocks/quartz_bricks" | "minecraft:blocks/coal_block" | "minecraft:entities/sheep/magenta" | "minecraft:blocks/light_blue_bed" | "minecraft:blocks/jungle_hanging_sign" | "minecraft:blocks/dark_oak_sign" | "minecraft:blocks/raw_copper_block" | "minecraft:blocks/deepslate_brick_slab" | "minecraft:blocks/warped_sign" | "minecraft:blocks/cauldron" | "minecraft:blocks/weathered_cut_copper" | "minecraft:blocks/black_wool" | "minecraft:blocks/birch_stairs" | "minecraft:blocks/lily_of_the_valley" | "minecraft:blocks/powered_rail" | "minecraft:blocks/mud_bricks" | "minecraft:blocks/pumpkin_stem" | "minecraft:blocks/jungle_sign" | "minecraft:blocks/jungle_log" | "minecraft:blocks/frogspawn" | "minecraft:blocks/brick_stairs" | "minecraft:blocks/black_glazed_terracotta" | "minecraft:chests/village/village_fisher" | "minecraft:chests/village/village_toolsmith" | "minecraft:blocks/jungle_button" | "minecraft:blocks/white_concrete_powder" | "minecraft:blocks/sand" | "minecraft:blocks/pink_wool" | "minecraft:blocks/white_concrete" | "minecraft:blocks/polished_diorite" | "minecraft:blocks/nether_brick_slab" | "minecraft:blocks/gilded_blackstone" | "irons_spellbooks:chests/generic_magic_treasure" | "minecraft:blocks/cornflower" | "minecraft:blocks/seagrass" | "minecraft:blocks/sculk" | "minecraft:blocks/brown_mushroom" | "minecraft:blocks/pink_bed" | "minecraft:entities/sheep/black" | "minecraft:blocks/cherry_sapling" | "minecraft:chests/shipwreck_map" | "minecraft:blocks/purpur_block" | "minecraft:blocks/pink_candle_cake" | "minecraft:blocks/orange_carpet" | "minecraft:blocks/polished_diorite_stairs" | "minecraft:blocks/redstone_wire" | "minecraft:entities/magma_cube" | "minecraft:gameplay/hero_of_the_village/mason_gift" | "minecraft:blocks/waxed_exposed_cut_copper_slab" | "minecraft:blocks/lightning_rod" | "minecraft:blocks/suspicious_sand" | "minecraft:blocks/spruce_sapling" | "minecraft:entities/mule" | "minecraft:blocks/bamboo_slab" | "minecraft:blocks/purple_candle_cake" | "minecraft:blocks/spruce_fence_gate" | "minecraft:blocks/end_stone" | "minecraft:blocks/blue_shulker_box" | "minecraft:blocks/mossy_stone_bricks" | "minecraft:entities/camel" | "irons_spellbooks:blocks/inscription_table" | "minecraft:blocks/stripped_oak_wood" | "minecraft:blocks/yellow_bed" | "minecraft:blocks/acacia_hanging_sign" | "minecraft:blocks/gray_concrete_powder" | "minecraft:blocks/jungle_fence_gate" | "minecraft:blocks/smooth_stone" | "minecraft:chests/shipwreck_supply" | "minecraft:blocks/cyan_glazed_terracotta" | "minecraft:blocks/stripped_birch_log" | "minecraft:blocks/twisting_vines" | "irons_spellbooks:entities/cultist" | "minecraft:entities/hoglin" | "minecraft:blocks/spawner" | "minecraft:blocks/piston" | "minecraft:blocks/waxed_copper_block" | "irons_spellbooks:magic_items/all_focuses" | "minecraft:blocks/ender_chest" | "irons_spellbooks:chests/catacombs/crypt_loot" | "minecraft:entities/witch" | "minecraft:blocks/hopper" | "minecraft:blocks/dark_prismarine_stairs" | "minecraft:blocks/polished_basalt" | "minecraft:blocks/polished_granite_stairs" | "minecraft:blocks/big_dripleaf" | "minecraft:entities/skeleton_horse" | "minecraft:blocks/andesite" | "minecraft:blocks/mangrove_slab" | "minecraft:blocks/oak_fence_gate" | "irons_spellbooks:magic_items/good_ink" | "minecraft:blocks/acacia_slab" | "minecraft:blocks/light_blue_concrete" | "minecraft:blocks/enchanting_table" | "minecraft:blocks/smithing_table" | "minecraft:blocks/polished_blackstone_bricks" | "minecraft:blocks/gold_block" | "minecraft:blocks/note_block" | "minecraft:blocks/light_blue_candle" | "irons_spellbooks:entities/necromancer" | "minecraft:gameplay/hero_of_the_village/leatherworker_gift" | "minecraft:blocks/dead_tube_coral_fan" | "minecraft:blocks/magenta_banner" | "minecraft:blocks/potted_red_mushroom" | "minecraft:blocks/jungle_leaves" | "minecraft:blocks/iron_block" | "minecraft:blocks/birch_wood" | "minecraft:blocks/blue_bed" | "minecraft:blocks/copper_block" | "minecraft:entities/sheep/lime" | "minecraft:blocks/mangrove_hanging_sign" | "minecraft:blocks/dead_bubble_coral_fan" | "minecraft:blocks/brown_stained_glass_pane" | "irons_spellbooks:blocks/pedestal" | "minecraft:blocks/smooth_quartz" | "minecraft:blocks/oak_slab" | "minecraft:entities/zombified_piglin" | "minecraft:blocks/black_shulker_box" | "minecraft:blocks/waxed_exposed_cut_copper_stairs" | "minecraft:blocks/acacia_fence_gate" | "minecraft:blocks/petrified_oak_slab" | "minecraft:blocks/waxed_oxidized_cut_copper_slab" | "minecraft:blocks/flower_pot" | "minecraft:blocks/light_blue_stained_glass_pane" | "minecraft:chests/village/village_snowy_house" | "minecraft:entities/chicken" | "minecraft:blocks/red_bed" | "minecraft:blocks/mangrove_pressure_plate" | "minecraft:blocks/soul_torch" | "minecraft:blocks/bamboo_sapling" | "minecraft:blocks/twisting_vines_plant" | "minecraft:blocks/white_bed" | "minecraft:blocks/stone_bricks" | "minecraft:blocks/tripwire_hook" | "minecraft:blocks/cherry_fence" | "minecraft:blocks/crimson_stem" | "irons_spellbooks:chests/pyromancer_tower/pyromancer_basic_storage" | "minecraft:blocks/chipped_anvil" | "irons_spellbooks:ring_gen_break_me" | "minecraft:blocks/frosted_ice" | "minecraft:blocks/light_blue_terracotta" | "minecraft:entities/skeleton" | "minecraft:blocks/exposed_cut_copper_slab" | "irons_spellbooks:blocks/arcane_debris" | "minecraft:entities/enderman" | "minecraft:blocks/cyan_carpet" | "minecraft:blocks/flowering_azalea" | "minecraft:blocks/mangrove_stairs" | "minecraft:blocks/birch_leaves" | "minecraft:blocks/jungle_wood" | "minecraft:entities/shulker" | "minecraft:blocks/infested_stone" | "minecraft:blocks/cyan_concrete" | "minecraft:blocks/waxed_weathered_cut_copper" | "minecraft:blocks/cut_red_sandstone" | "minecraft:blocks/redstone_lamp" | "minecraft:blocks/tinted_glass" | "minecraft:blocks/torchflower" | "minecraft:entities/snow_golem" | "irons_spellbooks:scroll_gen_fire" | "minecraft:blocks/light_blue_candle_cake" | "minecraft:blocks/grass_block" | "minecraft:blocks/brown_candle_cake" | "minecraft:blocks/andesite_stairs" | "minecraft:blocks/dead_brain_coral_block" | "minecraft:blocks/allium" | "minecraft:entities/sheep/blue" | "minecraft:blocks/creeper_head" | "minecraft:blocks/mangrove_propagule" | "minecraft:chests/stronghold_crossing" | "minecraft:blocks/polished_andesite_stairs" | "minecraft:blocks/birch_sign" | "minecraft:blocks/lime_candle_cake" | "minecraft:blocks/sea_lantern" | "minecraft:blocks/waxed_oxidized_cut_copper" | "minecraft:blocks/birch_hanging_sign" | "minecraft:blocks/blast_furnace" | "irons_spellbooks:blocks/scroll_forge" | "minecraft:blocks/lime_bed" | "minecraft:blocks/potted_fern" | "minecraft:blocks/green_stained_glass" | "minecraft:blocks/oak_sapling" | "minecraft:blocks/brick_slab" | "minecraft:blocks/prismarine" | "minecraft:entities/ender_dragon" | "minecraft:blocks/fern" | "minecraft:blocks/acacia_log" | "minecraft:blocks/quartz_stairs" | "minecraft:blocks/light_blue_stained_glass" | "minecraft:blocks/purple_terracotta" | "minecraft:blocks/red_terracotta" | "minecraft:archaeology/ocean_ruin_warm" | "irons_spellbooks:chests/catacombs/hidden_trough_treasure" | "minecraft:blocks/soul_campfire" | "minecraft:blocks/red_glazed_terracotta" | "irons_spellbooks:blocks/armor_pile" | "irons_spellbooks:magic_items/random_potion" | "minecraft:blocks/infested_mossy_stone_bricks" | "minecraft:blocks/exposed_cut_copper" | "minecraft:entities/ravager" | "minecraft:blocks/yellow_wool" | "minecraft:blocks/mangrove_button" | "minecraft:blocks/potted_jungle_sapling" | "minecraft:blocks/cyan_bed" | "minecraft:blocks/warped_stem" | "minecraft:blocks/black_concrete_powder" | "minecraft:blocks/orange_stained_glass_pane" | "minecraft:blocks/infested_deepslate" | "minecraft:blocks/soul_fire" | "minecraft:blocks/cave_vines_plant" | "minecraft:blocks/cherry_hanging_sign" | "minecraft:blocks/magenta_concrete_powder" | "minecraft:blocks/tuff" | "minecraft:blocks/end_stone_brick_stairs" | "minecraft:blocks/exposed_copper" | "minecraft:blocks/crimson_stairs" | "minecraft:entities/llama" | "minecraft:blocks/orange_shulker_box" | "minecraft:blocks/polished_deepslate" | "minecraft:blocks/deepslate_brick_wall" | "minecraft:blocks/stripped_crimson_stem" | "irons_spellbooks:blocks/alchemist_cauldron" | "minecraft:blocks/comparator" | "irons_spellbooks:chests/mangrove_hut" | "minecraft:entities/sheep/brown" | "minecraft:blocks/dark_oak_log" | "minecraft:blocks/oxidized_copper" | "irons_spellbooks:chests/pyromancer_tower/fire_ale_cask" | "minecraft:blocks/acacia_trapdoor" | "minecraft:blocks/cyan_terracotta" | "minecraft:blocks/lime_stained_glass_pane" | "minecraft:chests/nether_bridge" | "minecraft:blocks/polished_blackstone_stairs" | "minecraft:blocks/dark_oak_sapling" | "minecraft:blocks/dark_prismarine_slab" | "minecraft:blocks/blue_orchid" | "minecraft:blocks/stone_brick_slab" | "minecraft:blocks/composter" | "minecraft:blocks/lime_banner" | "minecraft:blocks/waxed_oxidized_cut_copper_stairs" | "minecraft:blocks/cyan_stained_glass_pane" | "minecraft:entities/horse" | "minecraft:blocks/birch_button" | "minecraft:blocks/purpur_stairs" | "minecraft:chests/abandoned_mineshaft" | "minecraft:blocks/ancient_debris" | "minecraft:gameplay/hero_of_the_village/armorer_gift" | "irons_spellbooks:magic_items/poor_ink" | "minecraft:blocks/cobbled_deepslate_slab" | "minecraft:blocks/azalea_leaves" | "minecraft:blocks/cocoa" | "minecraft:entities/player" | "minecraft:blocks/magenta_terracotta" | "minecraft:chests/shipwreck_treasure" | "minecraft:blocks/red_sandstone_wall" | "minecraft:blocks/stripped_spruce_log" | "minecraft:blocks/moss_block" | "minecraft:blocks/gray_concrete" | "minecraft:blocks/iron_door" | "minecraft:blocks/sniffer_egg" | "minecraft:blocks/mangrove_log" | "minecraft:blocks/stripped_mangrove_wood" | "irons_spellbooks:entities/additional_stray_loot" | "minecraft:blocks/iron_ore" | "minecraft:blocks/pearlescent_froglight" | "minecraft:blocks/cobbled_deepslate_stairs" | "minecraft:blocks/deepslate_tile_stairs" | "irons_spellbooks:chests/wheat" | "minecraft:blocks/deepslate_redstone_ore" | "minecraft:blocks/yellow_terracotta" | "minecraft:blocks/light_gray_stained_glass_pane" | "minecraft:blocks/nether_wart" | "minecraft:blocks/dripstone_block" | "minecraft:blocks/warped_pressure_plate" | "minecraft:blocks/mud" | "minecraft:entities/cod" | "minecraft:blocks/yellow_concrete_powder" | "minecraft:blocks/waxed_weathered_cut_copper_slab" | "minecraft:blocks/tube_coral" | "minecraft:blocks/red_concrete_powder" | "minecraft:entities/mooshroom" | "minecraft:blocks/acacia_button" | "minecraft:blocks/bamboo_sign" | "minecraft:blocks/cut_copper" | "minecraft:blocks/bamboo_planks" | "minecraft:blocks/orange_concrete_powder" | "minecraft:blocks/oxidized_cut_copper" | "minecraft:blocks/pitcher_crop" | "minecraft:blocks/purple_candle" | "minecraft:entities/cow" | "minecraft:blocks/carrots" | "minecraft:blocks/green_glazed_terracotta" | "minecraft:entities/pig" | "minecraft:blocks/pink_terracotta" | "minecraft:blocks/yellow_candle" | "minecraft:blocks/oak_pressure_plate" | "minecraft:blocks/polished_blackstone_wall" | "minecraft:blocks/smooth_basalt" | "minecraft:blocks/jungle_fence" | "minecraft:blocks/sandstone_slab" | "minecraft:blocks/calibrated_sculk_sensor" | "minecraft:blocks/dark_oak_door" | "minecraft:blocks/lime_glazed_terracotta" | "minecraft:blocks/potted_cherry_sapling" | "minecraft:blocks/blue_terracotta" | "minecraft:chests/stronghold_corridor" | "minecraft:blocks/barrel" | "minecraft:blocks/brown_mushroom_block" | "minecraft:blocks/purple_stained_glass_pane" | "minecraft:blocks/black_terracotta" | "minecraft:blocks/rooted_dirt" | "minecraft:blocks/fire_coral" | "minecraft:blocks/smooth_sandstone_slab" | "irons_spellbooks:magic_items/basic_curios" | "minecraft:blocks/polished_granite_slab" | "minecraft:blocks/cyan_banner" | "minecraft:blocks/cherry_button" | "minecraft:blocks/repeater" | "irons_spellbooks:chests/pyromancer_tower/old_cask" | "minecraft:blocks/potted_brown_mushroom" | "minecraft:blocks/loom" | "minecraft:blocks/cyan_shulker_box" | "minecraft:blocks/prismarine_bricks" | "minecraft:blocks/cyan_wool" | "minecraft:blocks/warped_door" | "minecraft:blocks/acacia_sapling" | "irons_spellbooks:chests/battleground/burial_loot" | "minecraft:blocks/weathered_copper" | "minecraft:entities/donkey" | "minecraft:blocks/nether_brick_stairs" | "minecraft:blocks/jungle_stairs" | "minecraft:blocks/dark_oak_fence_gate" | "irons_spellbooks:chests/additional_ancient_city_loot" | "minecraft:blocks/smooth_stone_slab" | "minecraft:blocks/bamboo_mosaic_slab" | "minecraft:blocks/brain_coral" | "minecraft:blocks/dead_bubble_coral" | "minecraft:blocks/crimson_fence_gate" | "minecraft:blocks/fire" | "minecraft:blocks/smooth_sandstone_stairs" | "minecraft:entities/goat" | "irons_spellbooks:chests/evoker_fort" | "minecraft:entities/sheep/yellow" | "minecraft:blocks/wither_rose" | "minecraft:blocks/stonecutter" | "minecraft:blocks/shulker_box" | "minecraft:blocks/beetroots" | "minecraft:blocks/pink_petals" | "minecraft:blocks/potted_spruce_sapling" | "minecraft:blocks/granite" | "minecraft:blocks/end_stone_bricks" | "minecraft:blocks/bamboo_mosaic_stairs" | "minecraft:blocks/skeleton_skull" | "minecraft:blocks/mossy_stone_brick_wall" | "minecraft:blocks/dried_kelp_block" | "minecraft:blocks/red_nether_brick_slab" | "irons_spellbooks:chests/mangrove_hut/hidden_potion_storage" | "minecraft:blocks/black_banner" | "minecraft:blocks/shroomlight" | "minecraft:blocks/acacia_planks" | "titanium:blocks/titanium_block_asset_test" | "minecraft:blocks/red_nether_bricks" | "irons_spellbooks:magic_items/great_ink" | "minecraft:blocks/oak_stairs" | "minecraft:blocks/cut_copper_stairs" | "minecraft:blocks/diorite" | "minecraft:blocks/cyan_concrete_powder" | "minecraft:blocks/spruce_leaves" | "minecraft:entities/endermite" | "minecraft:blocks/weathered_cut_copper_slab" | "minecraft:blocks/large_amethyst_bud" | "minecraft:blocks/cherry_log" | "minecraft:gameplay/fishing" | "irons_spellbooks:chests/battleground/piglin_camp" | "minecraft:blocks/gray_bed" | "irons_spellbooks:magic_items/random_potion_or_elixir" | "minecraft:blocks/mud_brick_stairs" | "minecraft:chests/village/village_fletcher" | "minecraft:blocks/magenta_wool" | "minecraft:blocks/bamboo_fence" | "minecraft:blocks/blackstone_wall" | "minecraft:blocks/gray_carpet" | "minecraft:blocks/acacia_leaves" | "minecraft:blocks/red_tulip" | "minecraft:blocks/mossy_stone_brick_slab" | "minecraft:blocks/cobblestone_wall" | "minecraft:blocks/stripped_bamboo_block" | "minecraft:blocks/white_terracotta" | "minecraft:blocks/piglin_head" | "minecraft:blocks/cyan_candle_cake" | "minecraft:blocks/stripped_spruce_wood" | "minecraft:blocks/deepslate_tile_wall" | "minecraft:blocks/bubble_coral_fan" | "minecraft:blocks/red_mushroom" | "minecraft:blocks/stripped_jungle_wood" | "minecraft:blocks/tripwire" | "minecraft:blocks/jungle_slab" | "irons_spellbooks:chests/catacombs/wall_loot" | "minecraft:blocks/green_candle" | "minecraft:blocks/emerald_ore" | "minecraft:blocks/waxed_weathered_cut_copper_stairs" | "minecraft:blocks/fire_coral_block" | "minecraft:entities/guardian" | "minecraft:blocks/birch_log" | "minecraft:blocks/pink_glazed_terracotta" | "minecraft:blocks/warped_stairs" | "minecraft:entities/salmon" | "minecraft:blocks/chiseled_deepslate" | "minecraft:blocks/large_fern" | "minecraft:blocks/deepslate_iron_ore" | "minecraft:blocks/brown_bed" | "minecraft:blocks/smooth_sandstone" | "minecraft:blocks/cherry_pressure_plate" | "minecraft:blocks/brown_glazed_terracotta" | "minecraft:entities/sheep" | "minecraft:blocks/horn_coral" | "minecraft:blocks/stone_slab" | "minecraft:blocks/diorite_slab" | "minecraft:blocks/light_blue_banner" | "minecraft:entities/pillager" | "minecraft:blocks/lime_stained_glass" | "minecraft:blocks/glass_pane" | "minecraft:blocks/sea_pickle" | "minecraft:blocks/amethyst_cluster" | "irons_spellbooks:chests/pyromancer_tower/pyromancer_supplies" | "minecraft:blocks/potted_oxeye_daisy" | "minecraft:blocks/white_candle" | "minecraft:blocks/waxed_cut_copper" | "minecraft:entities/sniffer" | "minecraft:blocks/furnace" | "minecraft:blocks/jungle_pressure_plate" | "minecraft:blocks/bricks" | "minecraft:blocks/cracked_deepslate_bricks" | "minecraft:blocks/chiseled_nether_bricks" | "minecraft:blocks/brain_coral_fan" | "minecraft:blocks/bubble_coral" | "minecraft:blocks/oak_log" | "minecraft:blocks/crimson_hyphae" | "minecraft:blocks/magenta_stained_glass_pane" | "minecraft:blocks/weathered_cut_copper_stairs" | "minecraft:entities/frog" | "minecraft:blocks/orange_bed" | "irons_spellbooks:magic_items/archevoker_logbook" | "minecraft:blocks/red_sand" | "minecraft:blocks/magenta_stained_glass" | "minecraft:blocks/purpur_pillar" | "minecraft:chests/village/village_tannery" | "minecraft:chests/spawn_bonus_chest" | "minecraft:blocks/trapped_chest" | "minecraft:blocks/brick_wall" | "minecraft:blocks/crimson_sign" | "minecraft:blocks/cobweb" | "minecraft:blocks/orange_banner" | "minecraft:gameplay/hero_of_the_village/fletcher_gift" | "minecraft:blocks/wheat" | "minecraft:blocks/crimson_roots" | "minecraft:blocks/polished_blackstone_pressure_plate" | "minecraft:blocks/light_blue_concrete_powder" | "minecraft:blocks/ice" | "minecraft:entities/zoglin" | "minecraft:blocks/infested_cobblestone" | "irons_spellbooks:chests/impaled_icebreaker/food_barrel" | "minecraft:chests/village/village_plains_house" | "minecraft:blocks/dark_oak_pressure_plate" | "minecraft:blocks/mangrove_wood" | "minecraft:blocks/terracotta" | "minecraft:blocks/cherry_sign" | "minecraft:blocks/exposed_cut_copper_stairs" | "minecraft:blocks/gravel" | "minecraft:gameplay/hero_of_the_village/toolsmith_gift" | "minecraft:entities/cave_spider" | "minecraft:entities/wither_skeleton" | "minecraft:blocks/dead_fire_coral_block" | "minecraft:chests/underwater_ruin_small" | "minecraft:blocks/deepslate_tiles" | "minecraft:blocks/acacia_sign" | "minecraft:blocks/brown_candle" | "minecraft:blocks/soul_soil" | "minecraft:blocks/warped_hyphae" | "minecraft:blocks/spruce_slab" | "minecraft:chests/buried_treasure" | "minecraft:blocks/target" | "minecraft:blocks/polished_blackstone" | "minecraft:blocks/nether_brick_fence" | "minecraft:blocks/dirt" | "minecraft:blocks/stripped_jungle_log" | "minecraft:entities/sheep/light_gray" | "minecraft:blocks/blue_ice" | "minecraft:entities/rabbit" | "minecraft:blocks/dark_oak_stairs" | "minecraft:blocks/spruce_planks" | "minecraft:blocks/prismarine_brick_slab" | "minecraft:entities/strider" | "minecraft:blocks/amethyst_block" | "minecraft:blocks/dead_brain_coral" | "minecraft:blocks/birch_fence_gate" | "minecraft:blocks/jungle_sapling" | "minecraft:blocks/magenta_candle_cake" | "minecraft:blocks/orange_candle_cake" | "minecraft:blocks/magenta_bed" | "minecraft:entities/pufferfish" | "minecraft:blocks/oak_wood" | "minecraft:blocks/budding_amethyst" | "minecraft:blocks/prismarine_slab" | "minecraft:blocks/andesite_wall" | "minecraft:blocks/cherry_trapdoor" | "minecraft:blocks/black_concrete" | "minecraft:blocks/cave_vines" | "minecraft:blocks/horn_coral_fan" | "irons_spellbooks:blocks/firefly_jar" | "minecraft:blocks/lapis_ore" | "minecraft:blocks/raw_gold_block" | "minecraft:blocks/gray_candle_cake" | "minecraft:entities/axolotl" | "minecraft:blocks/bamboo_fence_gate" | "irons_spellbooks:chests/mountain_tower/ice_barrel" | "irons_spellbooks:chests/catacombs/coffin_loot" | "minecraft:entities/armor_stand" | "minecraft:blocks/pink_banner" | "minecraft:blocks/gray_shulker_box" | "minecraft:blocks/brown_concrete" | "minecraft:blocks/nether_portal" | "minecraft:blocks/tall_seagrass" | "minecraft:blocks/daylight_detector" | "minecraft:blocks/bell" | "minecraft:blocks/sandstone_wall" | "minecraft:blocks/cartography_table" | "minecraft:blocks/black_candle_cake" | "minecraft:blocks/mossy_cobblestone_wall" | "minecraft:blocks/dark_prismarine" | "minecraft:blocks/granite_wall" | "minecraft:entities/elder_guardian" | "minecraft:blocks/light_blue_glazed_terracotta" | "minecraft:blocks/blue_wool" | "minecraft:blocks/red_nether_brick_stairs" | "titanium:blocks/titanium_creative_fe_generator" | "minecraft:blocks/turtle_egg" | "minecraft:blocks/red_sandstone_stairs" | "minecraft:blocks/red_nether_brick_wall" | "minecraft:entities/creeper" | "minecraft:blocks/glass" | "minecraft:blocks/player_head" | "minecraft:blocks/polished_blackstone_brick_slab" | "minecraft:blocks/chorus_flower" | "minecraft:blocks/white_tulip" | "minecraft:entities/sheep/red" | "minecraft:gameplay/piglin_bartering" | "minecraft:blocks/spruce_trapdoor" | "minecraft:blocks/chorus_plant" | "minecraft:chests/village/village_armorer" | "minecraft:chests/bastion_hoglin_stable" | "minecraft:blocks/stone_brick_stairs" | "minecraft:blocks/light_gray_carpet" | "minecraft:blocks/polished_deepslate_wall" | "minecraft:blocks/yellow_carpet" | "minecraft:blocks/lime_candle" | "minecraft:blocks/mushroom_stem" | "minecraft:chests/desert_pyramid" | "minecraft:blocks/bookshelf" | "minecraft:blocks/purple_shulker_box" | "minecraft:blocks/farmland" | "titanium:blocks/titanium_block_twenty_four_test" | "minecraft:blocks/mossy_cobblestone" | "minecraft:blocks/stripped_cherry_wood" | "minecraft:blocks/ochre_froglight" | "minecraft:blocks/green_stained_glass_pane" | "minecraft:blocks/birch_door" | "minecraft:blocks/pink_concrete_powder" | "minecraft:blocks/lime_concrete_powder" | "irons_spellbooks:entities/cryomancer" | "minecraft:blocks/cherry_leaves" | "irons_spellbooks:scroll_gen" | "minecraft:blocks/small_amethyst_bud" | "minecraft:blocks/potted_azure_bluet" | "minecraft:blocks/chest" | "minecraft:blocks/pink_candle" | "minecraft:entities/sheep/white" | "minecraft:chests/underwater_ruin_big" | "minecraft:blocks/cut_red_sandstone_slab" | "minecraft:blocks/purple_bed" | "minecraft:blocks/smooth_quartz_stairs" | "minecraft:blocks/bamboo_trapdoor" | "minecraft:blocks/oak_trapdoor" | "minecraft:blocks/chiseled_polished_blackstone" | "minecraft:blocks/cut_sandstone_slab" | "minecraft:entities/sheep/cyan" | "minecraft:blocks/lapis_block" | "minecraft:blocks/dead_bush" | "minecraft:blocks/blue_banner" | "minecraft:blocks/pink_shulker_box" | "minecraft:blocks/red_concrete" | "minecraft:blocks/bamboo_door" | "minecraft:blocks/gray_stained_glass_pane" | "minecraft:blocks/pink_stained_glass_pane" | "minecraft:blocks/yellow_glazed_terracotta" | "minecraft:blocks/dead_tube_coral" | "minecraft:blocks/light_gray_concrete_powder" | "minecraft:blocks/soul_lantern" | "minecraft:entities/allay" | "minecraft:blocks/poppy" | "minecraft:blocks/polished_deepslate_stairs" | "minecraft:blocks/dirt_path" | "minecraft:blocks/dead_tube_coral_block" | "minecraft:blocks/glow_lichen" | "irons_spellbooks:blocks/blood_cauldron" | "minecraft:blocks/magenta_concrete" | "irons_spellbooks:patchouli_book" | "irons_spellbooks:chests/mangrove_hut/potion_ingredient_storage" | "minecraft:blocks/bamboo_block" | "minecraft:blocks/stripped_oak_log" | "minecraft:blocks/quartz_slab" | "minecraft:entities/stray" | "minecraft:blocks/stone_brick_wall" | "minecraft:blocks/redstone_block" | "minecraft:blocks/blue_carpet" | "minecraft:blocks/crimson_fence" | "irons_spellbooks:magic_items/decent_ink" | "minecraft:blocks/potted_dandelion" | "minecraft:blocks/cherry_stairs" | "minecraft:blocks/jack_o_lantern" | "minecraft:blocks/cobblestone_stairs" | "minecraft:blocks/mud_brick_slab" | "minecraft:blocks/purple_concrete" | "minecraft:chests/igloo_chest" | "minecraft:blocks/mangrove_sign" | "minecraft:blocks/red_sandstone_slab" | "minecraft:blocks/cobblestone_slab" | "minecraft:blocks/cracked_nether_bricks" | "minecraft:blocks/dead_horn_coral_fan" | "minecraft:chests/ancient_city" | "minecraft:blocks/cobbled_deepslate" | "minecraft:blocks/deepslate_copper_ore" | "minecraft:gameplay/fishing/junk" | "minecraft:blocks/red_carpet" | "minecraft:blocks/prismarine_brick_stairs" | "minecraft:blocks/peony" | "minecraft:blocks/cactus" | "minecraft:blocks/warped_planks" | "minecraft:blocks/end_stone_brick_slab" | "minecraft:entities/dolphin" | "minecraft:blocks/jungle_planks" | "minecraft:blocks/dark_oak_fence" | "minecraft:blocks/crimson_pressure_plate" | "minecraft:blocks/potted_mangrove_propagule" | "minecraft:entities/spider" | "minecraft:blocks/light_gray_terracotta" | "minecraft:archaeology/trail_ruins_rare" | "minecraft:blocks/bamboo_hanging_sign" | "minecraft:blocks/oak_sign" | "minecraft:blocks/mycelium" | "minecraft:entities/zombie_horse" | "irons_spellbooks:magic_items/scroll_pouch" | "minecraft:blocks/nether_bricks" | "minecraft:blocks/tnt" | "minecraft:blocks/kelp" | "minecraft:blocks/warped_wart_block" | "minecraft:blocks/yellow_banner" | "minecraft:blocks/white_stained_glass_pane" | "minecraft:blocks/potted_poppy" | "minecraft:blocks/lilac" | "minecraft:blocks/polished_blackstone_slab" | "minecraft:blocks/red_candle_cake" | "minecraft:blocks/stone" | "minecraft:blocks/white_banner" | "minecraft:blocks/light_gray_banner" | "minecraft:blocks/stripped_acacia_log" | "minecraft:blocks/infested_chiseled_stone_bricks" | "minecraft:blocks/quartz_pillar" | "minecraft:blocks/warped_fence" | "minecraft:blocks/pitcher_plant" | "minecraft:blocks/potted_orange_tulip" | "minecraft:blocks/red_stained_glass" | "minecraft:blocks/sculk_vein" | "minecraft:entities/drowned" | "irons_spellbooks:chests/additional_generic_loot" | "minecraft:blocks/oak_button" | "minecraft:blocks/purple_banner" | "minecraft:chests/bastion_bridge" | "minecraft:entities/bat" | "minecraft:blocks/crimson_planks" | "minecraft:blocks/bamboo_mosaic" | "minecraft:blocks/netherrack" | "minecraft:blocks/magenta_glazed_terracotta" | "minecraft:blocks/green_banner" | "minecraft:blocks/honeycomb_block" | "minecraft:entities/trader_llama" | "minecraft:blocks/carved_pumpkin" | "minecraft:blocks/smoker" | "minecraft:blocks/potted_pink_tulip" | "minecraft:entities/turtle" | "minecraft:blocks/spruce_log" | "minecraft:entities/vindicator" | "minecraft:entities/evoker" | "minecraft:blocks/brown_shulker_box" | "minecraft:blocks/waxed_exposed_copper" | "minecraft:blocks/potted_lily_of_the_valley" | "minecraft:blocks/redstone_torch" | "minecraft:blocks/stripped_acacia_wood" | "irons_spellbooks:entities/apothecarist" | "minecraft:entities/zombie_villager" | "minecraft:blocks/black_stained_glass" | "minecraft:blocks/nether_quartz_ore" | "minecraft:blocks/spruce_sign" | "minecraft:blocks/potted_white_tulip" | "minecraft:blocks/magenta_candle" | "minecraft:blocks/lime_shulker_box" | "irons_spellbooks:magic_items/archevoker_logbook_translated" | "minecraft:blocks/dispenser" | "minecraft:blocks/orange_tulip" | "minecraft:entities/fox" | "minecraft:blocks/potted_dead_bush" | "minecraft:blocks/birch_sapling" | "minecraft:blocks/grindstone" | "minecraft:blocks/waxed_exposed_cut_copper" | "minecraft:blocks/scaffolding" | "minecraft:blocks/smooth_quartz_slab" | "minecraft:entities/sheep/orange" | "minecraft:blocks/red_wool" | "minecraft:blocks/light_gray_candle_cake" | "minecraft:blocks/sculk_shrieker" | "irons_spellbooks:ring_gen" | "irons_spellbooks:chests/additional_nether_loot" | "minecraft:blocks/gray_candle" | "minecraft:blocks/flowering_azalea_leaves" | "irons_spellbooks:magic_items/random_elixir" | "minecraft:blocks/light_blue_shulker_box" | "minecraft:chests/pillager_outpost" | "minecraft:blocks/black_stained_glass_pane" | "minecraft:blocks/cyan_stained_glass" | "minecraft:blocks/orange_concrete" | "irons_spellbooks:chests/catacombs/armory_loot" | "minecraft:blocks/light_blue_wool" | "minecraft:blocks/bamboo" | "minecraft:blocks/vine" | "minecraft:blocks/dead_horn_coral" | "minecraft:blocks/prismarine_wall" | "minecraft:chests/village/village_shepherd" | "minecraft:blocks/wet_sponge" | "minecraft:blocks/blackstone_stairs" | "minecraft:blocks/chiseled_red_sandstone" | "minecraft:blocks/mangrove_roots" | "minecraft:gameplay/hero_of_the_village/cartographer_gift" | "minecraft:entities/bee" | "minecraft:blocks/jungle_trapdoor" | "minecraft:blocks/potted_warped_fungus" | "minecraft:blocks/cherry_door" | "minecraft:blocks/pink_concrete" | "minecraft:blocks/andesite_slab" | "minecraft:blocks/deepslate_brick_stairs" | "minecraft:blocks/blackstone_slab" | "minecraft:blocks/red_banner" | "minecraft:entities/sheep/light_blue" | "minecraft:entities/wolf" | "irons_spellbooks:entities/priest" | "minecraft:blocks/candle_cake" | "minecraft:blocks/sculk_catalyst" | "minecraft:chests/village/village_cartographer" | "minecraft:blocks/potted_azalea_bush" | "minecraft:blocks/deepslate_tile_slab" | "minecraft:blocks/white_carpet" | "minecraft:blocks/acacia_door" | "minecraft:blocks/chain" | "minecraft:blocks/crimson_door" | "minecraft:gameplay/fishing/treasure" | "minecraft:blocks/polished_diorite_slab" | "minecraft:blocks/lime_wool" | "minecraft:blocks/stripped_birch_wood" | "minecraft:archaeology/ocean_ruin_cold" | "minecraft:blocks/cobbled_deepslate_wall" | "minecraft:blocks/polished_deepslate_slab" | "minecraft:blocks/beehive" | "minecraft:blocks/mangrove_trapdoor" | "minecraft:blocks/deepslate_diamond_ore" | "minecraft:blocks/red_stained_glass_pane" | "minecraft:blocks/red_mushroom_block" | "minecraft:blocks/rail" | "minecraft:blocks/cut_copper_slab" | "minecraft:blocks/dark_oak_planks" | "minecraft:blocks/mossy_cobblestone_slab" | "minecraft:blocks/pink_tulip" | "minecraft:blocks/crimson_hanging_sign" | "minecraft:blocks/attached_pumpkin_stem" | "minecraft:blocks/tube_coral_fan" | "minecraft:blocks/bamboo_stairs" | "minecraft:blocks/sticky_piston" | "minecraft:blocks/mossy_stone_brick_stairs" | "minecraft:blocks/coarse_dirt" | "minecraft:blocks/stripped_mangrove_log" | "minecraft:entities/phantom" | "minecraft:gameplay/sniffer_digging" | "minecraft:blocks/brain_coral_block" | "minecraft:blocks/yellow_concrete" | "minecraft:blocks/rose_bush" | "minecraft:gameplay/hero_of_the_village/butcher_gift" | "minecraft:blocks/waxed_weathered_copper" | "minecraft:entities/parrot" | "minecraft:blocks/spruce_wood" | "minecraft:blocks/diorite_wall" | "minecraft:blocks/crimson_trapdoor" | "minecraft:blocks/green_carpet" | "minecraft:chests/jungle_temple_dispenser" | "minecraft:blocks/white_wool" | "minecraft:blocks/bamboo_button" | "minecraft:blocks/dragon_head" | "minecraft:blocks/potted_crimson_roots" | "minecraft:blocks/chiseled_quartz_block" | "minecraft:blocks/hanging_roots" | "minecraft:blocks/honey_block" | "minecraft:blocks/fire_coral_fan" | "minecraft:blocks/dandelion" | "minecraft:blocks/emerald_block" | "minecraft:entities/sheep/purple" | "irons_spellbooks:chests/evoker_fort/guard_tower" | "minecraft:blocks/jukebox" | "minecraft:blocks/fletching_table" | "minecraft:blocks/white_stained_glass" | "minecraft:entities/ocelot" | "minecraft:blocks/lectern" | "irons_spellbooks:chests/citadel/wall_loot" | "minecraft:blocks/warped_fungus" | "irons_spellbooks:entities/additional_hoglin_loot" | "minecraft:blocks/slime_block" | "minecraft:blocks/stone_stairs" | "minecraft:blocks/sweet_berry_bush" | "minecraft:blocks/lodestone" | "minecraft:blocks/mangrove_fence" | "minecraft:blocks/sculk_sensor" | "minecraft:blocks/beacon" | "minecraft:blocks/potted_crimson_fungus" | "minecraft:blocks/pointed_dripstone" | "minecraft:blocks/cherry_slab" | "minecraft:blocks/granite_stairs" | "minecraft:blocks/warped_nylium" | "minecraft:blocks/dark_oak_slab" | "minecraft:blocks/lava_cauldron" | "minecraft:blocks/pink_carpet" | "minecraft:blocks/pink_stained_glass" | "minecraft:blocks/attached_melon_stem" | "minecraft:gameplay/hero_of_the_village/shepherd_gift" | "minecraft:blocks/packed_mud" | "minecraft:blocks/potatoes" | "minecraft:blocks/birch_planks" | "minecraft:blocks/gold_ore" | "minecraft:blocks/stone_pressure_plate" | "minecraft:blocks/brown_banner" | "minecraft:blocks/orange_stained_glass" | "minecraft:blocks/obsidian" | "minecraft:blocks/brown_concrete_powder" | "minecraft:blocks/potted_red_tulip" | "minecraft:blocks/gray_glazed_terracotta" | "minecraft:chests/jungle_temple" | "minecraft:blocks/potted_acacia_sapling" | "minecraft:blocks/horn_coral_block" | "minecraft:blocks/dead_brain_coral_fan" | "minecraft:blocks/lime_terracotta" | "minecraft:blocks/brown_terracotta" | "minecraft:blocks/weeping_vines" | "minecraft:blocks/polished_andesite_slab" | "minecraft:blocks/light_gray_bed" | "minecraft:blocks/cherry_planks" | "minecraft:blocks/grass" | "minecraft:blocks/green_terracotta" | "minecraft:blocks/granite_slab" | "minecraft:blocks/mangrove_planks" | "irons_spellbooks:entities/citadel_keeper" | "minecraft:gameplay/hero_of_the_village/weaponsmith_gift" | "minecraft:blocks/brown_carpet" | "minecraft:blocks/polished_blackstone_brick_stairs" | "minecraft:blocks/light_gray_candle" | "minecraft:blocks/hay_block" | "minecraft:blocks/white_candle_cake" | "minecraft:gameplay/cat_morning_gift" | "minecraft:blocks/red_candle" | "minecraft:blocks/stripped_dark_oak_log" | "minecraft:blocks/purple_glazed_terracotta" | "minecraft:blocks/brown_wool" | "minecraft:blocks/cobblestone" | "minecraft:blocks/spruce_button" | "minecraft:blocks/cut_sandstone" | "minecraft:blocks/wither_skeleton_skull" | "minecraft:archaeology/desert_well" | "minecraft:chests/village/village_savanna_house" | "minecraft:blocks/white_glazed_terracotta" | "minecraft:chests/village/village_taiga_house" | "irons_spellbooks:chests/sewer_loot" | "minecraft:blocks/jungle_door" | "minecraft:blocks/mangrove_door" | "minecraft:entities/glow_squid" | "minecraft:blocks/powder_snow" | "minecraft:blocks/iron_trapdoor" | "minecraft:gameplay/fishing/fish" | "minecraft:blocks/potted_torchflower" | "minecraft:blocks/orange_terracotta" | "minecraft:blocks/orange_candle" | "minecraft:blocks/waxed_oxidized_copper" | "minecraft:chests/village/village_butcher" | "irons_spellbooks:chests/mountain_tower/mountain_tower" | "minecraft:blocks/green_shulker_box" | "minecraft:blocks/potted_allium" | "minecraft:blocks/cake" | "minecraft:blocks/nether_gold_ore" | "minecraft:blocks/purpur_slab" | "minecraft:blocks/activator_rail" | "minecraft:blocks/lime_carpet" | "minecraft:blocks/yellow_stained_glass_pane" | "minecraft:entities/tropical_fish" | "minecraft:blocks/oxidized_cut_copper_slab" | "minecraft:blocks/potted_oak_sapling" | "minecraft:chests/village/village_desert_house" | "minecraft:entities/villager" | "hungry_game_func:hungry_game_chest" | "minecraft:blocks/green_bed" | "minecraft:blocks/mud_brick_wall" | "minecraft:blocks/spruce_door" | "minecraft:blocks/blue_candle" | "minecraft:blocks/red_sandstone" | "minecraft:blocks/melon" | "minecraft:blocks/mossy_cobblestone_stairs" | "minecraft:blocks/oak_door" | "irons_spellbooks:entities/additional_dragon_loot" | "irons_spellbooks:chests/filler_storage_loot" | "minecraft:blocks/bamboo_pressure_plate" | "minecraft:blocks/light_gray_stained_glass" | "minecraft:blocks/smooth_red_sandstone_slab" | "irons_spellbooks:entities/additional_blaze_loot" | "minecraft:blocks/gray_stained_glass" | "irons_spellbooks:entities/additional_evoker_loot" | "minecraft:blocks/diorite_stairs" | "minecraft:entities/piglin_brute" | "minecraft:entities/piglin" | "minecraft:blocks/bubble_coral_block" | "minecraft:blocks/clay" | "minecraft:blocks/dragon_egg" | "minecraft:blocks/lily_pad" | "minecraft:blocks/weeping_vines_plant" | "minecraft:blocks/polished_blackstone_brick_wall" | "irons_spellbooks:chests/bookshelf_loot" | "minecraft:entities/sheep/pink" | "minecraft:blocks/white_shulker_box" | "irons_spellbooks:chests/component_storage" | "minecraft:blocks/acacia_fence" | "minecraft:chests/end_city_treasure" | "minecraft:blocks/deepslate_emerald_ore" | "minecraft:blocks/quartz_block" | "minecraft:gameplay/hero_of_the_village/cleric_gift" | "minecraft:blocks/light_gray_wool" | "minecraft:blocks/stripped_warped_stem" | "minecraft:blocks/blue_concrete_powder" | "minecraft:blocks/bone_block" | "minecraft:blocks/conduit" | "minecraft:blocks/birch_fence" | "minecraft:blocks/potted_blue_orchid" | "minecraft:blocks/end_stone_brick_wall" | "minecraft:blocks/cherry_fence_gate" | "minecraft:blocks/gray_banner" | "minecraft:blocks/mangrove_fence_gate" | "minecraft:blocks/infested_stone_bricks" | "minecraft:blocks/dark_oak_trapdoor" | "minecraft:blocks/light_weighted_pressure_plate" | "minecraft:blocks/blue_stained_glass_pane" | "minecraft:blocks/crimson_nylium" | "irons_spellbooks:chests/additional_treasure_loot" | "minecraft:blocks/chiseled_sandstone" | "minecraft:blocks/stripped_crimson_hyphae" | "minecraft:blocks/warped_slab" | "minecraft:blocks/powder_snow_cauldron" | "minecraft:blocks/big_dripleaf_stem" | "minecraft:blocks/oxidized_cut_copper_stairs" | "minecraft:blocks/chiseled_bookshelf" | "minecraft:blocks/moss_carpet" | "minecraft:blocks/heavy_weighted_pressure_plate" | "minecraft:blocks/blackstone" | "minecraft:blocks/potted_cornflower" | "minecraft:entities/blaze" | "minecraft:entities/wandering_trader" | "minecraft:blocks/birch_slab" | "minecraft:blocks/zombie_head" | "minecraft:blocks/purple_concrete_powder" | "minecraft:blocks/azure_bluet" | "minecraft:blocks/gray_wool" | "minecraft:blocks/reinforced_deepslate" | "minecraft:blocks/polished_andesite" | "minecraft:blocks/cyan_candle" | "minecraft:blocks/crimson_fungus" | "minecraft:blocks/waxed_cut_copper_slab" | "minecraft:blocks/water_cauldron" | "minecraft:entities/wither" | "minecraft:chests/stronghold_library" | "minecraft:blocks/acacia_pressure_plate" | "minecraft:blocks/nether_brick_wall" | "minecraft:blocks/birch_pressure_plate" | "minecraft:blocks/spruce_pressure_plate" | "minecraft:blocks/blue_candle_cake" | "minecraft:blocks/podzol" | "minecraft:blocks/blue_glazed_terracotta" | "minecraft:blocks/melon_stem" | "minecraft:blocks/smooth_red_sandstone" | "irons_spellbooks:entities/pyromancer" | "minecraft:blocks/oak_leaves" | "minecraft:blocks/tall_grass" | "minecraft:blocks/magenta_carpet" | "minecraft:blocks/light_gray_glazed_terracotta" | "minecraft:blocks/ladder" | "minecraft:entities/panda" | "minecraft:blocks/respawn_anchor" | "minecraft:blocks/torchflower_crop" | "minecraft:blocks/basalt" | "minecraft:blocks/observer" | "minecraft:blocks/suspicious_gravel" | "minecraft:chests/village/village_weaponsmith" | "minecraft:blocks/snow" | "minecraft:blocks/sunflower" | "irons_spellbooks:entities/dead_king" | "minecraft:blocks/coal_ore" | "minecraft:blocks/yellow_shulker_box" | "irons_spellbooks:chests/priest_house" | "minecraft:blocks/prismarine_stairs" | "minecraft:blocks/smooth_red_sandstone_stairs" | "minecraft:chests/bastion_other" | "minecraft:blocks/dark_oak_wood" | "minecraft:blocks/dead_horn_coral_block" | "minecraft:blocks/anvil" | "minecraft:blocks/potted_dark_oak_sapling" | "minecraft:entities/squid" | "minecraft:blocks/green_candle_cake" | "minecraft:blocks/crafting_table" | "minecraft:blocks/light_gray_concrete" | "minecraft:entities/sheep/green" | "minecraft:blocks/black_bed" | "minecraft:blocks/raw_iron_block" | "minecraft:blocks/campfire" | "minecraft:blocks/green_concrete_powder" | "minecraft:blocks/warped_button" | "minecraft:blocks/cracked_polished_blackstone_bricks" | "minecraft:blocks/soul_sand" | "minecraft:blocks/purple_stained_glass" | "minecraft:blocks/copper_ore" | "minecraft:blocks/crying_obsidian" | "minecraft:blocks/red_shulker_box" | "minecraft:blocks/spruce_hanging_sign" | "minecraft:blocks/purple_carpet" | "minecraft:blocks/deepslate_gold_ore" | "minecraft:blocks/netherite_block" | "minecraft:blocks/brewing_stand" | "minecraft:blocks/cracked_stone_bricks" | "minecraft:blocks/black_carpet" | "minecraft:blocks/birch_trapdoor" | "minecraft:blocks/green_wool" | "minecraft:blocks/dark_oak_button" | "minecraft:blocks/dropper" | "minecraft:blocks/cracked_deepslate_tiles" | "minecraft:blocks/deepslate_coal_ore" | "minecraft:blocks/oak_hanging_sign" | "irons_spellbooks:chests/additional_good_loot" | "minecraft:archaeology/desert_pyramid" | "minecraft:blocks/deepslate" | "minecraft:blocks/stripped_cherry_log" | "minecraft:entities/polar_bear" | "minecraft:blocks/yellow_candle_cake" | "minecraft:blocks/iron_bars" | "minecraft:blocks/candle" | "minecraft:entities/sheep/gray" | "minecraft:blocks/oak_fence" | "minecraft:blocks/warped_trapdoor" | "minecraft:blocks/packed_ice" | "minecraft:blocks/purple_wool" | "minecraft:blocks/calcite" | "minecraft:chests/woodland_mansion" | "minecraft:blocks/sponge" | "minecraft:blocks/muddy_mangrove_roots" | "minecraft:blocks/redstone_ore" | "minecraft:blocks/diamond_ore" | "irons_spellbooks:blocks/arcane_anvil" | "minecraft:blocks/snow_block" | "minecraft:blocks/stripped_dark_oak_wood" | "irons_spellbooks:scroll_gen_magic_missile" | "minecraft:blocks/waxed_cut_copper_stairs" | "minecraft:blocks/blue_stained_glass" | "minecraft:entities/husk" | "minecraft:blocks/magma_block" | "minecraft:blocks/potted_wither_rose" | "minecraft:blocks/potted_birch_sapling" | "minecraft:blocks/light_blue_carpet" | "minecraft:entities/giant" | "minecraft:entities/iron_golem" | "minecraft:gameplay/hero_of_the_village/librarian_gift"
    type RawTexture = "minecraft:textures/gui/title/background/panorama_0.png" | "jei:textures/atlas/gui.png" | "forge:textures/gui/version_check_icons.png" | "minecraft:textures/gui/title/background/panorama_1.png" | "minecraft:textures/gui/container/inventory.png" | "minecraft:textures/gui/options_background.png" | "irons_spellbooks:textures/gui/spell_icons/ray_of_frost.png" | "minecraft:textures/atlas/mob_effects.png" | "minecraft:textures/gui/title/edition.png" | "irons_spellbooks:textures/gui/spell_icons/fire_breath.png" | "minecraft:textures/atlas/paintings.png" | "minecraft:textures/gui/icons.png" | "minecraft:textures/atlas/beds.png" | "minecraft:default/0" | "minecraft:include/space/0" | "minecraft:include/default/0" | "minecraft:textures/atlas/armor_trims.png" | "minecraft:textures/atlas/chest.png" | "minecraft:uniform/0" | "minecraft:textures/gui/widgets.png" | "minecraft:dynamic/light_map_1" | "minecraft:textures/gui/accessibility.png" | "minecraft:textures/atlas/shield_patterns.png" | "minecraft:textures/gui/world_selection.png" | "minecraft:textures/gui/title/mojangstudios.png" | "minecraft:textures/entity/player/slim/kai.png" | "minecraft:textures/atlas/blocks.png" | "minecraft:textures/gui/title/background/panorama_5.png" | "irons_spellbooks:textures/gui/icons.png" | "irons_spellbooks:textures/gui/spell_icons/arrow_volley.png" | "minecraft:textures/atlas/decorated_pot.png" | "minecraft:include/unifont/0" | "minecraft:textures/atlas/shulker_boxes.png" | "minecraft:missing/0" | "minecraft:textures/gui/title/background/panorama_overlay.png" | "minecraft:illageralt/0" | "minecraft:textures/environment/sun.png" | "minecraft:textures/environment/moon_phases.png" | "minecraft:textures/atlas/banner_patterns.png" | "minecraft:textures/gui/title/background/panorama_4.png" | "minecraft:textures/misc/forcefield.png" | "minecraft:alt/0" | "minecraft:textures/gui/title/background/panorama_3.png" | "minecraft:textures/atlas/particles.png" | "minecraft:missingno" | "minecraft:textures/misc/vignette.png" | "minecraft:textures/atlas/signs.png" | "moonlight:textures/atlas/map_markers.png" | "minecraft:textures/gui/title/background/panorama_2.png" | "minecraft:textures/gui/title/minecraft.png";
    type Texture = "minecraft:block/chipped_anvil_top" | "minecraft:item/clock_50" | "minecraft:block/lightning_rod" | "irons_spellbooks:item/void_rune" | "minecraft:trims/items/boots_trim_diamond" | "minecraft:item/clock_55" | "minecraft:item/clock_56" | "minecraft:item/flint" | "minecraft:item/clock_57" | "minecraft:trims/items/leggings_trim_gold" | "minecraft:item/clock_58" | "irons_spellbooks:item/claymore" | "minecraft:item/clock_59" | "minecraft:item/clock_53" | "minecraft:item/clock_54" | "minecraft:item/dark_oak_chest_boat" | "minecraft:item/clock_51" | "minecraft:item/clock_52" | "geckolib:block/botarium_side" | "irons_spellbooks:item/cast_time_ring" | "irons_spellbooks:item/blaze_spell_book" | "irons_spellbooks:item/scroll_holy" | "minecraft:item/heart_of_the_sea" | "minecraft:item/leather_boots" | "minecraft:block/dead_bubble_coral" | "irons_spellbooks:item/staff_of_the_nines_stick" | "moonlight:block/soft_fluids/honey_liquid" | "minecraft:block/azalea_plant" | "minecraft:block/polished_andesite" | "irons_spellbooks:item/mana_ring" | "minecraft:trims/items/helmet_trim_amethyst" | "minecraft:item/acacia_sign" | "minecraft:item/gray_dye" | "minecraft:item/oak_boat" | "irons_spellbooks:item/cryomancer_leggings" | "minecraft:item/clock_60" | "minecraft:item/clock_61" | "minecraft:trims/items/chestplate_trim_netherite_darker" | "irons_spellbooks:item/amethyst_rapier" | "minecraft:item/clock_62" | "minecraft:item/clock_63" | "irons_spellbooks:item/spellbreaker_gui" | "minecraft:block/pointed_dripstone_up_tip" | "minecraft:block/structure_block_data" | "minecraft:item/chainmail_leggings" | "irons_spellbooks:item/pumpkin_chestplate" | "minecraft:item/shulker_shell" | "minecraft:block/brain_coral_fan" | "minecraft:block/scaffolding_side" | "minecraft:block/deepslate_redstone_ore" | "minecraft:item/knowledge_book" | "minecraft:item/yellow_candle" | "minecraft:item/music_disc_far" | "minecraft:item/wheat" | "minecraft:block/lime_shulker_box" | "minecraft:item/jungle_sign" | "irons_spellbooks:item/upgrade_orb_holy" | "minecraft:block/dark_prismarine" | "curios:slot/empty_bracelet_slot" | "minecraft:block/black_concrete_powder" | "minecraft:block/sniffer_egg_slightly_cracked_bottom" | "minecraft:item/melon_seeds" | "minecraft:block/gilded_blackstone" | "minecraft:item/heart_pottery_sherd" | "minecraft:block/cut_red_sandstone" | "minecraft:block/mushroom_stem" | "minecraft:item/bone" | "minecraft:block/end_portal_frame_top" | "geckolib:item/wolf_armor_helmet" | "minecraft:block/red_sand" | "minecraft:block/nether_sprouts" | "kubejs:block/detector" | "minecraft:block/mangrove_log_top" | "irons_spellbooks:item/scroll_ender" | "minecraft:block/crafting_table_front" | "minecraft:item/book" | "minecraft:block/coarse_dirt" | "minecraft:block/chiseled_red_sandstone" | "minecraft:item/birch_door" | "irons_spellbooks:item/oakskin_elixir" | "minecraft:block/azure_bluet" | "irons_spellbooks:item/rotten_spell_book" | "minecraft:item/firework_star" | "minecraft:block/white_stained_glass" | "minecraft:block/item_frame" | "irons_spellbooks:item/upgrade_orb_cooldown" | "minecraft:item/bow_pulling_0" | "minecraft:item/bow_pulling_1" | "minecraft:item/bow_pulling_2" | "minecraft:block/sculk_sensor_side" | "moonlight:block/soft_fluids/magma_flow" | "minecraft:block/furnace_side" | "minecraft:block/pink_stained_glass" | "minecraft:block/pink_petals_stem" | "minecraft:block/bubble_coral_fan" | "minecraft:block/light_blue_wool" | "minecraft:item/music_disc_mall" | "minecraft:trims/items/helmet_trim_netherite" | "minecraft:block/fire_coral_block" | "minecraft:block/spawner" | "minecraft:entity/conduit/wind_vertical" | "minecraft:block/beacon" | "minecraft:block/brewing_stand_base" | "irons_spellbooks:item/weapon_parts" | "minecraft:block/rail_corner" | "minecraft:entity/conduit/cage" | "minecraft:block/cornflower" | "minecraft:item/dark_oak_door" | "minecraft:block/orange_concrete" | "minecraft:block/gold_block" | "minecraft:block/cherry_planks" | "minecraft:item/empty_armor_slot_helmet" | "irons_spellbooks:item/netherite_mage_leggings" | "minecraft:item/netherite_chestplate" | "minecraft:block/light_blue_glazed_terracotta" | "minecraft:item/acacia_chest_boat" | "minecraft:item/leather_horse_armor" | "minecraft:block/birch_log" | "minecraft:block/soul_fire_0" | "minecraft:block/soul_fire_1" | "minecraft:block/chain_command_block_front" | "minecraft:block/bamboo_door_bottom" | "irons_spellbooks:item/netherward_tincture" | "minecraft:block/light_gray_concrete" | "minecraft:block/light_blue_stained_glass_pane_top" | "minecraft:block/acacia_trapdoor" | "irons_spellbooks:item/autoloader_crossbow_pulling_0" | "irons_spellbooks:item/autoloader_crossbow_pulling_1" | "minecraft:item/campfire" | "irons_spellbooks:item/autoloader_crossbow_pulling_2" | "irons_spellbooks:item/autoloader_crossbow_pulling_3" | "irons_spellbooks:item/autoloader_crossbow_pulling_4" | "minecraft:item/nether_wart" | "irons_spellbooks:item/autoloader_crossbow_pulling_5" | "irons_spellbooks:item/autoloader_crossbow_pulling_6" | "minecraft:block/stonecutter_side" | "minecraft:block/brown_mushroom" | "minecraft:block/purple_terracotta" | "minecraft:block/purpur_block" | "minecraft:item/stone_axe" | "minecraft:block/lime_candle_lit" | "minecraft:block/rail" | "minecraft:block/warped_nylium_side" | "irons_spellbooks:block/arcane_anvil_side" | "minecraft:block/chiseled_polished_blackstone" | "irons_spellbooks:item/necronomicon_spell_book" | "minecraft:block/brain_coral" | "minecraft:item/emerald" | "minecraft:item/netherite_hoe" | "minecraft:block/beetroots_stage0" | "minecraft:block/beetroots_stage1" | "minecraft:block/beetroots_stage2" | "minecraft:block/small_dripleaf_top" | "minecraft:block/beetroots_stage3" | "minecraft:item/light_gray_candle" | "minecraft:block/acacia_log" | "irons_spellbooks:item/copper_spell_book" | "minecraft:block/stripped_oak_log_top" | "minecraft:block/cave_vines_plant" | "minecraft:item/pitcher_plant" | "minecraft:block/brown_stained_glass_pane_top" | "minecraft:block/fire_0" | "minecraft:block/fire_1" | "minecraft:item/repeater" | "kubejs:item/bucket" | "minecraft:item/crimson_sign" | "minecraft:block/sniffer_egg_not_cracked_top" | "irons_spellbooks:item/shadowwalker_boots" | "minecraft:block/brown_stained_glass" | "minecraft:block/brown_terracotta" | "minecraft:block/stone" | "minecraft:block/gray_wool" | "minecraft:block/tube_coral_block" | "minecraft:item/iron_boots" | "irons_spellbooks:item/upgrade_orb_blood" | "minecraft:item/wayfinder_armor_trim_smithing_template" | "minecraft:block/enchanting_table_bottom" | "minecraft:item/mushroom_stew" | "minecraft:block/mangrove_roots_side" | "minecraft:block/pearlescent_froglight_top" | "minecraft:item/leather_helmet_overlay" | "minecraft:block/dead_brain_coral_fan" | "minecraft:item/spruce_boat" | "irons_spellbooks:block/arcane_anvil" | "minecraft:block/composter_top" | "minecraft:item/armor_stand" | "minecraft:block/bamboo_fence" | "patchouli:item/book_gray" | "irons_spellbooks:item/casters_tea" | "minecraft:block/deepslate_gold_ore" | "minecraft:item/cooked_cod" | "minecraft:block/hay_block_top" | "minecraft:item/cooked_salmon" | "minecraft:item/salmon" | "minecraft:item/bowl" | "minecraft:block/magenta_concrete" | "minecraft:block/black_glazed_terracotta" | "minecraft:block/lava_still" | "minecraft:block/birch_log_top" | "minecraft:item/flower_banner_pattern" | "minecraft:block/brown_wool" | "minecraft:block/shulker_box" | "minecraft:block/diamond_block" | "minecraft:trims/items/chestplate_trim_netherite" | "kubejs:block/example_block" | "minecraft:block/pink_concrete" | "minecraft:block/fletching_table_top" | "minecraft:item/oak_hanging_sign" | "minecraft:block/dead_fire_coral_fan" | "minecraft:block/bamboo_fence_gate" | "minecraft:block/grass_block_side_overlay" | "minecraft:block/jungle_door_top" | "minecraft:item/candle" | "minecraft:block/smooth_stone_slab_side" | "minecraft:item/mourner_pottery_sherd" | "minecraft:block/repeating_command_block_back" | "minecraft:block/amethyst_cluster" | "minecraft:block/brown_concrete_powder" | "minecraft:block/bamboo_trapdoor" | "irons_spellbooks:item/frosted_helve" | "minecraft:block/calibrated_sculk_sensor_top" | "minecraft:item/pink_petals" | "minecraft:block/netherrack" | "minecraft:entity/conduit/open_eye" | "minecraft:block/purple_candle" | "minecraft:block/oak_door_bottom" | "minecraft:block/large_fern_bottom" | "minecraft:block/cauldron_top" | "minecraft:item/wooden_axe" | "minecraft:trims/items/chestplate_trim_lapis" | "geckolib:item/gecko_armor_helmet" | "minecraft:item/turtle_helmet" | "minecraft:block/oak_log" | "minecraft:item/poisonous_potato" | "minecraft:item/pink_candle" | "minecraft:item/powder_snow_bucket" | "minecraft:item/red_dye" | "minecraft:item/dragon_breath" | "irons_spellbooks:item/divine_pearl" | "minecraft:item/diamond_leggings" | "moonlight:block/soft_fluids/xp_flow" | "minecraft:item/black_dye" | "minecraft:block/cake_side" | "minecraft:block/black_candle_lit" | "minecraft:block/honeycomb_block" | "irons_spellbooks:item/cinder_essence" | "minecraft:block/cherry_door_top" | "minecraft:block/flowering_azalea_top" | "minecraft:item/music_disc_wait" | "curios:slot/empty_ring_slot" | "minecraft:block/dead_bush" | "minecraft:block/sculk_catalyst_bottom" | "minecraft:block/potted_azalea_bush_top" | "irons_spellbooks:item/archevoker_leggings" | "minecraft:item/glowstone_dust" | "minecraft:block/oxeye_daisy" | "minecraft:trims/items/helmet_trim_redstone" | "minecraft:block/scaffolding_top" | "minecraft:trims/items/chestplate_trim_gold" | "minecraft:block/crimson_stem" | "minecraft:block/deepslate_copper_ore" | "minecraft:item/crossbow_standby" | "minecraft:block/green_candle_lit" | "minecraft:trims/items/boots_trim_netherite_darker" | "minecraft:block/white_glazed_terracotta" | "minecraft:block/deepslate_lapis_ore" | "minecraft:block/carved_pumpkin" | "minecraft:item/golden_sword" | "curios:slot/empty_body_slot" | "minecraft:block/campfire_log" | "minecraft:block/bedrock" | "irons_spellbooks:item/spell_book_models/gold_spell_book" | "minecraft:block/loom_front" | "minecraft:block/light_blue_stained_glass" | "minecraft:block/gray_glazed_terracotta" | "minecraft:block/warped_stem_top" | "irons_spellbooks:item/blood_staff_gui" | "minecraft:block/dead_bubble_coral_fan" | "minecraft:block/lodestone_top" | "minecraft:item/mutton" | "minecraft:item/cooked_mutton" | "minecraft:block/crimson_roots" | "minecraft:block/red_mushroom" | "minecraft:block/sniffer_egg_slightly_cracked_top" | "minecraft:block/white_candle_lit" | "minecraft:item/tide_armor_trim_smithing_template" | "geckolib:item/gecko_armor_boots" | "minecraft:block/magenta_concrete_powder" | "minecraft:item/golden_apple" | "minecraft:item/bamboo_sign" | "minecraft:item/spectral_arrow" | "minecraft:block/mangrove_propagule" | "minecraft:item/jungle_hanging_sign" | "kubejs:item/arrow" | "minecraft:block/yellow_terracotta" | "minecraft:block/observer_back_on" | "minecraft:block/sniffer_egg_slightly_cracked_east" | "irons_spellbooks:item/permafrost_shard" | "minecraft:block/birch_planks" | "irons_spellbooks:item/heavy_chain" | "minecraft:block/bookshelf" | "minecraft:block/observer_back" | "minecraft:block/pink_concrete_powder" | "minecraft:block/cocoa_stage0" | "minecraft:block/cocoa_stage1" | "minecraft:item/beetroot_soup" | "minecraft:block/reinforced_deepslate_side" | "minecraft:block/cocoa_stage2" | "minecraft:item/paper" | "irons_spellbooks:item/priest_chestplate" | "minecraft:item/gold_nugget" | "minecraft:block/purpur_pillar_top" | "minecraft:trims/items/leggings_trim_iron_darker" | "irons_spellbooks:item/protection_rune" | "irons_spellbooks:item/shadowwalker_helmet" | "minecraft:block/sculk_sensor_tendril_inactive" | "minecraft:block/daylight_detector_top" | "minecraft:block/nether_bricks" | "minecraft:item/empty_slot_hoe" | "minecraft:block/glowstone" | "minecraft:block/small_dripleaf_side" | "minecraft:item/diamond_chestplate" | "minecraft:item/cherry_boat" | "minecraft:block/allium" | "minecraft:block/light_gray_candle" | "irons_spellbooks:item/holy_rune" | "minecraft:block/bamboo_mosaic" | "minecraft:block/granite" | "minecraft:block/pink_wool" | "irons_spellbooks:item/plagued_helmet" | "minecraft:item/purple_candle" | "minecraft:item/crimson_hanging_sign" | "minecraft:trims/items/helmet_trim_iron" | "minecraft:item/raw_iron" | "irons_spellbooks:item/amethyst_resonance_charm" | "minecraft:trims/items/boots_trim_iron" | "minecraft:block/bamboo_small_leaves" | "minecraft:block/packed_ice" | "minecraft:block/brown_shulker_box" | "minecraft:block/ancient_debris_top" | "minecraft:block/brown_concrete" | "minecraft:item/bread" | "minecraft:block/slime_block" | "minecraft:block/stripped_cherry_log_top" | "minecraft:block/spruce_door_top" | "minecraft:block/structure_block_save" | "minecraft:block/potatoes_stage0" | "minecraft:item/beetroot_seeds" | "minecraft:block/potatoes_stage2" | "minecraft:block/potatoes_stage1" | "minecraft:block/chain_command_block_conditional" | "minecraft:block/potatoes_stage3" | "curios:slot/empty_necklace_slot" | "minecraft:block/quartz_block_top" | "minecraft:block/lava_flow" | "minecraft:block/dead_tube_coral_block" | "minecraft:item/warped_sign" | "irons_spellbooks:item/firebrand_gui" | "minecraft:item/light_blue_candle" | "minecraft:item/nautilus_shell" | "minecraft:block/green_stained_glass" | "minecraft:item/glow_berries" | "minecraft:item/splash_potion" | "minecraft:block/stripped_jungle_log_top" | "minecraft:block/yellow_stained_glass" | "minecraft:block/brain_coral_block" | "minecraft:block/loom_bottom" | "minecraft:item/iron_ingot" | "minecraft:block/farmland_moist" | "minecraft:block/spruce_planks" | "minecraft:block/coal_ore" | "irons_spellbooks:item/spell_book_models/diamond_spell_book" | "minecraft:block/brewing_stand" | "minecraft:item/music_disc_ward" | "minecraft:block/deepslate_diamond_ore" | "minecraft:block/redstone_block" | "minecraft:entity/enchanting_table_book" | "minecraft:item/iron_axe" | "minecraft:block/barrel_side" | "minecraft:block/polished_basalt_top" | "minecraft:block/detector_rail" | "minecraft:block/cyan_candle" | "irons_spellbooks:item/magehunter_gui" | "minecraft:block/oak_planks" | "minecraft:item/stick" | "minecraft:block/snow" | "minecraft:block/raw_copper_block" | "minecraft:item/brick" | "irons_spellbooks:item/fireward_ring" | "minecraft:block/cherry_log_top" | "minecraft:item/mangrove_boat" | "minecraft:item/firework_rocket" | "irons_spellbooks:item/cryomancer_boots" | "minecraft:block/raw_iron_block" | "minecraft:item/axolotl_bucket" | "minecraft:block/sandstone_top" | "minecraft:block/chorus_flower" | "minecraft:block/glass_pane_top" | "minecraft:block/water_still" | "minecraft:block/dark_oak_trapdoor" | "minecraft:block/lime_candle" | "minecraft:item/leather_leggings" | "kubejs:block/thin_fluid_still" | "minecraft:item/trident" | "minecraft:block/crimson_door_top" | "minecraft:block/pink_shulker_box" | "minecraft:block/dropper_front" | "minecraft:item/echo_shard" | "minecraft:entity/conduit/break_particle" | "minecraft:block/basalt_top" | "minecraft:block/jungle_log_top" | "minecraft:item/music_disc_otherside" | "minecraft:item/ender_pearl" | "minecraft:item/spire_armor_trim_smithing_template" | "irons_spellbooks:item/lesser_spell_slot_upgrade" | "minecraft:block/mangrove_door_top" | "minecraft:item/amethyst_shard" | "minecraft:block/green_glazed_terracotta" | "minecraft:block/purple_candle_lit" | "minecraft:item/wooden_shovel" | "minecraft:block/composter_bottom" | "irons_spellbooks:item/wandering_magician_helmet" | "minecraft:item/milk_bucket" | "minecraft:item/coast_armor_trim_smithing_template" | "irons_spellbooks:item/hither_thither_wand" | "minecraft:block/cactus_top" | "minecraft:block/smoker_top" | "minecraft:block/honey_block_top" | "forge:block/milk_still" | "minecraft:item/empty_slot_diamond" | "minecraft:block/gravel" | "irons_spellbooks:item/archevoker_boots" | "minecraft:block/diorite" | "minecraft:item/orange_dye" | "irons_spellbooks:item/wandering_magician_boots" | "minecraft:block/warped_trapdoor" | "minecraft:block/deepslate_iron_ore" | "minecraft:block/cake_bottom" | "moonlight:block/soft_fluids/magma_still" | "minecraft:item/bow" | "irons_spellbooks:item/cultist_chestplate" | "irons_spellbooks:item/invisibility_ring" | "irons_spellbooks:item/autoloader_crossbow_standby" | "irons_spellbooks:item/misery_gui" | "minecraft:block/respawn_anchor_side1" | "minecraft:block/respawn_anchor_side2" | "minecraft:block/respawn_anchor_side3" | "minecraft:block/respawn_anchor_side4" | "minecraft:block/respawn_anchor_side0" | "irons_spellbooks:item/affinity_ring_eldritch" | "minecraft:block/stripped_crimson_stem" | "minecraft:block/big_dripleaf_stem" | "minecraft:block/mangrove_leaves" | "irons_spellbooks:item/cryomancer_helmet" | "forge:white" | "minecraft:item/iron_horse_armor" | "minecraft:block/brown_candle_lit" | "minecraft:block/large_amethyst_bud" | "irons_spellbooks:item/priest_leggings" | "minecraft:item/music_disc_blocks" | "minecraft:item/sea_pickle" | "irons_spellbooks:item/evocation_rune" | "minecraft:block/red_glazed_terracotta" | "minecraft:item/cooked_beef" | "minecraft:item/glass_bottle" | "irons_spellbooks:item/scroll_evocation" | "geckolib:block/botarium" | "minecraft:block/melon_top" | "minecraft:item/end_crystal" | "kubejs:item/example_item" | "minecraft:block/sculk_catalyst_top_bloom" | "minecraft:block/nether_wart_stage1" | "minecraft:block/nether_wart_stage2" | "minecraft:block/nether_wart_stage0" | "minecraft:trims/items/chestplate_trim_diamond_darker" | "minecraft:block/acacia_door_bottom" | "minecraft:block/cauldron_inner" | "minecraft:block/chiseled_quartz_block" | "minecraft:item/music_disc_cat" | "minecraft:block/activator_rail_on" | "minecraft:item/crossbow_firework" | "minecraft:block/lime_wool" | "minecraft:item/empty_slot_redstone_dust" | "minecraft:block/light_gray_terracotta" | "minecraft:item/brewing_stand" | "minecraft:block/rose_bush_top" | "minecraft:block/twisting_vines_plant" | "minecraft:item/ghast_tear" | "irons_spellbooks:item/affinity_ring_lightning" | "minecraft:item/music_disc_11" | "minecraft:item/music_disc_13" | "irons_spellbooks:item/lightning_bottle" | "minecraft:block/gray_stained_glass_pane_top" | "irons_spellbooks:item/artificer_cane" | "minecraft:block/acacia_sapling" | "irons_spellbooks:item/enchanted_ward_amulet" | "minecraft:item/shaper_armor_trim_smithing_template" | "irons_spellbooks:item/scroll_ice" | "minecraft:block/chiseled_quartz_block_top" | "minecraft:item/ward_armor_trim_smithing_template" | "minecraft:trims/items/leggings_trim_amethyst" | "minecraft:item/redstone" | "minecraft:block/red_concrete" | "minecraft:block/jungle_log" | "minecraft:item/suspicious_stew" | "minecraft:block/cyan_terracotta" | "minecraft:block/bee_nest_top" | "irons_spellbooks:item/blood_rune" | "minecraft:block/sea_pickle" | "minecraft:item/dried_kelp" | "minecraft:item/chain" | "minecraft:block/spore_blossom" | "minecraft:block/composter_compost" | "minecraft:block/redstone_dust_line0" | "minecraft:block/redstone_dust_line1" | "minecraft:block/pink_glazed_terracotta" | "irons_spellbooks:item/upgrade_orb_ender" | "minecraft:item/light_gray_dye" | "minecraft:item/music_disc_pigstep" | "minecraft:item/spawn_egg_overlay" | "minecraft:block/blue_ice" | "minecraft:item/cake" | "minecraft:block/black_stained_glass" | "minecraft:block/purple_glazed_terracotta" | "minecraft:item/apple" | "minecraft:block/red_sandstone_bottom" | "minecraft:trims/items/chestplate_trim_diamond" | "minecraft:block/chiseled_deepslate" | "minecraft:block/beehive_front_honey" | "irons_spellbooks:item/evoker_spell_book" | "irons_spellbooks:block/scroll_forge_paper" | "minecraft:block/black_shulker_box" | "minecraft:block/cracked_nether_bricks" | "minecraft:block/mangrove_log" | "minecraft:block/sponge" | "minecraft:block/soul_campfire_fire" | "minecraft:block/soul_torch" | "minecraft:trims/items/boots_trim_quartz" | "minecraft:block/red_nether_bricks" | "minecraft:item/music_disc_chirp" | "minecraft:block/birch_trapdoor" | "minecraft:block/enchanting_table_side" | "minecraft:block/damaged_anvil_top" | "irons_spellbooks:item/graybeard_staff" | "minecraft:block/lime_glazed_terracotta" | "minecraft:block/composter_ready" | "irons_spellbooks:item/lightning_rune" | "minecraft:item/birch_boat" | "minecraft:item/golden_boots" | "minecraft:block/grass" | "minecraft:block/terracotta" | "minecraft:block/hopper_outside" | "minecraft:block/reinforced_deepslate_top" | "minecraft:block/red_stained_glass_pane_top" | "irons_spellbooks:item/uncommon_ink" | "minecraft:item/blue_dye" | "minecraft:block/pitcher_crop_bottom" | "minecraft:item/host_armor_trim_smithing_template" | "minecraft:block/stripped_birch_log" | "minecraft:block/cracked_deepslate_bricks" | "geckolib:block/fertilizer" | "minecraft:block/polished_blackstone" | "minecraft:block/warped_stem" | "minecraft:trims/items/chestplate_trim_iron_darker" | "minecraft:block/dark_oak_planks" | "minecraft:item/elytra" | "geckolib:item/wolf_armor_leggings" | "minecraft:item/minecart" | "irons_spellbooks:item/scroll_nature" | "minecraft:trims/items/leggings_trim_diamond_darker" | "minecraft:block/target_top" | "minecraft:block/pointed_dripstone_up_frustum" | "minecraft:item/saddle" | "irons_spellbooks:item/magehunter" | "minecraft:block/deepslate_tiles" | "minecraft:item/dark_oak_boat" | "minecraft:item/carrot_on_a_stick" | "minecraft:item/hopper" | "minecraft:block/cyan_glazed_terracotta" | "minecraft:block/bricks" | "minecraft:block/gray_terracotta" | "minecraft:item/recovery_compass_00" | "minecraft:item/recovery_compass_01" | "minecraft:item/recovery_compass_02" | "minecraft:item/recovery_compass_03" | "minecraft:item/recovery_compass_04" | "minecraft:item/recovery_compass_05" | "minecraft:item/recovery_compass_06" | "minecraft:item/recovery_compass_07" | "minecraft:item/recovery_compass_08" | "minecraft:item/recovery_compass_09" | "minecraft:item/oak_sign" | "minecraft:block/end_portal_frame_eye" | "minecraft:item/bamboo_raft" | "minecraft:block/blackstone" | "minecraft:item/command_block_minecart" | "minecraft:item/wooden_pickaxe" | "minecraft:item/tnt_minecart" | "minecraft:block/comparator_on" | "minecraft:item/magenta_candle" | "minecraft:item/recovery_compass_10" | "minecraft:block/turtle_egg_slightly_cracked" | "minecraft:block/kelp_plant" | "minecraft:block/tnt_side" | "minecraft:item/recovery_compass_13" | "minecraft:item/recovery_compass_14" | "minecraft:item/recovery_compass_15" | "minecraft:item/black_candle" | "minecraft:item/recovery_compass_17" | "minecraft:item/recovery_compass_18" | "minecraft:trims/items/boots_trim_diamond_darker" | "minecraft:item/recovery_compass_19" | "minecraft:item/recovery_compass_16" | "minecraft:block/spruce_door_bottom" | "minecraft:item/friend_pottery_sherd" | "minecraft:item/recovery_compass_11" | "minecraft:item/recovery_compass_12" | "minecraft:block/bone_block_top" | "minecraft:item/soul_lantern" | "minecraft:block/quartz_block_bottom" | "minecraft:block/sniffer_egg_very_cracked_bottom" | "minecraft:block/iron_door_top" | "minecraft:block/red_sandstone_top" | "irons_spellbooks:item/truthseeker_gui" | "minecraft:block/chiseled_bookshelf_occupied" | "irons_spellbooks:item/priest_helmet" | "minecraft:entity/conduit/base" | "minecraft:item/light_00" | "minecraft:item/light_01" | "minecraft:item/light_02" | "minecraft:item/light_03" | "minecraft:trims/items/boots_trim_copper" | "minecraft:item/light_05" | "minecraft:item/light_04" | "minecraft:item/snowball" | "minecraft:item/light_07" | "minecraft:item/light_06" | "minecraft:item/light_09" | "minecraft:item/light_08" | "minecraft:item/recovery_compass_28" | "minecraft:item/recovery_compass_29" | "irons_spellbooks:item/electromancer_helmet" | "minecraft:item/recovery_compass_24" | "minecraft:item/recovery_compass_25" | "minecraft:item/recovery_compass_26" | "minecraft:item/recovery_compass_27" | "minecraft:item/recovery_compass_20" | "minecraft:item/recovery_compass_21" | "minecraft:item/recovery_compass_22" | "minecraft:block/fletching_table_front" | "minecraft:item/recovery_compass_23" | "minecraft:item/prismarine_shard" | "minecraft:block/jungle_leaves" | "minecraft:block/orange_stained_glass_pane_top" | "minecraft:entity/conduit/wind" | "minecraft:block/suspicious_sand_2" | "minecraft:block/suspicious_sand_3" | "minecraft:block/suspicious_sand_0" | "minecraft:item/light_10" | "minecraft:item/light_11" | "minecraft:item/light_12" | "minecraft:item/light_13" | "minecraft:item/light_14" | "minecraft:item/light_15" | "minecraft:item/recovery_compass_31" | "minecraft:item/recovery_compass_30" | "geckolib:item/jack_in_the_box" | "minecraft:block/chain_command_block_side" | "minecraft:block/suspicious_sand_1" | "minecraft:block/packed_mud" | "minecraft:block/stone_bricks" | "minecraft:block/magenta_glazed_terracotta" | "kubejs:block/detector_on" | "minecraft:block/chiseled_bookshelf_empty" | "minecraft:block/blue_candle" | "minecraft:block/blue_concrete" | "minecraft:block/white_concrete_powder" | "irons_spellbooks:item/truthseeker" | "minecraft:item/lapis_lazuli" | "minecraft:block/sniffer_egg_very_cracked_north" | "minecraft:block/lightning_rod_on" | "minecraft:block/stonecutter_top" | "minecraft:block/dead_bubble_coral_block" | "minecraft:block/light_blue_terracotta" | "minecraft:block/powered_rail" | "irons_spellbooks:item/poisonward_ring" | "minecraft:block/obsidian" | "geckolib:item/wolf_armor_chestplate" | "minecraft:block/yellow_shulker_box" | "irons_spellbooks:item/archevoker_chestplate" | "minecraft:block/blue_stained_glass" | "minecraft:item/pink_dye" | "minecraft:item/bucket" | "minecraft:item/pumpkin_seeds" | "minecraft:item/empty_armor_slot_chestplate" | "minecraft:item/brush" | "irons_spellbooks:item/staff_of_the_nines_orb" | "minecraft:block/blast_furnace_front_on" | "minecraft:block/stripped_crimson_stem_top" | "minecraft:item/netherite_helmet" | "minecraft:item/clay_ball" | "minecraft:block/crimson_fungus" | "minecraft:block/redstone_lamp" | "irons_spellbooks:item/upgrade_orb_ice" | "minecraft:missingno" | "minecraft:item/cyan_dye" | "minecraft:block/vine" | "minecraft:trims/items/leggings_trim_quartz" | "minecraft:item/golden_horse_armor" | "irons_spellbooks:item/ruined_book" | "minecraft:block/blast_furnace_side" | "minecraft:block/redstone_ore" | "minecraft:item/lantern" | "minecraft:item/potion_overlay" | "minecraft:block/conduit" | "minecraft:block/light_gray_stained_glass_pane_top" | "minecraft:item/blaze_rod" | "minecraft:block/brown_glazed_terracotta" | "minecraft:block/pink_tulip" | "minecraft:block/furnace_front" | "minecraft:block/brown_mushroom_block" | "minecraft:block/sculk_shrieker_bottom" | "minecraft:item/diamond" | "minecraft:block/prismarine_bricks" | "minecraft:block/sniffer_egg_very_cracked_west" | "minecraft:item/iron_leggings" | "irons_spellbooks:item/silver_ring" | "minecraft:item/diamond_pickaxe" | "minecraft:item/iron_chestplate" | "minecraft:block/hopper_inside" | "minecraft:block/sniffer_egg_very_cracked_top" | "minecraft:item/netherite_axe" | "minecraft:item/netherite_sword" | "minecraft:block/pitcher_crop_top_stage_3" | "minecraft:block/pitcher_crop_top_stage_4" | "irons_spellbooks:item/arcane_salvage" | "irons_spellbooks:item/keeper_flamberge" | "minecraft:item/music_disc_strad" | "irons_spellbooks:item/wandering_magician_leggings" | "irons_spellbooks:item/netherite_mage_boots" | "irons_spellbooks:item/blood_vial" | "minecraft:item/filled_map_markings" | "irons_spellbooks:item/upgrade_orb_nature" | "irons_spellbooks:block/inscription_table_top" | "irons_spellbooks:block/armor_pile" | "minecraft:block/peony_bottom" | "curios:slot/empty_belt_slot" | "moonlight:block/soft_fluids/dragon_breath_liquid" | "minecraft:item/bamboo_hanging_sign" | "minecraft:block/ochre_froglight_side" | "minecraft:block/magenta_candle" | "minecraft:block/red_shulker_box" | "minecraft:block/sunflower_top" | "minecraft:item/netherite_shovel" | "minecraft:item/experience_bottle" | "minecraft:item/dune_armor_trim_smithing_template" | "irons_spellbooks:item/scroll" | "minecraft:block/carrots_stage0" | "minecraft:block/carrots_stage1" | "minecraft:block/carrots_stage2" | "minecraft:block/carrots_stage3" | "minecraft:block/exposed_copper" | "minecraft:block/lectern_top" | "minecraft:item/shears" | "minecraft:trims/items/leggings_trim_iron" | "minecraft:trims/items/leggings_trim_redstone" | "minecraft:trims/items/boots_trim_gold_darker" | "minecraft:block/furnace_top" | "minecraft:block/dirt_path_side" | "irons_spellbooks:block/pedestal_side" | "minecraft:trims/items/boots_trim_amethyst" | "irons_spellbooks:block/scroll_forge_top" | "irons_spellbooks:item/cultist_leggings" | "minecraft:block/smithing_table_bottom" | "minecraft:item/magma_cream" | "geckolib:item/armor/gecko_armor" | "minecraft:item/spruce_sign" | "minecraft:block/hanging_roots" | "minecraft:block/jungle_trapdoor" | "minecraft:block/ladder" | "minecraft:block/bell_side" | "minecraft:block/blue_terracotta" | "minecraft:block/chorus_flower_dead" | "minecraft:item/acacia_door" | "minecraft:item/heartbreak_pottery_sherd" | "minecraft:trims/items/leggings_trim_copper" | "minecraft:item/chicken" | "minecraft:item/tadpole_bucket" | "minecraft:item/fishing_rod_cast" | "minecraft:block/yellow_glazed_terracotta" | "geckolib:item/armor/gecko_armor_glowmask" | "minecraft:block/light_gray_candle_lit" | "irons_spellbooks:item/nature_rune" | "minecraft:block/observer_front" | "minecraft:block/fern" | "minecraft:block/oxidized_copper" | "minecraft:item/mangrove_chest_boat" | "minecraft:block/attached_melon_stem" | "minecraft:block/magenta_stained_glass" | "minecraft:block/magenta_shulker_box" | "curios:slot/empty_cosmetic_slot" | "irons_spellbooks:item/pumpkin_boots" | "irons_spellbooks:block/arcane_debris_top" | "minecraft:block/cobblestone" | "minecraft:block/loom_top" | "minecraft:block/dripstone_block" | "minecraft:item/purple_dye" | "irons_spellbooks:item/root" | "minecraft:item/burn_pottery_sherd" | "minecraft:block/kelp" | "minecraft:block/anvil" | "minecraft:block/stripped_jungle_log" | "minecraft:item/jungle_door" | "minecraft:block/cyan_candle_lit" | "minecraft:item/leather_boots_overlay" | "minecraft:item/mangrove_propagule" | "minecraft:block/pitcher_crop_bottom_stage_2" | "minecraft:block/pitcher_crop_bottom_stage_3" | "minecraft:block/pitcher_crop_bottom_stage_4" | "minecraft:block/pitcher_crop_bottom_stage_1" | "minecraft:block/sunflower_back" | "minecraft:item/beef" | "minecraft:block/acacia_leaves" | "minecraft:item/disc_fragment_5" | "minecraft:block/cherry_trapdoor" | "minecraft:block/piston_top_sticky" | "minecraft:item/slime_ball" | "minecraft:block/green_wool" | "minecraft:item/furnace_minecart" | "minecraft:block/gold_ore" | "minecraft:block/glass" | "minecraft:item/empty_slot_lapis_lazuli" | "curios:slot/empty_hands_slot" | "minecraft:item/eye_armor_trim_smithing_template" | "minecraft:item/skull_pottery_sherd" | "irons_spellbooks:item/ice_staff" | "minecraft:item/chainmail_boots" | "minecraft:block/seagrass" | "minecraft:item/archer_pottery_sherd" | "minecraft:block/end_stone" | "irons_spellbooks:block/alchemist_cauldron_side" | "minecraft:item/arrow" | "minecraft:item/stone_sword" | "minecraft:block/grass_block_side" | "minecraft:item/warped_hanging_sign" | "minecraft:block/grindstone_round" | "irons_spellbooks:block/arcane_debris_side" | "minecraft:block/deepslate" | "moonlight:block/soft_fluids/potion_still" | "minecraft:block/calibrated_sculk_sensor_amethyst" | "minecraft:item/empty_armor_slot_boots" | "irons_spellbooks:item/lurker_ring" | "minecraft:block/gray_concrete_powder" | "minecraft:block/light_blue_concrete" | "minecraft:block/warped_door_bottom" | "minecraft:block/polished_blackstone_bricks" | "minecraft:item/compass_00" | "irons_spellbooks:item/villager_spell_book" | "minecraft:item/birch_chest_boat" | "minecraft:item/compass_02" | "minecraft:block/dark_oak_door_bottom" | "minecraft:item/spyglass" | "minecraft:item/compass_06" | "minecraft:item/compass_07" | "minecraft:item/compass_08" | "minecraft:item/compass_09" | "minecraft:item/compass_04" | "minecraft:item/compass_05" | "minecraft:item/compass_03" | "irons_spellbooks:item/autoloader_crossbow_arrow" | "minecraft:item/compass_01" | "minecraft:block/white_stained_glass_pane_top" | "minecraft:block/sculk_catalyst_side_bloom" | "minecraft:item/rabbit_stew" | "minecraft:block/sniffer_egg_slightly_cracked_north" | "minecraft:block/respawn_anchor_bottom" | "minecraft:block/bamboo_planks" | "minecraft:block/orange_wool" | "minecraft:item/empty_slot_sword" | "irons_spellbooks:item/patchouli_book" | "minecraft:item/spider_eye" | "irons_spellbooks:block/inscription_table_book" | "minecraft:block/budding_amethyst" | "minecraft:block/mangrove_roots_top" | "minecraft:item/compass_10" | "minecraft:block/bee_nest_front_honey" | "minecraft:item/compass_11" | "minecraft:item/iron_nugget" | "irons_spellbooks:item/netherite_mage_chestplate" | "minecraft:block/turtle_egg_very_cracked" | "forge:item/mask/bucket_fluid_cover" | "minecraft:item/compass_13" | "minecraft:item/compass_14" | "minecraft:item/compass_12" | "minecraft:item/compass_19" | "minecraft:item/compass_17" | "minecraft:block/big_dripleaf_side" | "minecraft:block/muddy_mangrove_roots_side" | "minecraft:block/peony_top" | "minecraft:item/birch_hanging_sign" | "minecraft:block/sunflower_front" | "minecraft:block/red_sandstone" | "minecraft:block/azalea_top" | "irons_spellbooks:item/armor/priest" | "minecraft:item/compass_18" | "minecraft:block/lectern_base" | "minecraft:item/compass_15" | "minecraft:item/howl_pottery_sherd" | "minecraft:block/candle_lit" | "minecraft:item/pufferfish" | "minecraft:item/compass_16" | "minecraft:item/sniffer_egg" | "minecraft:block/blackstone_top" | "minecraft:block/pointed_dripstone_down_frustum" | "minecraft:block/crimson_nylium" | "minecraft:item/diamond_hoe" | "minecraft:item/compass_20" | "minecraft:item/compass_22" | "minecraft:block/tnt_top" | "minecraft:item/compass_24" | "minecraft:item/compass_25" | "minecraft:item/stone_pickaxe" | "minecraft:block/bamboo_block" | "minecraft:item/golden_chestplate" | "minecraft:item/compass_28" | "irons_spellbooks:item/affinity_ring_blood" | "irons_spellbooks:item/spell_book_models/villager_spell_book" | "minecraft:item/blade_pottery_sherd" | "minecraft:item/compass_29" | "minecraft:item/compass_26" | "minecraft:item/compass_27" | "minecraft:item/compass_23" | "minecraft:item/compass_21" | "minecraft:block/respawn_anchor_top_off" | "minecraft:item/nether_star" | "irons_spellbooks:item/keeper_flamberge_gui" | "minecraft:block/cyan_stained_glass_pane_top" | "irons_spellbooks:item/spell_book_models/necronomicon_spell_book" | "minecraft:block/soul_sand" | "minecraft:item/compass_31" | "minecraft:item/compass_30" | "minecraft:block/end_rod" | "irons_spellbooks:item/fire_rune" | "minecraft:block/tube_coral_fan" | "curios:slot/empty_curio_slot" | "minecraft:block/pink_petals" | "minecraft:block/daylight_detector_inverted_top" | "minecraft:block/tinted_glass" | "minecraft:block/cobbled_deepslate" | "minecraft:block/sculk_catalyst_top" | "minecraft:block/pointed_dripstone_up_middle" | "minecraft:block/orange_stained_glass" | "minecraft:block/blast_furnace_front" | "minecraft:block/gray_candle_lit" | "minecraft:item/empty_slot_axe" | "minecraft:item/brown_candle" | "minecraft:block/shroomlight" | "minecraft:item/cod" | "minecraft:block/blue_wool" | "minecraft:item/diamond_horse_armor" | "minecraft:block/pink_candle" | "minecraft:item/golden_hoe" | "minecraft:entity/bell/bell_body" | "minecraft:block/beehive_end" | "minecraft:block/attached_pumpkin_stem" | "minecraft:item/feather" | "minecraft:item/bell" | "minecraft:item/baked_potato" | "minecraft:item/bamboo" | "irons_spellbooks:item/conjurers_talisman" | "minecraft:block/crafting_table_top" | "minecraft:block/mushroom_block_inside" | "minecraft:block/sunflower_bottom" | "minecraft:block/spruce_trapdoor" | "minecraft:block/stripped_acacia_log" | "minecraft:item/cherry_sign" | "minecraft:block/smoker_bottom" | "minecraft:block/end_stone_bricks" | "minecraft:item/crimson_door" | "minecraft:block/jigsaw_bottom" | "minecraft:block/observer_top" | "curios:slot/empty_charm_slot" | "minecraft:block/lime_stained_glass_pane_top" | "curios:slot/empty_back_slot" | "minecraft:block/yellow_wool" | "minecraft:block/blast_furnace_top" | "minecraft:item/sugar" | "irons_spellbooks:item/affinity_ring_ice" | "minecraft:block/twisting_vines" | "minecraft:block/cyan_concrete_powder" | "minecraft:item/lead" | "irons_spellbooks:item/netherite_spell_book_2" | "minecraft:block/oak_door_top" | "irons_spellbooks:item/compass/wayward_compass_02" | "irons_spellbooks:item/compass/wayward_compass_03" | "irons_spellbooks:item/compass/wayward_compass_01" | "irons_spellbooks:item/compass/wayward_compass_00" | "irons_spellbooks:item/compass/wayward_compass_06" | "minecraft:item/shelter_pottery_sherd" | "irons_spellbooks:item/compass/wayward_compass_08" | "irons_spellbooks:item/compass/wayward_compass_09" | "irons_spellbooks:item/compass/wayward_compass_07" | "irons_spellbooks:item/compass/wayward_compass_05" | "irons_spellbooks:item/compass/wayward_compass_04" | "minecraft:block/powered_rail_on" | "minecraft:block/cauldron_bottom" | "minecraft:trims/items/helmet_trim_iron_darker" | "minecraft:item/tipped_arrow_head" | "minecraft:block/dead_tube_coral" | "minecraft:block/sniffer_egg_not_cracked_bottom" | "minecraft:item/cod_bucket" | "minecraft:block/light_blue_candle_lit" | "minecraft:item/phantom_membrane" | "minecraft:block/yellow_stained_glass_pane_top" | "kubejs:block/thin_fluid_flow" | "minecraft:block/powder_snow" | "minecraft:block/orange_terracotta" | "irons_spellbooks:item/compass/wayward_compass_10" | "irons_spellbooks:item/compass/wayward_compass_11" | "irons_spellbooks:item/compass/wayward_compass_12" | "minecraft:block/piston_side" | "irons_spellbooks:item/compass/wayward_compass_14" | "irons_spellbooks:item/compass/wayward_compass_13" | "irons_spellbooks:item/cryomancer_chestplate" | "irons_spellbooks:item/compass/wayward_compass_17" | "irons_spellbooks:item/compass/wayward_compass_18" | "irons_spellbooks:item/compass/wayward_compass_19" | "irons_spellbooks:item/compass/wayward_compass_16" | "irons_spellbooks:item/compass/wayward_compass_15" | "irons_spellbooks:item/claymore_gui" | "minecraft:block/melon_stem" | "minecraft:item/flint_and_steel" | "minecraft:block/sniffer_egg_not_cracked_west" | "minecraft:block/cherry_log" | "minecraft:item/tropical_fish_bucket" | "minecraft:block/polished_granite" | "irons_spellbooks:item/archevoker_helmet" | "irons_spellbooks:item/compass/wayward_compass_20" | "irons_spellbooks:item/compass/wayward_compass_21" | "minecraft:block/sniffer_egg_not_cracked_north" | "irons_spellbooks:item/evasion_elixir" | "minecraft:block/weathered_copper" | "irons_spellbooks:item/compass/wayward_compass_25" | "irons_spellbooks:item/compass/wayward_compass_24" | "irons_spellbooks:item/compass/wayward_compass_23" | "minecraft:block/stripped_acacia_log_top" | "irons_spellbooks:item/compass/wayward_compass_22" | "irons_spellbooks:item/compass/wayward_compass_29" | "irons_spellbooks:item/compass/wayward_compass_28" | "minecraft:block/large_fern_top" | "irons_spellbooks:item/compass/wayward_compass_27" | "minecraft:block/exposed_cut_copper" | "irons_spellbooks:item/compass/wayward_compass_26" | "minecraft:item/wooden_sword" | "minecraft:item/netherite_pickaxe" | "minecraft:block/pitcher_crop_top" | "irons_spellbooks:item/upgrade_orb_evocation" | "minecraft:item/leather_leggings_overlay" | "minecraft:item/enchanted_book" | "minecraft:block/mangrove_trapdoor" | "minecraft:trims/items/chestplate_trim_amethyst" | "minecraft:block/white_shulker_box" | "minecraft:item/comparator" | "irons_spellbooks:item/compass/wayward_compass_30" | "minecraft:trims/items/helmet_trim_lapis" | "irons_spellbooks:item/compass/wayward_compass_31" | "minecraft:block/birch_door_bottom" | "minecraft:item/name_tag" | "minecraft:item/pumpkin_pie" | "minecraft:item/golden_shovel" | "minecraft:item/mangrove_sign" | "minecraft:block/hay_block_side" | "minecraft:block/mossy_cobblestone" | "minecraft:item/leather" | "minecraft:item/empty_slot_quartz" | "minecraft:item/brewer_pottery_sherd" | "minecraft:block/blue_shulker_box" | "minecraft:item/rotten_flesh" | "minecraft:block/oxidized_cut_copper" | "minecraft:block/lime_stained_glass" | "minecraft:block/blue_concrete_powder" | "minecraft:item/potion" | "minecraft:item/empty_slot_pickaxe" | "minecraft:block/warped_roots" | "minecraft:block/iron_block" | "minecraft:block/chain_command_block_back" | "minecraft:item/netherite_boots" | "minecraft:block/white_candle" | "minecraft:item/spruce_hanging_sign" | "minecraft:block/chiseled_bookshelf_top" | "minecraft:block/anvil_top" | "minecraft:block/cave_vines" | "minecraft:block/stripped_dark_oak_log_top" | "minecraft:block/crimson_door_bottom" | "minecraft:item/pitcher_pod" | "minecraft:trims/items/chestplate_trim_iron" | "minecraft:block/cobweb" | "irons_spellbooks:item/invisibility_elixir" | "minecraft:trims/items/boots_trim_redstone" | "minecraft:item/broken_elytra" | "minecraft:item/empty_slot_amethyst_shard" | "forge:item/mask/bucket_fluid_drip" | "minecraft:item/prismarine_crystals" | "minecraft:item/seagrass" | "minecraft:item/cherry_chest_boat" | "minecraft:block/scaffolding_bottom" | "minecraft:block/spore_blossom_base" | "minecraft:block/purple_stained_glass" | "minecraft:block/stonecutter_bottom" | "minecraft:block/wheat_stage0" | "minecraft:block/wheat_stage1" | "minecraft:block/dark_oak_log" | "minecraft:block/chain" | "minecraft:block/wheat_stage2" | "minecraft:block/wheat_stage3" | "minecraft:block/light_blue_candle" | "irons_spellbooks:item/upgrade_orb_mana" | "minecraft:block/wheat_stage4" | "minecraft:block/wheat_stage5" | "minecraft:block/acacia_log_top" | "minecraft:block/wheat_stage6" | "minecraft:block/wheat_stage7" | "irons_spellbooks:item/mageslayer_ring" | "minecraft:item/leather_helmet" | "minecraft:block/potted_flowering_azalea_bush_top" | "minecraft:block/deepslate_emerald_ore" | "minecraft:block/spruce_sapling" | "minecraft:item/chainmail_chestplate" | "minecraft:block/comparator" | "minecraft:block/lilac_bottom" | "irons_spellbooks:item/electromancer_leggings" | "minecraft:block/ancient_debris_side" | "minecraft:block/tall_grass_bottom" | "minecraft:block/grindstone_pivot" | "minecraft:block/purple_concrete_powder" | "minecraft:item/potato" | "irons_spellbooks:item/gold_spell_book" | "minecraft:block/oak_sapling" | "minecraft:block/stripped_birch_log_top" | "minecraft:block/repeater_on" | "minecraft:block/blue_glazed_terracotta" | "minecraft:block/amethyst_block" | "minecraft:block/target_side" | "minecraft:item/cooked_chicken" | "minecraft:block/stripped_bamboo_block" | "minecraft:item/bamboo_door" | "minecraft:block/jungle_door_bottom" | "minecraft:item/glistering_melon_slice" | "minecraft:block/red_tulip" | "minecraft:item/piglin_banner_pattern" | "minecraft:block/crimson_planks" | "minecraft:item/chest_minecart" | "minecraft:item/pufferfish_bucket" | "minecraft:item/bundle" | "minecraft:item/spruce_chest_boat" | "kubejs:block/thick_fluid_flow" | "minecraft:block/small_amethyst_bud" | "minecraft:item/crossbow_arrow" | "minecraft:block/command_block_conditional" | "minecraft:block/blue_candle_lit" | "moonlight:block/soft_fluids/soup_liquid" | "minecraft:block/iron_ore" | "forge:block/milk_flowing" | "minecraft:block/yellow_candle_lit" | "irons_spellbooks:item/ice_rune" | "minecraft:block/cartography_table_top" | "minecraft:block/stripped_warped_stem_top" | "minecraft:item/diamond_sword" | "minecraft:block/mangrove_planks" | "minecraft:item/bundle_filled" | "minecraft:item/empty_armor_slot_leggings" | "minecraft:item/scute" | "minecraft:item/light_blue_dye" | "minecraft:item/music_disc_mellohi" | "minecraft:block/lily_of_the_valley" | "minecraft:block/cherry_door_bottom" | "irons_spellbooks:item/misery" | "minecraft:block/dark_oak_sapling" | "minecraft:block/candle" | "minecraft:block/deepslate_top" | "minecraft:block/structure_block" | "minecraft:block/flowering_azalea_leaves" | "minecraft:block/pink_terracotta" | "minecraft:block/oak_log_top" | "minecraft:block/pitcher_crop_side" | "minecraft:item/golden_leggings" | "minecraft:block/water_flow" | "irons_spellbooks:item/plagued_leggings" | "minecraft:item/snout_armor_trim_smithing_template" | "minecraft:block/smoker_front" | "minecraft:block/white_tulip" | "minecraft:item/string" | "minecraft:item/silence_armor_trim_smithing_template" | "minecraft:item/tropical_fish" | "minecraft:trims/items/boots_trim_netherite" | "irons_spellbooks:item/ancient_knowledge_fragment" | "minecraft:trims/items/helmet_trim_diamond_darker" | "minecraft:item/pointed_dripstone" | "minecraft:item/warped_door" | "minecraft:block/debug" | "minecraft:item/oak_chest_boat" | "minecraft:block/verdant_froglight_top" | "irons_spellbooks:item/blank_rune" | "minecraft:block/medium_amethyst_bud" | "minecraft:item/music_disc_stal" | "minecraft:block/magenta_stained_glass_pane_top" | "irons_spellbooks:block/inscription_table_ink" | "minecraft:block/dried_kelp_side" | "minecraft:item/gray_candle" | "minecraft:block/enchanting_table_top" | "irons_spellbooks:item/gold_crown" | "minecraft:item/quartz" | "irons_spellbooks:item/pumpkin_helmet" | "irons_spellbooks:item/priest_boots" | "patchouli:item/book_cyan" | "minecraft:item/netherite_upgrade_smithing_template" | "minecraft:block/cracked_deepslate_tiles" | "irons_spellbooks:item/energized_core_energy" | "minecraft:block/light_gray_stained_glass" | "minecraft:item/green_dye" | "minecraft:block/diamond_ore" | "minecraft:block/clay" | "minecraft:item/cookie" | "minecraft:block/gray_shulker_box" | "minecraft:item/empty_slot_shovel" | "minecraft:block/lime_concrete" | "minecraft:item/raiser_armor_trim_smithing_template" | "minecraft:block/lime_concrete_powder" | "minecraft:item/writable_book" | "minecraft:block/sweet_berry_bush_stage0" | "minecraft:block/sweet_berry_bush_stage1" | "minecraft:block/sweet_berry_bush_stage2" | "minecraft:block/sweet_berry_bush_stage3" | "minecraft:item/birch_sign" | "minecraft:block/mangrove_propagule_hanging" | "irons_spellbooks:item/scroll_lightning" | "minecraft:item/cocoa_beans" | "minecraft:block/lectern_sides" | "minecraft:trims/items/leggings_trim_emerald" | "irons_spellbooks:item/pyromancer_boots" | "minecraft:item/glow_ink_sac" | "minecraft:block/potted_azalea_bush_plant" | "minecraft:block/muddy_mangrove_roots_top" | "minecraft:item/snort_pottery_sherd" | "minecraft:item/explorer_pottery_sherd" | "minecraft:block/fire_coral_fan" | "irons_spellbooks:item/cooldown_ring" | "minecraft:block/orange_candle" | "irons_spellbooks:block/water_still" | "minecraft:block/smooth_basalt" | "irons_spellbooks:item/pyromancer_chestplate" | "minecraft:block/black_candle" | "irons_spellbooks:block/inscription_table_side" | "minecraft:item/mangrove_hanging_sign" | "minecraft:block/cut_sandstone" | "minecraft:block/iron_door_bottom" | "minecraft:block/lever" | "minecraft:item/music_disc_relic" | "minecraft:block/red_terracotta" | "minecraft:item/dark_oak_sign" | "minecraft:item/diamond_shovel" | "minecraft:block/wither_rose" | "minecraft:trims/items/leggings_trim_netherite_darker" | "minecraft:item/nether_brick" | "minecraft:block/light_gray_glazed_terracotta" | "minecraft:block/sculk_catalyst_side" | "minecraft:block/hopper_top" | "minecraft:block/mangrove_door_bottom" | "minecraft:block/iron_trapdoor" | "minecraft:block/dried_kelp_top" | "moonlight:block/soft_fluids/milk_liquid" | "minecraft:block/light_gray_wool" | "irons_spellbooks:item/frozen_bone" | "minecraft:block/bamboo_large_leaves" | "irons_spellbooks:block/alchemist_cauldron" | "minecraft:block/deepslate_bricks" | "irons_spellbooks:item/rare_ink" | "irons_spellbooks:item/energized_core" | "irons_spellbooks:item/affinity_ring_nature" | "minecraft:block/lodestone_side" | "minecraft:block/smooth_stone" | "geckolib:block/default_box_side" | "minecraft:block/glow_item_frame" | "minecraft:block/pointed_dripstone_down_tip" | "minecraft:block/stripped_mangrove_log" | "minecraft:item/netherite_ingot" | "irons_spellbooks:item/cooldown_rune" | "minecraft:block/pointed_dripstone_down_tip_merge" | "minecraft:block/potted_flowering_azalea_bush_plant" | "minecraft:block/bubble_coral" | "minecraft:item/lingering_potion" | "irons_spellbooks:item/affinity_ring_ender" | "irons_spellbooks:item/netherite_spell_book" | "minecraft:item/honeycomb" | "minecraft:block/mossy_stone_bricks" | "minecraft:block/pumpkin_stem" | "minecraft:block/iron_bars" | "irons_spellbooks:item/pyromancer_helmet" | "minecraft:trims/items/chestplate_trim_redstone" | "minecraft:block/torchflower" | "minecraft:block/cyan_shulker_box" | "minecraft:block/green_stained_glass_pane_top" | "minecraft:trims/items/helmet_trim_emerald" | "minecraft:block/warped_wart_block" | "irons_spellbooks:item/fire_ale" | "minecraft:item/arms_up_pottery_sherd" | "minecraft:item/plenty_pottery_sherd" | "minecraft:block/copper_ore" | "irons_spellbooks:item/upgrade_orb_base" | "irons_spellbooks:item/pyromancer_leggings" | "minecraft:item/vex_armor_trim_smithing_template" | "minecraft:block/orange_candle_lit" | "minecraft:item/netherite_leggings" | "minecraft:block/potted_flowering_azalea_bush_side" | "minecraft:block/nether_gold_ore" | "minecraft:block/frogspawn" | "minecraft:item/painting" | "minecraft:block/smoker_front_on" | "minecraft:item/torchflower_seeds" | "minecraft:item/green_candle" | "minecraft:item/goat_horn" | "minecraft:block/grass_block_top" | "minecraft:block/stripped_cherry_log" | "minecraft:item/acacia_boat" | "minecraft:block/respawn_anchor_top" | "minecraft:item/popped_chorus_fruit" | "minecraft:item/salmon_bucket" | "irons_spellbooks:item/spell_book_models/dragonskin_spell_book" | "minecraft:block/dead_horn_coral_fan" | "minecraft:block/piston_bottom" | "minecraft:block/jungle_planks" | "minecraft:block/barrel_bottom" | "minecraft:block/lapis_block" | "patchouli:item/book_blue" | "minecraft:block/command_block_side" | "irons_spellbooks:item/ender_rune" | "minecraft:block/small_dripleaf_stem_top" | "minecraft:item/jungle_chest_boat" | "minecraft:item/brown_dye" | "minecraft:block/sculk_shrieker_top" | "minecraft:item/melon_slice" | "minecraft:trims/items/boots_trim_emerald" | "minecraft:item/chainmail_helmet" | "minecraft:item/orange_candle" | "minecraft:block/lapis_ore" | "minecraft:block/calcite" | "minecraft:block/purple_wool" | "minecraft:item/jungle_boat" | "kubejs:item/fluid" | "minecraft:block/fletching_table_side" | "minecraft:item/structure_void" | "minecraft:item/filled_map" | "minecraft:block/crimson_stem_top" | "minecraft:block/stripped_mangrove_log_top" | "irons_spellbooks:item/spell_book_models/rotten_spell_book" | "minecraft:block/polished_basalt_side" | "minecraft:block/stripped_bamboo_block_top" | "minecraft:block/honey_block_bottom" | "irons_spellbooks:item/upgrade_orb_protection" | "minecraft:block/tuff" | "minecraft:item/turtle_egg" | "minecraft:block/quartz_pillar_top" | "minecraft:block/chorus_plant" | "minecraft:block/dispenser_front_vertical" | "minecraft:block/command_block_front" | "minecraft:item/gold_ingot" | "minecraft:item/mojang_banner_pattern" | "minecraft:block/green_shulker_box" | "irons_spellbooks:item/eldritch_manuscript" | "minecraft:block/smithing_table_front" | "minecraft:block/sculk_sensor_bottom" | "minecraft:block/pearlescent_froglight_side" | "irons_spellbooks:item/electromancer_boots" | "minecraft:block/orange_concrete_powder" | "minecraft:item/barrier" | "minecraft:block/barrel_top_open" | "minecraft:block/cherry_leaves" | "minecraft:block/magenta_terracotta" | "minecraft:block/note_block" | "irons_spellbooks:item/cultist_boots" | "minecraft:block/bee_nest_bottom" | "curios:slot/empty_head_slot" | "minecraft:block/jack_o_lantern" | "minecraft:item/sheaf_pottery_sherd" | "minecraft:item/empty_slot_ingot" | "minecraft:item/raw_copper" | "minecraft:block/sculk_shrieker_inner_top" | "minecraft:block/spruce_log" | "minecraft:block/honey_block_side" | "minecraft:item/golden_pickaxe" | "moonlight:block/soft_fluids/xp_still" | "minecraft:block/raw_gold_block" | "minecraft:item/blue_candle" | "irons_spellbooks:item/spellbreaker" | "irons_spellbooks:item/scroll_eldritch" | "minecraft:block/warped_fungus" | "irons_spellbooks:item/plagued_boots" | "minecraft:block/sculk_sensor_top" | "minecraft:block/yellow_concrete_powder" | "minecraft:block/lilac_top" | "irons_spellbooks:block/inscription_table" | "minecraft:block/birch_door_top" | "minecraft:item/coal" | "minecraft:block/crying_obsidian" | "minecraft:block/redstone_dust_overlay" | "irons_spellbooks:item/affinity_ring_fire" | "minecraft:block/dragon_egg" | "minecraft:item/rabbit_foot" | "minecraft:item/empty_armor_slot_shield" | "irons_spellbooks:item/dev_staff" | "irons_spellbooks:item/lightning_rod" | "minecraft:item/ink_sac" | "minecraft:item/miner_pottery_sherd" | "minecraft:block/red_stained_glass" | "minecraft:block/turtle_egg" | "minecraft:block/bamboo_stage0" | "minecraft:block/glow_lichen" | "minecraft:block/bell_bottom" | "minecraft:item/angler_pottery_sherd" | "minecraft:item/oak_door" | "minecraft:block/dead_fire_coral" | "minecraft:item/cherry_hanging_sign" | "minecraft:block/melon_side" | "minecraft:block/cracked_stone_bricks" | "minecraft:block/weeping_vines" | "irons_spellbooks:item/spell_book_models/copper_spell_book" | "minecraft:block/cave_vines_plant_lit" | "minecraft:trims/items/leggings_trim_netherite" | "minecraft:item/diamond_boots" | "minecraft:block/suspicious_gravel_0" | "minecraft:block/suspicious_gravel_1" | "minecraft:block/suspicious_gravel_2" | "minecraft:block/suspicious_gravel_3" | "irons_spellbooks:item/common_ink" | "irons_spellbooks:block/scroll_forge_side" | "minecraft:block/cyan_concrete" | "minecraft:block/tall_grass_top" | "minecraft:block/chiseled_nether_bricks" | "irons_spellbooks:item/concentration_amulet" | "irons_spellbooks:item/emerald_stoneplate_ring" | "minecraft:block/podzol_top" | "minecraft:item/rabbit_hide" | "minecraft:block/white_wool" | "minecraft:block/ice" | "minecraft:item/wheat_seeds" | "minecraft:item/firework_star_overlay" | "minecraft:item/lime_dye" | "minecraft:item/golden_carrot" | "minecraft:item/hopper_minecart" | "irons_spellbooks:item/temp_spellbook" | "minecraft:block/pink_candle_lit" | "minecraft:block/chiseled_sandstone" | "minecraft:item/item_frame" | "minecraft:block/composter_side" | "irons_spellbooks:item/weapon_schematics" | "minecraft:block/sculk_sensor_tendril_active" | "minecraft:item/bamboo_chest_raft" | "minecraft:block/orange_glazed_terracotta" | "minecraft:block/acacia_door_top" | "minecraft:item/stone_hoe" | "minecraft:block/grindstone_side" | "minecraft:trims/items/chestplate_trim_gold_darker" | "minecraft:block/dispenser_front" | "minecraft:block/green_concrete" | "minecraft:block/jigsaw_top" | "minecraft:entity/conduit/closed_eye" | "minecraft:item/golden_helmet" | "minecraft:block/calibrated_sculk_sensor_input_side" | "geckolib:item/armor/wolf_armor" | "minecraft:item/cooked_porkchop" | "minecraft:block/white_concrete" | "minecraft:block/black_stained_glass_pane_top" | "minecraft:block/sniffer_egg_slightly_cracked_west" | "minecraft:item/fire_charge" | "minecraft:block/structure_block_corner" | "patchouli:item/book_purple" | "minecraft:block/tnt_bottom" | "minecraft:block/weeping_vines_plant" | "minecraft:block/repeating_command_block_conditional" | "minecraft:block/yellow_concrete" | "minecraft:block/crimson_roots_pot" | "minecraft:block/fire_coral" | "minecraft:block/piston_top" | "minecraft:block/acacia_planks" | "minecraft:trims/items/chestplate_trim_quartz" | "irons_spellbooks:item/diamond_spell_book" | "minecraft:item/diamond_axe" | "minecraft:block/sniffer_egg_very_cracked_east" | "minecraft:block/blue_orchid" | "curios:slot/spellbook_slot" | "minecraft:trims/items/helmet_trim_gold" | "minecraft:item/raw_gold" | "minecraft:block/bamboo_block_top" | "minecraft:trims/items/boots_trim_gold" | "minecraft:block/cracked_polished_blackstone_bricks" | "irons_spellbooks:item/autoloader_crossbow_firework" | "minecraft:block/bamboo_fence_gate_particle" | "minecraft:block/jukebox_side" | "minecraft:block/jigsaw_lock" | "minecraft:block/brown_candle" | "minecraft:block/dirt_path_top" | "minecraft:block/crimson_trapdoor" | "minecraft:block/cave_vines_lit" | "minecraft:item/tipped_arrow_base" | "minecraft:block/cauldron_side" | "minecraft:item/netherite_scrap" | "minecraft:block/big_dripleaf_tip" | "minecraft:block/purpur_pillar" | "minecraft:item/cauldron" | "irons_spellbooks:item/magic_cloth" | "minecraft:block/red_mushroom_block" | "minecraft:item/kelp" | "minecraft:block/azalea_leaves" | "minecraft:block/activator_rail" | "minecraft:block/andesite" | "minecraft:block/stripped_warped_stem" | "minecraft:block/redstone_torch_off" | "minecraft:item/spawn_egg" | "moonlight:block/soft_fluids/potion_flow" | "minecraft:item/iron_helmet" | "minecraft:block/grass_block_snow" | "minecraft:block/sculk" | "geckolib:item/gecko_armor_chestplate" | "minecraft:block/horn_coral_block" | "minecraft:block/smithing_table_side" | "minecraft:block/sea_lantern" | "minecraft:block/bell_top" | "minecraft:block/red_candle_lit" | "minecraft:item/golden_axe" | "minecraft:item/blaze_powder" | "irons_spellbooks:block/pedestal_top" | "irons_spellbooks:item/spell_book_models/netherite_spell_book" | "kubejs:block/thick_fluid_still" | "irons_spellbooks:block/scroll_forge_top_side" | "minecraft:block/cartography_table_side1" | "minecraft:block/cartography_table_side2" | "minecraft:block/cartography_table_side3" | "minecraft:block/bone_block_side" | "irons_spellbooks:item/furled_map" | "minecraft:block/pointed_dripstone_up_tip_merge" | "irons_spellbooks:item/cultist_helmet" | "minecraft:block/dropper_front_vertical" | "minecraft:block/dried_kelp_bottom" | "minecraft:item/totem_of_undying" | "minecraft:block/cactus_side" | "minecraft:block/tube_coral" | "minecraft:block/dead_brain_coral_block" | "forge:item/mask/bucket_fluid" | "minecraft:item/wooden_hoe" | "minecraft:block/bamboo_door_top" | "minecraft:item/crossbow_pulling_0" | "minecraft:item/crossbow_pulling_1" | "minecraft:item/crossbow_pulling_2" | "minecraft:item/danger_pottery_sherd" | "minecraft:block/sniffer_egg_very_cracked_south" | "minecraft:block/dirt" | "minecraft:block/red_wool" | "irons_spellbooks:item/cloth" | "minecraft:block/tall_seagrass_top" | "minecraft:block/magma" | "minecraft:block/orange_tulip" | "minecraft:item/wild_armor_trim_smithing_template" | "minecraft:block/oak_trapdoor" | "minecraft:block/birch_sapling" | "minecraft:item/honey_bottle" | "minecraft:block/copper_block" | "minecraft:block/flowering_azalea_side" | "irons_spellbooks:item/wandering_magician_chestplate" | "irons_spellbooks:item/druidic_spell_book" | "minecraft:item/water_bucket" | "minecraft:item/flower_pot" | "minecraft:item/leather_chestplate" | "minecraft:block/stripped_spruce_log_top" | "minecraft:item/white_dye" | "minecraft:item/gunpowder" | "minecraft:block/light_blue_shulker_box" | "minecraft:block/mycelium_side" | "minecraft:block/cut_copper" | "minecraft:block/birch_leaves" | "minecraft:trims/items/chestplate_trim_copper" | "irons_spellbooks:item/affinity_ring_holy" | "minecraft:item/sweet_berries" | "minecraft:item/dark_oak_hanging_sign" | "minecraft:item/bone_meal" | "minecraft:block/furnace_front_on" | "minecraft:block/warped_nylium" | "minecraft:item/iron_shovel" | "minecraft:item/spruce_door" | "minecraft:block/barrel_top" | "irons_spellbooks:item/spell_book_models/iron_spell_book" | "minecraft:block/gray_stained_glass" | "minecraft:block/detector_rail_on" | "minecraft:item/iron_door" | "minecraft:block/bamboo_fence_particle" | "minecraft:block/chiseled_bookshelf_side" | "minecraft:block/cake_top" | "minecraft:item/written_book" | "irons_spellbooks:block/firefly_jar" | "minecraft:block/big_dripleaf_top" | "minecraft:block/sculk_shrieker_side" | "minecraft:block/torch" | "minecraft:item/rabbit" | "minecraft:item/cooked_rabbit" | "minecraft:block/polished_diorite" | "irons_spellbooks:item/scroll_blood" | "irons_spellbooks:item/dragonskin_spell_book" | "minecraft:block/quartz_block_side" | "minecraft:item/globe_banner_pattern" | "minecraft:item/cyan_candle" | "minecraft:block/smoker_side" | "minecraft:block/quartz_bricks" | "minecraft:item/empty_slot_smithing_template_netherite_upgrade" | "minecraft:block/crafting_table_side" | "minecraft:block/flower_pot" | "minecraft:item/beetroot" | "minecraft:block/spruce_log_top" | "minecraft:block/beehive_front" | "minecraft:entity/decorated_pot/decorated_pot_side" | "minecraft:item/music_disc_5" | "minecraft:item/light" | "irons_spellbooks:item/arcane_essence" | "minecraft:block/torchflower_crop_stage0" | "minecraft:block/torchflower_crop_stage1" | "minecraft:item/warped_fungus_on_a_stick" | "minecraft:block/chiseled_stone_bricks" | "minecraft:block/reinforced_deepslate_bottom" | "minecraft:item/lime_candle" | "irons_spellbooks:item/firebrand" | "minecraft:block/small_dripleaf_stem_bottom" | "minecraft:item/iron_pickaxe" | "minecraft:block/quartz_pillar" | "minecraft:block/rose_bush_bottom" | "minecraft:block/nether_quartz_ore" | "forge:item/mask/bucket_fluid_cover_drip" | "minecraft:block/spruce_leaves" | "minecraft:block/deepslate_coal_ore" | "minecraft:block/tripwire" | "minecraft:block/emerald_block" | "minecraft:block/black_concrete" | "minecraft:block/weathered_cut_copper" | "minecraft:block/end_portal_frame_side" | "irons_spellbooks:item/amethyst_rapier_gui" | "minecraft:block/moss_block" | "minecraft:item/diamond_helmet" | "minecraft:block/oak_leaves" | "minecraft:item/red_candle" | "minecraft:block/structure_block_load" | "geckolib:item/wolf_armor_boots" | "irons_spellbooks:item/dragonskin" | "minecraft:block/dead_horn_coral" | "minecraft:block/wet_sponge" | "irons_spellbooks:item/cool_book" | "minecraft:block/daylight_detector_side" | "minecraft:block/jukebox_top" | "minecraft:block/magenta_candle_lit" | "minecraft:item/ender_eye" | "minecraft:item/chorus_fruit" | "minecraft:trims/items/leggings_trim_gold_darker" | "geckolib:block/default_box_top" | "minecraft:block/dark_oak_log_top" | "minecraft:block/bamboo_stalk" | "minecraft:block/bee_nest_side" | "minecraft:item/rib_armor_trim_smithing_template" | "minecraft:item/empty_slot_smithing_template_armor_trim" | "minecraft:block/command_block_back" | "minecraft:item/skull_banner_pattern" | "minecraft:trims/items/boots_trim_lapis" | "minecraft:block/pumpkin_side" | "minecraft:block/stripped_spruce_log" | "minecraft:block/bee_nest_front" | "minecraft:block/poppy" | "patchouli:item/book_brown" | "minecraft:block/pointed_dripstone_up_base" | "minecraft:block/sandstone_bottom" | "minecraft:item/yellow_dye" | "minecraft:block/light_gray_concrete_powder" | "minecraft:trims/items/leggings_trim_lapis" | "irons_spellbooks:item/dreadsword" | "minecraft:block/tall_seagrass_bottom" | "minecraft:item/magenta_dye" | "minecraft:block/dead_fire_coral_block" | "minecraft:item/map" | "minecraft:block/pointed_dripstone_down_middle" | "irons_spellbooks:item/affinity_ring_evocation" | "minecraft:item/iron_hoe" | "minecraft:block/cyan_wool" | "minecraft:block/campfire_log_lit" | "minecraft:block/red_candle" | "minecraft:block/podzol_side" | "minecraft:block/soul_lantern" | "irons_spellbooks:item/hogskin" | "minecraft:block/water_overlay" | "minecraft:item/spyglass_model" | "irons_spellbooks:item/upgrade_orb_swirl" | "minecraft:item/stone_shovel" | "irons_spellbooks:item/upgrade_orb_lightning" | "minecraft:block/dead_horn_coral_block" | "irons_spellbooks:item/plagued_chestplate" | "minecraft:block/basalt_side" | "minecraft:block/red_concrete_powder" | "minecraft:block/light_gray_shulker_box" | "geckolib:item/gecko_armor_leggings" | "minecraft:block/mud" | "minecraft:block/nether_portal" | "minecraft:block/purple_shulker_box" | "minecraft:item/fishing_rod" | "minecraft:block/horn_coral" | "irons_spellbooks:block/blood" | "minecraft:block/mycelium_top" | "minecraft:block/redstone_torch" | "minecraft:item/charcoal" | "minecraft:block/sculk_shrieker_can_summon_inner_top" | "minecraft:block/crimson_nylium_side" | "minecraft:item/cherry_door" | "minecraft:block/sniffer_egg_slightly_cracked_south" | "minecraft:block/sandstone" | "irons_spellbooks:item/frostward_ring" | "irons_spellbooks:item/scroll_fire" | "minecraft:item/carrot" | "minecraft:item/fermented_spider_eye" | "minecraft:block/dark_oak_door_top" | "minecraft:block/lime_terracotta" | "minecraft:item/porkchop" | "minecraft:block/prismarine" | "minecraft:block/stripped_dark_oak_log" | "minecraft:item/glow_item_frame" | "minecraft:block/smithing_table_top" | "irons_spellbooks:item/arcane_rune" | "minecraft:block/sniffer_egg_not_cracked_east" | "patchouli:item/book_green" | "minecraft:block/sculk_vein" | "minecraft:block/mud_bricks" | "minecraft:block/verdant_froglight_side" | "minecraft:item/leather_chestplate_overlay" | "minecraft:block/repeating_command_block_side" | "irons_spellbooks:item/arcane_ingot" | "minecraft:item/sugar_cane" | "minecraft:block/sand" | "minecraft:item/egg" | "kubejs:item/projectile" | "minecraft:block/farmland" | "minecraft:block/coal_block" | "irons_spellbooks:item/upgrade_orb_fire" | "minecraft:block/cherry_sapling" | "minecraft:block/pink_stained_glass_pane_top" | "irons_spellbooks:item/netherite_mage_helmet" | "geckolib:block/gecko_habitat" | "minecraft:trims/items/leggings_trim_diamond" | "minecraft:item/empty_slot_emerald" | "minecraft:block/potted_azalea_bush_side" | "minecraft:item/iron_sword" | "minecraft:block/warped_door_top" | "minecraft:block/frosted_ice_0" | "minecraft:block/frosted_ice_2" | "minecraft:block/frosted_ice_3" | "minecraft:block/frosted_ice_1" | "minecraft:block/warped_planks" | "minecraft:block/stripped_oak_log" | "minecraft:block/lily_pad" | "minecraft:block/jungle_sapling" | "minecraft:block/dead_brain_coral" | "minecraft:trims/items/helmet_trim_netherite_darker" | "minecraft:block/orange_shulker_box" | "minecraft:trims/items/helmet_trim_quartz" | "minecraft:block/beehive_side" | "minecraft:block/destroy_stage_0" | "minecraft:block/destroy_stage_1" | "minecraft:block/destroy_stage_2" | "minecraft:block/destroy_stage_3" | "minecraft:block/lantern" | "minecraft:block/destroy_stage_4" | "minecraft:block/destroy_stage_5" | "minecraft:block/destroy_stage_7" | "minecraft:block/destroy_stage_8" | "minecraft:block/destroy_stage_9" | "minecraft:block/destroy_stage_6" | "minecraft:block/polished_deepslate" | "minecraft:item/copper_ingot" | "irons_spellbooks:block/scroll_forge_bottom" | "irons_spellbooks:item/legendary_ink" | "irons_spellbooks:item/tarnished_crown" | "minecraft:block/repeating_command_block_front" | "minecraft:item/sentry_armor_trim_smithing_template" | "minecraft:block/redstone_lamp_on" | "minecraft:block/horn_coral_fan" | "minecraft:block/sugar_cane" | "minecraft:item/mangrove_door" | "minecraft:item/creeper_banner_pattern" | "minecraft:block/pointed_dripstone_down_base" | "minecraft:block/yellow_candle" | "minecraft:block/cyan_stained_glass" | "minecraft:block/purple_stained_glass_pane_top" | "minecraft:block/lectern_front" | "minecraft:block/dead_tube_coral_fan" | "irons_spellbooks:item/spell_book_models/evoker_spell_book" | "minecraft:block/jigsaw_side" | "minecraft:block/purple_concrete" | "minecraft:block/bamboo_singleleaf" | "irons_spellbooks:item/shadowwalker_leggings" | "minecraft:item/clock_00" | "minecraft:item/clock_01" | "minecraft:item/clock_02" | "minecraft:trims/items/boots_trim_iron_darker" | "minecraft:item/clock_03" | "minecraft:item/clock_04" | "minecraft:block/blue_stained_glass_pane_top" | "minecraft:item/clock_06" | "minecraft:item/clock_07" | "minecraft:item/clock_05" | "minecraft:item/clock_08" | "minecraft:item/clock_09" | "irons_spellbooks:item/blood_staff" | "minecraft:block/pumpkin_top" | "minecraft:block/loom_side" | "minecraft:trims/items/helmet_trim_gold_darker" | "minecraft:block/soul_soil" | "minecraft:item/clock_10" | "minecraft:item/clock_11" | "minecraft:item/clock_12" | "minecraft:item/clock_13" | "minecraft:block/netherite_block" | "minecraft:item/clock_14" | "irons_spellbooks:item/pumpkin_leggings" | "minecraft:item/nether_sprouts" | "minecraft:item/clock_17" | "irons_spellbooks:item/shriving_stone" | "minecraft:item/clock_18" | "minecraft:item/clock_15" | "minecraft:item/clock_16" | "minecraft:item/clock_19" | "minecraft:block/cactus_bottom" | "minecraft:item/soul_campfire" | "minecraft:block/gray_concrete" | "minecraft:block/black_terracotta" | "minecraft:block/magenta_wool" | "minecraft:block/soul_campfire_log_lit" | "irons_spellbooks:item/shadowwalker_chestplate" | "minecraft:item/clock_20" | "minecraft:item/clock_22" | "minecraft:block/observer_side" | "minecraft:block/dark_oak_leaves" | "minecraft:item/clock_24" | "minecraft:item/clock_25" | "minecraft:item/clock_23" | "minecraft:item/clock_28" | "minecraft:item/clock_29" | "minecraft:item/clock_26" | "minecraft:item/clock_27" | "minecraft:block/black_wool" | "minecraft:item/clock_21" | "minecraft:block/rooted_dirt" | "minecraft:trims/items/helmet_trim_diamond" | "minecraft:block/gray_candle" | "minecraft:block/repeater" | "minecraft:block/green_concrete_powder" | "minecraft:block/ochre_froglight_top" | "minecraft:block/nether_wart_block" | "minecraft:block/emerald_ore" | "minecraft:block/campfire_fire" | "minecraft:block/debug2" | "patchouli:item/book_red" | "minecraft:block/dandelion" | "irons_spellbooks:item/spell_book_models/blaze_spell_book" | "minecraft:block/light_blue_concrete_powder" | "minecraft:item/clock_33" | "minecraft:item/clock_34" | "minecraft:block/sniffer_egg_not_cracked_south" | "minecraft:item/clock_35" | "minecraft:item/white_candle" | "minecraft:item/clock_36" | "minecraft:block/green_candle" | "minecraft:item/clock_39" | "minecraft:item/clock_37" | "minecraft:item/clock_38" | "minecraft:block/green_terracotta" | "minecraft:item/clock_31" | "minecraft:block/redstone_dust_dot" | "irons_spellbooks:item/spell_book_models/druidic_spell_book" | "minecraft:item/clock_32" | "minecraft:trims/items/chestplate_trim_emerald" | "minecraft:item/lava_bucket" | "minecraft:block/azalea_side" | "minecraft:trims/items/helmet_trim_copper" | "minecraft:item/acacia_hanging_sign" | "minecraft:item/clock_30" | "irons_spellbooks:item/iron_spell_book" | "minecraft:block/piston_inner" | "minecraft:block/warped_roots_pot" | "irons_spellbooks:item/epic_ink" | "minecraft:item/clock_40" | "minecraft:item/clock_42" | "minecraft:block/bubble_coral_block" | "minecraft:item/clock_44" | "minecraft:item/clock_45" | "minecraft:item/clock_46" | "minecraft:item/clock_47" | "minecraft:item/clock_48" | "minecraft:item/clock_49" | "minecraft:item/clock_43" | "minecraft:item/clock_41" | "minecraft:block/cake_inner" | "minecraft:block/tripwire_hook" | "irons_spellbooks:item/electromancer_chestplate" | "irons_spellbooks:item/greater_healing_potion" | "minecraft:block/stonecutter_saw" | "minecraft:item/prize_pottery_sherd" | "minecraft:block/white_terracotta";
    type BakedModel = "minecraft:ghast_spawn_egg" | "minecraft:name_tag" | "minecraft:archer_pottery_sherd" | "minecraft:andesite_wall" | "minecraft:golden_horse_armor" | "minecraft:warped_slab" | "irons_spellbooks:item/affinity_ring_holy" | "minecraft:fire" | "minecraft:purple_candle_cake" | "minecraft:deepslate_tiles" | "minecraft:apple" | "minecraft:blackstone_stairs" | "minecraft:observer" | "minecraft:warped_fence" | "minecraft:bubble_coral_fan" | "irons_spellbooks:netherite_mage_leggings" | "minecraft:pink_wool" | "minecraft:light_gray_shulker_box" | "minecraft:bamboo_raft" | "minecraft:sculk" | "minecraft:orange_stained_glass_pane" | "minecraft:mangrove_fence" | "minecraft:kelp_plant" | "minecraft:skull_banner_pattern" | "minecraft:granite_stairs" | "minecraft:potted_dead_bush" | "minecraft:piglin_head" | "minecraft:cherry_planks" | "minecraft:dead_horn_coral_fan" | "minecraft:yellow_candle_cake" | "minecraft:iron_sword" | "irons_spellbooks:plagued_leggings" | "minecraft:loom" | "irons_spellbooks:furled_map" | "minecraft:firework_star" | "minecraft:beacon" | "minecraft:written_book" | "minecraft:honey_bottle" | "minecraft:dark_oak_wall_hanging_sign" | "minecraft:stripped_mangrove_log" | "minecraft:rabbit_stew" | "minecraft:tipped_arrow" | "irons_spellbooks:wandering_magician_leggings" | "minecraft:pumpkin_seeds" | "minecraft:white_dye" | "minecraft:gray_banner" | "minecraft:stripped_acacia_log" | "minecraft:tnt" | "minecraft:crimson_sign" | "minecraft:blade_pottery_sherd" | "minecraft:white_carpet" | "minecraft:gray_terracotta" | "minecraft:purple_wall_banner" | "irons_spellbooks:arcane_ingot" | "irons_spellbooks:item/scroll_blood" | "minecraft:iron_horse_armor" | "minecraft:birch_trapdoor" | "irons_spellbooks:item/keeper_flamberge_normal" | "minecraft:smooth_stone_slab" | "minecraft:arrow" | "minecraft:end_stone_brick_slab" | "minecraft:stripped_birch_wood" | "minecraft:dark_oak_leaves" | "minecraft:light_blue_dye" | "minecraft:waxed_oxidized_cut_copper_stairs" | "minecraft:bubble_coral" | "minecraft:wither_skeleton_skull" | "minecraft:potted_wither_rose" | "minecraft:iron_axe" | "minecraft:light_weighted_pressure_plate" | "minecraft:end_portal_frame" | "minecraft:netherite_boots" | "minecraft:purpur_stairs" | "minecraft:cobblestone_slab" | "minecraft:lime_dye" | "minecraft:sheaf_pottery_sherd" | "minecraft:terracotta" | "irons_spellbooks:claymore" | "minecraft:repeating_command_block" | "minecraft:stripped_dark_oak_log" | "minecraft:armor_stand" | "minecraft:pink_concrete_powder" | "minecraft:oak_planks" | "minecraft:evoker_spawn_egg" | "minecraft:spruce_leaves" | "minecraft:birch_hanging_sign" | "minecraft:wither_skeleton_spawn_egg" | "minecraft:yellow_terracotta" | "minecraft:vex_armor_trim_smithing_template" | "minecraft:mud_bricks" | "irons_spellbooks:pumpkin_chestplate" | "minecraft:ward_armor_trim_smithing_template" | "minecraft:chicken" | "minecraft:pink_candle" | "minecraft:carved_pumpkin" | "minecraft:oak_log" | "minecraft:diamond_hoe" | "minecraft:magenta_banner" | "irons_spellbooks:druidic_spell_book" | "minecraft:light" | "minecraft:soul_torch" | "minecraft:mossy_cobblestone" | "minecraft:calcite" | "minecraft:magenta_candle_cake" | "minecraft:cherry_wall_sign" | "irons_spellbooks:magehunter" | "minecraft:trident" | "minecraft:cherry_trapdoor" | "minecraft:golden_axe" | "minecraft:jungle_pressure_plate" | "minecraft:magma_cube_spawn_egg" | "minecraft:scute" | "minecraft:dark_oak_door" | "minecraft:cherry_chest_boat" | "minecraft:spruce_sapling" | "minecraft:cooked_beef" | "minecraft:acacia_pressure_plate" | "minecraft:crimson_roots" | "minecraft:frogspawn" | "minecraft:magenta_carpet" | "minecraft:jungle_button" | "irons_spellbooks:frozen_bone" | "irons_spellbooks:iron_spell_book" | "minecraft:item_frame" | "minecraft:silence_armor_trim_smithing_template" | "irons_spellbooks:protection_upgrade_orb" | "minecraft:tropical_fish_spawn_egg" | "minecraft:minecart" | "minecraft:clay_ball" | "irons_spellbooks:pyromancer_leggings" | "minecraft:iron_block" | "minecraft:bell" | "minecraft:brick_slab" | "irons_spellbooks:fireward_ring" | "minecraft:vex_spawn_egg" | "minecraft:dark_prismarine_stairs" | "minecraft:lime_banner" | "minecraft:eye_armor_trim_smithing_template" | "minecraft:orange_terracotta" | "minecraft:pink_stained_glass" | "minecraft:black_concrete" | "minecraft:conduit" | "minecraft:piston_head" | "minecraft:wandering_trader_spawn_egg" | "minecraft:light_gray_carpet" | "minecraft:potatoes" | "minecraft:dark_oak_log" | "minecraft:brown_mushroom" | "minecraft:stripped_warped_stem" | "minecraft:dark_oak_fence_gate" | "minecraft:dark_oak_stairs" | "minecraft:glistering_melon_slice" | "minecraft:brown_dye" | "minecraft:lime_stained_glass_pane" | "minecraft:waxed_copper_block" | "minecraft:grass_block" | "minecraft:magenta_concrete_powder" | "minecraft:green_terracotta" | "minecraft:water" | "minecraft:netherite_block" | "minecraft:iron_ingot" | "minecraft:tnt_minecart" | "irons_spellbooks:diamond_spell_book" | "minecraft:rotten_flesh" | "minecraft:leather_horse_armor" | "minecraft:smooth_red_sandstone_stairs" | "minecraft:polished_andesite" | "minecraft:oak_wall_sign" | "minecraft:acacia_door" | "minecraft:flower_pot" | "minecraft:lime_carpet" | "minecraft:white_banner" | "irons_spellbooks:item/affinity_ring_lightning" | "minecraft:shroomlight" | "irons_spellbooks:pedestal" | "irons_spellbooks:frostward_ring" | "minecraft:diamond_chestplate" | "minecraft:furnace_minecart" | "minecraft:cobweb" | "minecraft:weeping_vines" | "minecraft:stripped_spruce_log" | "minecraft:sandstone" | "minecraft:oak_door" | "irons_spellbooks:item/affinity_ring_blood" | "minecraft:water_cauldron" | "minecraft:scaffolding" | "minecraft:cartography_table" | "minecraft:crimson_wall_sign" | "irons_spellbooks:conjurers_talisman" | "irons_spellbooks:arcane_debris" | "minecraft:builtin/missing" | "minecraft:panda_spawn_egg" | "minecraft:spruce_sign" | "minecraft:crimson_fence_gate" | "minecraft:yellow_wall_banner" | "minecraft:splash_potion" | "minecraft:red_shulker_box" | "minecraft:damaged_anvil" | "minecraft:lily_of_the_valley" | "minecraft:end_stone_brick_stairs" | "minecraft:cooked_rabbit" | "minecraft:spider_eye" | "minecraft:orange_wall_banner" | "minecraft:bubble_coral_block" | "minecraft:green_candle_cake" | "minecraft:brown_terracotta" | "irons_spellbooks:affinity_ring" | "minecraft:light_gray_bed" | "minecraft:weathered_cut_copper_stairs" | "minecraft:soul_fire" | "minecraft:sandstone_wall" | "minecraft:waxed_exposed_cut_copper_stairs" | "minecraft:moving_piston" | "minecraft:bamboo_fence" | "minecraft:experience_bottle" | "minecraft:black_shulker_box" | "minecraft:comparator" | "minecraft:warped_wall_hanging_sign" | "minecraft:oak_stairs" | "minecraft:grass" | "minecraft:chain_command_block" | "minecraft:gray_candle" | "minecraft:bamboo_mosaic_stairs" | "minecraft:warped_wart_block" | "minecraft:small_dripleaf" | "minecraft:raw_gold" | "minecraft:zombified_piglin_spawn_egg" | "minecraft:polished_blackstone_bricks" | "minecraft:tube_coral" | "irons_spellbooks:priest_chestplate" | "minecraft:birch_fence" | "minecraft:heart_of_the_sea" | "minecraft:beef" | "minecraft:dark_oak_hanging_sign" | "minecraft:netherite_upgrade_smithing_template" | "minecraft:cut_copper" | "minecraft:light_blue_carpet" | "minecraft:warped_button" | "minecraft:orange_candle_cake" | "irons_spellbooks:patchouli_book" | "minecraft:decorated_pot" | "minecraft:smooth_quartz_slab" | "minecraft:polished_granite_stairs" | "irons_spellbooks:poisonward_ring" | "minecraft:ocelot_spawn_egg" | "irons_spellbooks:item/affinity_ring_evocation" | "minecraft:cyan_terracotta" | "minecraft:birch_sign" | "minecraft:horn_coral_wall_fan" | "minecraft:wooden_pickaxe" | "minecraft:end_portal" | "minecraft:magenta_concrete" | "minecraft:lava_bucket" | "irons_spellbooks:heavy_chain_necklace" | "minecraft:lectern" | "minecraft:dark_prismarine_slab" | "minecraft:oxidized_cut_copper_slab" | "minecraft:dark_oak_button" | "irons_spellbooks:tarnished_helmet" | "minecraft:campfire" | "minecraft:elytra" | "minecraft:iron_boots" | "minecraft:skeleton_spawn_egg" | "minecraft:light_gray_stained_glass" | "irons_spellbooks:rare_ink" | "minecraft:warped_stem" | "irons_spellbooks:nature_upgrade_orb" | "minecraft:green_concrete" | "minecraft:podzol" | "minecraft:lightning_rod" | "minecraft:spruce_wall_sign" | "minecraft:cyan_candle" | "minecraft:cyan_bed" | "minecraft:brown_mushroom_block" | "minecraft:azure_bluet" | "minecraft:red_stained_glass" | "minecraft:feather" | "minecraft:purple_wool" | "minecraft:waxed_exposed_cut_copper_slab" | "minecraft:mossy_stone_brick_stairs" | "minecraft:light_gray_banner" | "minecraft:infested_chiseled_stone_bricks" | "minecraft:polished_andesite_stairs" | "minecraft:birch_wall_hanging_sign" | "irons_spellbooks:fire_rune" | "minecraft:diamond" | "minecraft:mangrove_sign" | "minecraft:black_glazed_terracotta" | "minecraft:dark_oak_trapdoor" | "minecraft:cherry_stairs" | "minecraft:mud_brick_slab" | "minecraft:villager_spawn_egg" | "minecraft:stone_axe" | "minecraft:lilac" | "minecraft:respawn_anchor" | "minecraft:dead_brain_coral_wall_fan" | "minecraft:firework_rocket" | "minecraft:cactus" | "minecraft:pink_shulker_box" | "minecraft:ender_dragon_spawn_egg" | "minecraft:twisting_vines" | "minecraft:blue_glazed_terracotta" | "minecraft:brain_coral_block" | "minecraft:sandstone_stairs" | "minecraft:magenta_stained_glass" | "minecraft:purple_terracotta" | "minecraft:emerald" | "minecraft:nether_star" | "minecraft:note_block" | "minecraft:light_blue_concrete" |