/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class GlowingEyesLayer {
    public static final ResourceLocation EYE_TEXTURE = new ResourceLocation("irons_spellbooks", "textures/entity/purple_eyes.png");
    public static final RenderType EYES = RenderType.m_110488_((ResourceLocation)EYE_TEXTURE);

    public static EyeType getEyeType(LivingEntity entity) {
        if (ClientMagicData.getSyncedSpellData(entity).hasEffect(8L)) {
            return EyeType.Abyssal;
        }
        if (ClientMagicData.getSyncedSpellData(entity).hasEffect(128L)) {
            return EyeType.Planar_Sight;
        }
        return EyeType.None;
    }

    public static float getEyeScale(LivingEntity entity) {
        if (entity.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ItemRegistry.SHADOWWALKER_HELMET.get())) {
            return EyeType.Ender_Armor.scale;
        }
        if (ClientMagicData.getSyncedSpellData(entity).hasEffect(8L)) {
            return EyeType.Abyssal.scale;
        }
        if (ClientMagicData.getSyncedSpellData(entity).hasEffect(128L)) {
            return EyeType.Planar_Sight.scale;
        }
        return EyeType.None.scale;
    }

    public static enum EyeType {
        None(0.0f, 0.0f, 0.0f, 0.0f),
        Abyssal(1.0f, 1.0f, 1.0f, 1.0f),
        Planar_Sight(0.42f, 0.258f, 0.96f, 1.0f),
        Ender_Armor(0.816f, 0.0f, 1.0f, 1.15f);

        public final float r;
        public final float g;
        public final float b;
        public final float scale;

        private EyeType(float r, float g, float b, float scale) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.scale = scale;
        }
    }

    public static class Geo
    extends GeoRenderLayer<AbstractSpellCastingMob> {
        public Geo(GeoEntityRenderer<AbstractSpellCastingMob> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(PoseStack poseStack, AbstractSpellCastingMob animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
            EyeType eye = GlowingEyesLayer.getEyeType((LivingEntity)animatable);
            if (eye != EyeType.None) {
                bakedModel.getBone("head").ifPresent(headBone -> {
                    float scale = GlowingEyesLayer.getEyeScale((LivingEntity)animatable);
                    headBone.updateScale(scale, scale, scale);
                    this.getRenderer().renderChildBones(poseStack, (GeoAnimatable)animatable, headBone, EYES, bufferSource, buffer, true, partialTick, packedLight, packedOverlay, eye.r, eye.g, eye.b, 1.0f);
                });
            }
        }
    }

    public static class Vanilla<T extends LivingEntity, M extends HumanoidModel<T>>
    extends EyesLayer<T, M> {
        public Vanilla(RenderLayerParent pRenderer) {
            super(pRenderer);
        }

        public RenderType m_5708_() {
            return EYES;
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int pPackedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            EyeType eye = GlowingEyesLayer.getEyeType(livingEntity);
            if (eye != EyeType.None) {
                VertexConsumer vertexconsumer = multiBufferSource.m_6299_(this.m_5708_());
                float scale = GlowingEyesLayer.getEyeScale(livingEntity);
                poseStack.m_85841_(scale, scale, scale);
                ((HumanoidModel)this.m_117386_()).m_7695_(poseStack, vertexconsumer, 0xF00000, OverlayTexture.f_118083_, eye.r, eye.g, eye.b, 1.0f);
            }
        }
    }
}

