/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.mixin.perf.patchouli_deduplicate_books;

import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.annotation.RequiresMod;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vazkii.patchouli.client.book.BookContents;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookPage;
import vazkii.patchouli.client.book.ClientBookRegistry;
import vazkii.patchouli.client.book.page.PageTemplate;
import vazkii.patchouli.client.book.template.BookTemplate;
import vazkii.patchouli.client.book.template.TemplateComponent;
import vazkii.patchouli.client.book.template.component.ComponentItemStack;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;

@Mixin(value={ClientBookRegistry.class})
@RequiresMod(value="patchouli")
@ClientOnlyMixin
public class ClientBookRegistryMixin {
    @Inject(method={"reload"}, at={@At(value="RETURN")}, remap=false)
    private void performDeduplication(CallbackInfo ci) {
        Field templateField = ObfuscationReflectionHelper.findField(PageTemplate.class, (String)"template");
        Field contentsField = ObfuscationReflectionHelper.findField(Book.class, (String)"contents");
        Field componentsField = ObfuscationReflectionHelper.findField(BookTemplate.class, (String)"components");
        Field itemsField = ObfuscationReflectionHelper.findField(ComponentItemStack.class, (String)"items");
        int numItemsCleared = 0;
        for (Book book : BookRegistry.INSTANCE.books.values()) {
            try {
                BookContents contents = (BookContents)contentsField.get(book);
                if (contents == null || contents.entries == null) continue;
                for (BookEntry entry : contents.entries.values()) {
                    for (BookPage page : entry.getPages()) {
                        List components;
                        BookTemplate template;
                        if (!(page instanceof PageTemplate) || (template = (BookTemplate)templateField.get(page)) == null || (components = (List)componentsField.get(template)) == null) continue;
                        for (TemplateComponent component : components) {
                            ItemStack[] items;
                            if (!(component instanceof ComponentItemStack) || (items = (ItemStack[])itemsField.get(component)) == null) continue;
                            for (int i = 0; i < items.length; ++i) {
                                if (items[i] == null || items[i].m_41720_() != Items.f_41852_) continue;
                                ++numItemsCleared;
                                items[i] = ItemStack.f_41583_;
                            }
                        }
                    }
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
            }
        }
        ModernFix.LOGGER.info("Cleared {} unneeded book NBT tags", (Object)numItemsCleared);
    }
}

