/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class SoulSwordItem
extends UniqueSwordItem {
    private static int stepMod = 0;

    public SoulSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            int fhitchance = (int)Config.getFloat("soulMeldChance", "UniqueEffects", ConfigDefaultValues.soulMeldChance);
            int fduration = (int)Config.getFloat("soulMeldDuration", "UniqueEffects", ConfigDefaultValues.soulMeldDuration);
            HelperMethods.playHitSounds(attacker, target);
            if (attacker.m_217043_().m_188503_(100) <= fhitchance) {
                if (attacker.m_21023_(MobEffects.f_19599_) && attacker.m_21023_(MobEffects.f_19606_)) {
                    int a = attacker.m_21124_(MobEffects.f_19599_).m_19564_() + 1;
                    if (attacker.m_21124_(MobEffects.f_19599_).m_19564_() <= 2) {
                        attacker.m_147207_(new MobEffectInstance(MobEffects.f_19599_, fduration, a), (Entity)attacker);
                        attacker.m_147207_(new MobEffectInstance(MobEffects.f_19606_, fduration, a), (Entity)attacker);
                    }
                } else {
                    attacker.m_147207_(new MobEffectInstance(MobEffects.f_19599_, fduration, 1), (Entity)attacker);
                    attacker.m_147207_(new MobEffectInstance(MobEffects.f_19606_, fduration, 1), (Entity)attacker);
                }
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (!user.m_9236_().m_5776_()) {
            int hradius = (int)Config.getFloat("soulMeldRadius", "UniqueEffects", ConfigDefaultValues.soulMeldRadius);
            int vradius = (int)(Config.getFloat("soulMeldRadius", "UniqueEffects", ConfigDefaultValues.soulMeldRadius) / 2.0f);
            double x = user.m_20185_();
            double y = user.m_20186_();
            double z = user.m_20189_();
            ServerLevel serverWorld = (ServerLevel)user.m_9236_();
            AABB box = new AABB(x + (double)hradius, y + (double)vradius, z + (double)hradius, x - (double)hradius, y - (double)vradius, z - (double)hradius);
            for (Entity entity : serverWorld.m_6249_((Entity)user, box, EntitySelector.f_20403_)) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity le = (LivingEntity)entity;
                if (!user.m_21023_(MobEffects.f_19599_) || !HelperMethods.checkFriendlyFire((LivingEntity)entity, (LivingEntity)user)) continue;
                le.m_147207_(new MobEffectInstance(MobEffects.f_19599_, user.m_21124_(MobEffects.f_19599_).m_19557_(), user.m_21124_(MobEffects.f_19599_).m_19564_()), (Entity)user);
                world.m_6269_(null, entity, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_SCIFI_SHOOT_IMPACT_03.get(), entity.m_5720_(), 0.1f, 1.0f);
            }
            if (user.m_21023_(MobEffects.f_19599_) && user.m_21023_(MobEffects.f_19606_)) {
                user.m_147207_(new MobEffectInstance(MobEffects.f_19605_, user.m_21124_(MobEffects.f_19599_).m_19564_() * 40, 2), (Entity)user);
                user.m_21195_(MobEffects.f_19599_);
                user.m_21195_(MobEffects.f_19606_);
            }
        }
        return super.m_7203_(world, user, hand);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        HelperMethods.createFootfalls(entity, stack, world, stepMod, ParticleTypes.f_123746_, ParticleTypes.f_123746_, ParticleTypes.f_175833_, false);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style RIGHTCLICK = HelperMethods.getStyle("rightclick");
        Style ABILITY = HelperMethods.getStyle("ability");
        Style TEXT = HelperMethods.getStyle("text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.soulsworditem.tooltip1").m_6270_(ABILITY));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.soulsworditem.tooltip2").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.soulsworditem.tooltip3").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(RIGHTCLICK));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.soulsworditem.tooltip4").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.soulsworditem.tooltip5").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.soulsworditem.tooltip6").m_6270_(TEXT));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

