/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class LivyatanSwordItem
extends UniqueSwordItem {
    private static int stepMod = 0;
    public static boolean scalesWithSpellPower;
    int radius = (int)Config.getFloat("frostShatterRadius", "UniqueEffects", ConfigDefaultValues.frostShatterRadius);
    float abilityDamage = Config.getFloat("frostShatterDamage", "UniqueEffects", ConfigDefaultValues.frostShatterDamage);
    int proc_chance = (int)Config.getFloat("frostShatterChance", "UniqueEffects", ConfigDefaultValues.frostShatterChance);
    int shatter_timer_max = (int)Config.getFloat("frostShatterDuration", "UniqueEffects", ConfigDefaultValues.frostShatterDuration);
    float spellScalingModifier = Config.getFloat("frostShatterSpellScaling", "UniqueEffects", ConfigDefaultValues.frostShatterSpellScaling);
    int shatter_timer;
    int shatter_bonus;
    int player_shatter_timer;
    double lastX;
    double lastY;
    double lastZ;

    public LivyatanSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            ServerLevel world = (ServerLevel)attacker.m_9236_();
            HelperMethods.playHitSounds(attacker, target);
            if (attacker.m_217043_().m_188503_(100) <= this.proc_chance) {
                AABB box = new AABB(target.m_20185_() + (double)this.radius, target.m_20186_() + (double)this.radius, target.m_20189_() + (double)this.radius, target.m_20185_() - (double)this.radius, target.m_20186_() - (double)this.radius, target.m_20189_() - (double)this.radius);
                for (Entity entity : world.m_6249_((Entity)attacker, box, EntitySelector.f_20403_)) {
                    LivingEntity le;
                    if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, attacker)) continue;
                    le.m_147207_(new MobEffectInstance((MobEffect)EffectRegistry.FREEZE.get(), this.shatter_timer_max + 10, 0), (Entity)attacker);
                    le.m_147207_(new MobEffectInstance(MobEffects.f_19606_, this.shatter_timer_max - 10, 4), (Entity)attacker);
                    world.m_6269_(null, (Entity)le, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_ICE_SHOOT_IMPACT_01.get(), le.m_5720_(), 0.1f, 3.0f);
                    BlockPos pos = BlockPos.m_274561_((double)le.m_20185_(), (double)le.m_20186_(), (double)le.m_20189_());
                    BlockPos pos2 = BlockPos.m_274561_((double)le.m_20185_(), (double)(le.m_20186_() + 1.0), (double)le.m_20189_());
                    BlockState state = Blocks.f_50126_.m_49966_();
                    if (world.m_8055_(pos) == Blocks.f_50016_.m_49966_()) {
                        world.m_46597_(pos, state);
                    }
                    if (world.m_8055_(pos2) != Blocks.f_50016_.m_49966_()) continue;
                    world.m_46597_(pos2, state);
                }
                this.shatter_timer = this.shatter_timer_max;
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (!user.m_9236_().m_5776_() && this.shatter_timer > 0) {
            this.shatter_bonus = this.shatter_timer / 5;
            this.shatter_timer = 2;
        }
        return super.m_7203_(world, user, hand);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (HelperMethods.commonSpellAttributeScaling(this.spellScalingModifier, entity, "frost") > 0.0f) {
            this.abilityDamage = HelperMethods.commonSpellAttributeScaling(this.spellScalingModifier, entity, "frost");
            scalesWithSpellPower = true;
        }
        if (!world.f_46443_ && entity instanceof Player && this.shatter_timer > 0) {
            --this.shatter_timer;
            if (this.shatter_timer == 1) {
                AABB box = new AABB(entity.m_20185_() + (double)this.radius + 10.0, entity.m_20186_() + (double)this.radius + 10.0, entity.m_20189_() + (double)this.radius + 10.0, entity.m_20185_() - (double)this.radius - 10.0, entity.m_20186_() - (double)this.radius - 10.0, entity.m_20189_() - (double)this.radius - 10.0);
                for (Entity otherEntity : world.m_6249_(entity, box, EntitySelector.f_20403_)) {
                    if (!(otherEntity instanceof LivingEntity)) continue;
                    LivingEntity le = (LivingEntity)otherEntity;
                    if (le.m_21023_((MobEffect)EffectRegistry.FREEZE.get())) {
                        le.m_21195_((MobEffect)EffectRegistry.FREEZE.get());
                        le.m_21195_(MobEffects.f_19606_);
                        world.m_6269_(null, (Entity)le, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_ICE_SHOOT_IMPACT_02.get(), le.m_5720_(), 0.2f, 3.0f);
                        le.m_6469_(entity.m_269291_().m_269104_(entity, entity), this.abilityDamage + (float)this.shatter_bonus);
                    }
                    double xpos = le.m_20185_() - 2.0;
                    double ypos = le.m_20186_();
                    double zpos = le.m_20189_() - 2.0;
                    for (int i = 3; i > 0; --i) {
                        for (int j = 3; j > 0; --j) {
                            BlockPos poscheck = BlockPos.m_274561_((double)(xpos + (double)i), (double)ypos, (double)(zpos + (double)j));
                            BlockPos poscheck2 = BlockPos.m_274561_((double)(xpos + (double)i), (double)(ypos + 1.0), (double)(zpos + (double)j));
                            BlockPos poscheck3 = BlockPos.m_274561_((double)(xpos + (double)i), (double)(ypos + 2.0), (double)(zpos + (double)j));
                            BlockPos poscheck4 = BlockPos.m_274561_((double)(xpos + (double)i), (double)(ypos - 1.0), (double)(zpos + (double)j));
                            BlockState currentState = world.m_8055_(poscheck);
                            BlockState currentState2 = world.m_8055_(poscheck2);
                            BlockState currentState3 = world.m_8055_(poscheck3);
                            BlockState currentState4 = world.m_8055_(poscheck4);
                            BlockState state = Blocks.f_50016_.m_49966_();
                            if (currentState == Blocks.f_50126_.m_49966_() || currentState == Blocks.f_49990_.m_49966_()) {
                                world.m_46597_(poscheck, state);
                            }
                            if (currentState2 == Blocks.f_50126_.m_49966_() || currentState2 == Blocks.f_49990_.m_49966_()) {
                                world.m_46597_(poscheck2, state);
                            }
                            if (currentState3 == Blocks.f_50126_.m_49966_() || currentState3 == Blocks.f_49990_.m_49966_()) {
                                world.m_46597_(poscheck3, state);
                            }
                            if (currentState4 != Blocks.f_50126_.m_49966_() && currentState4 != Blocks.f_49990_.m_49966_()) continue;
                            world.m_46597_(poscheck4, state);
                        }
                    }
                }
                this.shatter_bonus = 0;
            }
        }
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        HelperMethods.createFootfalls(entity, stack, world, stepMod, ParticleTypes.f_175821_, ParticleTypes.f_175821_, ParticleTypes.f_123790_, true);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style RIGHTCLICK = HelperMethods.getStyle("rightclick");
        Style ABILITY = HelperMethods.getStyle("ability");
        Style TEXT = HelperMethods.getStyle("text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.livyatansworditem.tooltip1").m_6270_(ABILITY));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.livyatansworditem.tooltip2").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.livyatansworditem.tooltip3").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237110_((String)"item.simplyswords.livyatansworditem.tooltip4", (Object[])new Object[]{this.shatter_timer_max / 20, Float.valueOf(this.abilityDamage)}).m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(RIGHTCLICK));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.livyatansworditem.tooltip5").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.livyatansworditem.tooltip6").m_6270_(TEXT));
        if (scalesWithSpellPower) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.compat.scaleFrost"));
        }
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

