/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.Comparator;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.effect.instance.SimplySwordsStatusEffectInstance;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class FlamewindSwordItem
extends UniqueSwordItem {
    private static int stepMod = 0;
    public static boolean scalesWithSpellPower;

    public FlamewindSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            ServerLevel serverWorld = (ServerLevel)attacker.m_9236_();
            HelperMethods.playHitSounds(attacker, target);
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (!user.m_9236_().m_5776_() && world instanceof ServerLevel) {
            LivingEntity ee;
            ServerLevel serverWorld = (ServerLevel)world;
            int flameSeedDuration = 101;
            int flameSeedSpreadCap = (int)Config.getFloat("emberstormSpreadCap", "UniqueEffects", ConfigDefaultValues.emberstormSpreadCap);
            int skillCooldown = (int)Config.getFloat("emberstormCooldown", "UniqueEffects", ConfigDefaultValues.emberstormCooldown);
            AABB box = HelperMethods.createBox((Entity)user, 10);
            Entity closestEntity = world.m_6249_((Entity)user, box, EntitySelector.f_20403_).stream().min(Comparator.comparingDouble(entity -> entity.m_20280_((Entity)user))).orElse(null);
            if (closestEntity != null && closestEntity instanceof LivingEntity && HelperMethods.checkFriendlyFire(ee = (LivingEntity)closestEntity, (LivingEntity)user) && !ee.m_21023_((MobEffect)EffectRegistry.FLAMESEED.get())) {
                SoundEvent soundSelect = (SoundEvent)SoundRegistry.SPELL_FIRE.get();
                int particleCount = 20;
                HelperMethods.spawnWaistHeightParticles(serverWorld, (ParticleOptions)ParticleTypes.f_123756_, (Entity)user, (Entity)ee, particleCount);
                world.m_5594_(null, user.m_20183_(), soundSelect, user.m_5720_(), 0.3f, 1.3f);
                SimplySwordsStatusEffectInstance flamSeedEffect = new SimplySwordsStatusEffectInstance((MobEffect)EffectRegistry.FLAMESEED.get(), flameSeedDuration, 0, false, false, true);
                flamSeedEffect.setSourceEntity((LivingEntity)user);
                flamSeedEffect.setAdditionalData(flameSeedSpreadCap);
                ee.m_7292_((MobEffectInstance)flamSeedEffect);
                user.m_36335_().m_41524_((Item)this, skillCooldown);
            }
        }
        return super.m_7203_(world, user, hand);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (HelperMethods.commonSpellAttributeScaling(0.5f, entity, "fire") > 0.0f) {
            scalesWithSpellPower = true;
        }
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        HelperMethods.createFootfalls(entity, stack, world, stepMod, ParticleTypes.f_123744_, ParticleTypes.f_123744_, ParticleTypes.f_123783_, true);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style RIGHTCLICK = HelperMethods.getStyle("rightclick");
        Style ABILITY = HelperMethods.getStyle("ability");
        Style TEXT = HelperMethods.getStyle("text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.flamewindsworditem.tooltip1").m_6270_(ABILITY));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.flamewindsworditem.tooltip2").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.flamewindsworditem.tooltip3").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(RIGHTCLICK));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.flamewindsworditem.tooltip4").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.flamewindsworditem.tooltip5").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.flamewindsworditem.tooltip6").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.flamewindsworditem.tooltip7").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.flamewindsworditem.tooltip8").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.flamewindsworditem.tooltip9").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.flamewindsworditem.tooltip10").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237110_((String)"item.simplyswords.flamewindsworditem.tooltip11", (Object[])new Object[]{(int)Config.getFloat("emberstormSpreadCap", "UniqueEffects", ConfigDefaultValues.emberstormSpreadCap)}).m_6270_(TEXT));
        if (scalesWithSpellPower) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.compat.scaleFire"));
        }
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

