/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.data;

import io.github.mortuusars.exposure.camera.infrastructure.FocalRange;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.IPacket;
import io.github.mortuusars.exposure.network.packet.client.SyncLensesS2CP;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class Lenses {
    private static ConcurrentMap<Ingredient, FocalRange> lenses = new ConcurrentHashMap<Ingredient, FocalRange>();

    public static void reload(ConcurrentMap<Ingredient, FocalRange> newLenses) {
        lenses.clear();
        lenses = newLenses;
    }

    public static Optional<FocalRange> getFocalRangeOf(ItemStack stack) {
        for (Map.Entry lens : lenses.entrySet()) {
            if (!((Ingredient)lens.getKey()).test(stack)) continue;
            return Optional.of((FocalRange)lens.getValue());
        }
        return Optional.empty();
    }

    public static IPacket getSyncToClientPacket() {
        return new SyncLensesS2CP(new ConcurrentHashMap<Ingredient, FocalRange>(lenses));
    }

    public static void onDatapackSync(@Nullable ServerPlayer joiningPlayer) {
        IPacket packet = Lenses.getSyncToClientPacket();
        if (joiningPlayer != null) {
            Packets.sendToClient(packet, joiningPlayer);
        } else {
            Packets.sendToAllClients(packet);
        }
    }
}

