/*
 * Decompiled with CFR 0.152.
 */
package lykrast.meetyourfight.renderer;

import lykrast.meetyourfight.MeetYourFight;
import lykrast.meetyourfight.entity.DameFortunaEntity;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class DameFortunaModel
extends HumanoidModel<DameFortunaEntity> {
    public static final ModelLayerLocation MODEL = new ModelLayerLocation(MeetYourFight.rl("dame_fortuna"), "main");
    public static final ModelLayerLocation MODEL_ARMOR = new ModelLayerLocation(MeetYourFight.rl("dame_fortuna"), "armor");
    public static final ModelLayerLocation MODEL_HEAD = new ModelLayerLocation(MeetYourFight.rl("dame_fortuna"), "head");
    private static final Pose[] POSE = new Pose[]{new Pose(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), new Pose(30.0f, 0.0f, 30.0f, 30.0f, 0.0f, -30.0f), new Pose(160.0f, 0.0f, 30.0f, 160.0f, 0.0f, -30.0f), new Pose(-150.0f, 0.0f, -30.0f, 150.0f, 0.0f, 30.0f), new Pose(160.0f, 0.0f, 30.0f, -160.0f, 0.0f, -30.0f), new Pose(-10.0f, 0.0f, -160.0f, 10.0f, 0.0f, 160.0f), new Pose(-10.0f, 0.0f, -95.0f, 10.0f, 0.0f, 95.0f), new Pose(135.0f, 70.0f, 0.0f, 0.0f, 0.0f, 0.0f), new Pose(110.0f, 70.0f, 0.0f, 0.0f, 0.0f, 0.0f), new Pose(35.0f, 20.0f, 55.0f, 35.0f, -20.0f, -55.0f), new Pose(0.0f, 0.0f, -100.0f, 0.0f, 0.0f, -50.0f), new Pose(110.0f, -40.0f, 0.0f, 110.0f, 40.0f, 0.0f)};
    private Pose pose;
    private Pose prevPose;
    private float headProgress;
    private float headScale;
    private float animProgress;

    public DameFortunaModel(ModelPart modelPart) {
        super(modelPart);
    }

    public static LayerDefinition createBodyLayer(CubeDeformation deform) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, deform), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)0.0f));
        partdefinition.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, deform.m_171469_(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, deform), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, deform), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, deform), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, deform), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, deform), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void prepareMobModel(DameFortunaEntity entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.m_6839_((LivingEntity)entity, limbSwing, limbSwingAmount, partialTick);
        this.headProgress = entity.getHeadRotationProgress(partialTick);
        this.animProgress = entity.getAnimProgress(partialTick);
        this.animProgress = 1.0f - this.animProgress;
        this.animProgress *= this.animProgress;
        this.animProgress = 1.0f - this.animProgress;
        this.pose = POSE[entity.clientAnim];
        this.prevPose = POSE[entity.prevAnim];
        if (entity.headRegrowTime > 0) {
            this.headScale = ((float)(10 - entity.headRegrowTime) + partialTick) / 10.0f;
            float sq = this.headScale * this.headScale;
            this.headScale = sq / (2.0f * (sq - this.headScale) + 1.0f);
        } else {
            this.headScale = 1.0f;
        }
    }

    public void setupAnim(DameFortunaEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float headX = this.f_102808_.f_104203_;
        float headY = this.f_102808_.f_104204_;
        float headZ = this.f_102808_.f_104205_;
        this.f_102817_ = entity.clientAnim == 10;
        super.m_6973_((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.f_102809_.f_233556_ = true;
        this.f_102808_.f_104201_ = -8.0f + Mth.m_14031_((float)(ageInTicks * (float)Math.PI / 50.0f));
        this.f_102808_.f_104203_ = this.m_102835_(this.headProgress, headX, (float)entity.headTargetPitch * 1.5707964f);
        this.f_102808_.f_104204_ = this.m_102835_(this.headProgress, headY, (float)entity.headTargetYaw * 1.5707964f);
        this.f_102808_.f_104205_ = this.m_102835_(this.headProgress, headZ, (float)entity.headTargetRoll * 1.5707964f);
        this.f_102808_.f_233553_ = this.headScale;
        this.f_102808_.f_233554_ = this.headScale;
        this.f_102808_.f_233555_ = this.headScale;
        if ((double)this.animProgress > 0.99) {
            if (this.pose.usesLeft) {
                this.f_102812_.f_104203_ = this.pose.leftX;
                this.f_102812_.f_104204_ = this.pose.leftY;
                this.f_102812_.f_104205_ = this.pose.leftZ;
            }
            if (this.pose.usesRight) {
                this.f_102811_.f_104203_ = this.pose.rightX;
                this.f_102811_.f_104204_ = this.pose.rightY;
                this.f_102811_.f_104205_ = this.pose.rightZ;
            }
            if (entity.clientAnim == 3) {
                this.f_102808_.f_104201_ = -8.0f;
            }
        } else {
            float oldz;
            float oldy;
            float oldx;
            if (this.pose.usesLeft) {
                if (this.prevPose.usesLeft) {
                    oldx = this.prevPose.leftX;
                    oldy = this.prevPose.leftY;
                    oldz = this.prevPose.leftZ;
                } else {
                    oldx = this.f_102812_.f_104203_;
                    oldy = this.f_102812_.f_104204_;
                    oldz = this.f_102812_.f_104205_;
                }
                this.f_102812_.f_104203_ = this.m_102835_(this.animProgress, oldx, this.pose.leftX);
                this.f_102812_.f_104204_ = this.m_102835_(this.animProgress, oldy, this.pose.leftY);
                this.f_102812_.f_104205_ = this.m_102835_(this.animProgress, oldz, this.pose.leftZ);
            } else if (this.prevPose.usesLeft) {
                this.f_102812_.f_104203_ = this.m_102835_(this.animProgress, this.prevPose.leftX, this.f_102812_.f_104203_);
                this.f_102812_.f_104204_ = this.m_102835_(this.animProgress, this.prevPose.leftY, this.f_102812_.f_104204_);
                this.f_102812_.f_104205_ = this.m_102835_(this.animProgress, this.prevPose.leftZ, this.f_102812_.f_104205_);
            }
            if (this.pose.usesRight) {
                if (this.prevPose.usesRight) {
                    oldx = this.prevPose.rightX;
                    oldy = this.prevPose.rightY;
                    oldz = this.prevPose.rightZ;
                } else {
                    oldx = this.f_102811_.f_104203_;
                    oldy = this.f_102811_.f_104204_;
                    oldz = this.f_102811_.f_104205_;
                }
                this.f_102811_.f_104203_ = this.m_102835_(this.animProgress, oldx, this.pose.rightX);
                this.f_102811_.f_104204_ = this.m_102835_(this.animProgress, oldy, this.pose.rightY);
                this.f_102811_.f_104205_ = this.m_102835_(this.animProgress, oldz, this.pose.rightZ);
            } else if (this.prevPose.usesLeft) {
                this.f_102811_.f_104203_ = this.m_102835_(this.animProgress, this.prevPose.rightX, this.f_102811_.f_104203_);
                this.f_102811_.f_104204_ = this.m_102835_(this.animProgress, this.prevPose.rightY, this.f_102811_.f_104204_);
                this.f_102811_.f_104205_ = this.m_102835_(this.animProgress, this.prevPose.rightZ, this.f_102811_.f_104205_);
            }
            if (entity.clientAnim == 3) {
                this.f_102808_.f_104201_ = Mth.m_14179_((float)this.animProgress, (float)this.f_102808_.f_104201_, (float)-8.0f);
            } else if (entity.prevAnim == 3) {
                this.f_102808_.f_104201_ = Mth.m_14179_((float)this.animProgress, (float)-8.0f, (float)this.f_102808_.f_104201_);
            }
        }
    }

    private static class Pose {
        public final float leftX;
        public final float leftY;
        public final float leftZ;
        public final float rightX;
        public final float rightY;
        public final float rightZ;
        public final boolean usesLeft;
        public final boolean usesRight;

        public Pose(float leftX, float leftY, float leftZ, float rightX, float rightY, float rightZ) {
            this.leftX = leftX * ((float)(-Math.PI) / 180);
            this.leftY = leftY * ((float)(-Math.PI) / 180);
            this.leftZ = leftZ * ((float)Math.PI / 180);
            this.rightX = rightX * ((float)(-Math.PI) / 180);
            this.rightY = rightY * ((float)(-Math.PI) / 180);
            this.rightZ = rightZ * ((float)Math.PI / 180);
            this.usesLeft = leftX != 0.0f || leftY != 0.0f || leftZ != 0.0f;
            this.usesRight = rightX != 0.0f || rightY != 0.0f || rightZ != 0.0f;
        }
    }
}

