/*
 * Decompiled with CFR 0.152.
 */
package lykrast.meetyourfight.registry;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import lykrast.meetyourfight.MeetYourFight;
import lykrast.meetyourfight.config.MYFConfigValues;
import lykrast.meetyourfight.entity.BellringerEntity;
import lykrast.meetyourfight.entity.DameFortunaEntity;
import lykrast.meetyourfight.entity.RosalyneEntity;
import lykrast.meetyourfight.entity.SwampjawEntity;
import lykrast.meetyourfight.item.BoneRaker;
import lykrast.meetyourfight.item.CocktailCutlass;
import lykrast.meetyourfight.item.CurioBaseItem;
import lykrast.meetyourfight.item.DepthStar;
import lykrast.meetyourfight.item.LuckCurio;
import lykrast.meetyourfight.item.PassagesToll;
import lykrast.meetyourfight.item.SpectresEye;
import lykrast.meetyourfight.item.SpectresGrasp;
import lykrast.meetyourfight.item.SummonItem;
import lykrast.meetyourfight.item.TwilightsThorn;
import lykrast.meetyourfight.item.WiltedIdeals;
import lykrast.meetyourfight.registry.CompatGWRItems;
import lykrast.meetyourfight.registry.MYFBlocks;
import lykrast.meetyourfight.registry.MYFEntities;
import lykrast.meetyourfight.registry.MYFSounds;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;

public class MYFItems {
    public static final DeferredRegister<Item> REG = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"meetyourfight");
    public static RegistryObject<Item> fossilBait;
    public static RegistryObject<Item> mossyTooth;
    public static RegistryObject<Item> boneRaker;
    public static RegistryObject<Item> depthStar;
    public static RegistryObject<Item> cagedHeart;
    public static RegistryObject<Item> marshyDelight;
    public static RegistryObject<Item> hauntedBell;
    public static RegistryObject<Item> phantoplasm;
    public static RegistryObject<Item> passagesToll;
    public static RegistryObject<Item> spectresEye;
    public static RegistryObject<Item> spectresGrasp;
    public static RegistryObject<Item> aetherGlazedCupcake;
    public static RegistryObject<Item> devilsAnte;
    public static RegistryObject<Item> fortunesFavor;
    public static RegistryObject<Item> slicersDice;
    public static RegistryObject<Item> aceOfIron;
    public static RegistryObject<Item> cocktailCutlass;
    public static RegistryObject<Item> velvetFortune;
    public static RegistryObject<Item> duskKey;
    public static RegistryObject<Item> violetBloom;
    public static RegistryObject<Item> twilightsThorn;
    public static RegistryObject<Item> wiltedIdeals;
    public static RegistryObject<Item> blossomingMind;
    public static RegistryObject<Item> tombPlanter;
    public static RegistryObject<Item> petalCream;
    public static RegistryObject<Item> discSwampjaw;
    public static RegistryObject<Item> discBellringer;
    public static RegistryObject<Item> discFortuna;
    public static RegistryObject<Item> discRosalyne;
    public static RegistryObject<Item> headSwampjaw;
    public static RegistryObject<Item> headBellringer;
    public static RegistryObject<Item> headFortuna;
    public static RegistryObject<Item> headRosalyne;
    public static RegistryObject<Item> headRosalyneCracked;
    public static RegistryObject<Item> eggSwampjaw;
    public static RegistryObject<Item> eggBellringer;
    public static RegistryObject<Item> eggDameFortuna;
    public static RegistryObject<Item> eggRosalyne;
    private static List<RegistryObject<? extends Item>> orderedItemsCreative;

    public static void makeCreativeTab(RegisterEvent event) {
        event.register(Registries.f_279569_, helper -> helper.register(ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)new ResourceLocation("meetyourfight", "meetyourfight")), (Object)CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.meetyourfight")).m_257737_(() -> new ItemStack((ItemLike)hauntedBell.get())).m_257501_((parameters, output) -> orderedItemsCreative.forEach(i -> output.m_246326_((ItemLike)i.get()))).m_257652_()));
    }

    public static Item.Properties defP() {
        return new Item.Properties();
    }

    public static Item.Properties boss() {
        return new Item.Properties().m_41497_(Rarity.UNCOMMON).m_41486_();
    }

    public static Item.Properties noStack() {
        return new Item.Properties().m_41487_(1);
    }

    public static Item.Properties bossNS() {
        return new Item.Properties().m_41487_(1).m_41497_(Rarity.UNCOMMON).m_41486_();
    }

    public static Item.Properties disc() {
        return MYFItems.noStack().m_41497_(Rarity.RARE).m_41486_();
    }

    public static Supplier<Item> skull(RegistryObject<Block> normal, RegistryObject<Block> wall) {
        return () -> new StandingAndWallBlockItem((Block)normal.get(), (Block)wall.get(), MYFItems.boss(), Direction.DOWN);
    }

    public static <I extends Item> RegistryObject<I> initItem(String name, Supplier<I> item) {
        RegistryObject rego = REG.register(name, item);
        orderedItemsCreative.add((RegistryObject<? extends Item>)rego);
        return rego;
    }

    static {
        orderedItemsCreative = new ArrayList<RegistryObject<? extends Item>>();
        fossilBait = MYFItems.initItem("fossil_bait", () -> new SummonItem(MYFItems.noStack(), SwampjawEntity::spawn, () -> MYFConfigValues.SWAMPJAW_CHANGED));
        mossyTooth = MYFItems.initItem("mossy_tooth", () -> new Item(MYFItems.boss()));
        boneRaker = MYFItems.initItem("bone_raker", () -> new BoneRaker(MYFItems.bossNS()));
        depthStar = MYFItems.initItem("depth_star", () -> new DepthStar(MYFItems.bossNS()));
        cagedHeart = MYFItems.initItem("caged_heart", () -> new CurioBaseItem(MYFItems.bossNS(), true, () -> new Object[]{MYFConfigValues.percent(MYFConfigValues.CAGED_HEART_TRESHOLD), MYFConfigValues.percent(1.0 - MYFConfigValues.CAGED_HEART_MULT)}));
        marshyDelight = MYFItems.initItem("marshy_delight", () -> new Item(MYFItems.boss().m_41489_(new FoodProperties.Builder().m_38760_(14).m_38758_(0.9f).m_38757_().m_38767_())));
        hauntedBell = MYFItems.initItem("haunted_bell", () -> new SummonItem(MYFItems.noStack(), BellringerEntity::spawn, () -> MYFConfigValues.BELLRINGER_CHANGED));
        phantoplasm = MYFItems.initItem("phantoplasm", () -> new Item(MYFItems.boss()));
        passagesToll = MYFItems.initItem("passages_toll", () -> new PassagesToll(MYFItems.bossNS()));
        spectresEye = MYFItems.initItem("spectres_eye", () -> new SpectresEye(MYFItems.bossNS()));
        spectresGrasp = MYFItems.initItem("spectres_grasp", () -> new SpectresGrasp(MYFItems.bossNS()));
        aetherGlazedCupcake = MYFItems.initItem("aether_glazed_cupcake", () -> new Item(MYFItems.boss().m_41489_(new FoodProperties.Builder().m_38760_(5).m_38758_(0.6f).m_38765_().effect(() -> new MobEffectInstance(MobEffects.f_19620_, 100), 1.0f).m_38767_())));
        devilsAnte = MYFItems.initItem("devils_ante", () -> new SummonItem(MYFItems.noStack(), DameFortunaEntity::spawn, () -> MYFConfigValues.FORTUNA_CHANGED));
        fortunesFavor = MYFItems.initItem("fortunes_favor", () -> new Item(MYFItems.boss()));
        slicersDice = MYFItems.initItem("slicers_dice", () -> new LuckCurio(MYFItems.bossNS(), () -> MYFConfigValues.SLICER_DICE_LUCK, () -> new Object[]{MYFConfigValues.percent(MYFConfigValues.SLICER_DICE_CHANCE), MYFConfigValues.percent(MYFConfigValues.SLICER_DICE_MULT - 1.0)}));
        aceOfIron = MYFItems.initItem("ace_of_iron", () -> new LuckCurio(MYFItems.bossNS(), () -> MYFConfigValues.ACE_OF_IRON_LUCK, () -> new Object[]{MYFConfigValues.percent(MYFConfigValues.ACE_OF_IRON_CHANCE)}));
        cocktailCutlass = MYFItems.initItem("cocktail_cutlass", () -> new CocktailCutlass(MYFItems.bossNS(), () -> MYFConfigValues.COCKTAIL_CUTLASS_LUCK));
        velvetFortune = MYFItems.initItem("velvet_fortune", () -> new Item(MYFItems.boss().m_41489_(new FoodProperties.Builder().m_38760_(2).m_38758_(0.1f).m_38765_().effect(() -> new MobEffectInstance(MobEffects.f_19621_, 12000), 1.0f).m_38767_())));
        duskKey = MYFItems.initItem("dusk_key", () -> new SummonItem(MYFItems.noStack(), RosalyneEntity::spawn, () -> MYFConfigValues.ROSALYNE_CHANGED));
        violetBloom = MYFItems.initItem("violet_bloom", () -> new Item(MYFItems.boss()));
        twilightsThorn = MYFItems.initItem("twilights_thorn", () -> new TwilightsThorn(MYFItems.bossNS()));
        wiltedIdeals = MYFItems.initItem("wilted_ideals", () -> new WiltedIdeals(MYFItems.bossNS()));
        blossomingMind = MYFItems.initItem("blossoming_mind", () -> new CurioBaseItem(MYFItems.bossNS(), true, () -> new Object[]{MYFConfigValues.percent(MYFConfigValues.BLOSSOMING_MIND_BONUS)}));
        tombPlanter = MYFItems.initItem("tomb_planter", () -> new CurioBaseItem(MYFItems.bossNS(), true));
        petalCream = MYFItems.initItem("petal_cream", () -> new Item(MYFItems.boss().m_41489_(new FoodProperties.Builder().m_38760_(4).m_38758_(0.8f).m_38767_())));
        discSwampjaw = MYFItems.initItem("music_disc_swampjaw", () -> new RecordItem(1, MYFSounds.musicSwampjaw, MYFItems.disc(), 1691));
        discBellringer = MYFItems.initItem("music_disc_bellringer", () -> new RecordItem(1, MYFSounds.musicBellringer, MYFItems.disc(), 1818));
        discFortuna = MYFItems.initItem("music_disc_fortuna", () -> new RecordItem(1, MYFSounds.musicFortuna, MYFItems.disc(), 4200));
        discRosalyne = MYFItems.initItem("music_disc_rosalyne", () -> new RecordItem(1, MYFSounds.musicRosalyne, MYFItems.disc(), 4408));
        headSwampjaw = MYFItems.initItem("swampjaw_head", MYFItems.skull(MYFBlocks.swampjawHead, MYFBlocks.swampjawHeadWall));
        headBellringer = MYFItems.initItem("bellringer_head", MYFItems.skull(MYFBlocks.bellringerHead, MYFBlocks.bellringerHeadWall));
        headFortuna = MYFItems.initItem("dame_fortuna_head", MYFItems.skull(MYFBlocks.fortunaHead, MYFBlocks.fortunaHeadWall));
        headRosalyne = MYFItems.initItem("rosalyne_head", MYFItems.skull(MYFBlocks.rosalyneHead, MYFBlocks.rosalyneHeadWall));
        headRosalyneCracked = MYFItems.initItem("rosalyne_head_cracked", MYFItems.skull(MYFBlocks.rosalyneCracked, MYFBlocks.rosalyneCrackedWall));
        eggSwampjaw = MYFItems.initItem("swampjaw_spawn_egg", () -> new ForgeSpawnEggItem(MYFEntities.SWAMPJAW, 16579565, 7570770, MYFItems.defP()));
        eggBellringer = MYFItems.initItem("bellringer_spawn_egg", () -> new ForgeSpawnEggItem(MYFEntities.BELLRINGER, 5636224, 0xDFFFF9, MYFItems.defP()));
        eggDameFortuna = MYFItems.initItem("dame_fortuna_spawn_egg", () -> new ForgeSpawnEggItem(MYFEntities.DAME_FORTUNA, 0xFE0000, 0xEEEEEE, MYFItems.defP()));
        eggRosalyne = MYFItems.initItem("rosalyne_spawn_egg", () -> new ForgeSpawnEggItem(MYFEntities.ROSALYNE, 0xEBEBEB, 14126847, MYFItems.defP()));
        if (MeetYourFight.loadedGunsWithoutRoses()) {
            CompatGWRItems.registerItems();
        }
    }
}

