/*
 * Decompiled with CFR 0.152.
 */
package lykrast.meetyourfight.misc;

import lykrast.meetyourfight.config.MYFConfigValues;
import lykrast.meetyourfight.registry.MYFItems;
import lykrast.meetyourfight.registry.MYFSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="meetyourfight")
public class EventHandler {
    private static boolean isWearing(LivingEntity wearer, RegistryObject<Item> curio) {
        return CuriosApi.getCuriosInventory((LivingEntity)wearer).map(i -> i.isEquipped((Item)curio.get())).orElse(false);
    }

    @SubscribeEvent
    public static void entityDamage(LivingHurtEvent event) {
        Player pattacked;
        LivingEntity attacked = event.getEntity();
        if (attacked instanceof Player) {
            Player pattacked2 = (Player)attacked;
            if (!event.isCanceled() && !event.getSource().m_269533_(DamageTypeTags.f_268738_) && EventHandler.isWearing((LivingEntity)pattacked2, MYFItems.aceOfIron)) {
                float luck = pattacked2.m_36336_();
                double chance = MYFConfigValues.ACE_OF_IRON_CHANCE;
                if (MYFConfigValues.ACE_OF_IRON_LUCK) {
                    if (luck >= 0.0f && chance < 0.5) {
                        chance = (1.0 + (double)luck) / (1.0 / MYFConfigValues.ACE_OF_IRON_CHANCE + (double)(2.0f * luck));
                    } else if (luck < 0.0f) {
                        chance = 1.0 / (1.0 / MYFConfigValues.ACE_OF_IRON_CHANCE - (double)(3.0f * luck));
                    }
                }
                if (pattacked2.m_217043_().m_188500_() <= chance) {
                    event.setCanceled(true);
                    pattacked2.m_9236_().m_5594_(null, attacked.m_20183_(), (SoundEvent)MYFSounds.aceOfIronProc.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
        if (event.isCanceled()) {
            return;
        }
        Entity attacker = event.getSource().m_7639_();
        if (attacker != null && attacker instanceof Player) {
            Player pattacker = (Player)attacker;
            if (EventHandler.isWearing((LivingEntity)pattacker, MYFItems.slicersDice)) {
                float luck = pattacker.m_36336_();
                double chance = MYFConfigValues.SLICER_DICE_CHANCE;
                if (MYFConfigValues.SLICER_DICE_LUCK) {
                    chance = luck >= 0.0f ? (1.0 + (double)luck) / (1.0 / MYFConfigValues.SLICER_DICE_CHANCE + (double)luck) : 1.0 / (1.0 / MYFConfigValues.SLICER_DICE_CHANCE - (double)(3.0f * luck));
                }
                if (pattacker.m_217043_().m_188500_() <= chance) {
                    event.setAmount((float)((double)event.getAmount() * MYFConfigValues.SLICER_DICE_MULT));
                    pattacker.m_9236_().m_5594_(null, attacked.m_20183_(), (SoundEvent)MYFSounds.slicersDiceProc.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    ((ServerLevel)pattacker.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123797_, attacked.m_20185_(), attacked.m_20188_(), attacked.m_20189_(), 15, 0.2, 0.2, 0.2, 0.0);
                }
            }
            if (EventHandler.isWearing((LivingEntity)pattacker, MYFItems.wiltedIdeals)) {
                event.setAmount((float)((double)event.getAmount() * MYFConfigValues.WILTED_IDEALS_MULT));
            }
        }
        if (attacked instanceof Player && EventHandler.isWearing((LivingEntity)(pattacked = (Player)attacked), MYFItems.cagedHeart)) {
            double treshold = (double)pattacked.m_21233_() * MYFConfigValues.CAGED_HEART_TRESHOLD;
            if ((double)event.getAmount() > treshold) {
                event.setAmount((float)(((double)event.getAmount() - treshold) * MYFConfigValues.CAGED_HEART_MULT + treshold));
                pattacked.m_9236_().m_5594_(null, attacked.m_20183_(), (SoundEvent)MYFSounds.cagedHeartProc.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void entityDeath(LivingDeathEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Entity killer = event.getSource().m_7639_();
        if (killer != null && killer instanceof Player) {
            ItemStack dummy;
            BlockPos pos;
            Level lvl;
            Player pkiller = (Player)killer;
            LivingEntity killed = event.getEntity();
            if (!(!EventHandler.isWearing((LivingEntity)pkiller, MYFItems.tombPlanter) || (lvl = killed.m_9236_()).m_46859_(pos = killed.m_20183_()) && lvl.m_46859_(pos = pos.m_7495_()) || !BoneMealItem.applyBonemeal((ItemStack)(dummy = new ItemStack((ItemLike)Items.f_42499_)), (Level)lvl, (BlockPos)pos, (Player)pkiller) && !BoneMealItem.m_40631_((ItemStack)dummy, (Level)lvl, (BlockPos)pos, null) || lvl.f_46443_)) {
                lvl.m_46796_(1505, pos, 0);
            }
        }
    }

    @SubscribeEvent
    public static void livingExperienceDrop(LivingExperienceDropEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Player killer = event.getAttackingPlayer();
        if (killer != null && event.getOriginalExperience() >= 2 && EventHandler.isWearing((LivingEntity)killer, MYFItems.blossomingMind)) {
            double amt = Math.min((double)event.getOriginalExperience() * MYFConfigValues.BLOSSOMING_MIND_BONUS, (double)MYFConfigValues.BLOSSOMING_MIND_CAP);
            event.setDroppedExperience(event.getDroppedExperience() + (int)(amt *= 0.5 * (1.0 + killer.m_9236_().f_46441_.m_188500_() + killer.m_9236_().f_46441_.m_188500_())));
        }
    }
}

