/*
 * Decompiled with CFR 0.152.
 */
package lykrast.meetyourfight.entity;

import java.util.UUID;
import javax.annotation.Nullable;
import lykrast.meetyourfight.config.MYFConfigValues;
import lykrast.meetyourfight.entity.ProjectileBossAbstract;
import lykrast.meetyourfight.registry.MYFEntities;
import lykrast.meetyourfight.registry.MYFSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ProjectileTargetedEntity
extends ProjectileBossAbstract {
    private static final EntityDataAccessor<Byte> COLOR = SynchedEntityData.m_135353_(ProjectileTargetedEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private double startX;
    private double startY;
    private double startZ;
    private double speed;
    private double angleOffset;
    private int setupTime;
    @Nullable
    private Entity finalTarget;
    @Nullable
    private UUID targetId;

    public ProjectileTargetedEntity(EntityType<? extends ProjectileTargetedEntity> type, Level world) {
        super(type, world);
    }

    public ProjectileTargetedEntity(Level worldIn, LivingEntity shooter) {
        super((EntityType<? extends ProjectileBossAbstract>)((EntityType)MYFEntities.PROJECTILE_TARGETED.get()), shooter, 0.0, 0.0, 0.0, worldIn);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COLOR, (Object)0);
    }

    public void setUp(int delay, int setupTime, Entity target, double speed, double startX, double startY, double startZ) {
        this.setUp(delay, setupTime, target, speed, startX, startY, startZ, 0.0);
    }

    public void setUp(int delay, int setupTime, Entity target, double speed, double startX, double startY, double startZ, double angleOffset) {
        this.fired = false;
        this.timer = delay;
        this.setupTime = setupTime;
        this.finalTarget = target;
        this.speed = speed;
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
        this.angleOffset = angleOffset;
    }

    @Override
    protected float getDamage(LivingEntity shooter, Entity hit) {
        return (float)(16.0 * MYFConfigValues.FORTUNA_DMG_MULT);
    }

    @Override
    protected void projTick() {
        if (this.finalTarget == null && this.targetId != null) {
            this.finalTarget = ((ServerLevel)this.m_9236_()).m_8791_(this.targetId);
            if (this.finalTarget == null) {
                this.targetId = null;
            }
        }
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        if (this.timer <= 0) {
            if (this.fired || this.finalTarget == null) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            } else {
                this.fired = true;
                this.timer = 30;
                this.m_20256_(new Vec3(this.finalTarget.m_20185_() - x, this.finalTarget.m_20188_() - y, this.finalTarget.m_20189_() - z).m_82541_().m_82490_(this.speed).m_82524_((float)this.angleOffset * ((float)Math.PI / 180)));
                this.m_5496_((SoundEvent)MYFSounds.dameFortunaChipsFire.get(), 2.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            }
        }
        if (!this.fired && this.setupTime > 0) {
            --this.setupTime;
            if (this.setupTime == 0) {
                this.m_20334_(0.0, 0.0, 0.0);
            } else {
                this.m_20256_(new Vec3(this.startX - x, this.startY - y, this.startZ - z).m_82490_(1.0 / (double)this.setupTime));
            }
        }
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(COLOR, (Object)((byte)variant));
    }

    public int getVariant() {
        return ((Byte)this.f_19804_.m_135370_(COLOR)).byteValue();
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128347_("speed", this.speed);
        compound.m_128347_("SX", this.startX);
        compound.m_128347_("SY", this.startY);
        compound.m_128347_("SZ", this.startZ);
        compound.m_128347_("angle", this.angleOffset);
        compound.m_128405_("Variant", this.getVariant());
        compound.m_128405_("setuptime", this.setupTime);
        if (this.finalTarget != null) {
            compound.m_128362_("Target", this.finalTarget.m_20148_());
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.speed = compound.m_128459_("speed");
        this.startX = compound.m_128459_("SX");
        this.startY = compound.m_128459_("SY");
        this.startZ = compound.m_128459_("SZ");
        this.angleOffset = compound.m_128459_("angle");
        this.setupTime = compound.m_128451_("setuptime");
        this.setVariant(compound.m_128451_("Variant"));
        if (compound.m_128403_("Target")) {
            this.targetId = compound.m_128342_("Target");
        }
    }
}

