/*
 * Decompiled with CFR 0.152.
 */
package lykrast.meetyourfight.entity;

import lykrast.meetyourfight.config.MYFConfigValues;
import lykrast.meetyourfight.entity.ProjectileBossAbstract;
import lykrast.meetyourfight.entity.RosalyneEntity;
import lykrast.meetyourfight.entity.RoseSpiritEntity;
import lykrast.meetyourfight.registry.MYFEntities;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ProjectileLineEntity
extends ProjectileBossAbstract {
    private static final EntityDataAccessor<Integer> PROJECTILE_VARIANT = SynchedEntityData.m_135353_(ProjectileLineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final int VAR_BELLRINGER = 0;
    public static final int VAR_DAME_FORTUNA = 1;
    public static final int VAR_ROSALYNE = 2;
    private double dirX;
    private double dirY;
    private double dirZ;
    private double startX;
    private double startY;
    private double startZ;

    public ProjectileLineEntity(EntityType<? extends ProjectileLineEntity> type, Level world) {
        super(type, world);
    }

    public ProjectileLineEntity(Level worldIn, LivingEntity shooter) {
        super((EntityType<? extends ProjectileBossAbstract>)((EntityType)MYFEntities.PROJECTILE_LINE.get()), shooter, 0.0, 0.0, 0.0, worldIn);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PROJECTILE_VARIANT, (Object)0);
    }

    public void setUp(int delay, double dirX, double dirY, double dirZ, double startX, double startY, double startZ) {
        this.fired = false;
        this.timer = delay;
        this.dirX = dirX;
        this.dirY = dirY;
        this.dirZ = dirZ;
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
    }

    public void setUpTowards(int delay, double startX, double startY, double startZ, double endX, double endY, double endZ, double speed) {
        Vec3 vec = new Vec3(endX - startX, endY - startY, endZ - startZ).m_82541_().m_82490_(speed);
        this.setUp(delay, vec.f_82479_, vec.f_82480_, vec.f_82481_, startX, startY, startZ);
    }

    @Override
    protected float getDamage(LivingEntity shooter, Entity hit) {
        switch (this.getVariant()) {
            default: {
                return (float)(10.0 * MYFConfigValues.BELLRINGER_DMG_MULT);
            }
            case 1: {
                return (float)(16.0 * MYFConfigValues.FORTUNA_DMG_MULT);
            }
            case 2: 
        }
        return (float)(16.0 * MYFConfigValues.ROSALYNE_PROJECTILE_MULT);
    }

    @Override
    protected void particles(double targetx, double targety, double targetz) {
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, targetx, targety + 0.5, targetz, 0.0, 0.0, 0.0);
    }

    protected boolean m_5603_(Entity target) {
        if (this.getVariant() == 2 && (target instanceof RoseSpiritEntity || target instanceof RosalyneEntity)) {
            return false;
        }
        return super.m_5603_(target);
    }

    @Override
    protected void projTick() {
        if (this.timer <= 0) {
            if (this.fired) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            } else {
                this.fired = true;
                this.m_20256_(new Vec3(0.0, 0.0, 0.0));
                this.timer = 30;
            }
        }
        Vec3 motion = this.m_20184_();
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        if (this.fired) {
            if (motion.m_82556_() <= 16.0) {
                this.m_20256_(motion.m_82520_(this.dirX * 0.1, this.dirY * 0.1, this.dirZ * 0.1));
            }
        } else {
            this.m_20256_(new Vec3(this.startX - d0, this.startY - d1, this.startZ - d2).m_82490_(1.0 / (double)this.timer));
        }
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(PROJECTILE_VARIANT, (Object)variant);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(PROJECTILE_VARIANT);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128347_("DX", this.dirX);
        compound.m_128347_("DY", this.dirY);
        compound.m_128347_("DZ", this.dirZ);
        compound.m_128347_("SX", this.startX);
        compound.m_128347_("SY", this.startY);
        compound.m_128347_("SZ", this.startZ);
        compound.m_128405_("Variant", this.getVariant());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.dirX = compound.m_128459_("DX");
        this.dirY = compound.m_128459_("DY");
        this.dirZ = compound.m_128459_("DZ");
        this.startX = compound.m_128459_("SX");
        this.startY = compound.m_128459_("SY");
        this.startZ = compound.m_128459_("SZ");
        this.setVariant(compound.m_128451_("Variant"));
    }
}

