/*
 * Decompiled with CFR 0.152.
 */
package lykrast.meetyourfight.entity;

import javax.annotation.Nullable;
import lykrast.meetyourfight.entity.ProjectileLineEntity;
import lykrast.meetyourfight.registry.MYFEntities;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class FortunaBombEntity
extends Entity {
    private LivingEntity bomber;
    private static final EntityDataAccessor<Integer> DATA_FUSE_ID = SynchedEntityData.m_135353_(FortunaBombEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int moveFuse;
    private static final double GRAVITY = -0.08;
    private static final double HALF_SQRT2 = Math.sqrt(2.0) / 2.0;

    public FortunaBombEntity(EntityType<? extends FortunaBombEntity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public FortunaBombEntity(Level worldIn, double x, double y, double z, @Nullable LivingEntity igniter) {
        this((EntityType<? extends FortunaBombEntity>)((EntityType)MYFEntities.FORTUNA_BOMB.get()), worldIn);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
        this.bomber = igniter;
    }

    public void setup(int fuse, int moveFuse, double tx, double ty, double tz) {
        this.setFuse(fuse);
        this.moveFuse = moveFuse;
        double compensation = (double)(-(moveFuse + 1)) / 2.0 * -0.08;
        double scale = 1.0 / (double)moveFuse;
        this.m_20334_((tx - this.m_20185_()) * scale, (ty - this.m_20186_()) * scale + compensation, (tz - this.m_20189_()) * scale);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_FUSE_ID, (Object)80);
    }

    public void setFuse(int value) {
        this.f_19804_.m_135381_(DATA_FUSE_ID, (Object)value);
    }

    public int getFuse() {
        return (Integer)this.f_19804_.m_135370_(DATA_FUSE_ID);
    }

    public boolean m_6087_() {
        return false;
    }

    public void m_8119_() {
        if (this.moveFuse > 0) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.08, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (this.moveFuse > 0) {
            --this.moveFuse;
            if (this.moveFuse == 0) {
                this.m_20334_(0.0, 0.0, 0.0);
            }
        }
        int remaining = this.getFuse() - 1;
        this.setFuse(remaining);
        if (remaining <= 0) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_5496_(SoundEvents.f_11913_, 1.0f, 0.5f);
            if (!this.m_9236_().f_46443_) {
                this.explode();
            }
        } else {
            this.m_20073_();
            if (this.m_9236_().f_46443_) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    private void explode() {
        if (this.bomber == null) {
            return;
        }
        this.projectile(1.0, 0.0);
        this.projectile(-1.0, 0.0);
        this.projectile(0.0, 1.0);
        this.projectile(0.0, -1.0);
        this.projectile(HALF_SQRT2, HALF_SQRT2);
        this.projectile(-HALF_SQRT2, HALF_SQRT2);
        this.projectile(HALF_SQRT2, -HALF_SQRT2);
        this.projectile(-HALF_SQRT2, -HALF_SQRT2);
    }

    private void projectile(double dx, double dz) {
        ProjectileLineEntity proj = new ProjectileLineEntity(this.m_9236_(), this.bomber);
        proj.m_5602_((Entity)this.bomber);
        proj.m_146884_(this.m_20182_());
        proj.setVariant(1);
        proj.setUp(1, dx, 0.0, dz, this.m_20185_() + dx * 0.1, this.m_20186_(), this.m_20189_() + dz * 0.1);
        this.m_9236_().m_7967_((Entity)proj);
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128376_("Fuse", (short)this.getFuse());
        compound.m_128376_("MFuse", (short)this.moveFuse);
    }

    protected void m_7378_(CompoundTag compound) {
        this.setFuse(compound.m_128448_("Fuse"));
        this.moveFuse = compound.m_128448_("MFuse");
    }

    protected float m_6380_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.15f;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

