/*
 * Decompiled with CFR 0.152.
 */
package lykrast.meetyourfight.entity;

import java.util.EnumSet;
import javax.annotation.Nullable;
import lykrast.meetyourfight.MeetYourFight;
import lykrast.meetyourfight.config.MYFConfigValues;
import lykrast.meetyourfight.entity.BossEntity;
import lykrast.meetyourfight.entity.FortunaBombEntity;
import lykrast.meetyourfight.entity.FortunaCardEntity;
import lykrast.meetyourfight.entity.ProjectileTargetedEntity;
import lykrast.meetyourfight.entity.ai.MoveAroundTarget;
import lykrast.meetyourfight.entity.ai.StationaryAttack;
import lykrast.meetyourfight.entity.ai.VexMoveRandomGoal;
import lykrast.meetyourfight.entity.movement.VexMovementController;
import lykrast.meetyourfight.misc.FortunaSpinSound;
import lykrast.meetyourfight.registry.MYFEntities;
import lykrast.meetyourfight.registry.MYFSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class DameFortunaEntity
extends BossEntity
implements PowerableMob {
    public static final int HP = 300;
    public static final int DMG = 16;
    private static final EntityDataAccessor<Byte> STATUS = SynchedEntityData.m_135353_(DameFortunaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final int PHASE_1 = 0;
    public static final int SHUFFLE_1 = 1;
    public static final int PHASE_2 = 2;
    public static final int SHUFFLE_2 = 3;
    public static final int PHASE_3 = 4;
    public static final int SHUFFLE_3 = 5;
    public static final int DEATH = 6;
    private static final float TRESHOLD_1 = 0.6666667f;
    private static final float TRESHOLD_2 = 0.33333334f;
    private static final float TRESHOLD_3 = 0.1f;
    private static final float RESET_1 = 0.8333334f;
    private static final float RESET_2 = 0.5f;
    private static final float RESET_3 = 0.21666667f;
    private static final int ATK_DICE = 0;
    private static final int ATK_SPIN = 1;
    private static final int ATK_CHIPS_CIRCLE = 2;
    private static final int ATK_CHIPS_STRAFE = 3;
    public static final int ANIM_IDLE = 0;
    public static final int ANIM_CHIPS_WINDUP = 1;
    public static final int ANIM_CHIPS_LAUNCH = 2;
    public static final int ANIM_DICE_WINDUP = 3;
    public static final int ANIM_DICE_LAUNCH = 4;
    public static final int ANIM_SPIN = 5;
    public static final int ANIM_SPIN_POSE = 6;
    public static final int ANIM_SNAP_PRE = 7;
    public static final int ANIM_SNAP_POST = 8;
    public static final int ANIM_CARD_WAIT = 9;
    public static final int ANIM_FINALE = 10;
    public static final int ANIM_CLAP = 11;
    private static final int PHASE_MASK = 7;
    private static final int ANIMATION_MASK = -8;
    private int attackCooldown;
    private int nextAttack;
    private int shuffleAttackWait;
    private int phase;
    private boolean hasSpawnedShuffle = false;
    public int headTargetPitch;
    public int headTargetYaw;
    public int headTargetRoll;
    public int headRotationTimer;
    public float headRotationProgress;
    public float headRotationProgressLast;
    public int clientAnim;
    public int prevAnim;
    public int animProg;
    public int animDur;
    public int spinTime;
    public int headRegrowTime;
    public float spinAngle;
    public float spinPrev;

    public DameFortunaEntity(EntityType<? extends DameFortunaEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new VexMovementController((Mob)this);
        this.f_21364_ = 100;
        this.phase = 0;
        this.headRotationTimer = 30;
        this.headTargetPitch = 0;
        this.headTargetYaw = 0;
        this.headTargetRoll = 0;
        this.headRotationProgress = 1.0f;
        this.headRotationProgressLast = 1.0f;
        this.clientAnim = 0;
        this.prevAnim = 0;
        this.animProg = 1;
        this.animDur = 1;
        this.spinAngle = 0.0f;
        this.spinPrev = 0.0f;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new DoTheShuffle(this));
        this.f_21345_.m_25352_(2, (Goal)new WaitShuffle(this));
        this.f_21345_.m_25352_(3, (Goal)new EndPose(this));
        this.f_21345_.m_25352_(4, (Goal)new SpinAttack(this));
        this.f_21345_.m_25352_(5, (Goal)new DiceAttack(this));
        this.f_21345_.m_25352_(6, (Goal)new ChipsAttack(this));
        this.f_21345_.m_25352_(7, (Goal)new MoveAroundTarget((Mob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new VexMoveRandomGoal((Mob)this, 0.25));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 300.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22277_, 64.0);
    }

    public void m_6478_(MoverType typeIn, Vec3 pos) {
        super.m_6478_(typeIn, pos);
        this.m_20101_();
    }

    public void m_8119_() {
        this.f_19794_ = true;
        super.m_8119_();
        this.f_19794_ = false;
        this.m_20242_(true);
        if (this.m_9236_().f_46443_) {
            int newanim = this.getAnimation();
            if (this.clientAnim != newanim) {
                this.prevAnim = this.clientAnim;
                this.clientAnim = newanim;
                this.animProg = 0;
                this.animDur = 10;
                if (this.clientAnim == 4) {
                    this.animDur = 4;
                    this.headRegrowTime = 11;
                    this.headRotationTimer = 0;
                } else if (this.clientAnim == 2) {
                    this.animDur = 4;
                } else if (this.clientAnim == 3) {
                    this.animDur = 8;
                } else if (this.clientAnim == 8 || this.clientAnim == 11) {
                    this.animDur = 2;
                }
            } else if (this.animProg < this.animDur) {
                ++this.animProg;
            }
            this.spinPrev = this.spinAngle;
            if (this.clientAnim == 5) {
                if (this.spinTime < 20) {
                    ++this.spinTime;
                } else {
                    this.spinAngle += 36.0f;
                    if (this.spinAngle >= 360.0f) {
                        this.spinAngle = 0.0f;
                    }
                }
            } else if (this.spinAngle > 0.0f) {
                this.spinAngle += 36.0f;
                if (this.spinAngle >= 360.0f) {
                    this.spinAngle = 0.0f;
                }
            } else if (this.spinTime > 0) {
                --this.spinTime;
            }
            if (this.headRegrowTime > 0) {
                --this.headRegrowTime;
            }
            if (this.clientAnim != 3) {
                --this.headRotationTimer;
            }
            if (this.headRotationTimer <= 0) {
                switch (this.getPhase()) {
                    default: {
                        this.headRotationTimer = 20 + this.f_19796_.m_188503_(21);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.headRotationTimer = 15 + this.f_19796_.m_188503_(11);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        this.headRotationTimer = 5 + this.f_19796_.m_188503_(11);
                    }
                }
                this.rotateHead();
                this.headRotationProgress = 0.0f;
                this.headRotationProgressLast = 0.0f;
            } else {
                this.headRotationProgressLast = this.headRotationProgress;
                this.headRotationProgress = Math.min(1.0f, this.headRotationProgress + 0.07f);
            }
        }
    }

    public float getAnimProgress(float partial) {
        return Mth.m_14036_((float)(((float)this.animProg + partial) / (float)this.animDur), (float)0.0f, (float)1.0f);
    }

    public float getHeadRotationProgress(float partial) {
        return Mth.m_14179_((float)partial, (float)this.headRotationProgressLast, (float)this.headRotationProgress);
    }

    private float getEasedSpin(float progress) {
        return 0.9f * progress * progress;
    }

    public float getSpinAngle(float partial) {
        if (this.clientAnim == 5) {
            if (this.spinTime < 20) {
                return this.getEasedSpin((float)this.spinTime + partial);
            }
            return Mth.m_14189_((float)partial, (float)this.spinPrev, (float)this.spinAngle);
        }
        if (this.spinAngle > 0.0f) {
            return Mth.m_14189_((float)partial, (float)this.spinPrev, (float)this.spinAngle);
        }
        if (this.spinTime > 0) {
            return 360.0f - this.getEasedSpin((float)this.spinTime - partial);
        }
        return 0.0f;
    }

    private void rotateHead() {
        boolean reverse = this.f_19796_.m_188499_();
        int axis = this.f_19796_.m_188503_(3);
        switch (axis) {
            case 0: {
                if (reverse) {
                    if (this.headTargetPitch <= 0) {
                        this.headTargetPitch = 3;
                        break;
                    }
                    --this.headTargetPitch;
                    break;
                }
                this.headTargetPitch = (this.headTargetPitch + 1) % 4;
                break;
            }
            case 1: {
                if (reverse) {
                    if (this.headTargetYaw <= 0) {
                        this.headTargetYaw = 3;
                        break;
                    }
                    --this.headTargetYaw;
                    break;
                }
                this.headTargetYaw = (this.headTargetYaw + 1) % 4;
                break;
            }
            case 2: {
                if (reverse) {
                    if (this.headTargetRoll <= 0) {
                        this.headTargetRoll = 3;
                        break;
                    }
                    --this.headTargetRoll;
                    break;
                }
                this.headTargetRoll = (this.headTargetRoll + 1) % 4;
            }
        }
    }

    public static void spawn(Player player, Level world) {
        RandomSource rand = player.m_217043_();
        DameFortunaEntity dame = (DameFortunaEntity)((EntityType)MYFEntities.DAME_FORTUNA.get()).m_20615_(world);
        dame.m_7678_(player.m_20185_() + (double)rand.m_188503_(5) - 2.0, player.m_20186_() + (double)rand.m_188503_(3) + 3.0, player.m_20189_() + (double)rand.m_188503_(5) - 2.0, rand.m_188501_() * 360.0f - 180.0f, 0.0f);
        dame.attackCooldown = 100;
        dame.nextAttack = 2;
        if (!player.m_150110_().f_35937_) {
            dame.m_6710_((LivingEntity)player);
        }
        dame.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 100, 2));
        ForgeEventFactory.onFinalizeSpawn((Mob)dame, (ServerLevelAccessor)((ServerLevel)world), (DifficultyInstance)world.m_6436_(dame.m_20183_()), (MobSpawnType)MobSpawnType.EVENT, null, null);
        world.m_7967_((Entity)dame);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier("Config Health", MYFConfigValues.FORTUNA_HEALTH_MOD, AttributeModifier.Operation.ADDITION));
        this.m_21153_(this.m_21233_());
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATUS, (Object)0);
    }

    public int getAnimation() {
        return ((Byte)this.f_19804_.m_135370_(STATUS) & 0xFFFFFFF8) >> 3;
    }

    public void setAnimation(int animation) {
        int phase = (Byte)this.f_19804_.m_135370_(STATUS) & 7;
        this.f_19804_.m_135381_(STATUS, (Object)((byte)(animation << 3 | phase)));
    }

    public int getPhase() {
        return (Byte)this.f_19804_.m_135370_(STATUS) & 7;
    }

    public void setPhase(int phase) {
        int animation = (Byte)this.f_19804_.m_135370_(STATUS) & 0xFFFFFFF8;
        this.f_19804_.m_135381_(STATUS, (Object)((byte)(phase | animation)));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!source.m_269533_(DamageTypeTags.f_268738_) && this.m_7090_()) {
            if (amount > 1.0f) {
                this.m_5496_((SoundEvent)MYFSounds.aceOfIronProc.get(), 1.0f, 1.0f);
            }
            return false;
        }
        if (amount > 1.0f && this.getPhase() == 6) {
            return super.m_6469_(source, Math.max(this.m_21223_() * 2.0f, amount));
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_7090_() {
        return this.getPhase() == 1 || this.getPhase() == 3 || this.getPhase() == 5;
    }

    @Override
    public void m_8024_() {
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.shuffleAttackWait > 0) {
            --this.shuffleAttackWait;
        }
        if (this.phase != this.getPhase()) {
            this.phase = this.getPhase();
        }
        if (this.isShuffling() && this.f_19797_ % 10 == 0) {
            if (this.hasSpawnedShuffle && this.m_9236_().m_45976_(FortunaCardEntity.class, this.m_20191_().m_82400_(32.0)).isEmpty()) {
                if (this.phase == 1) {
                    this.m_21153_(this.m_21233_() * 0.8333334f);
                    this.setPhase(0);
                    this.phase = 0;
                } else if (this.phase == 3) {
                    this.m_21153_(this.m_21233_() * 0.5f);
                    this.setPhase(2);
                    this.phase = 2;
                } else if (this.phase == 5) {
                    this.m_21153_(this.m_21233_() * 0.21666667f);
                    this.setPhase(4);
                    this.phase = 4;
                }
            }
        } else if (this.phase == 0 && this.m_21223_() < this.m_21233_() * 0.6666667f) {
            this.setPhase(1);
            this.phase = 1;
            this.hasSpawnedShuffle = false;
        } else if (this.phase == 2 && this.m_21223_() < this.m_21233_() * 0.33333334f) {
            this.setPhase(3);
            this.phase = 3;
            this.hasSpawnedShuffle = false;
        } else if (this.phase == 4 && this.m_21223_() < this.m_21233_() * 0.1f) {
            this.setPhase(5);
            this.phase = 5;
            this.hasSpawnedShuffle = false;
        }
        super.m_8024_();
    }

    public void progressShuffle() {
        if (this.phase == 1) {
            this.setPhase(2);
            this.phase = 2;
        } else if (this.phase == 3) {
            this.setPhase(4);
            this.phase = 4;
        } else if (this.phase == 5) {
            this.setPhase(6);
            this.phase = 6;
        }
        this.attackCooldown = 20;
    }

    public boolean isAttackPhase() {
        return this.phase == 0 || this.phase == 2 || this.phase == 4;
    }

    public boolean isShuffling() {
        return this.phase == 1 || this.phase == 3 || this.phase == 5;
    }

    private void rollNextAttack(int ignore) {
        int max = 2;
        if (this.phase == 2 || this.phase == 4) {
            max = 3;
        }
        if (ignore >= 0) {
            this.nextAttack = this.f_19796_.m_188503_(max);
            if (this.nextAttack >= ignore) {
                ++this.nextAttack;
            }
        } else {
            this.nextAttack = this.f_19796_.m_188503_(max + 1);
        }
    }

    private void cooldownNextAttack() {
        this.attackCooldown = 50 + this.f_19796_.m_188503_(21);
    }

    private ProjectileTargetedEntity readyTargeted() {
        ProjectileTargetedEntity proj = new ProjectileTargetedEntity(this.m_9236_(), (LivingEntity)this);
        proj.m_5602_((Entity)this);
        proj.m_6034_(this.m_20185_(), this.m_20188_() + 1.0, this.m_20189_());
        return proj;
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Phase")) {
            this.setPhase(compound.m_128445_("Phase"));
        }
        if (compound.m_128441_("AttackCooldown")) {
            this.attackCooldown = compound.m_128451_("AttackCooldown");
        }
        if (compound.m_128441_("NxtAt")) {
            this.nextAttack = compound.m_128451_("NxtAt");
        }
        if (compound.m_128441_("ChipsCooldown")) {
            this.shuffleAttackWait = compound.m_128451_("ChipsCooldown");
        }
        if (compound.m_128441_("HasShuffled")) {
            this.hasSpawnedShuffle = compound.m_128471_("HasShuffled");
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_("Phase", (byte)this.getPhase());
        compound.m_128405_("AttackCooldown", this.attackCooldown);
        compound.m_128405_("NxtAt", this.nextAttack);
        compound.m_128405_("ChipsCooldown", this.shuffleAttackWait);
        compound.m_128379_("HasShuffled", this.hasSpawnedShuffle);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)MYFSounds.dameFortunaIdle.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)MYFSounds.dameFortunaHurt.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MYFSounds.dameFortunaDeath.get();
    }

    @Override
    protected SoundEvent getMusic() {
        return (SoundEvent)MYFSounds.musicFortuna.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readSpawnData(FriendlyByteBuf additionalData) {
        super.readSpawnData(additionalData);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new FortunaSpinSound(this));
    }

    protected ResourceLocation m_7582_() {
        return MeetYourFight.rl("dame_fortuna");
    }

    private static class DoTheShuffle
    extends StationaryAttack {
        private DameFortunaEntity dame;
        private LivingEntity target;
        private int timer;

        public DoTheShuffle(DameFortunaEntity dame) {
            super((Mob)dame, 4.0);
            this.dame = dame;
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            this.dame.attackCooldown = 2;
            this.target = this.dame.m_5448_();
            this.dame.setAnimation(7);
            this.dame.m_5496_((SoundEvent)MYFSounds.dameFortunaAttack.get(), this.dame.m_6121_(), this.dame.m_6100_());
            this.timer = Math.max(40, this.dame.shuffleAttackWait + 30);
        }

        @Override
        public void m_8037_() {
            super.m_8037_();
            this.dame.attackCooldown = 2;
            --this.timer;
            if (this.timer <= 0 && !this.dame.hasSpawnedShuffle) {
                this.dame.hasSpawnedShuffle = true;
                Direction dir = Direction.m_122366_((double)(this.target.m_20185_() - this.dame.m_20185_()), (double)0.0, (double)(this.target.m_20189_() - this.dame.m_20189_()));
                Direction side = dir.m_122427_();
                int cards = 2;
                if (this.dame.phase == 3) {
                    cards = 3;
                } else if (this.dame.phase == 5) {
                    cards = 4;
                }
                int[] shuffled = new int[cards];
                for (int i = 0; i < cards; ++i) {
                    shuffled[i] = i;
                }
                this.shuffle(shuffled);
                int correct = this.dame.f_19796_.m_188503_(cards);
                BlockPos center = BlockPos.m_274561_((double)this.dame.m_20185_(), (double)(this.target.m_20186_() + 1.0), (double)this.dame.m_20189_());
                Vec3 start = new Vec3((double)center.m_123341_() - (double)side.m_122429_() * 1.5 * (double)(cards - 1), (double)center.m_123342_(), (double)center.m_123343_() - (double)side.m_122431_() * 1.5 * (double)(cards - 1));
                int sus = this.dame.f_19796_.m_188503_(1000) == 0 ? this.dame.f_19796_.m_188503_(cards) : -1;
                for (int i = 0; i < cards; ++i) {
                    FortunaCardEntity card = new FortunaCardEntity(this.dame.m_9236_(), start.f_82479_ + (double)(3 * i * side.m_122429_()), start.f_82480_, start.f_82481_ + (double)(3 * i * side.m_122431_()));
                    card.m_146922_(dir.m_122435_());
                    int angleOffset = (i * (360 / cards) + 360 - (int)dir.m_122435_()) % 360;
                    card.setup(i == sus ? 4 : i, correct == sus ? 4 : correct, i == correct, i * 10 + 5, center.m_123341_(), center.m_123342_() + 3, center.m_123343_(), angleOffset, start.f_82479_ + (double)(3 * shuffled[i] * side.m_122429_()), start.f_82480_, start.f_82481_ + (double)(3 * shuffled[i] * side.m_122431_()));
                    this.dame.m_9236_().m_7967_((Entity)card);
                }
                this.timer = 110;
            } else if (this.timer == 10 && !this.dame.hasSpawnedShuffle) {
                this.dame.m_5496_((SoundEvent)MYFSounds.dameFortunaSnap.get(), 2.0f, (this.dame.f_19796_.m_188501_() - this.dame.f_19796_.m_188501_()) * 0.1f + 1.0f);
                this.dame.setAnimation(8);
            } else if (this.timer == 90 && this.dame.hasSpawnedShuffle) {
                this.dame.setAnimation(0);
            }
        }

        private void shuffle(int[] arr) {
            for (int i = 0; i < arr.length - 1; ++i) {
                int j = this.dame.f_19796_.m_216339_(i, arr.length);
                int swap = arr[i];
                arr[i] = arr[j];
                arr[j] = swap;
            }
        }

        public boolean m_8036_() {
            return this.dame.isShuffling() && !this.dame.hasSpawnedShuffle && this.dame.m_5448_() != null && this.dame.m_5448_().m_6084_();
        }

        public boolean m_8045_() {
            return !this.dame.hasSpawnedShuffle || this.timer > 0;
        }
    }

    private static class WaitShuffle
    extends StationaryAttack {
        private DameFortunaEntity dame;

        public WaitShuffle(DameFortunaEntity dame) {
            super((Mob)dame, 4.0);
            this.dame = dame;
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            this.dame.setAnimation(9);
        }

        public void m_8041_() {
            this.dame.setAnimation(0);
            this.dame.attackCooldown = 20;
        }

        public boolean m_8045_() {
            return this.dame.isShuffling();
        }

        public boolean m_8036_() {
            return this.dame.isShuffling() && this.dame.hasSpawnedShuffle;
        }
    }

    private static class EndPose
    extends StationaryAttack {
        private DameFortunaEntity dame;
        private int patience;

        public EndPose(DameFortunaEntity dame) {
            super((Mob)dame);
            this.dame = dame;
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            this.dame.setAnimation(10);
            this.patience = 600;
            if (this.dame.m_5448_() != null) {
                this.stationaryY = this.dame.m_5448_().m_20186_() + 1.0;
            }
        }

        @Override
        public void m_8037_() {
            super.m_8037_();
            --this.patience;
            if (this.patience <= 0) {
                this.dame.m_21153_(this.dame.m_21233_() * 0.21666667f);
                this.dame.setPhase(4);
                this.dame.phase = 4;
                this.dame.attackCooldown = 20;
                this.dame.setAnimation(0);
            }
        }

        public boolean m_8036_() {
            return this.dame.phase == 6;
        }
    }

    private static class SpinAttack
    extends Goal {
        private DameFortunaEntity dame;
        private int timer;
        private int chipsLeft;
        private int attackPhase;
        private double holdx;
        private double holdy;
        private double holdz;

        public SpinAttack(DameFortunaEntity dame) {
            this.dame = dame;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            return this.dame.nextAttack == 1 && this.dame.isAttackPhase() && this.dame.attackCooldown <= 0 && this.dame.m_5448_() != null && this.dame.m_5448_().m_6084_();
        }

        public boolean m_8045_() {
            return this.m_8036_() && (this.chipsLeft > 0 || this.timer > 0);
        }

        public void m_8056_() {
            this.timer = 20;
            this.chipsLeft = 5 + this.dame.f_19796_.m_188503_(3);
            if (this.dame.phase == 2) {
                this.chipsLeft = 10 + this.dame.f_19796_.m_188503_(5);
            } else if (this.dame.phase == 4) {
                this.chipsLeft = 20 + this.dame.f_19796_.m_188503_(9);
            }
            this.attackPhase = 0;
            this.holdx = this.dame.m_20185_();
            this.holdy = this.dame.m_5448_().m_20186_() + 1.0;
            this.holdz = this.dame.m_20189_();
            this.dame.f_21342_.m_6849_(this.holdx, this.holdy, this.holdz, 1.0);
            this.dame.setAnimation(5);
            this.dame.m_5496_((SoundEvent)MYFSounds.dameFortunaSpinStart.get(), 2.0f, 1.0f);
            this.dame.m_5496_((SoundEvent)MYFSounds.dameFortunaAttack.get(), this.dame.m_6121_(), this.dame.m_6100_());
        }

        public void m_8037_() {
            --this.timer;
            LivingEntity target = this.dame.m_5448_();
            if (target == null) {
                return;
            }
            if (this.attackPhase == 0) {
                this.dame.f_21342_.m_6849_(this.holdx, this.holdy, this.holdz, 1.0);
                if (this.timer <= 0) {
                    this.attackPhase = 1;
                    this.timer = 10;
                }
            } else if (this.attackPhase == 1) {
                this.dame.f_21342_.m_6849_(target.m_20185_(), target.m_20186_() + 1.0, target.m_20189_(), 0.4);
                if (this.timer <= 0) {
                    this.fireChips(target);
                    --this.chipsLeft;
                    if (this.chipsLeft > 0) {
                        this.timer = this.dame.phase == 4 ? 6 : (this.dame.phase == 2 ? 12 : 20);
                    } else {
                        this.attackPhase = 2;
                        this.timer = 30;
                        this.holdx = this.dame.m_20185_();
                        this.holdy = target.m_20186_() + 1.0;
                        this.holdz = this.dame.m_20189_();
                        this.dame.f_21342_.m_6849_(this.holdx, this.holdy, this.holdz, 1.0);
                        this.dame.setAnimation(6);
                        this.dame.m_5496_((SoundEvent)MYFSounds.dameFortunaSpinStop.get(), 2.0f, 1.0f);
                    }
                }
            } else {
                this.dame.f_21342_.m_6849_(this.holdx, this.holdy, this.holdz, 1.0);
            }
        }

        private void fireChips(LivingEntity target) {
            Vec3 perp = this.dame.m_20154_().m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
            perp = perp.m_82524_(this.dame.f_19796_.m_188501_() * ((float)Math.PI * 2));
            double sy = this.dame.m_20186_() + 1.0;
            this.dame.shuffleAttackWait = Math.max(this.dame.shuffleAttackWait, 10);
            double damex = this.dame.m_20185_();
            double damez = this.dame.m_20189_();
            ProjectileTargetedEntity proj = this.dame.readyTargeted();
            proj.m_6034_(damex, sy, damez);
            proj.setUp(10, 15, (Entity)target, 1.0, damex + 1.0 * perp.f_82479_, sy + 1.0, damez + 1.0 * perp.f_82481_);
            this.dame.m_9236_().m_7967_((Entity)proj);
        }

        public void m_8041_() {
            this.dame.cooldownNextAttack();
            this.dame.rollNextAttack(1);
            if (this.dame.isAttackPhase()) {
                this.dame.setAnimation(0);
            }
        }
    }

    private static class DiceAttack
    extends StationaryAttack {
        private DameFortunaEntity dame;
        private LivingEntity target;
        private int attackRemaining;
        private int attackDelay;

        public DiceAttack(DameFortunaEntity dame) {
            super((Mob)dame);
            this.dame = dame;
        }

        public boolean m_8036_() {
            return this.dame.nextAttack == 0 && this.dame.isAttackPhase() && this.dame.attackCooldown <= 0 && this.dame.m_5448_() != null && this.dame.m_5448_().m_6084_();
        }

        public boolean m_8045_() {
            return this.dame.nextAttack == 0 && (this.attackDelay > 0 || this.attackRemaining > 0) && this.target.m_6084_() && this.dame.isAttackPhase();
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            this.target = this.dame.m_5448_();
            this.dame.setAnimation(3);
            this.attackDelay = 30;
            this.attackRemaining = this.getAttackCount();
            this.dame.m_5496_((SoundEvent)MYFSounds.dameFortunaAttack.get(), this.dame.m_6121_(), this.dame.m_6100_());
        }

        private int getAttackCount() {
            if (this.dame.phase == 2) {
                return 4 + this.dame.f_19796_.m_188503_(3);
            }
            if (this.dame.phase == 4) {
                return 8 + this.dame.f_19796_.m_188503_(4);
            }
            return 2 + this.dame.f_19796_.m_188503_(2);
        }

        @Override
        public void m_8037_() {
            super.m_8037_();
            --this.attackDelay;
            if (this.attackDelay <= 0 && this.attackRemaining > 0) {
                --this.attackRemaining;
                this.dame.setAnimation(4);
                this.performAttack();
            }
            if (this.attackDelay == (this.dame.phase == 4 ? 8 : 10) && this.attackRemaining > 0) {
                this.dame.setAnimation(3);
            }
        }

        private void performAttack() {
            double tx = this.target.m_20185_();
            double ty = this.target.m_20186_();
            double tz = this.target.m_20189_();
            this.attackDelay = this.attackRemaining == 0 ? 40 : (this.dame.phase == 4 ? 12 : 20);
            this.dame.shuffleAttackWait = Math.max(this.dame.shuffleAttackWait, 30);
            Vec3 offset = new Vec3(this.dame.m_20185_() - tx, 0.0, this.dame.m_20189_() - tz).m_82541_().m_82524_(Mth.m_14177_((float)(this.dame.f_19796_.m_188501_() * 60.0f - 30.0f)) * ((float)Math.PI / 180));
            double bombX = tx + offset.f_82479_ * 3.0;
            double bombY = ty + 0.5;
            double bombZ = tz + offset.f_82481_ * 3.0;
            if (this.target.m_20096_()) {
                bombY += 0.75;
            }
            FortunaBombEntity bomb = new FortunaBombEntity(this.dame.m_9236_(), this.dame.m_20185_(), this.dame.m_20186_() + 2.0, this.dame.m_20189_(), (LivingEntity)this.dame);
            int dettime = this.dame.phase == 0 ? 0 : this.dame.f_19796_.m_188503_(11);
            bomb.setup(25 + dettime, 15 + dettime, bombX, bombY, bombZ);
            this.dame.m_9236_().m_7967_((Entity)bomb);
            this.dame.m_5496_((SoundEvent)MYFSounds.dameFortunaShoot.get(), 2.0f, (this.dame.f_19796_.m_188501_() - this.dame.f_19796_.m_188501_()) * 0.2f + 1.0f);
        }

        public void m_8041_() {
            this.dame.cooldownNextAttack();
            this.dame.rollNextAttack(0);
            if (this.dame.isAttackPhase()) {
                this.dame.setAnimation(0);
            }
        }
    }

    private static class ChipsAttack
    extends StationaryAttack {
        private DameFortunaEntity dame;
        private LivingEntity target;
        private int attackRemaining;
        private int attackDelay;
        private int chosenPattern;
        private int circleDelay;
        private int circleDirection;
        private int clapTime;
        private int midStrafe;

        public ChipsAttack(DameFortunaEntity dame) {
            super((Mob)dame);
            this.dame = dame;
        }

        public boolean m_8036_() {
            return this.dame.nextAttack >= 2 && this.dame.nextAttack <= 3 && this.dame.isAttackPhase() && this.dame.attackCooldown <= 0 && this.dame.m_5448_() != null && this.dame.m_5448_().m_6084_();
        }

        public boolean m_8045_() {
            return this.dame.nextAttack >= 2 && this.dame.nextAttack <= 3 && (this.attackDelay > 0 || this.attackRemaining > 0) && this.target.m_6084_() && this.dame.isAttackPhase();
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            this.target = this.dame.m_5448_();
            this.dame.setAnimation(1);
            this.attackDelay = 20;
            this.dame.m_5496_((SoundEvent)MYFSounds.dameFortunaAttack.get(), this.dame.m_6121_(), this.dame.m_6100_());
            this.chosenPattern = this.dame.nextAttack;
            switch (this.chosenPattern) {
                default: {
                    this.midStrafe = 0;
                    if (this.dame.phase == 4) {
                        this.attackRemaining = 3 + this.dame.f_19796_.m_188503_(2);
                        this.midStrafe = 4 + this.dame.f_19796_.m_188503_(2);
                        this.attackRemaining += this.midStrafe;
                    } else {
                        this.attackRemaining = this.dame.phase == 2 ? 3 + this.dame.f_19796_.m_188503_(2) : 3;
                    }
                    this.circleDelay = 15 * (this.midStrafe > 0 ? this.attackRemaining - this.midStrafe : this.attackRemaining) + 5;
                    this.circleDirection = this.dame.f_19796_.m_188499_() ? 1 : -1;
                    this.clapTime = this.midStrafe > 0 ? 7 : 32;
                    break;
                }
                case 3: {
                    this.attackRemaining = 2;
                    this.clapTime = 17;
                    break;
                }
                case 0: {
                    this.attackRemaining = 2;
                }
            }
        }

        @Override
        public void m_8037_() {
            super.m_8037_();
            --this.attackDelay;
            if (this.attackRemaining > 0 && this.attackRemaining != this.midStrafe) {
                if (this.attackDelay <= 0) {
                    --this.attackRemaining;
                    this.dame.setAnimation(2);
                    this.performAttack();
                } else if (this.attackDelay == 15) {
                    this.dame.setAnimation(1);
                }
            } else if (this.attackDelay == this.clapTime) {
                this.dame.setAnimation(11);
            } else if (this.attackDelay == this.clapTime - 2) {
                this.dame.m_5496_((SoundEvent)MYFSounds.dameFortunaClap.get(), 2.0f, (this.dame.f_19796_.m_188501_() - this.dame.f_19796_.m_188501_()) * 0.1f + 1.0f);
            } else if (this.attackDelay <= 0 && this.attackRemaining > 0 && this.attackRemaining == this.midStrafe) {
                --this.attackRemaining;
                this.midStrafe = 0;
                this.circleDelay = 15 * this.attackRemaining + 5;
                this.clapTime = 32;
                this.attackDelay = 20;
                this.rotateAroundTarget();
            }
        }

        private void performAttack() {
            this.attackDelay = 45;
            if (this.chosenPattern == 2 && this.attackRemaining > 0) {
                this.attackDelay = 20;
            }
            switch (this.chosenPattern) {
                default: {
                    this.fireChipsCircle(8, 1, this.circleDelay + 5 * (this.midStrafe > 0 ? this.attackRemaining - this.midStrafe : this.attackRemaining));
                    if (this.attackRemaining <= 0 || this.attackRemaining == this.midStrafe) break;
                    this.rotateAroundTarget();
                    break;
                }
                case 3: {
                    if (this.attackRemaining == 1) {
                        this.fireChipsStack(this.dame.phase == 4 ? 20 : 16);
                        break;
                    }
                    this.fireChipsCircle(8, (this.dame.phase == 4 ? 5 : 3) + this.dame.f_19796_.m_188503_(2), 35);
                    break;
                }
                case 0: {
                    this.attackRemaining = 2;
                }
            }
        }

        private void rotateAroundTarget() {
            float angle = (float)(this.dame.f_19796_.m_188503_(4) + 4) * 10.0f * ((float)Math.PI / 180) * (float)this.circleDirection;
            Vec3 offset = new Vec3(this.dame.m_20185_() - this.target.m_20185_(), 0.0, this.dame.m_20189_() - this.target.m_20189_()).m_82541_().m_82524_(angle);
            double distance = this.dame.f_19796_.m_188500_() * 2.0 + 4.0;
            this.dame.m_21566_().m_6849_(this.target.m_20185_() + offset.f_82479_ * distance, this.target.m_20186_() + 1.0 + this.dame.f_19796_.m_188500_() * 2.0, this.target.m_20189_() + offset.f_82481_ * distance, 3.0);
        }

        private void fireChipsStack(int number) {
            Vec3 perp = this.dame.m_20154_().m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
            double sy = this.dame.m_20186_() + 1.0;
            this.dame.shuffleAttackWait = Math.max(this.dame.shuffleAttackWait, 38 + number * 6);
            for (int dir = -1; dir <= 1; dir += 2) {
                double sx = this.dame.m_20185_() + perp.f_82479_ * (double)dir;
                double sz = this.dame.m_20189_() + perp.f_82481_ * (double)dir;
                int intialdelay = dir == -1 ? 35 : 38;
                for (int i = 0; i < number; ++i) {
                    ProjectileTargetedEntity proj = this.dame.readyTargeted();
                    proj.m_6034_(sx, sy + (double)i * 0.125, sz);
                    proj.setUp(intialdelay + (number - i - 1) * 6, 15, (Entity)this.target, 0.75, sx, sy + (double)i * 0.25 + 0.25, sz, dir * -20);
                    this.dame.m_9236_().m_7967_((Entity)proj);
                }
            }
            this.dame.m_5496_((SoundEvent)MYFSounds.dameFortunaChipsStart.get(), 2.0f, (this.dame.f_19796_.m_188501_() - this.dame.f_19796_.m_188501_()) * 0.2f + 1.0f);
        }

        private void fireChipsCircle(int chips, int circles, int delay) {
            Vec3 perp = this.dame.m_20154_().m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
            double sy = this.dame.m_20186_() + 1.0;
            float angle = (float)Math.PI * 2 / (float)chips;
            this.dame.shuffleAttackWait = Math.max(this.dame.shuffleAttackWait, 35 + 15 * (circles - 1));
            double damex = this.dame.m_20185_();
            double damez = this.dame.m_20189_();
            double sx = damex;
            double sz = damez;
            for (int c = 0; c < circles; ++c) {
                Vec3 offset = perp;
                for (int i = 0; i < chips; ++i) {
                    ProjectileTargetedEntity proj = this.dame.readyTargeted();
                    proj.m_6034_(sx, sy + (double)(c * chips + i) * 0.125, sz);
                    proj.setUp(delay + 15 * c, 15, (Entity)this.target, 1.0, damex + 2.0 * offset.f_82479_, sy + 1.0 + (double)c, damez + 2.0 * offset.f_82481_);
                    this.dame.m_9236_().m_7967_((Entity)proj);
                    offset = offset.m_82524_(angle);
                }
            }
            this.dame.m_5496_((SoundEvent)MYFSounds.dameFortunaChipsStart.get(), 2.0f, (this.dame.f_19796_.m_188501_() - this.dame.f_19796_.m_188501_()) * 0.2f + 1.0f);
        }

        public void m_8041_() {
            this.dame.cooldownNextAttack();
            this.dame.rollNextAttack(this.chosenPattern);
            if (this.dame.isAttackPhase()) {
                this.dame.setAnimation(0);
            }
        }
    }
}

