/*
 * Decompiled with CFR 0.152.
 */
package lykrast.meetyourfight.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class MYFConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final MYFConfig COMMON;
    public final ForgeConfigSpec.DoubleValue swampjawHealth;
    public final ForgeConfigSpec.DoubleValue swampjawMelee;
    public final ForgeConfigSpec.DoubleValue swampjawExplosion;
    public final ForgeConfigSpec.DoubleValue bellringerHealth;
    public final ForgeConfigSpec.DoubleValue bellringerDamage;
    public final ForgeConfigSpec.DoubleValue fortunaHealth;
    public final ForgeConfigSpec.DoubleValue fortunaDamage;
    public final ForgeConfigSpec.DoubleValue rosalyneHealth;
    public final ForgeConfigSpec.DoubleValue rosalyneMelee;
    public final ForgeConfigSpec.DoubleValue rosalyneProjectile;
    public final ForgeConfigSpec.DoubleValue cagedHeartTreshold;
    public final ForgeConfigSpec.DoubleValue cagedHeartMultiplier;
    public final ForgeConfigSpec.DoubleValue boneRakerBonus;
    public final ForgeConfigSpec.IntValue spectresEyeRange;
    public final ForgeConfigSpec.IntValue passagesTollRange;
    public final ForgeConfigSpec.DoubleValue slicerDiceChance;
    public final ForgeConfigSpec.DoubleValue slicerDiceMultiplier;
    public final ForgeConfigSpec.DoubleValue aceOfIronChance;
    public final ForgeConfigSpec.DoubleValue cocktailCutlassChance;
    public final ForgeConfigSpec.DoubleValue jagershotChance;
    public final ForgeConfigSpec.BooleanValue slicerDiceLuck;
    public final ForgeConfigSpec.BooleanValue aceOfIronLuck;
    public final ForgeConfigSpec.BooleanValue cocktailCutlassLuck;
    public final ForgeConfigSpec.BooleanValue jagershotLuck;
    public final ForgeConfigSpec.DoubleValue wiltedIdealsMultiplier;
    public final ForgeConfigSpec.DoubleValue wiltedIdealsPenalty;
    public final ForgeConfigSpec.DoubleValue blossomingMindBonus;
    public final ForgeConfigSpec.IntValue blossomingMindCap;

    public MYFConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Boss stats");
        builder.comment("Changing any of these values will change the recommended gear in the summoning item's tooltip to a notice");
        builder.push("stats");
        builder.comment("Swampjaw");
        builder.push("swampjaw");
        this.swampjawHealth = this.doubleval(builder, "health", 1.0, 0.1, 1000.0, "Max health multiplier for Swampjaw", "eg 2 means x2 max health", "Values above ~10 require AttributeFix mod", "Will not apply to already spawned bosses");
        this.swampjawMelee = this.doubleval(builder, "melee", 1.0, 0.1, 1000.0, "Damage multiplier for Swampjaw's charge", "eg 2 means x2 damage", "Values above ~170 require AttributeFix mod", "Will not apply to already spawned bosses");
        this.swampjawExplosion = this.doubleval(builder, "explosion", 2.5, 0.1, 20.0, "Explosion strength for Swampjaw's mines", "eg ghast fireballs are 1, creepers are 3, tnt 4, charged creeper 6");
        builder.pop();
        builder.comment("Bellringer");
        builder.push("bellringer");
        this.bellringerHealth = this.doubleval(builder, "health", 1.0, 0.1, 1000.0, "Max health multiplier for Bellringer", "eg 2 means x2 max health", "Values above ~5 require AttributeFix mod", "Will not apply to already spawned bosses");
        this.bellringerDamage = this.doubleval(builder, "damage", 1.0, 0.1, 1000.0, "Damage multiplier for Bellringer's projectiles", "eg 2 means x2 damage");
        builder.pop();
        builder.comment("Dame Fortuna");
        builder.push("fortuna");
        this.fortunaHealth = this.doubleval(builder, "health", 1.0, 0.1, 1000.0, "Max health multiplier for Dame Fortuna, very low values may lead to skipped/wonky card transitions", "eg 2 means x2 max health", "Values above ~3.4 require AttributeFix mod", "Will not apply to already spawned bosses");
        this.fortunaDamage = this.doubleval(builder, "damage", 1.0, 0.1, 1000.0, "Damage multiplier for Dame Fortuna's projectiles", "eg 2 means x2 damage");
        builder.pop();
        builder.comment("Rosalyne");
        builder.push("rosalyne");
        this.rosalyneHealth = this.doubleval(builder, "health", 1.0, 0.1, 1000.0, "Max health multiplier for Rosalyne and her spirits", "eg 2 means x2 max health", "Values above ~2 require AttributeFix mod", "Will not apply to already spawned bosses");
        this.rosalyneMelee = this.doubleval(builder, "melee", 1.0, 0.1, 1000.0, "Damage multiplier for Rosalyne's melee swings", "eg 2 means x2 damage", "Values above ~85 require AttributeFix mod", "Will not apply to already spawned bosses");
        this.rosalyneProjectile = this.doubleval(builder, "projectile", 1.0, 0.1, 1000.0, "Damage multiplier for Rosalyne's spirits' projectiles", "eg 2 means x2 damage");
        builder.pop();
        builder.pop();
        builder.comment("Boss items");
        builder.push("items");
        builder.comment("Swampjaw");
        builder.push("swampjaw");
        this.cagedHeartTreshold = this.doubleval(builder, "cagedHeartTreshold", 0.25, 0.0, 1.0, "Caged Heart will reduce damage over this fraction of max health", "eg 0.25 means it reduces damage over 25% max health");
        this.cagedHeartMultiplier = this.doubleval(builder, "cagedHeartMultiplier", 0.5, 0.0, 1.0, "Caged Heart's damage multiplier for damage above the treshold", "eg 0.25 multiplies damage by 0.25 = 75% reduction");
        this.boneRakerBonus = this.doubleval(builder, "boneRakerBonus", 2.0, 0.0, 100.0, "Bone Raker bonus attack damage", "Need to reequip or restart world to take effect");
        builder.pop();
        builder.comment("Bellringer");
        builder.push("bellringer");
        this.spectresEyeRange = this.intval(builder, "spectresEyeRange", 32, 1, 64, "Range of the Spectre's Eye in blocks");
        this.passagesTollRange = this.intval(builder, "passagesTollRange", 16, 1, 64, "Max range of the Passage's Toll in blocks");
        builder.pop();
        builder.comment("Dame Fortuna");
        builder.push("fortuna");
        this.slicerDiceChance = this.doubleval(builder, "slicerDiceChance", 0.16666666666666666, 0.01, 1.0, "Chance that the Slicer's Dice increases damage", "eg 0.25 means 25% chance");
        this.slicerDiceMultiplier = this.doubleval(builder, "slicerDiceMultiplier", 2.0, 1.0, 100.0, "Damage multiplier of the Slicer's Dice", "eg 2 means x2 damage = +100% damage");
        this.slicerDiceLuck = this.boolval(builder, "slicerDiceLuck", true, "Whether the Slicer's Dice proc chance is affected by luck", "When positive luck, it's (1+luck)/((1/chance)+luck)", "When negative luck, it's 1/((1/chance)-3*luck)");
        this.aceOfIronChance = this.doubleval(builder, "aceOfIronChance", 0.16666666666666666, 0.01, 1.0, "Chance that the Ace of Iron blocks damage", "eg 0.25 means 25% chance");
        this.aceOfIronLuck = this.boolval(builder, "aceOfIronLuck", true, "Whether the Ace of Iron proc chance is affected by luck", "There is a soft cap of 50% chance, so if the base chance exceeds that, positive luck won't do anything either way", "When positive luck, it's (1+luck)/((1/chance)+2*luck)", "When negative luck, it's 1/((1/chance)-3*luck)");
        this.cocktailCutlassChance = this.doubleval(builder, "cocktailCutlassChance", 0.2, 0.01, 1.0, "Chance that the Cocktail Cutlass gives a potion effect", "eg 0.25 means 25% chance");
        this.cocktailCutlassLuck = this.boolval(builder, "cocktailCutlassLuck", true, "Whether the Cocktail Cutlass proc chance is affected by luck", "When positive luck, it's (1+luck)/((1/chance)+0.5*luck)", "When negative luck, it's 1/((1/chance)-luck)");
        this.jagershotChance = this.doubleval(builder, "jagershotChance", 0.3333333333333333, 0.01, 1.0, "Chance that the Jagershot (Guns Without Roses compat) shoots a splash potion", "eg 0.25 means 25% chance");
        this.jagershotLuck = this.boolval(builder, "jagershotLuck", true, "Whether the Jagershot proc chance is affected by luck", "When positive luck, it's (1+luck)/((1/chance)+0.5*luck)", "When negative luck, it's 1/((1/chance)-luck)");
        builder.pop();
        builder.comment("Rosalyne");
        builder.push("rosalyne");
        this.wiltedIdealsMultiplier = this.doubleval(builder, "wiltedIdealsMultiplier", 1.5, 1.0, 100.0, "Damage multiplier of the Wilted Ideals", "eg 2 means x2 damage = +100% damage");
        this.wiltedIdealsPenalty = this.doubleval(builder, "wiltedIdealsPenalty", 0.5, 0.0, 0.9, "Percent max health penalty from the Wilted Ideals", "eg 0.4 means -40% max health", "Need to reequip or restart world to take effect");
        this.blossomingMindBonus = this.doubleval(builder, "blossomingMindBonus", 1.0, 0.0, 100.0, "Average bonus experience (relative to the mob's xp drop) the Blossoming Mind gives", "eg 0.6 means adds an average of 0.6x the base xp drops (so +60%)");
        this.blossomingMindCap = this.intval(builder, "blossomingMindCap", 10, 1, 10000, "Maximum bonus experiece the Blossoming Mind can give per kill", "The actual amount can vary between 0.5 and 1.5 times that and still depends on the experience dropped by the monster", "I capped it so that it's not 'optimal' to use it for bosses");
        builder.pop();
        builder.pop();
    }

    private ForgeConfigSpec.IntValue intval(ForgeConfigSpec.Builder builder, String name, int def, int min, int max, String ... comments) {
        return builder.translation(name).comment(comments).comment("Default: " + def).defineInRange(name, def, min, max);
    }

    private ForgeConfigSpec.DoubleValue doubleval(ForgeConfigSpec.Builder builder, String name, double def, double min, double max, String ... comments) {
        return builder.translation(name).comment(comments).comment("Default: " + def).defineInRange(name, def, min, max);
    }

    private ForgeConfigSpec.BooleanValue boolval(ForgeConfigSpec.Builder builder, String name, boolean def, String ... comments) {
        return builder.translation(name).comment(comments).comment("Default: " + def).define(name, def);
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(MYFConfig::new);
        COMMON = (MYFConfig)specPair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
    }
}

