/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.util;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;

public class MathUtil {
    public static <T extends ParticleOptions> void createParticleDisk(Level world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, float radius, T type, RandomSource random) {
        int surfaceArea = Mth.m_14165_((double)(Math.PI * (double)radius * (double)radius));
        for (int j = 0; j < surfaceArea; ++j) {
            float h = random.m_188501_() * ((float)Math.PI * 2);
            float valueRange = Mth.m_14116_((float)random.m_188501_()) * radius;
            double xCoord = x + (double)(Mth.m_14089_((float)h) * valueRange);
            double zCoord = z + (double)(Mth.m_14031_((float)h) * valueRange);
            world.m_7106_(type, xCoord, y, zCoord, velocityX, velocityY, velocityZ);
        }
    }

    public static <T extends ParticleOptions> void createParticleCircle(Level world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, float radius, T type, RandomSource random, float thickness) {
        int surfaceArea = Mth.m_14165_((double)(Math.PI * (double)radius * (double)radius));
        for (int i = 0; i < surfaceArea; ++i) {
            float h = random.m_188501_() * ((float)Math.PI * 2);
            double circleThickness = (double)(radius - thickness) + (double)(radius - (radius - thickness)) * random.m_188500_();
            double xCoord = x + (double)Mth.m_14031_((float)h) * circleThickness;
            double zCoord = z + (double)Mth.m_14089_((float)h) * circleThickness;
            world.m_7106_(type, xCoord, y + 0.5, zCoord, velocityX, velocityY, velocityZ);
        }
    }

    public static <T extends ParticleOptions> void createParticleSpiral(Level world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, int length, T type, RandomSource random) {
        double yCoord = y + 1.1;
        for (int i = 0; i < length; ++i) {
            float densityFactor = (float)i / 25.0f;
            double xCoord = x + (double)Mth.m_14031_((float)densityFactor);
            yCoord += 0.025;
            double zCoord = z + (double)Mth.m_14089_((float)densityFactor);
            if (random.m_188503_(10) != 0) continue;
            world.m_7106_(type, xCoord, yCoord, zCoord, velocityX, velocityY, velocityZ);
        }
    }

    public static <T extends ParticleOptions> void createParticleFlare(Level world, double x, double y, double z, int length, T type, T type2, RandomSource random, boolean inverted) {
        double yCoord = y + 1.1;
        double yDeviation = !inverted ? random.m_188500_() / 8.0 + 0.01 : -random.m_188500_() / 8.0 - 0.01;
        double xDeviation = -1.0 + 2.0 * random.m_188500_();
        double zDeviation = -1.0 + 2.0 * random.m_188500_();
        double curvatureFactor = random.m_188503_(5) + 1;
        for (int j = 1; j < length; ++j) {
            float densityFactor = (float)j / 25.0f;
            double xDeviationVector = (double)densityFactor * xDeviation;
            double zDeviationVector = (double)densityFactor * zDeviation;
            double curvature = Mth.m_14089_((float)densityFactor);
            int k = 0;
            while ((double)k < curvatureFactor) {
                curvature *= curvature;
                ++k;
            }
            double xCoord = x + (curvature + xDeviationVector);
            double zCoord = z + ((double)Mth.m_14089_((float)densityFactor) + zDeviationVector);
            world.m_7106_(random.m_188499_() ? type : type2, xCoord, yCoord += yDeviation, zCoord, 0.0, 0.0, 0.0);
        }
    }
}

