/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.forge;

import com.lion.graveyard.Graveyard;
import com.lion.graveyard.GraveyardClient;
import com.lion.graveyard.init.TGProcessors;
import com.lion.graveyard.network.PacketHandler;
import com.lion.graveyard.platform.forge.NamelessHangedTradeOfferResourceListener;
import com.lion.graveyard.platform.forge.RegistryHelperImpl;
import com.lion.graveyard.util.SpawnHordeCommand;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod(value="graveyard")
public class GraveyardForge {
    public GraveyardForge() {
        Graveyard.init();
        PacketHandler.registerMessages();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            GraveyardClient.init();
        }
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        RegistryHelperImpl.SOUNDS.register(bus);
        RegistryHelperImpl.BLOCKS.register(bus);
        RegistryHelperImpl.ITEMS.register(bus);
        RegistryHelperImpl.TILE_ENTITIES.register(bus);
        RegistryHelperImpl.ENTITIES.register(bus);
        RegistryHelperImpl.PARTICLES.register(bus);
        RegistryHelperImpl.STRUCTURE_TYPES.register(bus);
        RegistryHelperImpl.FEATURES.register(bus);
        RegistryHelperImpl.TRUNK_PLACERS.register(bus);
        RegistryHelperImpl.RECIPE_TYPES.register(bus);
        RegistryHelperImpl.RECIPE_SERIALIZERS.register(bus);
        RegistryHelperImpl.CREATIVE_TABS.register(bus);
        RegistryHelperImpl.MENUS.register(bus);
        bus.addListener(GraveyardForge::init);
        bus.addListener(GraveyardForge::registerEntityAttributes);
        bus.addListener(GraveyardForge::addItemsToTabs);
        forgeBus.register((Object)this);
        forgeBus.addListener(GraveyardForge::registerCommands);
        forgeBus.addListener(GraveyardForge::registerResourceReloader);
    }

    private static void init(FMLCommonSetupEvent event) {
        Registry.m_122965_((Registry)BuiltInRegistries.f_256897_, (ResourceLocation)new ResourceLocation("graveyard", "remove_waterlogged_processor"), TGProcessors.REMOVE_WATERLOGGED);
        Registry.m_122965_((Registry)BuiltInRegistries.f_256897_, (ResourceLocation)new ResourceLocation("graveyard", "switch_spawner_processor"), TGProcessors.SWITCH_SPAWNER);
        Registry.m_122965_((Registry)BuiltInRegistries.f_256897_, (ResourceLocation)new ResourceLocation("graveyard", "waterlogged_crypt_processor"), TGProcessors.REMOVE_WATERLOGGED_CRYPT);
        event.enqueueWork(Graveyard::postInit);
    }

    @SubscribeEvent
    public static void registerResourceReloader(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new NamelessHangedTradeOfferResourceListener());
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        SpawnHordeCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void registerEntityAttributes(EntityAttributeCreationEvent event) {
        for (Map.Entry<Supplier<? extends EntityType<? extends LivingEntity>>, Supplier<AttributeSupplier.Builder>> entry : RegistryHelperImpl.ENTITY_ATTRIBUTES.entrySet()) {
            event.put(entry.getKey().get(), entry.getValue().get().m_22265_());
        }
    }

    @SubscribeEvent
    public static void addItemsToTabs(BuildCreativeModeTabContentsEvent event) {
        RegistryHelperImpl.ITEMS_TO_ADD.forEach((itemGroup, itemPairs) -> {
            if (event.getTabKey() == itemGroup) {
                itemPairs.forEach(item -> event.getEntries().put((Object)item.m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
            }
        });
    }
}

