/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.entities;

import com.lion.graveyard.util.MathUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FallingCorpse
extends Monster
implements GeoEntity {
    private AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation FALLING_ANIMATION = RawAnimation.begin().then("falling", Animation.LoopType.LOOP);
    private final RawAnimation LANDING_ANIMATION = RawAnimation.begin().then("landing", Animation.LoopType.PLAY_ONCE).then("despawn", Animation.LoopType.PLAY_ONCE);
    private static final EntityDataAccessor<Boolean> IS_FALLING = SynchedEntityData.m_135353_(FallingCorpse.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_COLLIDED = SynchedEntityData.m_135353_(FallingCorpse.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final float DAMAGE = 10.0f;
    private int landingCounter = 40;
    private int levitationCounter = 15;
    private float rotation;

    public FallingCorpse(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
        this.f_21364_ = 0;
        this.setRotation(this.m_217043_().m_188503_(361));
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        this.m_20193_().m_5594_(null, this.m_20183_(), SoundEvents.f_12037_, SoundSource.HOSTILE, 2.0f, 1.0f);
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return source.m_269533_(DamageTypeTags.f_268630_);
    }

    public void m_183634_() {
        this.setIsFalling(false);
        super.m_183634_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_FALLING, (Object)true);
        this.f_19804_.m_135372_(HAS_COLLIDED, (Object)false);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar animationData) {
        animationData.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, event -> {
            if (this.isFalling()) {
                event.setAnimation(this.FALLING_ANIMATION);
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(this.LANDING_ANIMATION);
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public static AttributeSupplier.Builder createFallingCorpseAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22278_, 5.0);
    }

    public void m_8107_() {
        if (this.m_146900_().m_60795_()) {
            for (int i = 0; i < 10; ++i) {
                BlockPos pos = this.m_20183_().m_7918_(0, -i, 0);
                BlockState state = this.m_20193_().m_8055_(pos);
                if (state.m_60795_() || !state.m_60796_((BlockGetter)this.m_20193_(), pos)) continue;
                MathUtil.createParticleDisk(this.m_9236_(), (double)pos.m_123341_() + this.f_19796_.m_188500_(), (double)pos.m_123342_() + 1.3, (double)pos.m_123343_() + this.f_19796_.m_188500_(), 0.0, 0.0, 0.0, 1.0f, DustParticleOptions.f_123656_, this.m_217043_());
                break;
            }
        }
        super.m_8107_();
    }

    protected void m_8024_() {
        if (this.levitationCounter > 0) {
            --this.levitationCounter;
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.04, 0.0));
        } else {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        if (!this.isFalling() && this.landingCounter > 0) {
            --this.landingCounter;
        }
        if (this.landingCounter <= 0) {
            this.m_146870_();
        }
        if (!this.m_20193_().m_8055_(this.m_20183_().m_7495_()).m_60795_()) {
            this.setIsFalling(false);
        }
        if (this.m_146900_().m_60795_()) {
            this.setIsFalling(true);
        }
        super.m_8024_();
    }

    public void m_6123_(Player player) {
        if (!this.hasCollided() && this.isFalling()) {
            player.m_6469_(this.m_269291_().m_268989_(), 10.0f);
            this.setHasCollided(true);
        }
        super.m_6123_(player);
    }

    public boolean isFalling() {
        return (Boolean)this.f_19804_.m_135370_(IS_FALLING);
    }

    public void setIsFalling(boolean isFalling) {
        this.f_19804_.m_135381_(IS_FALLING, (Object)isFalling);
    }

    public boolean hasCollided() {
        return (Boolean)this.f_19804_.m_135370_(HAS_COLLIDED);
    }

    public void setHasCollided(boolean hasCollided) {
        this.f_19804_.m_135381_(HAS_COLLIDED, (Object)hasCollided);
    }
}

