/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.blocks;

import com.lion.graveyard.blockentities.BrazierBlockEntity;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BrazierBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty LIT;
    public static final BooleanProperty WATERLOGGED;
    public static final ToIntFunction<BlockState> STATE_TO_LUMINANCE;
    protected static final VoxelShape SHAPE;
    private ParticleOptions fireType;

    public BrazierBlock(BlockBehaviour.Properties settings, ParticleOptions fireType) {
        super(settings);
        this.fireType = fireType;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_150110_().f_35938_ && player.m_21120_(hand).m_41619_() && ((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            BrazierBlock.extinguish(player, state, (LevelAccessor)world, pos);
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos blockPos;
        Level worldAccess = ctx.m_43725_();
        boolean bl = worldAccess.m_6425_(blockPos = ctx.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(bl))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return direction == Direction.DOWN ? state : super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }

    public boolean m_7361_(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue() && fluidState.m_76152_() == Fluids.f_76193_) {
            BlockState blockState = (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
            if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                BrazierBlock.extinguish(null, blockState, world, pos);
            } else {
                world.m_7731_(pos, blockState, 3);
            }
            world.m_186469_(pos, fluidState.m_76152_(), fluidState.m_76152_().m_6718_((LevelReader)world));
            return true;
        }
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            if (random.m_188503_(20) == 0) {
                world.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11784_, SoundSource.BLOCKS, 0.2f + random.m_188501_(), random.m_188501_() * 0.7f + 0.6f, false);
            }
            for (int i = 0; i < 20; ++i) {
                world.m_7106_(this.fireType, (double)pos.m_123341_() + 0.25 + Math.abs(random.m_188500_() - 0.5), (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + 0.25 + Math.abs(random.m_188500_() - 0.5), 0.0, 0.01, 0.0);
            }
        }
    }

    public void m_5581_(Level world, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos blockPos = hit.m_82425_();
        if (!world.f_46443_ && projectile.m_6060_() && projectile.m_142265_(world, blockPos) && !((Boolean)state.m_61143_((Property)LIT)).booleanValue() && !((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_7731_(blockPos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 11);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BrazierBlockEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT, WATERLOGGED});
    }

    public static void extinguish(@Nullable Player player, BlockState state, LevelAccessor world, BlockPos pos) {
        BrazierBlock.setLit(world, state, pos, false);
        if (state.m_60734_() instanceof BrazierBlock) {
            RandomSource random = world.m_213780_();
            world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5 + random.m_188500_() / 4.0 * (double)(random.m_188499_() ? 1 : -1), (double)pos.m_123342_() + 0.4, (double)pos.m_123343_() + 0.5 + random.m_188500_() / 4.0 * (double)(random.m_188499_() ? 1 : -1), 0.0, 0.005, 0.0);
            world.m_7106_((ParticleOptions)ParticleTypes.f_123777_, (double)pos.m_123341_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), (double)pos.m_123342_() + random.m_188500_() + random.m_188500_(), (double)pos.m_123343_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), 0.0, 0.07, 0.0);
        }
        world.m_5594_((Player)null, pos, SoundEvents.f_144098_, SoundSource.BLOCKS, 1.0f, 1.0f);
        world.m_142346_((Entity)player, GameEvent.f_157792_, pos);
    }

    public static void spawnSmokeParticle(Level world, BlockPos pos, boolean lotsOfSmoke) {
        RandomSource random = world.m_213780_();
        SimpleParticleType defaultParticleType = ParticleTypes.f_123777_;
        world.m_6485_((ParticleOptions)defaultParticleType, true, (double)pos.m_123341_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), (double)pos.m_123342_() + random.m_188500_() + random.m_188500_(), (double)pos.m_123343_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), 0.0, 0.07, 0.0);
        if (lotsOfSmoke) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5 + random.m_188500_() / 4.0 * (double)(random.m_188499_() ? 1 : -1), (double)pos.m_123342_() + 0.4, (double)pos.m_123343_() + 0.5 + random.m_188500_() / 4.0 * (double)(random.m_188499_() ? 1 : -1), 0.0, 0.005, 0.0);
        }
    }

    private static void setLit(LevelAccessor world, BlockState state, BlockPos pos, boolean lit) {
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(lit)), 11);
    }

    static {
        SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)15.0);
        LIT = BlockStateProperties.f_61443_;
        WATERLOGGED = BlockStateProperties.f_61362_;
        STATE_TO_LUMINANCE = state -> (Boolean)state.m_61143_((Property)LIT) != false ? 11 : 0;
    }
}

