/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.blockentities;

import com.lion.graveyard.init.TGBlockEntities;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.network.FilteredText;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class GravestoneBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private UUID editor;
    private SignText text = this.createText();
    private boolean waxed;

    public GravestoneBlockEntity(BlockPos pos, BlockState state) {
        this(TGBlockEntities.GRAVESTONE_BLOCK_ENTITY.get(), pos, state);
    }

    public GravestoneBlockEntity(BlockEntityType blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    protected SignText createText() {
        return new SignText();
    }

    public SignText getText() {
        return this.text;
    }

    public int getTextLineHeight() {
        return 10;
    }

    public int getMaxTextWidth() {
        return 90;
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        DataResult var10000 = SignText.f_276558_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.text);
        Logger var10001 = LOGGER;
        Objects.requireNonNull(var10001);
        var10000.resultOrPartial(arg_0 -> ((Logger)var10001).error(arg_0)).ifPresent(frontText -> nbt.m_128365_("front_text", frontText));
        nbt.m_128379_("is_waxed", this.waxed);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("front_text")) {
            DataResult var10000 = SignText.f_276558_.parse((DynamicOps)NbtOps.f_128958_, (Object)nbt.m_128469_("front_text"));
            Logger var10001 = LOGGER;
            Objects.requireNonNull(var10001);
            var10000.resultOrPartial(arg_0 -> ((Logger)var10001).error(arg_0)).ifPresent(signText -> {
                this.text = this.parseLines((SignText)signText);
            });
        }
        this.waxed = nbt.m_128471_("is_waxed");
    }

    private SignText parseLines(SignText signText) {
        for (int i = 0; i < 4; ++i) {
            Component text = this.parseLine(signText.m_277138_(i, false));
            Component text2 = this.parseLine(signText.m_277138_(i, true));
            signText = signText.m_276948_(i, text, text2);
        }
        return signText;
    }

    private Component parseLine(Component text) {
        Level var3 = this.f_58857_;
        if (var3 instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)var3;
            try {
                return ComponentUtils.m_130731_((CommandSourceStack)GravestoneBlockEntity.createCommandSource(null, (Level)serverWorld, this.f_58858_), (Component)text, (Entity)null, (int)0);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return text;
    }

    public void tryChangeText(Player player, List<FilteredText> messages) {
        if (!this.isWaxed() && player.m_20148_().equals(this.getEditor()) && this.f_58857_ != null) {
            this.changeText(text -> this.getTextWithMessages(player, messages, (SignText)text));
            this.setEditor(null);
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        } else {
            LOGGER.warn("Player {} just tried to change non-editable sign", (Object)player.m_7755_().getString());
        }
    }

    public boolean changeText(UnaryOperator<SignText> textChanger) {
        SignText signText = this.getText();
        return this.setText((SignText)textChanger.apply(signText));
    }

    private SignText getTextWithMessages(Player player, List<FilteredText> messages, SignText text) {
        for (int i = 0; i < messages.size(); ++i) {
            FilteredText filteredMessage = messages.get(i);
            Style style = text.m_277138_(i, player.m_143387_()).m_7383_();
            text = player.m_143387_() ? text.m_276913_(i, (Component)Component.m_237113_((String)filteredMessage.m_243113_()).m_6270_(style)) : text.m_276948_(i, (Component)Component.m_237113_((String)filteredMessage.f_215168_()).m_6270_(style), (Component)Component.m_237113_((String)filteredMessage.m_243113_()).m_6270_(style));
        }
        return text;
    }

    public boolean setText(SignText text) {
        return this.setFrontText(text);
    }

    private boolean setFrontText(SignText frontText) {
        if (frontText != this.text) {
            this.text = frontText;
            this.updateListeners();
            return true;
        }
        return false;
    }

    public boolean runCommandClickEvent(Player player, Level world, BlockPos pos) {
        Component[] var6;
        boolean bl = false;
        for (Component text : var6 = this.getText().m_276945_(player.m_143387_())) {
            Style style = text.m_7383_();
            ClickEvent clickEvent = style.m_131182_();
            if (clickEvent == null || clickEvent.m_130622_() != ClickEvent.Action.RUN_COMMAND) continue;
            player.m_20194_().m_129892_().m_230957_(GravestoneBlockEntity.createCommandSource(player, world, pos), clickEvent.m_130623_());
            bl = true;
        }
        return bl;
    }

    private static CommandSourceStack createCommandSource(@Nullable Player player, Level world, BlockPos pos) {
        String string = player == null ? "Sign" : player.m_7755_().getString();
        MutableComponent text = player == null ? Component.m_237113_((String)"Sign") : player.m_5446_();
        return new CommandSourceStack(CommandSource.f_80164_, Vec3.m_82512_((Vec3i)pos), Vec2.f_82462_, (ServerLevel)world, 2, string, (Component)text, world.m_7654_(), (Entity)player);
    }

    public ClientboundBlockEntityDataPacket toUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public boolean m_6326_() {
        return true;
    }

    public void setEditor(@Nullable UUID editor) {
        this.editor = editor;
    }

    @Nullable
    public UUID getEditor() {
        return this.editor;
    }

    private void updateListeners() {
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public boolean isWaxed() {
        return this.waxed;
    }

    public boolean setWaxed(boolean waxed) {
        if (this.waxed != waxed) {
            this.waxed = waxed;
            this.updateListeners();
            return true;
        }
        return false;
    }

    public boolean isPlayerTooFarToEdit(UUID uuid) {
        Player playerEntity = this.f_58857_.m_46003_(uuid);
        return playerEntity == null || playerEntity.m_20275_((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_()) > 64.0;
    }

    public static void tick(Level world, BlockPos pos, BlockState state, GravestoneBlockEntity blockEntity) {
        UUID uUID = blockEntity.getEditor();
        if (uUID != null) {
            blockEntity.tryClearInvalidEditor(blockEntity, world, uUID);
        }
    }

    private void tryClearInvalidEditor(GravestoneBlockEntity blockEntity, Level world, UUID uuid) {
        if (blockEntity.isPlayerTooFarToEdit(uuid)) {
            blockEntity.setEditor(null);
        }
    }
}

