/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.retraining.network.messages;

import com.mrbysco.retraining.CommonRetraining;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class UpdateMessage {
    private final boolean villager;
    private final int experience;

    public UpdateMessage(boolean villager, int experience) {
        this.villager = villager;
        this.experience = experience;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.villager);
        buf.writeInt(this.experience);
    }

    public static UpdateMessage decode(FriendlyByteBuf packetBuffer) {
        return new UpdateMessage(packetBuffer.readBoolean(), packetBuffer.readInt());
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            if (ctx.getDirection().getReceptionSide().isClient()) {
                CommonRetraining.isVillager = this.experience == 0 && this.villager;
            }
        });
        ctx.setPacketHandled(true);
    }
}

