/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.spells.fire;

import com.gametechbc.traveloptics.api.particle.CylinderParticleManager;
import com.gametechbc.traveloptics.api.particle.ParticleDirection;
import com.gametechbc.traveloptics.api.spells.AbstractUniqueSpell;
import com.gametechbc.traveloptics.api.utils.SummonCheckHelper;
import com.gametechbc.traveloptics.config.SpellsConfig;
import com.gametechbc.traveloptics.entity.summons.SummonedIgnitedBerserker;
import com.gametechbc.traveloptics.entity.summons.SummonedIgnitedRevenant;
import com.gametechbc.traveloptics.init.TravelopticsEffects;
import com.gametechbc.traveloptics.util.SummonTypes;
import com.github.L_Ender.cataclysm.init.ModSounds;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.CameraShakeData;
import io.redspace.ironsspellbooks.api.util.CameraShakeManager;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

@AutoSpellConfig
public class IgnitedOnslaughtSpell
extends AbstractUniqueSpell {
    private final ResourceLocation spellId = new ResourceLocation("traveloptics", "ignited_onslaught");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(SchoolRegistry.FIRE_RESOURCE).setMaxLevel(5).setCooldownSeconds(360.0).build();

    public IgnitedOnslaughtSpell() {
        this.manaCostPerLevel = 75;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 60;
        this.baseManaCost = 50;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)ModSounds.REVENANT_IDLE.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)ModSounds.REVENANT_HURT.get());
    }

    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (((Boolean)SpellsConfig.limitMinibossSummons.get()).booleanValue() && SummonCheckHelper.hasActiveSummons(player, 128.0, SummonTypes.getMinibossSummons())) {
                player.m_5661_((Component)Component.m_237115_((String)"spell.traveloptics.summon_miniboss.warning").m_130940_(ChatFormatting.RED), true);
                return false;
            }
        }
        return true;
    }

    public void onServerCastTick(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        CylinderParticleManager.spawnParticles(level, (Entity)entity, 2, ParticleHelper.FIRE, ParticleDirection.UPWARD, 2.0, 2.0, -1.0);
        CylinderParticleManager.spawnParticles(level, (Entity)entity, 7, (ParticleOptions)ParticleTypes.f_123762_, ParticleDirection.UPWARD, 2.0, 2.0, -1.0);
        super.onServerCastTick(level, spellLevel, entity, playerMagicData);
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        int summonTime = 12000;
        double radius = 4.5;
        double leftAngle = 1.5707963267948966;
        double rightAngle = -1.5707963267948966;
        double berserkerXOffset = radius * Math.cos(leftAngle);
        double berserkerZOffset = radius * Math.sin(leftAngle);
        SummonedIgnitedBerserker ignitedBerserker = new SummonedIgnitedBerserker(world, entity);
        ignitedBerserker.m_6034_(entity.m_20185_() + berserkerXOffset, entity.m_20186_(), entity.m_20189_() + berserkerZOffset);
        ignitedBerserker.m_21204_().m_22146_(Attributes.f_22281_).m_22100_((double)this.getBerserkerDamage(spellLevel, entity));
        ignitedBerserker.m_21204_().m_22146_(Attributes.f_22276_).m_22100_((double)this.getBerserkerHealth(spellLevel));
        ignitedBerserker.m_21153_(ignitedBerserker.m_21233_());
        world.m_7967_((Entity)ignitedBerserker);
        ignitedBerserker.m_7292_(new MobEffectInstance((MobEffect)TravelopticsEffects.IGNITED_ONSLAUGHT_TIMER.get(), summonTime, 0, false, false, false));
        MagicManager.spawnParticles((Level)world, (ParticleOptions)ParticleHelper.FIRE, (double)(entity.m_20185_() + berserkerXOffset), (double)(entity.m_20186_() + 2.0), (double)(entity.m_20189_() + berserkerZOffset), (int)20, (double)0.0, (double)0.0, (double)0.0, (double)0.03, (boolean)false);
        MagicManager.spawnParticles((Level)world, (ParticleOptions)ParticleTypes.f_123762_, (double)(entity.m_20185_() + berserkerXOffset), (double)(entity.m_20186_() + 2.0), (double)(entity.m_20189_() + berserkerZOffset), (int)45, (double)0.0, (double)0.0, (double)0.0, (double)0.03, (boolean)false);
        double revenantXOffset = radius * Math.cos(rightAngle);
        double revenantZOffset = radius * Math.sin(rightAngle);
        SummonedIgnitedRevenant ignitedRevenant = new SummonedIgnitedRevenant(world, entity);
        ignitedRevenant.m_6034_(entity.m_20185_() + revenantXOffset, entity.m_20186_(), entity.m_20189_() + revenantZOffset);
        ignitedRevenant.m_21204_().m_22146_(Attributes.f_22281_).m_22100_((double)this.getRevenantDamage(spellLevel, entity));
        ignitedRevenant.m_21204_().m_22146_(Attributes.f_22276_).m_22100_((double)this.getRevenantHealth(spellLevel));
        ignitedRevenant.m_21153_(ignitedRevenant.m_21233_());
        world.m_7967_((Entity)ignitedRevenant);
        ignitedRevenant.m_7292_(new MobEffectInstance((MobEffect)TravelopticsEffects.IGNITED_ONSLAUGHT_TIMER.get(), summonTime, 0, false, false, false));
        MagicManager.spawnParticles((Level)world, (ParticleOptions)ParticleHelper.FIRE, (double)(entity.m_20185_() + revenantXOffset), (double)(entity.m_20186_() + 2.0), (double)(entity.m_20189_() + revenantZOffset), (int)20, (double)0.0, (double)0.0, (double)0.0, (double)0.03, (boolean)false);
        MagicManager.spawnParticles((Level)world, (ParticleOptions)ParticleTypes.f_123762_, (double)(entity.m_20185_() + revenantXOffset), (double)(entity.m_20186_() + 2.0), (double)(entity.m_20189_() + revenantZOffset), (int)45, (double)0.0, (double)0.0, (double)0.0, (double)0.03, (boolean)false);
        int effectAmplifier = 0;
        if (entity.m_21023_((MobEffect)TravelopticsEffects.IGNITED_ONSLAUGHT_TIMER.get())) {
            effectAmplifier += entity.m_21124_((MobEffect)TravelopticsEffects.IGNITED_ONSLAUGHT_TIMER.get()).m_19564_() + 1;
        }
        entity.m_7292_(new MobEffectInstance((MobEffect)TravelopticsEffects.IGNITED_ONSLAUGHT_TIMER.get(), summonTime, effectAmplifier, false, false, true));
        CameraShakeManager.addCameraShake((CameraShakeData)new CameraShakeData(30, entity.m_20182_(), 25.0f));
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    private float getBerserkerHealth(int spellLevel) {
        return 25.0f + (float)spellLevel * 8.0f;
    }

    private float getBerserkerDamage(int spellLevel, LivingEntity caster) {
        float baseDamage = 2.0f + this.getSpellPower(spellLevel, (Entity)caster) * 1.2f;
        double summonedDamageMultiplier = 1.0;
        if (caster.m_21204_().m_22171_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get())) {
            summonedDamageMultiplier = caster.m_21133_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get());
        }
        return (float)((double)baseDamage * summonedDamageMultiplier);
    }

    private String getBerserkerDamageText(int spellLevel, LivingEntity caster) {
        if (caster != null) {
            float baseDamage = 2.0f + this.getSpellPower(spellLevel, (Entity)caster) * 1.2f;
            double summonedDamageMultiplier = caster.m_21204_().m_22171_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get()) ? caster.m_21133_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get()) : 1.0;
            float finalDamage = (float)((double)baseDamage * summonedDamageMultiplier);
            String baseDamageText = Utils.stringTruncation((double)baseDamage, (int)1);
            String finalDamageText = Utils.stringTruncation((double)finalDamage, (int)1);
            if (summonedDamageMultiplier > 1.0) {
                return String.format("%s -> %s", baseDamageText, finalDamageText);
            }
            return baseDamageText;
        }
        return "" + this.getSpellPower(spellLevel, (Entity)caster);
    }

    private float getRevenantHealth(int spellLevel) {
        return 30.0f + (float)spellLevel * 10.0f;
    }

    private float getRevenantDamage(int spellLevel, LivingEntity caster) {
        float baseDamage = 2.0f + this.getSpellPower(spellLevel, (Entity)caster);
        double summonedDamageMultiplier = 1.0;
        if (caster.m_21204_().m_22171_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get())) {
            summonedDamageMultiplier = caster.m_21133_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get());
        }
        return (float)((double)baseDamage * summonedDamageMultiplier);
    }

    private String getRevenantDamageText(int spellLevel, LivingEntity caster) {
        if (caster != null) {
            float baseDamage = 2.0f + this.getSpellPower(spellLevel, (Entity)caster);
            double summonedDamageMultiplier = caster.m_21204_().m_22171_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get()) ? caster.m_21133_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get()) : 1.0;
            float finalDamage = (float)((double)baseDamage * summonedDamageMultiplier);
            String baseDamageText = Utils.stringTruncation((double)baseDamage, (int)1);
            String finalDamageText = Utils.stringTruncation((double)finalDamage, (int)1);
            if (summonedDamageMultiplier > 1.0) {
                return String.format("%s -> %s", baseDamageText, finalDamageText);
            }
            return baseDamageText;
        }
        return "" + this.getSpellPower(spellLevel, (Entity)caster);
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.traveloptics.summon_count", (Object[])new Object[]{2}), Component.m_237110_((String)"ui.traveloptics.berserker_hp", (Object[])new Object[]{Float.valueOf(this.getBerserkerHealth(spellLevel))}), Component.m_237110_((String)"ui.traveloptics.berserker_damage", (Object[])new Object[]{this.getBerserkerDamageText(spellLevel, caster)}), Component.m_237110_((String)"ui.traveloptics.revenant_hp", (Object[])new Object[]{Float.valueOf(this.getRevenantHealth(spellLevel))}), Component.m_237110_((String)"ui.traveloptics.revenant_damage", (Object[])new Object[]{this.getRevenantDamageText(spellLevel, caster)}), Component.m_237113_((String)"\u00a79T.O Magic 'n Extras"));
    }
}

