/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.spells.fire;

import com.gametechbc.traveloptics.api.particle.ParticleDirection;
import com.gametechbc.traveloptics.api.particle.SphereParticleManager;
import com.gametechbc.traveloptics.api.spells.AbstractUniqueSpell;
import com.gametechbc.traveloptics.init.TravelopticsItems;
import com.gametechbc.traveloptics.spells.TravelopticsSpellAnimations;
import com.github.L_Ender.cataclysm.entity.effect.Flame_Strike_Entity;
import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import com.github.L_Ender.cataclysm.init.ModSounds;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import top.theillusivec4.curios.api.CuriosApi;

@AutoSpellConfig
public class BurningJudgmentSpell
extends AbstractUniqueSpell {
    private final ResourceLocation spellId = new ResourceLocation("traveloptics", "burning_judgment");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchoolResource(SchoolRegistry.FIRE_RESOURCE).setMaxLevel(6).setCooldownSeconds(18.0).build();

    public BurningJudgmentSpell() {
        this.manaCostPerLevel = 40;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 50;
        this.baseManaCost = 40;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public AnimationHolder getCastStartAnimation() {
        return TravelopticsSpellAnimations.JUDGMENT_START;
    }

    public AnimationHolder getCastFinishAnimation() {
        return TravelopticsSpellAnimations.JUDGMENT_FINISH;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)ModSounds.FLAME_BURST.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)ModSounds.SWORD_STOMP.get());
    }

    public void onServerCastTick(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        SphereParticleManager.spawnParticles(level, (Entity)entity, 1, (ParticleOptions)ParticleTypes.f_123744_, ParticleDirection.INWARD, 3.0);
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        int flameStrikes = (int)this.getFlameStrikeCount(spellLevel);
        int duration = (int)this.getDuration(spellLevel);
        int damage = (int)this.getDamage(spellLevel, caster);
        return List.of(Component.m_237110_((String)"ui.traveloptics.damage", (Object[])new Object[]{Utils.stringTruncation((double)damage, (int)2)}), Component.m_237110_((String)"ui.traveloptics.flame_strikes", (Object[])new Object[]{flameStrikes}), Component.m_237110_((String)"ui.traveloptics.flame_strike_length", (Object[])new Object[]{Utils.timeFromTicks((float)duration, (int)2)}), Component.m_237113_((String)"\u00a79T.O Magic 'n Extras"));
    }

    public void onCast(Level level, int spellLevel, LivingEntity caster, CastSource castSource, MagicData playerMagicData) {
        int flameStrikes = (int)this.getFlameStrikeCount(spellLevel);
        int duration = (int)this.getDuration(spellLevel);
        double casterX = caster.m_20185_();
        double casterZ = caster.m_20189_();
        double casterHeadY = caster.m_20186_() + 1.0;
        int standOnYPos = Mth.m_14107_((double)caster.m_20186_()) - 2;
        float yawRadians = (float)Math.toRadians(90.0f + caster.m_146908_());
        boolean isSoulStrike = (double)caster.m_21223_() <= (double)caster.m_21233_() * 0.5 || CuriosApi.getCuriosInventory((LivingEntity)caster).map(curios -> !curios.findCurios(item -> item != null && item.m_150930_((Item)TravelopticsItems.AZURE_IGNITION_BRACELET.get())).isEmpty()).orElse(false) != false;
        for (int i = 0; i < flameStrikes; ++i) {
            double d2 = 2.25 * (double)(i + 1);
            int j2 = (int)(1.5f * (float)i);
            double casterXYaw = casterX + (double)Mth.m_14089_((float)yawRadians) * d2;
            double casterZYaw = casterZ + (double)Mth.m_14031_((float)yawRadians) * d2;
            this.spawnFlameStrike(casterXYaw, casterZYaw, standOnYPos, casterHeadY, yawRadians, duration, j2, j2, level, 1.0f, isSoulStrike, caster, spellLevel);
        }
        SphereParticleManager.spawnParticles(level, (Entity)caster, 50, (ParticleOptions)ParticleTypes.f_123744_, ParticleDirection.OUTWARD, 3.0);
        ScreenShake_Entity.ScreenShake((Level)level, (Vec3)caster.m_20182_(), (float)12.0f, (float)0.03f, (int)10, (int)20);
        super.onCast(level, spellLevel, caster, castSource, playerMagicData);
    }

    private void spawnFlameStrike(double x, double z, double minY, double maxY, float rotation, int duration, int wait, int delay, Level level, float radius, boolean isSoul, LivingEntity caster, int spellLevel) {
        BlockPos pos = new BlockPos((int)x, (int)maxY, (int)z);
        boolean flag = false;
        double d0 = 0.0;
        int damage = (int)this.getDamage(spellLevel, caster);
        if (CuriosApi.getCuriosInventory((LivingEntity)caster).map(curios -> !curios.findCurios(item -> item != null && item.m_150930_((Item)TravelopticsItems.AZURE_IGNITION_BRACELET.get())).isEmpty()).orElse(false).booleanValue()) {
            damage += 2;
        }
        do {
            BlockState blockState1;
            VoxelShape voxelShape;
            BlockPos pos1;
            BlockState blockState;
            if (!(blockState = level.m_8055_(pos1 = pos.m_7495_())).m_60783_((BlockGetter)level, pos1, Direction.UP)) continue;
            if (!level.m_46859_(pos) && !(voxelShape = (blockState1 = level.m_8055_(pos)).m_60812_((BlockGetter)level, pos)).m_83281_()) {
                d0 = voxelShape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((pos = pos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            level.m_7967_((Entity)new Flame_Strike_Entity(level, x, (double)pos.m_123342_() + d0, z, rotation, duration, wait, delay, radius, (float)damage, 0.0f, isSoul, caster));
        }
    }

    private float getFlameStrikeCount(int spellLevel) {
        return 1 + spellLevel;
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) * 3.0f;
    }

    private float getDuration(int spellLevel) {
        return spellLevel * 40;
    }
}

