/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.spells.aqua;

import com.gametechbc.traveloptics.api.init.TravelopticsSchools;
import com.gametechbc.traveloptics.api.spells.AbstractUniqueSpell;
import com.gametechbc.traveloptics.api.utils.TOGeneralUtils;
import com.gametechbc.traveloptics.entity.projectiles.flood_slash.FloodSlashProjectile;
import com.gametechbc.traveloptics.init.TravelopticsEffects;
import com.gametechbc.traveloptics.init.TravelopticsItems;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

@AutoSpellConfig
public class TidalSlashSpell
extends AbstractUniqueSpell {
    private final ResourceLocation spellId = new ResourceLocation("traveloptics", "tidal_slash");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(TravelopticsSchools.AQUA_RESOURCE).setMaxLevel(1).setCooldownSeconds(50.0).build();

    public TidalSlashSpell() {
        this.manaCostPerLevel = 5;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 0;
        this.baseManaCost = 20;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        List<Item> allowedWeapons = List.of((Item)TravelopticsItems.ETERNAL_MAELSTROM_TRIDENT.get(), (Item)TravelopticsItems.ETERNAL_MAELSTROM_TRIDENT_LEVEL_ONE.get(), (Item)TravelopticsItems.ETERNAL_MAELSTROM_TRIDENT_LEVEL_TWO.get(), (Item)TravelopticsItems.ETERNAL_MAELSTROM_TRIDENT_LEVEL_THREE.get());
        if (allowedWeapons.contains(entity.m_21205_().m_41720_())) {
            return true;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!level.m_5776_()) {
                player.m_5661_((Component)Component.m_237115_((String)"spell.traveloptics.tidal_slash.warning").m_130940_(ChatFormatting.RED), true);
            }
        }
        return false;
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        Item mainHandItem = entity.m_21205_().m_41720_();
        if (mainHandItem == TravelopticsItems.ETERNAL_MAELSTROM_TRIDENT_LEVEL_TWO.get() || mainHandItem == TravelopticsItems.ETERNAL_MAELSTROM_TRIDENT_LEVEL_THREE.get()) {
            entity.m_7292_(new MobEffectInstance((MobEffect)TravelopticsEffects.TIDAL_SLASH.get(), 100, (int)this.getAmplifier(spellLevel, entity)));
        } else {
            FloodSlashProjectile floodSlash = new FloodSlashProjectile(world, entity);
            floodSlash.m_146884_(entity.m_146892_());
            floodSlash.shoot(entity.m_20154_());
            floodSlash.setDamage(this.getDamage(spellLevel, entity));
            floodSlash.setManaGain(this.getDamage(spellLevel, entity) * this.getManaGain(spellLevel));
            world.m_7967_((Entity)floodSlash);
        }
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return TOGeneralUtils.buildAquaSpellInfo(1, true, Component.m_237110_((String)"ui.traveloptics.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}), Component.m_237110_((String)"ui.traveloptics.mana_conversion", (Object[])new Object[]{this.getManaGainPercentage(spellLevel)}), Component.m_237115_((String)"ui.traveloptics.tidal_slash_extras"));
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        return 30.0f + this.getSpellPower(spellLevel, (Entity)caster) * 4.0f;
    }

    private float getAmplifier(int spellLevel, LivingEntity caster) {
        return 12.0f + this.getSpellPower(spellLevel, (Entity)caster) * 2.0f;
    }

    private float getManaGain(int spellLevel) {
        return 0.15f + (float)spellLevel * 0.1f;
    }

    private String getManaGainPercentage(int spellLevel) {
        return String.format("%.1f%%", Float.valueOf(this.getManaGain(spellLevel) * 100.0f));
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.SLASH_ANIMATION;
    }
}

