/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.spells.aqua;

import com.gametechbc.traveloptics.api.init.TravelopticsSchools;
import com.gametechbc.traveloptics.init.TravelopticsEffects;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.RecastInstance;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class JetSteamSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("traveloptics", "jet_steam");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.EPIC).setSchoolResource(TravelopticsSchools.AQUA_RESOURCE).setMaxLevel(1).setCooldownSeconds(10.0).build();

    public JetSteamSpell() {
        this.baseManaCost = 50;
        this.manaCostPerLevel = 0;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 0;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public int getRecastCount(int spellLevel, @Nullable LivingEntity entity) {
        return 5;
    }

    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        if (entity.m_6069_() || entity.m_21255_()) {
            return true;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!level.m_5776_()) {
                player.m_5661_((Component)Component.m_237115_((String)"spell.traveloptics.jet_steam.warning").m_130940_(ChatFormatting.RED), true);
            }
        }
        return false;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        if (!playerMagicData.getPlayerRecasts().hasRecastForSpell(this.getSpellId())) {
            playerMagicData.getPlayerRecasts().addRecast(new RecastInstance(this.getSpellId(), spellLevel, this.getRecastCount(spellLevel, entity), 400, castSource, null), playerMagicData);
        }
        if (entity.m_21255_()) {
            entity.m_7292_(new MobEffectInstance((MobEffect)TravelopticsEffects.JET_STEAM.get(), this.getBoostDuration(spellLevel, entity), 0, false, false, false));
        }
        if (entity.m_6069_()) {
            entity.m_7292_(new MobEffectInstance((MobEffect)TravelopticsEffects.JET_STEAM.get(), this.getBoostDuration(spellLevel, entity) * 2, 0, false, false, false));
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private int getBoostDuration(int spellLevel, LivingEntity caster) {
        return (int)(20.0f + this.getSpellPower(spellLevel, (Entity)caster) * 20.0f);
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237115_((String)"ui.traveloptics.boost_duration"), Component.m_237110_((String)"ui.traveloptics.elytra_boost_duration", (Object[])new Object[]{Utils.timeFromTicks((float)this.getBoostDuration(spellLevel, caster), (int)2)}), Component.m_237110_((String)"ui.traveloptics.swimming_boost_duration", (Object[])new Object[]{Utils.timeFromTicks((float)(this.getBoostDuration(spellLevel, caster) * 2), (int)2)}), Component.m_237110_((String)"ui.traveloptics.recast", (Object[])new Object[]{Utils.stringTruncation((double)5.0, (int)2)}), Component.m_237113_((String)"\u00a79T.O Magic 'n Extras"));
    }

    public AnimationHolder getCastFinishAnimation() {
        return SpellAnimations.SELF_CAST_ANIMATION;
    }
}

