/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.compat.spells.holy;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

@AutoSpellConfig
public class SolarFlareSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("traveloptics", "solar_flare");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchoolResource(SchoolRegistry.HOLY_RESOURCE).setMaxLevel(8).setCooldownSeconds(60.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.traveloptics.radius", (Object[])new Object[]{this.getRadius(spellLevel, caster)}), Component.m_237110_((String)"ui.traveloptics.effect_length", (Object[])new Object[]{Utils.timeFromTicks((float)this.getDurationTicks(spellLevel, caster), (int)1)}), Component.m_237110_((String)"ui.traveloptics.effect_frequency", (Object[])new Object[]{this.getTickFrequency(spellLevel)}));
    }

    public SolarFlareSpell() {
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 8;
        this.spellPowerPerLevel = 1;
        this.castTime = 30;
        this.baseManaCost = 10;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    public Optional<SoundEvent> getCastStartSound() {
        ResourceLocation soundLocation = new ResourceLocation("mowziesmobs", "umvuthi.burst");
        return Optional.ofNullable((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundLocation));
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        ResourceLocation effectLocation = new ResourceLocation("traveloptics", "sunstrike");
        MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectLocation);
        if (effect != null) {
            entity.m_7292_(new MobEffectInstance(effect, this.getDurationTicks(spellLevel, entity), this.getAmplifierForLevel(spellLevel, entity), false, false, true));
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private int getAmplifierForLevel(int spellLevel, LivingEntity caster) {
        return 8 + (int)((float)(spellLevel - 1) * this.getEntityPowerMultiplier(caster));
    }

    private int getRadius(int spellLevel, LivingEntity caster) {
        int baseRadius = 14;
        int radiusIncreasePerLevel = 2;
        return baseRadius + (spellLevel - 1) * radiusIncreasePerLevel;
    }

    public int getDurationTicks(int spellLevel, LivingEntity caster) {
        int baseDurationTicks = 400;
        int additionalDurationPerLevel = 100;
        return baseDurationTicks + (spellLevel - 1) * additionalDurationPerLevel;
    }

    private int getTickFrequency(int spellLevel) {
        int baseFrequency = 60;
        int frequencyDecreasePerLevel = 2;
        return baseFrequency - (spellLevel - 1) * frequencyDecreasePerLevel;
    }
}

