/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics;

import com.gametechbc.traveloptics.ClientProxy;
import com.gametechbc.traveloptics.CommonProxy;
import com.gametechbc.traveloptics.api.init.TravelopticsAttributes;
import com.gametechbc.traveloptics.api.init.TravelopticsSchools;
import com.gametechbc.traveloptics.config.ArmorConfig;
import com.gametechbc.traveloptics.config.AugmentConfig;
import com.gametechbc.traveloptics.config.ClientConfig;
import com.gametechbc.traveloptics.config.CommonConfig;
import com.gametechbc.traveloptics.config.DependantItemsAttributeConfig;
import com.gametechbc.traveloptics.config.EntityConfig;
import com.gametechbc.traveloptics.config.SpellsConfig;
import com.gametechbc.traveloptics.config.WeaponConfig;
import com.gametechbc.traveloptics.config.WildAugmentConfig;
import com.gametechbc.traveloptics.effects.AbyssalStrike.AttackHandler;
import com.gametechbc.traveloptics.effects.Blackout.BlackoutHandler;
import com.gametechbc.traveloptics.effects.Casting.CastingHandler;
import com.gametechbc.traveloptics.effects.FrozenSight.FrozenSightClientHandler;
import com.gametechbc.traveloptics.effects.FrozenSight.FrozenSightHandler;
import com.gametechbc.traveloptics.effects.LingeringStrain.LingeringStrainHandler;
import com.gametechbc.traveloptics.init.TravelopticsAugments;
import com.gametechbc.traveloptics.init.TravelopticsBlessedAugments;
import com.gametechbc.traveloptics.init.TravelopticsBlocks;
import com.gametechbc.traveloptics.init.TravelopticsEffects;
import com.gametechbc.traveloptics.init.TravelopticsEntities;
import com.gametechbc.traveloptics.init.TravelopticsItems;
import com.gametechbc.traveloptics.init.TravelopticsParticles;
import com.gametechbc.traveloptics.init.TravelopticsSounds;
import com.gametechbc.traveloptics.init.TravelopticsSpells;
import com.gametechbc.traveloptics.init.TravelopticsTabs;
import com.gametechbc.traveloptics.loot.TravelopticsLootModifiers;
import com.gametechbc.traveloptics.network.MessageSwingArm;
import com.gametechbc.traveloptics.network.MessageUpdateBossBar;
import com.gametechbc.traveloptics.setup.TremorzillaRewardHandler;
import com.gametechbc.traveloptics.util.SummonTypes;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Mod(value="traveloptics")
public class TravelopticsMod {
    public static final Logger LOGGER = LogManager.getLogger(TravelopticsMod.class);
    public static final String MODID = "traveloptics";
    public static final SimpleChannel NETWORK_WRAPPER;
    private static final String PROTOCOL_VERSION;
    public static CommonProxy PROXY;
    private static int packetsRegistered;
    public static final SimpleChannel PACKET_HANDLER;
    private static int messageID;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue;

    public TravelopticsMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        TravelopticsSounds.REGISTRY.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::onLoad);
        modEventBus.addListener(this::onReload);
        TravelopticsSpells.register(modEventBus);
        TravelopticsEffects.register(modEventBus);
        TravelopticsEntities.register(modEventBus);
        TravelopticsSchools.TRAVELOPTICS_SCHOOLS.register(modEventBus);
        TravelopticsAttributes.ATTRIBUTES.register(modEventBus);
        TravelopticsParticles.register(modEventBus);
        TravelopticsLootModifiers.register(modEventBus);
        TravelopticsTabs.REGISTRY.register(modEventBus);
        MinecraftForge.EVENT_BUS.register(AttackHandler.class);
        MinecraftForge.EVENT_BUS.register(TremorzillaRewardHandler.class);
        MinecraftForge.EVENT_BUS.register(FrozenSightHandler.class);
        MinecraftForge.EVENT_BUS.register(BlackoutHandler.class);
        MinecraftForge.EVENT_BUS.register(LingeringStrainHandler.class);
        MinecraftForge.EVENT_BUS.register(CastingHandler.class);
        if (FMLLoader.getDist() == Dist.CLIENT) {
            MinecraftForge.EVENT_BUS.register(FrozenSightClientHandler.class);
        }
        TravelopticsItems.ITEMS.register(modEventBus);
        TravelopticsBlocks.BLOCKS.register(modEventBus);
        TravelopticsAugments.ITEMS.register(modEventBus);
        TravelopticsBlessedAugments.ITEMS.register(modEventBus);
        MinecraftForge.EVENT_BUS.addListener(this::onAddReloadListeners);
        Path configPath = FMLPaths.CONFIGDIR.get().resolve(MODID);
        try {
            Files.createDirectories(configPath, new FileAttribute[0]);
        }
        catch (Exception e) {
            LOGGER.error("Failed to create config directory: " + configPath, (Throwable)e);
        }
        WeaponConfig.loadConfig(WeaponConfig.WEAPON, configPath.resolve("traveloptics-weapons.toml").toString());
        SpellsConfig.loadConfig(SpellsConfig.SPELLS_SPEC, configPath.resolve("traveloptics-spells.toml").toString());
        CommonConfig.loadConfig(CommonConfig.COMMON_SPEC, configPath.resolve("traveloptics-common.toml").toString());
        AugmentConfig.loadConfig(AugmentConfig.AUGMENT_SPEC, configPath.resolve("traveloptics-augments.toml").toString());
        WildAugmentConfig.loadConfig(WildAugmentConfig.WILD_AUGMENT_SPEC, configPath.resolve("traveloptics-wild_augment.toml").toString());
        DependantItemsAttributeConfig.loadConfig(DependantItemsAttributeConfig.DEPENDANT_CONFIG_SPEC, configPath.resolve("traveloptics-dependency_items_attribute.toml").toString());
        ArmorConfig.loadConfig(ArmorConfig.ARMOR_SPEC, configPath.resolve("traveloptics-armors.toml").toString());
        EntityConfig.loadConfig(EntityConfig.ENTITY_SPEC, configPath.resolve("traveloptics-entity.toml").toString());
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientConfig.loadConfig(ClientConfig.CLIENT_SPEC, configPath.resolve("traveloptics-client.toml").toString()));
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    public static <MSG> void sendMSGToServer(MSG message) {
        NETWORK_WRAPPER.sendToServer(message);
    }

    public static <MSG> void sendMSGToAll(MSG message) {
        for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
            TravelopticsMod.sendNonLocal(message, player);
        }
    }

    public static <MSG> void sendNonLocal(MSG msg, ServerPlayer player) {
        NETWORK_WRAPPER.sendTo(msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    private void setup(FMLCommonSetupEvent event) {
        NETWORK_WRAPPER.registerMessage(packetsRegistered++, MessageSwingArm.class, MessageSwingArm::write, MessageSwingArm::read, MessageSwingArm.Handler::handle);
        NETWORK_WRAPPER.registerMessage(packetsRegistered++, MessageUpdateBossBar.class, MessageUpdateBossBar::write, MessageUpdateBossBar::read, MessageUpdateBossBar::handle);
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }

    public static ResourceLocation id(@NotNull String path) {
        return new ResourceLocation(MODID, path);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        SummonTypes.registerKaijuSummons();
        SummonTypes.registerMinibossSummons();
        SummonTypes.registerGroupSummons();
    }

    private void clientSetup(FMLClientSetupEvent event) {
    }

    private void onAddReloadListeners(AddReloadListenerEvent event) {
    }

    private void onLoad(ModConfigEvent.Loading configEvent) {
        if (configEvent.getConfig().getSpec() == WeaponConfig.WEAPON) {
            // empty if block
        }
        if (configEvent.getConfig().getSpec() == SpellsConfig.SPELLS_SPEC) {
            // empty if block
        }
        if (configEvent.getConfig().getSpec() == CommonConfig.COMMON_SPEC) {
            // empty if block
        }
        if (configEvent.getConfig().getSpec() == AugmentConfig.AUGMENT_SPEC) {
            // empty if block
        }
        if (configEvent.getConfig().getSpec() == WildAugmentConfig.WILD_AUGMENT_SPEC) {
            // empty if block
        }
        if (configEvent.getConfig().getSpec() == DependantItemsAttributeConfig.DEPENDANT_CONFIG_SPEC) {
            // empty if block
        }
        if (configEvent.getConfig().getSpec() == ArmorConfig.ARMOR_SPEC) {
            // empty if block
        }
        if (configEvent.getConfig().getSpec() == EntityConfig.ENTITY_SPEC) {
            // empty if block
        }
    }

    private void onReload(ModConfigEvent.Reloading configEvent) {
        if (configEvent.getConfig().getSpec() == WeaponConfig.WEAPON) {
            // empty if block
        }
        if (configEvent.getConfig().getSpec() == SpellsConfig.SPELLS_SPEC) {
            // empty if block
        }
        if (configEvent.getConfig().getSpec() == CommonConfig.COMMON_SPEC) {
            // empty if block
        }
        if (configEvent.getConfig().getSpec() == AugmentConfig.AUGMENT_SPEC) {
            // empty if block
        }
        if (configEvent.getConfig().getSpec() == WildAugmentConfig.WILD_AUGMENT_SPEC) {
            // empty if block
        }
        if (configEvent.getConfig().getSpec() == DependantItemsAttributeConfig.DEPENDANT_CONFIG_SPEC) {
            // empty if block
        }
        if (configEvent.getConfig().getSpec() == ArmorConfig.ARMOR_SPEC) {
            // empty if block
        }
        if (configEvent.getConfig().getSpec() == EntityConfig.ENTITY_SPEC) {
            // empty if block
        }
    }

    static {
        PROTOCOL_VERSION = Integer.toString(1);
        PROXY = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
        NetworkRegistry.ChannelBuilder channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(MODID, "main_channel"));
        String version = PROTOCOL_VERSION;
        version.getClass();
        channel = channel.clientAcceptedVersions(version::equals);
        version = PROTOCOL_VERSION;
        version.getClass();
        NETWORK_WRAPPER = channel.serverAcceptedVersions(version::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
        PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MODID, MODID), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
        messageID = 0;
        workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();
    }
}

