/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.entity;

import com.github.eterdelta.crittersandcompanions.extension.IGrapplingState;
import com.github.eterdelta.crittersandcompanions.network.CACPacketHandler;
import com.github.eterdelta.crittersandcompanions.network.ClientboundGrapplingStatePacket;
import com.github.eterdelta.crittersandcompanions.registry.CACEntities;
import java.util.Optional;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GrapplingHookEntity
extends Projectile {
    protected static final EntityDataAccessor<ItemStack> OWNER_STACK = SynchedEntityData.m_135353_(GrapplingHookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    protected boolean isStick;
    protected boolean wasStick;
    protected double stickLength;
    private boolean addedToWorld;

    public GrapplingHookEntity(EntityType<? extends GrapplingHookEntity> entityType, Level level) {
        super(entityType, level);
    }

    public GrapplingHookEntity(Player owner, ItemStack ownerStack, Level level) {
        this((EntityType<? extends GrapplingHookEntity>)((EntityType)CACEntities.GRAPPLING_HOOK.get()), level);
        this.m_7678_(owner.m_20185_(), owner.m_20188_(), owner.m_20189_(), owner.m_6080_(), owner.m_146909_());
        this.m_5602_((Entity)owner);
        this.setOwnerStack(ownerStack);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER_STACK, (Object)ItemStack.f_41583_);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.addedToWorld) {
            this.updateOwnerState();
            this.addedToWorld = true;
        }
        if (!(this.m_9236_().m_5776_() || this.isFocused() && !(this.m_19749_().m_20280_((Entity)this) > 1048.0))) {
            this.m_146870_();
            return;
        }
        AABB collidableBox = this.m_20191_().m_82400_(0.1);
        Iterable collisions = this.m_9236_().m_186434_((Entity)this, collidableBox);
        this.isStick = false;
        for (VoxelShape shape : collisions) {
            if (shape.m_83281_() || !shape.m_83215_().m_82381_(collidableBox)) continue;
            this.isStick = true;
            break;
        }
        if (this.isStick && !this.wasStick) {
            this.stickLength = this.m_20182_().m_82546_(this.m_19749_().m_20182_()).m_82556_();
        }
        this.wasStick = this.isStick;
        if (this.isStick && this.m_19749_() != null) {
            Vec3 offset = this.m_20182_().m_82546_(this.m_19749_().m_20182_());
            if (offset.m_82556_() > this.stickLength) {
                this.m_19749_().m_20256_(this.m_19749_().m_20184_().m_82549_(offset.m_82490_(0.02)));
                this.m_19749_().f_19864_ = true;
            }
            this.m_20334_(0.0, 0.0, 0.0);
        } else {
            this.m_20256_(this.m_20184_().m_82490_(0.98));
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.03, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        super.m_142687_(removalReason);
        this.updateOwnerState();
    }

    public boolean m_6783_(double distance) {
        return distance < 4096.0;
    }

    public void pull() {
        if (this.m_19749_() != null) {
            if (this.m_9236_().m_5776_() && this.isStick) {
                this.m_19749_().m_20256_(this.m_20182_().m_82546_(this.m_19749_().m_20182_()).m_82542_(0.25, 0.2, 0.25).m_82520_(0.0, 0.25, 0.0));
            }
            this.m_146870_();
        }
    }

    public void updateOwnerState() {
        Entity entity;
        if (!this.m_9236_().m_5776_() && this.m_19749_() != null && (entity = this.m_19749_()) instanceof Player) {
            Player player = (Player)entity;
            entity = this.m_19749_();
            if (entity instanceof IGrapplingState) {
                IGrapplingState grapplingState = (IGrapplingState)entity;
                grapplingState.setHook(this.m_6084_() ? this : null);
                CACPacketHandler.GRAPPLING_STATE.sendToTracking((Entity)player, new ClientboundGrapplingStatePacket(this.m_6084_() ? Optional.of(this.m_19879_()) : Optional.empty(), player.m_19879_()));
            }
        }
    }

    public boolean isFocused() {
        Entity entity = this.m_19749_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.m_9236_().m_5776_()) {
                return ItemStack.m_150942_((ItemStack)player.m_21205_(), (ItemStack)this.getOwnerStack()) || ItemStack.m_150942_((ItemStack)player.m_21206_(), (ItemStack)this.getOwnerStack());
            }
            return player.m_21205_() == this.getOwnerStack() || player.m_21206_() == this.getOwnerStack();
        }
        return false;
    }

    public ItemStack getOwnerStack() {
        return (ItemStack)this.f_19804_.m_135370_(OWNER_STACK);
    }

    public void setOwnerStack(ItemStack stack) {
        this.f_19804_.m_135381_(OWNER_STACK, (Object)stack);
    }
}

