/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.vec;

import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class Scale
extends Transformation {
    public Vector3 factor;

    public Scale(Vector3 factor) {
        this.factor = factor;
    }

    public Scale(double factor) {
        this(new Vector3(factor, factor, factor));
    }

    public Scale(double x, double y, double z) {
        this(new Vector3(x, y, z));
    }

    public Scale(Scale scale) {
        this(scale.factor.copy());
    }

    @Override
    public void apply(Vector3 vec) {
        vec.multiply(this.factor);
    }

    @Override
    public void applyN(Vector3 normal) {
    }

    @Override
    public void apply(Matrix4 mat) {
        mat.scale(this.factor);
    }

    @Override
    public Transformation inverse() {
        return new Scale(1.0 / this.factor.x, 1.0 / this.factor.y, 1.0 / this.factor.z);
    }

    @Override
    public Transformation merge(Transformation next) {
        if (next instanceof Scale) {
            return new Scale(this.factor.copy().multiply(((Scale)next).factor));
        }
        return null;
    }

    @Override
    public boolean isRedundant() {
        return this.factor.equalsT(Vector3.ONE);
    }

    public String toString() {
        MathContext cont = new MathContext(4, RoundingMode.HALF_UP);
        return "Scale(" + new BigDecimal(this.factor.x, cont) + ", " + new BigDecimal(this.factor.y, cont) + ", " + new BigDecimal(this.factor.z, cont) + ")";
    }

    @Override
    public Scale copy() {
        return new Scale(this);
    }
}

