/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.internal.command.admin;

import codechicken.lib.math.MathHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;

public class CountCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"ccl").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"count").requires(e -> e.m_6761_(2))).then(Commands.m_82129_((String)"entity", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)context, (ResourceKey)Registries.f_256939_)).executes(ctx -> {
            EntityType entityType = (EntityType)ResourceArgument.m_246260_((CommandContext)ctx, (String)"entity").m_203334_();
            return CountCommand.countAllEntities((CommandContext<CommandSourceStack>)ctx, e -> e.equals(entityType));
        }))).executes(ctx -> CountCommand.countAllEntities((CommandContext<CommandSourceStack>)ctx, e -> true))));
    }

    private static int countAllEntities(CommandContext<CommandSourceStack> ctx, Predicate<EntityType<?>> predicate) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerLevel level = source.m_81372_();
        ServerChunkCache chunkCache = level.m_7726_();
        Object2IntOpenHashMap counts = new Object2IntOpenHashMap();
        counts.defaultReturnValue(0);
        StreamSupport.stream(level.m_142646_().m_142273_().spliterator(), false).filter(e -> predicate.test(e.m_6095_())).filter(e -> chunkCache.m_5563_(MathHelper.floor(e.m_20185_()) >> 4, MathHelper.floor(e.m_20189_()) >> 4)).forEach(arg_0 -> CountCommand.lambda$countAllEntities$7((Object2IntMap)counts, arg_0));
        ArrayList<EntityType> order = new ArrayList<EntityType>((Collection<EntityType>)counts.keySet());
        order.sort(Comparator.comparingInt(arg_0 -> ((Object2IntMap)counts).getInt(arg_0)));
        int total = 0;
        for (EntityType type : order) {
            int count = counts.getInt((Object)type);
            String name = ForgeRegistries.ENTITY_TYPES.getKey((Object)type).toString();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)(ChatFormatting.GREEN + name + ChatFormatting.RESET + " x " + ChatFormatting.AQUA + count)), false);
            total += count;
        }
        if (order.size() == 0) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"ccl.commands.count.fail"), false);
        } else if (order.size() > 1) {
            int finalTotal = total;
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"ccl.commands.count.total", (Object[])new Object[]{ChatFormatting.AQUA.toString() + finalTotal + ChatFormatting.RESET}), false);
        }
        return total;
    }

    private static /* synthetic */ void lambda$countAllEntities$7(Object2IntMap counts, Entity e) {
        int count = counts.getInt((Object)e.m_6095_());
        counts.put((Object)e.m_6095_(), count + 1);
    }
}

