/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.data;

import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.EncoderException;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.annotation.Nullable;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.joml.Vector3f;

public interface MCDataInput {
    public byte readByte();

    public short readUByte();

    public char readChar();

    public short readShort();

    public int readUShort();

    public int readInt();

    public long readLong();

    public float readFloat();

    public double readDouble();

    public boolean readBoolean();

    default public byte[] readBytes() {
        int len = this.readVarInt();
        byte[] arr = new byte[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = this.readByte();
        }
        return arr;
    }

    default public char[] readChars() {
        int len = this.readVarInt();
        char[] arr = new char[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = this.readChar();
        }
        return arr;
    }

    default public short[] readShorts() {
        int len = this.readVarInt();
        short[] arr = new short[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = this.readShort();
        }
        return arr;
    }

    default public int[] readInts() {
        int len = this.readVarInt();
        int[] arr = new int[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = this.readInt();
        }
        return arr;
    }

    default public long[] readLongs() {
        int len = this.readVarInt();
        long[] arr = new long[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = this.readLong();
        }
        return arr;
    }

    default public float[] readFloats() {
        int len = this.readVarInt();
        float[] arr = new float[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = this.readFloat();
        }
        return arr;
    }

    default public double[] readDoubles() {
        int len = this.readVarInt();
        double[] arr = new double[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = this.readDouble();
        }
        return arr;
    }

    default public boolean[] readBooleans() {
        int len = this.readVarInt();
        boolean[] arr = new boolean[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = this.readBoolean();
        }
        return arr;
    }

    default public int readVarInt() {
        byte b0;
        int i = 0;
        int j = 0;
        do {
            b0 = this.readByte();
            i |= (b0 & 0x7F) << j++ * 7;
            if (j <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((b0 & 0x80) == 128);
        return i;
    }

    default public long readVarLong() {
        byte b0;
        long i = 0L;
        int j = 0;
        do {
            b0 = this.readByte();
            i |= (long)(b0 & 0x7F) << j++ * 7;
            if (j <= 10) continue;
            throw new RuntimeException("VarLong too big");
        } while ((b0 & 0x80) == 128);
        return i;
    }

    default public int readSignedVarInt() {
        int i = this.readVarInt();
        return (i & 1) == 0 ? i >>> 1 : -(i >>> 1) - 1;
    }

    default public long readSignedVarLong() {
        long i = this.readVarLong();
        return (i & 1L) == 0L ? i >>> 1 : -(i >>> 1) - 1L;
    }

    default public int[] readVarInts() {
        int len = this.readVarInt();
        int[] arr = new int[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = this.readVarInt();
        }
        return arr;
    }

    default public long[] readVarLongs() {
        int len = this.readVarInt();
        long[] arr = new long[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = this.readVarLong();
        }
        return arr;
    }

    default public int[] readSignedVarInts() {
        int len = this.readVarInt();
        int[] arr = new int[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = this.readSignedVarInt();
        }
        return arr;
    }

    default public long[] readSignedVarLongs() {
        int len = this.readVarInt();
        long[] arr = new long[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = this.readSignedVarLong();
        }
        return arr;
    }

    default public String readString() {
        return new String(this.readBytes(), StandardCharsets.UTF_8);
    }

    default public UUID readUUID() {
        return new UUID(this.readLong(), this.readLong());
    }

    default public <T extends Enum<T>> T readEnum(Class<T> clazz) {
        return (T)((Enum[])clazz.getEnumConstants())[this.readVarInt()];
    }

    default public ByteBuffer readByteBuffer() {
        return ByteBuffer.wrap(this.readBytes());
    }

    default public CharBuffer readCharBuffer() {
        return CharBuffer.wrap(this.readChars());
    }

    default public ShortBuffer readShortBuffer() {
        return ShortBuffer.wrap(this.readShorts());
    }

    default public IntBuffer readIntBuffer() {
        return IntBuffer.wrap(this.readInts());
    }

    default public LongBuffer readLongBuffer() {
        return LongBuffer.wrap(this.readLongs());
    }

    default public FloatBuffer readFloatBuffer() {
        return FloatBuffer.wrap(this.readFloats());
    }

    default public DoubleBuffer readDoubleBuffer() {
        return DoubleBuffer.wrap(this.readDoubles());
    }

    default public Vector3 readVector() {
        return new Vector3(this.readDouble(), this.readDouble(), this.readDouble());
    }

    default public Cuboid6 readCuboid() {
        return new Cuboid6(this.readVector(), this.readVector());
    }

    default public ResourceLocation readResourceLocation() {
        return new ResourceLocation(this.readString());
    }

    default public Direction readDirection() {
        return this.readEnum(Direction.class);
    }

    default public BlockPos readPos() {
        return new BlockPos(this.readSignedVarInt(), this.readSignedVarInt(), this.readSignedVarInt());
    }

    default public Vec3i readVec3i() {
        return this.readPos();
    }

    default public Vec3 readVec3d() {
        return new Vec3(this.readDouble(), this.readDouble(), this.readDouble());
    }

    default public Vector3f readVec3f() {
        return new Vector3f(this.readFloat(), this.readFloat(), this.readFloat());
    }

    @Nullable
    default public CompoundTag readCompoundNBT() {
        if (!this.readBoolean()) {
            return null;
        }
        try {
            return NbtIo.m_128934_((DataInput)this.toDataInput(), (NbtAccounter)new NbtAccounter(0x200000L));
        }
        catch (IOException e) {
            throw new EncoderException("Failed to read CompoundNBT from stream.", (Throwable)e);
        }
    }

    default public ItemStack readItemStack() {
        if (!this.readBoolean()) {
            return ItemStack.f_41583_;
        }
        Item item = (Item)this.readRegistryIdDirect(ForgeRegistries.ITEMS);
        int count = this.readVarInt();
        ItemStack stack = new ItemStack((ItemLike)item, count);
        stack.readShareTag(this.readCompoundNBT());
        return stack;
    }

    default public FluidStack readFluidStack() {
        if (!this.readBoolean()) {
            return FluidStack.EMPTY;
        }
        Fluid fluid = (Fluid)this.readRegistryIdDirect(ForgeRegistries.FLUIDS);
        int amount = this.readVarInt();
        CompoundTag tag = this.readCompoundNBT();
        if (fluid == Fluids.f_76191_) {
            return FluidStack.EMPTY;
        }
        return new FluidStack(fluid, amount, tag);
    }

    default public MutableComponent readTextComponent() {
        return Component.Serializer.m_130701_((String)this.readString());
    }

    default public <T> T readRegistryIdDirect(IForgeRegistry<T> registry) {
        ForgeRegistry _registry = (ForgeRegistry)SneakyUtils.unsafeCast(registry);
        return (T)_registry.getValue(this.readVarInt());
    }

    default public <T> T readRegistryId() {
        ResourceLocation rName = this.readResourceLocation();
        ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(rName);
        return this.readRegistryIdDirect((IForgeRegistry<T>)registry);
    }

    default public ByteBuf readByteBuf() {
        return Unpooled.wrappedBuffer((byte[])this.readBytes());
    }

    default public DataInput toDataInput() {
        return new DataInputStream(this.toInputStream());
    }

    default public InputStream toInputStream() {
        return new InputStreamWrapper(this);
    }

    public static final class InputStreamWrapper
    extends InputStream {
        private final MCDataInput in;

        public InputStreamWrapper(MCDataInput in) {
            this.in = in;
        }

        @Override
        public int read() {
            return this.in.readByte() & 0xFF;
        }
    }
}

