/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.worldgen.structure;

import com.github.alexmodguy.alexscaves.server.level.structure.piece.VolcanoStructurePiece;
import com.kurome.ageofmythology.init.AOMStructures;
import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class VolcanoStructure
extends Structure {
    public static final int volcanoWidthRadiusRaw = 64;
    public static final int volcanoWidthRadiusRandom = 32;
    public static final Codec<VolcanoStructure> CODEC = VolcanoStructure.m_226607_(settings -> new VolcanoStructure((Structure.StructureSettings)settings));

    protected VolcanoStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        return VolcanoStructure.m_226585_((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> this.generatePieces((StructurePiecesBuilder)builder, context));
    }

    public void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context) {
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenrandom.m_190068_(context.f_226627_(), context.f_226628_().f_45578_, context.f_226628_().f_45579_);
        int volcanoWidthRadius = 64 + context.f_226626_().m_188503_(32);
        int volcanoHeight = volcanoWidthRadius + 8 + context.f_226626_().m_188503_(5);
        int i = context.f_226628_().m_45604_();
        int j = context.f_226628_().m_45605_();
        BlockPos xzCoords1 = new BlockPos(i, 1, j);
        BlockPos xzCoords = VolcanoStructure.posToSurface(context.f_226622_(), xzCoords1, context.f_226629_(), context.f_226624_());
        int widthChunks = (int)Math.ceil((float)volcanoWidthRadius / 16.0f);
        for (int chunkX = -widthChunks; chunkX <= widthChunks; ++chunkX) {
            for (int chunkZ = -widthChunks; chunkZ <= widthChunks; ++chunkZ) {
                BlockPos offset = xzCoords.m_7918_(chunkX * 16, 0, chunkZ * 16);
                builder.m_142679_((StructurePiece)new VolcanoStructurePiece(xzCoords, offset, volcanoWidthRadius, volcanoHeight));
            }
        }
    }

    private static BlockPos posToSurface(ChunkGenerator generator, BlockPos pos, LevelHeightAccessor heightAccessor, RandomState state) {
        int surfaceY = generator.m_214096_(pos.m_123341_(), pos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, heightAccessor, state);
        return new BlockPos(pos.m_123341_(), surfaceY - 1, pos.m_123343_());
    }

    public GenerationStep.Decoration m_226619_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    public StructureType<?> m_213658_() {
        return (StructureType)AOMStructures.VOLCANO.get();
    }
}

