/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.worldgen.feature;

import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.blocks.entities.PedestalBlockEntity;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.kurome.ageofmythology.init.AOMItems;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.SpikeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.SpikeConfiguration;

public class GoetySpikeFeature
extends Feature<SpikeConfiguration> {
    public static final int NUMBER_OF_SPIKES = 10;
    private static final int SPIKE_DISTANCE = 42;
    private static final LoadingCache<Long, List<SpikeFeature.EndSpike>> SPIKE_CACHE = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new SpikeCacheLoader());

    public GoetySpikeFeature(Codec<SpikeConfiguration> p_66852_) {
        super(p_66852_);
    }

    public static List<SpikeFeature.EndSpike> getSpikesForLevel(WorldGenLevel p_66859_) {
        RandomSource randomsource = RandomSource.m_216335_((long)p_66859_.m_7328_());
        long i = randomsource.m_188505_() & 0xFFFFL;
        return (List)SPIKE_CACHE.getUnchecked((Object)i);
    }

    public boolean m_142674_(FeaturePlaceContext<SpikeConfiguration> p_160372_) {
        SpikeConfiguration spikeconfiguration = (SpikeConfiguration)p_160372_.m_159778_();
        WorldGenLevel worldgenlevel = p_160372_.m_159774_();
        RandomSource randomsource = p_160372_.m_225041_();
        BlockPos blockpos = p_160372_.m_159777_();
        List<SpikeFeature.EndSpike> list = spikeconfiguration.m_68119_();
        if (list.isEmpty()) {
            list = GoetySpikeFeature.getSpikesForLevel(worldgenlevel);
        }
        for (SpikeFeature.EndSpike spikefeature$endspike : list) {
            if (!spikefeature$endspike.m_66891_(blockpos)) continue;
            this.placeSpike((ServerLevelAccessor)worldgenlevel, randomsource, spikeconfiguration, spikefeature$endspike);
        }
        return true;
    }

    private void placeSpike(ServerLevelAccessor p_225247_, RandomSource p_225248_, SpikeConfiguration p_225249_, SpikeFeature.EndSpike p_225250_) {
        int i = p_225250_.m_66896_();
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)new BlockPos(p_225250_.m_66886_() - i, p_225247_.m_141937_(), p_225250_.m_66893_() - i), (BlockPos)new BlockPos(p_225250_.m_66886_() + i, p_225250_.m_66899_() + 10, p_225250_.m_66893_() + i))) {
            if (blockpos.m_203202_((double)p_225250_.m_66886_(), (double)blockpos.m_123342_(), (double)p_225250_.m_66893_()) <= (double)(i * i + 1) && blockpos.m_123342_() < p_225250_.m_66899_()) {
                this.m_5974_((LevelWriter)p_225247_, blockpos, Blocks.f_50723_.m_49966_());
                continue;
            }
            if (blockpos.m_123342_() <= 65) continue;
            this.m_5974_((LevelWriter)p_225247_, blockpos, Blocks.f_50016_.m_49966_());
        }
        if (p_225250_.m_66902_()) {
            int j1 = -2;
            int k1 = 2;
            int j = 3;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k = -2; k <= 2; ++k) {
                for (int l = -2; l <= 2; ++l) {
                    for (int i1 = 0; i1 <= 3; ++i1) {
                        boolean flag2;
                        boolean flag = Mth.m_14040_((int)k) == 2;
                        boolean flag1 = Mth.m_14040_((int)l) == 2;
                        boolean bl = flag2 = i1 == 3;
                        if (!flag && !flag1 && !flag2) continue;
                        boolean flag3 = k == -2 || k == 2 || flag2;
                        boolean flag4 = l == -2 || l == 2 || flag2;
                        BlockState blockstate = (BlockState)((BlockState)((BlockState)((BlockState)Blocks.f_50183_.m_49966_().m_61124_((Property)IronBarsBlock.f_52309_, (Comparable)Boolean.valueOf(flag3 && l != -2))).m_61124_((Property)IronBarsBlock.f_52311_, (Comparable)Boolean.valueOf(flag3 && l != 2))).m_61124_((Property)IronBarsBlock.f_52312_, (Comparable)Boolean.valueOf(flag4 && k != -2))).m_61124_((Property)IronBarsBlock.f_52310_, (Comparable)Boolean.valueOf(flag4 && k != 2));
                        this.m_5974_((LevelWriter)p_225247_, (BlockPos)blockpos$mutableblockpos.m_122178_(p_225250_.m_66886_() + k, p_225250_.m_66899_() + i1, p_225250_.m_66893_() + l), blockstate);
                    }
                }
            }
        }
        BlockState pedestal = ((Block)ModBlocks.PEDESTAL.get()).m_49966_();
        this.m_5974_((LevelWriter)p_225247_, new BlockPos(p_225250_.m_66886_(), p_225250_.m_66899_(), p_225250_.m_66893_()), pedestal);
        BlockEntity pedestalBlockEntity = p_225247_.m_7702_(new BlockPos(p_225250_.m_66886_(), p_225250_.m_66899_(), p_225250_.m_66893_()));
        if (pedestalBlockEntity instanceof PedestalBlockEntity) {
            PedestalBlockEntity blockEntity = (PedestalBlockEntity)pedestalBlockEntity;
            blockEntity.itemStackHandler.ifPresent(itemStackHandler -> itemStackHandler.setStackInSlot(0, ((Item)AOMItems.GOETY_APOSTLE_ITEM.get()).m_7968_()));
        }
    }

    static class SpikeCacheLoader
    extends CacheLoader<Long, List<SpikeFeature.EndSpike>> {
        SpikeCacheLoader() {
        }

        public List<SpikeFeature.EndSpike> load(Long p_66910_) {
            IntArrayList intarraylist = Util.m_214658_((IntStream)IntStream.range(0, 12), (RandomSource)RandomSource.m_216335_((long)p_66910_));
            ArrayList list = Lists.newArrayList();
            for (int i = 0; i < 12; ++i) {
                int j = Mth.m_14107_((double)(42.0 * Math.cos(2.0 * (-Math.PI + 0.2617993877991494 * (double)i))));
                int k = Mth.m_14107_((double)(42.0 * Math.sin(2.0 * (-Math.PI + 0.2617993877991494 * (double)i))));
                int l = intarraylist.get(i);
                int i1 = 2 + l / 3;
                int j1 = 76 + l * 3;
                boolean flag = l == 1 || l == 2;
                list.add(new SpikeFeature.EndSpike(j, k, i1, j1, false));
            }
            return list;
        }
    }
}

