/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.worldgen.dimension;

import com.kurome.ageofmythology.AgeOfMythologyMod;
import com.kurome.ageofmythology.client.dimension.FrozenRealmRenderInfo;
import com.kurome.ageofmythology.dimension.AOMDimension;
import com.kurome.ageofmythology.utils.DimensionUtil;
import com.kurome.ageofmythology.worldgen.biome.AOMBiomes;
import com.kurome.ageofmythology.worldgen.surface.AOMSurfaceRules;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.OptionalLong;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class FrozenRealmGeneration {
    public static final ResourceKey<LevelStem> FROZEN_REALM_STEM = ResourceKey.m_135785_((ResourceKey)Registries.f_256862_, (ResourceLocation)AgeOfMythologyMod.prefix("frozen_realm"));
    public static final ResourceKey<NoiseGeneratorSettings> FROZEN_REALM_GENERATOR = ResourceKey.m_135785_((ResourceKey)Registries.f_256932_, (ResourceLocation)AgeOfMythologyMod.prefix("frozen_realm"));

    public static void bootstrap(BootstapContext<DimensionType> context) {
        context.m_255272_(AOMDimension.FROZEN_REALM_LEVEL_TYPE, (Object)FrozenRealmGeneration.frozenRealmDimType());
    }

    private static DimensionType frozenRealmDimType() {
        return new DimensionType(OptionalLong.empty(), true, false, false, true, 1.0, true, true, -64, 320, 320, BlockTags.f_13058_, FrozenRealmRenderInfo.FROZEN_REALM_RENDER, 0.0f, new DimensionType.MonsterSettings(false, false, (IntProvider)UniformInt.m_146622_((int)0, (int)7), 7));
    }

    public static void levelBootstrap(BootstapContext<LevelStem> context) {
        HolderGetter biomes = context.m_255420_(Registries.f_256952_);
        HolderGetter noiseSettings = context.m_255420_(Registries.f_256932_);
        HolderGetter dimensions = context.m_255420_(Registries.f_256787_);
        context.m_255272_(FROZEN_REALM_STEM, (Object)FrozenRealmGeneration.levelStem((HolderGetter<Biome>)biomes, (HolderGetter<NoiseGeneratorSettings>)noiseSettings, (HolderGetter<DimensionType>)dimensions));
    }

    private static LevelStem levelStem(HolderGetter<Biome> biomes, HolderGetter<NoiseGeneratorSettings> noiseSettings, HolderGetter<DimensionType> dimensions) {
        NoiseBasedChunkGenerator chunkGenerator = new NoiseBasedChunkGenerator((BiomeSource)MultiNoiseBiomeSource.m_274596_((Climate.ParameterList)new Climate.ParameterList(List.of(Pair.of((Object)Climate.m_186788_((float)-0.7f, (float)0.3f, (float)0.8f, (float)0.1f, (float)0.0f, (float)0.0f, (float)0.0f), (Object)biomes.m_255043_(AOMBiomes.FROZEN_PEAKS)), Pair.of((Object)Climate.m_186788_((float)-0.5f, (float)0.6f, (float)0.3f, (float)0.1f, (float)0.0f, (float)0.0f, (float)0.0f), (Object)biomes.m_255043_(AOMBiomes.DREAD_FOREST)), Pair.of((Object)Climate.m_186788_((float)-0.3f, (float)0.95f, (float)-0.2f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f), (Object)biomes.m_255043_(AOMBiomes.SEA_SPIRIT))))), (Holder)noiseSettings.m_255043_(FROZEN_REALM_GENERATOR));
        return new LevelStem((Holder)dimensions.m_255043_(AOMDimension.FROZEN_REALM_LEVEL_TYPE), (ChunkGenerator)chunkGenerator);
    }

    public static void noiseBootstrap(BootstapContext<NoiseGeneratorSettings> context) {
        HolderGetter densityFunction = context.m_255420_(Registries.f_257040_);
        HolderGetter noise = context.m_255420_(Registries.f_256865_);
        context.m_255272_(FROZEN_REALM_GENERATOR, (Object)FrozenRealmGeneration.noiseSettings(context, (HolderGetter<DensityFunction>)densityFunction, (HolderGetter<NormalNoise.NoiseParameters>)noise));
    }

    private static NoiseGeneratorSettings noiseSettings(BootstapContext<?> context, HolderGetter<DensityFunction> densityFunction, HolderGetter<NormalNoise.NoiseParameters> noise) {
        NoiseSettings overworldLikeNoiseSettings = NoiseSettings.m_224525_((int)-64, (int)384, (int)1, (int)2);
        return new NoiseGeneratorSettings(overworldLikeNoiseSettings, Blocks.f_50127_.m_49966_(), Blocks.f_49990_.m_49966_(), DimensionUtil.noCaveNoiseRouter(context), AOMSurfaceRules.frozenPeaksSurfaceRules(true, false, true), List.of(), -64, false, true, true, false);
    }
}

