/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.worldgen.dimension;

import com.github.elenterius.biomancy.block.FleshBlock;
import com.github.elenterius.biomancy.init.ModBlocks;
import com.kurome.ageofmythology.dimension.AOMDimension;
import com.kurome.ageofmythology.utils.DimensionUtil;
import com.kurome.ageofmythology.worldgen.biome.AOMBiomes;
import com.kurome.ageofmythology.worldgen.surface.AOMSurfaceRules;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.OptionalLong;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class BloodNetherGeneration {
    public static void bootstrap(BootstapContext<DimensionType> context) {
        context.m_255272_(AOMDimension.BLOOD_NETHER_LEVEL_TYPE, (Object)BloodNetherGeneration.dimType());
    }

    private static DimensionType dimType() {
        return new DimensionType(OptionalLong.of(18000L), false, true, true, false, 1.0, false, true, 0, 256, 128, BlockTags.f_13059_, BuiltinDimensionTypes.f_223543_, 0.1f, new DimensionType.MonsterSettings(true, true, (IntProvider)UniformInt.m_146622_((int)0, (int)7), 15));
    }

    public static void levelBootstrap(BootstapContext<LevelStem> context) {
        HolderGetter biomes = context.m_255420_(Registries.f_256952_);
        HolderGetter noiseSettings = context.m_255420_(Registries.f_256932_);
        HolderGetter dimensions = context.m_255420_(Registries.f_256787_);
        context.m_255272_(AOMDimension.BLOOD_NETHER_STEM, (Object)BloodNetherGeneration.levelStem((HolderGetter<Biome>)biomes, (HolderGetter<NoiseGeneratorSettings>)noiseSettings, (HolderGetter<DimensionType>)dimensions));
    }

    private static LevelStem levelStem(HolderGetter<Biome> biomes, HolderGetter<NoiseGeneratorSettings> noiseSettings, HolderGetter<DimensionType> dimensions) {
        NoiseBasedChunkGenerator chunkGenerator = new NoiseBasedChunkGenerator((BiomeSource)MultiNoiseBiomeSource.m_274596_((Climate.ParameterList)new Climate.ParameterList(List.of(Pair.of((Object)Climate.m_186788_((float)0.1f, (float)0.1f, (float)0.3f, (float)0.1f, (float)0.0f, (float)0.0f, (float)0.0f), (Object)biomes.m_255043_(AOMBiomes.BLOOD_CAVE)), Pair.of((Object)Climate.m_186788_((float)0.175f, (float)0.0f, (float)0.35f, (float)0.1f, (float)0.0f, (float)0.0f, (float)0.0f), (Object)biomes.m_255043_(AOMBiomes.SOUL_CAVE)), Pair.of((Object)Climate.m_186788_((float)0.1f, (float)0.2f, (float)0.3f, (float)0.1f, (float)0.0f, (float)0.0f, (float)0.0f), (Object)biomes.m_255043_(AOMBiomes.FLESH_CAVE))))), (Holder)noiseSettings.m_255043_(AOMDimension.BLOOD_NETHER_GENERATOR));
        return new LevelStem((Holder)dimensions.m_255043_(AOMDimension.BLOOD_NETHER_LEVEL_TYPE), (ChunkGenerator)chunkGenerator);
    }

    public static void noiseBootstrap(BootstapContext<NoiseGeneratorSettings> context) {
        HolderGetter densityFunction = context.m_255420_(Registries.f_257040_);
        HolderGetter noise = context.m_255420_(Registries.f_256865_);
        context.m_255272_(AOMDimension.BLOOD_NETHER_GENERATOR, (Object)BloodNetherGeneration.noiseSettings(context, (HolderGetter<DensityFunction>)densityFunction, (HolderGetter<NormalNoise.NoiseParameters>)noise));
    }

    private static NoiseGeneratorSettings noiseSettings(BootstapContext<?> context, HolderGetter<DensityFunction> densityFunction, HolderGetter<NormalNoise.NoiseParameters> noise) {
        NoiseSettings overworldLikeNoiseSettings = NoiseSettings.m_224525_((int)0, (int)128, (int)1, (int)2);
        return new NoiseGeneratorSettings(overworldLikeNoiseSettings, ((FleshBlock)ModBlocks.FLESH.get()).m_49966_(), ((LiquidBlock)ModBlocks.ACID_FLUID_BLOCK.get()).m_49966_(), DimensionUtil.netherLikeNoiseRouter((HolderGetter<DensityFunction>)context.m_255420_(Registries.f_257040_), (HolderGetter<NormalNoise.NoiseParameters>)context.m_255420_(Registries.f_256865_)), AOMSurfaceRules.bloodNetherSurfaceRules(), List.of(), 32, false, false, false, true);
    }
}

