/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.worldgen.biome;

import com.kurome.ageofmythology.AgeOfMythologyMod;
import com.kurome.ageofmythology.worldgen.biome.AOMBiomesBootstrap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class AOMBiomes {
    public static final Map<ResourceKey<Biome>, BiomeFactory> BIOME_FACTORIES = new Reference2ObjectOpenHashMap();
    public static final ResourceKey<Biome> DEEP_DESERT = AOMBiomes.createBiome("deep_desert", AOMBiomesBootstrap::deepDesert);
    public static final ResourceKey<Biome> CRIMSON_PLAIN = AOMBiomes.createBiome("crimson_plain", AOMBiomesBootstrap::crimsonPlain);
    public static final ResourceKey<Biome> FLAMING_PEAKS = AOMBiomes.createBiome("flaming_peaks", AOMBiomesBootstrap::flamingPeaks);
    public static final ResourceKey<Biome> FROZEN_PEAKS = AOMBiomes.createBiome("frozen_peaks", AOMBiomesBootstrap::frozenPeaks);
    public static final ResourceKey<Biome> DREAD_FOREST = AOMBiomes.createBiome("dread_forest", AOMBiomesBootstrap::dreadForest);
    public static final ResourceKey<Biome> SEA_SPIRIT = AOMBiomes.createBiome("sea_spirit", AOMBiomesBootstrap::seaSpirit);
    public static final ResourceKey<Biome> ICE_FOREST = AOMBiomes.createBiome("ice_forest", AOMBiomesBootstrap::iceForest);
    public static final ResourceKey<Biome> FIRE_FOREST = AOMBiomes.createBiome("fire_forest", AOMBiomesBootstrap::fireForest);
    public static final ResourceKey<Biome> BLOOD_FOREST = AOMBiomes.createBiome("blood_forest", AOMBiomesBootstrap::bloodForest);
    public static final ResourceKey<Biome> LIGHTNING_FOREST = AOMBiomes.createBiome("lightning_forest", AOMBiomesBootstrap::lightningForest);
    public static final ResourceKey<Biome> HOLY_FOREST = AOMBiomes.createBiome("holy_forest", AOMBiomesBootstrap::holyForest);
    public static final ResourceKey<Biome> ENDER_FOREST = AOMBiomes.createBiome("ender_forest", AOMBiomesBootstrap::enderForest);
    public static final ResourceKey<Biome> NATURE_FOREST = AOMBiomes.createBiome("nature_forest", AOMBiomesBootstrap::natureForest);
    public static final ResourceKey<Biome> NETHER_FOREST = AOMBiomes.createBiome("nether_forest", AOMBiomesBootstrap::netherForest);
    public static final ResourceKey<Biome> RUNE_PLAIN = AOMBiomes.createBiome("rune_plain", AOMBiomesBootstrap::runePlain);
    public static final ResourceKey<Biome> MACHINE_REALM = AOMBiomes.createBiome("machine_realm", AOMBiomesBootstrap::machineRealm);
    public static final ResourceKey<Biome> CURSED_REALM = AOMBiomes.createBiome("cursed_realm", AOMBiomesBootstrap::cursedRealm);
    public static final ResourceKey<Biome> PUTRID_ISLAND = AOMBiomes.createBiome("putrid_island", AOMBiomesBootstrap::putridIsland);
    public static final ResourceKey<Biome> BLOOD_CAVE = AOMBiomes.createBiome("blood_cave", AOMBiomesBootstrap::bloodCave);
    public static final ResourceKey<Biome> SOUL_CAVE = AOMBiomes.createBiome("soul_cave", AOMBiomesBootstrap::soulCave);
    public static final ResourceKey<Biome> FLESH_CAVE = AOMBiomes.createBiome("flesh_cave", AOMBiomesBootstrap::fleshCave);

    private static ResourceKey<Biome> createBiome(String id, BiomeFactory biomeFactory) {
        ResourceKey biomeResourceKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)AgeOfMythologyMod.prefix(id));
        BIOME_FACTORIES.put((ResourceKey<Biome>)biomeResourceKey, biomeFactory);
        return biomeResourceKey;
    }

    @FunctionalInterface
    public static interface BiomeFactory {
        public Biome generate(HolderGetter<PlacedFeature> var1, HolderGetter<ConfiguredWorldCarver<?>> var2);
    }
}

