/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.utils;

import com.github.L_Ender.cataclysm.entity.Deepling.AbstractDeepling;
import com.github.L_Ender.cataclysm.entity.effect.Cm_Falling_Block_Entity;
import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import com.github.L_Ender.lionfishapi.server.animation.AnimationHandler;
import com.kurome.ageofmythology.config.AOMUtil;
import com.kurome.ageofmythology.data.tag.EntityTagGenerator;
import com.kurome.ageofmythology.dimension.AOMDimension;
import com.kurome.ageofmythology.mixin.accessors.LivingEntityAccessor;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class MorphUtil {
    private static Supplier<List<Block>> destoryBlockWhiteList = () -> Arrays.asList(Blocks.f_50087_, Blocks.f_50752_);

    public static void fixDeeplingAnimation(Player player, AbstractDeepling entity) {
        if (entity instanceof LivingEntityAccessor) {
            LivingEntityAccessor accessor = (LivingEntityAccessor)entity;
            accessor.callUpdateSwimAmount();
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)entity);
        boolean flag1 = player.getEyeInFluidType().canSwim((Entity)player);
        if (flag1) {
            if (player.m_9236_().m_45756_((Entity)player, MorphUtil.getSwimmingBox((LivingEntity)player))) {
                if (!entity.getDeeplingSwim()) {
                    entity.setDeeplingSwim(true);
                }
                player.m_6210_();
                entity.m_6210_();
            }
        } else if (player.m_9236_().m_45756_((Entity)player, MorphUtil.getNormalBox((LivingEntity)player))) {
            if (entity.getDeeplingSwim()) {
                entity.setDeeplingSwim(false);
            }
            player.m_6210_();
            entity.m_6210_();
        }
    }

    public static AABB getSwimmingBox(LivingEntity livingEntity) {
        return new AABB(livingEntity.m_20185_() - (double)1.15f, livingEntity.m_20186_(), livingEntity.m_20189_() - (double)1.15f, livingEntity.m_20185_() + (double)1.15f, livingEntity.m_20186_() + (double)0.6f, livingEntity.m_20189_() + (double)1.15f);
    }

    public static AABB getNormalBox(LivingEntity livingEntity) {
        return new AABB(livingEntity.m_20185_() - (double)0.6f, livingEntity.m_20186_(), livingEntity.m_20189_() - (double)0.6f, livingEntity.m_20185_() + (double)0.6f, livingEntity.m_20186_() + (double)2.3f, livingEntity.m_20189_() + (double)0.6f);
    }

    public static AABB getNormalBox(Vec3 vec3) {
        return new AABB(vec3.f_82479_ - (double)0.6f, vec3.f_82480_, vec3.f_82481_ - (double)0.6f, vec3.f_82479_ + (double)0.6f, vec3.f_82480_ + (double)2.3f, vec3.f_82481_ + (double)0.6f);
    }

    public static void ChargeBlockBreaking(LivingEntity entity, double inflate) {
        MorphUtil.ChargeBlockBreaking(entity, inflate, true);
    }

    public static void ChargeBlockBreaking(LivingEntity entity, double inflate, boolean needFallBlock) {
        boolean flag = false;
        AABB aabb = entity.m_20191_().m_82377_(inflate, 0.2, inflate);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)entity.m_20186_()), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState blockstate = entity.m_9236_().m_8055_(blockpos);
            if (blockstate.m_60795_() || !blockstate.canEntityDestroy((BlockGetter)entity.m_9236_(), blockpos, (Entity)entity) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)entity, (BlockPos)blockpos, (BlockState)blockstate) || blockstate.m_155947_() || destoryBlockWhiteList.get().contains(blockstate.m_60734_()) || entity.m_9236_().m_46472_().equals(AOMDimension.THE_PATH_LEVEL)) continue;
            if (needFallBlock && entity.m_217043_().m_188503_(6) == 0 && !blockstate.m_155947_()) {
                Cm_Falling_Block_Entity fallingBlockEntity = new Cm_Falling_Block_Entity(entity.m_9236_(), (double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.5, (double)blockpos.m_123343_() + 0.5, blockstate, 20);
                flag = entity.m_9236_().m_46953_(blockpos, false, (Entity)entity) || flag;
                fallingBlockEntity.m_20256_(fallingBlockEntity.m_20184_().m_82549_(entity.m_20182_().m_82546_(fallingBlockEntity.m_20182_()).m_82542_((-1.2 + entity.m_217043_().m_188500_()) / 3.0, 0.2 + entity.m_217043_().m_188583_() * 0.15, (-1.2 + entity.m_217043_().m_188500_()) / 3.0)));
                entity.m_9236_().m_7967_((Entity)fallingBlockEntity);
                continue;
            }
            flag = entity.m_9236_().m_46953_(blockpos, false, (Entity)entity) || flag;
        }
    }

    public static void ScreenShake(LivingEntity player) {
        MorphUtil.ScreenShake(player.m_9236_(), player.m_20182_(), 30.0f, 0.1f, 0, 10);
    }

    public static void ScreenShake(Level world, Vec3 position, float radius, float magnitude, int duration, int fadeDuration) {
        ScreenShake_Entity.ScreenShake((Level)world, (Vec3)position, (float)radius, (float)magnitude, (int)duration, (int)fadeDuration);
    }

    public static void AreaAttack(LivingEntity player, float range, float height, float arc, boolean knockback, double extraDamage) {
        MorphUtil.AreaAttack(player, range, height, arc, knockback, new Vec3(1.0, 1.0, 1.0), extraDamage, livingEntity -> {});
    }

    public static void AreaAttack(LivingEntity player, float range, float height, float arc, boolean knockback, Vec3 knockVec, double extraDamage) {
        MorphUtil.AreaAttack(player, range, height, arc, knockback, knockVec, extraDamage, livingEntity -> {});
    }

    public static void AreaAttack(LivingEntity player, float range, float height, float arc, boolean knockback, double extraDamage, Consumer<LivingEntity> consumer) {
        MorphUtil.AreaAttack(player, range, height, arc, knockback, new Vec3(1.0, 1.0, 1.0), extraDamage, consumer);
    }

    public static void AreaAttack(LivingEntity player, float range, float height, float arc, boolean knockback, Vec3 knockVec, double extraDamage, Consumer<LivingEntity> consumer) {
        List<LivingEntity> entitiesHit = AOMUtil.getEntityLivingBaseNearby(player, range, height, range, range);
        if (!player.m_9236_().f_46443_) {
            for (LivingEntity entityHit : entitiesHit) {
                float playerDamage;
                DamageSource damagesource;
                boolean flag;
                float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - player.m_20189_(), entityHit.m_20185_() - player.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
                float entityAttackingAngle = player.f_20883_ % 360.0f;
                if (entityHitAngle < 0.0f) {
                    entityHitAngle += 360.0f;
                }
                if (entityAttackingAngle < 0.0f) {
                    entityAttackingAngle += 360.0f;
                }
                float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
                float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - player.m_20189_()) * (entityHit.m_20189_() - player.m_20189_()) + (entityHit.m_20185_() - player.m_20185_()) * (entityHit.m_20185_() - player.m_20185_()));
                if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || player.m_7307_((Entity)entityHit) || entityHit == player || !(flag = entityHit.m_6469_(damagesource = player.m_269291_().m_269333_(player), playerDamage = (float)(AOMUtil.getRealDamage(player, Arrays.asList(EntityTagGenerator.GENERAL)) + extraDamage)))) continue;
                consumer.accept(entityHit);
                double d0 = entityHit.m_20185_() - player.m_20185_();
                double d1 = entityHit.m_20189_() - player.m_20189_();
                double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
                if (!knockback) continue;
                entityHit.m_5997_(d0 / d2 * 2.5 * knockVec.f_82479_, 0.18 * knockVec.f_82480_, d1 / d2 * 2.2 * knockVec.f_82481_);
            }
        }
    }
}

