/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraftforge.common.data.ExistingFileHelper;

public class LangUtils {
    private static final Map<String, String> TRANSLATIONS = new HashMap<String, String>();
    private static final ArrayList<String> MODLIST = new ArrayList<String>(Arrays.asList("conjurer_illager", "irons_spellbooks", "bosses_of_mass_destruction"));

    public static void loadLanguage(String namespace, ExistingFileHelper helper, String lang) {
        ResourceLocation langFile = new ResourceLocation(namespace, "lang/" + lang + ".json");
        if (!helper.exists(langFile, PackType.CLIENT_RESOURCES)) {
            LogUtils.getLogger().warn("\u672a\u627e\u5230\u8bed\u8a00\u6587\u4ef6: " + langFile);
            return;
        }
        try {
            Resource resource = helper.getResource(langFile, PackType.CLIENT_RESOURCES);
            JsonObject langJson = JsonParser.parseReader((Reader)new InputStreamReader(resource.m_215507_())).getAsJsonObject();
            langJson.entrySet().forEach(entry -> TRANSLATIONS.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString()));
        }
        catch (Exception e) {
            LogUtils.getLogger().warn("\u52a0\u8f7d\u8bed\u8a00\u6587\u4ef6\u5931\u8d25: " + langFile, (Throwable)e);
        }
    }

    public static void loadModLanguage(String modId, String jarPath, String lang) {
        Path jarFile = Paths.get(new File(System.getProperty("user.dir")).getParent() + "/libs/" + jarPath, new String[0]);
        if (!jarFile.toFile().exists()) {
            jarFile = Paths.get(new File(System.getProperty("user.dir")).getParent() + "/libs-assist/" + jarPath, new String[0]);
        }
        if (!jarFile.toFile().exists()) {
            jarFile = Paths.get(new File(System.getProperty("user.dir")).getParent() + "/libs-core/" + jarPath, new String[0]);
        }
        if (!jarFile.toFile().exists()) {
            jarFile = Paths.get(new File(System.getProperty("user.dir")).getParent() + "/libs-new/" + jarPath, new String[0]);
        }
        if (!jarFile.toFile().exists()) {
            jarFile = Paths.get(new File(System.getProperty("user.dir")).getParent() + "/libs-003/" + jarPath, new String[0]);
        }
        if (!jarFile.toFile().exists()) {
            jarFile = Paths.get(new File(System.getProperty("user.dir")).getParent() + "/libs-010/" + jarPath, new String[0]);
        }
        System.out.println("\u5c1d\u8bd5\u52a0\u8f7d JAR \u6587\u4ef6: " + jarFile.toAbsolutePath());
        if (!jarFile.toFile().exists()) {
            LogUtils.getLogger().warn("\u672a\u627e\u5230\u6a21\u7ec4 JAR \u6587\u4ef6: " + jarPath);
            return;
        }
        try (ZipInputStream zip = new ZipInputStream(new FileInputStream(jarFile.toFile()));){
            ZipEntry entry;
            while ((entry = zip.getNextEntry()) != null) {
                if (!entry.getName().equals("assets/" + modId + "/lang/" + lang + ".json")) continue;
                JsonObject langJson = JsonParser.parseReader((Reader)new InputStreamReader(zip)).getAsJsonObject();
                langJson.entrySet().forEach(e -> TRANSLATIONS.put((String)e.getKey(), ((JsonElement)e.getValue()).getAsString()));
                break;
            }
        }
        catch (Exception e2) {
            LogUtils.getLogger().warn("\u52a0\u8f7d\u6a21\u7ec4\u8bed\u8a00\u6587\u4ef6\u5931\u8d25: " + modId, (Throwable)e2);
        }
    }

    public static String getTranslation(String key) {
        return TRANSLATIONS.getOrDefault(key, Component.m_237115_((String)key).toString());
    }

    public static ArrayList<String> getInfoByBlockID(String id) {
        String[] parts = id.split(":");
        if (parts.length < 1) {
            return new ArrayList<String>();
        }
        String path = parts[parts.length - 1];
        String[] pathParts = LangUtils.splitNameSpace(path);
        ArrayList<String> result = new ArrayList<String>();
        result.add(pathParts[0]);
        result.add(pathParts[1]);
        return result;
    }

    public static String[] splitNameSpace(String input) {
        for (String mod : MODLIST) {
            if (!input.startsWith(mod)) continue;
            String part1 = mod;
            String part2 = input.substring(mod.length());
            if (part2.startsWith("_")) {
                part2 = part2.substring(1);
            }
            if (part2.endsWith("_block")) {
                part2 = part2.substring(0, part2.length() - "_block".length());
            }
            return new String[]{part1, part2};
        }
        String part1 = input.split("_")[0];
        String part2 = input.substring(part1.length());
        if (part2.startsWith("_")) {
            part2 = part2.substring(1);
        }
        if (part2.endsWith("_block")) {
            part2 = part2.substring(0, part2.length() - "_block".length());
        }
        return new String[]{part1, part2};
    }
}

