/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.utils;

import com.google.common.collect.ImmutableList;
import com.kurome.ageofmythology.dimension.AOMDimension;
import com.kurome.ageofmythology.worldgen.biome.AOMBiomes;
import com.kurome.ageofmythology.worldgen.noise.density.AOMDensityFunctions;
import com.kurome.ageofmythology.worldgen.noise.density.AOMDensityGenerator;
import com.kurome.ageofmythology.worldgen.surface.AOMSurfaceRules;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.TerrainProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.CubicSpline;
import net.minecraft.util.ToFloatFunction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class DimensionUtil {
    public static final DensityFunction BLENDING_FACTOR = DensityFunctions.m_208264_((double)10.0);
    public static final DensityFunction BLENDING_JAGGEDNESS = DensityFunctions.m_208263_();
    public static final ResourceKey<DensityFunction> ZERO = DimensionUtil.createKey("zero");
    public static final ResourceKey<DensityFunction> Y = DimensionUtil.createKey("y");
    public static final ResourceKey<DensityFunction> SHIFT_X = DimensionUtil.createKey("shift_x");
    public static final ResourceKey<DensityFunction> SHIFT_Z = DimensionUtil.createKey("shift_z");
    public static final ResourceKey<DensityFunction> BASE_3D_NOISE_OVERWORLD = DimensionUtil.createKey("overworld/base_3d_noise");
    public static final ResourceKey<DensityFunction> BASE_3D_NOISE_NETHER = DimensionUtil.createKey("nether/base_3d_noise");
    public static final ResourceKey<DensityFunction> BASE_3D_NOISE_END = DimensionUtil.createKey("end/base_3d_noise");
    public static final ResourceKey<DensityFunction> CONTINENTS = DimensionUtil.createKey("overworld/continents");
    public static final ResourceKey<DensityFunction> EROSION = DimensionUtil.createKey("overworld/erosion");
    public static final ResourceKey<DensityFunction> RIDGES = DimensionUtil.createKey("overworld/ridges");
    public static final ResourceKey<DensityFunction> RIDGES_FOLDED = DimensionUtil.createKey("overworld/ridges_folded");
    public static final ResourceKey<DensityFunction> OFFSET = DimensionUtil.createKey("overworld/offset");
    public static final ResourceKey<DensityFunction> FACTOR = DimensionUtil.createKey("overworld/factor");
    public static final ResourceKey<DensityFunction> JAGGEDNESS = DimensionUtil.createKey("overworld/jaggedness");
    public static final ResourceKey<DensityFunction> DEPTH = DimensionUtil.createKey("overworld/depth");
    public static final ResourceKey<DensityFunction> SLOPED_CHEESE = DimensionUtil.createKey("overworld/sloped_cheese");
    public static final ResourceKey<DensityFunction> CONTINENTS_LARGE = DimensionUtil.createKey("overworld_large_biomes/continents");
    public static final ResourceKey<DensityFunction> EROSION_LARGE = DimensionUtil.createKey("overworld_large_biomes/erosion");
    public static final ResourceKey<DensityFunction> OFFSET_LARGE = DimensionUtil.createKey("overworld_large_biomes/offset");
    public static final ResourceKey<DensityFunction> FACTOR_LARGE = DimensionUtil.createKey("overworld_large_biomes/factor");
    public static final ResourceKey<DensityFunction> JAGGEDNESS_LARGE = DimensionUtil.createKey("overworld_large_biomes/jaggedness");
    public static final ResourceKey<DensityFunction> DEPTH_LARGE = DimensionUtil.createKey("overworld_large_biomes/depth");
    public static final ResourceKey<DensityFunction> SLOPED_CHEESE_LARGE = DimensionUtil.createKey("overworld_large_biomes/sloped_cheese");
    public static final ResourceKey<DensityFunction> OFFSET_AMPLIFIED = DimensionUtil.createKey("overworld_amplified/offset");
    public static final ResourceKey<DensityFunction> FACTOR_AMPLIFIED = DimensionUtil.createKey("overworld_amplified/factor");
    public static final ResourceKey<DensityFunction> JAGGEDNESS_AMPLIFIED = DimensionUtil.createKey("overworld_amplified/jaggedness");
    public static final ResourceKey<DensityFunction> DEPTH_AMPLIFIED = DimensionUtil.createKey("overworld_amplified/depth");
    public static final ResourceKey<DensityFunction> SLOPED_CHEESE_AMPLIFIED = DimensionUtil.createKey("overworld_amplified/sloped_cheese");
    public static final ResourceKey<DensityFunction> SLOPED_CHEESE_END = DimensionUtil.createKey("end/sloped_cheese");
    public static final ResourceKey<DensityFunction> SPAGHETTI_ROUGHNESS_FUNCTION = DimensionUtil.createKey("overworld/caves/spaghetti_roughness_function");
    public static final ResourceKey<DensityFunction> ENTRANCES = DimensionUtil.createKey("overworld/caves/entrances");
    public static final ResourceKey<DensityFunction> NOODLE = DimensionUtil.createKey("overworld/caves/noodle");
    public static final ResourceKey<DensityFunction> PILLARS = DimensionUtil.createKey("overworld/caves/pillars");
    public static final ResourceKey<DensityFunction> SPAGHETTI_2D_THICKNESS_MODULATOR = DimensionUtil.createKey("overworld/caves/spaghetti_2d_thickness_modulator");
    public static final ResourceKey<DensityFunction> SPAGHETTI_2D = DimensionUtil.createKey("overworld/caves/spaghetti_2d");

    public static ResourceKey<DensityFunction> createKey(String p_209537_) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_257040_, (ResourceLocation)new ResourceLocation(p_209537_));
    }

    public static SurfaceRules.RuleSource makeStateRule(Block p_194811_) {
        return SurfaceRules.m_189390_((BlockState)p_194811_.m_49966_());
    }

    public static SurfaceRules.RuleSource overworldLikeSurfaceRules() {
        return DimensionUtil.overworldLikeSurfaceRules(true, false, true);
    }

    public static SurfaceRules.ConditionSource surfaceNoiseAbove(double p_194809_) {
        return SurfaceRules.m_189412_((ResourceKey)Noises.f_189256_, (double)(p_194809_ / 8.25), (double)Double.MAX_VALUE);
    }

    public static SurfaceRules.RuleSource overworldLikeSurfaceRules(boolean p_198381_, boolean p_198382_, boolean p_198383_) {
        SurfaceRules.ConditionSource surfacerules$conditionsource = SurfaceRules.m_189400_((VerticalAnchor)VerticalAnchor.m_158922_((int)97), (int)2);
        SurfaceRules.ConditionSource surfacerules$conditionsource1 = SurfaceRules.m_189400_((VerticalAnchor)VerticalAnchor.m_158922_((int)256), (int)0);
        SurfaceRules.ConditionSource surfacerules$conditionsource2 = SurfaceRules.m_189422_((VerticalAnchor)VerticalAnchor.m_158922_((int)63), (int)-1);
        SurfaceRules.ConditionSource surfacerules$conditionsource3 = SurfaceRules.m_189422_((VerticalAnchor)VerticalAnchor.m_158922_((int)74), (int)1);
        SurfaceRules.ConditionSource surfacerules$conditionsource4 = SurfaceRules.m_189400_((VerticalAnchor)VerticalAnchor.m_158922_((int)60), (int)0);
        SurfaceRules.ConditionSource surfacerules$conditionsource5 = SurfaceRules.m_189400_((VerticalAnchor)VerticalAnchor.m_158922_((int)62), (int)0);
        SurfaceRules.ConditionSource surfacerules$conditionsource6 = SurfaceRules.m_189400_((VerticalAnchor)VerticalAnchor.m_158922_((int)63), (int)0);
        SurfaceRules.ConditionSource surfacerules$conditionsource7 = SurfaceRules.m_189382_((int)-1, (int)0);
        SurfaceRules.ConditionSource surfacerules$conditionsource8 = SurfaceRules.m_189382_((int)0, (int)0);
        SurfaceRules.ConditionSource surfacerules$conditionsource9 = SurfaceRules.m_189419_((int)-6, (int)-1);
        SurfaceRules.ConditionSource surfacerules$conditionsource10 = SurfaceRules.m_189418_();
        SurfaceRules.ConditionSource surfacerules$conditionsource11 = SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_48211_, Biomes.f_48172_});
        SurfaceRules.ConditionSource surfacerules$conditionsource12 = SurfaceRules.m_189381_();
        SurfaceRules.RuleSource surfacerules$rulesource = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource8, (SurfaceRules.RuleSource)AOMSurfaceRules.GRASS_BLOCK), AOMSurfaceRules.DIRT});
        SurfaceRules.RuleSource surfacerules$rulesource1 = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189377_, (SurfaceRules.RuleSource)AOMSurfaceRules.SANDSTONE), AOMSurfaceRules.SAND});
        SurfaceRules.RuleSource surfacerules$rulesource2 = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189377_, (SurfaceRules.RuleSource)AOMSurfaceRules.STONE), AOMSurfaceRules.GRAVEL});
        SurfaceRules.ConditionSource surfacerules$conditionsource13 = SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_48166_, Biomes.f_48217_, Biomes.f_48148_});
        SurfaceRules.ConditionSource surfacerules$conditionsource14 = SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{AOMBiomes.DEEP_DESERT});
        SurfaceRules.RuleSource surfacerules$rulesource3 = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186759_}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_((ResourceKey)Noises.f_189266_, (double)-0.0125, (double)0.0125), (SurfaceRules.RuleSource)AOMSurfaceRules.CALCITE), AOMSurfaceRules.STONE})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186760_}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_((ResourceKey)Noises.f_189267_, (double)-0.05, (double)0.05), (SurfaceRules.RuleSource)surfacerules$rulesource2), AOMSurfaceRules.STONE})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186765_}), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)DimensionUtil.surfaceNoiseAbove(1.0), (SurfaceRules.RuleSource)AOMSurfaceRules.STONE)), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource13, (SurfaceRules.RuleSource)surfacerules$rulesource1), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource14, (SurfaceRules.RuleSource)surfacerules$rulesource1), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_151784_}), (SurfaceRules.RuleSource)AOMSurfaceRules.STONE)});
        SurfaceRules.RuleSource surfacerules$rulesource4 = SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_((ResourceKey)Noises.f_189268_, (double)0.45, (double)0.58), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource8, (SurfaceRules.RuleSource)AOMSurfaceRules.POWDER_SNOW));
        SurfaceRules.RuleSource surfacerules$rulesource5 = SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_((ResourceKey)Noises.f_189268_, (double)0.35, (double)0.6), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource8, (SurfaceRules.RuleSource)AOMSurfaceRules.POWDER_SNOW));
        SurfaceRules.RuleSource surfacerules$rulesource6 = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186757_}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource12, (SurfaceRules.RuleSource)AOMSurfaceRules.PACKED_ICE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_((ResourceKey)Noises.f_189270_, (double)-0.5, (double)0.2), (SurfaceRules.RuleSource)AOMSurfaceRules.PACKED_ICE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_((ResourceKey)Noises.f_189271_, (double)-0.0625, (double)0.025), (SurfaceRules.RuleSource)AOMSurfaceRules.ICE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource8, (SurfaceRules.RuleSource)AOMSurfaceRules.SNOW_BLOCK)})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186756_}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource12, (SurfaceRules.RuleSource)AOMSurfaceRules.STONE), surfacerules$rulesource4, SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource8, (SurfaceRules.RuleSource)AOMSurfaceRules.SNOW_BLOCK)})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186758_}), (SurfaceRules.RuleSource)AOMSurfaceRules.STONE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186755_}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{surfacerules$rulesource4, AOMSurfaceRules.DIRT})), surfacerules$rulesource3, SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186768_}), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)DimensionUtil.surfaceNoiseAbove(1.75), (SurfaceRules.RuleSource)AOMSurfaceRules.STONE)), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186766_}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)DimensionUtil.surfaceNoiseAbove(2.0), (SurfaceRules.RuleSource)surfacerules$rulesource2), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)DimensionUtil.surfaceNoiseAbove(1.0), (SurfaceRules.RuleSource)AOMSurfaceRules.STONE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)DimensionUtil.surfaceNoiseAbove(-1.0), (SurfaceRules.RuleSource)AOMSurfaceRules.DIRT), surfacerules$rulesource2})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_220595_}), (SurfaceRules.RuleSource)AOMSurfaceRules.MUD), AOMSurfaceRules.DIRT});
        SurfaceRules.RuleSource surfacerules$rulesource7 = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186757_}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource12, (SurfaceRules.RuleSource)AOMSurfaceRules.PACKED_ICE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_((ResourceKey)Noises.f_189270_, (double)0.0, (double)0.2), (SurfaceRules.RuleSource)AOMSurfaceRules.PACKED_ICE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_((ResourceKey)Noises.f_189271_, (double)0.0, (double)0.025), (SurfaceRules.RuleSource)AOMSurfaceRules.ICE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource8, (SurfaceRules.RuleSource)AOMSurfaceRules.SNOW_BLOCK)})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186756_}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource12, (SurfaceRules.RuleSource)AOMSurfaceRules.STONE), surfacerules$rulesource5, SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource8, (SurfaceRules.RuleSource)AOMSurfaceRules.SNOW_BLOCK)})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186758_}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource12, (SurfaceRules.RuleSource)AOMSurfaceRules.STONE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource8, (SurfaceRules.RuleSource)AOMSurfaceRules.SNOW_BLOCK)})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186755_}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{surfacerules$rulesource5, SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource8, (SurfaceRules.RuleSource)AOMSurfaceRules.SNOW_BLOCK)})), surfacerules$rulesource3, SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186768_}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)DimensionUtil.surfaceNoiseAbove(1.75), (SurfaceRules.RuleSource)AOMSurfaceRules.STONE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)DimensionUtil.surfaceNoiseAbove(-0.5), (SurfaceRules.RuleSource)AOMSurfaceRules.COARSE_DIRT)})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186766_}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)DimensionUtil.surfaceNoiseAbove(2.0), (SurfaceRules.RuleSource)surfacerules$rulesource2), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)DimensionUtil.surfaceNoiseAbove(1.0), (SurfaceRules.RuleSource)AOMSurfaceRules.STONE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)DimensionUtil.surfaceNoiseAbove(-1.0), (SurfaceRules.RuleSource)surfacerules$rulesource), surfacerules$rulesource2})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186763_, Biomes.f_186764_}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)DimensionUtil.surfaceNoiseAbove(1.75), (SurfaceRules.RuleSource)AOMSurfaceRules.COARSE_DIRT), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)DimensionUtil.surfaceNoiseAbove(-0.95), (SurfaceRules.RuleSource)AOMSurfaceRules.PODZOL)})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_48182_}), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource8, (SurfaceRules.RuleSource)AOMSurfaceRules.SNOW_BLOCK)), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_220595_}), (SurfaceRules.RuleSource)AOMSurfaceRules.MUD), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_48215_}), (SurfaceRules.RuleSource)AOMSurfaceRules.MYCELIUM), surfacerules$rulesource});
        SurfaceRules.ConditionSource surfacerules$conditionsource15 = SurfaceRules.m_189412_((ResourceKey)Noises.f_189256_, (double)-0.909, (double)-0.5454);
        SurfaceRules.ConditionSource surfacerules$conditionsource16 = SurfaceRules.m_189412_((ResourceKey)Noises.f_189256_, (double)-0.1818, (double)0.1818);
        SurfaceRules.ConditionSource surfacerules$conditionsource17 = SurfaceRules.m_189412_((ResourceKey)Noises.f_189256_, (double)0.5454, (double)0.909);
        SurfaceRules.RuleSource surfacerules$rulesource8 = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186753_}), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource15, (SurfaceRules.RuleSource)AOMSurfaceRules.COARSE_DIRT), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource16, (SurfaceRules.RuleSource)AOMSurfaceRules.COARSE_DIRT), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource17, (SurfaceRules.RuleSource)AOMSurfaceRules.COARSE_DIRT), surfacerules$rulesource}))), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_48207_}), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource5, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189392_((SurfaceRules.ConditionSource)surfacerules$conditionsource6), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189409_((ResourceKey)Noises.f_189265_, (double)0.0), (SurfaceRules.RuleSource)AOMSurfaceRules.WATER)))), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_220595_}), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource4, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189392_((SurfaceRules.ConditionSource)surfacerules$conditionsource6), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189409_((ResourceKey)Noises.f_189265_, (double)0.0), (SurfaceRules.RuleSource)AOMSurfaceRules.WATER))))})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_48159_, Biomes.f_48194_, Biomes.f_186753_}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource1, (SurfaceRules.RuleSource)AOMSurfaceRules.ORANGE_TERRACOTTA), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource3, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource15, (SurfaceRules.RuleSource)AOMSurfaceRules.TERRACOTTA), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource16, (SurfaceRules.RuleSource)AOMSurfaceRules.TERRACOTTA), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource17, (SurfaceRules.RuleSource)AOMSurfaceRules.TERRACOTTA), SurfaceRules.m_189427_()})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource7, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189377_, (SurfaceRules.RuleSource)AOMSurfaceRules.RED_SANDSTONE), AOMSurfaceRules.RED_SAND})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189392_((SurfaceRules.ConditionSource)surfacerules$conditionsource10), (SurfaceRules.RuleSource)AOMSurfaceRules.ORANGE_TERRACOTTA), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource9, (SurfaceRules.RuleSource)AOMSurfaceRules.WHITE_TERRACOTTA), surfacerules$rulesource2})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource2, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource6, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189392_((SurfaceRules.ConditionSource)surfacerules$conditionsource3), (SurfaceRules.RuleSource)AOMSurfaceRules.ORANGE_TERRACOTTA)), SurfaceRules.m_189427_()})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189376_, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource9, (SurfaceRules.RuleSource)AOMSurfaceRules.WHITE_TERRACOTTA))})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource7, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource11, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource10, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource8, (SurfaceRules.RuleSource)AOMSurfaceRules.AIR), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189426_(), (SurfaceRules.RuleSource)AOMSurfaceRules.ICE), AOMSurfaceRules.WATER}))), surfacerules$rulesource7}))), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource9, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource11, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource10, (SurfaceRules.RuleSource)AOMSurfaceRules.WATER))), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189376_, (SurfaceRules.RuleSource)surfacerules$rulesource6), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource13, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_202169_, (SurfaceRules.RuleSource)AOMSurfaceRules.SANDSTONE)), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)surfacerules$conditionsource14, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_202170_, (SurfaceRules.RuleSource)AOMSurfaceRules.SANDSTONE))})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_186757_, Biomes.f_186758_}), (SurfaceRules.RuleSource)AOMSurfaceRules.STONE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_}), (SurfaceRules.RuleSource)surfacerules$rulesource1), surfacerules$rulesource2}))});
        ImmutableList.Builder builder = ImmutableList.builder();
        if (p_198382_) {
            builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189392_((SurfaceRules.ConditionSource)SurfaceRules.m_189403_((String)"bedrock_roof", (VerticalAnchor)VerticalAnchor.m_158935_((int)5), (VerticalAnchor)VerticalAnchor.m_158929_())), (SurfaceRules.RuleSource)AOMSurfaceRules.BEDROCK));
        }
        if (p_198383_) {
            builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189403_((String)"bedrock_floor", (VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158930_((int)5)), (SurfaceRules.RuleSource)AOMSurfaceRules.BEDROCK));
        }
        SurfaceRules.RuleSource surfacerules$rulesource9 = SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189425_(), (SurfaceRules.RuleSource)surfacerules$rulesource8);
        builder.add((Object)(p_198381_ ? surfacerules$rulesource9 : surfacerules$rulesource8));
        builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189403_((String)"deepslate", (VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)8)), (SurfaceRules.RuleSource)AOMSurfaceRules.DEEPSLATE));
        return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])builder.build().toArray(SurfaceRules.RuleSource[]::new)));
    }

    protected static NoiseRouter overworldLikeRouter(HolderGetter<DensityFunction> p_255681_, HolderGetter<NormalNoise.NoiseParameters> p_256005_, boolean p_255649_, boolean p_255617_) {
        DensityFunction densityfunction = DensityFunctions.m_208324_((Holder)p_256005_.m_255043_(Noises.f_189287_), (double)0.5);
        DensityFunction densityfunction1 = DensityFunctions.m_208324_((Holder)p_256005_.m_255043_(Noises.f_189288_), (double)0.67);
        DensityFunction densityfunction2 = DensityFunctions.m_208324_((Holder)p_256005_.m_255043_(Noises.f_189290_), (double)0.7142857142857143);
        DensityFunction densityfunction3 = DensityFunctions.m_208322_((Holder)p_256005_.m_255043_(Noises.f_189289_));
        DensityFunction densityfunction4 = DimensionUtil.getFunction(p_255681_, SHIFT_X);
        DensityFunction densityfunction5 = DimensionUtil.getFunction(p_255681_, SHIFT_Z);
        DensityFunction densityfunction6 = DensityFunctions.m_208296_((DensityFunction)densityfunction4, (DensityFunction)densityfunction5, (double)0.25, (Holder)p_256005_.m_255043_(p_255649_ ? Noises.f_189281_ : Noises.f_189269_));
        DensityFunction densityfunction7 = DensityFunctions.m_208296_((DensityFunction)densityfunction4, (DensityFunction)densityfunction5, (double)0.25, (Holder)p_256005_.m_255043_(p_255649_ ? Noises.f_189282_ : Noises.f_189278_));
        DensityFunction densityfunction8 = DimensionUtil.getFunction(p_255681_, p_255649_ ? FACTOR_LARGE : (p_255617_ ? FACTOR_AMPLIFIED : FACTOR));
        DensityFunction densityfunction9 = DimensionUtil.getFunction(p_255681_, p_255649_ ? DEPTH_LARGE : (p_255617_ ? DEPTH_AMPLIFIED : DEPTH));
        DensityFunction densityfunction10 = DimensionUtil.noiseGradientDensity(DensityFunctions.m_208373_((DensityFunction)densityfunction8), densityfunction9);
        DensityFunction densityfunction11 = DimensionUtil.getFunction(p_255681_, p_255649_ ? SLOPED_CHEESE_LARGE : (p_255617_ ? SLOPED_CHEESE_AMPLIFIED : SLOPED_CHEESE));
        DensityFunction densityfunction12 = DensityFunctions.m_208375_((DensityFunction)densityfunction11, (DensityFunction)DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)5.0), (DensityFunction)DimensionUtil.getFunction(p_255681_, ENTRANCES)));
        DensityFunction densityfunction13 = DensityFunctions.m_208287_((DensityFunction)densityfunction11, (double)-1000000.0, (double)1.5625, (DensityFunction)densityfunction12, (DensityFunction)DimensionUtil.underground(p_255681_, p_256005_, densityfunction11));
        DensityFunction finalDensity = DensityFunctions.m_208375_((DensityFunction)DimensionUtil.postProcess(DimensionUtil.slideOverworld(p_255617_, densityfunction13)), (DensityFunction)DimensionUtil.getFunction(p_255681_, NOODLE));
        return new NoiseRouter(densityfunction, densityfunction1, densityfunction2, densityfunction3, densityfunction6, densityfunction7, DimensionUtil.getFunction(p_255681_, p_255649_ ? CONTINENTS_LARGE : CONTINENTS), DimensionUtil.getFunction(p_255681_, p_255649_ ? EROSION_LARGE : EROSION), densityfunction9, DimensionUtil.getFunction(p_255681_, RIDGES), DimensionUtil.slideOverworld(p_255617_, DensityFunctions.m_208293_((DensityFunction)densityfunction10, (DensityFunction)DensityFunctions.m_208264_((double)-0.703125)).m_208220_(-64.0, 64.0)), finalDensity, DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_());
    }

    public static NoiseRouter netherLikeNoiseRouter(HolderGetter<DensityFunction> p_256256_, HolderGetter<NormalNoise.NoiseParameters> p_256169_) {
        return DimensionUtil.noNewCaves(p_256256_, p_256169_, DimensionUtil.slideNetherLike(p_256256_, 0, 128));
    }

    private static DensityFunction slideNetherLike(HolderGetter<DensityFunction> p_256084_, int p_255802_, int p_255834_) {
        return DimensionUtil.slide(DimensionUtil.getFunction(p_256084_, BASE_3D_NOISE_NETHER), p_255802_, p_255834_, 24, 0, 0.9375, -8, 24, 2.5);
    }

    public static NoiseRouter frozenRealmNoiseRouter(HolderGetter<DensityFunction> p_255681_, HolderGetter<NormalNoise.NoiseParameters> p_256005_, boolean p_255649_, boolean p_255617_) {
        DensityFunction densityfunction11;
        DensityFunction densityfunction = DensityFunctions.m_208324_((Holder)p_256005_.m_255043_(Noises.f_189287_), (double)0.5);
        DensityFunction densityfunction1 = DensityFunctions.m_208324_((Holder)p_256005_.m_255043_(Noises.f_189288_), (double)0.67);
        DensityFunction densityfunction2 = DensityFunctions.m_208324_((Holder)p_256005_.m_255043_(Noises.f_189290_), (double)0.7142857142857143);
        DensityFunction densityfunction3 = DensityFunctions.m_208322_((Holder)p_256005_.m_255043_(Noises.f_189289_));
        DensityFunction densityfunction4 = DimensionUtil.getFunction(p_255681_, SHIFT_X);
        DensityFunction densityfunction5 = DimensionUtil.getFunction(p_255681_, SHIFT_Z);
        DensityFunction temperature = DensityFunctions.m_208296_((DensityFunction)densityfunction4, (DensityFunction)densityfunction5, (double)0.25, (Holder)p_256005_.m_255043_(p_255649_ ? Noises.f_189281_ : Noises.f_189269_));
        DensityFunction vegetation = DensityFunctions.m_208296_((DensityFunction)densityfunction4, (DensityFunction)densityfunction5, (double)0.25, (Holder)p_256005_.m_255043_(p_255649_ ? Noises.f_189282_ : Noises.f_189278_));
        DensityFunction densityfunction8 = DimensionUtil.getFunction(p_255681_, p_255649_ ? FACTOR_LARGE : (p_255617_ ? FACTOR_AMPLIFIED : FACTOR));
        DensityFunction densityfunction9 = DimensionUtil.getFunction(p_255681_, p_255649_ ? DEPTH_LARGE : (p_255617_ ? DEPTH_AMPLIFIED : DEPTH));
        DensityFunction densityfunction10 = DimensionUtil.noiseGradientDensity(DensityFunctions.m_208373_((DensityFunction)densityfunction8), densityfunction9);
        DensityFunction densityfunction12 = densityfunction11 = DimensionUtil.getFunction(p_255681_, p_255649_ ? SLOPED_CHEESE_LARGE : (p_255617_ ? SLOPED_CHEESE_AMPLIFIED : AOMDensityGenerator.SLOPED_CHEESE_FROZEN_REALM));
        DensityFunction densityfunction13 = DensityFunctions.m_208287_((DensityFunction)densityfunction11, (double)-1000000.0, (double)1.5625, (DensityFunction)densityfunction12, (DensityFunction)DimensionUtil.underground(p_255681_, p_256005_, densityfunction11));
        DensityFunction finalDensity = DensityFunctions.m_208375_((DensityFunction)DimensionUtil.postProcess(DimensionUtil.slideOverworld(p_255617_, densityfunction13)), (DensityFunction)DimensionUtil.getFunction(p_255681_, NOODLE));
        return new NoiseRouter(DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), temperature, vegetation, DimensionUtil.getFunction(p_255681_, p_255649_ ? CONTINENTS_LARGE : CONTINENTS), DimensionUtil.getFunction(p_255681_, p_255649_ ? EROSION_LARGE : EROSION), densityfunction9, DimensionUtil.getFunction(p_255681_, RIDGES), DimensionUtil.slideOverworld(p_255617_, DensityFunctions.m_208293_((DensityFunction)densityfunction10, (DensityFunction)DensityFunctions.m_208264_((double)-0.703125)).m_208220_(-64.0, 64.0)), finalDensity, DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_());
    }

    public static NoiseRouter noCaveNoiseRouter(BootstapContext<?> context) {
        return DimensionUtil.noCaveNoiseRouter((HolderGetter<DensityFunction>)context.m_255420_(Registries.f_257040_), (HolderGetter<NormalNoise.NoiseParameters>)context.m_255420_(Registries.f_256865_), false, false);
    }

    public static NoiseRouter noCaveNoiseRouter(HolderGetter<DensityFunction> p_255681_, HolderGetter<NormalNoise.NoiseParameters> p_256005_, boolean p_255649_, boolean p_255617_) {
        DensityFunction densityfunction12;
        DensityFunction densityfunction = DensityFunctions.m_208324_((Holder)p_256005_.m_255043_(Noises.f_189287_), (double)0.5);
        DensityFunction densityfunction1 = DensityFunctions.m_208324_((Holder)p_256005_.m_255043_(Noises.f_189288_), (double)0.67);
        DensityFunction densityfunction2 = DensityFunctions.m_208324_((Holder)p_256005_.m_255043_(Noises.f_189290_), (double)0.7142857142857143);
        DensityFunction densityfunction3 = DensityFunctions.m_208322_((Holder)p_256005_.m_255043_(Noises.f_189289_));
        DensityFunction shiftX = DimensionUtil.getFunction(p_255681_, SHIFT_X);
        DensityFunction shiftZ = DimensionUtil.getFunction(p_255681_, SHIFT_Z);
        DensityFunction temperature = DensityFunctions.m_208296_((DensityFunction)shiftX, (DensityFunction)shiftZ, (double)0.25, (Holder)p_256005_.m_255043_(p_255649_ ? Noises.f_189281_ : Noises.f_189269_));
        DensityFunction vegetation = DensityFunctions.m_208296_((DensityFunction)shiftX, (DensityFunction)shiftZ, (double)0.25, (Holder)p_256005_.m_255043_(p_255649_ ? Noises.f_189282_ : Noises.f_189278_));
        DensityFunction factorDensity = DimensionUtil.getFunction(p_255681_, p_255649_ ? FACTOR_LARGE : (p_255617_ ? FACTOR_AMPLIFIED : FACTOR));
        DensityFunction depthDensity = DimensionUtil.getFunction(p_255681_, p_255649_ ? DEPTH_LARGE : (p_255617_ ? DEPTH_AMPLIFIED : DEPTH));
        DensityFunction noiseGradientDensity = DimensionUtil.noiseGradientDensity(DensityFunctions.m_208373_((DensityFunction)factorDensity), depthDensity);
        DensityFunction densityfunction11 = DimensionUtil.getFunction(p_255681_, p_255649_ ? SLOPED_CHEESE_LARGE : (p_255617_ ? SLOPED_CHEESE_AMPLIFIED : AOMDensityGenerator.SLOPED_CHEESE_FROZEN_REALM));
        DensityFunction pillarsDensityfunction = DimensionUtil.getFunction(p_255681_, PILLARS);
        DensityFunction pillarsDensityfunction2 = DensityFunctions.m_208287_((DensityFunction)factorDensity, (double)-1000000.0, (double)0.03, (DensityFunction)DensityFunctions.m_208264_((double)-1000000.0), (DensityFunction)factorDensity);
        DensityFunction densityfunction13 = densityfunction12 = densityfunction11;
        DensityFunction finalDensity = DimensionUtil.postProcess(DimensionUtil.slideOverworld(p_255617_, densityfunction13));
        return new NoiseRouter(DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), temperature, vegetation, DimensionUtil.getFunction(p_255681_, p_255649_ ? CONTINENTS_LARGE : CONTINENTS), DimensionUtil.getFunction(p_255681_, p_255649_ ? EROSION_LARGE : EROSION), depthDensity, DimensionUtil.getFunction(p_255681_, RIDGES), DimensionUtil.slideOverworld(p_255617_, DensityFunctions.m_208293_((DensityFunction)noiseGradientDensity, (DensityFunction)DensityFunctions.m_208264_((double)-0.703125)).m_208220_(-64.0, 64.0)), finalDensity, DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_());
    }

    public static NoiseRouter isLandRouter(HolderGetter<DensityFunction> p_256079_) {
        DensityFunction densityfunction = DensityFunctions.m_208373_((DensityFunction)AOMDensityFunctions.putridCathedralIslands(0L));
        DensityFunction densityfunction1 = DimensionUtil.postProcess(DimensionUtil.slideEnd(DimensionUtil.getFunction(p_256079_, AOMDensityGenerator.SLOPED_CHEESE_PUTRID_CATHEDRAL)));
        return new NoiseRouter(DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), densityfunction, DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DimensionUtil.slideEnd(DensityFunctions.m_208293_((DensityFunction)densityfunction, (DensityFunction)DensityFunctions.m_208264_((double)-0.703125))), densityfunction1, DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_());
    }

    private static DensityFunction slideEnd(DensityFunction p_224506_) {
        return DimensionUtil.slideEndLike(p_224506_, 0, 128);
    }

    public static NoiseRouter floatingIslands(HolderGetter<DensityFunction> p_256633_, HolderGetter<NormalNoise.NoiseParameters> p_255902_) {
        return DimensionUtil.noNewCaves(p_256633_, p_255902_, DimensionUtil.slideEndLike(DimensionUtil.getFunction(p_256633_, BASE_3D_NOISE_END), 0, 256));
    }

    public static NoiseRouter noNewCaves(HolderGetter<DensityFunction> p_255724_, HolderGetter<NormalNoise.NoiseParameters> p_255986_, DensityFunction p_256378_) {
        DensityFunction densityfunction = DimensionUtil.getFunction(p_255724_, SHIFT_X);
        DensityFunction densityfunction1 = DimensionUtil.getFunction(p_255724_, SHIFT_Z);
        DensityFunction densityfunction2 = DensityFunctions.m_208296_((DensityFunction)densityfunction, (DensityFunction)densityfunction1, (double)0.25, (Holder)p_255986_.m_255043_(Noises.f_189269_));
        DensityFunction densityfunction3 = DensityFunctions.m_208296_((DensityFunction)densityfunction, (DensityFunction)densityfunction1, (double)0.25, (Holder)p_255986_.m_255043_(Noises.f_189278_));
        DensityFunction densityfunction4 = DimensionUtil.postProcess(p_256378_);
        return new NoiseRouter(DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), densityfunction2, densityfunction3, DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), densityfunction4, DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_());
    }

    private static DensityFunction slideEndLike(DensityFunction p_224440_, int p_224441_, int p_224442_) {
        return DimensionUtil.slide(p_224440_, p_224441_, p_224442_, 72, -184, -23.4375, 4, 32, -0.234375);
    }

    public static NoiseRouter skyNoiseRouter(HolderGetter<DensityFunction> p_255681_, HolderGetter<NormalNoise.NoiseParameters> p_256005_, boolean p_255649_, boolean p_255617_) {
        DensityFunction densityfunction4 = DimensionUtil.getFunction(p_255681_, SHIFT_X);
        DensityFunction densityfunction5 = DimensionUtil.getFunction(p_255681_, SHIFT_Z);
        DensityFunction temperature = DensityFunctions.m_208296_((DensityFunction)densityfunction4, (DensityFunction)densityfunction5, (double)0.25, (Holder)p_256005_.m_255043_(p_255649_ ? Noises.f_189281_ : Noises.f_189269_));
        DensityFunction vegetation = DensityFunctions.m_208296_((DensityFunction)densityfunction4, (DensityFunction)densityfunction5, (double)0.25, (Holder)p_256005_.m_255043_(p_255649_ ? Noises.f_189282_ : Noises.f_189278_));
        DensityFunction density = DimensionUtil.getFunction(p_255681_, AOMDensityGenerator.BASE_3D_NOISE_DEEP_DESERT);
        density = DensityFunctions.m_208293_((DensityFunction)density, (DensityFunction)DensityFunctions.m_208264_((double)-0.13));
        density = DimensionUtil.slide(density, -64, 384, 216, 0, -0.2, -48, 32, -0.1);
        density = DensityFunctions.m_208293_((DensityFunction)density, (DensityFunction)DensityFunctions.m_208264_((double)-0.05));
        density = DensityFunctions.m_208389_((DensityFunction)density);
        density = DensityFunctions.m_208281_((DensityFunction)density);
        density = density.m_208234_();
        return new NoiseRouter(DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), temperature, vegetation, DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), density, DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_());
    }

    public static void registerTerrainNoises(BootstapContext<DensityFunction> p_256336_, HolderGetter<DensityFunction> p_256393_, DensityFunction p_224476_, Holder<DensityFunction> p_224477_, Holder<DensityFunction> p_224478_, ResourceKey<DensityFunction> p_224479_, ResourceKey<DensityFunction> p_224480_, ResourceKey<DensityFunction> p_224481_, ResourceKey<DensityFunction> p_224482_, ResourceKey<DensityFunction> p_224483_, boolean p_224484_) {
        DensityFunctions.Spline.Coordinate densityfunctions$spline$coordinate = new DensityFunctions.Spline.Coordinate(p_224477_);
        DensityFunctions.Spline.Coordinate densityfunctions$spline$coordinate1 = new DensityFunctions.Spline.Coordinate(p_224478_);
        DensityFunctions.Spline.Coordinate densityfunctions$spline$coordinate2 = new DensityFunctions.Spline.Coordinate((Holder)p_256393_.m_255043_(RIDGES));
        DensityFunctions.Spline.Coordinate densityfunctions$spline$coordinate3 = new DensityFunctions.Spline.Coordinate((Holder)p_256393_.m_255043_(RIDGES_FOLDED));
        DensityFunction densityfunction = DimensionUtil.registerAndWrap(p_256336_, p_224479_, DimensionUtil.splineWithBlending(DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)-0.50375f), (DensityFunction)DensityFunctions.m_224020_((CubicSpline)TerrainProvider.m_236635_((ToFloatFunction)densityfunctions$spline$coordinate, (ToFloatFunction)densityfunctions$spline$coordinate1, (ToFloatFunction)densityfunctions$spline$coordinate3, (boolean)p_224484_))), DensityFunctions.m_208372_()));
        DensityFunction densityfunction1 = DimensionUtil.registerAndWrap(p_256336_, p_224480_, DimensionUtil.splineWithBlending(DensityFunctions.m_224020_((CubicSpline)TerrainProvider.m_236629_((ToFloatFunction)densityfunctions$spline$coordinate, (ToFloatFunction)densityfunctions$spline$coordinate1, (ToFloatFunction)densityfunctions$spline$coordinate2, (ToFloatFunction)densityfunctions$spline$coordinate3, (boolean)p_224484_)), BLENDING_FACTOR));
        DensityFunction densityfunction2 = DimensionUtil.registerAndWrap(p_256336_, p_224482_, DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208266_((int)-64, (int)320, (double)1.5, (double)-1.5), (DensityFunction)densityfunction));
        DensityFunction densityfunction3 = DimensionUtil.registerAndWrap(p_256336_, p_224481_, DimensionUtil.splineWithBlending(DensityFunctions.m_224020_((CubicSpline)TerrainProvider.m_236642_((ToFloatFunction)densityfunctions$spline$coordinate, (ToFloatFunction)densityfunctions$spline$coordinate1, (ToFloatFunction)densityfunctions$spline$coordinate2, (ToFloatFunction)densityfunctions$spline$coordinate3, (boolean)p_224484_)), BLENDING_JAGGEDNESS));
        DensityFunction densityfunction4 = DensityFunctions.m_208363_((DensityFunction)densityfunction3, (DensityFunction)p_224476_.m_208232_());
        DensityFunction densityfunction5 = DimensionUtil.noiseGradientDensity(densityfunction1, DensityFunctions.m_208293_((DensityFunction)densityfunction2, (DensityFunction)densityfunction4));
        p_256336_.m_255272_(p_224483_, (Object)DensityFunctions.m_208293_((DensityFunction)densityfunction5, (DensityFunction)DimensionUtil.getFunction(p_256393_, BASE_3D_NOISE_OVERWORLD)));
    }

    public static void registerFrozenRealmTerrainNoises(BootstapContext<DensityFunction> p_256336_, HolderGetter<DensityFunction> p_256393_, DensityFunction p_224476_, Holder<DensityFunction> p_224477_, Holder<DensityFunction> p_224478_, ResourceKey<DensityFunction> p_224479_, ResourceKey<DensityFunction> p_224480_, ResourceKey<DensityFunction> p_224481_, ResourceKey<DensityFunction> p_224482_, ResourceKey<DensityFunction> p_224483_, boolean p_224484_) {
        DensityFunctions.Spline.Coordinate densityfunctions$spline$coordinate = new DensityFunctions.Spline.Coordinate(p_224477_);
        DensityFunctions.Spline.Coordinate densityfunctions$spline$coordinate1 = new DensityFunctions.Spline.Coordinate(p_224478_);
        DensityFunctions.Spline.Coordinate densityfunctions$spline$coordinate2 = new DensityFunctions.Spline.Coordinate((Holder)p_256393_.m_255043_(RIDGES));
        DensityFunctions.Spline.Coordinate densityfunctions$spline$coordinate3 = new DensityFunctions.Spline.Coordinate((Holder)p_256393_.m_255043_(RIDGES_FOLDED));
        DensityFunction densityfunction = DimensionUtil.registerAndWrap(p_256336_, p_224479_, DimensionUtil.splineWithBlending(DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)-0.50375f), (DensityFunction)DensityFunctions.m_224020_((CubicSpline)TerrainProvider.m_236635_((ToFloatFunction)densityfunctions$spline$coordinate, (ToFloatFunction)densityfunctions$spline$coordinate1, (ToFloatFunction)densityfunctions$spline$coordinate3, (boolean)p_224484_))), DensityFunctions.m_208372_()));
        DensityFunction densityfunction1 = DimensionUtil.registerAndWrap(p_256336_, p_224480_, DimensionUtil.splineWithBlending(DensityFunctions.m_224020_((CubicSpline)TerrainProvider.m_236629_((ToFloatFunction)densityfunctions$spline$coordinate, (ToFloatFunction)densityfunctions$spline$coordinate1, (ToFloatFunction)densityfunctions$spline$coordinate2, (ToFloatFunction)densityfunctions$spline$coordinate3, (boolean)p_224484_)), BLENDING_FACTOR));
        DensityFunction densityfunction2 = DimensionUtil.registerAndWrap(p_256336_, p_224482_, DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208266_((int)-64, (int)320, (double)1.5, (double)-1.5), (DensityFunction)densityfunction));
        DensityFunction densityfunction3 = DimensionUtil.registerAndWrap(p_256336_, p_224481_, DimensionUtil.splineWithBlending(DensityFunctions.m_224020_((CubicSpline)TerrainProvider.m_236642_((ToFloatFunction)densityfunctions$spline$coordinate, (ToFloatFunction)densityfunctions$spline$coordinate1, (ToFloatFunction)densityfunctions$spline$coordinate2, (ToFloatFunction)densityfunctions$spline$coordinate3, (boolean)p_224484_)), BLENDING_JAGGEDNESS));
        DensityFunction densityfunction4 = DensityFunctions.m_208363_((DensityFunction)densityfunction3, (DensityFunction)p_224476_.m_208232_());
        DensityFunction densityfunction5 = DimensionUtil.noiseGradientDensity(densityfunction1, DensityFunctions.m_208293_((DensityFunction)densityfunction2, (DensityFunction)densityfunction4));
        p_256336_.m_255272_(p_224483_, (Object)DensityFunctions.m_208293_((DensityFunction)densityfunction5, (DensityFunction)DimensionUtil.getFunction(p_256393_, AOMDensityGenerator.BASE_3D_NOISE_DEEP_DESERT)));
    }

    public static DensityFunction registerAndWrap(BootstapContext<DensityFunction> p_256149_, ResourceKey<DensityFunction> p_255905_, DensityFunction p_255856_) {
        return new DensityFunctions.HolderHolder((Holder)p_256149_.m_255272_(p_255905_, (Object)p_255856_));
    }

    public static DensityFunction splineWithBlending(DensityFunction p_224454_, DensityFunction p_224455_) {
        DensityFunction densityfunction = DensityFunctions.m_208301_((DensityFunction)DensityFunctions.m_208360_(), (DensityFunction)p_224455_, (DensityFunction)p_224454_);
        return DensityFunctions.m_208361_((DensityFunction)DensityFunctions.m_208373_((DensityFunction)densityfunction));
    }

    public static DensityFunction getFunction(HolderGetter<DensityFunction> p_256312_, ResourceKey<DensityFunction> p_256077_) {
        return new DensityFunctions.HolderHolder((Holder)p_256312_.m_255043_(p_256077_));
    }

    public static DensityFunction noiseGradientDensity(DensityFunction p_212272_, DensityFunction p_212273_) {
        DensityFunction densityfunction = DensityFunctions.m_208363_((DensityFunction)p_212273_, (DensityFunction)p_212272_);
        return DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)4.0), (DensityFunction)densityfunction.m_208233_());
    }

    public static DensityFunction slideOverworld(boolean p_224490_, DensityFunction p_224491_) {
        return DimensionUtil.slide(p_224491_, -64, 384, p_224490_ ? 16 : 80, p_224490_ ? 0 : 64, -0.078125, 0, 24, p_224490_ ? 0.4 : 0.1171875);
    }

    public static DensityFunction postProcess(DensityFunction p_224493_) {
        DensityFunction densityfunction = DensityFunctions.m_208389_((DensityFunction)p_224493_);
        return DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208281_((DensityFunction)densityfunction), (DensityFunction)DensityFunctions.m_208264_((double)0.64)).m_208234_();
    }

    public static DensityFunction slide(DensityFunction p_224444_, int p_224445_, int p_224446_, int p_224447_, int p_224448_, double p_224449_, int p_224450_, int p_224451_, double p_224452_) {
        DensityFunction densityfunction1 = DensityFunctions.m_208266_((int)(p_224445_ + p_224446_ - p_224447_), (int)(p_224445_ + p_224446_ - p_224448_), (double)1.0, (double)0.0);
        DensityFunction $$9 = DensityFunctions.m_224030_((DensityFunction)densityfunction1, (double)p_224449_, (DensityFunction)p_224444_);
        DensityFunction densityfunction2 = DensityFunctions.m_208266_((int)(p_224445_ + p_224450_), (int)(p_224445_ + p_224451_), (double)0.0, (double)1.0);
        return DensityFunctions.m_224030_((DensityFunction)densityfunction2, (double)p_224452_, (DensityFunction)$$9);
    }

    public static DensityFunction yLimitedInterpolatable(DensityFunction p_209472_, DensityFunction p_209473_, int p_209474_, int p_209475_, int p_209476_) {
        return DensityFunctions.m_208281_((DensityFunction)DensityFunctions.m_208287_((DensityFunction)p_209472_, (double)p_209474_, (double)(p_209475_ + 1), (DensityFunction)p_209473_, (DensityFunction)DensityFunctions.m_208264_((double)p_209476_)));
    }

    public static DensityFunction underground(HolderGetter<DensityFunction> p_256548_, HolderGetter<NormalNoise.NoiseParameters> p_256236_, DensityFunction p_256658_) {
        DensityFunction densityfunction = DimensionUtil.getFunction(p_256548_, SPAGHETTI_2D);
        DensityFunction densityfunction1 = DimensionUtil.getFunction(p_256548_, SPAGHETTI_ROUGHNESS_FUNCTION);
        DensityFunction densityfunction2 = DensityFunctions.m_208324_((Holder)p_256236_.m_255043_(Noises.f_189245_), (double)8.0);
        DensityFunction densityfunction3 = DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)4.0), (DensityFunction)densityfunction2.m_208230_());
        DensityFunction densityfunction4 = DensityFunctions.m_208324_((Holder)p_256236_.m_255043_(Noises.f_189246_), (double)0.6666666666666666);
        DensityFunction densityfunction5 = DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)0.27), (DensityFunction)densityfunction4).m_208220_(-1.0, 1.0), (DensityFunction)DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)1.5), (DensityFunction)DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)-0.64), (DensityFunction)p_256658_)).m_208220_(0.0, 0.5));
        DensityFunction densityfunction6 = DensityFunctions.m_208293_((DensityFunction)densityfunction3, (DensityFunction)densityfunction5);
        DensityFunction densityfunction7 = DensityFunctions.m_208375_((DensityFunction)DensityFunctions.m_208375_((DensityFunction)densityfunction6, (DensityFunction)DimensionUtil.getFunction(p_256548_, ENTRANCES)), (DensityFunction)DensityFunctions.m_208293_((DensityFunction)densityfunction, (DensityFunction)densityfunction1));
        DensityFunction densityfunction8 = DimensionUtil.getFunction(p_256548_, PILLARS);
        DensityFunction densityfunction9 = DensityFunctions.m_208287_((DensityFunction)densityfunction8, (double)-1000000.0, (double)0.03, (DensityFunction)DensityFunctions.m_208264_((double)-1000000.0), (DensityFunction)densityfunction8);
        return DensityFunctions.m_208382_((DensityFunction)densityfunction7, (DensityFunction)densityfunction9);
    }

    public static boolean checkMagicMobValidDimension(Level level) {
        ResourceKey dimension = level.m_46472_();
        return dimension.equals(AOMDimension.DEEP_DESERT_LEVEL) || dimension.equals(AOMDimension.FROZEN_REALM_LEVEL) || dimension.equals(AOMDimension.CHAOS_REALM_LEVEL) || dimension.equals(AOMDimension.MAGIC_FOREST_LEVEL) || dimension.equals(AOMDimension.PUTRID_CATHEDRAL_LEVEL) || dimension.equals(AOMDimension.BLOOD_NETHER_LEVEL) || dimension.equals(AOMDimension.LOST_DREAM_LEVEL) || dimension.equals(AOMDimension.LOST_END_LEVEL);
    }
}

