/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.net.ironspell;

import com.kurome.ageofmythology.AgeOfMythologyMod;
import com.kurome.ageofmythology.bettermorph.api.IAnimation;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.Supplier;
import liushuangwuyin.bettermorph.impl.PlayerDataProvider;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class ClientSyncAnimationIronSpell<T extends Entity> {
    UUID playerUUID;
    int animationId;

    public ClientSyncAnimationIronSpell(int animationId, Player entity) {
        this.playerUUID = entity.m_20148_();
        this.animationId = animationId;
    }

    public ClientSyncAnimationIronSpell(FriendlyByteBuf buf) {
        this.playerUUID = buf.m_130259_();
        this.animationId = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.playerUUID);
        buf.writeInt(this.animationId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            PlayerDataProvider dataProvider;
            LivingEntity identity;
            Level level = AgeOfMythologyMod.PROXY.getClientLevel();
            if (level == null) {
                return;
            }
            Player player = level.m_46003_(this.playerUUID);
            if (player instanceof PlayerDataProvider && (identity = (dataProvider = (PlayerDataProvider)player).getIdentity()) instanceof AbstractSpellCastingMob) {
                AbstractSpellCastingMob mob = (AbstractSpellCastingMob)identity;
                if (this.animationId == SpellType.EMPTY.getId()) {
                    ((IAnimation)mob).resetAnimation();
                } else {
                    Arrays.stream(SpellType.values()).filter(spellType -> spellType.getId() == this.animationId).findFirst().ifPresent(spellType -> ((IAnimation)mob).setAnimation(spellType.getSpell()));
                }
            }
        });
        return true;
    }

    public static enum SpellType {
        RAISE_DEAD_SPELL(1, (AbstractSpell)SpellRegistry.RAISE_DEAD_SPELL.get()),
        FANG_STRIKE_SPELL(2, (AbstractSpell)SpellRegistry.FANG_STRIKE_SPELL.get()),
        FANG_WARD_SPELL(3, (AbstractSpell)SpellRegistry.FANG_WARD_SPELL.get()),
        ICICLE_SPELL(4, (AbstractSpell)SpellRegistry.ICICLE_SPELL.get()),
        MAGIC_MISSILE_SPELL(5, (AbstractSpell)SpellRegistry.MAGIC_MISSILE_SPELL.get()),
        BLIGHT_SPELL(6, (AbstractSpell)SpellRegistry.BLIGHT_SPELL.get()),
        ROOT_SPELL(7, (AbstractSpell)SpellRegistry.ROOT_SPELL.get()),
        CONE_OF_COLD_SPELL(8, (AbstractSpell)SpellRegistry.CONE_OF_COLD_SPELL.get()),
        COUNTERSPELL_SPELL(9, (AbstractSpell)SpellRegistry.COUNTERSPELL_SPELL.get()),
        FROST_STEP_SPELL(10, (AbstractSpell)SpellRegistry.FROST_STEP_SPELL.get()),
        SUMMON_POLAR_BEAR_SPELL(11, (AbstractSpell)SpellRegistry.SUMMON_POLAR_BEAR_SPELL.get()),
        FIREBOLT_SPELL(12, (AbstractSpell)SpellRegistry.FIREBOLT_SPELL.get()),
        FIRE_BREATH_SPELL(13, (AbstractSpell)SpellRegistry.FIRE_BREATH_SPELL.get()),
        BLAZE_STORM_SPELL(14, (AbstractSpell)SpellRegistry.BLAZE_STORM_SPELL.get()),
        BURNING_DASH_SPELL(15, (AbstractSpell)SpellRegistry.BURNING_DASH_SPELL.get()),
        MAGMA_BOMB_SPELL(16, (AbstractSpell)SpellRegistry.MAGMA_BOMB_SPELL.get()),
        SUMMON_VEX_SPELL(17, (AbstractSpell)SpellRegistry.SUMMON_VEX_SPELL.get()),
        INVISIBILITY_SPELL(18, (AbstractSpell)SpellRegistry.INVISIBILITY_SPELL.get()),
        WITHER_SKULL_SPELL(19, (AbstractSpell)SpellRegistry.WITHER_SKULL_SPELL.get()),
        BLOOD_STEP_SPELL(20, (AbstractSpell)SpellRegistry.BLOOD_STEP_SPELL.get()),
        BLESSING_OF_LIFE_SPELL(21, (AbstractSpell)SpellRegistry.BLESSING_OF_LIFE_SPELL.get()),
        HEALING_CIRCLE_SPELL(22, (AbstractSpell)SpellRegistry.HEALING_CIRCLE_SPELL.get()),
        FORTIFY_SPELL(23, (AbstractSpell)SpellRegistry.FORTIFY_SPELL.get()),
        WISP_SPELL(24, (AbstractSpell)SpellRegistry.WISP_SPELL.get()),
        GUIDING_BOLT_SPELL(25, (AbstractSpell)SpellRegistry.GUIDING_BOLT_SPELL.get()),
        GUST_SPELL(26, (AbstractSpell)SpellRegistry.GUST_SPELL.get()),
        HEAL_SPELL(27, (AbstractSpell)SpellRegistry.HEAL_SPELL.get()),
        EMPTY(-1, (AbstractSpell)SpellRegistry.none());

        private final int id;
        private final AbstractSpell spell;

        private SpellType(int id, AbstractSpell spell) {
            this.id = id;
            this.spell = spell;
        }

        public int getId() {
            return this.id;
        }

        public AbstractSpell getSpell() {
            return this.spell;
        }
    }
}

