/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.net.iaf;

import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.kurome.ageofmythology.AgeOfMythologyMod;
import java.util.UUID;
import java.util.function.Supplier;
import liushuangwuyin.bettermorph.impl.PlayerDataProvider;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class ClientSyncAnimationIaf<T extends Entity> {
    int animationId;
    UUID playerUUID;

    public ClientSyncAnimationIaf(int animationId, Player entity) {
        this.animationId = animationId;
        this.playerUUID = entity.m_20148_();
    }

    public ClientSyncAnimationIaf(FriendlyByteBuf buf) {
        this.animationId = buf.readInt();
        this.playerUUID = buf.m_130259_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.animationId);
        buf.m_130077_(this.playerUUID);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            PlayerDataProvider dataProvider;
            LivingEntity identity;
            Level level = AgeOfMythologyMod.PROXY.getClientLevel();
            if (level == null) {
                return;
            }
            Player player = level.m_46003_(this.playerUUID);
            if (player instanceof PlayerDataProvider && (identity = (dataProvider = (PlayerDataProvider)player).getIdentity()) instanceof IAnimatedEntity) {
                IAnimatedEntity monster = (IAnimatedEntity)identity;
                if (this.animationId == -1) {
                    monster.setAnimation(IAnimatedEntity.NO_ANIMATION);
                } else {
                    monster.setAnimation(monster.getAnimations()[this.animationId]);
                }
                monster.setAnimationTick(0);
            }
        });
        return true;
    }
}

