/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.net.general;

import com.kurome.ageofmythology.gui.AbilityWheelOverlay;
import com.kurome.ageofmythology.gui.MorphWheelOverlay;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class ClientSyncWheelSelection<T extends Entity> {
    int type;
    int selection;

    public ClientSyncWheelSelection(int type, int selection) {
        this.type = type;
        this.selection = selection;
    }

    public ClientSyncWheelSelection(FriendlyByteBuf buf) {
        this.type = buf.readInt();
        this.selection = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.type);
        buf.writeInt(this.selection);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            if (this.type == WheelType.ABILITY_WHEEL.getId()) {
                AbilityWheelOverlay.instance.updateWheelSelection(this.selection);
            } else if (this.type == WheelType.MORPH_WHEEL.getId()) {
                MorphWheelOverlay.instance.updateWheelSelection(this.selection);
            }
        });
        return true;
    }

    public static enum WheelType {
        ABILITY_WHEEL(1),
        MORPH_WHEEL(2);

        private final int id;

        private WheelType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

