/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.net.cataclysm;

import com.github.L_Ender.cataclysm.entity.AnimationMonster.LLibrary_Monster;
import com.github.L_Ender.cataclysm.entity.InternalAnimationMonster.Internal_Animation_Monster;
import com.github.L_Ender.lionfishapi.server.animation.IAnimatedEntity;
import com.kurome.ageofmythology.AgeOfMythologyMod;
import java.util.UUID;
import java.util.function.Supplier;
import liushuangwuyin.bettermorph.impl.PlayerDataProvider;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class ClientSyncAnimationCataclysm<T extends Entity> {
    int animationId;
    UUID playerUUID;

    public ClientSyncAnimationCataclysm(int animationId, Player entity) {
        this.animationId = animationId;
        this.playerUUID = entity.m_20148_();
    }

    public ClientSyncAnimationCataclysm(FriendlyByteBuf buf) {
        this.animationId = buf.readInt();
        this.playerUUID = buf.m_130259_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.animationId);
        buf.m_130077_(this.playerUUID);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            Level level = AgeOfMythologyMod.PROXY.getClientLevel();
            if (level == null) {
                return;
            }
            Player player = level.m_46003_(this.playerUUID);
            if (player instanceof PlayerDataProvider) {
                PlayerDataProvider dataProvider = (PlayerDataProvider)player;
                LivingEntity identity = dataProvider.getIdentity();
                if (identity instanceof LLibrary_Monster) {
                    LLibrary_Monster monster = (LLibrary_Monster)identity;
                    if (this.animationId == -1) {
                        monster.setAnimation(IAnimatedEntity.NO_ANIMATION);
                    } else {
                        monster.setAnimation(monster.getAnimations()[this.animationId]);
                    }
                    monster.setAnimationTick(0);
                } else if (identity instanceof Internal_Animation_Monster) {
                    Internal_Animation_Monster monster = (Internal_Animation_Monster)identity;
                    monster.setAttackState(this.animationId);
                }
            }
        });
        return true;
    }
}

