/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.net.capability;

import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.kurome.ageofmythology.AgeOfMythologyMod;
import com.kurome.ageofmythology.capability.PlayerDataCapability;
import com.kurome.ageofmythology.model.CapabilityExtraInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import liushuangwuyin.bettermorph.impl.DimensionsRefresher;
import liushuangwuyin.bettermorph.impl.PlayerDataProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ClientSyncPlayerDataCapability<T extends Entity> {
    Set<String> visitBiomes = new HashSet<String>();
    Set<String> listenedDiscs = new HashSet<String>();
    Set<String> foodList = new HashSet<String>();
    int dragonAge = 0;
    boolean noPhysics = true;
    int sunState = 0;
    CapabilityExtraInfo extraInfo = new CapabilityExtraInfo();
    private static final String NBT_VISIT_BIOMES = "ClientVisitBiomes";
    private static final String NBT_VISIT_BIOMES_SIZE = "ClientVisitBiomesSize";
    private static final String NBT_LISTENED_DISCS = "nbt_listened_discs";
    private static final String NBT_LISTENED_DISCS_SIZE = "nbt_listened_discs_size";

    public ClientSyncPlayerDataCapability(Set<String> visitBiomes, Set<String> listenedDiscs, Set<String> foodList, int age, boolean noPhysics, int sunState, CapabilityExtraInfo extraInfo) {
        this.visitBiomes = visitBiomes;
        this.listenedDiscs = listenedDiscs;
        this.foodList = foodList;
        this.dragonAge = age;
        this.noPhysics = noPhysics;
        this.sunState = sunState;
        this.extraInfo = extraInfo;
    }

    public ClientSyncPlayerDataCapability(FriendlyByteBuf buf) {
        CompoundTag nbt = buf.m_130260_();
        if (nbt == null) {
            return;
        }
        this.readSetNbt(nbt, NBT_VISIT_BIOMES, NBT_VISIT_BIOMES_SIZE, this.visitBiomes);
        this.readSetNbt(nbt, NBT_LISTENED_DISCS, NBT_LISTENED_DISCS_SIZE, this.listenedDiscs);
        this.readSetNbt(nbt, "nbt_food_list", "nbt_food_list_size", this.foodList);
        this.dragonAge = nbt.m_128451_("nbt_dragon_age");
        this.noPhysics = nbt.m_128471_("nbt_no_physics");
        this.sunState = nbt.m_128451_("nbt_sun_state");
        this.extraInfo.deserializeNBT(nbt);
    }

    private void readSetNbt(@Nullable CompoundTag nbt, String key, String sizeKey, Set<String> add) {
        if (nbt == null) {
            return;
        }
        int size = nbt.m_128451_(sizeKey);
        for (int i = 0; i < size; ++i) {
            String result = nbt.m_128461_(key + i);
            add.add(result);
        }
    }

    private void writeSetNbt(CompoundTag nbt, String key, String sizeKey, Set<String> add) {
        List list = add.stream().toList();
        int size = list.size();
        nbt.m_128405_(sizeKey, size);
        for (int i = 0; i < size; ++i) {
            nbt.m_128359_(key + i, (String)list.get(i));
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        CompoundTag nbt = new CompoundTag();
        this.writeSetNbt(nbt, NBT_VISIT_BIOMES, NBT_VISIT_BIOMES_SIZE, this.visitBiomes);
        this.writeSetNbt(nbt, NBT_LISTENED_DISCS, NBT_LISTENED_DISCS_SIZE, this.listenedDiscs);
        this.writeSetNbt(nbt, "nbt_food_list", "nbt_food_list_size", this.foodList);
        nbt.m_128405_("nbt_dragon_age", this.dragonAge);
        nbt.m_128379_("nbt_no_physics", this.noPhysics);
        nbt.m_128405_("nbt_sun_state", this.sunState);
        this.extraInfo.serializeNBT(nbt);
        buf.m_130079_(nbt);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            Player player = AgeOfMythologyMod.PROXY.getClientPlayer();
            if (player == null) {
                return;
            }
            player.getCapability(PlayerDataCapability.INSTANCE).ifPresent(data -> {
                PlayerDataProvider dataProvider;
                LivingEntity identity;
                data.setVisitBiomes(this.visitBiomes);
                data.setDiscs(this.listenedDiscs);
                data.setFoodList(this.foodList);
                data.setDragonAge(this.dragonAge);
                data.setNoPhysics(this.noPhysics);
                data.setSunState(this.sunState);
                data.setExtraInfo(this.extraInfo);
                if (player instanceof PlayerDataProvider && (identity = (dataProvider = (PlayerDataProvider)player).getIdentity()) instanceof EntityDragonBase) {
                    EntityDragonBase dragon = (EntityDragonBase)identity;
                    dragon.setAgeInDays(this.dragonAge);
                    dragon.m_20011_(dragon.m_20191_());
                    dragon.m_6210_();
                    ((DimensionsRefresher)player).identity_refreshDimensions();
                }
            });
        });
        return true;
    }
}

