/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.model;

import com.github.L_Ender.cataclysm.init.ModEntities;
import com.kurome.ageofmythology.config.AOMUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EntityType;

public class CapabilityExtraInfo {
    public static Supplier<List<EntityType<?>>> killList = () -> Arrays.asList((EntityType)ModEntities.ENDER_GUARDIAN.get(), (EntityType)ModEntities.IGNIS.get(), (EntityType)ModEntities.NETHERITE_MONSTROSITY.get(), (EntityType)ModEntities.THE_HARBINGER.get(), (EntityType)ModEntities.THE_LEVIATHAN.get(), (EntityType)ModEntities.ANCIENT_REMNANT.get(), (EntityType)ModEntities.MALEDICTUS.get(), (EntityType)ModEntities.SCYLLA.get());
    public List<String> the_power_kill_map = new ArrayList<String>();
    public static final String nbt_the_power_kill_map = "nbt_the_power_kill_map";
    public int boss_fight_type = 0;
    public static final String nbt_boss_fight_type = "nbt_boss_fight_type";
    public int apostle_type = 0;
    public static final String nbt_apostle_type = "nbt_apostle_type";
    public int color_phase = 0;
    public static final String nbt_color_phase = "nbt_color_phase";
    public int pride_sin_lord_boss_fight = 0;
    public static final String nbt_pride_sin_lord_boss_fight = "nbt_pride_sin_lord_boss_fight";

    public void serializeNBT(CompoundTag compound) {
        ListTag listTag = new ListTag();
        this.the_power_kill_map.forEach(kill_mob -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("kill_mob", kill_mob);
            listTag.add((Object)tag);
        });
        compound.m_128365_(nbt_the_power_kill_map, (Tag)listTag);
        compound.m_128405_(nbt_boss_fight_type, this.boss_fight_type);
        compound.m_128405_(nbt_apostle_type, this.apostle_type);
        compound.m_128405_(nbt_color_phase, this.color_phase);
        compound.m_128405_(nbt_pride_sin_lord_boss_fight, this.pride_sin_lord_boss_fight);
    }

    public void deserializeNBT(CompoundTag compound) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ListTag listTag = (ListTag)compound.m_128423_(nbt_the_power_kill_map);
        if (listTag != null) {
            listTag.forEach(tag -> {
                String kill_mob = ((CompoundTag)tag).m_128461_("kill_mob");
                arrayList.add(kill_mob);
            });
        }
        this.the_power_kill_map = arrayList;
        this.boss_fight_type = compound.m_128451_(nbt_boss_fight_type);
        this.apostle_type = compound.m_128451_(nbt_apostle_type);
        this.color_phase = compound.m_128451_(nbt_color_phase);
        this.pride_sin_lord_boss_fight = compound.m_128451_(nbt_pride_sin_lord_boss_fight);
    }

    public void updateApostleType(int type) {
        this.apostle_type = type;
    }

    public void setColorPhase(int i) {
        this.color_phase = i;
    }

    public void updateKilMob(String mob) {
        if (!this.the_power_kill_map.contains(mob)) {
            this.the_power_kill_map.add(mob);
        }
    }

    public void setBoss_fight_type(int type) {
        this.boss_fight_type = type;
    }

    public void set_pride_sin_lord_boss_fight(int type) {
        this.pride_sin_lord_boss_fight = type;
    }

    public boolean checkMobAllKilled() {
        AtomicBoolean result = new AtomicBoolean(true);
        killList.get().forEach(target -> {
            if (!this.the_power_kill_map.contains(AOMUtil.getMobName(target))) {
                result.set(false);
            }
        });
        return result.get();
    }

    public static enum BossFightType {
        Apollon(1),
        None(0);

        private final int type;

        private BossFightType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }
}

