/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.model;

import com.kurome.ageofmythology.bettermorph.impl.general.TimeExecutor;
import com.kurome.ageofmythology.model.AbilitySupplier;
import com.kurome.ageofmythology.model.MorphData;
import com.kurome.ageofmythology.model.QuadConsumer;
import com.kurome.ageofmythology.model.TriConsumer;
import io.redspace.ironsspellbooks.api.spells.CastType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class Ability {
    public AbilityType type = AbilityType.DEFAULT;
    public static int LONG_TYPE_DEFAULT_DELAY = 20;
    public static TriConsumer<Level, LivingEntity, Player> empty = (l, e, p) -> {};
    public MorphData abilityData = null;
    public TriConsumer<Level, LivingEntity, Player> abilityConsumer;
    public QuadConsumer<Level, LivingEntity, Player, TimeExecutor> abilityConsumerQuad;
    public TriConsumer<Level, LivingEntity, Player> animationConsumer;
    public TriConsumer<Level, LivingEntity, Player> animationFinishCallbackConsumer;
    public int delay;
    public int animationDelay;
    public int callBackDelay;
    public int duration;
    public int triggerTick;
    public int cooldown;
    public int weight;
    public AbilitySupplier<Boolean, Player> abilitySupplier;

    public Ability() {
        this.abilityConsumer = (l, e, p) -> {};
        this.abilityConsumerQuad = (l, e, p, t) -> {};
        this.animationConsumer = (l, e, p) -> {};
        this.animationFinishCallbackConsumer = (l, e, p) -> {};
        this.delay = 0;
        this.animationDelay = 0;
        this.callBackDelay = 0;
        this.duration = 0;
        this.triggerTick = 1;
        this.cooldown = 20;
        this.weight = 1;
        this.abilitySupplier = player -> true;
    }

    public Ability(MorphData abilityData, TriConsumer<Level, LivingEntity, Player> abilityConsumer) {
        this(abilityData, abilityConsumer, 0, empty, 0);
    }

    public Ability(MorphData abilityData, TriConsumer<Level, LivingEntity, Player> abilityConsumer, int delay, TriConsumer<Level, LivingEntity, Player> animationConsumer, int animationDelay) {
        this(abilityData, abilityConsumer, delay, animationConsumer, animationDelay, empty, 0);
    }

    public Ability(MorphData abilityData, TriConsumer<Level, LivingEntity, Player> abilityConsumer, int delay, TriConsumer<Level, LivingEntity, Player> animationConsumer, int animationDelay, TriConsumer<Level, LivingEntity, Player> animationFinishCallbackConsumer, int callBackDelay) {
        this(abilityData, abilityConsumer, delay, animationConsumer, animationDelay, animationFinishCallbackConsumer, callBackDelay, 0, 1);
    }

    public Ability(MorphData abilityData, TriConsumer<Level, LivingEntity, Player> abilityConsumer, int delay, TriConsumer<Level, LivingEntity, Player> animationConsumer, int animationDelay, TriConsumer<Level, LivingEntity, Player> animationFinishCallbackConsumer, int callBackDelay, int duration, int triggerTick) {
        this.abilityConsumer = (l, e, p) -> {};
        this.abilityConsumerQuad = (l, e, p, t) -> {};
        this.animationConsumer = (l, e, p) -> {};
        this.animationFinishCallbackConsumer = (l, e, p) -> {};
        this.delay = 0;
        this.animationDelay = 0;
        this.callBackDelay = 0;
        this.duration = 0;
        this.triggerTick = 1;
        this.cooldown = 20;
        this.weight = 1;
        this.abilitySupplier = player -> true;
        this.abilityData = abilityData;
        this.abilityConsumer = abilityConsumer;
        this.animationConsumer = animationConsumer;
        this.delay = delay;
        this.animationDelay = animationDelay;
        this.animationFinishCallbackConsumer = animationFinishCallbackConsumer;
        this.callBackDelay = callBackDelay;
        this.duration = duration;
        this.triggerTick = triggerTick;
        this.updateDelay();
    }

    public Ability(MorphData abilityData, QuadConsumer<Level, LivingEntity, Player, TimeExecutor> abilityConsumer) {
        this(abilityData, abilityConsumer, 0, empty, 0);
    }

    public Ability(MorphData abilityData, QuadConsumer<Level, LivingEntity, Player, TimeExecutor> abilityConsumer, int delay, TriConsumer<Level, LivingEntity, Player> animationConsumer, int animationDelay) {
        this(abilityData, abilityConsumer, delay, animationConsumer, animationDelay, empty, 0);
    }

    public Ability(MorphData abilityData, QuadConsumer<Level, LivingEntity, Player, TimeExecutor> abilityConsumer, int delay, TriConsumer<Level, LivingEntity, Player> animationConsumer, int animationDelay, TriConsumer<Level, LivingEntity, Player> animationFinishCallbackConsumer, int callBackDelay) {
        this(abilityData, abilityConsumer, delay, animationConsumer, animationDelay, animationFinishCallbackConsumer, callBackDelay, 0, 1);
    }

    public Ability(MorphData abilityData, QuadConsumer<Level, LivingEntity, Player, TimeExecutor> abilityConsumerQuad, int delay, TriConsumer<Level, LivingEntity, Player> animationConsumer, int animationDelay, TriConsumer<Level, LivingEntity, Player> animationFinishCallbackConsumer, int callBackDelay, int duration, int triggerTick) {
        this.abilityConsumer = (l, e, p) -> {};
        this.abilityConsumerQuad = (l, e, p, t) -> {};
        this.animationConsumer = (l, e, p) -> {};
        this.animationFinishCallbackConsumer = (l, e, p) -> {};
        this.delay = 0;
        this.animationDelay = 0;
        this.callBackDelay = 0;
        this.duration = 0;
        this.triggerTick = 1;
        this.cooldown = 20;
        this.weight = 1;
        this.abilitySupplier = player -> true;
        this.abilityData = abilityData;
        this.abilityConsumerQuad = abilityConsumerQuad;
        this.animationConsumer = animationConsumer;
        this.delay = delay;
        this.animationDelay = animationDelay;
        this.animationFinishCallbackConsumer = animationFinishCallbackConsumer;
        this.callBackDelay = callBackDelay;
        this.duration = duration;
        this.triggerTick = triggerTick;
        this.updateDelay();
    }

    public Ability(QuadConsumer<Level, LivingEntity, Player, TimeExecutor> abilityConsumerQuad) {
        this(abilityConsumerQuad, 0, empty, 0, empty, 0, 0, 1);
    }

    public Ability(QuadConsumer<Level, LivingEntity, Player, TimeExecutor> abilityConsumerQuad, int delay, TriConsumer<Level, LivingEntity, Player> animationConsumer, int animationDelay, TriConsumer<Level, LivingEntity, Player> animationFinishCallbackConsumer, int callBackDelay, int duration, int triggerTick) {
        this.abilityConsumer = (l, e, p) -> {};
        this.abilityConsumerQuad = (l, e, p, t) -> {};
        this.animationConsumer = (l, e, p) -> {};
        this.animationFinishCallbackConsumer = (l, e, p) -> {};
        this.delay = 0;
        this.animationDelay = 0;
        this.callBackDelay = 0;
        this.duration = 0;
        this.triggerTick = 1;
        this.cooldown = 20;
        this.weight = 1;
        this.abilitySupplier = player -> true;
        this.abilityConsumerQuad = abilityConsumerQuad;
        this.animationConsumer = animationConsumer;
        this.delay = delay;
        this.animationDelay = animationDelay;
        this.animationFinishCallbackConsumer = animationFinishCallbackConsumer;
        this.callBackDelay = callBackDelay;
        this.duration = duration;
        this.triggerTick = triggerTick;
    }

    private void updateDelay() {
        if (this.abilityData != null && this.abilityData.spell != null && this.abilityData.spell.getCastType() == CastType.LONG) {
            if (this.delay == 0) {
                this.delay = LONG_TYPE_DEFAULT_DELAY;
            }
            if (this.callBackDelay == 0) {
                this.callBackDelay = LONG_TYPE_DEFAULT_DELAY;
            }
        }
    }

    public Ability setDelay(int delay) {
        this.delay = delay;
        return this;
    }

    public Ability setAnimationDelay(int animationDelay) {
        this.animationDelay = animationDelay;
        return this;
    }

    public Ability setCallBackDelay(int callBackDelay) {
        this.callBackDelay = callBackDelay;
        return this;
    }

    public Ability setDuration(int duration) {
        this.duration = duration;
        return this;
    }

    public Ability setTriggerTick(int triggerTick) {
        this.triggerTick = triggerTick;
        return this;
    }

    public Ability setNotSpellingMob() {
        this.delay = 0;
        this.animationDelay = 0;
        this.callBackDelay = 0;
        return this;
    }

    public Ability setCooldown(int cooldown) {
        this.cooldown = cooldown;
        return this;
    }

    public int getAbilityCooldown() {
        return Math.max(this.cooldown, Math.max(this.delay + this.duration, this.callBackDelay));
    }

    public Ability setAbilitySupplier(AbilitySupplier<Boolean, Player> abilitySupplier) {
        this.abilitySupplier = abilitySupplier;
        return this;
    }

    public Ability setType(AbilityType abilityType) {
        this.type = abilityType;
        return this;
    }

    public Ability setAnimationFinishCallbackConsumer(TriConsumer<Level, LivingEntity, Player> animationFinishCallbackConsumer) {
        this.animationFinishCallbackConsumer = animationFinishCallbackConsumer;
        return this;
    }

    public Ability setWeight(int weight) {
        this.weight = weight;
        return this;
    }

    public int getWeight() {
        return this.weight;
    }

    public static enum AbilityType {
        EXPLODE,
        ABYSS,
        MACHINE,
        GOETY,
        DRAGON,
        DEFAULT;

    }
}

